<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$products_list = new products_list();

// Run the page
$products_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$products_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$products_list->isExport()) { ?>
<script>
var fproductslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fproductslist = currentForm = new ew.Form("fproductslist", "list");
	fproductslist.formKeyCountName = '<?php echo $products_list->FormKeyCountName ?>';
	loadjs.done("fproductslist");
});
var fproductslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fproductslistsrch = currentSearchForm = new ew.Form("fproductslistsrch");

	// Dynamic selection lists
	// Filters

	fproductslistsrch.filterList = <?php echo $products_list->getFilterList() ?>;
	loadjs.done("fproductslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$products_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($products_list->TotalRecords > 0 && $products_list->ExportOptions->visible()) { ?>
<?php $products_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($products_list->ImportOptions->visible()) { ?>
<?php $products_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($products_list->SearchOptions->visible()) { ?>
<?php $products_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($products_list->FilterOptions->visible()) { ?>
<?php $products_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$products_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$products_list->isExport() && !$products->CurrentAction) { ?>
<form name="fproductslistsrch" id="fproductslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fproductslistsrch-search-panel" class="<?php echo $products_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="products">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $products_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($products_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($products_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $products_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($products_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($products_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($products_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($products_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $products_list->showPageHeader(); ?>
<?php
$products_list->showMessage();
?>
<?php if ($products_list->TotalRecords > 0 || $products->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($products_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> products">
<form name="fproductslist" id="fproductslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="products">
<div id="gmp_products" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($products_list->TotalRecords > 0 || $products_list->isGridEdit()) { ?>
<table id="tbl_productslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$products->RowType = ROWTYPE_HEADER;

// Render list options
$products_list->renderListOptions();

// Render list options (header, left)
$products_list->ListOptions->render("header", "left");
?>
<?php if ($products_list->id_producto->Visible) { // id_producto ?>
	<?php if ($products_list->SortUrl($products_list->id_producto) == "") { ?>
		<th data-name="id_producto" class="<?php echo $products_list->id_producto->headerCellClass() ?>"><div id="elh_products_id_producto" class="products_id_producto"><div class="ew-table-header-caption"><?php echo $products_list->id_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_producto" class="<?php echo $products_list->id_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->id_producto) ?>', 1);"><div id="elh_products_id_producto" class="products_id_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->id_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->id_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->id_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->codigo_producto->Visible) { // codigo_producto ?>
	<?php if ($products_list->SortUrl($products_list->codigo_producto) == "") { ?>
		<th data-name="codigo_producto" class="<?php echo $products_list->codigo_producto->headerCellClass() ?>"><div id="elh_products_codigo_producto" class="products_codigo_producto"><div class="ew-table-header-caption"><?php echo $products_list->codigo_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo_producto" class="<?php echo $products_list->codigo_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->codigo_producto) ?>', 1);"><div id="elh_products_codigo_producto" class="products_codigo_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->codigo_producto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->codigo_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->codigo_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->estado->Visible) { // estado ?>
	<?php if ($products_list->SortUrl($products_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $products_list->estado->headerCellClass() ?>"><div id="elh_products_estado" class="products_estado"><div class="ew-table-header-caption"><?php echo $products_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $products_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->estado) ?>', 1);"><div id="elh_products_estado" class="products_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->status_producto->Visible) { // status_producto ?>
	<?php if ($products_list->SortUrl($products_list->status_producto) == "") { ?>
		<th data-name="status_producto" class="<?php echo $products_list->status_producto->headerCellClass() ?>"><div id="elh_products_status_producto" class="products_status_producto"><div class="ew-table-header-caption"><?php echo $products_list->status_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_producto" class="<?php echo $products_list->status_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->status_producto) ?>', 1);"><div id="elh_products_status_producto" class="products_status_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->status_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->status_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->status_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->date_added->Visible) { // date_added ?>
	<?php if ($products_list->SortUrl($products_list->date_added) == "") { ?>
		<th data-name="date_added" class="<?php echo $products_list->date_added->headerCellClass() ?>"><div id="elh_products_date_added" class="products_date_added"><div class="ew-table-header-caption"><?php echo $products_list->date_added->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_added" class="<?php echo $products_list->date_added->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->date_added) ?>', 1);"><div id="elh_products_date_added" class="products_date_added">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->date_added->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->date_added->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->date_added->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->precio_producto->Visible) { // precio_producto ?>
	<?php if ($products_list->SortUrl($products_list->precio_producto) == "") { ?>
		<th data-name="precio_producto" class="<?php echo $products_list->precio_producto->headerCellClass() ?>"><div id="elh_products_precio_producto" class="products_precio_producto"><div class="ew-table-header-caption"><?php echo $products_list->precio_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio_producto" class="<?php echo $products_list->precio_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->precio_producto) ?>', 1);"><div id="elh_products_precio_producto" class="products_precio_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->precio_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->precio_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->precio_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->costo_producto->Visible) { // costo_producto ?>
	<?php if ($products_list->SortUrl($products_list->costo_producto) == "") { ?>
		<th data-name="costo_producto" class="<?php echo $products_list->costo_producto->headerCellClass() ?>"><div id="elh_products_costo_producto" class="products_costo_producto"><div class="ew-table-header-caption"><?php echo $products_list->costo_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="costo_producto" class="<?php echo $products_list->costo_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->costo_producto) ?>', 1);"><div id="elh_products_costo_producto" class="products_costo_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->costo_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->costo_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->costo_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->mon_costo->Visible) { // mon_costo ?>
	<?php if ($products_list->SortUrl($products_list->mon_costo) == "") { ?>
		<th data-name="mon_costo" class="<?php echo $products_list->mon_costo->headerCellClass() ?>"><div id="elh_products_mon_costo" class="products_mon_costo"><div class="ew-table-header-caption"><?php echo $products_list->mon_costo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mon_costo" class="<?php echo $products_list->mon_costo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->mon_costo) ?>', 1);"><div id="elh_products_mon_costo" class="products_mon_costo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->mon_costo->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->mon_costo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->mon_costo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->mon_venta->Visible) { // mon_venta ?>
	<?php if ($products_list->SortUrl($products_list->mon_venta) == "") { ?>
		<th data-name="mon_venta" class="<?php echo $products_list->mon_venta->headerCellClass() ?>"><div id="elh_products_mon_venta" class="products_mon_venta"><div class="ew-table-header-caption"><?php echo $products_list->mon_venta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mon_venta" class="<?php echo $products_list->mon_venta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->mon_venta) ?>', 1);"><div id="elh_products_mon_venta" class="products_mon_venta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->mon_venta->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->mon_venta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->mon_venta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->pais->Visible) { // pais ?>
	<?php if ($products_list->SortUrl($products_list->pais) == "") { ?>
		<th data-name="pais" class="<?php echo $products_list->pais->headerCellClass() ?>"><div id="elh_products_pais" class="products_pais"><div class="ew-table-header-caption"><?php echo $products_list->pais->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pais" class="<?php echo $products_list->pais->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->pais) ?>', 1);"><div id="elh_products_pais" class="products_pais">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->pais->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->pais->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->pais->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->departamento->Visible) { // departamento ?>
	<?php if ($products_list->SortUrl($products_list->departamento) == "") { ?>
		<th data-name="departamento" class="<?php echo $products_list->departamento->headerCellClass() ?>"><div id="elh_products_departamento" class="products_departamento"><div class="ew-table-header-caption"><?php echo $products_list->departamento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="departamento" class="<?php echo $products_list->departamento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->departamento) ?>', 1);"><div id="elh_products_departamento" class="products_departamento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->departamento->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->departamento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->departamento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->distrito->Visible) { // distrito ?>
	<?php if ($products_list->SortUrl($products_list->distrito) == "") { ?>
		<th data-name="distrito" class="<?php echo $products_list->distrito->headerCellClass() ?>"><div id="elh_products_distrito" class="products_distrito"><div class="ew-table-header-caption"><?php echo $products_list->distrito->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="distrito" class="<?php echo $products_list->distrito->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->distrito) ?>', 1);"><div id="elh_products_distrito" class="products_distrito">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->distrito->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->distrito->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->distrito->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->localidad->Visible) { // localidad ?>
	<?php if ($products_list->SortUrl($products_list->localidad) == "") { ?>
		<th data-name="localidad" class="<?php echo $products_list->localidad->headerCellClass() ?>"><div id="elh_products_localidad" class="products_localidad"><div class="ew-table-header-caption"><?php echo $products_list->localidad->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="localidad" class="<?php echo $products_list->localidad->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->localidad) ?>', 1);"><div id="elh_products_localidad" class="products_localidad">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->localidad->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->localidad->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->localidad->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->zona->Visible) { // zona ?>
	<?php if ($products_list->SortUrl($products_list->zona) == "") { ?>
		<th data-name="zona" class="<?php echo $products_list->zona->headerCellClass() ?>"><div id="elh_products_zona" class="products_zona"><div class="ew-table-header-caption"><?php echo $products_list->zona->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="zona" class="<?php echo $products_list->zona->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->zona) ?>', 1);"><div id="elh_products_zona" class="products_zona">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->zona->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->zona->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->zona->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->tipo_inmueble->Visible) { // tipo_inmueble ?>
	<?php if ($products_list->SortUrl($products_list->tipo_inmueble) == "") { ?>
		<th data-name="tipo_inmueble" class="<?php echo $products_list->tipo_inmueble->headerCellClass() ?>"><div id="elh_products_tipo_inmueble" class="products_tipo_inmueble"><div class="ew-table-header-caption"><?php echo $products_list->tipo_inmueble->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_inmueble" class="<?php echo $products_list->tipo_inmueble->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->tipo_inmueble) ?>', 1);"><div id="elh_products_tipo_inmueble" class="products_tipo_inmueble">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->tipo_inmueble->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->tipo_inmueble->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->tipo_inmueble->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->tipo_negocio->Visible) { // tipo_negocio ?>
	<?php if ($products_list->SortUrl($products_list->tipo_negocio) == "") { ?>
		<th data-name="tipo_negocio" class="<?php echo $products_list->tipo_negocio->headerCellClass() ?>"><div id="elh_products_tipo_negocio" class="products_tipo_negocio"><div class="ew-table-header-caption"><?php echo $products_list->tipo_negocio->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_negocio" class="<?php echo $products_list->tipo_negocio->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->tipo_negocio) ?>', 1);"><div id="elh_products_tipo_negocio" class="products_tipo_negocio">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->tipo_negocio->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->tipo_negocio->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->tipo_negocio->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->tiempo_alquiler->Visible) { // tiempo_alquiler ?>
	<?php if ($products_list->SortUrl($products_list->tiempo_alquiler) == "") { ?>
		<th data-name="tiempo_alquiler" class="<?php echo $products_list->tiempo_alquiler->headerCellClass() ?>"><div id="elh_products_tiempo_alquiler" class="products_tiempo_alquiler"><div class="ew-table-header-caption"><?php echo $products_list->tiempo_alquiler->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tiempo_alquiler" class="<?php echo $products_list->tiempo_alquiler->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->tiempo_alquiler) ?>', 1);"><div id="elh_products_tiempo_alquiler" class="products_tiempo_alquiler">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->tiempo_alquiler->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->tiempo_alquiler->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->tiempo_alquiler->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->moneda->Visible) { // moneda ?>
	<?php if ($products_list->SortUrl($products_list->moneda) == "") { ?>
		<th data-name="moneda" class="<?php echo $products_list->moneda->headerCellClass() ?>"><div id="elh_products_moneda" class="products_moneda"><div class="ew-table-header-caption"><?php echo $products_list->moneda->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="moneda" class="<?php echo $products_list->moneda->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->moneda) ?>', 1);"><div id="elh_products_moneda" class="products_moneda">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->moneda->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->moneda->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->moneda->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->estado_inmueble->Visible) { // estado_inmueble ?>
	<?php if ($products_list->SortUrl($products_list->estado_inmueble) == "") { ?>
		<th data-name="estado_inmueble" class="<?php echo $products_list->estado_inmueble->headerCellClass() ?>"><div id="elh_products_estado_inmueble" class="products_estado_inmueble"><div class="ew-table-header-caption"><?php echo $products_list->estado_inmueble->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado_inmueble" class="<?php echo $products_list->estado_inmueble->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->estado_inmueble) ?>', 1);"><div id="elh_products_estado_inmueble" class="products_estado_inmueble">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->estado_inmueble->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->estado_inmueble->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->estado_inmueble->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->area_construida->Visible) { // area_construida ?>
	<?php if ($products_list->SortUrl($products_list->area_construida) == "") { ?>
		<th data-name="area_construida" class="<?php echo $products_list->area_construida->headerCellClass() ?>"><div id="elh_products_area_construida" class="products_area_construida"><div class="ew-table-header-caption"><?php echo $products_list->area_construida->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="area_construida" class="<?php echo $products_list->area_construida->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->area_construida) ?>', 1);"><div id="elh_products_area_construida" class="products_area_construida">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->area_construida->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->area_construida->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->area_construida->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->area_privada->Visible) { // area_privada ?>
	<?php if ($products_list->SortUrl($products_list->area_privada) == "") { ?>
		<th data-name="area_privada" class="<?php echo $products_list->area_privada->headerCellClass() ?>"><div id="elh_products_area_privada" class="products_area_privada"><div class="ew-table-header-caption"><?php echo $products_list->area_privada->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="area_privada" class="<?php echo $products_list->area_privada->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->area_privada) ?>', 1);"><div id="elh_products_area_privada" class="products_area_privada">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->area_privada->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->area_privada->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->area_privada->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->area_terreno->Visible) { // area_terreno ?>
	<?php if ($products_list->SortUrl($products_list->area_terreno) == "") { ?>
		<th data-name="area_terreno" class="<?php echo $products_list->area_terreno->headerCellClass() ?>"><div id="elh_products_area_terreno" class="products_area_terreno"><div class="ew-table-header-caption"><?php echo $products_list->area_terreno->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="area_terreno" class="<?php echo $products_list->area_terreno->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->area_terreno) ?>', 1);"><div id="elh_products_area_terreno" class="products_area_terreno">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->area_terreno->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->area_terreno->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->area_terreno->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->valor_administracion->Visible) { // valor_administracion ?>
	<?php if ($products_list->SortUrl($products_list->valor_administracion) == "") { ?>
		<th data-name="valor_administracion" class="<?php echo $products_list->valor_administracion->headerCellClass() ?>"><div id="elh_products_valor_administracion" class="products_valor_administracion"><div class="ew-table-header-caption"><?php echo $products_list->valor_administracion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="valor_administracion" class="<?php echo $products_list->valor_administracion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->valor_administracion) ?>', 1);"><div id="elh_products_valor_administracion" class="products_valor_administracion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->valor_administracion->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->valor_administracion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->valor_administracion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->dormitorios->Visible) { // dormitorios ?>
	<?php if ($products_list->SortUrl($products_list->dormitorios) == "") { ?>
		<th data-name="dormitorios" class="<?php echo $products_list->dormitorios->headerCellClass() ?>"><div id="elh_products_dormitorios" class="products_dormitorios"><div class="ew-table-header-caption"><?php echo $products_list->dormitorios->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dormitorios" class="<?php echo $products_list->dormitorios->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->dormitorios) ?>', 1);"><div id="elh_products_dormitorios" class="products_dormitorios">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->dormitorios->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->dormitorios->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->dormitorios->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->banios->Visible) { // banios ?>
	<?php if ($products_list->SortUrl($products_list->banios) == "") { ?>
		<th data-name="banios" class="<?php echo $products_list->banios->headerCellClass() ?>"><div id="elh_products_banios" class="products_banios"><div class="ew-table-header-caption"><?php echo $products_list->banios->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="banios" class="<?php echo $products_list->banios->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->banios) ?>', 1);"><div id="elh_products_banios" class="products_banios">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->banios->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->banios->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->banios->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->garaje->Visible) { // garaje ?>
	<?php if ($products_list->SortUrl($products_list->garaje) == "") { ?>
		<th data-name="garaje" class="<?php echo $products_list->garaje->headerCellClass() ?>"><div id="elh_products_garaje" class="products_garaje"><div class="ew-table-header-caption"><?php echo $products_list->garaje->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="garaje" class="<?php echo $products_list->garaje->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->garaje) ?>', 1);"><div id="elh_products_garaje" class="products_garaje">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->garaje->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->garaje->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->garaje->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->piso->Visible) { // piso ?>
	<?php if ($products_list->SortUrl($products_list->piso) == "") { ?>
		<th data-name="piso" class="<?php echo $products_list->piso->headerCellClass() ?>"><div id="elh_products_piso" class="products_piso"><div class="ew-table-header-caption"><?php echo $products_list->piso->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="piso" class="<?php echo $products_list->piso->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->piso) ?>', 1);"><div id="elh_products_piso" class="products_piso">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->piso->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->piso->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->piso->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->estrato->Visible) { // estrato ?>
	<?php if ($products_list->SortUrl($products_list->estrato) == "") { ?>
		<th data-name="estrato" class="<?php echo $products_list->estrato->headerCellClass() ?>"><div id="elh_products_estrato" class="products_estrato"><div class="ew-table-header-caption"><?php echo $products_list->estrato->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estrato" class="<?php echo $products_list->estrato->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->estrato) ?>', 1);"><div id="elh_products_estrato" class="products_estrato">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->estrato->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->estrato->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->estrato->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->codigo_postal->Visible) { // codigo_postal ?>
	<?php if ($products_list->SortUrl($products_list->codigo_postal) == "") { ?>
		<th data-name="codigo_postal" class="<?php echo $products_list->codigo_postal->headerCellClass() ?>"><div id="elh_products_codigo_postal" class="products_codigo_postal"><div class="ew-table-header-caption"><?php echo $products_list->codigo_postal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo_postal" class="<?php echo $products_list->codigo_postal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->codigo_postal) ?>', 1);"><div id="elh_products_codigo_postal" class="products_codigo_postal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->codigo_postal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->codigo_postal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->codigo_postal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->mapa->Visible) { // mapa ?>
	<?php if ($products_list->SortUrl($products_list->mapa) == "") { ?>
		<th data-name="mapa" class="<?php echo $products_list->mapa->headerCellClass() ?>"><div id="elh_products_mapa" class="products_mapa"><div class="ew-table-header-caption"><?php echo $products_list->mapa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mapa" class="<?php echo $products_list->mapa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->mapa) ?>', 1);"><div id="elh_products_mapa" class="products_mapa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->mapa->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->mapa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->mapa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->latitud->Visible) { // latitud ?>
	<?php if ($products_list->SortUrl($products_list->latitud) == "") { ?>
		<th data-name="latitud" class="<?php echo $products_list->latitud->headerCellClass() ?>"><div id="elh_products_latitud" class="products_latitud"><div class="ew-table-header-caption"><?php echo $products_list->latitud->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="latitud" class="<?php echo $products_list->latitud->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->latitud) ?>', 1);"><div id="elh_products_latitud" class="products_latitud">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->latitud->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->latitud->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->latitud->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->longitud->Visible) { // longitud ?>
	<?php if ($products_list->SortUrl($products_list->longitud) == "") { ?>
		<th data-name="longitud" class="<?php echo $products_list->longitud->headerCellClass() ?>"><div id="elh_products_longitud" class="products_longitud"><div class="ew-table-header-caption"><?php echo $products_list->longitud->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="longitud" class="<?php echo $products_list->longitud->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->longitud) ?>', 1);"><div id="elh_products_longitud" class="products_longitud">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->longitud->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->longitud->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->longitud->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->opciones_mapa->Visible) { // opciones_mapa ?>
	<?php if ($products_list->SortUrl($products_list->opciones_mapa) == "") { ?>
		<th data-name="opciones_mapa" class="<?php echo $products_list->opciones_mapa->headerCellClass() ?>"><div id="elh_products_opciones_mapa" class="products_opciones_mapa"><div class="ew-table-header-caption"><?php echo $products_list->opciones_mapa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="opciones_mapa" class="<?php echo $products_list->opciones_mapa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->opciones_mapa) ?>', 1);"><div id="elh_products_opciones_mapa" class="products_opciones_mapa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->opciones_mapa->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->opciones_mapa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->opciones_mapa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->red->Visible) { // red ?>
	<?php if ($products_list->SortUrl($products_list->red) == "") { ?>
		<th data-name="red" class="<?php echo $products_list->red->headerCellClass() ?>"><div id="elh_products_red" class="products_red"><div class="ew-table-header-caption"><?php echo $products_list->red->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="red" class="<?php echo $products_list->red->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->red) ?>', 1);"><div id="elh_products_red" class="products_red">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->red->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->red->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->red->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->disponibilidad->Visible) { // disponibilidad ?>
	<?php if ($products_list->SortUrl($products_list->disponibilidad) == "") { ?>
		<th data-name="disponibilidad" class="<?php echo $products_list->disponibilidad->headerCellClass() ?>"><div id="elh_products_disponibilidad" class="products_disponibilidad"><div class="ew-table-header-caption"><?php echo $products_list->disponibilidad->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="disponibilidad" class="<?php echo $products_list->disponibilidad->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->disponibilidad) ?>', 1);"><div id="elh_products_disponibilidad" class="products_disponibilidad">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->disponibilidad->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->disponibilidad->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->disponibilidad->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->anio_construccion->Visible) { // anio_construccion ?>
	<?php if ($products_list->SortUrl($products_list->anio_construccion) == "") { ?>
		<th data-name="anio_construccion" class="<?php echo $products_list->anio_construccion->headerCellClass() ?>"><div id="elh_products_anio_construccion" class="products_anio_construccion"><div class="ew-table-header-caption"><?php echo $products_list->anio_construccion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="anio_construccion" class="<?php echo $products_list->anio_construccion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->anio_construccion) ?>', 1);"><div id="elh_products_anio_construccion" class="products_anio_construccion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->anio_construccion->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->anio_construccion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->anio_construccion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->encargado->Visible) { // encargado ?>
	<?php if ($products_list->SortUrl($products_list->encargado) == "") { ?>
		<th data-name="encargado" class="<?php echo $products_list->encargado->headerCellClass() ?>"><div id="elh_products_encargado" class="products_encargado"><div class="ew-table-header-caption"><?php echo $products_list->encargado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="encargado" class="<?php echo $products_list->encargado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->encargado) ?>', 1);"><div id="elh_products_encargado" class="products_encargado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->encargado->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->encargado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->encargado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->visitas->Visible) { // visitas ?>
	<?php if ($products_list->SortUrl($products_list->visitas) == "") { ?>
		<th data-name="visitas" class="<?php echo $products_list->visitas->headerCellClass() ?>"><div id="elh_products_visitas" class="products_visitas"><div class="ew-table-header-caption"><?php echo $products_list->visitas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="visitas" class="<?php echo $products_list->visitas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->visitas) ?>', 1);"><div id="elh_products_visitas" class="products_visitas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->visitas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->visitas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->visitas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->valor_comision->Visible) { // valor_comision ?>
	<?php if ($products_list->SortUrl($products_list->valor_comision) == "") { ?>
		<th data-name="valor_comision" class="<?php echo $products_list->valor_comision->headerCellClass() ?>"><div id="elh_products_valor_comision" class="products_valor_comision"><div class="ew-table-header-caption"><?php echo $products_list->valor_comision->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="valor_comision" class="<?php echo $products_list->valor_comision->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->valor_comision) ?>', 1);"><div id="elh_products_valor_comision" class="products_valor_comision">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->valor_comision->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->valor_comision->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->valor_comision->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->tipo_comision->Visible) { // tipo_comision ?>
	<?php if ($products_list->SortUrl($products_list->tipo_comision) == "") { ?>
		<th data-name="tipo_comision" class="<?php echo $products_list->tipo_comision->headerCellClass() ?>"><div id="elh_products_tipo_comision" class="products_tipo_comision"><div class="ew-table-header-caption"><?php echo $products_list->tipo_comision->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_comision" class="<?php echo $products_list->tipo_comision->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->tipo_comision) ?>', 1);"><div id="elh_products_tipo_comision" class="products_tipo_comision">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->tipo_comision->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->tipo_comision->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->tipo_comision->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->certificado->Visible) { // certificado ?>
	<?php if ($products_list->SortUrl($products_list->certificado) == "") { ?>
		<th data-name="certificado" class="<?php echo $products_list->certificado->headerCellClass() ?>"><div id="elh_products_certificado" class="products_certificado"><div class="ew-table-header-caption"><?php echo $products_list->certificado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="certificado" class="<?php echo $products_list->certificado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->certificado) ?>', 1);"><div id="elh_products_certificado" class="products_certificado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->certificado->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->certificado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->certificado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->nombre_propietario->Visible) { // nombre_propietario ?>
	<?php if ($products_list->SortUrl($products_list->nombre_propietario) == "") { ?>
		<th data-name="nombre_propietario" class="<?php echo $products_list->nombre_propietario->headerCellClass() ?>"><div id="elh_products_nombre_propietario" class="products_nombre_propietario"><div class="ew-table-header-caption"><?php echo $products_list->nombre_propietario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre_propietario" class="<?php echo $products_list->nombre_propietario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->nombre_propietario) ?>', 1);"><div id="elh_products_nombre_propietario" class="products_nombre_propietario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->nombre_propietario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->nombre_propietario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->nombre_propietario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->movil_propietario->Visible) { // movil_propietario ?>
	<?php if ($products_list->SortUrl($products_list->movil_propietario) == "") { ?>
		<th data-name="movil_propietario" class="<?php echo $products_list->movil_propietario->headerCellClass() ?>"><div id="elh_products_movil_propietario" class="products_movil_propietario"><div class="ew-table-header-caption"><?php echo $products_list->movil_propietario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="movil_propietario" class="<?php echo $products_list->movil_propietario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->movil_propietario) ?>', 1);"><div id="elh_products_movil_propietario" class="products_movil_propietario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->movil_propietario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->movil_propietario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->movil_propietario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->telefono_propietario->Visible) { // telefono_propietario ?>
	<?php if ($products_list->SortUrl($products_list->telefono_propietario) == "") { ?>
		<th data-name="telefono_propietario" class="<?php echo $products_list->telefono_propietario->headerCellClass() ?>"><div id="elh_products_telefono_propietario" class="products_telefono_propietario"><div class="ew-table-header-caption"><?php echo $products_list->telefono_propietario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="telefono_propietario" class="<?php echo $products_list->telefono_propietario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->telefono_propietario) ?>', 1);"><div id="elh_products_telefono_propietario" class="products_telefono_propietario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->telefono_propietario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->telefono_propietario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->telefono_propietario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->correo_propietario->Visible) { // correo_propietario ?>
	<?php if ($products_list->SortUrl($products_list->correo_propietario) == "") { ?>
		<th data-name="correo_propietario" class="<?php echo $products_list->correo_propietario->headerCellClass() ?>"><div id="elh_products_correo_propietario" class="products_correo_propietario"><div class="ew-table-header-caption"><?php echo $products_list->correo_propietario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="correo_propietario" class="<?php echo $products_list->correo_propietario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->correo_propietario) ?>', 1);"><div id="elh_products_correo_propietario" class="products_correo_propietario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->correo_propietario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->correo_propietario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->correo_propietario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->vinculo->Visible) { // vinculo ?>
	<?php if ($products_list->SortUrl($products_list->vinculo) == "") { ?>
		<th data-name="vinculo" class="<?php echo $products_list->vinculo->headerCellClass() ?>"><div id="elh_products_vinculo" class="products_vinculo"><div class="ew-table-header-caption"><?php echo $products_list->vinculo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vinculo" class="<?php echo $products_list->vinculo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->vinculo) ?>', 1);"><div id="elh_products_vinculo" class="products_vinculo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->vinculo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->vinculo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->vinculo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->notas->Visible) { // notas ?>
	<?php if ($products_list->SortUrl($products_list->notas) == "") { ?>
		<th data-name="notas" class="<?php echo $products_list->notas->headerCellClass() ?>"><div id="elh_products_notas" class="products_notas"><div class="ew-table-header-caption"><?php echo $products_list->notas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="notas" class="<?php echo $products_list->notas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->notas) ?>', 1);"><div id="elh_products_notas" class="products_notas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->notas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->notas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->notas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->marca->Visible) { // marca ?>
	<?php if ($products_list->SortUrl($products_list->marca) == "") { ?>
		<th data-name="marca" class="<?php echo $products_list->marca->headerCellClass() ?>"><div id="elh_products_marca" class="products_marca"><div class="ew-table-header-caption"><?php echo $products_list->marca->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marca" class="<?php echo $products_list->marca->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->marca) ?>', 1);"><div id="elh_products_marca" class="products_marca">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->marca->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->marca->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->marca->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->modelo->Visible) { // modelo ?>
	<?php if ($products_list->SortUrl($products_list->modelo) == "") { ?>
		<th data-name="modelo" class="<?php echo $products_list->modelo->headerCellClass() ?>"><div id="elh_products_modelo" class="products_modelo"><div class="ew-table-header-caption"><?php echo $products_list->modelo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="modelo" class="<?php echo $products_list->modelo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->modelo) ?>', 1);"><div id="elh_products_modelo" class="products_modelo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->modelo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->modelo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->modelo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->color->Visible) { // color ?>
	<?php if ($products_list->SortUrl($products_list->color) == "") { ?>
		<th data-name="color" class="<?php echo $products_list->color->headerCellClass() ?>"><div id="elh_products_color" class="products_color"><div class="ew-table-header-caption"><?php echo $products_list->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $products_list->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->color) ?>', 1);"><div id="elh_products_color" class="products_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->color->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->color->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b1->Visible) { // b1 ?>
	<?php if ($products_list->SortUrl($products_list->b1) == "") { ?>
		<th data-name="b1" class="<?php echo $products_list->b1->headerCellClass() ?>"><div id="elh_products_b1" class="products_b1"><div class="ew-table-header-caption"><?php echo $products_list->b1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b1" class="<?php echo $products_list->b1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b1) ?>', 1);"><div id="elh_products_b1" class="products_b1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b1->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b2->Visible) { // b2 ?>
	<?php if ($products_list->SortUrl($products_list->b2) == "") { ?>
		<th data-name="b2" class="<?php echo $products_list->b2->headerCellClass() ?>"><div id="elh_products_b2" class="products_b2"><div class="ew-table-header-caption"><?php echo $products_list->b2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b2" class="<?php echo $products_list->b2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b2) ?>', 1);"><div id="elh_products_b2" class="products_b2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b2->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b3->Visible) { // b3 ?>
	<?php if ($products_list->SortUrl($products_list->b3) == "") { ?>
		<th data-name="b3" class="<?php echo $products_list->b3->headerCellClass() ?>"><div id="elh_products_b3" class="products_b3"><div class="ew-table-header-caption"><?php echo $products_list->b3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b3" class="<?php echo $products_list->b3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b3) ?>', 1);"><div id="elh_products_b3" class="products_b3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b3->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b4->Visible) { // b4 ?>
	<?php if ($products_list->SortUrl($products_list->b4) == "") { ?>
		<th data-name="b4" class="<?php echo $products_list->b4->headerCellClass() ?>"><div id="elh_products_b4" class="products_b4"><div class="ew-table-header-caption"><?php echo $products_list->b4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b4" class="<?php echo $products_list->b4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b4) ?>', 1);"><div id="elh_products_b4" class="products_b4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b4->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b4->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b4->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b5->Visible) { // b5 ?>
	<?php if ($products_list->SortUrl($products_list->b5) == "") { ?>
		<th data-name="b5" class="<?php echo $products_list->b5->headerCellClass() ?>"><div id="elh_products_b5" class="products_b5"><div class="ew-table-header-caption"><?php echo $products_list->b5->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b5" class="<?php echo $products_list->b5->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b5) ?>', 1);"><div id="elh_products_b5" class="products_b5">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b5->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b5->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b5->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->b6->Visible) { // b6 ?>
	<?php if ($products_list->SortUrl($products_list->b6) == "") { ?>
		<th data-name="b6" class="<?php echo $products_list->b6->headerCellClass() ?>"><div id="elh_products_b6" class="products_b6"><div class="ew-table-header-caption"><?php echo $products_list->b6->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b6" class="<?php echo $products_list->b6->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->b6) ?>', 1);"><div id="elh_products_b6" class="products_b6">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->b6->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->b6->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->b6->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->cat_pro->Visible) { // cat_pro ?>
	<?php if ($products_list->SortUrl($products_list->cat_pro) == "") { ?>
		<th data-name="cat_pro" class="<?php echo $products_list->cat_pro->headerCellClass() ?>"><div id="elh_products_cat_pro" class="products_cat_pro"><div class="ew-table-header-caption"><?php echo $products_list->cat_pro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cat_pro" class="<?php echo $products_list->cat_pro->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->cat_pro) ?>', 1);"><div id="elh_products_cat_pro" class="products_cat_pro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->cat_pro->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->cat_pro->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->cat_pro->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->pro_ser->Visible) { // pro_ser ?>
	<?php if ($products_list->SortUrl($products_list->pro_ser) == "") { ?>
		<th data-name="pro_ser" class="<?php echo $products_list->pro_ser->headerCellClass() ?>"><div id="elh_products_pro_ser" class="products_pro_ser"><div class="ew-table-header-caption"><?php echo $products_list->pro_ser->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pro_ser" class="<?php echo $products_list->pro_ser->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->pro_ser) ?>', 1);"><div id="elh_products_pro_ser" class="products_pro_ser">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->pro_ser->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->pro_ser->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->pro_ser->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->foto2->Visible) { // foto2 ?>
	<?php if ($products_list->SortUrl($products_list->foto2) == "") { ?>
		<th data-name="foto2" class="<?php echo $products_list->foto2->headerCellClass() ?>"><div id="elh_products_foto2" class="products_foto2"><div class="ew-table-header-caption"><?php echo $products_list->foto2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto2" class="<?php echo $products_list->foto2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->foto2) ?>', 1);"><div id="elh_products_foto2" class="products_foto2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->foto2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->foto2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->foto2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->foto3->Visible) { // foto3 ?>
	<?php if ($products_list->SortUrl($products_list->foto3) == "") { ?>
		<th data-name="foto3" class="<?php echo $products_list->foto3->headerCellClass() ?>"><div id="elh_products_foto3" class="products_foto3"><div class="ew-table-header-caption"><?php echo $products_list->foto3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto3" class="<?php echo $products_list->foto3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->foto3) ?>', 1);"><div id="elh_products_foto3" class="products_foto3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->foto3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->foto3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->foto3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->foto4->Visible) { // foto4 ?>
	<?php if ($products_list->SortUrl($products_list->foto4) == "") { ?>
		<th data-name="foto4" class="<?php echo $products_list->foto4->headerCellClass() ?>"><div id="elh_products_foto4" class="products_foto4"><div class="ew-table-header-caption"><?php echo $products_list->foto4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto4" class="<?php echo $products_list->foto4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->foto4) ?>', 1);"><div id="elh_products_foto4" class="products_foto4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->foto4->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->foto4->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->foto4->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->web->Visible) { // web ?>
	<?php if ($products_list->SortUrl($products_list->web) == "") { ?>
		<th data-name="web" class="<?php echo $products_list->web->headerCellClass() ?>"><div id="elh_products_web" class="products_web"><div class="ew-table-header-caption"><?php echo $products_list->web->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="web" class="<?php echo $products_list->web->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->web) ?>', 1);"><div id="elh_products_web" class="products_web">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->web->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->web->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->web->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->pre_web->Visible) { // pre_web ?>
	<?php if ($products_list->SortUrl($products_list->pre_web) == "") { ?>
		<th data-name="pre_web" class="<?php echo $products_list->pre_web->headerCellClass() ?>"><div id="elh_products_pre_web" class="products_pre_web"><div class="ew-table-header-caption"><?php echo $products_list->pre_web->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pre_web" class="<?php echo $products_list->pre_web->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->pre_web) ?>', 1);"><div id="elh_products_pre_web" class="products_pre_web">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->pre_web->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->pre_web->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->pre_web->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->megusta->Visible) { // megusta ?>
	<?php if ($products_list->SortUrl($products_list->megusta) == "") { ?>
		<th data-name="megusta" class="<?php echo $products_list->megusta->headerCellClass() ?>"><div id="elh_products_megusta" class="products_megusta"><div class="ew-table-header-caption"><?php echo $products_list->megusta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="megusta" class="<?php echo $products_list->megusta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->megusta) ?>', 1);"><div id="elh_products_megusta" class="products_megusta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->megusta->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->megusta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->megusta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->nomegusta->Visible) { // nomegusta ?>
	<?php if ($products_list->SortUrl($products_list->nomegusta) == "") { ?>
		<th data-name="nomegusta" class="<?php echo $products_list->nomegusta->headerCellClass() ?>"><div id="elh_products_nomegusta" class="products_nomegusta"><div class="ew-table-header-caption"><?php echo $products_list->nomegusta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomegusta" class="<?php echo $products_list->nomegusta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->nomegusta) ?>', 1);"><div id="elh_products_nomegusta" class="products_nomegusta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->nomegusta->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->nomegusta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->nomegusta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->precio2->Visible) { // precio2 ?>
	<?php if ($products_list->SortUrl($products_list->precio2) == "") { ?>
		<th data-name="precio2" class="<?php echo $products_list->precio2->headerCellClass() ?>"><div id="elh_products_precio2" class="products_precio2"><div class="ew-table-header-caption"><?php echo $products_list->precio2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio2" class="<?php echo $products_list->precio2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->precio2) ?>', 1);"><div id="elh_products_precio2" class="products_precio2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->precio2->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->precio2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->precio2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->precio3->Visible) { // precio3 ?>
	<?php if ($products_list->SortUrl($products_list->precio3) == "") { ?>
		<th data-name="precio3" class="<?php echo $products_list->precio3->headerCellClass() ?>"><div id="elh_products_precio3" class="products_precio3"><div class="ew-table-header-caption"><?php echo $products_list->precio3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio3" class="<?php echo $products_list->precio3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->precio3) ?>', 1);"><div id="elh_products_precio3" class="products_precio3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->precio3->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->precio3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->precio3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->und_pro->Visible) { // und_pro ?>
	<?php if ($products_list->SortUrl($products_list->und_pro) == "") { ?>
		<th data-name="und_pro" class="<?php echo $products_list->und_pro->headerCellClass() ?>"><div id="elh_products_und_pro" class="products_und_pro"><div class="ew-table-header-caption"><?php echo $products_list->und_pro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="und_pro" class="<?php echo $products_list->und_pro->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->und_pro) ?>', 1);"><div id="elh_products_und_pro" class="products_und_pro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->und_pro->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->und_pro->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->und_pro->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->barras->Visible) { // barras ?>
	<?php if ($products_list->SortUrl($products_list->barras) == "") { ?>
		<th data-name="barras" class="<?php echo $products_list->barras->headerCellClass() ?>"><div id="elh_products_barras" class="products_barras"><div class="ew-table-header-caption"><?php echo $products_list->barras->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="barras" class="<?php echo $products_list->barras->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->barras) ?>', 1);"><div id="elh_products_barras" class="products_barras">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->barras->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->barras->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->barras->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->stockmin->Visible) { // stockmin ?>
	<?php if ($products_list->SortUrl($products_list->stockmin) == "") { ?>
		<th data-name="stockmin" class="<?php echo $products_list->stockmin->headerCellClass() ?>"><div id="elh_products_stockmin" class="products_stockmin"><div class="ew-table-header-caption"><?php echo $products_list->stockmin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stockmin" class="<?php echo $products_list->stockmin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->stockmin) ?>', 1);"><div id="elh_products_stockmin" class="products_stockmin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->stockmin->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->stockmin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->stockmin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->id_grupo->Visible) { // id_grupo ?>
	<?php if ($products_list->SortUrl($products_list->id_grupo) == "") { ?>
		<th data-name="id_grupo" class="<?php echo $products_list->id_grupo->headerCellClass() ?>"><div id="elh_products_id_grupo" class="products_id_grupo"><div class="ew-table-header-caption"><?php echo $products_list->id_grupo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_grupo" class="<?php echo $products_list->id_grupo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->id_grupo) ?>', 1);"><div id="elh_products_id_grupo" class="products_id_grupo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->id_grupo->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->id_grupo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->id_grupo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->talla->Visible) { // talla ?>
	<?php if ($products_list->SortUrl($products_list->talla) == "") { ?>
		<th data-name="talla" class="<?php echo $products_list->talla->headerCellClass() ?>"><div id="elh_products_talla" class="products_talla"><div class="ew-table-header-caption"><?php echo $products_list->talla->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="talla" class="<?php echo $products_list->talla->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->talla) ?>', 1);"><div id="elh_products_talla" class="products_talla">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->talla->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->talla->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->talla->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->mostrarcolor->Visible) { // mostrarcolor ?>
	<?php if ($products_list->SortUrl($products_list->mostrarcolor) == "") { ?>
		<th data-name="mostrarcolor" class="<?php echo $products_list->mostrarcolor->headerCellClass() ?>"><div id="elh_products_mostrarcolor" class="products_mostrarcolor"><div class="ew-table-header-caption"><?php echo $products_list->mostrarcolor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mostrarcolor" class="<?php echo $products_list->mostrarcolor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->mostrarcolor) ?>', 1);"><div id="elh_products_mostrarcolor" class="products_mostrarcolor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->mostrarcolor->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->mostrarcolor->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->mostrarcolor->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->precio_mayorista->Visible) { // precio_mayorista ?>
	<?php if ($products_list->SortUrl($products_list->precio_mayorista) == "") { ?>
		<th data-name="precio_mayorista" class="<?php echo $products_list->precio_mayorista->headerCellClass() ?>"><div id="elh_products_precio_mayorista" class="products_precio_mayorista"><div class="ew-table-header-caption"><?php echo $products_list->precio_mayorista->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio_mayorista" class="<?php echo $products_list->precio_mayorista->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->precio_mayorista) ?>', 1);"><div id="elh_products_precio_mayorista" class="products_precio_mayorista">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->precio_mayorista->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->precio_mayorista->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->precio_mayorista->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->precio_vendedor->Visible) { // precio_vendedor ?>
	<?php if ($products_list->SortUrl($products_list->precio_vendedor) == "") { ?>
		<th data-name="precio_vendedor" class="<?php echo $products_list->precio_vendedor->headerCellClass() ?>"><div id="elh_products_precio_vendedor" class="products_precio_vendedor"><div class="ew-table-header-caption"><?php echo $products_list->precio_vendedor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio_vendedor" class="<?php echo $products_list->precio_vendedor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->precio_vendedor) ?>', 1);"><div id="elh_products_precio_vendedor" class="products_precio_vendedor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->precio_vendedor->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->precio_vendedor->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->precio_vendedor->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->medida1->Visible) { // medida1 ?>
	<?php if ($products_list->SortUrl($products_list->medida1) == "") { ?>
		<th data-name="medida1" class="<?php echo $products_list->medida1->headerCellClass() ?>"><div id="elh_products_medida1" class="products_medida1"><div class="ew-table-header-caption"><?php echo $products_list->medida1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="medida1" class="<?php echo $products_list->medida1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->medida1) ?>', 1);"><div id="elh_products_medida1" class="products_medida1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->medida1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->medida1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->medida1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->medida2->Visible) { // medida2 ?>
	<?php if ($products_list->SortUrl($products_list->medida2) == "") { ?>
		<th data-name="medida2" class="<?php echo $products_list->medida2->headerCellClass() ?>"><div id="elh_products_medida2" class="products_medida2"><div class="ew-table-header-caption"><?php echo $products_list->medida2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="medida2" class="<?php echo $products_list->medida2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->medida2) ?>', 1);"><div id="elh_products_medida2" class="products_medida2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->medida2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->medida2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->medida2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->medida3->Visible) { // medida3 ?>
	<?php if ($products_list->SortUrl($products_list->medida3) == "") { ?>
		<th data-name="medida3" class="<?php echo $products_list->medida3->headerCellClass() ?>"><div id="elh_products_medida3" class="products_medida3"><div class="ew-table-header-caption"><?php echo $products_list->medida3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="medida3" class="<?php echo $products_list->medida3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->medida3) ?>', 1);"><div id="elh_products_medida3" class="products_medida3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->medida3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->medida3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->medida3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->codlogin->Visible) { // codlogin ?>
	<?php if ($products_list->SortUrl($products_list->codlogin) == "") { ?>
		<th data-name="codlogin" class="<?php echo $products_list->codlogin->headerCellClass() ?>"><div id="elh_products_codlogin" class="products_codlogin"><div class="ew-table-header-caption"><?php echo $products_list->codlogin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codlogin" class="<?php echo $products_list->codlogin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->codlogin) ?>', 1);"><div id="elh_products_codlogin" class="products_codlogin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->codlogin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->codlogin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->codlogin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->idempresa->Visible) { // idempresa ?>
	<?php if ($products_list->SortUrl($products_list->idempresa) == "") { ?>
		<th data-name="idempresa" class="<?php echo $products_list->idempresa->headerCellClass() ?>"><div id="elh_products_idempresa" class="products_idempresa"><div class="ew-table-header-caption"><?php echo $products_list->idempresa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idempresa" class="<?php echo $products_list->idempresa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->idempresa) ?>', 1);"><div id="elh_products_idempresa" class="products_idempresa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->idempresa->caption() ?></span><span class="ew-table-header-sort"><?php if ($products_list->idempresa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->idempresa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($products_list->urlstreetview->Visible) { // urlstreetview ?>
	<?php if ($products_list->SortUrl($products_list->urlstreetview) == "") { ?>
		<th data-name="urlstreetview" class="<?php echo $products_list->urlstreetview->headerCellClass() ?>"><div id="elh_products_urlstreetview" class="products_urlstreetview"><div class="ew-table-header-caption"><?php echo $products_list->urlstreetview->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="urlstreetview" class="<?php echo $products_list->urlstreetview->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $products_list->SortUrl($products_list->urlstreetview) ?>', 1);"><div id="elh_products_urlstreetview" class="products_urlstreetview">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $products_list->urlstreetview->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($products_list->urlstreetview->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($products_list->urlstreetview->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$products_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($products_list->ExportAll && $products_list->isExport()) {
	$products_list->StopRecord = $products_list->TotalRecords;
} else {

	// Set the last record to display
	if ($products_list->TotalRecords > $products_list->StartRecord + $products_list->DisplayRecords - 1)
		$products_list->StopRecord = $products_list->StartRecord + $products_list->DisplayRecords - 1;
	else
		$products_list->StopRecord = $products_list->TotalRecords;
}
$products_list->RecordCount = $products_list->StartRecord - 1;
if ($products_list->Recordset && !$products_list->Recordset->EOF) {
	$products_list->Recordset->moveFirst();
	$selectLimit = $products_list->UseSelectLimit;
	if (!$selectLimit && $products_list->StartRecord > 1)
		$products_list->Recordset->move($products_list->StartRecord - 1);
} elseif (!$products->AllowAddDeleteRow && $products_list->StopRecord == 0) {
	$products_list->StopRecord = $products->GridAddRowCount;
}

// Initialize aggregate
$products->RowType = ROWTYPE_AGGREGATEINIT;
$products->resetAttributes();
$products_list->renderRow();
while ($products_list->RecordCount < $products_list->StopRecord) {
	$products_list->RecordCount++;
	if ($products_list->RecordCount >= $products_list->StartRecord) {
		$products_list->RowCount++;

		// Set up key count
		$products_list->KeyCount = $products_list->RowIndex;

		// Init row class and style
		$products->resetAttributes();
		$products->CssClass = "";
		if ($products_list->isGridAdd()) {
		} else {
			$products_list->loadRowValues($products_list->Recordset); // Load row values
		}
		$products->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$products->RowAttrs->merge(["data-rowindex" => $products_list->RowCount, "id" => "r" . $products_list->RowCount . "_products", "data-rowtype" => $products->RowType]);

		// Render row
		$products_list->renderRow();

		// Render list options
		$products_list->renderListOptions();
?>
	<tr <?php echo $products->rowAttributes() ?>>
<?php

// Render list options (body, left)
$products_list->ListOptions->render("body", "left", $products_list->RowCount);
?>
	<?php if ($products_list->id_producto->Visible) { // id_producto ?>
		<td data-name="id_producto" <?php echo $products_list->id_producto->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_id_producto" class="products_id_producto">
<span<?php echo $products_list->id_producto->viewAttributes() ?>><?php echo $products_list->id_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->codigo_producto->Visible) { // codigo_producto ?>
		<td data-name="codigo_producto" <?php echo $products_list->codigo_producto->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_codigo_producto" class="products_codigo_producto">
<span<?php echo $products_list->codigo_producto->viewAttributes() ?>><?php echo $products_list->codigo_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $products_list->estado->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_estado" class="products_estado">
<span<?php echo $products_list->estado->viewAttributes() ?>><?php echo $products_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->status_producto->Visible) { // status_producto ?>
		<td data-name="status_producto" <?php echo $products_list->status_producto->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_status_producto" class="products_status_producto">
<span<?php echo $products_list->status_producto->viewAttributes() ?>><?php echo $products_list->status_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->date_added->Visible) { // date_added ?>
		<td data-name="date_added" <?php echo $products_list->date_added->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_date_added" class="products_date_added">
<span<?php echo $products_list->date_added->viewAttributes() ?>><?php echo $products_list->date_added->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->precio_producto->Visible) { // precio_producto ?>
		<td data-name="precio_producto" <?php echo $products_list->precio_producto->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_precio_producto" class="products_precio_producto">
<span<?php echo $products_list->precio_producto->viewAttributes() ?>><?php echo $products_list->precio_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->costo_producto->Visible) { // costo_producto ?>
		<td data-name="costo_producto" <?php echo $products_list->costo_producto->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_costo_producto" class="products_costo_producto">
<span<?php echo $products_list->costo_producto->viewAttributes() ?>><?php echo $products_list->costo_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->mon_costo->Visible) { // mon_costo ?>
		<td data-name="mon_costo" <?php echo $products_list->mon_costo->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_mon_costo" class="products_mon_costo">
<span<?php echo $products_list->mon_costo->viewAttributes() ?>><?php echo $products_list->mon_costo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->mon_venta->Visible) { // mon_venta ?>
		<td data-name="mon_venta" <?php echo $products_list->mon_venta->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_mon_venta" class="products_mon_venta">
<span<?php echo $products_list->mon_venta->viewAttributes() ?>><?php echo $products_list->mon_venta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->pais->Visible) { // pais ?>
		<td data-name="pais" <?php echo $products_list->pais->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_pais" class="products_pais">
<span<?php echo $products_list->pais->viewAttributes() ?>><?php echo $products_list->pais->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->departamento->Visible) { // departamento ?>
		<td data-name="departamento" <?php echo $products_list->departamento->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_departamento" class="products_departamento">
<span<?php echo $products_list->departamento->viewAttributes() ?>><?php echo $products_list->departamento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->distrito->Visible) { // distrito ?>
		<td data-name="distrito" <?php echo $products_list->distrito->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_distrito" class="products_distrito">
<span<?php echo $products_list->distrito->viewAttributes() ?>><?php echo $products_list->distrito->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->localidad->Visible) { // localidad ?>
		<td data-name="localidad" <?php echo $products_list->localidad->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_localidad" class="products_localidad">
<span<?php echo $products_list->localidad->viewAttributes() ?>><?php echo $products_list->localidad->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->zona->Visible) { // zona ?>
		<td data-name="zona" <?php echo $products_list->zona->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_zona" class="products_zona">
<span<?php echo $products_list->zona->viewAttributes() ?>><?php echo $products_list->zona->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->tipo_inmueble->Visible) { // tipo_inmueble ?>
		<td data-name="tipo_inmueble" <?php echo $products_list->tipo_inmueble->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_tipo_inmueble" class="products_tipo_inmueble">
<span<?php echo $products_list->tipo_inmueble->viewAttributes() ?>><?php echo $products_list->tipo_inmueble->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->tipo_negocio->Visible) { // tipo_negocio ?>
		<td data-name="tipo_negocio" <?php echo $products_list->tipo_negocio->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_tipo_negocio" class="products_tipo_negocio">
<span<?php echo $products_list->tipo_negocio->viewAttributes() ?>><?php echo $products_list->tipo_negocio->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->tiempo_alquiler->Visible) { // tiempo_alquiler ?>
		<td data-name="tiempo_alquiler" <?php echo $products_list->tiempo_alquiler->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_tiempo_alquiler" class="products_tiempo_alquiler">
<span<?php echo $products_list->tiempo_alquiler->viewAttributes() ?>><?php echo $products_list->tiempo_alquiler->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->moneda->Visible) { // moneda ?>
		<td data-name="moneda" <?php echo $products_list->moneda->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_moneda" class="products_moneda">
<span<?php echo $products_list->moneda->viewAttributes() ?>><?php echo $products_list->moneda->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->estado_inmueble->Visible) { // estado_inmueble ?>
		<td data-name="estado_inmueble" <?php echo $products_list->estado_inmueble->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_estado_inmueble" class="products_estado_inmueble">
<span<?php echo $products_list->estado_inmueble->viewAttributes() ?>><?php echo $products_list->estado_inmueble->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->area_construida->Visible) { // area_construida ?>
		<td data-name="area_construida" <?php echo $products_list->area_construida->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_area_construida" class="products_area_construida">
<span<?php echo $products_list->area_construida->viewAttributes() ?>><?php echo $products_list->area_construida->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->area_privada->Visible) { // area_privada ?>
		<td data-name="area_privada" <?php echo $products_list->area_privada->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_area_privada" class="products_area_privada">
<span<?php echo $products_list->area_privada->viewAttributes() ?>><?php echo $products_list->area_privada->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->area_terreno->Visible) { // area_terreno ?>
		<td data-name="area_terreno" <?php echo $products_list->area_terreno->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_area_terreno" class="products_area_terreno">
<span<?php echo $products_list->area_terreno->viewAttributes() ?>><?php echo $products_list->area_terreno->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->valor_administracion->Visible) { // valor_administracion ?>
		<td data-name="valor_administracion" <?php echo $products_list->valor_administracion->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_valor_administracion" class="products_valor_administracion">
<span<?php echo $products_list->valor_administracion->viewAttributes() ?>><?php echo $products_list->valor_administracion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->dormitorios->Visible) { // dormitorios ?>
		<td data-name="dormitorios" <?php echo $products_list->dormitorios->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_dormitorios" class="products_dormitorios">
<span<?php echo $products_list->dormitorios->viewAttributes() ?>><?php echo $products_list->dormitorios->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->banios->Visible) { // banios ?>
		<td data-name="banios" <?php echo $products_list->banios->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_banios" class="products_banios">
<span<?php echo $products_list->banios->viewAttributes() ?>><?php echo $products_list->banios->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->garaje->Visible) { // garaje ?>
		<td data-name="garaje" <?php echo $products_list->garaje->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_garaje" class="products_garaje">
<span<?php echo $products_list->garaje->viewAttributes() ?>><?php echo $products_list->garaje->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->piso->Visible) { // piso ?>
		<td data-name="piso" <?php echo $products_list->piso->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_piso" class="products_piso">
<span<?php echo $products_list->piso->viewAttributes() ?>><?php echo $products_list->piso->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->estrato->Visible) { // estrato ?>
		<td data-name="estrato" <?php echo $products_list->estrato->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_estrato" class="products_estrato">
<span<?php echo $products_list->estrato->viewAttributes() ?>><?php echo $products_list->estrato->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->codigo_postal->Visible) { // codigo_postal ?>
		<td data-name="codigo_postal" <?php echo $products_list->codigo_postal->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_codigo_postal" class="products_codigo_postal">
<span<?php echo $products_list->codigo_postal->viewAttributes() ?>><?php echo $products_list->codigo_postal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->mapa->Visible) { // mapa ?>
		<td data-name="mapa" <?php echo $products_list->mapa->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_mapa" class="products_mapa">
<span<?php echo $products_list->mapa->viewAttributes() ?>><?php echo $products_list->mapa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->latitud->Visible) { // latitud ?>
		<td data-name="latitud" <?php echo $products_list->latitud->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_latitud" class="products_latitud">
<span<?php echo $products_list->latitud->viewAttributes() ?>><?php echo $products_list->latitud->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->longitud->Visible) { // longitud ?>
		<td data-name="longitud" <?php echo $products_list->longitud->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_longitud" class="products_longitud">
<span<?php echo $products_list->longitud->viewAttributes() ?>><?php echo $products_list->longitud->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->opciones_mapa->Visible) { // opciones_mapa ?>
		<td data-name="opciones_mapa" <?php echo $products_list->opciones_mapa->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_opciones_mapa" class="products_opciones_mapa">
<span<?php echo $products_list->opciones_mapa->viewAttributes() ?>><?php echo $products_list->opciones_mapa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->red->Visible) { // red ?>
		<td data-name="red" <?php echo $products_list->red->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_red" class="products_red">
<span<?php echo $products_list->red->viewAttributes() ?>><?php echo $products_list->red->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->disponibilidad->Visible) { // disponibilidad ?>
		<td data-name="disponibilidad" <?php echo $products_list->disponibilidad->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_disponibilidad" class="products_disponibilidad">
<span<?php echo $products_list->disponibilidad->viewAttributes() ?>><?php echo $products_list->disponibilidad->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->anio_construccion->Visible) { // anio_construccion ?>
		<td data-name="anio_construccion" <?php echo $products_list->anio_construccion->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_anio_construccion" class="products_anio_construccion">
<span<?php echo $products_list->anio_construccion->viewAttributes() ?>><?php echo $products_list->anio_construccion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->encargado->Visible) { // encargado ?>
		<td data-name="encargado" <?php echo $products_list->encargado->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_encargado" class="products_encargado">
<span<?php echo $products_list->encargado->viewAttributes() ?>><?php echo $products_list->encargado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->visitas->Visible) { // visitas ?>
		<td data-name="visitas" <?php echo $products_list->visitas->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_visitas" class="products_visitas">
<span<?php echo $products_list->visitas->viewAttributes() ?>><?php echo $products_list->visitas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->valor_comision->Visible) { // valor_comision ?>
		<td data-name="valor_comision" <?php echo $products_list->valor_comision->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_valor_comision" class="products_valor_comision">
<span<?php echo $products_list->valor_comision->viewAttributes() ?>><?php echo $products_list->valor_comision->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->tipo_comision->Visible) { // tipo_comision ?>
		<td data-name="tipo_comision" <?php echo $products_list->tipo_comision->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_tipo_comision" class="products_tipo_comision">
<span<?php echo $products_list->tipo_comision->viewAttributes() ?>><?php echo $products_list->tipo_comision->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->certificado->Visible) { // certificado ?>
		<td data-name="certificado" <?php echo $products_list->certificado->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_certificado" class="products_certificado">
<span<?php echo $products_list->certificado->viewAttributes() ?>><?php echo $products_list->certificado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->nombre_propietario->Visible) { // nombre_propietario ?>
		<td data-name="nombre_propietario" <?php echo $products_list->nombre_propietario->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_nombre_propietario" class="products_nombre_propietario">
<span<?php echo $products_list->nombre_propietario->viewAttributes() ?>><?php echo $products_list->nombre_propietario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->movil_propietario->Visible) { // movil_propietario ?>
		<td data-name="movil_propietario" <?php echo $products_list->movil_propietario->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_movil_propietario" class="products_movil_propietario">
<span<?php echo $products_list->movil_propietario->viewAttributes() ?>><?php echo $products_list->movil_propietario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->telefono_propietario->Visible) { // telefono_propietario ?>
		<td data-name="telefono_propietario" <?php echo $products_list->telefono_propietario->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_telefono_propietario" class="products_telefono_propietario">
<span<?php echo $products_list->telefono_propietario->viewAttributes() ?>><?php echo $products_list->telefono_propietario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->correo_propietario->Visible) { // correo_propietario ?>
		<td data-name="correo_propietario" <?php echo $products_list->correo_propietario->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_correo_propietario" class="products_correo_propietario">
<span<?php echo $products_list->correo_propietario->viewAttributes() ?>><?php echo $products_list->correo_propietario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->vinculo->Visible) { // vinculo ?>
		<td data-name="vinculo" <?php echo $products_list->vinculo->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_vinculo" class="products_vinculo">
<span<?php echo $products_list->vinculo->viewAttributes() ?>><?php echo $products_list->vinculo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->notas->Visible) { // notas ?>
		<td data-name="notas" <?php echo $products_list->notas->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_notas" class="products_notas">
<span<?php echo $products_list->notas->viewAttributes() ?>><?php echo $products_list->notas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->marca->Visible) { // marca ?>
		<td data-name="marca" <?php echo $products_list->marca->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_marca" class="products_marca">
<span<?php echo $products_list->marca->viewAttributes() ?>><?php echo $products_list->marca->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->modelo->Visible) { // modelo ?>
		<td data-name="modelo" <?php echo $products_list->modelo->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_modelo" class="products_modelo">
<span<?php echo $products_list->modelo->viewAttributes() ?>><?php echo $products_list->modelo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->color->Visible) { // color ?>
		<td data-name="color" <?php echo $products_list->color->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_color" class="products_color">
<span<?php echo $products_list->color->viewAttributes() ?>><?php echo $products_list->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b1->Visible) { // b1 ?>
		<td data-name="b1" <?php echo $products_list->b1->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b1" class="products_b1">
<span<?php echo $products_list->b1->viewAttributes() ?>><?php echo $products_list->b1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b2->Visible) { // b2 ?>
		<td data-name="b2" <?php echo $products_list->b2->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b2" class="products_b2">
<span<?php echo $products_list->b2->viewAttributes() ?>><?php echo $products_list->b2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b3->Visible) { // b3 ?>
		<td data-name="b3" <?php echo $products_list->b3->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b3" class="products_b3">
<span<?php echo $products_list->b3->viewAttributes() ?>><?php echo $products_list->b3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b4->Visible) { // b4 ?>
		<td data-name="b4" <?php echo $products_list->b4->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b4" class="products_b4">
<span<?php echo $products_list->b4->viewAttributes() ?>><?php echo $products_list->b4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b5->Visible) { // b5 ?>
		<td data-name="b5" <?php echo $products_list->b5->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b5" class="products_b5">
<span<?php echo $products_list->b5->viewAttributes() ?>><?php echo $products_list->b5->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->b6->Visible) { // b6 ?>
		<td data-name="b6" <?php echo $products_list->b6->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_b6" class="products_b6">
<span<?php echo $products_list->b6->viewAttributes() ?>><?php echo $products_list->b6->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->cat_pro->Visible) { // cat_pro ?>
		<td data-name="cat_pro" <?php echo $products_list->cat_pro->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_cat_pro" class="products_cat_pro">
<span<?php echo $products_list->cat_pro->viewAttributes() ?>><?php echo $products_list->cat_pro->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->pro_ser->Visible) { // pro_ser ?>
		<td data-name="pro_ser" <?php echo $products_list->pro_ser->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_pro_ser" class="products_pro_ser">
<span<?php echo $products_list->pro_ser->viewAttributes() ?>><?php echo $products_list->pro_ser->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->foto2->Visible) { // foto2 ?>
		<td data-name="foto2" <?php echo $products_list->foto2->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_foto2" class="products_foto2">
<span<?php echo $products_list->foto2->viewAttributes() ?>><?php echo $products_list->foto2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->foto3->Visible) { // foto3 ?>
		<td data-name="foto3" <?php echo $products_list->foto3->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_foto3" class="products_foto3">
<span<?php echo $products_list->foto3->viewAttributes() ?>><?php echo $products_list->foto3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->foto4->Visible) { // foto4 ?>
		<td data-name="foto4" <?php echo $products_list->foto4->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_foto4" class="products_foto4">
<span<?php echo $products_list->foto4->viewAttributes() ?>><?php echo $products_list->foto4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->web->Visible) { // web ?>
		<td data-name="web" <?php echo $products_list->web->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_web" class="products_web">
<span<?php echo $products_list->web->viewAttributes() ?>><?php echo $products_list->web->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->pre_web->Visible) { // pre_web ?>
		<td data-name="pre_web" <?php echo $products_list->pre_web->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_pre_web" class="products_pre_web">
<span<?php echo $products_list->pre_web->viewAttributes() ?>><?php echo $products_list->pre_web->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->megusta->Visible) { // megusta ?>
		<td data-name="megusta" <?php echo $products_list->megusta->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_megusta" class="products_megusta">
<span<?php echo $products_list->megusta->viewAttributes() ?>><?php echo $products_list->megusta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->nomegusta->Visible) { // nomegusta ?>
		<td data-name="nomegusta" <?php echo $products_list->nomegusta->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_nomegusta" class="products_nomegusta">
<span<?php echo $products_list->nomegusta->viewAttributes() ?>><?php echo $products_list->nomegusta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->precio2->Visible) { // precio2 ?>
		<td data-name="precio2" <?php echo $products_list->precio2->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_precio2" class="products_precio2">
<span<?php echo $products_list->precio2->viewAttributes() ?>><?php echo $products_list->precio2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->precio3->Visible) { // precio3 ?>
		<td data-name="precio3" <?php echo $products_list->precio3->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_precio3" class="products_precio3">
<span<?php echo $products_list->precio3->viewAttributes() ?>><?php echo $products_list->precio3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->und_pro->Visible) { // und_pro ?>
		<td data-name="und_pro" <?php echo $products_list->und_pro->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_und_pro" class="products_und_pro">
<span<?php echo $products_list->und_pro->viewAttributes() ?>><?php echo $products_list->und_pro->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->barras->Visible) { // barras ?>
		<td data-name="barras" <?php echo $products_list->barras->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_barras" class="products_barras">
<span<?php echo $products_list->barras->viewAttributes() ?>><?php echo $products_list->barras->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->stockmin->Visible) { // stockmin ?>
		<td data-name="stockmin" <?php echo $products_list->stockmin->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_stockmin" class="products_stockmin">
<span<?php echo $products_list->stockmin->viewAttributes() ?>><?php echo $products_list->stockmin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->id_grupo->Visible) { // id_grupo ?>
		<td data-name="id_grupo" <?php echo $products_list->id_grupo->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_id_grupo" class="products_id_grupo">
<span<?php echo $products_list->id_grupo->viewAttributes() ?>><?php echo $products_list->id_grupo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->talla->Visible) { // talla ?>
		<td data-name="talla" <?php echo $products_list->talla->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_talla" class="products_talla">
<span<?php echo $products_list->talla->viewAttributes() ?>><?php echo $products_list->talla->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->mostrarcolor->Visible) { // mostrarcolor ?>
		<td data-name="mostrarcolor" <?php echo $products_list->mostrarcolor->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_mostrarcolor" class="products_mostrarcolor">
<span<?php echo $products_list->mostrarcolor->viewAttributes() ?>><?php echo $products_list->mostrarcolor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->precio_mayorista->Visible) { // precio_mayorista ?>
		<td data-name="precio_mayorista" <?php echo $products_list->precio_mayorista->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_precio_mayorista" class="products_precio_mayorista">
<span<?php echo $products_list->precio_mayorista->viewAttributes() ?>><?php echo $products_list->precio_mayorista->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->precio_vendedor->Visible) { // precio_vendedor ?>
		<td data-name="precio_vendedor" <?php echo $products_list->precio_vendedor->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_precio_vendedor" class="products_precio_vendedor">
<span<?php echo $products_list->precio_vendedor->viewAttributes() ?>><?php echo $products_list->precio_vendedor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->medida1->Visible) { // medida1 ?>
		<td data-name="medida1" <?php echo $products_list->medida1->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_medida1" class="products_medida1">
<span<?php echo $products_list->medida1->viewAttributes() ?>><?php echo $products_list->medida1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->medida2->Visible) { // medida2 ?>
		<td data-name="medida2" <?php echo $products_list->medida2->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_medida2" class="products_medida2">
<span<?php echo $products_list->medida2->viewAttributes() ?>><?php echo $products_list->medida2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->medida3->Visible) { // medida3 ?>
		<td data-name="medida3" <?php echo $products_list->medida3->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_medida3" class="products_medida3">
<span<?php echo $products_list->medida3->viewAttributes() ?>><?php echo $products_list->medida3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->codlogin->Visible) { // codlogin ?>
		<td data-name="codlogin" <?php echo $products_list->codlogin->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_codlogin" class="products_codlogin">
<span<?php echo $products_list->codlogin->viewAttributes() ?>><?php echo $products_list->codlogin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->idempresa->Visible) { // idempresa ?>
		<td data-name="idempresa" <?php echo $products_list->idempresa->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_idempresa" class="products_idempresa">
<span<?php echo $products_list->idempresa->viewAttributes() ?>><?php echo $products_list->idempresa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($products_list->urlstreetview->Visible) { // urlstreetview ?>
		<td data-name="urlstreetview" <?php echo $products_list->urlstreetview->cellAttributes() ?>>
<span id="el<?php echo $products_list->RowCount ?>_products_urlstreetview" class="products_urlstreetview">
<span<?php echo $products_list->urlstreetview->viewAttributes() ?>><?php echo $products_list->urlstreetview->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$products_list->ListOptions->render("body", "right", $products_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$products_list->isGridAdd())
		$products_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$products->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($products_list->Recordset)
	$products_list->Recordset->Close();
?>
<?php if (!$products_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$products_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $products_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $products_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($products_list->TotalRecords == 0 && !$products->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $products_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$products_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$products_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$products_list->terminate();
?>