<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$products_edit = new products_edit();

// Run the page
$products_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$products_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fproductsedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fproductsedit = currentForm = new ew.Form("fproductsedit", "edit");

	// Validate form
	fproductsedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($products_edit->id_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_id_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->id_producto->caption(), $products_edit->id_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->codigo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->codigo_producto->caption(), $products_edit->codigo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->nombre_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->nombre_producto->caption(), $products_edit->nombre_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->estado->caption(), $products_edit->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->estado->errorMessage()) ?>");
			<?php if ($products_edit->status_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->status_producto->caption(), $products_edit->status_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->status_producto->errorMessage()) ?>");
			<?php if ($products_edit->date_added->Required) { ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->date_added->caption(), $products_edit->date_added->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->date_added->errorMessage()) ?>");
			<?php if ($products_edit->precio_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->precio_producto->caption(), $products_edit->precio_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->precio_producto->errorMessage()) ?>");
			<?php if ($products_edit->costo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->costo_producto->caption(), $products_edit->costo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->costo_producto->errorMessage()) ?>");
			<?php if ($products_edit->mon_costo->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->mon_costo->caption(), $products_edit->mon_costo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->mon_costo->errorMessage()) ?>");
			<?php if ($products_edit->mon_venta->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->mon_venta->caption(), $products_edit->mon_venta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->mon_venta->errorMessage()) ?>");
			<?php if ($products_edit->pais->Required) { ?>
				elm = this.getElements("x" + infix + "_pais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->pais->caption(), $products_edit->pais->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->departamento->Required) { ?>
				elm = this.getElements("x" + infix + "_departamento");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->departamento->caption(), $products_edit->departamento->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->distrito->Required) { ?>
				elm = this.getElements("x" + infix + "_distrito");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->distrito->caption(), $products_edit->distrito->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->localidad->Required) { ?>
				elm = this.getElements("x" + infix + "_localidad");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->localidad->caption(), $products_edit->localidad->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->zona->Required) { ?>
				elm = this.getElements("x" + infix + "_zona");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->zona->caption(), $products_edit->zona->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->tipo_inmueble->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_inmueble");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->tipo_inmueble->caption(), $products_edit->tipo_inmueble->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tipo_inmueble");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->tipo_inmueble->errorMessage()) ?>");
			<?php if ($products_edit->tipo_negocio->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_negocio");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->tipo_negocio->caption(), $products_edit->tipo_negocio->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->tiempo_alquiler->Required) { ?>
				elm = this.getElements("x" + infix + "_tiempo_alquiler");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->tiempo_alquiler->caption(), $products_edit->tiempo_alquiler->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->moneda->Required) { ?>
				elm = this.getElements("x" + infix + "_moneda");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->moneda->caption(), $products_edit->moneda->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->estado_inmueble->Required) { ?>
				elm = this.getElements("x" + infix + "_estado_inmueble");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->estado_inmueble->caption(), $products_edit->estado_inmueble->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->area_construida->Required) { ?>
				elm = this.getElements("x" + infix + "_area_construida");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->area_construida->caption(), $products_edit->area_construida->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->area_privada->Required) { ?>
				elm = this.getElements("x" + infix + "_area_privada");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->area_privada->caption(), $products_edit->area_privada->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->area_terreno->Required) { ?>
				elm = this.getElements("x" + infix + "_area_terreno");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->area_terreno->caption(), $products_edit->area_terreno->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->valor_administracion->Required) { ?>
				elm = this.getElements("x" + infix + "_valor_administracion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->valor_administracion->caption(), $products_edit->valor_administracion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->dormitorios->Required) { ?>
				elm = this.getElements("x" + infix + "_dormitorios");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->dormitorios->caption(), $products_edit->dormitorios->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->banios->Required) { ?>
				elm = this.getElements("x" + infix + "_banios");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->banios->caption(), $products_edit->banios->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->garaje->Required) { ?>
				elm = this.getElements("x" + infix + "_garaje");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->garaje->caption(), $products_edit->garaje->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->piso->Required) { ?>
				elm = this.getElements("x" + infix + "_piso");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->piso->caption(), $products_edit->piso->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->estrato->Required) { ?>
				elm = this.getElements("x" + infix + "_estrato");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->estrato->caption(), $products_edit->estrato->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->direccion->Required) { ?>
				elm = this.getElements("x" + infix + "_direccion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->direccion->caption(), $products_edit->direccion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->codigo_postal->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_postal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->codigo_postal->caption(), $products_edit->codigo_postal->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->mapa->Required) { ?>
				elm = this.getElements("x" + infix + "_mapa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->mapa->caption(), $products_edit->mapa->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->latitud->Required) { ?>
				elm = this.getElements("x" + infix + "_latitud");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->latitud->caption(), $products_edit->latitud->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->longitud->Required) { ?>
				elm = this.getElements("x" + infix + "_longitud");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->longitud->caption(), $products_edit->longitud->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->opciones_mapa->Required) { ?>
				elm = this.getElements("x" + infix + "_opciones_mapa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->opciones_mapa->caption(), $products_edit->opciones_mapa->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->red->Required) { ?>
				elm = this.getElements("x" + infix + "_red");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->red->caption(), $products_edit->red->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->video->Required) { ?>
				elm = this.getElements("x" + infix + "_video");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->video->caption(), $products_edit->video->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->disponibilidad->Required) { ?>
				elm = this.getElements("x" + infix + "_disponibilidad");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->disponibilidad->caption(), $products_edit->disponibilidad->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->anio_construccion->Required) { ?>
				elm = this.getElements("x" + infix + "_anio_construccion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->anio_construccion->caption(), $products_edit->anio_construccion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->encargado->Required) { ?>
				elm = this.getElements("x" + infix + "_encargado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->encargado->caption(), $products_edit->encargado->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->comentario->Required) { ?>
				elm = this.getElements("x" + infix + "_comentario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->comentario->caption(), $products_edit->comentario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->visitas->Required) { ?>
				elm = this.getElements("x" + infix + "_visitas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->visitas->caption(), $products_edit->visitas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->valor_comision->Required) { ?>
				elm = this.getElements("x" + infix + "_valor_comision");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->valor_comision->caption(), $products_edit->valor_comision->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_valor_comision");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->valor_comision->errorMessage()) ?>");
			<?php if ($products_edit->tipo_comision->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_comision");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->tipo_comision->caption(), $products_edit->tipo_comision->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->certificado->Required) { ?>
				elm = this.getElements("x" + infix + "_certificado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->certificado->caption(), $products_edit->certificado->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->nombre_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->nombre_propietario->caption(), $products_edit->nombre_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->movil_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_movil_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->movil_propietario->caption(), $products_edit->movil_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->telefono_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_telefono_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->telefono_propietario->caption(), $products_edit->telefono_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->correo_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_correo_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->correo_propietario->caption(), $products_edit->correo_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->vinculo->Required) { ?>
				elm = this.getElements("x" + infix + "_vinculo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->vinculo->caption(), $products_edit->vinculo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->portales->Required) { ?>
				elm = this.getElements("x" + infix + "_portales");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->portales->caption(), $products_edit->portales->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->notas->Required) { ?>
				elm = this.getElements("x" + infix + "_notas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->notas->caption(), $products_edit->notas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->marca->Required) { ?>
				elm = this.getElements("x" + infix + "_marca");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->marca->caption(), $products_edit->marca->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->modelo->Required) { ?>
				elm = this.getElements("x" + infix + "_modelo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->modelo->caption(), $products_edit->modelo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->color->Required) { ?>
				elm = this.getElements("x" + infix + "_color");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->color->caption(), $products_edit->color->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->b1->Required) { ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b1->caption(), $products_edit->b1->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b1->errorMessage()) ?>");
			<?php if ($products_edit->b2->Required) { ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b2->caption(), $products_edit->b2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b2->errorMessage()) ?>");
			<?php if ($products_edit->b3->Required) { ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b3->caption(), $products_edit->b3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b3->errorMessage()) ?>");
			<?php if ($products_edit->b4->Required) { ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b4->caption(), $products_edit->b4->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b4->errorMessage()) ?>");
			<?php if ($products_edit->b5->Required) { ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b5->caption(), $products_edit->b5->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b5->errorMessage()) ?>");
			<?php if ($products_edit->b6->Required) { ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->b6->caption(), $products_edit->b6->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->b6->errorMessage()) ?>");
			<?php if ($products_edit->cat_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->cat_pro->caption(), $products_edit->cat_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->cat_pro->errorMessage()) ?>");
			<?php if ($products_edit->pro_ser->Required) { ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->pro_ser->caption(), $products_edit->pro_ser->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->pro_ser->errorMessage()) ?>");
			<?php if ($products_edit->foto1->Required) { ?>
				elm = this.getElements("x" + infix + "_foto1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->foto1->caption(), $products_edit->foto1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->foto2->Required) { ?>
				elm = this.getElements("x" + infix + "_foto2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->foto2->caption(), $products_edit->foto2->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->foto3->Required) { ?>
				elm = this.getElements("x" + infix + "_foto3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->foto3->caption(), $products_edit->foto3->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->foto4->Required) { ?>
				elm = this.getElements("x" + infix + "_foto4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->foto4->caption(), $products_edit->foto4->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->web->Required) { ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->web->caption(), $products_edit->web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->web->errorMessage()) ?>");
			<?php if ($products_edit->pre_web->Required) { ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->pre_web->caption(), $products_edit->pre_web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->pre_web->errorMessage()) ?>");
			<?php if ($products_edit->descripcion->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->descripcion->caption(), $products_edit->descripcion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->descripcion1->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->descripcion1->caption(), $products_edit->descripcion1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->megusta->Required) { ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->megusta->caption(), $products_edit->megusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->megusta->errorMessage()) ?>");
			<?php if ($products_edit->nomegusta->Required) { ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->nomegusta->caption(), $products_edit->nomegusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->nomegusta->errorMessage()) ?>");
			<?php if ($products_edit->precio2->Required) { ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->precio2->caption(), $products_edit->precio2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->precio2->errorMessage()) ?>");
			<?php if ($products_edit->precio3->Required) { ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->precio3->caption(), $products_edit->precio3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->precio3->errorMessage()) ?>");
			<?php if ($products_edit->und_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->und_pro->caption(), $products_edit->und_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->und_pro->errorMessage()) ?>");
			<?php if ($products_edit->barras->Required) { ?>
				elm = this.getElements("x" + infix + "_barras");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->barras->caption(), $products_edit->barras->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->stockmin->Required) { ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->stockmin->caption(), $products_edit->stockmin->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->stockmin->errorMessage()) ?>");
			<?php if ($products_edit->id_grupo->Required) { ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->id_grupo->caption(), $products_edit->id_grupo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->id_grupo->errorMessage()) ?>");
			<?php if ($products_edit->talla->Required) { ?>
				elm = this.getElements("x" + infix + "_talla");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->talla->caption(), $products_edit->talla->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->mostrarcolor->Required) { ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->mostrarcolor->caption(), $products_edit->mostrarcolor->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->mostrarcolor->errorMessage()) ?>");
			<?php if ($products_edit->precio_mayorista->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_mayorista");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->precio_mayorista->caption(), $products_edit->precio_mayorista->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_mayorista");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->precio_mayorista->errorMessage()) ?>");
			<?php if ($products_edit->precio_vendedor->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_vendedor");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->precio_vendedor->caption(), $products_edit->precio_vendedor->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_vendedor");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->precio_vendedor->errorMessage()) ?>");
			<?php if ($products_edit->medida1->Required) { ?>
				elm = this.getElements("x" + infix + "_medida1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->medida1->caption(), $products_edit->medida1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->medida2->Required) { ?>
				elm = this.getElements("x" + infix + "_medida2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->medida2->caption(), $products_edit->medida2->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->medida3->Required) { ?>
				elm = this.getElements("x" + infix + "_medida3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->medida3->caption(), $products_edit->medida3->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->codlogin->Required) { ?>
				elm = this.getElements("x" + infix + "_codlogin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->codlogin->caption(), $products_edit->codlogin->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_edit->idempresa->Required) { ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->idempresa->caption(), $products_edit->idempresa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_edit->idempresa->errorMessage()) ?>");
			<?php if ($products_edit->urlstreetview->Required) { ?>
				elm = this.getElements("x" + infix + "_urlstreetview");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_edit->urlstreetview->caption(), $products_edit->urlstreetview->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fproductsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductsedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fproductsedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $products_edit->showPageHeader(); ?>
<?php
$products_edit->showMessage();
?>
<form name="fproductsedit" id="fproductsedit" class="<?php echo $products_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="products">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$products_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($products_edit->id_producto->Visible) { // id_producto ?>
	<div id="r_id_producto" class="form-group row">
		<label id="elh_products_id_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->id_producto->caption() ?><?php echo $products_edit->id_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->id_producto->cellAttributes() ?>>
<span id="el_products_id_producto">
<span<?php echo $products_edit->id_producto->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($products_edit->id_producto->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="products" data-field="x_id_producto" name="x_id_producto" id="x_id_producto" value="<?php echo HtmlEncode($products_edit->id_producto->CurrentValue) ?>">
<?php echo $products_edit->id_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->codigo_producto->Visible) { // codigo_producto ?>
	<div id="r_codigo_producto" class="form-group row">
		<label id="elh_products_codigo_producto" for="x_codigo_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->codigo_producto->caption() ?><?php echo $products_edit->codigo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->codigo_producto->cellAttributes() ?>>
<span id="el_products_codigo_producto">
<input type="text" data-table="products" data-field="x_codigo_producto" name="x_codigo_producto" id="x_codigo_producto" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_edit->codigo_producto->getPlaceHolder()) ?>" value="<?php echo $products_edit->codigo_producto->EditValue ?>"<?php echo $products_edit->codigo_producto->editAttributes() ?>>
</span>
<?php echo $products_edit->codigo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->nombre_producto->Visible) { // nombre_producto ?>
	<div id="r_nombre_producto" class="form-group row">
		<label id="elh_products_nombre_producto" for="x_nombre_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->nombre_producto->caption() ?><?php echo $products_edit->nombre_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->nombre_producto->cellAttributes() ?>>
<span id="el_products_nombre_producto">
<textarea data-table="products" data-field="x_nombre_producto" name="x_nombre_producto" id="x_nombre_producto" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->nombre_producto->getPlaceHolder()) ?>"<?php echo $products_edit->nombre_producto->editAttributes() ?>><?php echo $products_edit->nombre_producto->EditValue ?></textarea>
</span>
<?php echo $products_edit->nombre_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_products_estado" for="x_estado" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->estado->caption() ?><?php echo $products_edit->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->estado->cellAttributes() ?>>
<span id="el_products_estado">
<input type="text" data-table="products" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->estado->getPlaceHolder()) ?>" value="<?php echo $products_edit->estado->EditValue ?>"<?php echo $products_edit->estado->editAttributes() ?>>
</span>
<?php echo $products_edit->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->status_producto->Visible) { // status_producto ?>
	<div id="r_status_producto" class="form-group row">
		<label id="elh_products_status_producto" for="x_status_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->status_producto->caption() ?><?php echo $products_edit->status_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->status_producto->cellAttributes() ?>>
<span id="el_products_status_producto">
<input type="text" data-table="products" data-field="x_status_producto" name="x_status_producto" id="x_status_producto" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($products_edit->status_producto->getPlaceHolder()) ?>" value="<?php echo $products_edit->status_producto->EditValue ?>"<?php echo $products_edit->status_producto->editAttributes() ?>>
</span>
<?php echo $products_edit->status_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->date_added->Visible) { // date_added ?>
	<div id="r_date_added" class="form-group row">
		<label id="elh_products_date_added" for="x_date_added" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->date_added->caption() ?><?php echo $products_edit->date_added->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->date_added->cellAttributes() ?>>
<span id="el_products_date_added">
<input type="text" data-table="products" data-field="x_date_added" name="x_date_added" id="x_date_added" maxlength="19" placeholder="<?php echo HtmlEncode($products_edit->date_added->getPlaceHolder()) ?>" value="<?php echo $products_edit->date_added->EditValue ?>"<?php echo $products_edit->date_added->editAttributes() ?>>
<?php if (!$products_edit->date_added->ReadOnly && !$products_edit->date_added->Disabled && !isset($products_edit->date_added->EditAttrs["readonly"]) && !isset($products_edit->date_added->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductsedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductsedit", "x_date_added", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $products_edit->date_added->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->precio_producto->Visible) { // precio_producto ?>
	<div id="r_precio_producto" class="form-group row">
		<label id="elh_products_precio_producto" for="x_precio_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->precio_producto->caption() ?><?php echo $products_edit->precio_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->precio_producto->cellAttributes() ?>>
<span id="el_products_precio_producto">
<input type="text" data-table="products" data-field="x_precio_producto" name="x_precio_producto" id="x_precio_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->precio_producto->getPlaceHolder()) ?>" value="<?php echo $products_edit->precio_producto->EditValue ?>"<?php echo $products_edit->precio_producto->editAttributes() ?>>
</span>
<?php echo $products_edit->precio_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->costo_producto->Visible) { // costo_producto ?>
	<div id="r_costo_producto" class="form-group row">
		<label id="elh_products_costo_producto" for="x_costo_producto" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->costo_producto->caption() ?><?php echo $products_edit->costo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->costo_producto->cellAttributes() ?>>
<span id="el_products_costo_producto">
<input type="text" data-table="products" data-field="x_costo_producto" name="x_costo_producto" id="x_costo_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->costo_producto->getPlaceHolder()) ?>" value="<?php echo $products_edit->costo_producto->EditValue ?>"<?php echo $products_edit->costo_producto->editAttributes() ?>>
</span>
<?php echo $products_edit->costo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->mon_costo->Visible) { // mon_costo ?>
	<div id="r_mon_costo" class="form-group row">
		<label id="elh_products_mon_costo" for="x_mon_costo" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->mon_costo->caption() ?><?php echo $products_edit->mon_costo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->mon_costo->cellAttributes() ?>>
<span id="el_products_mon_costo">
<input type="text" data-table="products" data-field="x_mon_costo" name="x_mon_costo" id="x_mon_costo" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($products_edit->mon_costo->getPlaceHolder()) ?>" value="<?php echo $products_edit->mon_costo->EditValue ?>"<?php echo $products_edit->mon_costo->editAttributes() ?>>
</span>
<?php echo $products_edit->mon_costo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->mon_venta->Visible) { // mon_venta ?>
	<div id="r_mon_venta" class="form-group row">
		<label id="elh_products_mon_venta" for="x_mon_venta" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->mon_venta->caption() ?><?php echo $products_edit->mon_venta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->mon_venta->cellAttributes() ?>>
<span id="el_products_mon_venta">
<input type="text" data-table="products" data-field="x_mon_venta" name="x_mon_venta" id="x_mon_venta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->mon_venta->getPlaceHolder()) ?>" value="<?php echo $products_edit->mon_venta->EditValue ?>"<?php echo $products_edit->mon_venta->editAttributes() ?>>
</span>
<?php echo $products_edit->mon_venta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->pais->Visible) { // pais ?>
	<div id="r_pais" class="form-group row">
		<label id="elh_products_pais" for="x_pais" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->pais->caption() ?><?php echo $products_edit->pais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->pais->cellAttributes() ?>>
<span id="el_products_pais">
<input type="text" data-table="products" data-field="x_pais" name="x_pais" id="x_pais" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->pais->getPlaceHolder()) ?>" value="<?php echo $products_edit->pais->EditValue ?>"<?php echo $products_edit->pais->editAttributes() ?>>
</span>
<?php echo $products_edit->pais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->departamento->Visible) { // departamento ?>
	<div id="r_departamento" class="form-group row">
		<label id="elh_products_departamento" for="x_departamento" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->departamento->caption() ?><?php echo $products_edit->departamento->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->departamento->cellAttributes() ?>>
<span id="el_products_departamento">
<input type="text" data-table="products" data-field="x_departamento" name="x_departamento" id="x_departamento" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->departamento->getPlaceHolder()) ?>" value="<?php echo $products_edit->departamento->EditValue ?>"<?php echo $products_edit->departamento->editAttributes() ?>>
</span>
<?php echo $products_edit->departamento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->distrito->Visible) { // distrito ?>
	<div id="r_distrito" class="form-group row">
		<label id="elh_products_distrito" for="x_distrito" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->distrito->caption() ?><?php echo $products_edit->distrito->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->distrito->cellAttributes() ?>>
<span id="el_products_distrito">
<input type="text" data-table="products" data-field="x_distrito" name="x_distrito" id="x_distrito" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->distrito->getPlaceHolder()) ?>" value="<?php echo $products_edit->distrito->EditValue ?>"<?php echo $products_edit->distrito->editAttributes() ?>>
</span>
<?php echo $products_edit->distrito->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->localidad->Visible) { // localidad ?>
	<div id="r_localidad" class="form-group row">
		<label id="elh_products_localidad" for="x_localidad" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->localidad->caption() ?><?php echo $products_edit->localidad->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->localidad->cellAttributes() ?>>
<span id="el_products_localidad">
<input type="text" data-table="products" data-field="x_localidad" name="x_localidad" id="x_localidad" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->localidad->getPlaceHolder()) ?>" value="<?php echo $products_edit->localidad->EditValue ?>"<?php echo $products_edit->localidad->editAttributes() ?>>
</span>
<?php echo $products_edit->localidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->zona->Visible) { // zona ?>
	<div id="r_zona" class="form-group row">
		<label id="elh_products_zona" for="x_zona" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->zona->caption() ?><?php echo $products_edit->zona->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->zona->cellAttributes() ?>>
<span id="el_products_zona">
<input type="text" data-table="products" data-field="x_zona" name="x_zona" id="x_zona" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->zona->getPlaceHolder()) ?>" value="<?php echo $products_edit->zona->EditValue ?>"<?php echo $products_edit->zona->editAttributes() ?>>
</span>
<?php echo $products_edit->zona->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->tipo_inmueble->Visible) { // tipo_inmueble ?>
	<div id="r_tipo_inmueble" class="form-group row">
		<label id="elh_products_tipo_inmueble" for="x_tipo_inmueble" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->tipo_inmueble->caption() ?><?php echo $products_edit->tipo_inmueble->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->tipo_inmueble->cellAttributes() ?>>
<span id="el_products_tipo_inmueble">
<input type="text" data-table="products" data-field="x_tipo_inmueble" name="x_tipo_inmueble" id="x_tipo_inmueble" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->tipo_inmueble->getPlaceHolder()) ?>" value="<?php echo $products_edit->tipo_inmueble->EditValue ?>"<?php echo $products_edit->tipo_inmueble->editAttributes() ?>>
</span>
<?php echo $products_edit->tipo_inmueble->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->tipo_negocio->Visible) { // tipo_negocio ?>
	<div id="r_tipo_negocio" class="form-group row">
		<label id="elh_products_tipo_negocio" for="x_tipo_negocio" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->tipo_negocio->caption() ?><?php echo $products_edit->tipo_negocio->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->tipo_negocio->cellAttributes() ?>>
<span id="el_products_tipo_negocio">
<input type="text" data-table="products" data-field="x_tipo_negocio" name="x_tipo_negocio" id="x_tipo_negocio" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->tipo_negocio->getPlaceHolder()) ?>" value="<?php echo $products_edit->tipo_negocio->EditValue ?>"<?php echo $products_edit->tipo_negocio->editAttributes() ?>>
</span>
<?php echo $products_edit->tipo_negocio->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->tiempo_alquiler->Visible) { // tiempo_alquiler ?>
	<div id="r_tiempo_alquiler" class="form-group row">
		<label id="elh_products_tiempo_alquiler" for="x_tiempo_alquiler" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->tiempo_alquiler->caption() ?><?php echo $products_edit->tiempo_alquiler->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->tiempo_alquiler->cellAttributes() ?>>
<span id="el_products_tiempo_alquiler">
<input type="text" data-table="products" data-field="x_tiempo_alquiler" name="x_tiempo_alquiler" id="x_tiempo_alquiler" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->tiempo_alquiler->getPlaceHolder()) ?>" value="<?php echo $products_edit->tiempo_alquiler->EditValue ?>"<?php echo $products_edit->tiempo_alquiler->editAttributes() ?>>
</span>
<?php echo $products_edit->tiempo_alquiler->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->moneda->Visible) { // moneda ?>
	<div id="r_moneda" class="form-group row">
		<label id="elh_products_moneda" for="x_moneda" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->moneda->caption() ?><?php echo $products_edit->moneda->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->moneda->cellAttributes() ?>>
<span id="el_products_moneda">
<input type="text" data-table="products" data-field="x_moneda" name="x_moneda" id="x_moneda" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->moneda->getPlaceHolder()) ?>" value="<?php echo $products_edit->moneda->EditValue ?>"<?php echo $products_edit->moneda->editAttributes() ?>>
</span>
<?php echo $products_edit->moneda->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->estado_inmueble->Visible) { // estado_inmueble ?>
	<div id="r_estado_inmueble" class="form-group row">
		<label id="elh_products_estado_inmueble" for="x_estado_inmueble" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->estado_inmueble->caption() ?><?php echo $products_edit->estado_inmueble->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->estado_inmueble->cellAttributes() ?>>
<span id="el_products_estado_inmueble">
<input type="text" data-table="products" data-field="x_estado_inmueble" name="x_estado_inmueble" id="x_estado_inmueble" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->estado_inmueble->getPlaceHolder()) ?>" value="<?php echo $products_edit->estado_inmueble->EditValue ?>"<?php echo $products_edit->estado_inmueble->editAttributes() ?>>
</span>
<?php echo $products_edit->estado_inmueble->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->area_construida->Visible) { // area_construida ?>
	<div id="r_area_construida" class="form-group row">
		<label id="elh_products_area_construida" for="x_area_construida" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->area_construida->caption() ?><?php echo $products_edit->area_construida->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->area_construida->cellAttributes() ?>>
<span id="el_products_area_construida">
<input type="text" data-table="products" data-field="x_area_construida" name="x_area_construida" id="x_area_construida" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->area_construida->getPlaceHolder()) ?>" value="<?php echo $products_edit->area_construida->EditValue ?>"<?php echo $products_edit->area_construida->editAttributes() ?>>
</span>
<?php echo $products_edit->area_construida->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->area_privada->Visible) { // area_privada ?>
	<div id="r_area_privada" class="form-group row">
		<label id="elh_products_area_privada" for="x_area_privada" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->area_privada->caption() ?><?php echo $products_edit->area_privada->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->area_privada->cellAttributes() ?>>
<span id="el_products_area_privada">
<input type="text" data-table="products" data-field="x_area_privada" name="x_area_privada" id="x_area_privada" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->area_privada->getPlaceHolder()) ?>" value="<?php echo $products_edit->area_privada->EditValue ?>"<?php echo $products_edit->area_privada->editAttributes() ?>>
</span>
<?php echo $products_edit->area_privada->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->area_terreno->Visible) { // area_terreno ?>
	<div id="r_area_terreno" class="form-group row">
		<label id="elh_products_area_terreno" for="x_area_terreno" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->area_terreno->caption() ?><?php echo $products_edit->area_terreno->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->area_terreno->cellAttributes() ?>>
<span id="el_products_area_terreno">
<input type="text" data-table="products" data-field="x_area_terreno" name="x_area_terreno" id="x_area_terreno" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->area_terreno->getPlaceHolder()) ?>" value="<?php echo $products_edit->area_terreno->EditValue ?>"<?php echo $products_edit->area_terreno->editAttributes() ?>>
</span>
<?php echo $products_edit->area_terreno->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->valor_administracion->Visible) { // valor_administracion ?>
	<div id="r_valor_administracion" class="form-group row">
		<label id="elh_products_valor_administracion" for="x_valor_administracion" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->valor_administracion->caption() ?><?php echo $products_edit->valor_administracion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->valor_administracion->cellAttributes() ?>>
<span id="el_products_valor_administracion">
<input type="text" data-table="products" data-field="x_valor_administracion" name="x_valor_administracion" id="x_valor_administracion" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->valor_administracion->getPlaceHolder()) ?>" value="<?php echo $products_edit->valor_administracion->EditValue ?>"<?php echo $products_edit->valor_administracion->editAttributes() ?>>
</span>
<?php echo $products_edit->valor_administracion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->dormitorios->Visible) { // dormitorios ?>
	<div id="r_dormitorios" class="form-group row">
		<label id="elh_products_dormitorios" for="x_dormitorios" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->dormitorios->caption() ?><?php echo $products_edit->dormitorios->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->dormitorios->cellAttributes() ?>>
<span id="el_products_dormitorios">
<input type="text" data-table="products" data-field="x_dormitorios" name="x_dormitorios" id="x_dormitorios" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->dormitorios->getPlaceHolder()) ?>" value="<?php echo $products_edit->dormitorios->EditValue ?>"<?php echo $products_edit->dormitorios->editAttributes() ?>>
</span>
<?php echo $products_edit->dormitorios->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->banios->Visible) { // banios ?>
	<div id="r_banios" class="form-group row">
		<label id="elh_products_banios" for="x_banios" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->banios->caption() ?><?php echo $products_edit->banios->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->banios->cellAttributes() ?>>
<span id="el_products_banios">
<input type="text" data-table="products" data-field="x_banios" name="x_banios" id="x_banios" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->banios->getPlaceHolder()) ?>" value="<?php echo $products_edit->banios->EditValue ?>"<?php echo $products_edit->banios->editAttributes() ?>>
</span>
<?php echo $products_edit->banios->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->garaje->Visible) { // garaje ?>
	<div id="r_garaje" class="form-group row">
		<label id="elh_products_garaje" for="x_garaje" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->garaje->caption() ?><?php echo $products_edit->garaje->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->garaje->cellAttributes() ?>>
<span id="el_products_garaje">
<input type="text" data-table="products" data-field="x_garaje" name="x_garaje" id="x_garaje" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->garaje->getPlaceHolder()) ?>" value="<?php echo $products_edit->garaje->EditValue ?>"<?php echo $products_edit->garaje->editAttributes() ?>>
</span>
<?php echo $products_edit->garaje->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->piso->Visible) { // piso ?>
	<div id="r_piso" class="form-group row">
		<label id="elh_products_piso" for="x_piso" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->piso->caption() ?><?php echo $products_edit->piso->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->piso->cellAttributes() ?>>
<span id="el_products_piso">
<input type="text" data-table="products" data-field="x_piso" name="x_piso" id="x_piso" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->piso->getPlaceHolder()) ?>" value="<?php echo $products_edit->piso->EditValue ?>"<?php echo $products_edit->piso->editAttributes() ?>>
</span>
<?php echo $products_edit->piso->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->estrato->Visible) { // estrato ?>
	<div id="r_estrato" class="form-group row">
		<label id="elh_products_estrato" for="x_estrato" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->estrato->caption() ?><?php echo $products_edit->estrato->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->estrato->cellAttributes() ?>>
<span id="el_products_estrato">
<input type="text" data-table="products" data-field="x_estrato" name="x_estrato" id="x_estrato" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->estrato->getPlaceHolder()) ?>" value="<?php echo $products_edit->estrato->EditValue ?>"<?php echo $products_edit->estrato->editAttributes() ?>>
</span>
<?php echo $products_edit->estrato->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->direccion->Visible) { // direccion ?>
	<div id="r_direccion" class="form-group row">
		<label id="elh_products_direccion" for="x_direccion" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->direccion->caption() ?><?php echo $products_edit->direccion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->direccion->cellAttributes() ?>>
<span id="el_products_direccion">
<textarea data-table="products" data-field="x_direccion" name="x_direccion" id="x_direccion" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->direccion->getPlaceHolder()) ?>"<?php echo $products_edit->direccion->editAttributes() ?>><?php echo $products_edit->direccion->EditValue ?></textarea>
</span>
<?php echo $products_edit->direccion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->codigo_postal->Visible) { // codigo_postal ?>
	<div id="r_codigo_postal" class="form-group row">
		<label id="elh_products_codigo_postal" for="x_codigo_postal" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->codigo_postal->caption() ?><?php echo $products_edit->codigo_postal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->codigo_postal->cellAttributes() ?>>
<span id="el_products_codigo_postal">
<input type="text" data-table="products" data-field="x_codigo_postal" name="x_codigo_postal" id="x_codigo_postal" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->codigo_postal->getPlaceHolder()) ?>" value="<?php echo $products_edit->codigo_postal->EditValue ?>"<?php echo $products_edit->codigo_postal->editAttributes() ?>>
</span>
<?php echo $products_edit->codigo_postal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->mapa->Visible) { // mapa ?>
	<div id="r_mapa" class="form-group row">
		<label id="elh_products_mapa" for="x_mapa" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->mapa->caption() ?><?php echo $products_edit->mapa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->mapa->cellAttributes() ?>>
<span id="el_products_mapa">
<input type="text" data-table="products" data-field="x_mapa" name="x_mapa" id="x_mapa" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->mapa->getPlaceHolder()) ?>" value="<?php echo $products_edit->mapa->EditValue ?>"<?php echo $products_edit->mapa->editAttributes() ?>>
</span>
<?php echo $products_edit->mapa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->latitud->Visible) { // latitud ?>
	<div id="r_latitud" class="form-group row">
		<label id="elh_products_latitud" for="x_latitud" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->latitud->caption() ?><?php echo $products_edit->latitud->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->latitud->cellAttributes() ?>>
<span id="el_products_latitud">
<input type="text" data-table="products" data-field="x_latitud" name="x_latitud" id="x_latitud" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->latitud->getPlaceHolder()) ?>" value="<?php echo $products_edit->latitud->EditValue ?>"<?php echo $products_edit->latitud->editAttributes() ?>>
</span>
<?php echo $products_edit->latitud->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->longitud->Visible) { // longitud ?>
	<div id="r_longitud" class="form-group row">
		<label id="elh_products_longitud" for="x_longitud" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->longitud->caption() ?><?php echo $products_edit->longitud->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->longitud->cellAttributes() ?>>
<span id="el_products_longitud">
<input type="text" data-table="products" data-field="x_longitud" name="x_longitud" id="x_longitud" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->longitud->getPlaceHolder()) ?>" value="<?php echo $products_edit->longitud->EditValue ?>"<?php echo $products_edit->longitud->editAttributes() ?>>
</span>
<?php echo $products_edit->longitud->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->opciones_mapa->Visible) { // opciones_mapa ?>
	<div id="r_opciones_mapa" class="form-group row">
		<label id="elh_products_opciones_mapa" for="x_opciones_mapa" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->opciones_mapa->caption() ?><?php echo $products_edit->opciones_mapa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->opciones_mapa->cellAttributes() ?>>
<span id="el_products_opciones_mapa">
<input type="text" data-table="products" data-field="x_opciones_mapa" name="x_opciones_mapa" id="x_opciones_mapa" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->opciones_mapa->getPlaceHolder()) ?>" value="<?php echo $products_edit->opciones_mapa->EditValue ?>"<?php echo $products_edit->opciones_mapa->editAttributes() ?>>
</span>
<?php echo $products_edit->opciones_mapa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->red->Visible) { // red ?>
	<div id="r_red" class="form-group row">
		<label id="elh_products_red" for="x_red" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->red->caption() ?><?php echo $products_edit->red->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->red->cellAttributes() ?>>
<span id="el_products_red">
<input type="text" data-table="products" data-field="x_red" name="x_red" id="x_red" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->red->getPlaceHolder()) ?>" value="<?php echo $products_edit->red->EditValue ?>"<?php echo $products_edit->red->editAttributes() ?>>
</span>
<?php echo $products_edit->red->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->video->Visible) { // video ?>
	<div id="r_video" class="form-group row">
		<label id="elh_products_video" for="x_video" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->video->caption() ?><?php echo $products_edit->video->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->video->cellAttributes() ?>>
<span id="el_products_video">
<textarea data-table="products" data-field="x_video" name="x_video" id="x_video" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->video->getPlaceHolder()) ?>"<?php echo $products_edit->video->editAttributes() ?>><?php echo $products_edit->video->EditValue ?></textarea>
</span>
<?php echo $products_edit->video->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->disponibilidad->Visible) { // disponibilidad ?>
	<div id="r_disponibilidad" class="form-group row">
		<label id="elh_products_disponibilidad" for="x_disponibilidad" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->disponibilidad->caption() ?><?php echo $products_edit->disponibilidad->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->disponibilidad->cellAttributes() ?>>
<span id="el_products_disponibilidad">
<input type="text" data-table="products" data-field="x_disponibilidad" name="x_disponibilidad" id="x_disponibilidad" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->disponibilidad->getPlaceHolder()) ?>" value="<?php echo $products_edit->disponibilidad->EditValue ?>"<?php echo $products_edit->disponibilidad->editAttributes() ?>>
</span>
<?php echo $products_edit->disponibilidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->anio_construccion->Visible) { // anio_construccion ?>
	<div id="r_anio_construccion" class="form-group row">
		<label id="elh_products_anio_construccion" for="x_anio_construccion" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->anio_construccion->caption() ?><?php echo $products_edit->anio_construccion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->anio_construccion->cellAttributes() ?>>
<span id="el_products_anio_construccion">
<input type="text" data-table="products" data-field="x_anio_construccion" name="x_anio_construccion" id="x_anio_construccion" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->anio_construccion->getPlaceHolder()) ?>" value="<?php echo $products_edit->anio_construccion->EditValue ?>"<?php echo $products_edit->anio_construccion->editAttributes() ?>>
</span>
<?php echo $products_edit->anio_construccion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->encargado->Visible) { // encargado ?>
	<div id="r_encargado" class="form-group row">
		<label id="elh_products_encargado" for="x_encargado" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->encargado->caption() ?><?php echo $products_edit->encargado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->encargado->cellAttributes() ?>>
<span id="el_products_encargado">
<input type="text" data-table="products" data-field="x_encargado" name="x_encargado" id="x_encargado" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->encargado->getPlaceHolder()) ?>" value="<?php echo $products_edit->encargado->EditValue ?>"<?php echo $products_edit->encargado->editAttributes() ?>>
</span>
<?php echo $products_edit->encargado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->comentario->Visible) { // comentario ?>
	<div id="r_comentario" class="form-group row">
		<label id="elh_products_comentario" for="x_comentario" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->comentario->caption() ?><?php echo $products_edit->comentario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->comentario->cellAttributes() ?>>
<span id="el_products_comentario">
<textarea data-table="products" data-field="x_comentario" name="x_comentario" id="x_comentario" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->comentario->getPlaceHolder()) ?>"<?php echo $products_edit->comentario->editAttributes() ?>><?php echo $products_edit->comentario->EditValue ?></textarea>
</span>
<?php echo $products_edit->comentario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->visitas->Visible) { // visitas ?>
	<div id="r_visitas" class="form-group row">
		<label id="elh_products_visitas" for="x_visitas" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->visitas->caption() ?><?php echo $products_edit->visitas->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->visitas->cellAttributes() ?>>
<span id="el_products_visitas">
<input type="text" data-table="products" data-field="x_visitas" name="x_visitas" id="x_visitas" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->visitas->getPlaceHolder()) ?>" value="<?php echo $products_edit->visitas->EditValue ?>"<?php echo $products_edit->visitas->editAttributes() ?>>
</span>
<?php echo $products_edit->visitas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->valor_comision->Visible) { // valor_comision ?>
	<div id="r_valor_comision" class="form-group row">
		<label id="elh_products_valor_comision" for="x_valor_comision" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->valor_comision->caption() ?><?php echo $products_edit->valor_comision->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->valor_comision->cellAttributes() ?>>
<span id="el_products_valor_comision">
<input type="text" data-table="products" data-field="x_valor_comision" name="x_valor_comision" id="x_valor_comision" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->valor_comision->getPlaceHolder()) ?>" value="<?php echo $products_edit->valor_comision->EditValue ?>"<?php echo $products_edit->valor_comision->editAttributes() ?>>
</span>
<?php echo $products_edit->valor_comision->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->tipo_comision->Visible) { // tipo_comision ?>
	<div id="r_tipo_comision" class="form-group row">
		<label id="elh_products_tipo_comision" for="x_tipo_comision" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->tipo_comision->caption() ?><?php echo $products_edit->tipo_comision->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->tipo_comision->cellAttributes() ?>>
<span id="el_products_tipo_comision">
<input type="text" data-table="products" data-field="x_tipo_comision" name="x_tipo_comision" id="x_tipo_comision" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->tipo_comision->getPlaceHolder()) ?>" value="<?php echo $products_edit->tipo_comision->EditValue ?>"<?php echo $products_edit->tipo_comision->editAttributes() ?>>
</span>
<?php echo $products_edit->tipo_comision->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->certificado->Visible) { // certificado ?>
	<div id="r_certificado" class="form-group row">
		<label id="elh_products_certificado" for="x_certificado" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->certificado->caption() ?><?php echo $products_edit->certificado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->certificado->cellAttributes() ?>>
<span id="el_products_certificado">
<input type="text" data-table="products" data-field="x_certificado" name="x_certificado" id="x_certificado" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->certificado->getPlaceHolder()) ?>" value="<?php echo $products_edit->certificado->EditValue ?>"<?php echo $products_edit->certificado->editAttributes() ?>>
</span>
<?php echo $products_edit->certificado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->nombre_propietario->Visible) { // nombre_propietario ?>
	<div id="r_nombre_propietario" class="form-group row">
		<label id="elh_products_nombre_propietario" for="x_nombre_propietario" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->nombre_propietario->caption() ?><?php echo $products_edit->nombre_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->nombre_propietario->cellAttributes() ?>>
<span id="el_products_nombre_propietario">
<input type="text" data-table="products" data-field="x_nombre_propietario" name="x_nombre_propietario" id="x_nombre_propietario" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->nombre_propietario->getPlaceHolder()) ?>" value="<?php echo $products_edit->nombre_propietario->EditValue ?>"<?php echo $products_edit->nombre_propietario->editAttributes() ?>>
</span>
<?php echo $products_edit->nombre_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->movil_propietario->Visible) { // movil_propietario ?>
	<div id="r_movil_propietario" class="form-group row">
		<label id="elh_products_movil_propietario" for="x_movil_propietario" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->movil_propietario->caption() ?><?php echo $products_edit->movil_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->movil_propietario->cellAttributes() ?>>
<span id="el_products_movil_propietario">
<input type="text" data-table="products" data-field="x_movil_propietario" name="x_movil_propietario" id="x_movil_propietario" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_edit->movil_propietario->getPlaceHolder()) ?>" value="<?php echo $products_edit->movil_propietario->EditValue ?>"<?php echo $products_edit->movil_propietario->editAttributes() ?>>
</span>
<?php echo $products_edit->movil_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->telefono_propietario->Visible) { // telefono_propietario ?>
	<div id="r_telefono_propietario" class="form-group row">
		<label id="elh_products_telefono_propietario" for="x_telefono_propietario" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->telefono_propietario->caption() ?><?php echo $products_edit->telefono_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->telefono_propietario->cellAttributes() ?>>
<span id="el_products_telefono_propietario">
<input type="text" data-table="products" data-field="x_telefono_propietario" name="x_telefono_propietario" id="x_telefono_propietario" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_edit->telefono_propietario->getPlaceHolder()) ?>" value="<?php echo $products_edit->telefono_propietario->EditValue ?>"<?php echo $products_edit->telefono_propietario->editAttributes() ?>>
</span>
<?php echo $products_edit->telefono_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->correo_propietario->Visible) { // correo_propietario ?>
	<div id="r_correo_propietario" class="form-group row">
		<label id="elh_products_correo_propietario" for="x_correo_propietario" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->correo_propietario->caption() ?><?php echo $products_edit->correo_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->correo_propietario->cellAttributes() ?>>
<span id="el_products_correo_propietario">
<input type="text" data-table="products" data-field="x_correo_propietario" name="x_correo_propietario" id="x_correo_propietario" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->correo_propietario->getPlaceHolder()) ?>" value="<?php echo $products_edit->correo_propietario->EditValue ?>"<?php echo $products_edit->correo_propietario->editAttributes() ?>>
</span>
<?php echo $products_edit->correo_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->vinculo->Visible) { // vinculo ?>
	<div id="r_vinculo" class="form-group row">
		<label id="elh_products_vinculo" for="x_vinculo" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->vinculo->caption() ?><?php echo $products_edit->vinculo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->vinculo->cellAttributes() ?>>
<span id="el_products_vinculo">
<input type="text" data-table="products" data-field="x_vinculo" name="x_vinculo" id="x_vinculo" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->vinculo->getPlaceHolder()) ?>" value="<?php echo $products_edit->vinculo->EditValue ?>"<?php echo $products_edit->vinculo->editAttributes() ?>>
</span>
<?php echo $products_edit->vinculo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->portales->Visible) { // portales ?>
	<div id="r_portales" class="form-group row">
		<label id="elh_products_portales" for="x_portales" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->portales->caption() ?><?php echo $products_edit->portales->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->portales->cellAttributes() ?>>
<span id="el_products_portales">
<textarea data-table="products" data-field="x_portales" name="x_portales" id="x_portales" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->portales->getPlaceHolder()) ?>"<?php echo $products_edit->portales->editAttributes() ?>><?php echo $products_edit->portales->EditValue ?></textarea>
</span>
<?php echo $products_edit->portales->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->notas->Visible) { // notas ?>
	<div id="r_notas" class="form-group row">
		<label id="elh_products_notas" for="x_notas" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->notas->caption() ?><?php echo $products_edit->notas->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->notas->cellAttributes() ?>>
<span id="el_products_notas">
<input type="text" data-table="products" data-field="x_notas" name="x_notas" id="x_notas" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_edit->notas->getPlaceHolder()) ?>" value="<?php echo $products_edit->notas->EditValue ?>"<?php echo $products_edit->notas->editAttributes() ?>>
</span>
<?php echo $products_edit->notas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->marca->Visible) { // marca ?>
	<div id="r_marca" class="form-group row">
		<label id="elh_products_marca" for="x_marca" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->marca->caption() ?><?php echo $products_edit->marca->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->marca->cellAttributes() ?>>
<span id="el_products_marca">
<input type="text" data-table="products" data-field="x_marca" name="x_marca" id="x_marca" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_edit->marca->getPlaceHolder()) ?>" value="<?php echo $products_edit->marca->EditValue ?>"<?php echo $products_edit->marca->editAttributes() ?>>
</span>
<?php echo $products_edit->marca->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->modelo->Visible) { // modelo ?>
	<div id="r_modelo" class="form-group row">
		<label id="elh_products_modelo" for="x_modelo" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->modelo->caption() ?><?php echo $products_edit->modelo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->modelo->cellAttributes() ?>>
<span id="el_products_modelo">
<input type="text" data-table="products" data-field="x_modelo" name="x_modelo" id="x_modelo" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_edit->modelo->getPlaceHolder()) ?>" value="<?php echo $products_edit->modelo->EditValue ?>"<?php echo $products_edit->modelo->editAttributes() ?>>
</span>
<?php echo $products_edit->modelo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_products_color" for="x_color" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->color->caption() ?><?php echo $products_edit->color->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->color->cellAttributes() ?>>
<span id="el_products_color">
<input type="text" data-table="products" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_edit->color->getPlaceHolder()) ?>" value="<?php echo $products_edit->color->EditValue ?>"<?php echo $products_edit->color->editAttributes() ?>>
</span>
<?php echo $products_edit->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b1->Visible) { // b1 ?>
	<div id="r_b1" class="form-group row">
		<label id="elh_products_b1" for="x_b1" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b1->caption() ?><?php echo $products_edit->b1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b1->cellAttributes() ?>>
<span id="el_products_b1">
<input type="text" data-table="products" data-field="x_b1" name="x_b1" id="x_b1" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b1->getPlaceHolder()) ?>" value="<?php echo $products_edit->b1->EditValue ?>"<?php echo $products_edit->b1->editAttributes() ?>>
</span>
<?php echo $products_edit->b1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b2->Visible) { // b2 ?>
	<div id="r_b2" class="form-group row">
		<label id="elh_products_b2" for="x_b2" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b2->caption() ?><?php echo $products_edit->b2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b2->cellAttributes() ?>>
<span id="el_products_b2">
<input type="text" data-table="products" data-field="x_b2" name="x_b2" id="x_b2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b2->getPlaceHolder()) ?>" value="<?php echo $products_edit->b2->EditValue ?>"<?php echo $products_edit->b2->editAttributes() ?>>
</span>
<?php echo $products_edit->b2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b3->Visible) { // b3 ?>
	<div id="r_b3" class="form-group row">
		<label id="elh_products_b3" for="x_b3" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b3->caption() ?><?php echo $products_edit->b3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b3->cellAttributes() ?>>
<span id="el_products_b3">
<input type="text" data-table="products" data-field="x_b3" name="x_b3" id="x_b3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b3->getPlaceHolder()) ?>" value="<?php echo $products_edit->b3->EditValue ?>"<?php echo $products_edit->b3->editAttributes() ?>>
</span>
<?php echo $products_edit->b3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b4->Visible) { // b4 ?>
	<div id="r_b4" class="form-group row">
		<label id="elh_products_b4" for="x_b4" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b4->caption() ?><?php echo $products_edit->b4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b4->cellAttributes() ?>>
<span id="el_products_b4">
<input type="text" data-table="products" data-field="x_b4" name="x_b4" id="x_b4" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b4->getPlaceHolder()) ?>" value="<?php echo $products_edit->b4->EditValue ?>"<?php echo $products_edit->b4->editAttributes() ?>>
</span>
<?php echo $products_edit->b4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b5->Visible) { // b5 ?>
	<div id="r_b5" class="form-group row">
		<label id="elh_products_b5" for="x_b5" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b5->caption() ?><?php echo $products_edit->b5->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b5->cellAttributes() ?>>
<span id="el_products_b5">
<input type="text" data-table="products" data-field="x_b5" name="x_b5" id="x_b5" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b5->getPlaceHolder()) ?>" value="<?php echo $products_edit->b5->EditValue ?>"<?php echo $products_edit->b5->editAttributes() ?>>
</span>
<?php echo $products_edit->b5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->b6->Visible) { // b6 ?>
	<div id="r_b6" class="form-group row">
		<label id="elh_products_b6" for="x_b6" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->b6->caption() ?><?php echo $products_edit->b6->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->b6->cellAttributes() ?>>
<span id="el_products_b6">
<input type="text" data-table="products" data-field="x_b6" name="x_b6" id="x_b6" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->b6->getPlaceHolder()) ?>" value="<?php echo $products_edit->b6->EditValue ?>"<?php echo $products_edit->b6->editAttributes() ?>>
</span>
<?php echo $products_edit->b6->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->cat_pro->Visible) { // cat_pro ?>
	<div id="r_cat_pro" class="form-group row">
		<label id="elh_products_cat_pro" for="x_cat_pro" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->cat_pro->caption() ?><?php echo $products_edit->cat_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->cat_pro->cellAttributes() ?>>
<span id="el_products_cat_pro">
<input type="text" data-table="products" data-field="x_cat_pro" name="x_cat_pro" id="x_cat_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->cat_pro->getPlaceHolder()) ?>" value="<?php echo $products_edit->cat_pro->EditValue ?>"<?php echo $products_edit->cat_pro->editAttributes() ?>>
</span>
<?php echo $products_edit->cat_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->pro_ser->Visible) { // pro_ser ?>
	<div id="r_pro_ser" class="form-group row">
		<label id="elh_products_pro_ser" for="x_pro_ser" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->pro_ser->caption() ?><?php echo $products_edit->pro_ser->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->pro_ser->cellAttributes() ?>>
<span id="el_products_pro_ser">
<input type="text" data-table="products" data-field="x_pro_ser" name="x_pro_ser" id="x_pro_ser" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->pro_ser->getPlaceHolder()) ?>" value="<?php echo $products_edit->pro_ser->EditValue ?>"<?php echo $products_edit->pro_ser->editAttributes() ?>>
</span>
<?php echo $products_edit->pro_ser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->foto1->Visible) { // foto1 ?>
	<div id="r_foto1" class="form-group row">
		<label id="elh_products_foto1" for="x_foto1" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->foto1->caption() ?><?php echo $products_edit->foto1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->foto1->cellAttributes() ?>>
<span id="el_products_foto1">
<textarea data-table="products" data-field="x_foto1" name="x_foto1" id="x_foto1" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->foto1->getPlaceHolder()) ?>"<?php echo $products_edit->foto1->editAttributes() ?>><?php echo $products_edit->foto1->EditValue ?></textarea>
</span>
<?php echo $products_edit->foto1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->foto2->Visible) { // foto2 ?>
	<div id="r_foto2" class="form-group row">
		<label id="elh_products_foto2" for="x_foto2" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->foto2->caption() ?><?php echo $products_edit->foto2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->foto2->cellAttributes() ?>>
<span id="el_products_foto2">
<input type="text" data-table="products" data-field="x_foto2" name="x_foto2" id="x_foto2" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->foto2->getPlaceHolder()) ?>" value="<?php echo $products_edit->foto2->EditValue ?>"<?php echo $products_edit->foto2->editAttributes() ?>>
</span>
<?php echo $products_edit->foto2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->foto3->Visible) { // foto3 ?>
	<div id="r_foto3" class="form-group row">
		<label id="elh_products_foto3" for="x_foto3" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->foto3->caption() ?><?php echo $products_edit->foto3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->foto3->cellAttributes() ?>>
<span id="el_products_foto3">
<input type="text" data-table="products" data-field="x_foto3" name="x_foto3" id="x_foto3" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->foto3->getPlaceHolder()) ?>" value="<?php echo $products_edit->foto3->EditValue ?>"<?php echo $products_edit->foto3->editAttributes() ?>>
</span>
<?php echo $products_edit->foto3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->foto4->Visible) { // foto4 ?>
	<div id="r_foto4" class="form-group row">
		<label id="elh_products_foto4" for="x_foto4" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->foto4->caption() ?><?php echo $products_edit->foto4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->foto4->cellAttributes() ?>>
<span id="el_products_foto4">
<input type="text" data-table="products" data-field="x_foto4" name="x_foto4" id="x_foto4" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->foto4->getPlaceHolder()) ?>" value="<?php echo $products_edit->foto4->EditValue ?>"<?php echo $products_edit->foto4->editAttributes() ?>>
</span>
<?php echo $products_edit->foto4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->web->Visible) { // web ?>
	<div id="r_web" class="form-group row">
		<label id="elh_products_web" for="x_web" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->web->caption() ?><?php echo $products_edit->web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->web->cellAttributes() ?>>
<span id="el_products_web">
<input type="text" data-table="products" data-field="x_web" name="x_web" id="x_web" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->web->getPlaceHolder()) ?>" value="<?php echo $products_edit->web->EditValue ?>"<?php echo $products_edit->web->editAttributes() ?>>
</span>
<?php echo $products_edit->web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->pre_web->Visible) { // pre_web ?>
	<div id="r_pre_web" class="form-group row">
		<label id="elh_products_pre_web" for="x_pre_web" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->pre_web->caption() ?><?php echo $products_edit->pre_web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->pre_web->cellAttributes() ?>>
<span id="el_products_pre_web">
<input type="text" data-table="products" data-field="x_pre_web" name="x_pre_web" id="x_pre_web" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->pre_web->getPlaceHolder()) ?>" value="<?php echo $products_edit->pre_web->EditValue ?>"<?php echo $products_edit->pre_web->editAttributes() ?>>
</span>
<?php echo $products_edit->pre_web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->descripcion->Visible) { // descripcion ?>
	<div id="r_descripcion" class="form-group row">
		<label id="elh_products_descripcion" for="x_descripcion" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->descripcion->caption() ?><?php echo $products_edit->descripcion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->descripcion->cellAttributes() ?>>
<span id="el_products_descripcion">
<textarea data-table="products" data-field="x_descripcion" name="x_descripcion" id="x_descripcion" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->descripcion->getPlaceHolder()) ?>"<?php echo $products_edit->descripcion->editAttributes() ?>><?php echo $products_edit->descripcion->EditValue ?></textarea>
</span>
<?php echo $products_edit->descripcion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->descripcion1->Visible) { // descripcion1 ?>
	<div id="r_descripcion1" class="form-group row">
		<label id="elh_products_descripcion1" for="x_descripcion1" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->descripcion1->caption() ?><?php echo $products_edit->descripcion1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->descripcion1->cellAttributes() ?>>
<span id="el_products_descripcion1">
<textarea data-table="products" data-field="x_descripcion1" name="x_descripcion1" id="x_descripcion1" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_edit->descripcion1->getPlaceHolder()) ?>"<?php echo $products_edit->descripcion1->editAttributes() ?>><?php echo $products_edit->descripcion1->EditValue ?></textarea>
</span>
<?php echo $products_edit->descripcion1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->megusta->Visible) { // megusta ?>
	<div id="r_megusta" class="form-group row">
		<label id="elh_products_megusta" for="x_megusta" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->megusta->caption() ?><?php echo $products_edit->megusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->megusta->cellAttributes() ?>>
<span id="el_products_megusta">
<input type="text" data-table="products" data-field="x_megusta" name="x_megusta" id="x_megusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->megusta->getPlaceHolder()) ?>" value="<?php echo $products_edit->megusta->EditValue ?>"<?php echo $products_edit->megusta->editAttributes() ?>>
</span>
<?php echo $products_edit->megusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->nomegusta->Visible) { // nomegusta ?>
	<div id="r_nomegusta" class="form-group row">
		<label id="elh_products_nomegusta" for="x_nomegusta" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->nomegusta->caption() ?><?php echo $products_edit->nomegusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->nomegusta->cellAttributes() ?>>
<span id="el_products_nomegusta">
<input type="text" data-table="products" data-field="x_nomegusta" name="x_nomegusta" id="x_nomegusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->nomegusta->getPlaceHolder()) ?>" value="<?php echo $products_edit->nomegusta->EditValue ?>"<?php echo $products_edit->nomegusta->editAttributes() ?>>
</span>
<?php echo $products_edit->nomegusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->precio2->Visible) { // precio2 ?>
	<div id="r_precio2" class="form-group row">
		<label id="elh_products_precio2" for="x_precio2" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->precio2->caption() ?><?php echo $products_edit->precio2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->precio2->cellAttributes() ?>>
<span id="el_products_precio2">
<input type="text" data-table="products" data-field="x_precio2" name="x_precio2" id="x_precio2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->precio2->getPlaceHolder()) ?>" value="<?php echo $products_edit->precio2->EditValue ?>"<?php echo $products_edit->precio2->editAttributes() ?>>
</span>
<?php echo $products_edit->precio2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->precio3->Visible) { // precio3 ?>
	<div id="r_precio3" class="form-group row">
		<label id="elh_products_precio3" for="x_precio3" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->precio3->caption() ?><?php echo $products_edit->precio3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->precio3->cellAttributes() ?>>
<span id="el_products_precio3">
<input type="text" data-table="products" data-field="x_precio3" name="x_precio3" id="x_precio3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->precio3->getPlaceHolder()) ?>" value="<?php echo $products_edit->precio3->EditValue ?>"<?php echo $products_edit->precio3->editAttributes() ?>>
</span>
<?php echo $products_edit->precio3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->und_pro->Visible) { // und_pro ?>
	<div id="r_und_pro" class="form-group row">
		<label id="elh_products_und_pro" for="x_und_pro" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->und_pro->caption() ?><?php echo $products_edit->und_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->und_pro->cellAttributes() ?>>
<span id="el_products_und_pro">
<input type="text" data-table="products" data-field="x_und_pro" name="x_und_pro" id="x_und_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->und_pro->getPlaceHolder()) ?>" value="<?php echo $products_edit->und_pro->EditValue ?>"<?php echo $products_edit->und_pro->editAttributes() ?>>
</span>
<?php echo $products_edit->und_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->barras->Visible) { // barras ?>
	<div id="r_barras" class="form-group row">
		<label id="elh_products_barras" for="x_barras" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->barras->caption() ?><?php echo $products_edit->barras->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->barras->cellAttributes() ?>>
<span id="el_products_barras">
<input type="text" data-table="products" data-field="x_barras" name="x_barras" id="x_barras" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_edit->barras->getPlaceHolder()) ?>" value="<?php echo $products_edit->barras->EditValue ?>"<?php echo $products_edit->barras->editAttributes() ?>>
</span>
<?php echo $products_edit->barras->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->stockmin->Visible) { // stockmin ?>
	<div id="r_stockmin" class="form-group row">
		<label id="elh_products_stockmin" for="x_stockmin" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->stockmin->caption() ?><?php echo $products_edit->stockmin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->stockmin->cellAttributes() ?>>
<span id="el_products_stockmin">
<input type="text" data-table="products" data-field="x_stockmin" name="x_stockmin" id="x_stockmin" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->stockmin->getPlaceHolder()) ?>" value="<?php echo $products_edit->stockmin->EditValue ?>"<?php echo $products_edit->stockmin->editAttributes() ?>>
</span>
<?php echo $products_edit->stockmin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->id_grupo->Visible) { // id_grupo ?>
	<div id="r_id_grupo" class="form-group row">
		<label id="elh_products_id_grupo" for="x_id_grupo" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->id_grupo->caption() ?><?php echo $products_edit->id_grupo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->id_grupo->cellAttributes() ?>>
<span id="el_products_id_grupo">
<input type="text" data-table="products" data-field="x_id_grupo" name="x_id_grupo" id="x_id_grupo" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->id_grupo->getPlaceHolder()) ?>" value="<?php echo $products_edit->id_grupo->EditValue ?>"<?php echo $products_edit->id_grupo->editAttributes() ?>>
</span>
<?php echo $products_edit->id_grupo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->talla->Visible) { // talla ?>
	<div id="r_talla" class="form-group row">
		<label id="elh_products_talla" for="x_talla" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->talla->caption() ?><?php echo $products_edit->talla->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->talla->cellAttributes() ?>>
<span id="el_products_talla">
<input type="text" data-table="products" data-field="x_talla" name="x_talla" id="x_talla" size="30" maxlength="110" placeholder="<?php echo HtmlEncode($products_edit->talla->getPlaceHolder()) ?>" value="<?php echo $products_edit->talla->EditValue ?>"<?php echo $products_edit->talla->editAttributes() ?>>
</span>
<?php echo $products_edit->talla->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->mostrarcolor->Visible) { // mostrarcolor ?>
	<div id="r_mostrarcolor" class="form-group row">
		<label id="elh_products_mostrarcolor" for="x_mostrarcolor" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->mostrarcolor->caption() ?><?php echo $products_edit->mostrarcolor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->mostrarcolor->cellAttributes() ?>>
<span id="el_products_mostrarcolor">
<input type="text" data-table="products" data-field="x_mostrarcolor" name="x_mostrarcolor" id="x_mostrarcolor" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->mostrarcolor->getPlaceHolder()) ?>" value="<?php echo $products_edit->mostrarcolor->EditValue ?>"<?php echo $products_edit->mostrarcolor->editAttributes() ?>>
</span>
<?php echo $products_edit->mostrarcolor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->precio_mayorista->Visible) { // precio_mayorista ?>
	<div id="r_precio_mayorista" class="form-group row">
		<label id="elh_products_precio_mayorista" for="x_precio_mayorista" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->precio_mayorista->caption() ?><?php echo $products_edit->precio_mayorista->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->precio_mayorista->cellAttributes() ?>>
<span id="el_products_precio_mayorista">
<input type="text" data-table="products" data-field="x_precio_mayorista" name="x_precio_mayorista" id="x_precio_mayorista" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->precio_mayorista->getPlaceHolder()) ?>" value="<?php echo $products_edit->precio_mayorista->EditValue ?>"<?php echo $products_edit->precio_mayorista->editAttributes() ?>>
</span>
<?php echo $products_edit->precio_mayorista->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->precio_vendedor->Visible) { // precio_vendedor ?>
	<div id="r_precio_vendedor" class="form-group row">
		<label id="elh_products_precio_vendedor" for="x_precio_vendedor" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->precio_vendedor->caption() ?><?php echo $products_edit->precio_vendedor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->precio_vendedor->cellAttributes() ?>>
<span id="el_products_precio_vendedor">
<input type="text" data-table="products" data-field="x_precio_vendedor" name="x_precio_vendedor" id="x_precio_vendedor" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_edit->precio_vendedor->getPlaceHolder()) ?>" value="<?php echo $products_edit->precio_vendedor->EditValue ?>"<?php echo $products_edit->precio_vendedor->editAttributes() ?>>
</span>
<?php echo $products_edit->precio_vendedor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->medida1->Visible) { // medida1 ?>
	<div id="r_medida1" class="form-group row">
		<label id="elh_products_medida1" for="x_medida1" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->medida1->caption() ?><?php echo $products_edit->medida1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->medida1->cellAttributes() ?>>
<span id="el_products_medida1">
<input type="text" data-table="products" data-field="x_medida1" name="x_medida1" id="x_medida1" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->medida1->getPlaceHolder()) ?>" value="<?php echo $products_edit->medida1->EditValue ?>"<?php echo $products_edit->medida1->editAttributes() ?>>
</span>
<?php echo $products_edit->medida1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->medida2->Visible) { // medida2 ?>
	<div id="r_medida2" class="form-group row">
		<label id="elh_products_medida2" for="x_medida2" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->medida2->caption() ?><?php echo $products_edit->medida2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->medida2->cellAttributes() ?>>
<span id="el_products_medida2">
<input type="text" data-table="products" data-field="x_medida2" name="x_medida2" id="x_medida2" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->medida2->getPlaceHolder()) ?>" value="<?php echo $products_edit->medida2->EditValue ?>"<?php echo $products_edit->medida2->editAttributes() ?>>
</span>
<?php echo $products_edit->medida2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->medida3->Visible) { // medida3 ?>
	<div id="r_medida3" class="form-group row">
		<label id="elh_products_medida3" for="x_medida3" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->medida3->caption() ?><?php echo $products_edit->medida3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->medida3->cellAttributes() ?>>
<span id="el_products_medida3">
<input type="text" data-table="products" data-field="x_medida3" name="x_medida3" id="x_medida3" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_edit->medida3->getPlaceHolder()) ?>" value="<?php echo $products_edit->medida3->EditValue ?>"<?php echo $products_edit->medida3->editAttributes() ?>>
</span>
<?php echo $products_edit->medida3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->codlogin->Visible) { // codlogin ?>
	<div id="r_codlogin" class="form-group row">
		<label id="elh_products_codlogin" for="x_codlogin" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->codlogin->caption() ?><?php echo $products_edit->codlogin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->codlogin->cellAttributes() ?>>
<span id="el_products_codlogin">
<input type="text" data-table="products" data-field="x_codlogin" name="x_codlogin" id="x_codlogin" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_edit->codlogin->getPlaceHolder()) ?>" value="<?php echo $products_edit->codlogin->EditValue ?>"<?php echo $products_edit->codlogin->editAttributes() ?>>
</span>
<?php echo $products_edit->codlogin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->idempresa->Visible) { // idempresa ?>
	<div id="r_idempresa" class="form-group row">
		<label id="elh_products_idempresa" for="x_idempresa" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->idempresa->caption() ?><?php echo $products_edit->idempresa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->idempresa->cellAttributes() ?>>
<span id="el_products_idempresa">
<input type="text" data-table="products" data-field="x_idempresa" name="x_idempresa" id="x_idempresa" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_edit->idempresa->getPlaceHolder()) ?>" value="<?php echo $products_edit->idempresa->EditValue ?>"<?php echo $products_edit->idempresa->editAttributes() ?>>
</span>
<?php echo $products_edit->idempresa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_edit->urlstreetview->Visible) { // urlstreetview ?>
	<div id="r_urlstreetview" class="form-group row">
		<label id="elh_products_urlstreetview" for="x_urlstreetview" class="<?php echo $products_edit->LeftColumnClass ?>"><?php echo $products_edit->urlstreetview->caption() ?><?php echo $products_edit->urlstreetview->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_edit->RightColumnClass ?>"><div <?php echo $products_edit->urlstreetview->cellAttributes() ?>>
<span id="el_products_urlstreetview">
<input type="text" data-table="products" data-field="x_urlstreetview" name="x_urlstreetview" id="x_urlstreetview" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($products_edit->urlstreetview->getPlaceHolder()) ?>" value="<?php echo $products_edit->urlstreetview->EditValue ?>"<?php echo $products_edit->urlstreetview->editAttributes() ?>>
</span>
<?php echo $products_edit->urlstreetview->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$products_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $products_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $products_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$products_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$products_edit->terminate();
?>