<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_usuarios_list = new kp_usuarios_list();

// Run the page
$kp_usuarios_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_usuarios_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_usuarios_list->isExport()) { ?>
<script>
var fkp_usuarioslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_usuarioslist = currentForm = new ew.Form("fkp_usuarioslist", "list");
	fkp_usuarioslist.formKeyCountName = '<?php echo $kp_usuarios_list->FormKeyCountName ?>';
	loadjs.done("fkp_usuarioslist");
});
var fkp_usuarioslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_usuarioslistsrch = currentSearchForm = new ew.Form("fkp_usuarioslistsrch");

	// Dynamic selection lists
	// Filters

	fkp_usuarioslistsrch.filterList = <?php echo $kp_usuarios_list->getFilterList() ?>;
	loadjs.done("fkp_usuarioslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_usuarios_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_usuarios_list->TotalRecords > 0 && $kp_usuarios_list->ExportOptions->visible()) { ?>
<?php $kp_usuarios_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_usuarios_list->ImportOptions->visible()) { ?>
<?php $kp_usuarios_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_usuarios_list->SearchOptions->visible()) { ?>
<?php $kp_usuarios_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_usuarios_list->FilterOptions->visible()) { ?>
<?php $kp_usuarios_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_usuarios_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_usuarios_list->isExport() && !$kp_usuarios->CurrentAction) { ?>
<form name="fkp_usuarioslistsrch" id="fkp_usuarioslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_usuarioslistsrch-search-panel" class="<?php echo $kp_usuarios_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_usuarios">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_usuarios_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_usuarios_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_usuarios_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_usuarios_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_usuarios_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_usuarios_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_usuarios_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_usuarios_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_usuarios_list->showPageHeader(); ?>
<?php
$kp_usuarios_list->showMessage();
?>
<?php if ($kp_usuarios_list->TotalRecords > 0 || $kp_usuarios->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_usuarios_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_usuarios">
<form name="fkp_usuarioslist" id="fkp_usuarioslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_usuarios">
<div id="gmp_kp_usuarios" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_usuarios_list->TotalRecords > 0 || $kp_usuarios_list->isGridEdit()) { ?>
<table id="tbl_kp_usuarioslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_usuarios->RowType = ROWTYPE_HEADER;

// Render list options
$kp_usuarios_list->renderListOptions();

// Render list options (header, left)
$kp_usuarios_list->ListOptions->render("header", "left");
?>
<?php if ($kp_usuarios_list->codlogin->Visible) { // codlogin ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->codlogin) == "") { ?>
		<th data-name="codlogin" class="<?php echo $kp_usuarios_list->codlogin->headerCellClass() ?>"><div id="elh_kp_usuarios_codlogin" class="kp_usuarios_codlogin"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->codlogin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codlogin" class="<?php echo $kp_usuarios_list->codlogin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->codlogin) ?>', 1);"><div id="elh_kp_usuarios_codlogin" class="kp_usuarios_codlogin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->codlogin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->codlogin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->codlogin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->codpassword->Visible) { // codpassword ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->codpassword) == "") { ?>
		<th data-name="codpassword" class="<?php echo $kp_usuarios_list->codpassword->headerCellClass() ?>"><div id="elh_kp_usuarios_codpassword" class="kp_usuarios_codpassword"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->codpassword->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codpassword" class="<?php echo $kp_usuarios_list->codpassword->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->codpassword) ?>', 1);"><div id="elh_kp_usuarios_codpassword" class="kp_usuarios_codpassword">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->codpassword->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->codpassword->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->codpassword->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->nomusuario->Visible) { // nomusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->nomusuario) == "") { ?>
		<th data-name="nomusuario" class="<?php echo $kp_usuarios_list->nomusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_nomusuario" class="kp_usuarios_nomusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->nomusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomusuario" class="<?php echo $kp_usuarios_list->nomusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->nomusuario) ?>', 1);"><div id="elh_kp_usuarios_nomusuario" class="kp_usuarios_nomusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->nomusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->nomusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->nomusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->apeusuario->Visible) { // apeusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->apeusuario) == "") { ?>
		<th data-name="apeusuario" class="<?php echo $kp_usuarios_list->apeusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_apeusuario" class="kp_usuarios_apeusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->apeusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="apeusuario" class="<?php echo $kp_usuarios_list->apeusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->apeusuario) ?>', 1);"><div id="elh_kp_usuarios_apeusuario" class="kp_usuarios_apeusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->apeusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->apeusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->apeusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->tipo->Visible) { // tipo ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->tipo) == "") { ?>
		<th data-name="tipo" class="<?php echo $kp_usuarios_list->tipo->headerCellClass() ?>"><div id="elh_kp_usuarios_tipo" class="kp_usuarios_tipo"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->tipo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo" class="<?php echo $kp_usuarios_list->tipo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->tipo) ?>', 1);"><div id="elh_kp_usuarios_tipo" class="kp_usuarios_tipo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->tipo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->tipo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->tipo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->fecha_reg->Visible) { // fecha_reg ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->fecha_reg) == "") { ?>
		<th data-name="fecha_reg" class="<?php echo $kp_usuarios_list->fecha_reg->headerCellClass() ?>"><div id="elh_kp_usuarios_fecha_reg" class="kp_usuarios_fecha_reg"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->fecha_reg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha_reg" class="<?php echo $kp_usuarios_list->fecha_reg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->fecha_reg) ?>', 1);"><div id="elh_kp_usuarios_fecha_reg" class="kp_usuarios_fecha_reg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->fecha_reg->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->fecha_reg->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->fecha_reg->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->dniusuario->Visible) { // dniusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->dniusuario) == "") { ?>
		<th data-name="dniusuario" class="<?php echo $kp_usuarios_list->dniusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_dniusuario" class="kp_usuarios_dniusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->dniusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dniusuario" class="<?php echo $kp_usuarios_list->dniusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->dniusuario) ?>', 1);"><div id="elh_kp_usuarios_dniusuario" class="kp_usuarios_dniusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->dniusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->dniusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->dniusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->telefonousuario->Visible) { // telefonousuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->telefonousuario) == "") { ?>
		<th data-name="telefonousuario" class="<?php echo $kp_usuarios_list->telefonousuario->headerCellClass() ?>"><div id="elh_kp_usuarios_telefonousuario" class="kp_usuarios_telefonousuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->telefonousuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="telefonousuario" class="<?php echo $kp_usuarios_list->telefonousuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->telefonousuario) ?>', 1);"><div id="elh_kp_usuarios_telefonousuario" class="kp_usuarios_telefonousuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->telefonousuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->telefonousuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->telefonousuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->celularusuario->Visible) { // celularusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->celularusuario) == "") { ?>
		<th data-name="celularusuario" class="<?php echo $kp_usuarios_list->celularusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_celularusuario" class="kp_usuarios_celularusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->celularusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="celularusuario" class="<?php echo $kp_usuarios_list->celularusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->celularusuario) ?>', 1);"><div id="elh_kp_usuarios_celularusuario" class="kp_usuarios_celularusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->celularusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->celularusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->celularusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->direccionusuario->Visible) { // direccionusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->direccionusuario) == "") { ?>
		<th data-name="direccionusuario" class="<?php echo $kp_usuarios_list->direccionusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_direccionusuario" class="kp_usuarios_direccionusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->direccionusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="direccionusuario" class="<?php echo $kp_usuarios_list->direccionusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->direccionusuario) ?>', 1);"><div id="elh_kp_usuarios_direccionusuario" class="kp_usuarios_direccionusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->direccionusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->direccionusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->direccionusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->emailcorpusuario->Visible) { // emailcorpusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->emailcorpusuario) == "") { ?>
		<th data-name="emailcorpusuario" class="<?php echo $kp_usuarios_list->emailcorpusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_emailcorpusuario" class="kp_usuarios_emailcorpusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->emailcorpusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emailcorpusuario" class="<?php echo $kp_usuarios_list->emailcorpusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->emailcorpusuario) ?>', 1);"><div id="elh_kp_usuarios_emailcorpusuario" class="kp_usuarios_emailcorpusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->emailcorpusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->emailcorpusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->emailcorpusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->emailusuario->Visible) { // emailusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->emailusuario) == "") { ?>
		<th data-name="emailusuario" class="<?php echo $kp_usuarios_list->emailusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_emailusuario" class="kp_usuarios_emailusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->emailusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emailusuario" class="<?php echo $kp_usuarios_list->emailusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->emailusuario) ?>', 1);"><div id="elh_kp_usuarios_emailusuario" class="kp_usuarios_emailusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->emailusuario->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->emailusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->emailusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->iddisciplina->Visible) { // iddisciplina ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->iddisciplina) == "") { ?>
		<th data-name="iddisciplina" class="<?php echo $kp_usuarios_list->iddisciplina->headerCellClass() ?>"><div id="elh_kp_usuarios_iddisciplina" class="kp_usuarios_iddisciplina"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->iddisciplina->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddisciplina" class="<?php echo $kp_usuarios_list->iddisciplina->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->iddisciplina) ?>', 1);"><div id="elh_kp_usuarios_iddisciplina" class="kp_usuarios_iddisciplina">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->iddisciplina->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->iddisciplina->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->iddisciplina->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->idperfil->Visible) { // idperfil ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->idperfil) == "") { ?>
		<th data-name="idperfil" class="<?php echo $kp_usuarios_list->idperfil->headerCellClass() ?>"><div id="elh_kp_usuarios_idperfil" class="kp_usuarios_idperfil"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->idperfil->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idperfil" class="<?php echo $kp_usuarios_list->idperfil->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->idperfil) ?>', 1);"><div id="elh_kp_usuarios_idperfil" class="kp_usuarios_idperfil">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->idperfil->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->idperfil->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->idperfil->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->mostrarcalendario->Visible) { // mostrarcalendario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->mostrarcalendario) == "") { ?>
		<th data-name="mostrarcalendario" class="<?php echo $kp_usuarios_list->mostrarcalendario->headerCellClass() ?>"><div id="elh_kp_usuarios_mostrarcalendario" class="kp_usuarios_mostrarcalendario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->mostrarcalendario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mostrarcalendario" class="<?php echo $kp_usuarios_list->mostrarcalendario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->mostrarcalendario) ?>', 1);"><div id="elh_kp_usuarios_mostrarcalendario" class="kp_usuarios_mostrarcalendario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->mostrarcalendario->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->mostrarcalendario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->mostrarcalendario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->verificaringreso->Visible) { // verificaringreso ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->verificaringreso) == "") { ?>
		<th data-name="verificaringreso" class="<?php echo $kp_usuarios_list->verificaringreso->headerCellClass() ?>"><div id="elh_kp_usuarios_verificaringreso" class="kp_usuarios_verificaringreso"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->verificaringreso->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="verificaringreso" class="<?php echo $kp_usuarios_list->verificaringreso->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->verificaringreso) ?>', 1);"><div id="elh_kp_usuarios_verificaringreso" class="kp_usuarios_verificaringreso">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->verificaringreso->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->verificaringreso->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->verificaringreso->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->estadousuario->Visible) { // estadousuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->estadousuario) == "") { ?>
		<th data-name="estadousuario" class="<?php echo $kp_usuarios_list->estadousuario->headerCellClass() ?>"><div id="elh_kp_usuarios_estadousuario" class="kp_usuarios_estadousuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->estadousuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estadousuario" class="<?php echo $kp_usuarios_list->estadousuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->estadousuario) ?>', 1);"><div id="elh_kp_usuarios_estadousuario" class="kp_usuarios_estadousuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->estadousuario->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->estadousuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->estadousuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->idcategoria->Visible) { // idcategoria ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->idcategoria) == "") { ?>
		<th data-name="idcategoria" class="<?php echo $kp_usuarios_list->idcategoria->headerCellClass() ?>"><div id="elh_kp_usuarios_idcategoria" class="kp_usuarios_idcategoria"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->idcategoria->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idcategoria" class="<?php echo $kp_usuarios_list->idcategoria->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->idcategoria) ?>', 1);"><div id="elh_kp_usuarios_idcategoria" class="kp_usuarios_idcategoria">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->idcategoria->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->idcategoria->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->idcategoria->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->tipo_usuario->Visible) { // tipo_usuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->tipo_usuario) == "") { ?>
		<th data-name="tipo_usuario" class="<?php echo $kp_usuarios_list->tipo_usuario->headerCellClass() ?>"><div id="elh_kp_usuarios_tipo_usuario" class="kp_usuarios_tipo_usuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->tipo_usuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_usuario" class="<?php echo $kp_usuarios_list->tipo_usuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->tipo_usuario) ?>', 1);"><div id="elh_kp_usuarios_tipo_usuario" class="kp_usuarios_tipo_usuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->tipo_usuario->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->tipo_usuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->tipo_usuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->idempresa->Visible) { // idempresa ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->idempresa) == "") { ?>
		<th data-name="idempresa" class="<?php echo $kp_usuarios_list->idempresa->headerCellClass() ?>"><div id="elh_kp_usuarios_idempresa" class="kp_usuarios_idempresa"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->idempresa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idempresa" class="<?php echo $kp_usuarios_list->idempresa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->idempresa) ?>', 1);"><div id="elh_kp_usuarios_idempresa" class="kp_usuarios_idempresa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->idempresa->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->idempresa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->idempresa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->idusuario->Visible) { // idusuario ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->idusuario) == "") { ?>
		<th data-name="idusuario" class="<?php echo $kp_usuarios_list->idusuario->headerCellClass() ?>"><div id="elh_kp_usuarios_idusuario" class="kp_usuarios_idusuario"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->idusuario->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idusuario" class="<?php echo $kp_usuarios_list->idusuario->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->idusuario) ?>', 1);"><div id="elh_kp_usuarios_idusuario" class="kp_usuarios_idusuario">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->idusuario->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->idusuario->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->idusuario->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_usuarios_list->estado->Visible) { // estado ?>
	<?php if ($kp_usuarios_list->SortUrl($kp_usuarios_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $kp_usuarios_list->estado->headerCellClass() ?>"><div id="elh_kp_usuarios_estado" class="kp_usuarios_estado"><div class="ew-table-header-caption"><?php echo $kp_usuarios_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $kp_usuarios_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_usuarios_list->SortUrl($kp_usuarios_list->estado) ?>', 1);"><div id="elh_kp_usuarios_estado" class="kp_usuarios_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_usuarios_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_usuarios_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_usuarios_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_usuarios_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_usuarios_list->ExportAll && $kp_usuarios_list->isExport()) {
	$kp_usuarios_list->StopRecord = $kp_usuarios_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_usuarios_list->TotalRecords > $kp_usuarios_list->StartRecord + $kp_usuarios_list->DisplayRecords - 1)
		$kp_usuarios_list->StopRecord = $kp_usuarios_list->StartRecord + $kp_usuarios_list->DisplayRecords - 1;
	else
		$kp_usuarios_list->StopRecord = $kp_usuarios_list->TotalRecords;
}
$kp_usuarios_list->RecordCount = $kp_usuarios_list->StartRecord - 1;
if ($kp_usuarios_list->Recordset && !$kp_usuarios_list->Recordset->EOF) {
	$kp_usuarios_list->Recordset->moveFirst();
	$selectLimit = $kp_usuarios_list->UseSelectLimit;
	if (!$selectLimit && $kp_usuarios_list->StartRecord > 1)
		$kp_usuarios_list->Recordset->move($kp_usuarios_list->StartRecord - 1);
} elseif (!$kp_usuarios->AllowAddDeleteRow && $kp_usuarios_list->StopRecord == 0) {
	$kp_usuarios_list->StopRecord = $kp_usuarios->GridAddRowCount;
}

// Initialize aggregate
$kp_usuarios->RowType = ROWTYPE_AGGREGATEINIT;
$kp_usuarios->resetAttributes();
$kp_usuarios_list->renderRow();
while ($kp_usuarios_list->RecordCount < $kp_usuarios_list->StopRecord) {
	$kp_usuarios_list->RecordCount++;
	if ($kp_usuarios_list->RecordCount >= $kp_usuarios_list->StartRecord) {
		$kp_usuarios_list->RowCount++;

		// Set up key count
		$kp_usuarios_list->KeyCount = $kp_usuarios_list->RowIndex;

		// Init row class and style
		$kp_usuarios->resetAttributes();
		$kp_usuarios->CssClass = "";
		if ($kp_usuarios_list->isGridAdd()) {
		} else {
			$kp_usuarios_list->loadRowValues($kp_usuarios_list->Recordset); // Load row values
		}
		$kp_usuarios->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_usuarios->RowAttrs->merge(["data-rowindex" => $kp_usuarios_list->RowCount, "id" => "r" . $kp_usuarios_list->RowCount . "_kp_usuarios", "data-rowtype" => $kp_usuarios->RowType]);

		// Render row
		$kp_usuarios_list->renderRow();

		// Render list options
		$kp_usuarios_list->renderListOptions();
?>
	<tr <?php echo $kp_usuarios->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_usuarios_list->ListOptions->render("body", "left", $kp_usuarios_list->RowCount);
?>
	<?php if ($kp_usuarios_list->codlogin->Visible) { // codlogin ?>
		<td data-name="codlogin" <?php echo $kp_usuarios_list->codlogin->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_codlogin" class="kp_usuarios_codlogin">
<span<?php echo $kp_usuarios_list->codlogin->viewAttributes() ?>><?php echo $kp_usuarios_list->codlogin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->codpassword->Visible) { // codpassword ?>
		<td data-name="codpassword" <?php echo $kp_usuarios_list->codpassword->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_codpassword" class="kp_usuarios_codpassword">
<span<?php echo $kp_usuarios_list->codpassword->viewAttributes() ?>><?php echo $kp_usuarios_list->codpassword->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->nomusuario->Visible) { // nomusuario ?>
		<td data-name="nomusuario" <?php echo $kp_usuarios_list->nomusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_nomusuario" class="kp_usuarios_nomusuario">
<span<?php echo $kp_usuarios_list->nomusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->nomusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->apeusuario->Visible) { // apeusuario ?>
		<td data-name="apeusuario" <?php echo $kp_usuarios_list->apeusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_apeusuario" class="kp_usuarios_apeusuario">
<span<?php echo $kp_usuarios_list->apeusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->apeusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->tipo->Visible) { // tipo ?>
		<td data-name="tipo" <?php echo $kp_usuarios_list->tipo->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_tipo" class="kp_usuarios_tipo">
<span<?php echo $kp_usuarios_list->tipo->viewAttributes() ?>><?php echo $kp_usuarios_list->tipo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->fecha_reg->Visible) { // fecha_reg ?>
		<td data-name="fecha_reg" <?php echo $kp_usuarios_list->fecha_reg->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_fecha_reg" class="kp_usuarios_fecha_reg">
<span<?php echo $kp_usuarios_list->fecha_reg->viewAttributes() ?>><?php echo $kp_usuarios_list->fecha_reg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->dniusuario->Visible) { // dniusuario ?>
		<td data-name="dniusuario" <?php echo $kp_usuarios_list->dniusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_dniusuario" class="kp_usuarios_dniusuario">
<span<?php echo $kp_usuarios_list->dniusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->dniusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->telefonousuario->Visible) { // telefonousuario ?>
		<td data-name="telefonousuario" <?php echo $kp_usuarios_list->telefonousuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_telefonousuario" class="kp_usuarios_telefonousuario">
<span<?php echo $kp_usuarios_list->telefonousuario->viewAttributes() ?>><?php echo $kp_usuarios_list->telefonousuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->celularusuario->Visible) { // celularusuario ?>
		<td data-name="celularusuario" <?php echo $kp_usuarios_list->celularusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_celularusuario" class="kp_usuarios_celularusuario">
<span<?php echo $kp_usuarios_list->celularusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->celularusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->direccionusuario->Visible) { // direccionusuario ?>
		<td data-name="direccionusuario" <?php echo $kp_usuarios_list->direccionusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_direccionusuario" class="kp_usuarios_direccionusuario">
<span<?php echo $kp_usuarios_list->direccionusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->direccionusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->emailcorpusuario->Visible) { // emailcorpusuario ?>
		<td data-name="emailcorpusuario" <?php echo $kp_usuarios_list->emailcorpusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_emailcorpusuario" class="kp_usuarios_emailcorpusuario">
<span<?php echo $kp_usuarios_list->emailcorpusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->emailcorpusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->emailusuario->Visible) { // emailusuario ?>
		<td data-name="emailusuario" <?php echo $kp_usuarios_list->emailusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_emailusuario" class="kp_usuarios_emailusuario">
<span<?php echo $kp_usuarios_list->emailusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->emailusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->iddisciplina->Visible) { // iddisciplina ?>
		<td data-name="iddisciplina" <?php echo $kp_usuarios_list->iddisciplina->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_iddisciplina" class="kp_usuarios_iddisciplina">
<span<?php echo $kp_usuarios_list->iddisciplina->viewAttributes() ?>><?php echo $kp_usuarios_list->iddisciplina->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->idperfil->Visible) { // idperfil ?>
		<td data-name="idperfil" <?php echo $kp_usuarios_list->idperfil->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_idperfil" class="kp_usuarios_idperfil">
<span<?php echo $kp_usuarios_list->idperfil->viewAttributes() ?>><?php echo $kp_usuarios_list->idperfil->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->mostrarcalendario->Visible) { // mostrarcalendario ?>
		<td data-name="mostrarcalendario" <?php echo $kp_usuarios_list->mostrarcalendario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_mostrarcalendario" class="kp_usuarios_mostrarcalendario">
<span<?php echo $kp_usuarios_list->mostrarcalendario->viewAttributes() ?>><?php echo $kp_usuarios_list->mostrarcalendario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->verificaringreso->Visible) { // verificaringreso ?>
		<td data-name="verificaringreso" <?php echo $kp_usuarios_list->verificaringreso->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_verificaringreso" class="kp_usuarios_verificaringreso">
<span<?php echo $kp_usuarios_list->verificaringreso->viewAttributes() ?>><?php echo $kp_usuarios_list->verificaringreso->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->estadousuario->Visible) { // estadousuario ?>
		<td data-name="estadousuario" <?php echo $kp_usuarios_list->estadousuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_estadousuario" class="kp_usuarios_estadousuario">
<span<?php echo $kp_usuarios_list->estadousuario->viewAttributes() ?>><?php echo $kp_usuarios_list->estadousuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->idcategoria->Visible) { // idcategoria ?>
		<td data-name="idcategoria" <?php echo $kp_usuarios_list->idcategoria->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_idcategoria" class="kp_usuarios_idcategoria">
<span<?php echo $kp_usuarios_list->idcategoria->viewAttributes() ?>><?php echo $kp_usuarios_list->idcategoria->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->tipo_usuario->Visible) { // tipo_usuario ?>
		<td data-name="tipo_usuario" <?php echo $kp_usuarios_list->tipo_usuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_tipo_usuario" class="kp_usuarios_tipo_usuario">
<span<?php echo $kp_usuarios_list->tipo_usuario->viewAttributes() ?>><?php echo $kp_usuarios_list->tipo_usuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->idempresa->Visible) { // idempresa ?>
		<td data-name="idempresa" <?php echo $kp_usuarios_list->idempresa->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_idempresa" class="kp_usuarios_idempresa">
<span<?php echo $kp_usuarios_list->idempresa->viewAttributes() ?>><?php echo $kp_usuarios_list->idempresa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->idusuario->Visible) { // idusuario ?>
		<td data-name="idusuario" <?php echo $kp_usuarios_list->idusuario->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_idusuario" class="kp_usuarios_idusuario">
<span<?php echo $kp_usuarios_list->idusuario->viewAttributes() ?>><?php echo $kp_usuarios_list->idusuario->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_usuarios_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $kp_usuarios_list->estado->cellAttributes() ?>>
<span id="el<?php echo $kp_usuarios_list->RowCount ?>_kp_usuarios_estado" class="kp_usuarios_estado">
<span<?php echo $kp_usuarios_list->estado->viewAttributes() ?>><?php echo $kp_usuarios_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_usuarios_list->ListOptions->render("body", "right", $kp_usuarios_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_usuarios_list->isGridAdd())
		$kp_usuarios_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_usuarios->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_usuarios_list->Recordset)
	$kp_usuarios_list->Recordset->Close();
?>
<?php if (!$kp_usuarios_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_usuarios_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_usuarios_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_usuarios_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_usuarios_list->TotalRecords == 0 && !$kp_usuarios->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_usuarios_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_usuarios_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_usuarios_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_usuarios_list->terminate();
?>