<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_categoria_list = new kp_categoria_list();

// Run the page
$kp_categoria_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_categoria_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_categoria_list->isExport()) { ?>
<script>
var fkp_categorialist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_categorialist = currentForm = new ew.Form("fkp_categorialist", "list");
	fkp_categorialist.formKeyCountName = '<?php echo $kp_categoria_list->FormKeyCountName ?>';
	loadjs.done("fkp_categorialist");
});
var fkp_categorialistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_categorialistsrch = currentSearchForm = new ew.Form("fkp_categorialistsrch");

	// Dynamic selection lists
	// Filters

	fkp_categorialistsrch.filterList = <?php echo $kp_categoria_list->getFilterList() ?>;
	loadjs.done("fkp_categorialistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_categoria_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_categoria_list->TotalRecords > 0 && $kp_categoria_list->ExportOptions->visible()) { ?>
<?php $kp_categoria_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_categoria_list->ImportOptions->visible()) { ?>
<?php $kp_categoria_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_categoria_list->SearchOptions->visible()) { ?>
<?php $kp_categoria_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_categoria_list->FilterOptions->visible()) { ?>
<?php $kp_categoria_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_categoria_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_categoria_list->isExport() && !$kp_categoria->CurrentAction) { ?>
<form name="fkp_categorialistsrch" id="fkp_categorialistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_categorialistsrch-search-panel" class="<?php echo $kp_categoria_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_categoria">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_categoria_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_categoria_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_categoria_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_categoria_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_categoria_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_categoria_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_categoria_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_categoria_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_categoria_list->showPageHeader(); ?>
<?php
$kp_categoria_list->showMessage();
?>
<?php if ($kp_categoria_list->TotalRecords > 0 || $kp_categoria->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_categoria_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_categoria">
<form name="fkp_categorialist" id="fkp_categorialist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_categoria">
<div id="gmp_kp_categoria" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_categoria_list->TotalRecords > 0 || $kp_categoria_list->isGridEdit()) { ?>
<table id="tbl_kp_categorialist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_categoria->RowType = ROWTYPE_HEADER;

// Render list options
$kp_categoria_list->renderListOptions();

// Render list options (header, left)
$kp_categoria_list->ListOptions->render("header", "left");
?>
<?php if ($kp_categoria_list->idcategoria->Visible) { // idcategoria ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->idcategoria) == "") { ?>
		<th data-name="idcategoria" class="<?php echo $kp_categoria_list->idcategoria->headerCellClass() ?>"><div id="elh_kp_categoria_idcategoria" class="kp_categoria_idcategoria"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->idcategoria->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idcategoria" class="<?php echo $kp_categoria_list->idcategoria->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->idcategoria) ?>', 1);"><div id="elh_kp_categoria_idcategoria" class="kp_categoria_idcategoria">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->idcategoria->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->idcategoria->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->idcategoria->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->titulo->Visible) { // titulo ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->titulo) == "") { ?>
		<th data-name="titulo" class="<?php echo $kp_categoria_list->titulo->headerCellClass() ?>"><div id="elh_kp_categoria_titulo" class="kp_categoria_titulo"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->titulo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titulo" class="<?php echo $kp_categoria_list->titulo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->titulo) ?>', 1);"><div id="elh_kp_categoria_titulo" class="kp_categoria_titulo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->titulo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->titulo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->titulo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->nombre->Visible) { // nombre ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->nombre) == "") { ?>
		<th data-name="nombre" class="<?php echo $kp_categoria_list->nombre->headerCellClass() ?>"><div id="elh_kp_categoria_nombre" class="kp_categoria_nombre"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->nombre->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre" class="<?php echo $kp_categoria_list->nombre->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->nombre) ?>', 1);"><div id="elh_kp_categoria_nombre" class="kp_categoria_nombre">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->nombre->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->nombre->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->nombre->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->estado->Visible) { // estado ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $kp_categoria_list->estado->headerCellClass() ?>"><div id="elh_kp_categoria_estado" class="kp_categoria_estado"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $kp_categoria_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->estado) ?>', 1);"><div id="elh_kp_categoria_estado" class="kp_categoria_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->acciones->Visible) { // acciones ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->acciones) == "") { ?>
		<th data-name="acciones" class="<?php echo $kp_categoria_list->acciones->headerCellClass() ?>"><div id="elh_kp_categoria_acciones" class="kp_categoria_acciones"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->acciones->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="acciones" class="<?php echo $kp_categoria_list->acciones->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->acciones) ?>', 1);"><div id="elh_kp_categoria_acciones" class="kp_categoria_acciones">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->acciones->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->acciones->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->acciones->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->video->Visible) { // video ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->video) == "") { ?>
		<th data-name="video" class="<?php echo $kp_categoria_list->video->headerCellClass() ?>"><div id="elh_kp_categoria_video" class="kp_categoria_video"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->video->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="video" class="<?php echo $kp_categoria_list->video->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->video) ?>', 1);"><div id="elh_kp_categoria_video" class="kp_categoria_video">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->video->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->video->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->video->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->foto->Visible) { // foto ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->foto) == "") { ?>
		<th data-name="foto" class="<?php echo $kp_categoria_list->foto->headerCellClass() ?>"><div id="elh_kp_categoria_foto" class="kp_categoria_foto"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->foto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto" class="<?php echo $kp_categoria_list->foto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->foto) ?>', 1);"><div id="elh_kp_categoria_foto" class="kp_categoria_foto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->foto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->foto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->foto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->url->Visible) { // url ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->url) == "") { ?>
		<th data-name="url" class="<?php echo $kp_categoria_list->url->headerCellClass() ?>"><div id="elh_kp_categoria_url" class="kp_categoria_url"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $kp_categoria_list->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->url) ?>', 1);"><div id="elh_kp_categoria_url" class="kp_categoria_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->url->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->url->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_categoria_list->status->Visible) { // status ?>
	<?php if ($kp_categoria_list->SortUrl($kp_categoria_list->status) == "") { ?>
		<th data-name="status" class="<?php echo $kp_categoria_list->status->headerCellClass() ?>"><div id="elh_kp_categoria_status" class="kp_categoria_status"><div class="ew-table-header-caption"><?php echo $kp_categoria_list->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $kp_categoria_list->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_categoria_list->SortUrl($kp_categoria_list->status) ?>', 1);"><div id="elh_kp_categoria_status" class="kp_categoria_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_categoria_list->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_categoria_list->status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_categoria_list->status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_categoria_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_categoria_list->ExportAll && $kp_categoria_list->isExport()) {
	$kp_categoria_list->StopRecord = $kp_categoria_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_categoria_list->TotalRecords > $kp_categoria_list->StartRecord + $kp_categoria_list->DisplayRecords - 1)
		$kp_categoria_list->StopRecord = $kp_categoria_list->StartRecord + $kp_categoria_list->DisplayRecords - 1;
	else
		$kp_categoria_list->StopRecord = $kp_categoria_list->TotalRecords;
}
$kp_categoria_list->RecordCount = $kp_categoria_list->StartRecord - 1;
if ($kp_categoria_list->Recordset && !$kp_categoria_list->Recordset->EOF) {
	$kp_categoria_list->Recordset->moveFirst();
	$selectLimit = $kp_categoria_list->UseSelectLimit;
	if (!$selectLimit && $kp_categoria_list->StartRecord > 1)
		$kp_categoria_list->Recordset->move($kp_categoria_list->StartRecord - 1);
} elseif (!$kp_categoria->AllowAddDeleteRow && $kp_categoria_list->StopRecord == 0) {
	$kp_categoria_list->StopRecord = $kp_categoria->GridAddRowCount;
}

// Initialize aggregate
$kp_categoria->RowType = ROWTYPE_AGGREGATEINIT;
$kp_categoria->resetAttributes();
$kp_categoria_list->renderRow();
while ($kp_categoria_list->RecordCount < $kp_categoria_list->StopRecord) {
	$kp_categoria_list->RecordCount++;
	if ($kp_categoria_list->RecordCount >= $kp_categoria_list->StartRecord) {
		$kp_categoria_list->RowCount++;

		// Set up key count
		$kp_categoria_list->KeyCount = $kp_categoria_list->RowIndex;

		// Init row class and style
		$kp_categoria->resetAttributes();
		$kp_categoria->CssClass = "";
		if ($kp_categoria_list->isGridAdd()) {
		} else {
			$kp_categoria_list->loadRowValues($kp_categoria_list->Recordset); // Load row values
		}
		$kp_categoria->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_categoria->RowAttrs->merge(["data-rowindex" => $kp_categoria_list->RowCount, "id" => "r" . $kp_categoria_list->RowCount . "_kp_categoria", "data-rowtype" => $kp_categoria->RowType]);

		// Render row
		$kp_categoria_list->renderRow();

		// Render list options
		$kp_categoria_list->renderListOptions();
?>
	<tr <?php echo $kp_categoria->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_categoria_list->ListOptions->render("body", "left", $kp_categoria_list->RowCount);
?>
	<?php if ($kp_categoria_list->idcategoria->Visible) { // idcategoria ?>
		<td data-name="idcategoria" <?php echo $kp_categoria_list->idcategoria->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_idcategoria" class="kp_categoria_idcategoria">
<span<?php echo $kp_categoria_list->idcategoria->viewAttributes() ?>><?php echo $kp_categoria_list->idcategoria->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->titulo->Visible) { // titulo ?>
		<td data-name="titulo" <?php echo $kp_categoria_list->titulo->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_titulo" class="kp_categoria_titulo">
<span<?php echo $kp_categoria_list->titulo->viewAttributes() ?>><?php echo $kp_categoria_list->titulo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->nombre->Visible) { // nombre ?>
		<td data-name="nombre" <?php echo $kp_categoria_list->nombre->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_nombre" class="kp_categoria_nombre">
<span<?php echo $kp_categoria_list->nombre->viewAttributes() ?>><?php echo $kp_categoria_list->nombre->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $kp_categoria_list->estado->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_estado" class="kp_categoria_estado">
<span<?php echo $kp_categoria_list->estado->viewAttributes() ?>><?php echo $kp_categoria_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->acciones->Visible) { // acciones ?>
		<td data-name="acciones" <?php echo $kp_categoria_list->acciones->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_acciones" class="kp_categoria_acciones">
<span<?php echo $kp_categoria_list->acciones->viewAttributes() ?>><?php echo $kp_categoria_list->acciones->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->video->Visible) { // video ?>
		<td data-name="video" <?php echo $kp_categoria_list->video->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_video" class="kp_categoria_video">
<span<?php echo $kp_categoria_list->video->viewAttributes() ?>><?php echo $kp_categoria_list->video->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->foto->Visible) { // foto ?>
		<td data-name="foto" <?php echo $kp_categoria_list->foto->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_foto" class="kp_categoria_foto">
<span<?php echo $kp_categoria_list->foto->viewAttributes() ?>><?php echo $kp_categoria_list->foto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->url->Visible) { // url ?>
		<td data-name="url" <?php echo $kp_categoria_list->url->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_url" class="kp_categoria_url">
<span<?php echo $kp_categoria_list->url->viewAttributes() ?>><?php echo $kp_categoria_list->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_categoria_list->status->Visible) { // status ?>
		<td data-name="status" <?php echo $kp_categoria_list->status->cellAttributes() ?>>
<span id="el<?php echo $kp_categoria_list->RowCount ?>_kp_categoria_status" class="kp_categoria_status">
<span<?php echo $kp_categoria_list->status->viewAttributes() ?>><?php echo $kp_categoria_list->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_categoria_list->ListOptions->render("body", "right", $kp_categoria_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_categoria_list->isGridAdd())
		$kp_categoria_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_categoria->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_categoria_list->Recordset)
	$kp_categoria_list->Recordset->Close();
?>
<?php if (!$kp_categoria_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_categoria_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_categoria_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_categoria_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_categoria_list->TotalRecords == 0 && !$kp_categoria->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_categoria_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_categoria_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_categoria_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_categoria_list->terminate();
?>