<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$interested_list = new interested_list();

// Run the page
$interested_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$interested_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$interested_list->isExport()) { ?>
<script>
var finterestedlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	finterestedlist = currentForm = new ew.Form("finterestedlist", "list");
	finterestedlist.formKeyCountName = '<?php echo $interested_list->FormKeyCountName ?>';
	loadjs.done("finterestedlist");
});
var finterestedlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	finterestedlistsrch = currentSearchForm = new ew.Form("finterestedlistsrch");

	// Dynamic selection lists
	// Filters

	finterestedlistsrch.filterList = <?php echo $interested_list->getFilterList() ?>;
	loadjs.done("finterestedlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$interested_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($interested_list->TotalRecords > 0 && $interested_list->ExportOptions->visible()) { ?>
<?php $interested_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($interested_list->ImportOptions->visible()) { ?>
<?php $interested_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($interested_list->SearchOptions->visible()) { ?>
<?php $interested_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($interested_list->FilterOptions->visible()) { ?>
<?php $interested_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$interested_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$interested_list->isExport() && !$interested->CurrentAction) { ?>
<form name="finterestedlistsrch" id="finterestedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="finterestedlistsrch-search-panel" class="<?php echo $interested_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="interested">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $interested_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($interested_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($interested_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $interested_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($interested_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($interested_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($interested_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($interested_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $interested_list->showPageHeader(); ?>
<?php
$interested_list->showMessage();
?>
<?php if ($interested_list->TotalRecords > 0 || $interested->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($interested_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> interested">
<form name="finterestedlist" id="finterestedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="interested">
<div id="gmp_interested" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($interested_list->TotalRecords > 0 || $interested_list->isGridEdit()) { ?>
<table id="tbl_interestedlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$interested->RowType = ROWTYPE_HEADER;

// Render list options
$interested_list->renderListOptions();

// Render list options (header, left)
$interested_list->ListOptions->render("header", "left");
?>
<?php if ($interested_list->id->Visible) { // id ?>
	<?php if ($interested_list->SortUrl($interested_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $interested_list->id->headerCellClass() ?>"><div id="elh_interested_id" class="interested_id"><div class="ew-table-header-caption"><?php echo $interested_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $interested_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->id) ?>', 1);"><div id="elh_interested_id" class="interested_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->fecha->Visible) { // fecha ?>
	<?php if ($interested_list->SortUrl($interested_list->fecha) == "") { ?>
		<th data-name="fecha" class="<?php echo $interested_list->fecha->headerCellClass() ?>"><div id="elh_interested_fecha" class="interested_fecha"><div class="ew-table-header-caption"><?php echo $interested_list->fecha->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha" class="<?php echo $interested_list->fecha->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->fecha) ?>', 1);"><div id="elh_interested_fecha" class="interested_fecha">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->fecha->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->fecha->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->fecha->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->_email->Visible) { // email ?>
	<?php if ($interested_list->SortUrl($interested_list->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $interested_list->_email->headerCellClass() ?>"><div id="elh_interested__email" class="interested__email"><div class="ew-table-header-caption"><?php echo $interested_list->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $interested_list->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->_email) ?>', 1);"><div id="elh_interested__email" class="interested__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->_email->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->_email->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->cursos->Visible) { // cursos ?>
	<?php if ($interested_list->SortUrl($interested_list->cursos) == "") { ?>
		<th data-name="cursos" class="<?php echo $interested_list->cursos->headerCellClass() ?>"><div id="elh_interested_cursos" class="interested_cursos"><div class="ew-table-header-caption"><?php echo $interested_list->cursos->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cursos" class="<?php echo $interested_list->cursos->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->cursos) ?>', 1);"><div id="elh_interested_cursos" class="interested_cursos">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->cursos->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->cursos->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->cursos->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->categorias->Visible) { // categorias ?>
	<?php if ($interested_list->SortUrl($interested_list->categorias) == "") { ?>
		<th data-name="categorias" class="<?php echo $interested_list->categorias->headerCellClass() ?>"><div id="elh_interested_categorias" class="interested_categorias"><div class="ew-table-header-caption"><?php echo $interested_list->categorias->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="categorias" class="<?php echo $interested_list->categorias->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->categorias) ?>', 1);"><div id="elh_interested_categorias" class="interested_categorias">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->categorias->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->categorias->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->categorias->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->nombres->Visible) { // nombres ?>
	<?php if ($interested_list->SortUrl($interested_list->nombres) == "") { ?>
		<th data-name="nombres" class="<?php echo $interested_list->nombres->headerCellClass() ?>"><div id="elh_interested_nombres" class="interested_nombres"><div class="ew-table-header-caption"><?php echo $interested_list->nombres->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombres" class="<?php echo $interested_list->nombres->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->nombres) ?>', 1);"><div id="elh_interested_nombres" class="interested_nombres">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->nombres->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->nombres->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->nombres->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->apellidos->Visible) { // apellidos ?>
	<?php if ($interested_list->SortUrl($interested_list->apellidos) == "") { ?>
		<th data-name="apellidos" class="<?php echo $interested_list->apellidos->headerCellClass() ?>"><div id="elh_interested_apellidos" class="interested_apellidos"><div class="ew-table-header-caption"><?php echo $interested_list->apellidos->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="apellidos" class="<?php echo $interested_list->apellidos->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->apellidos) ?>', 1);"><div id="elh_interested_apellidos" class="interested_apellidos">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->apellidos->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->apellidos->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->apellidos->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->direccion->Visible) { // direccion ?>
	<?php if ($interested_list->SortUrl($interested_list->direccion) == "") { ?>
		<th data-name="direccion" class="<?php echo $interested_list->direccion->headerCellClass() ?>"><div id="elh_interested_direccion" class="interested_direccion"><div class="ew-table-header-caption"><?php echo $interested_list->direccion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="direccion" class="<?php echo $interested_list->direccion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->direccion) ?>', 1);"><div id="elh_interested_direccion" class="interested_direccion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->direccion->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->direccion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->direccion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->ciudad->Visible) { // ciudad ?>
	<?php if ($interested_list->SortUrl($interested_list->ciudad) == "") { ?>
		<th data-name="ciudad" class="<?php echo $interested_list->ciudad->headerCellClass() ?>"><div id="elh_interested_ciudad" class="interested_ciudad"><div class="ew-table-header-caption"><?php echo $interested_list->ciudad->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ciudad" class="<?php echo $interested_list->ciudad->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->ciudad) ?>', 1);"><div id="elh_interested_ciudad" class="interested_ciudad">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->ciudad->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->ciudad->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->ciudad->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->provincia->Visible) { // provincia ?>
	<?php if ($interested_list->SortUrl($interested_list->provincia) == "") { ?>
		<th data-name="provincia" class="<?php echo $interested_list->provincia->headerCellClass() ?>"><div id="elh_interested_provincia" class="interested_provincia"><div class="ew-table-header-caption"><?php echo $interested_list->provincia->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="provincia" class="<?php echo $interested_list->provincia->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->provincia) ?>', 1);"><div id="elh_interested_provincia" class="interested_provincia">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->provincia->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->provincia->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->provincia->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->pais->Visible) { // pais ?>
	<?php if ($interested_list->SortUrl($interested_list->pais) == "") { ?>
		<th data-name="pais" class="<?php echo $interested_list->pais->headerCellClass() ?>"><div id="elh_interested_pais" class="interested_pais"><div class="ew-table-header-caption"><?php echo $interested_list->pais->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pais" class="<?php echo $interested_list->pais->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->pais) ?>', 1);"><div id="elh_interested_pais" class="interested_pais">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->pais->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->pais->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->pais->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->telefono->Visible) { // telefono ?>
	<?php if ($interested_list->SortUrl($interested_list->telefono) == "") { ?>
		<th data-name="telefono" class="<?php echo $interested_list->telefono->headerCellClass() ?>"><div id="elh_interested_telefono" class="interested_telefono"><div class="ew-table-header-caption"><?php echo $interested_list->telefono->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="telefono" class="<?php echo $interested_list->telefono->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->telefono) ?>', 1);"><div id="elh_interested_telefono" class="interested_telefono">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->telefono->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->telefono->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->telefono->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->tipo_certificado->Visible) { // tipo_certificado ?>
	<?php if ($interested_list->SortUrl($interested_list->tipo_certificado) == "") { ?>
		<th data-name="tipo_certificado" class="<?php echo $interested_list->tipo_certificado->headerCellClass() ?>"><div id="elh_interested_tipo_certificado" class="interested_tipo_certificado"><div class="ew-table-header-caption"><?php echo $interested_list->tipo_certificado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_certificado" class="<?php echo $interested_list->tipo_certificado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->tipo_certificado) ?>', 1);"><div id="elh_interested_tipo_certificado" class="interested_tipo_certificado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->tipo_certificado->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->tipo_certificado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->tipo_certificado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->tipo_pago->Visible) { // tipo_pago ?>
	<?php if ($interested_list->SortUrl($interested_list->tipo_pago) == "") { ?>
		<th data-name="tipo_pago" class="<?php echo $interested_list->tipo_pago->headerCellClass() ?>"><div id="elh_interested_tipo_pago" class="interested_tipo_pago"><div class="ew-table-header-caption"><?php echo $interested_list->tipo_pago->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_pago" class="<?php echo $interested_list->tipo_pago->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->tipo_pago) ?>', 1);"><div id="elh_interested_tipo_pago" class="interested_tipo_pago">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->tipo_pago->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->tipo_pago->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->tipo_pago->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->nombretarjeta->Visible) { // nombretarjeta ?>
	<?php if ($interested_list->SortUrl($interested_list->nombretarjeta) == "") { ?>
		<th data-name="nombretarjeta" class="<?php echo $interested_list->nombretarjeta->headerCellClass() ?>"><div id="elh_interested_nombretarjeta" class="interested_nombretarjeta"><div class="ew-table-header-caption"><?php echo $interested_list->nombretarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombretarjeta" class="<?php echo $interested_list->nombretarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->nombretarjeta) ?>', 1);"><div id="elh_interested_nombretarjeta" class="interested_nombretarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->nombretarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->nombretarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->nombretarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->numerotarjeta->Visible) { // numerotarjeta ?>
	<?php if ($interested_list->SortUrl($interested_list->numerotarjeta) == "") { ?>
		<th data-name="numerotarjeta" class="<?php echo $interested_list->numerotarjeta->headerCellClass() ?>"><div id="elh_interested_numerotarjeta" class="interested_numerotarjeta"><div class="ew-table-header-caption"><?php echo $interested_list->numerotarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numerotarjeta" class="<?php echo $interested_list->numerotarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->numerotarjeta) ?>', 1);"><div id="elh_interested_numerotarjeta" class="interested_numerotarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->numerotarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->numerotarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->numerotarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->mes->Visible) { // mes ?>
	<?php if ($interested_list->SortUrl($interested_list->mes) == "") { ?>
		<th data-name="mes" class="<?php echo $interested_list->mes->headerCellClass() ?>"><div id="elh_interested_mes" class="interested_mes"><div class="ew-table-header-caption"><?php echo $interested_list->mes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mes" class="<?php echo $interested_list->mes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->mes) ?>', 1);"><div id="elh_interested_mes" class="interested_mes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->mes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->mes->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->mes->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->anio->Visible) { // anio ?>
	<?php if ($interested_list->SortUrl($interested_list->anio) == "") { ?>
		<th data-name="anio" class="<?php echo $interested_list->anio->headerCellClass() ?>"><div id="elh_interested_anio" class="interested_anio"><div class="ew-table-header-caption"><?php echo $interested_list->anio->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="anio" class="<?php echo $interested_list->anio->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->anio) ?>', 1);"><div id="elh_interested_anio" class="interested_anio">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->anio->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->anio->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->anio->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->tipo_tarjeta->Visible) { // tipo_tarjeta ?>
	<?php if ($interested_list->SortUrl($interested_list->tipo_tarjeta) == "") { ?>
		<th data-name="tipo_tarjeta" class="<?php echo $interested_list->tipo_tarjeta->headerCellClass() ?>"><div id="elh_interested_tipo_tarjeta" class="interested_tipo_tarjeta"><div class="ew-table-header-caption"><?php echo $interested_list->tipo_tarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_tarjeta" class="<?php echo $interested_list->tipo_tarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->tipo_tarjeta) ?>', 1);"><div id="elh_interested_tipo_tarjeta" class="interested_tipo_tarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->tipo_tarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->tipo_tarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->tipo_tarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->nombrepaypal->Visible) { // nombrepaypal ?>
	<?php if ($interested_list->SortUrl($interested_list->nombrepaypal) == "") { ?>
		<th data-name="nombrepaypal" class="<?php echo $interested_list->nombrepaypal->headerCellClass() ?>"><div id="elh_interested_nombrepaypal" class="interested_nombrepaypal"><div class="ew-table-header-caption"><?php echo $interested_list->nombrepaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombrepaypal" class="<?php echo $interested_list->nombrepaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->nombrepaypal) ?>', 1);"><div id="elh_interested_nombrepaypal" class="interested_nombrepaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->nombrepaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->nombrepaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->nombrepaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->montopaypal->Visible) { // montopaypal ?>
	<?php if ($interested_list->SortUrl($interested_list->montopaypal) == "") { ?>
		<th data-name="montopaypal" class="<?php echo $interested_list->montopaypal->headerCellClass() ?>"><div id="elh_interested_montopaypal" class="interested_montopaypal"><div class="ew-table-header-caption"><?php echo $interested_list->montopaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="montopaypal" class="<?php echo $interested_list->montopaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->montopaypal) ?>', 1);"><div id="elh_interested_montopaypal" class="interested_montopaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->montopaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->montopaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->montopaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->emailpaypal->Visible) { // emailpaypal ?>
	<?php if ($interested_list->SortUrl($interested_list->emailpaypal) == "") { ?>
		<th data-name="emailpaypal" class="<?php echo $interested_list->emailpaypal->headerCellClass() ?>"><div id="elh_interested_emailpaypal" class="interested_emailpaypal"><div class="ew-table-header-caption"><?php echo $interested_list->emailpaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emailpaypal" class="<?php echo $interested_list->emailpaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->emailpaypal) ?>', 1);"><div id="elh_interested_emailpaypal" class="interested_emailpaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->emailpaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->emailpaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->emailpaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->don->Visible) { // don ?>
	<?php if ($interested_list->SortUrl($interested_list->don) == "") { ?>
		<th data-name="don" class="<?php echo $interested_list->don->headerCellClass() ?>"><div id="elh_interested_don" class="interested_don"><div class="ew-table-header-caption"><?php echo $interested_list->don->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="don" class="<?php echo $interested_list->don->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->don) ?>', 1);"><div id="elh_interested_don" class="interested_don">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->don->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interested_list->don->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->don->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interested_list->tipo_condicion->Visible) { // tipo_condicion ?>
	<?php if ($interested_list->SortUrl($interested_list->tipo_condicion) == "") { ?>
		<th data-name="tipo_condicion" class="<?php echo $interested_list->tipo_condicion->headerCellClass() ?>"><div id="elh_interested_tipo_condicion" class="interested_tipo_condicion"><div class="ew-table-header-caption"><?php echo $interested_list->tipo_condicion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_condicion" class="<?php echo $interested_list->tipo_condicion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interested_list->SortUrl($interested_list->tipo_condicion) ?>', 1);"><div id="elh_interested_tipo_condicion" class="interested_tipo_condicion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interested_list->tipo_condicion->caption() ?></span><span class="ew-table-header-sort"><?php if ($interested_list->tipo_condicion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interested_list->tipo_condicion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$interested_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($interested_list->ExportAll && $interested_list->isExport()) {
	$interested_list->StopRecord = $interested_list->TotalRecords;
} else {

	// Set the last record to display
	if ($interested_list->TotalRecords > $interested_list->StartRecord + $interested_list->DisplayRecords - 1)
		$interested_list->StopRecord = $interested_list->StartRecord + $interested_list->DisplayRecords - 1;
	else
		$interested_list->StopRecord = $interested_list->TotalRecords;
}
$interested_list->RecordCount = $interested_list->StartRecord - 1;
if ($interested_list->Recordset && !$interested_list->Recordset->EOF) {
	$interested_list->Recordset->moveFirst();
	$selectLimit = $interested_list->UseSelectLimit;
	if (!$selectLimit && $interested_list->StartRecord > 1)
		$interested_list->Recordset->move($interested_list->StartRecord - 1);
} elseif (!$interested->AllowAddDeleteRow && $interested_list->StopRecord == 0) {
	$interested_list->StopRecord = $interested->GridAddRowCount;
}

// Initialize aggregate
$interested->RowType = ROWTYPE_AGGREGATEINIT;
$interested->resetAttributes();
$interested_list->renderRow();
while ($interested_list->RecordCount < $interested_list->StopRecord) {
	$interested_list->RecordCount++;
	if ($interested_list->RecordCount >= $interested_list->StartRecord) {
		$interested_list->RowCount++;

		// Set up key count
		$interested_list->KeyCount = $interested_list->RowIndex;

		// Init row class and style
		$interested->resetAttributes();
		$interested->CssClass = "";
		if ($interested_list->isGridAdd()) {
		} else {
			$interested_list->loadRowValues($interested_list->Recordset); // Load row values
		}
		$interested->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$interested->RowAttrs->merge(["data-rowindex" => $interested_list->RowCount, "id" => "r" . $interested_list->RowCount . "_interested", "data-rowtype" => $interested->RowType]);

		// Render row
		$interested_list->renderRow();

		// Render list options
		$interested_list->renderListOptions();
?>
	<tr <?php echo $interested->rowAttributes() ?>>
<?php

// Render list options (body, left)
$interested_list->ListOptions->render("body", "left", $interested_list->RowCount);
?>
	<?php if ($interested_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $interested_list->id->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_id" class="interested_id">
<span<?php echo $interested_list->id->viewAttributes() ?>><?php echo $interested_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->fecha->Visible) { // fecha ?>
		<td data-name="fecha" <?php echo $interested_list->fecha->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_fecha" class="interested_fecha">
<span<?php echo $interested_list->fecha->viewAttributes() ?>><?php echo $interested_list->fecha->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->_email->Visible) { // email ?>
		<td data-name="_email" <?php echo $interested_list->_email->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested__email" class="interested__email">
<span<?php echo $interested_list->_email->viewAttributes() ?>><?php echo $interested_list->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->cursos->Visible) { // cursos ?>
		<td data-name="cursos" <?php echo $interested_list->cursos->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_cursos" class="interested_cursos">
<span<?php echo $interested_list->cursos->viewAttributes() ?>><?php echo $interested_list->cursos->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->categorias->Visible) { // categorias ?>
		<td data-name="categorias" <?php echo $interested_list->categorias->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_categorias" class="interested_categorias">
<span<?php echo $interested_list->categorias->viewAttributes() ?>><?php echo $interested_list->categorias->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->nombres->Visible) { // nombres ?>
		<td data-name="nombres" <?php echo $interested_list->nombres->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_nombres" class="interested_nombres">
<span<?php echo $interested_list->nombres->viewAttributes() ?>><?php echo $interested_list->nombres->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->apellidos->Visible) { // apellidos ?>
		<td data-name="apellidos" <?php echo $interested_list->apellidos->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_apellidos" class="interested_apellidos">
<span<?php echo $interested_list->apellidos->viewAttributes() ?>><?php echo $interested_list->apellidos->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->direccion->Visible) { // direccion ?>
		<td data-name="direccion" <?php echo $interested_list->direccion->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_direccion" class="interested_direccion">
<span<?php echo $interested_list->direccion->viewAttributes() ?>><?php echo $interested_list->direccion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->ciudad->Visible) { // ciudad ?>
		<td data-name="ciudad" <?php echo $interested_list->ciudad->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_ciudad" class="interested_ciudad">
<span<?php echo $interested_list->ciudad->viewAttributes() ?>><?php echo $interested_list->ciudad->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->provincia->Visible) { // provincia ?>
		<td data-name="provincia" <?php echo $interested_list->provincia->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_provincia" class="interested_provincia">
<span<?php echo $interested_list->provincia->viewAttributes() ?>><?php echo $interested_list->provincia->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->pais->Visible) { // pais ?>
		<td data-name="pais" <?php echo $interested_list->pais->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_pais" class="interested_pais">
<span<?php echo $interested_list->pais->viewAttributes() ?>><?php echo $interested_list->pais->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->telefono->Visible) { // telefono ?>
		<td data-name="telefono" <?php echo $interested_list->telefono->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_telefono" class="interested_telefono">
<span<?php echo $interested_list->telefono->viewAttributes() ?>><?php echo $interested_list->telefono->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->tipo_certificado->Visible) { // tipo_certificado ?>
		<td data-name="tipo_certificado" <?php echo $interested_list->tipo_certificado->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_tipo_certificado" class="interested_tipo_certificado">
<span<?php echo $interested_list->tipo_certificado->viewAttributes() ?>><?php echo $interested_list->tipo_certificado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->tipo_pago->Visible) { // tipo_pago ?>
		<td data-name="tipo_pago" <?php echo $interested_list->tipo_pago->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_tipo_pago" class="interested_tipo_pago">
<span<?php echo $interested_list->tipo_pago->viewAttributes() ?>><?php echo $interested_list->tipo_pago->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->nombretarjeta->Visible) { // nombretarjeta ?>
		<td data-name="nombretarjeta" <?php echo $interested_list->nombretarjeta->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_nombretarjeta" class="interested_nombretarjeta">
<span<?php echo $interested_list->nombretarjeta->viewAttributes() ?>><?php echo $interested_list->nombretarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->numerotarjeta->Visible) { // numerotarjeta ?>
		<td data-name="numerotarjeta" <?php echo $interested_list->numerotarjeta->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_numerotarjeta" class="interested_numerotarjeta">
<span<?php echo $interested_list->numerotarjeta->viewAttributes() ?>><?php echo $interested_list->numerotarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->mes->Visible) { // mes ?>
		<td data-name="mes" <?php echo $interested_list->mes->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_mes" class="interested_mes">
<span<?php echo $interested_list->mes->viewAttributes() ?>><?php echo $interested_list->mes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->anio->Visible) { // anio ?>
		<td data-name="anio" <?php echo $interested_list->anio->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_anio" class="interested_anio">
<span<?php echo $interested_list->anio->viewAttributes() ?>><?php echo $interested_list->anio->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->tipo_tarjeta->Visible) { // tipo_tarjeta ?>
		<td data-name="tipo_tarjeta" <?php echo $interested_list->tipo_tarjeta->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_tipo_tarjeta" class="interested_tipo_tarjeta">
<span<?php echo $interested_list->tipo_tarjeta->viewAttributes() ?>><?php echo $interested_list->tipo_tarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->nombrepaypal->Visible) { // nombrepaypal ?>
		<td data-name="nombrepaypal" <?php echo $interested_list->nombrepaypal->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_nombrepaypal" class="interested_nombrepaypal">
<span<?php echo $interested_list->nombrepaypal->viewAttributes() ?>><?php echo $interested_list->nombrepaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->montopaypal->Visible) { // montopaypal ?>
		<td data-name="montopaypal" <?php echo $interested_list->montopaypal->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_montopaypal" class="interested_montopaypal">
<span<?php echo $interested_list->montopaypal->viewAttributes() ?>><?php echo $interested_list->montopaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->emailpaypal->Visible) { // emailpaypal ?>
		<td data-name="emailpaypal" <?php echo $interested_list->emailpaypal->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_emailpaypal" class="interested_emailpaypal">
<span<?php echo $interested_list->emailpaypal->viewAttributes() ?>><?php echo $interested_list->emailpaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->don->Visible) { // don ?>
		<td data-name="don" <?php echo $interested_list->don->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_don" class="interested_don">
<span<?php echo $interested_list->don->viewAttributes() ?>><?php echo $interested_list->don->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interested_list->tipo_condicion->Visible) { // tipo_condicion ?>
		<td data-name="tipo_condicion" <?php echo $interested_list->tipo_condicion->cellAttributes() ?>>
<span id="el<?php echo $interested_list->RowCount ?>_interested_tipo_condicion" class="interested_tipo_condicion">
<span<?php echo $interested_list->tipo_condicion->viewAttributes() ?>><?php echo $interested_list->tipo_condicion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$interested_list->ListOptions->render("body", "right", $interested_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$interested_list->isGridAdd())
		$interested_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$interested->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($interested_list->Recordset)
	$interested_list->Recordset->Close();
?>
<?php if (!$interested_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$interested_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $interested_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $interested_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($interested_list->TotalRecords == 0 && !$interested->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $interested_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$interested_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$interested_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$interested_list->terminate();
?>