<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$estados_add = new estados_add();

// Run the page
$estados_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$estados_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var festadosadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	festadosadd = currentForm = new ew.Form("festadosadd", "add");

	// Validate form
	festadosadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($estados_add->color->Required) { ?>
				elm = this.getElements("x" + infix + "_color");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $estados_add->color->caption(), $estados_add->color->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($estados_add->nombre->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $estados_add->nombre->caption(), $estados_add->nombre->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	festadosadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	festadosadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("festadosadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $estados_add->showPageHeader(); ?>
<?php
$estados_add->showMessage();
?>
<form name="festadosadd" id="festadosadd" class="<?php echo $estados_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="estados">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$estados_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($estados_add->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_estados_color" for="x_color" class="<?php echo $estados_add->LeftColumnClass ?>"><?php echo $estados_add->color->caption() ?><?php echo $estados_add->color->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $estados_add->RightColumnClass ?>"><div <?php echo $estados_add->color->cellAttributes() ?>>
<span id="el_estados_color">
<input type="text" data-table="estados" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($estados_add->color->getPlaceHolder()) ?>" value="<?php echo $estados_add->color->EditValue ?>"<?php echo $estados_add->color->editAttributes() ?>>
</span>
<?php echo $estados_add->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($estados_add->nombre->Visible) { // nombre ?>
	<div id="r_nombre" class="form-group row">
		<label id="elh_estados_nombre" for="x_nombre" class="<?php echo $estados_add->LeftColumnClass ?>"><?php echo $estados_add->nombre->caption() ?><?php echo $estados_add->nombre->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $estados_add->RightColumnClass ?>"><div <?php echo $estados_add->nombre->cellAttributes() ?>>
<span id="el_estados_nombre">
<input type="text" data-table="estados" data-field="x_nombre" name="x_nombre" id="x_nombre" size="30" maxlength="80" placeholder="<?php echo HtmlEncode($estados_add->nombre->getPlaceHolder()) ?>" value="<?php echo $estados_add->nombre->EditValue ?>"<?php echo $estados_add->nombre->editAttributes() ?>>
</span>
<?php echo $estados_add->nombre->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$estados_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $estados_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $estados_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$estados_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$estados_add->terminate();
?>