<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detalle_proyecto_view = new detalle_proyecto_view();

// Run the page
$detalle_proyecto_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detalle_proyecto_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$detalle_proyecto_view->isExport()) { ?>
<script>
var fdetalle_proyectoview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdetalle_proyectoview = currentForm = new ew.Form("fdetalle_proyectoview", "view");
	loadjs.done("fdetalle_proyectoview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$detalle_proyecto_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $detalle_proyecto_view->ExportOptions->render("body") ?>
<?php $detalle_proyecto_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $detalle_proyecto_view->showPageHeader(); ?>
<?php
$detalle_proyecto_view->showMessage();
?>
<form name="fdetalle_proyectoview" id="fdetalle_proyectoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detalle_proyecto">
<input type="hidden" name="modal" value="<?php echo (int)$detalle_proyecto_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($detalle_proyecto_view->id_detalle->Visible) { // id_detalle ?>
	<tr id="r_id_detalle">
		<td class="<?php echo $detalle_proyecto_view->TableLeftColumnClass ?>"><span id="elh_detalle_proyecto_id_detalle"><?php echo $detalle_proyecto_view->id_detalle->caption() ?></span></td>
		<td data-name="id_detalle" <?php echo $detalle_proyecto_view->id_detalle->cellAttributes() ?>>
<span id="el_detalle_proyecto_id_detalle">
<span<?php echo $detalle_proyecto_view->id_detalle->viewAttributes() ?>><?php echo $detalle_proyecto_view->id_detalle->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detalle_proyecto_view->id_proyecto->Visible) { // id_proyecto ?>
	<tr id="r_id_proyecto">
		<td class="<?php echo $detalle_proyecto_view->TableLeftColumnClass ?>"><span id="elh_detalle_proyecto_id_proyecto"><?php echo $detalle_proyecto_view->id_proyecto->caption() ?></span></td>
		<td data-name="id_proyecto" <?php echo $detalle_proyecto_view->id_proyecto->cellAttributes() ?>>
<span id="el_detalle_proyecto_id_proyecto">
<span<?php echo $detalle_proyecto_view->id_proyecto->viewAttributes() ?>><?php echo $detalle_proyecto_view->id_proyecto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detalle_proyecto_view->nombre_etapa->Visible) { // nombre_etapa ?>
	<tr id="r_nombre_etapa">
		<td class="<?php echo $detalle_proyecto_view->TableLeftColumnClass ?>"><span id="elh_detalle_proyecto_nombre_etapa"><?php echo $detalle_proyecto_view->nombre_etapa->caption() ?></span></td>
		<td data-name="nombre_etapa" <?php echo $detalle_proyecto_view->nombre_etapa->cellAttributes() ?>>
<span id="el_detalle_proyecto_nombre_etapa">
<span<?php echo $detalle_proyecto_view->nombre_etapa->viewAttributes() ?>><?php echo $detalle_proyecto_view->nombre_etapa->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detalle_proyecto_view->foto->Visible) { // foto ?>
	<tr id="r_foto">
		<td class="<?php echo $detalle_proyecto_view->TableLeftColumnClass ?>"><span id="elh_detalle_proyecto_foto"><?php echo $detalle_proyecto_view->foto->caption() ?></span></td>
		<td data-name="foto" <?php echo $detalle_proyecto_view->foto->cellAttributes() ?>>
<span id="el_detalle_proyecto_foto">
<span<?php echo $detalle_proyecto_view->foto->viewAttributes() ?>><?php echo $detalle_proyecto_view->foto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detalle_proyecto_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $detalle_proyecto_view->TableLeftColumnClass ?>"><span id="elh_detalle_proyecto_estado"><?php echo $detalle_proyecto_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $detalle_proyecto_view->estado->cellAttributes() ?>>
<span id="el_detalle_proyecto_estado">
<span<?php echo $detalle_proyecto_view->estado->viewAttributes() ?>><?php echo $detalle_proyecto_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$detalle_proyecto_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$detalle_proyecto_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$detalle_proyecto_view->terminate();
?>