<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cuota_list = new cuota_list();

// Run the page
$cuota_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cuota_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$cuota_list->isExport()) { ?>
<script>
var fcuotalist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fcuotalist = currentForm = new ew.Form("fcuotalist", "list");
	fcuotalist.formKeyCountName = '<?php echo $cuota_list->FormKeyCountName ?>';
	loadjs.done("fcuotalist");
});
var fcuotalistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fcuotalistsrch = currentSearchForm = new ew.Form("fcuotalistsrch");

	// Dynamic selection lists
	// Filters

	fcuotalistsrch.filterList = <?php echo $cuota_list->getFilterList() ?>;
	loadjs.done("fcuotalistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$cuota_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cuota_list->TotalRecords > 0 && $cuota_list->ExportOptions->visible()) { ?>
<?php $cuota_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cuota_list->ImportOptions->visible()) { ?>
<?php $cuota_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cuota_list->SearchOptions->visible()) { ?>
<?php $cuota_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cuota_list->FilterOptions->visible()) { ?>
<?php $cuota_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$cuota_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cuota_list->isExport() && !$cuota->CurrentAction) { ?>
<form name="fcuotalistsrch" id="fcuotalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fcuotalistsrch-search-panel" class="<?php echo $cuota_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cuota">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $cuota_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($cuota_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($cuota_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cuota_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cuota_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cuota_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cuota_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cuota_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $cuota_list->showPageHeader(); ?>
<?php
$cuota_list->showMessage();
?>
<?php if ($cuota_list->TotalRecords > 0 || $cuota->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cuota_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cuota">
<form name="fcuotalist" id="fcuotalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cuota">
<div id="gmp_cuota" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($cuota_list->TotalRecords > 0 || $cuota_list->isGridEdit()) { ?>
<table id="tbl_cuotalist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cuota->RowType = ROWTYPE_HEADER;

// Render list options
$cuota_list->renderListOptions();

// Render list options (header, left)
$cuota_list->ListOptions->render("header", "left");
?>
<?php if ($cuota_list->id_cuota->Visible) { // id_cuota ?>
	<?php if ($cuota_list->SortUrl($cuota_list->id_cuota) == "") { ?>
		<th data-name="id_cuota" class="<?php echo $cuota_list->id_cuota->headerCellClass() ?>"><div id="elh_cuota_id_cuota" class="cuota_id_cuota"><div class="ew-table-header-caption"><?php echo $cuota_list->id_cuota->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_cuota" class="<?php echo $cuota_list->id_cuota->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->id_cuota) ?>', 1);"><div id="elh_cuota_id_cuota" class="cuota_id_cuota">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->id_cuota->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->id_cuota->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->id_cuota->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->id_producto->Visible) { // id_producto ?>
	<?php if ($cuota_list->SortUrl($cuota_list->id_producto) == "") { ?>
		<th data-name="id_producto" class="<?php echo $cuota_list->id_producto->headerCellClass() ?>"><div id="elh_cuota_id_producto" class="cuota_id_producto"><div class="ew-table-header-caption"><?php echo $cuota_list->id_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_producto" class="<?php echo $cuota_list->id_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->id_producto) ?>', 1);"><div id="elh_cuota_id_producto" class="cuota_id_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->id_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->id_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->id_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->interes->Visible) { // interes ?>
	<?php if ($cuota_list->SortUrl($cuota_list->interes) == "") { ?>
		<th data-name="interes" class="<?php echo $cuota_list->interes->headerCellClass() ?>"><div id="elh_cuota_interes" class="cuota_interes"><div class="ew-table-header-caption"><?php echo $cuota_list->interes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="interes" class="<?php echo $cuota_list->interes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->interes) ?>', 1);"><div id="elh_cuota_interes" class="cuota_interes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->interes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->interes->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->interes->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->plazo_meses->Visible) { // plazo_meses ?>
	<?php if ($cuota_list->SortUrl($cuota_list->plazo_meses) == "") { ?>
		<th data-name="plazo_meses" class="<?php echo $cuota_list->plazo_meses->headerCellClass() ?>"><div id="elh_cuota_plazo_meses" class="cuota_plazo_meses"><div class="ew-table-header-caption"><?php echo $cuota_list->plazo_meses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plazo_meses" class="<?php echo $cuota_list->plazo_meses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->plazo_meses) ?>', 1);"><div id="elh_cuota_plazo_meses" class="cuota_plazo_meses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->plazo_meses->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->plazo_meses->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->plazo_meses->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->monto->Visible) { // monto ?>
	<?php if ($cuota_list->SortUrl($cuota_list->monto) == "") { ?>
		<th data-name="monto" class="<?php echo $cuota_list->monto->headerCellClass() ?>"><div id="elh_cuota_monto" class="cuota_monto"><div class="ew-table-header-caption"><?php echo $cuota_list->monto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="monto" class="<?php echo $cuota_list->monto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->monto) ?>', 1);"><div id="elh_cuota_monto" class="cuota_monto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->monto->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->monto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->monto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->pagar_mensual->Visible) { // pagar_mensual ?>
	<?php if ($cuota_list->SortUrl($cuota_list->pagar_mensual) == "") { ?>
		<th data-name="pagar_mensual" class="<?php echo $cuota_list->pagar_mensual->headerCellClass() ?>"><div id="elh_cuota_pagar_mensual" class="cuota_pagar_mensual"><div class="ew-table-header-caption"><?php echo $cuota_list->pagar_mensual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pagar_mensual" class="<?php echo $cuota_list->pagar_mensual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->pagar_mensual) ?>', 1);"><div id="elh_cuota_pagar_mensual" class="cuota_pagar_mensual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->pagar_mensual->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->pagar_mensual->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->pagar_mensual->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cuota_list->estado->Visible) { // estado ?>
	<?php if ($cuota_list->SortUrl($cuota_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $cuota_list->estado->headerCellClass() ?>"><div id="elh_cuota_estado" class="cuota_estado"><div class="ew-table-header-caption"><?php echo $cuota_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $cuota_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $cuota_list->SortUrl($cuota_list->estado) ?>', 1);"><div id="elh_cuota_estado" class="cuota_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cuota_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($cuota_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($cuota_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cuota_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cuota_list->ExportAll && $cuota_list->isExport()) {
	$cuota_list->StopRecord = $cuota_list->TotalRecords;
} else {

	// Set the last record to display
	if ($cuota_list->TotalRecords > $cuota_list->StartRecord + $cuota_list->DisplayRecords - 1)
		$cuota_list->StopRecord = $cuota_list->StartRecord + $cuota_list->DisplayRecords - 1;
	else
		$cuota_list->StopRecord = $cuota_list->TotalRecords;
}
$cuota_list->RecordCount = $cuota_list->StartRecord - 1;
if ($cuota_list->Recordset && !$cuota_list->Recordset->EOF) {
	$cuota_list->Recordset->moveFirst();
	$selectLimit = $cuota_list->UseSelectLimit;
	if (!$selectLimit && $cuota_list->StartRecord > 1)
		$cuota_list->Recordset->move($cuota_list->StartRecord - 1);
} elseif (!$cuota->AllowAddDeleteRow && $cuota_list->StopRecord == 0) {
	$cuota_list->StopRecord = $cuota->GridAddRowCount;
}

// Initialize aggregate
$cuota->RowType = ROWTYPE_AGGREGATEINIT;
$cuota->resetAttributes();
$cuota_list->renderRow();
while ($cuota_list->RecordCount < $cuota_list->StopRecord) {
	$cuota_list->RecordCount++;
	if ($cuota_list->RecordCount >= $cuota_list->StartRecord) {
		$cuota_list->RowCount++;

		// Set up key count
		$cuota_list->KeyCount = $cuota_list->RowIndex;

		// Init row class and style
		$cuota->resetAttributes();
		$cuota->CssClass = "";
		if ($cuota_list->isGridAdd()) {
		} else {
			$cuota_list->loadRowValues($cuota_list->Recordset); // Load row values
		}
		$cuota->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cuota->RowAttrs->merge(["data-rowindex" => $cuota_list->RowCount, "id" => "r" . $cuota_list->RowCount . "_cuota", "data-rowtype" => $cuota->RowType]);

		// Render row
		$cuota_list->renderRow();

		// Render list options
		$cuota_list->renderListOptions();
?>
	<tr <?php echo $cuota->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cuota_list->ListOptions->render("body", "left", $cuota_list->RowCount);
?>
	<?php if ($cuota_list->id_cuota->Visible) { // id_cuota ?>
		<td data-name="id_cuota" <?php echo $cuota_list->id_cuota->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_id_cuota" class="cuota_id_cuota">
<span<?php echo $cuota_list->id_cuota->viewAttributes() ?>><?php echo $cuota_list->id_cuota->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->id_producto->Visible) { // id_producto ?>
		<td data-name="id_producto" <?php echo $cuota_list->id_producto->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_id_producto" class="cuota_id_producto">
<span<?php echo $cuota_list->id_producto->viewAttributes() ?>><?php echo $cuota_list->id_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->interes->Visible) { // interes ?>
		<td data-name="interes" <?php echo $cuota_list->interes->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_interes" class="cuota_interes">
<span<?php echo $cuota_list->interes->viewAttributes() ?>><?php echo $cuota_list->interes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->plazo_meses->Visible) { // plazo_meses ?>
		<td data-name="plazo_meses" <?php echo $cuota_list->plazo_meses->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_plazo_meses" class="cuota_plazo_meses">
<span<?php echo $cuota_list->plazo_meses->viewAttributes() ?>><?php echo $cuota_list->plazo_meses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->monto->Visible) { // monto ?>
		<td data-name="monto" <?php echo $cuota_list->monto->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_monto" class="cuota_monto">
<span<?php echo $cuota_list->monto->viewAttributes() ?>><?php echo $cuota_list->monto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->pagar_mensual->Visible) { // pagar_mensual ?>
		<td data-name="pagar_mensual" <?php echo $cuota_list->pagar_mensual->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_pagar_mensual" class="cuota_pagar_mensual">
<span<?php echo $cuota_list->pagar_mensual->viewAttributes() ?>><?php echo $cuota_list->pagar_mensual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cuota_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $cuota_list->estado->cellAttributes() ?>>
<span id="el<?php echo $cuota_list->RowCount ?>_cuota_estado" class="cuota_estado">
<span<?php echo $cuota_list->estado->viewAttributes() ?>><?php echo $cuota_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cuota_list->ListOptions->render("body", "right", $cuota_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$cuota_list->isGridAdd())
		$cuota_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$cuota->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cuota_list->Recordset)
	$cuota_list->Recordset->Close();
?>
<?php if (!$cuota_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cuota_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $cuota_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cuota_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cuota_list->TotalRecords == 0 && !$cuota->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cuota_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cuota_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$cuota_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$cuota_list->terminate();
?>