<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clientes_list = new clientes_list();

// Run the page
$clientes_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clientes_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$clientes_list->isExport()) { ?>
<script>
var fclienteslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fclienteslist = currentForm = new ew.Form("fclienteslist", "list");
	fclienteslist.formKeyCountName = '<?php echo $clientes_list->FormKeyCountName ?>';
	loadjs.done("fclienteslist");
});
var fclienteslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fclienteslistsrch = currentSearchForm = new ew.Form("fclienteslistsrch");

	// Dynamic selection lists
	// Filters

	fclienteslistsrch.filterList = <?php echo $clientes_list->getFilterList() ?>;
	loadjs.done("fclienteslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$clientes_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($clientes_list->TotalRecords > 0 && $clientes_list->ExportOptions->visible()) { ?>
<?php $clientes_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($clientes_list->ImportOptions->visible()) { ?>
<?php $clientes_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($clientes_list->SearchOptions->visible()) { ?>
<?php $clientes_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($clientes_list->FilterOptions->visible()) { ?>
<?php $clientes_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$clientes_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$clientes_list->isExport() && !$clientes->CurrentAction) { ?>
<form name="fclienteslistsrch" id="fclienteslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fclienteslistsrch-search-panel" class="<?php echo $clientes_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="clientes">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $clientes_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($clientes_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($clientes_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $clientes_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($clientes_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($clientes_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($clientes_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($clientes_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $clientes_list->showPageHeader(); ?>
<?php
$clientes_list->showMessage();
?>
<?php if ($clientes_list->TotalRecords > 0 || $clientes->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($clientes_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> clientes">
<form name="fclienteslist" id="fclienteslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clientes">
<div id="gmp_clientes" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($clientes_list->TotalRecords > 0 || $clientes_list->isGridEdit()) { ?>
<table id="tbl_clienteslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$clientes->RowType = ROWTYPE_HEADER;

// Render list options
$clientes_list->renderListOptions();

// Render list options (header, left)
$clientes_list->ListOptions->render("header", "left");
?>
<?php if ($clientes_list->id_cliente->Visible) { // id_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->id_cliente) == "") { ?>
		<th data-name="id_cliente" class="<?php echo $clientes_list->id_cliente->headerCellClass() ?>"><div id="elh_clientes_id_cliente" class="clientes_id_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->id_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_cliente" class="<?php echo $clientes_list->id_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->id_cliente) ?>', 1);"><div id="elh_clientes_id_cliente" class="clientes_id_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->id_cliente->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->id_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->id_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->nombre_cliente->Visible) { // nombre_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->nombre_cliente) == "") { ?>
		<th data-name="nombre_cliente" class="<?php echo $clientes_list->nombre_cliente->headerCellClass() ?>"><div id="elh_clientes_nombre_cliente" class="clientes_nombre_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->nombre_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre_cliente" class="<?php echo $clientes_list->nombre_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->nombre_cliente) ?>', 1);"><div id="elh_clientes_nombre_cliente" class="clientes_nombre_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->nombre_cliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->nombre_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->nombre_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->telefono_cliente->Visible) { // telefono_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->telefono_cliente) == "") { ?>
		<th data-name="telefono_cliente" class="<?php echo $clientes_list->telefono_cliente->headerCellClass() ?>"><div id="elh_clientes_telefono_cliente" class="clientes_telefono_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->telefono_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="telefono_cliente" class="<?php echo $clientes_list->telefono_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->telefono_cliente) ?>', 1);"><div id="elh_clientes_telefono_cliente" class="clientes_telefono_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->telefono_cliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->telefono_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->telefono_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->email_cliente->Visible) { // email_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->email_cliente) == "") { ?>
		<th data-name="email_cliente" class="<?php echo $clientes_list->email_cliente->headerCellClass() ?>"><div id="elh_clientes_email_cliente" class="clientes_email_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->email_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="email_cliente" class="<?php echo $clientes_list->email_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->email_cliente) ?>', 1);"><div id="elh_clientes_email_cliente" class="clientes_email_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->email_cliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->email_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->email_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->direccion_cliente->Visible) { // direccion_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->direccion_cliente) == "") { ?>
		<th data-name="direccion_cliente" class="<?php echo $clientes_list->direccion_cliente->headerCellClass() ?>"><div id="elh_clientes_direccion_cliente" class="clientes_direccion_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->direccion_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="direccion_cliente" class="<?php echo $clientes_list->direccion_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->direccion_cliente) ?>', 1);"><div id="elh_clientes_direccion_cliente" class="clientes_direccion_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->direccion_cliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->direccion_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->direccion_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->status_cliente->Visible) { // status_cliente ?>
	<?php if ($clientes_list->SortUrl($clientes_list->status_cliente) == "") { ?>
		<th data-name="status_cliente" class="<?php echo $clientes_list->status_cliente->headerCellClass() ?>"><div id="elh_clientes_status_cliente" class="clientes_status_cliente"><div class="ew-table-header-caption"><?php echo $clientes_list->status_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_cliente" class="<?php echo $clientes_list->status_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->status_cliente) ?>', 1);"><div id="elh_clientes_status_cliente" class="clientes_status_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->status_cliente->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->status_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->status_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->date_added->Visible) { // date_added ?>
	<?php if ($clientes_list->SortUrl($clientes_list->date_added) == "") { ?>
		<th data-name="date_added" class="<?php echo $clientes_list->date_added->headerCellClass() ?>"><div id="elh_clientes_date_added" class="clientes_date_added"><div class="ew-table-header-caption"><?php echo $clientes_list->date_added->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_added" class="<?php echo $clientes_list->date_added->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->date_added) ?>', 1);"><div id="elh_clientes_date_added" class="clientes_date_added">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->date_added->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->date_added->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->date_added->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->doc->Visible) { // doc ?>
	<?php if ($clientes_list->SortUrl($clientes_list->doc) == "") { ?>
		<th data-name="doc" class="<?php echo $clientes_list->doc->headerCellClass() ?>"><div id="elh_clientes_doc" class="clientes_doc"><div class="ew-table-header-caption"><?php echo $clientes_list->doc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="doc" class="<?php echo $clientes_list->doc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->doc) ?>', 1);"><div id="elh_clientes_doc" class="clientes_doc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->doc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->doc->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->doc->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->vendedor->Visible) { // vendedor ?>
	<?php if ($clientes_list->SortUrl($clientes_list->vendedor) == "") { ?>
		<th data-name="vendedor" class="<?php echo $clientes_list->vendedor->headerCellClass() ?>"><div id="elh_clientes_vendedor" class="clientes_vendedor"><div class="ew-table-header-caption"><?php echo $clientes_list->vendedor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vendedor" class="<?php echo $clientes_list->vendedor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->vendedor) ?>', 1);"><div id="elh_clientes_vendedor" class="clientes_vendedor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->vendedor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->vendedor->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->vendedor->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->tipo1->Visible) { // tipo1 ?>
	<?php if ($clientes_list->SortUrl($clientes_list->tipo1) == "") { ?>
		<th data-name="tipo1" class="<?php echo $clientes_list->tipo1->headerCellClass() ?>"><div id="elh_clientes_tipo1" class="clientes_tipo1"><div class="ew-table-header-caption"><?php echo $clientes_list->tipo1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo1" class="<?php echo $clientes_list->tipo1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->tipo1) ?>', 1);"><div id="elh_clientes_tipo1" class="clientes_tipo1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->tipo1->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->tipo1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->tipo1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->tienda->Visible) { // tienda ?>
	<?php if ($clientes_list->SortUrl($clientes_list->tienda) == "") { ?>
		<th data-name="tienda" class="<?php echo $clientes_list->tienda->headerCellClass() ?>"><div id="elh_clientes_tienda" class="clientes_tienda"><div class="ew-table-header-caption"><?php echo $clientes_list->tienda->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tienda" class="<?php echo $clientes_list->tienda->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->tienda) ?>', 1);"><div id="elh_clientes_tienda" class="clientes_tienda">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->tienda->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->tienda->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->tienda->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->users->Visible) { // users ?>
	<?php if ($clientes_list->SortUrl($clientes_list->users) == "") { ?>
		<th data-name="users" class="<?php echo $clientes_list->users->headerCellClass() ?>"><div id="elh_clientes_users" class="clientes_users"><div class="ew-table-header-caption"><?php echo $clientes_list->users->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="users" class="<?php echo $clientes_list->users->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->users) ?>', 1);"><div id="elh_clientes_users" class="clientes_users">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->users->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->users->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->users->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->deuda->Visible) { // deuda ?>
	<?php if ($clientes_list->SortUrl($clientes_list->deuda) == "") { ?>
		<th data-name="deuda" class="<?php echo $clientes_list->deuda->headerCellClass() ?>"><div id="elh_clientes_deuda" class="clientes_deuda"><div class="ew-table-header-caption"><?php echo $clientes_list->deuda->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deuda" class="<?php echo $clientes_list->deuda->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->deuda) ?>', 1);"><div id="elh_clientes_deuda" class="clientes_deuda">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->deuda->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->deuda->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->deuda->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->debe->Visible) { // debe ?>
	<?php if ($clientes_list->SortUrl($clientes_list->debe) == "") { ?>
		<th data-name="debe" class="<?php echo $clientes_list->debe->headerCellClass() ?>"><div id="elh_clientes_debe" class="clientes_debe"><div class="ew-table-header-caption"><?php echo $clientes_list->debe->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="debe" class="<?php echo $clientes_list->debe->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->debe) ?>', 1);"><div id="elh_clientes_debe" class="clientes_debe">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->debe->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->debe->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->debe->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->tipo_documento->Visible) { // tipo_documento ?>
	<?php if ($clientes_list->SortUrl($clientes_list->tipo_documento) == "") { ?>
		<th data-name="tipo_documento" class="<?php echo $clientes_list->tipo_documento->headerCellClass() ?>"><div id="elh_clientes_tipo_documento" class="clientes_tipo_documento"><div class="ew-table-header-caption"><?php echo $clientes_list->tipo_documento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_documento" class="<?php echo $clientes_list->tipo_documento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->tipo_documento) ?>', 1);"><div id="elh_clientes_tipo_documento" class="clientes_tipo_documento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->tipo_documento->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->tipo_documento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->tipo_documento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->n_documento->Visible) { // n_documento ?>
	<?php if ($clientes_list->SortUrl($clientes_list->n_documento) == "") { ?>
		<th data-name="n_documento" class="<?php echo $clientes_list->n_documento->headerCellClass() ?>"><div id="elh_clientes_n_documento" class="clientes_n_documento"><div class="ew-table-header-caption"><?php echo $clientes_list->n_documento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="n_documento" class="<?php echo $clientes_list->n_documento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->n_documento) ?>', 1);"><div id="elh_clientes_n_documento" class="clientes_n_documento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->n_documento->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->n_documento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->n_documento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->deuda1->Visible) { // deuda1 ?>
	<?php if ($clientes_list->SortUrl($clientes_list->deuda1) == "") { ?>
		<th data-name="deuda1" class="<?php echo $clientes_list->deuda1->headerCellClass() ?>"><div id="elh_clientes_deuda1" class="clientes_deuda1"><div class="ew-table-header-caption"><?php echo $clientes_list->deuda1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deuda1" class="<?php echo $clientes_list->deuda1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->deuda1) ?>', 1);"><div id="elh_clientes_deuda1" class="clientes_deuda1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->deuda1->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->deuda1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->deuda1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->debe1->Visible) { // debe1 ?>
	<?php if ($clientes_list->SortUrl($clientes_list->debe1) == "") { ?>
		<th data-name="debe1" class="<?php echo $clientes_list->debe1->headerCellClass() ?>"><div id="elh_clientes_debe1" class="clientes_debe1"><div class="ew-table-header-caption"><?php echo $clientes_list->debe1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="debe1" class="<?php echo $clientes_list->debe1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->debe1) ?>', 1);"><div id="elh_clientes_debe1" class="clientes_debe1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->debe1->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->debe1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->debe1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->tipo->Visible) { // tipo ?>
	<?php if ($clientes_list->SortUrl($clientes_list->tipo) == "") { ?>
		<th data-name="tipo" class="<?php echo $clientes_list->tipo->headerCellClass() ?>"><div id="elh_clientes_tipo" class="clientes_tipo"><div class="ew-table-header-caption"><?php echo $clientes_list->tipo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo" class="<?php echo $clientes_list->tipo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->tipo) ?>', 1);"><div id="elh_clientes_tipo" class="clientes_tipo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->tipo->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->tipo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->tipo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientes_list->estado->Visible) { // estado ?>
	<?php if ($clientes_list->SortUrl($clientes_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $clientes_list->estado->headerCellClass() ?>"><div id="elh_clientes_estado" class="clientes_estado"><div class="ew-table-header-caption"><?php echo $clientes_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $clientes_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $clientes_list->SortUrl($clientes_list->estado) ?>', 1);"><div id="elh_clientes_estado" class="clientes_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clientes_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($clientes_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($clientes_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$clientes_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($clientes_list->ExportAll && $clientes_list->isExport()) {
	$clientes_list->StopRecord = $clientes_list->TotalRecords;
} else {

	// Set the last record to display
	if ($clientes_list->TotalRecords > $clientes_list->StartRecord + $clientes_list->DisplayRecords - 1)
		$clientes_list->StopRecord = $clientes_list->StartRecord + $clientes_list->DisplayRecords - 1;
	else
		$clientes_list->StopRecord = $clientes_list->TotalRecords;
}
$clientes_list->RecordCount = $clientes_list->StartRecord - 1;
if ($clientes_list->Recordset && !$clientes_list->Recordset->EOF) {
	$clientes_list->Recordset->moveFirst();
	$selectLimit = $clientes_list->UseSelectLimit;
	if (!$selectLimit && $clientes_list->StartRecord > 1)
		$clientes_list->Recordset->move($clientes_list->StartRecord - 1);
} elseif (!$clientes->AllowAddDeleteRow && $clientes_list->StopRecord == 0) {
	$clientes_list->StopRecord = $clientes->GridAddRowCount;
}

// Initialize aggregate
$clientes->RowType = ROWTYPE_AGGREGATEINIT;
$clientes->resetAttributes();
$clientes_list->renderRow();
while ($clientes_list->RecordCount < $clientes_list->StopRecord) {
	$clientes_list->RecordCount++;
	if ($clientes_list->RecordCount >= $clientes_list->StartRecord) {
		$clientes_list->RowCount++;

		// Set up key count
		$clientes_list->KeyCount = $clientes_list->RowIndex;

		// Init row class and style
		$clientes->resetAttributes();
		$clientes->CssClass = "";
		if ($clientes_list->isGridAdd()) {
		} else {
			$clientes_list->loadRowValues($clientes_list->Recordset); // Load row values
		}
		$clientes->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$clientes->RowAttrs->merge(["data-rowindex" => $clientes_list->RowCount, "id" => "r" . $clientes_list->RowCount . "_clientes", "data-rowtype" => $clientes->RowType]);

		// Render row
		$clientes_list->renderRow();

		// Render list options
		$clientes_list->renderListOptions();
?>
	<tr <?php echo $clientes->rowAttributes() ?>>
<?php

// Render list options (body, left)
$clientes_list->ListOptions->render("body", "left", $clientes_list->RowCount);
?>
	<?php if ($clientes_list->id_cliente->Visible) { // id_cliente ?>
		<td data-name="id_cliente" <?php echo $clientes_list->id_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_id_cliente" class="clientes_id_cliente">
<span<?php echo $clientes_list->id_cliente->viewAttributes() ?>><?php echo $clientes_list->id_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->nombre_cliente->Visible) { // nombre_cliente ?>
		<td data-name="nombre_cliente" <?php echo $clientes_list->nombre_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_nombre_cliente" class="clientes_nombre_cliente">
<span<?php echo $clientes_list->nombre_cliente->viewAttributes() ?>><?php echo $clientes_list->nombre_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->telefono_cliente->Visible) { // telefono_cliente ?>
		<td data-name="telefono_cliente" <?php echo $clientes_list->telefono_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_telefono_cliente" class="clientes_telefono_cliente">
<span<?php echo $clientes_list->telefono_cliente->viewAttributes() ?>><?php echo $clientes_list->telefono_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->email_cliente->Visible) { // email_cliente ?>
		<td data-name="email_cliente" <?php echo $clientes_list->email_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_email_cliente" class="clientes_email_cliente">
<span<?php echo $clientes_list->email_cliente->viewAttributes() ?>><?php echo $clientes_list->email_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->direccion_cliente->Visible) { // direccion_cliente ?>
		<td data-name="direccion_cliente" <?php echo $clientes_list->direccion_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_direccion_cliente" class="clientes_direccion_cliente">
<span<?php echo $clientes_list->direccion_cliente->viewAttributes() ?>><?php echo $clientes_list->direccion_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->status_cliente->Visible) { // status_cliente ?>
		<td data-name="status_cliente" <?php echo $clientes_list->status_cliente->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_status_cliente" class="clientes_status_cliente">
<span<?php echo $clientes_list->status_cliente->viewAttributes() ?>><?php echo $clientes_list->status_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->date_added->Visible) { // date_added ?>
		<td data-name="date_added" <?php echo $clientes_list->date_added->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_date_added" class="clientes_date_added">
<span<?php echo $clientes_list->date_added->viewAttributes() ?>><?php echo $clientes_list->date_added->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->doc->Visible) { // doc ?>
		<td data-name="doc" <?php echo $clientes_list->doc->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_doc" class="clientes_doc">
<span<?php echo $clientes_list->doc->viewAttributes() ?>><?php echo $clientes_list->doc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->vendedor->Visible) { // vendedor ?>
		<td data-name="vendedor" <?php echo $clientes_list->vendedor->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_vendedor" class="clientes_vendedor">
<span<?php echo $clientes_list->vendedor->viewAttributes() ?>><?php echo $clientes_list->vendedor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->tipo1->Visible) { // tipo1 ?>
		<td data-name="tipo1" <?php echo $clientes_list->tipo1->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_tipo1" class="clientes_tipo1">
<span<?php echo $clientes_list->tipo1->viewAttributes() ?>><?php echo $clientes_list->tipo1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->tienda->Visible) { // tienda ?>
		<td data-name="tienda" <?php echo $clientes_list->tienda->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_tienda" class="clientes_tienda">
<span<?php echo $clientes_list->tienda->viewAttributes() ?>><?php echo $clientes_list->tienda->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->users->Visible) { // users ?>
		<td data-name="users" <?php echo $clientes_list->users->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_users" class="clientes_users">
<span<?php echo $clientes_list->users->viewAttributes() ?>><?php echo $clientes_list->users->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->deuda->Visible) { // deuda ?>
		<td data-name="deuda" <?php echo $clientes_list->deuda->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_deuda" class="clientes_deuda">
<span<?php echo $clientes_list->deuda->viewAttributes() ?>><?php echo $clientes_list->deuda->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->debe->Visible) { // debe ?>
		<td data-name="debe" <?php echo $clientes_list->debe->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_debe" class="clientes_debe">
<span<?php echo $clientes_list->debe->viewAttributes() ?>><?php echo $clientes_list->debe->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->tipo_documento->Visible) { // tipo_documento ?>
		<td data-name="tipo_documento" <?php echo $clientes_list->tipo_documento->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_tipo_documento" class="clientes_tipo_documento">
<span<?php echo $clientes_list->tipo_documento->viewAttributes() ?>><?php echo $clientes_list->tipo_documento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->n_documento->Visible) { // n_documento ?>
		<td data-name="n_documento" <?php echo $clientes_list->n_documento->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_n_documento" class="clientes_n_documento">
<span<?php echo $clientes_list->n_documento->viewAttributes() ?>><?php echo $clientes_list->n_documento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->deuda1->Visible) { // deuda1 ?>
		<td data-name="deuda1" <?php echo $clientes_list->deuda1->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_deuda1" class="clientes_deuda1">
<span<?php echo $clientes_list->deuda1->viewAttributes() ?>><?php echo $clientes_list->deuda1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->debe1->Visible) { // debe1 ?>
		<td data-name="debe1" <?php echo $clientes_list->debe1->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_debe1" class="clientes_debe1">
<span<?php echo $clientes_list->debe1->viewAttributes() ?>><?php echo $clientes_list->debe1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->tipo->Visible) { // tipo ?>
		<td data-name="tipo" <?php echo $clientes_list->tipo->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_tipo" class="clientes_tipo">
<span<?php echo $clientes_list->tipo->viewAttributes() ?>><?php echo $clientes_list->tipo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clientes_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $clientes_list->estado->cellAttributes() ?>>
<span id="el<?php echo $clientes_list->RowCount ?>_clientes_estado" class="clientes_estado">
<span<?php echo $clientes_list->estado->viewAttributes() ?>><?php echo $clientes_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$clientes_list->ListOptions->render("body", "right", $clientes_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$clientes_list->isGridAdd())
		$clientes_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$clientes->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($clientes_list->Recordset)
	$clientes_list->Recordset->Close();
?>
<?php if (!$clientes_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$clientes_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $clientes_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clientes_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($clientes_list->TotalRecords == 0 && !$clientes->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $clientes_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$clientes_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$clientes_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$clientes_list->terminate();
?>