<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class products_edit extends products
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'products';

	// Page object name
	public $PageObjName = "products_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (products)
		if (!isset($GLOBALS["products"]) || get_class($GLOBALS["products"]) == PROJECT_NAMESPACE . "products") {
			$GLOBALS["products"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["products"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'products');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $products;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($products);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "productsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("productslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_producto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->setVisibility();
		$this->estado->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->pais->setVisibility();
		$this->departamento->setVisibility();
		$this->distrito->setVisibility();
		$this->localidad->setVisibility();
		$this->zona->setVisibility();
		$this->tipo_inmueble->setVisibility();
		$this->tipo_negocio->setVisibility();
		$this->tiempo_alquiler->setVisibility();
		$this->moneda->setVisibility();
		$this->estado_inmueble->setVisibility();
		$this->area_construida->setVisibility();
		$this->area_privada->setVisibility();
		$this->area_terreno->setVisibility();
		$this->valor_administracion->setVisibility();
		$this->dormitorios->setVisibility();
		$this->banios->setVisibility();
		$this->garaje->setVisibility();
		$this->piso->setVisibility();
		$this->estrato->setVisibility();
		$this->direccion->setVisibility();
		$this->codigo_postal->setVisibility();
		$this->mapa->setVisibility();
		$this->latitud->setVisibility();
		$this->longitud->setVisibility();
		$this->opciones_mapa->setVisibility();
		$this->red->setVisibility();
		$this->video->setVisibility();
		$this->disponibilidad->setVisibility();
		$this->anio_construccion->setVisibility();
		$this->encargado->setVisibility();
		$this->comentario->setVisibility();
		$this->visitas->setVisibility();
		$this->valor_comision->setVisibility();
		$this->tipo_comision->setVisibility();
		$this->certificado->setVisibility();
		$this->nombre_propietario->setVisibility();
		$this->movil_propietario->setVisibility();
		$this->telefono_propietario->setVisibility();
		$this->correo_propietario->setVisibility();
		$this->vinculo->setVisibility();
		$this->portales->setVisibility();
		$this->notas->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->setVisibility();
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->setVisibility();
		$this->descripcion1->setVisibility();
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->precio_mayorista->setVisibility();
		$this->precio_vendedor->setVisibility();
		$this->medida1->setVisibility();
		$this->medida2->setVisibility();
		$this->medida3->setVisibility();
		$this->codlogin->setVisibility();
		$this->idempresa->setVisibility();
		$this->urlstreetview->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id_producto")) {
				$this->id_producto->setFormValue($CurrentForm->getValue("x_id_producto"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id_producto") !== NULL) {
				$this->id_producto->setQueryStringValue(Get("id_producto"));
				$loadByQuery = TRUE;
			} else {
				$this->id_producto->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("productslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "productslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id_producto' first before field var 'x_id_producto'
		$val = $CurrentForm->hasValue("id_producto") ? $CurrentForm->getValue("id_producto") : $CurrentForm->getValue("x_id_producto");
		if (!$this->id_producto->IsDetailKey)
			$this->id_producto->setFormValue($val);

		// Check field name 'codigo_producto' first before field var 'x_codigo_producto'
		$val = $CurrentForm->hasValue("codigo_producto") ? $CurrentForm->getValue("codigo_producto") : $CurrentForm->getValue("x_codigo_producto");
		if (!$this->codigo_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codigo_producto->Visible = FALSE; // Disable update for API request
			else
				$this->codigo_producto->setFormValue($val);
		}

		// Check field name 'nombre_producto' first before field var 'x_nombre_producto'
		$val = $CurrentForm->hasValue("nombre_producto") ? $CurrentForm->getValue("nombre_producto") : $CurrentForm->getValue("x_nombre_producto");
		if (!$this->nombre_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombre_producto->Visible = FALSE; // Disable update for API request
			else
				$this->nombre_producto->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'status_producto' first before field var 'x_status_producto'
		$val = $CurrentForm->hasValue("status_producto") ? $CurrentForm->getValue("status_producto") : $CurrentForm->getValue("x_status_producto");
		if (!$this->status_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_producto->Visible = FALSE; // Disable update for API request
			else
				$this->status_producto->setFormValue($val);
		}

		// Check field name 'date_added' first before field var 'x_date_added'
		$val = $CurrentForm->hasValue("date_added") ? $CurrentForm->getValue("date_added") : $CurrentForm->getValue("x_date_added");
		if (!$this->date_added->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date_added->Visible = FALSE; // Disable update for API request
			else
				$this->date_added->setFormValue($val);
			$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		}

		// Check field name 'precio_producto' first before field var 'x_precio_producto'
		$val = $CurrentForm->hasValue("precio_producto") ? $CurrentForm->getValue("precio_producto") : $CurrentForm->getValue("x_precio_producto");
		if (!$this->precio_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio_producto->Visible = FALSE; // Disable update for API request
			else
				$this->precio_producto->setFormValue($val);
		}

		// Check field name 'costo_producto' first before field var 'x_costo_producto'
		$val = $CurrentForm->hasValue("costo_producto") ? $CurrentForm->getValue("costo_producto") : $CurrentForm->getValue("x_costo_producto");
		if (!$this->costo_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->costo_producto->Visible = FALSE; // Disable update for API request
			else
				$this->costo_producto->setFormValue($val);
		}

		// Check field name 'mon_costo' first before field var 'x_mon_costo'
		$val = $CurrentForm->hasValue("mon_costo") ? $CurrentForm->getValue("mon_costo") : $CurrentForm->getValue("x_mon_costo");
		if (!$this->mon_costo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mon_costo->Visible = FALSE; // Disable update for API request
			else
				$this->mon_costo->setFormValue($val);
		}

		// Check field name 'mon_venta' first before field var 'x_mon_venta'
		$val = $CurrentForm->hasValue("mon_venta") ? $CurrentForm->getValue("mon_venta") : $CurrentForm->getValue("x_mon_venta");
		if (!$this->mon_venta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mon_venta->Visible = FALSE; // Disable update for API request
			else
				$this->mon_venta->setFormValue($val);
		}

		// Check field name 'pais' first before field var 'x_pais'
		$val = $CurrentForm->hasValue("pais") ? $CurrentForm->getValue("pais") : $CurrentForm->getValue("x_pais");
		if (!$this->pais->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pais->Visible = FALSE; // Disable update for API request
			else
				$this->pais->setFormValue($val);
		}

		// Check field name 'departamento' first before field var 'x_departamento'
		$val = $CurrentForm->hasValue("departamento") ? $CurrentForm->getValue("departamento") : $CurrentForm->getValue("x_departamento");
		if (!$this->departamento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->departamento->Visible = FALSE; // Disable update for API request
			else
				$this->departamento->setFormValue($val);
		}

		// Check field name 'distrito' first before field var 'x_distrito'
		$val = $CurrentForm->hasValue("distrito") ? $CurrentForm->getValue("distrito") : $CurrentForm->getValue("x_distrito");
		if (!$this->distrito->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->distrito->Visible = FALSE; // Disable update for API request
			else
				$this->distrito->setFormValue($val);
		}

		// Check field name 'localidad' first before field var 'x_localidad'
		$val = $CurrentForm->hasValue("localidad") ? $CurrentForm->getValue("localidad") : $CurrentForm->getValue("x_localidad");
		if (!$this->localidad->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->localidad->Visible = FALSE; // Disable update for API request
			else
				$this->localidad->setFormValue($val);
		}

		// Check field name 'zona' first before field var 'x_zona'
		$val = $CurrentForm->hasValue("zona") ? $CurrentForm->getValue("zona") : $CurrentForm->getValue("x_zona");
		if (!$this->zona->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->zona->Visible = FALSE; // Disable update for API request
			else
				$this->zona->setFormValue($val);
		}

		// Check field name 'tipo_inmueble' first before field var 'x_tipo_inmueble'
		$val = $CurrentForm->hasValue("tipo_inmueble") ? $CurrentForm->getValue("tipo_inmueble") : $CurrentForm->getValue("x_tipo_inmueble");
		if (!$this->tipo_inmueble->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_inmueble->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_inmueble->setFormValue($val);
		}

		// Check field name 'tipo_negocio' first before field var 'x_tipo_negocio'
		$val = $CurrentForm->hasValue("tipo_negocio") ? $CurrentForm->getValue("tipo_negocio") : $CurrentForm->getValue("x_tipo_negocio");
		if (!$this->tipo_negocio->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_negocio->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_negocio->setFormValue($val);
		}

		// Check field name 'tiempo_alquiler' first before field var 'x_tiempo_alquiler'
		$val = $CurrentForm->hasValue("tiempo_alquiler") ? $CurrentForm->getValue("tiempo_alquiler") : $CurrentForm->getValue("x_tiempo_alquiler");
		if (!$this->tiempo_alquiler->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tiempo_alquiler->Visible = FALSE; // Disable update for API request
			else
				$this->tiempo_alquiler->setFormValue($val);
		}

		// Check field name 'moneda' first before field var 'x_moneda'
		$val = $CurrentForm->hasValue("moneda") ? $CurrentForm->getValue("moneda") : $CurrentForm->getValue("x_moneda");
		if (!$this->moneda->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->moneda->Visible = FALSE; // Disable update for API request
			else
				$this->moneda->setFormValue($val);
		}

		// Check field name 'estado_inmueble' first before field var 'x_estado_inmueble'
		$val = $CurrentForm->hasValue("estado_inmueble") ? $CurrentForm->getValue("estado_inmueble") : $CurrentForm->getValue("x_estado_inmueble");
		if (!$this->estado_inmueble->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado_inmueble->Visible = FALSE; // Disable update for API request
			else
				$this->estado_inmueble->setFormValue($val);
		}

		// Check field name 'area_construida' first before field var 'x_area_construida'
		$val = $CurrentForm->hasValue("area_construida") ? $CurrentForm->getValue("area_construida") : $CurrentForm->getValue("x_area_construida");
		if (!$this->area_construida->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->area_construida->Visible = FALSE; // Disable update for API request
			else
				$this->area_construida->setFormValue($val);
		}

		// Check field name 'area_privada' first before field var 'x_area_privada'
		$val = $CurrentForm->hasValue("area_privada") ? $CurrentForm->getValue("area_privada") : $CurrentForm->getValue("x_area_privada");
		if (!$this->area_privada->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->area_privada->Visible = FALSE; // Disable update for API request
			else
				$this->area_privada->setFormValue($val);
		}

		// Check field name 'area_terreno' first before field var 'x_area_terreno'
		$val = $CurrentForm->hasValue("area_terreno") ? $CurrentForm->getValue("area_terreno") : $CurrentForm->getValue("x_area_terreno");
		if (!$this->area_terreno->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->area_terreno->Visible = FALSE; // Disable update for API request
			else
				$this->area_terreno->setFormValue($val);
		}

		// Check field name 'valor_administracion' first before field var 'x_valor_administracion'
		$val = $CurrentForm->hasValue("valor_administracion") ? $CurrentForm->getValue("valor_administracion") : $CurrentForm->getValue("x_valor_administracion");
		if (!$this->valor_administracion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->valor_administracion->Visible = FALSE; // Disable update for API request
			else
				$this->valor_administracion->setFormValue($val);
		}

		// Check field name 'dormitorios' first before field var 'x_dormitorios'
		$val = $CurrentForm->hasValue("dormitorios") ? $CurrentForm->getValue("dormitorios") : $CurrentForm->getValue("x_dormitorios");
		if (!$this->dormitorios->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dormitorios->Visible = FALSE; // Disable update for API request
			else
				$this->dormitorios->setFormValue($val);
		}

		// Check field name 'banios' first before field var 'x_banios'
		$val = $CurrentForm->hasValue("banios") ? $CurrentForm->getValue("banios") : $CurrentForm->getValue("x_banios");
		if (!$this->banios->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->banios->Visible = FALSE; // Disable update for API request
			else
				$this->banios->setFormValue($val);
		}

		// Check field name 'garaje' first before field var 'x_garaje'
		$val = $CurrentForm->hasValue("garaje") ? $CurrentForm->getValue("garaje") : $CurrentForm->getValue("x_garaje");
		if (!$this->garaje->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->garaje->Visible = FALSE; // Disable update for API request
			else
				$this->garaje->setFormValue($val);
		}

		// Check field name 'piso' first before field var 'x_piso'
		$val = $CurrentForm->hasValue("piso") ? $CurrentForm->getValue("piso") : $CurrentForm->getValue("x_piso");
		if (!$this->piso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->piso->Visible = FALSE; // Disable update for API request
			else
				$this->piso->setFormValue($val);
		}

		// Check field name 'estrato' first before field var 'x_estrato'
		$val = $CurrentForm->hasValue("estrato") ? $CurrentForm->getValue("estrato") : $CurrentForm->getValue("x_estrato");
		if (!$this->estrato->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estrato->Visible = FALSE; // Disable update for API request
			else
				$this->estrato->setFormValue($val);
		}

		// Check field name 'direccion' first before field var 'x_direccion'
		$val = $CurrentForm->hasValue("direccion") ? $CurrentForm->getValue("direccion") : $CurrentForm->getValue("x_direccion");
		if (!$this->direccion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->direccion->Visible = FALSE; // Disable update for API request
			else
				$this->direccion->setFormValue($val);
		}

		// Check field name 'codigo_postal' first before field var 'x_codigo_postal'
		$val = $CurrentForm->hasValue("codigo_postal") ? $CurrentForm->getValue("codigo_postal") : $CurrentForm->getValue("x_codigo_postal");
		if (!$this->codigo_postal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codigo_postal->Visible = FALSE; // Disable update for API request
			else
				$this->codigo_postal->setFormValue($val);
		}

		// Check field name 'mapa' first before field var 'x_mapa'
		$val = $CurrentForm->hasValue("mapa") ? $CurrentForm->getValue("mapa") : $CurrentForm->getValue("x_mapa");
		if (!$this->mapa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mapa->Visible = FALSE; // Disable update for API request
			else
				$this->mapa->setFormValue($val);
		}

		// Check field name 'latitud' first before field var 'x_latitud'
		$val = $CurrentForm->hasValue("latitud") ? $CurrentForm->getValue("latitud") : $CurrentForm->getValue("x_latitud");
		if (!$this->latitud->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->latitud->Visible = FALSE; // Disable update for API request
			else
				$this->latitud->setFormValue($val);
		}

		// Check field name 'longitud' first before field var 'x_longitud'
		$val = $CurrentForm->hasValue("longitud") ? $CurrentForm->getValue("longitud") : $CurrentForm->getValue("x_longitud");
		if (!$this->longitud->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->longitud->Visible = FALSE; // Disable update for API request
			else
				$this->longitud->setFormValue($val);
		}

		// Check field name 'opciones_mapa' first before field var 'x_opciones_mapa'
		$val = $CurrentForm->hasValue("opciones_mapa") ? $CurrentForm->getValue("opciones_mapa") : $CurrentForm->getValue("x_opciones_mapa");
		if (!$this->opciones_mapa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->opciones_mapa->Visible = FALSE; // Disable update for API request
			else
				$this->opciones_mapa->setFormValue($val);
		}

		// Check field name 'red' first before field var 'x_red'
		$val = $CurrentForm->hasValue("red") ? $CurrentForm->getValue("red") : $CurrentForm->getValue("x_red");
		if (!$this->red->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->red->Visible = FALSE; // Disable update for API request
			else
				$this->red->setFormValue($val);
		}

		// Check field name 'video' first before field var 'x_video'
		$val = $CurrentForm->hasValue("video") ? $CurrentForm->getValue("video") : $CurrentForm->getValue("x_video");
		if (!$this->video->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->video->Visible = FALSE; // Disable update for API request
			else
				$this->video->setFormValue($val);
		}

		// Check field name 'disponibilidad' first before field var 'x_disponibilidad'
		$val = $CurrentForm->hasValue("disponibilidad") ? $CurrentForm->getValue("disponibilidad") : $CurrentForm->getValue("x_disponibilidad");
		if (!$this->disponibilidad->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->disponibilidad->Visible = FALSE; // Disable update for API request
			else
				$this->disponibilidad->setFormValue($val);
		}

		// Check field name 'anio_construccion' first before field var 'x_anio_construccion'
		$val = $CurrentForm->hasValue("anio_construccion") ? $CurrentForm->getValue("anio_construccion") : $CurrentForm->getValue("x_anio_construccion");
		if (!$this->anio_construccion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->anio_construccion->Visible = FALSE; // Disable update for API request
			else
				$this->anio_construccion->setFormValue($val);
		}

		// Check field name 'encargado' first before field var 'x_encargado'
		$val = $CurrentForm->hasValue("encargado") ? $CurrentForm->getValue("encargado") : $CurrentForm->getValue("x_encargado");
		if (!$this->encargado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->encargado->Visible = FALSE; // Disable update for API request
			else
				$this->encargado->setFormValue($val);
		}

		// Check field name 'comentario' first before field var 'x_comentario'
		$val = $CurrentForm->hasValue("comentario") ? $CurrentForm->getValue("comentario") : $CurrentForm->getValue("x_comentario");
		if (!$this->comentario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->comentario->Visible = FALSE; // Disable update for API request
			else
				$this->comentario->setFormValue($val);
		}

		// Check field name 'visitas' first before field var 'x_visitas'
		$val = $CurrentForm->hasValue("visitas") ? $CurrentForm->getValue("visitas") : $CurrentForm->getValue("x_visitas");
		if (!$this->visitas->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->visitas->Visible = FALSE; // Disable update for API request
			else
				$this->visitas->setFormValue($val);
		}

		// Check field name 'valor_comision' first before field var 'x_valor_comision'
		$val = $CurrentForm->hasValue("valor_comision") ? $CurrentForm->getValue("valor_comision") : $CurrentForm->getValue("x_valor_comision");
		if (!$this->valor_comision->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->valor_comision->Visible = FALSE; // Disable update for API request
			else
				$this->valor_comision->setFormValue($val);
		}

		// Check field name 'tipo_comision' first before field var 'x_tipo_comision'
		$val = $CurrentForm->hasValue("tipo_comision") ? $CurrentForm->getValue("tipo_comision") : $CurrentForm->getValue("x_tipo_comision");
		if (!$this->tipo_comision->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_comision->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_comision->setFormValue($val);
		}

		// Check field name 'certificado' first before field var 'x_certificado'
		$val = $CurrentForm->hasValue("certificado") ? $CurrentForm->getValue("certificado") : $CurrentForm->getValue("x_certificado");
		if (!$this->certificado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->certificado->Visible = FALSE; // Disable update for API request
			else
				$this->certificado->setFormValue($val);
		}

		// Check field name 'nombre_propietario' first before field var 'x_nombre_propietario'
		$val = $CurrentForm->hasValue("nombre_propietario") ? $CurrentForm->getValue("nombre_propietario") : $CurrentForm->getValue("x_nombre_propietario");
		if (!$this->nombre_propietario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombre_propietario->Visible = FALSE; // Disable update for API request
			else
				$this->nombre_propietario->setFormValue($val);
		}

		// Check field name 'movil_propietario' first before field var 'x_movil_propietario'
		$val = $CurrentForm->hasValue("movil_propietario") ? $CurrentForm->getValue("movil_propietario") : $CurrentForm->getValue("x_movil_propietario");
		if (!$this->movil_propietario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->movil_propietario->Visible = FALSE; // Disable update for API request
			else
				$this->movil_propietario->setFormValue($val);
		}

		// Check field name 'telefono_propietario' first before field var 'x_telefono_propietario'
		$val = $CurrentForm->hasValue("telefono_propietario") ? $CurrentForm->getValue("telefono_propietario") : $CurrentForm->getValue("x_telefono_propietario");
		if (!$this->telefono_propietario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->telefono_propietario->Visible = FALSE; // Disable update for API request
			else
				$this->telefono_propietario->setFormValue($val);
		}

		// Check field name 'correo_propietario' first before field var 'x_correo_propietario'
		$val = $CurrentForm->hasValue("correo_propietario") ? $CurrentForm->getValue("correo_propietario") : $CurrentForm->getValue("x_correo_propietario");
		if (!$this->correo_propietario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->correo_propietario->Visible = FALSE; // Disable update for API request
			else
				$this->correo_propietario->setFormValue($val);
		}

		// Check field name 'vinculo' first before field var 'x_vinculo'
		$val = $CurrentForm->hasValue("vinculo") ? $CurrentForm->getValue("vinculo") : $CurrentForm->getValue("x_vinculo");
		if (!$this->vinculo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vinculo->Visible = FALSE; // Disable update for API request
			else
				$this->vinculo->setFormValue($val);
		}

		// Check field name 'portales' first before field var 'x_portales'
		$val = $CurrentForm->hasValue("portales") ? $CurrentForm->getValue("portales") : $CurrentForm->getValue("x_portales");
		if (!$this->portales->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->portales->Visible = FALSE; // Disable update for API request
			else
				$this->portales->setFormValue($val);
		}

		// Check field name 'notas' first before field var 'x_notas'
		$val = $CurrentForm->hasValue("notas") ? $CurrentForm->getValue("notas") : $CurrentForm->getValue("x_notas");
		if (!$this->notas->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->notas->Visible = FALSE; // Disable update for API request
			else
				$this->notas->setFormValue($val);
		}

		// Check field name 'marca' first before field var 'x_marca'
		$val = $CurrentForm->hasValue("marca") ? $CurrentForm->getValue("marca") : $CurrentForm->getValue("x_marca");
		if (!$this->marca->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->marca->Visible = FALSE; // Disable update for API request
			else
				$this->marca->setFormValue($val);
		}

		// Check field name 'modelo' first before field var 'x_modelo'
		$val = $CurrentForm->hasValue("modelo") ? $CurrentForm->getValue("modelo") : $CurrentForm->getValue("x_modelo");
		if (!$this->modelo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->modelo->Visible = FALSE; // Disable update for API request
			else
				$this->modelo->setFormValue($val);
		}

		// Check field name 'color' first before field var 'x_color'
		$val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
		if (!$this->color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color->Visible = FALSE; // Disable update for API request
			else
				$this->color->setFormValue($val);
		}

		// Check field name 'b1' first before field var 'x_b1'
		$val = $CurrentForm->hasValue("b1") ? $CurrentForm->getValue("b1") : $CurrentForm->getValue("x_b1");
		if (!$this->b1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b1->Visible = FALSE; // Disable update for API request
			else
				$this->b1->setFormValue($val);
		}

		// Check field name 'b2' first before field var 'x_b2'
		$val = $CurrentForm->hasValue("b2") ? $CurrentForm->getValue("b2") : $CurrentForm->getValue("x_b2");
		if (!$this->b2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b2->Visible = FALSE; // Disable update for API request
			else
				$this->b2->setFormValue($val);
		}

		// Check field name 'b3' first before field var 'x_b3'
		$val = $CurrentForm->hasValue("b3") ? $CurrentForm->getValue("b3") : $CurrentForm->getValue("x_b3");
		if (!$this->b3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b3->Visible = FALSE; // Disable update for API request
			else
				$this->b3->setFormValue($val);
		}

		// Check field name 'b4' first before field var 'x_b4'
		$val = $CurrentForm->hasValue("b4") ? $CurrentForm->getValue("b4") : $CurrentForm->getValue("x_b4");
		if (!$this->b4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b4->Visible = FALSE; // Disable update for API request
			else
				$this->b4->setFormValue($val);
		}

		// Check field name 'b5' first before field var 'x_b5'
		$val = $CurrentForm->hasValue("b5") ? $CurrentForm->getValue("b5") : $CurrentForm->getValue("x_b5");
		if (!$this->b5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b5->Visible = FALSE; // Disable update for API request
			else
				$this->b5->setFormValue($val);
		}

		// Check field name 'b6' first before field var 'x_b6'
		$val = $CurrentForm->hasValue("b6") ? $CurrentForm->getValue("b6") : $CurrentForm->getValue("x_b6");
		if (!$this->b6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b6->Visible = FALSE; // Disable update for API request
			else
				$this->b6->setFormValue($val);
		}

		// Check field name 'cat_pro' first before field var 'x_cat_pro'
		$val = $CurrentForm->hasValue("cat_pro") ? $CurrentForm->getValue("cat_pro") : $CurrentForm->getValue("x_cat_pro");
		if (!$this->cat_pro->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cat_pro->Visible = FALSE; // Disable update for API request
			else
				$this->cat_pro->setFormValue($val);
		}

		// Check field name 'pro_ser' first before field var 'x_pro_ser'
		$val = $CurrentForm->hasValue("pro_ser") ? $CurrentForm->getValue("pro_ser") : $CurrentForm->getValue("x_pro_ser");
		if (!$this->pro_ser->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pro_ser->Visible = FALSE; // Disable update for API request
			else
				$this->pro_ser->setFormValue($val);
		}

		// Check field name 'foto1' first before field var 'x_foto1'
		$val = $CurrentForm->hasValue("foto1") ? $CurrentForm->getValue("foto1") : $CurrentForm->getValue("x_foto1");
		if (!$this->foto1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto1->Visible = FALSE; // Disable update for API request
			else
				$this->foto1->setFormValue($val);
		}

		// Check field name 'foto2' first before field var 'x_foto2'
		$val = $CurrentForm->hasValue("foto2") ? $CurrentForm->getValue("foto2") : $CurrentForm->getValue("x_foto2");
		if (!$this->foto2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto2->Visible = FALSE; // Disable update for API request
			else
				$this->foto2->setFormValue($val);
		}

		// Check field name 'foto3' first before field var 'x_foto3'
		$val = $CurrentForm->hasValue("foto3") ? $CurrentForm->getValue("foto3") : $CurrentForm->getValue("x_foto3");
		if (!$this->foto3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto3->Visible = FALSE; // Disable update for API request
			else
				$this->foto3->setFormValue($val);
		}

		// Check field name 'foto4' first before field var 'x_foto4'
		$val = $CurrentForm->hasValue("foto4") ? $CurrentForm->getValue("foto4") : $CurrentForm->getValue("x_foto4");
		if (!$this->foto4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto4->Visible = FALSE; // Disable update for API request
			else
				$this->foto4->setFormValue($val);
		}

		// Check field name 'web' first before field var 'x_web'
		$val = $CurrentForm->hasValue("web") ? $CurrentForm->getValue("web") : $CurrentForm->getValue("x_web");
		if (!$this->web->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->web->Visible = FALSE; // Disable update for API request
			else
				$this->web->setFormValue($val);
		}

		// Check field name 'pre_web' first before field var 'x_pre_web'
		$val = $CurrentForm->hasValue("pre_web") ? $CurrentForm->getValue("pre_web") : $CurrentForm->getValue("x_pre_web");
		if (!$this->pre_web->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pre_web->Visible = FALSE; // Disable update for API request
			else
				$this->pre_web->setFormValue($val);
		}

		// Check field name 'descripcion' first before field var 'x_descripcion'
		$val = $CurrentForm->hasValue("descripcion") ? $CurrentForm->getValue("descripcion") : $CurrentForm->getValue("x_descripcion");
		if (!$this->descripcion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcion->Visible = FALSE; // Disable update for API request
			else
				$this->descripcion->setFormValue($val);
		}

		// Check field name 'descripcion1' first before field var 'x_descripcion1'
		$val = $CurrentForm->hasValue("descripcion1") ? $CurrentForm->getValue("descripcion1") : $CurrentForm->getValue("x_descripcion1");
		if (!$this->descripcion1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcion1->Visible = FALSE; // Disable update for API request
			else
				$this->descripcion1->setFormValue($val);
		}

		// Check field name 'megusta' first before field var 'x_megusta'
		$val = $CurrentForm->hasValue("megusta") ? $CurrentForm->getValue("megusta") : $CurrentForm->getValue("x_megusta");
		if (!$this->megusta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->megusta->Visible = FALSE; // Disable update for API request
			else
				$this->megusta->setFormValue($val);
		}

		// Check field name 'nomegusta' first before field var 'x_nomegusta'
		$val = $CurrentForm->hasValue("nomegusta") ? $CurrentForm->getValue("nomegusta") : $CurrentForm->getValue("x_nomegusta");
		if (!$this->nomegusta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomegusta->Visible = FALSE; // Disable update for API request
			else
				$this->nomegusta->setFormValue($val);
		}

		// Check field name 'precio2' first before field var 'x_precio2'
		$val = $CurrentForm->hasValue("precio2") ? $CurrentForm->getValue("precio2") : $CurrentForm->getValue("x_precio2");
		if (!$this->precio2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio2->Visible = FALSE; // Disable update for API request
			else
				$this->precio2->setFormValue($val);
		}

		// Check field name 'precio3' first before field var 'x_precio3'
		$val = $CurrentForm->hasValue("precio3") ? $CurrentForm->getValue("precio3") : $CurrentForm->getValue("x_precio3");
		if (!$this->precio3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio3->Visible = FALSE; // Disable update for API request
			else
				$this->precio3->setFormValue($val);
		}

		// Check field name 'und_pro' first before field var 'x_und_pro'
		$val = $CurrentForm->hasValue("und_pro") ? $CurrentForm->getValue("und_pro") : $CurrentForm->getValue("x_und_pro");
		if (!$this->und_pro->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->und_pro->Visible = FALSE; // Disable update for API request
			else
				$this->und_pro->setFormValue($val);
		}

		// Check field name 'barras' first before field var 'x_barras'
		$val = $CurrentForm->hasValue("barras") ? $CurrentForm->getValue("barras") : $CurrentForm->getValue("x_barras");
		if (!$this->barras->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->barras->Visible = FALSE; // Disable update for API request
			else
				$this->barras->setFormValue($val);
		}

		// Check field name 'stockmin' first before field var 'x_stockmin'
		$val = $CurrentForm->hasValue("stockmin") ? $CurrentForm->getValue("stockmin") : $CurrentForm->getValue("x_stockmin");
		if (!$this->stockmin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stockmin->Visible = FALSE; // Disable update for API request
			else
				$this->stockmin->setFormValue($val);
		}

		// Check field name 'id_grupo' first before field var 'x_id_grupo'
		$val = $CurrentForm->hasValue("id_grupo") ? $CurrentForm->getValue("id_grupo") : $CurrentForm->getValue("x_id_grupo");
		if (!$this->id_grupo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_grupo->Visible = FALSE; // Disable update for API request
			else
				$this->id_grupo->setFormValue($val);
		}

		// Check field name 'talla' first before field var 'x_talla'
		$val = $CurrentForm->hasValue("talla") ? $CurrentForm->getValue("talla") : $CurrentForm->getValue("x_talla");
		if (!$this->talla->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->talla->Visible = FALSE; // Disable update for API request
			else
				$this->talla->setFormValue($val);
		}

		// Check field name 'mostrarcolor' first before field var 'x_mostrarcolor'
		$val = $CurrentForm->hasValue("mostrarcolor") ? $CurrentForm->getValue("mostrarcolor") : $CurrentForm->getValue("x_mostrarcolor");
		if (!$this->mostrarcolor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mostrarcolor->Visible = FALSE; // Disable update for API request
			else
				$this->mostrarcolor->setFormValue($val);
		}

		// Check field name 'precio_mayorista' first before field var 'x_precio_mayorista'
		$val = $CurrentForm->hasValue("precio_mayorista") ? $CurrentForm->getValue("precio_mayorista") : $CurrentForm->getValue("x_precio_mayorista");
		if (!$this->precio_mayorista->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio_mayorista->Visible = FALSE; // Disable update for API request
			else
				$this->precio_mayorista->setFormValue($val);
		}

		// Check field name 'precio_vendedor' first before field var 'x_precio_vendedor'
		$val = $CurrentForm->hasValue("precio_vendedor") ? $CurrentForm->getValue("precio_vendedor") : $CurrentForm->getValue("x_precio_vendedor");
		if (!$this->precio_vendedor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio_vendedor->Visible = FALSE; // Disable update for API request
			else
				$this->precio_vendedor->setFormValue($val);
		}

		// Check field name 'medida1' first before field var 'x_medida1'
		$val = $CurrentForm->hasValue("medida1") ? $CurrentForm->getValue("medida1") : $CurrentForm->getValue("x_medida1");
		if (!$this->medida1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->medida1->Visible = FALSE; // Disable update for API request
			else
				$this->medida1->setFormValue($val);
		}

		// Check field name 'medida2' first before field var 'x_medida2'
		$val = $CurrentForm->hasValue("medida2") ? $CurrentForm->getValue("medida2") : $CurrentForm->getValue("x_medida2");
		if (!$this->medida2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->medida2->Visible = FALSE; // Disable update for API request
			else
				$this->medida2->setFormValue($val);
		}

		// Check field name 'medida3' first before field var 'x_medida3'
		$val = $CurrentForm->hasValue("medida3") ? $CurrentForm->getValue("medida3") : $CurrentForm->getValue("x_medida3");
		if (!$this->medida3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->medida3->Visible = FALSE; // Disable update for API request
			else
				$this->medida3->setFormValue($val);
		}

		// Check field name 'codlogin' first before field var 'x_codlogin'
		$val = $CurrentForm->hasValue("codlogin") ? $CurrentForm->getValue("codlogin") : $CurrentForm->getValue("x_codlogin");
		if (!$this->codlogin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codlogin->Visible = FALSE; // Disable update for API request
			else
				$this->codlogin->setFormValue($val);
		}

		// Check field name 'idempresa' first before field var 'x_idempresa'
		$val = $CurrentForm->hasValue("idempresa") ? $CurrentForm->getValue("idempresa") : $CurrentForm->getValue("x_idempresa");
		if (!$this->idempresa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idempresa->Visible = FALSE; // Disable update for API request
			else
				$this->idempresa->setFormValue($val);
		}

		// Check field name 'urlstreetview' first before field var 'x_urlstreetview'
		$val = $CurrentForm->hasValue("urlstreetview") ? $CurrentForm->getValue("urlstreetview") : $CurrentForm->getValue("x_urlstreetview");
		if (!$this->urlstreetview->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->urlstreetview->Visible = FALSE; // Disable update for API request
			else
				$this->urlstreetview->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id_producto->CurrentValue = $this->id_producto->FormValue;
		$this->codigo_producto->CurrentValue = $this->codigo_producto->FormValue;
		$this->nombre_producto->CurrentValue = $this->nombre_producto->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->status_producto->CurrentValue = $this->status_producto->FormValue;
		$this->date_added->CurrentValue = $this->date_added->FormValue;
		$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		$this->precio_producto->CurrentValue = $this->precio_producto->FormValue;
		$this->costo_producto->CurrentValue = $this->costo_producto->FormValue;
		$this->mon_costo->CurrentValue = $this->mon_costo->FormValue;
		$this->mon_venta->CurrentValue = $this->mon_venta->FormValue;
		$this->pais->CurrentValue = $this->pais->FormValue;
		$this->departamento->CurrentValue = $this->departamento->FormValue;
		$this->distrito->CurrentValue = $this->distrito->FormValue;
		$this->localidad->CurrentValue = $this->localidad->FormValue;
		$this->zona->CurrentValue = $this->zona->FormValue;
		$this->tipo_inmueble->CurrentValue = $this->tipo_inmueble->FormValue;
		$this->tipo_negocio->CurrentValue = $this->tipo_negocio->FormValue;
		$this->tiempo_alquiler->CurrentValue = $this->tiempo_alquiler->FormValue;
		$this->moneda->CurrentValue = $this->moneda->FormValue;
		$this->estado_inmueble->CurrentValue = $this->estado_inmueble->FormValue;
		$this->area_construida->CurrentValue = $this->area_construida->FormValue;
		$this->area_privada->CurrentValue = $this->area_privada->FormValue;
		$this->area_terreno->CurrentValue = $this->area_terreno->FormValue;
		$this->valor_administracion->CurrentValue = $this->valor_administracion->FormValue;
		$this->dormitorios->CurrentValue = $this->dormitorios->FormValue;
		$this->banios->CurrentValue = $this->banios->FormValue;
		$this->garaje->CurrentValue = $this->garaje->FormValue;
		$this->piso->CurrentValue = $this->piso->FormValue;
		$this->estrato->CurrentValue = $this->estrato->FormValue;
		$this->direccion->CurrentValue = $this->direccion->FormValue;
		$this->codigo_postal->CurrentValue = $this->codigo_postal->FormValue;
		$this->mapa->CurrentValue = $this->mapa->FormValue;
		$this->latitud->CurrentValue = $this->latitud->FormValue;
		$this->longitud->CurrentValue = $this->longitud->FormValue;
		$this->opciones_mapa->CurrentValue = $this->opciones_mapa->FormValue;
		$this->red->CurrentValue = $this->red->FormValue;
		$this->video->CurrentValue = $this->video->FormValue;
		$this->disponibilidad->CurrentValue = $this->disponibilidad->FormValue;
		$this->anio_construccion->CurrentValue = $this->anio_construccion->FormValue;
		$this->encargado->CurrentValue = $this->encargado->FormValue;
		$this->comentario->CurrentValue = $this->comentario->FormValue;
		$this->visitas->CurrentValue = $this->visitas->FormValue;
		$this->valor_comision->CurrentValue = $this->valor_comision->FormValue;
		$this->tipo_comision->CurrentValue = $this->tipo_comision->FormValue;
		$this->certificado->CurrentValue = $this->certificado->FormValue;
		$this->nombre_propietario->CurrentValue = $this->nombre_propietario->FormValue;
		$this->movil_propietario->CurrentValue = $this->movil_propietario->FormValue;
		$this->telefono_propietario->CurrentValue = $this->telefono_propietario->FormValue;
		$this->correo_propietario->CurrentValue = $this->correo_propietario->FormValue;
		$this->vinculo->CurrentValue = $this->vinculo->FormValue;
		$this->portales->CurrentValue = $this->portales->FormValue;
		$this->notas->CurrentValue = $this->notas->FormValue;
		$this->marca->CurrentValue = $this->marca->FormValue;
		$this->modelo->CurrentValue = $this->modelo->FormValue;
		$this->color->CurrentValue = $this->color->FormValue;
		$this->b1->CurrentValue = $this->b1->FormValue;
		$this->b2->CurrentValue = $this->b2->FormValue;
		$this->b3->CurrentValue = $this->b3->FormValue;
		$this->b4->CurrentValue = $this->b4->FormValue;
		$this->b5->CurrentValue = $this->b5->FormValue;
		$this->b6->CurrentValue = $this->b6->FormValue;
		$this->cat_pro->CurrentValue = $this->cat_pro->FormValue;
		$this->pro_ser->CurrentValue = $this->pro_ser->FormValue;
		$this->foto1->CurrentValue = $this->foto1->FormValue;
		$this->foto2->CurrentValue = $this->foto2->FormValue;
		$this->foto3->CurrentValue = $this->foto3->FormValue;
		$this->foto4->CurrentValue = $this->foto4->FormValue;
		$this->web->CurrentValue = $this->web->FormValue;
		$this->pre_web->CurrentValue = $this->pre_web->FormValue;
		$this->descripcion->CurrentValue = $this->descripcion->FormValue;
		$this->descripcion1->CurrentValue = $this->descripcion1->FormValue;
		$this->megusta->CurrentValue = $this->megusta->FormValue;
		$this->nomegusta->CurrentValue = $this->nomegusta->FormValue;
		$this->precio2->CurrentValue = $this->precio2->FormValue;
		$this->precio3->CurrentValue = $this->precio3->FormValue;
		$this->und_pro->CurrentValue = $this->und_pro->FormValue;
		$this->barras->CurrentValue = $this->barras->FormValue;
		$this->stockmin->CurrentValue = $this->stockmin->FormValue;
		$this->id_grupo->CurrentValue = $this->id_grupo->FormValue;
		$this->talla->CurrentValue = $this->talla->FormValue;
		$this->mostrarcolor->CurrentValue = $this->mostrarcolor->FormValue;
		$this->precio_mayorista->CurrentValue = $this->precio_mayorista->FormValue;
		$this->precio_vendedor->CurrentValue = $this->precio_vendedor->FormValue;
		$this->medida1->CurrentValue = $this->medida1->FormValue;
		$this->medida2->CurrentValue = $this->medida2->FormValue;
		$this->medida3->CurrentValue = $this->medida3->FormValue;
		$this->codlogin->CurrentValue = $this->codlogin->FormValue;
		$this->idempresa->CurrentValue = $this->idempresa->FormValue;
		$this->urlstreetview->CurrentValue = $this->urlstreetview->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->estado->setDbValue($row['estado']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->pais->setDbValue($row['pais']);
		$this->departamento->setDbValue($row['departamento']);
		$this->distrito->setDbValue($row['distrito']);
		$this->localidad->setDbValue($row['localidad']);
		$this->zona->setDbValue($row['zona']);
		$this->tipo_inmueble->setDbValue($row['tipo_inmueble']);
		$this->tipo_negocio->setDbValue($row['tipo_negocio']);
		$this->tiempo_alquiler->setDbValue($row['tiempo_alquiler']);
		$this->moneda->setDbValue($row['moneda']);
		$this->estado_inmueble->setDbValue($row['estado_inmueble']);
		$this->area_construida->setDbValue($row['area_construida']);
		$this->area_privada->setDbValue($row['area_privada']);
		$this->area_terreno->setDbValue($row['area_terreno']);
		$this->valor_administracion->setDbValue($row['valor_administracion']);
		$this->dormitorios->setDbValue($row['dormitorios']);
		$this->banios->setDbValue($row['banios']);
		$this->garaje->setDbValue($row['garaje']);
		$this->piso->setDbValue($row['piso']);
		$this->estrato->setDbValue($row['estrato']);
		$this->direccion->setDbValue($row['direccion']);
		$this->codigo_postal->setDbValue($row['codigo_postal']);
		$this->mapa->setDbValue($row['mapa']);
		$this->latitud->setDbValue($row['latitud']);
		$this->longitud->setDbValue($row['longitud']);
		$this->opciones_mapa->setDbValue($row['opciones_mapa']);
		$this->red->setDbValue($row['red']);
		$this->video->setDbValue($row['video']);
		$this->disponibilidad->setDbValue($row['disponibilidad']);
		$this->anio_construccion->setDbValue($row['anio_construccion']);
		$this->encargado->setDbValue($row['encargado']);
		$this->comentario->setDbValue($row['comentario']);
		$this->visitas->setDbValue($row['visitas']);
		$this->valor_comision->setDbValue($row['valor_comision']);
		$this->tipo_comision->setDbValue($row['tipo_comision']);
		$this->certificado->setDbValue($row['certificado']);
		$this->nombre_propietario->setDbValue($row['nombre_propietario']);
		$this->movil_propietario->setDbValue($row['movil_propietario']);
		$this->telefono_propietario->setDbValue($row['telefono_propietario']);
		$this->correo_propietario->setDbValue($row['correo_propietario']);
		$this->vinculo->setDbValue($row['vinculo']);
		$this->portales->setDbValue($row['portales']);
		$this->notas->setDbValue($row['notas']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->precio_mayorista->setDbValue($row['precio_mayorista']);
		$this->precio_vendedor->setDbValue($row['precio_vendedor']);
		$this->medida1->setDbValue($row['medida1']);
		$this->medida2->setDbValue($row['medida2']);
		$this->medida3->setDbValue($row['medida3']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->urlstreetview->setDbValue($row['urlstreetview']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_producto'] = NULL;
		$row['codigo_producto'] = NULL;
		$row['nombre_producto'] = NULL;
		$row['estado'] = NULL;
		$row['status_producto'] = NULL;
		$row['date_added'] = NULL;
		$row['precio_producto'] = NULL;
		$row['costo_producto'] = NULL;
		$row['mon_costo'] = NULL;
		$row['mon_venta'] = NULL;
		$row['pais'] = NULL;
		$row['departamento'] = NULL;
		$row['distrito'] = NULL;
		$row['localidad'] = NULL;
		$row['zona'] = NULL;
		$row['tipo_inmueble'] = NULL;
		$row['tipo_negocio'] = NULL;
		$row['tiempo_alquiler'] = NULL;
		$row['moneda'] = NULL;
		$row['estado_inmueble'] = NULL;
		$row['area_construida'] = NULL;
		$row['area_privada'] = NULL;
		$row['area_terreno'] = NULL;
		$row['valor_administracion'] = NULL;
		$row['dormitorios'] = NULL;
		$row['banios'] = NULL;
		$row['garaje'] = NULL;
		$row['piso'] = NULL;
		$row['estrato'] = NULL;
		$row['direccion'] = NULL;
		$row['codigo_postal'] = NULL;
		$row['mapa'] = NULL;
		$row['latitud'] = NULL;
		$row['longitud'] = NULL;
		$row['opciones_mapa'] = NULL;
		$row['red'] = NULL;
		$row['video'] = NULL;
		$row['disponibilidad'] = NULL;
		$row['anio_construccion'] = NULL;
		$row['encargado'] = NULL;
		$row['comentario'] = NULL;
		$row['visitas'] = NULL;
		$row['valor_comision'] = NULL;
		$row['tipo_comision'] = NULL;
		$row['certificado'] = NULL;
		$row['nombre_propietario'] = NULL;
		$row['movil_propietario'] = NULL;
		$row['telefono_propietario'] = NULL;
		$row['correo_propietario'] = NULL;
		$row['vinculo'] = NULL;
		$row['portales'] = NULL;
		$row['notas'] = NULL;
		$row['marca'] = NULL;
		$row['modelo'] = NULL;
		$row['color'] = NULL;
		$row['b1'] = NULL;
		$row['b2'] = NULL;
		$row['b3'] = NULL;
		$row['b4'] = NULL;
		$row['b5'] = NULL;
		$row['b6'] = NULL;
		$row['cat_pro'] = NULL;
		$row['pro_ser'] = NULL;
		$row['foto1'] = NULL;
		$row['foto2'] = NULL;
		$row['foto3'] = NULL;
		$row['foto4'] = NULL;
		$row['web'] = NULL;
		$row['pre_web'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcion1'] = NULL;
		$row['megusta'] = NULL;
		$row['nomegusta'] = NULL;
		$row['precio2'] = NULL;
		$row['precio3'] = NULL;
		$row['und_pro'] = NULL;
		$row['barras'] = NULL;
		$row['stockmin'] = NULL;
		$row['id_grupo'] = NULL;
		$row['talla'] = NULL;
		$row['mostrarcolor'] = NULL;
		$row['precio_mayorista'] = NULL;
		$row['precio_vendedor'] = NULL;
		$row['medida1'] = NULL;
		$row['medida2'] = NULL;
		$row['medida3'] = NULL;
		$row['codlogin'] = NULL;
		$row['idempresa'] = NULL;
		$row['urlstreetview'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_producto")) != "")
			$this->id_producto->OldValue = $this->getKey("id_producto"); // id_producto
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->valor_comision->FormValue == $this->valor_comision->CurrentValue && is_numeric(ConvertToFloatString($this->valor_comision->CurrentValue)))
			$this->valor_comision->CurrentValue = ConvertToFloatString($this->valor_comision->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_mayorista->FormValue == $this->precio_mayorista->CurrentValue && is_numeric(ConvertToFloatString($this->precio_mayorista->CurrentValue)))
			$this->precio_mayorista->CurrentValue = ConvertToFloatString($this->precio_mayorista->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_vendedor->FormValue == $this->precio_vendedor->CurrentValue && is_numeric(ConvertToFloatString($this->precio_vendedor->CurrentValue)))
			$this->precio_vendedor->CurrentValue = ConvertToFloatString($this->precio_vendedor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// codigo_producto
		// nombre_producto
		// estado
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// pais
		// departamento
		// distrito
		// localidad
		// zona
		// tipo_inmueble
		// tipo_negocio
		// tiempo_alquiler
		// moneda
		// estado_inmueble
		// area_construida
		// area_privada
		// area_terreno
		// valor_administracion
		// dormitorios
		// banios
		// garaje
		// piso
		// estrato
		// direccion
		// codigo_postal
		// mapa
		// latitud
		// longitud
		// opciones_mapa
		// red
		// video
		// disponibilidad
		// anio_construccion
		// encargado
		// comentario
		// visitas
		// valor_comision
		// tipo_comision
		// certificado
		// nombre_propietario
		// movil_propietario
		// telefono_propietario
		// correo_propietario
		// vinculo
		// portales
		// notas
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// precio_mayorista
		// precio_vendedor
		// medida1
		// medida2
		// medida3
		// codlogin
		// idempresa
		// urlstreetview

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// nombre_producto
			$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
			$this->nombre_producto->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 0, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// departamento
			$this->departamento->ViewValue = $this->departamento->CurrentValue;
			$this->departamento->ViewCustomAttributes = "";

			// distrito
			$this->distrito->ViewValue = $this->distrito->CurrentValue;
			$this->distrito->ViewCustomAttributes = "";

			// localidad
			$this->localidad->ViewValue = $this->localidad->CurrentValue;
			$this->localidad->ViewCustomAttributes = "";

			// zona
			$this->zona->ViewValue = $this->zona->CurrentValue;
			$this->zona->ViewCustomAttributes = "";

			// tipo_inmueble
			$this->tipo_inmueble->ViewValue = $this->tipo_inmueble->CurrentValue;
			$this->tipo_inmueble->ViewValue = FormatNumber($this->tipo_inmueble->ViewValue, 0, -2, -2, -2);
			$this->tipo_inmueble->ViewCustomAttributes = "";

			// tipo_negocio
			$this->tipo_negocio->ViewValue = $this->tipo_negocio->CurrentValue;
			$this->tipo_negocio->ViewCustomAttributes = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->ViewValue = $this->tiempo_alquiler->CurrentValue;
			$this->tiempo_alquiler->ViewCustomAttributes = "";

			// moneda
			$this->moneda->ViewValue = $this->moneda->CurrentValue;
			$this->moneda->ViewCustomAttributes = "";

			// estado_inmueble
			$this->estado_inmueble->ViewValue = $this->estado_inmueble->CurrentValue;
			$this->estado_inmueble->ViewCustomAttributes = "";

			// area_construida
			$this->area_construida->ViewValue = $this->area_construida->CurrentValue;
			$this->area_construida->ViewCustomAttributes = "";

			// area_privada
			$this->area_privada->ViewValue = $this->area_privada->CurrentValue;
			$this->area_privada->ViewCustomAttributes = "";

			// area_terreno
			$this->area_terreno->ViewValue = $this->area_terreno->CurrentValue;
			$this->area_terreno->ViewCustomAttributes = "";

			// valor_administracion
			$this->valor_administracion->ViewValue = $this->valor_administracion->CurrentValue;
			$this->valor_administracion->ViewCustomAttributes = "";

			// dormitorios
			$this->dormitorios->ViewValue = $this->dormitorios->CurrentValue;
			$this->dormitorios->ViewCustomAttributes = "";

			// banios
			$this->banios->ViewValue = $this->banios->CurrentValue;
			$this->banios->ViewCustomAttributes = "";

			// garaje
			$this->garaje->ViewValue = $this->garaje->CurrentValue;
			$this->garaje->ViewCustomAttributes = "";

			// piso
			$this->piso->ViewValue = $this->piso->CurrentValue;
			$this->piso->ViewCustomAttributes = "";

			// estrato
			$this->estrato->ViewValue = $this->estrato->CurrentValue;
			$this->estrato->ViewCustomAttributes = "";

			// direccion
			$this->direccion->ViewValue = $this->direccion->CurrentValue;
			$this->direccion->ViewCustomAttributes = "";

			// codigo_postal
			$this->codigo_postal->ViewValue = $this->codigo_postal->CurrentValue;
			$this->codigo_postal->ViewCustomAttributes = "";

			// mapa
			$this->mapa->ViewValue = $this->mapa->CurrentValue;
			$this->mapa->ViewCustomAttributes = "";

			// latitud
			$this->latitud->ViewValue = $this->latitud->CurrentValue;
			$this->latitud->ViewCustomAttributes = "";

			// longitud
			$this->longitud->ViewValue = $this->longitud->CurrentValue;
			$this->longitud->ViewCustomAttributes = "";

			// opciones_mapa
			$this->opciones_mapa->ViewValue = $this->opciones_mapa->CurrentValue;
			$this->opciones_mapa->ViewCustomAttributes = "";

			// red
			$this->red->ViewValue = $this->red->CurrentValue;
			$this->red->ViewCustomAttributes = "";

			// video
			$this->video->ViewValue = $this->video->CurrentValue;
			$this->video->ViewCustomAttributes = "";

			// disponibilidad
			$this->disponibilidad->ViewValue = $this->disponibilidad->CurrentValue;
			$this->disponibilidad->ViewCustomAttributes = "";

			// anio_construccion
			$this->anio_construccion->ViewValue = $this->anio_construccion->CurrentValue;
			$this->anio_construccion->ViewCustomAttributes = "";

			// encargado
			$this->encargado->ViewValue = $this->encargado->CurrentValue;
			$this->encargado->ViewCustomAttributes = "";

			// comentario
			$this->comentario->ViewValue = $this->comentario->CurrentValue;
			$this->comentario->ViewCustomAttributes = "";

			// visitas
			$this->visitas->ViewValue = $this->visitas->CurrentValue;
			$this->visitas->ViewCustomAttributes = "";

			// valor_comision
			$this->valor_comision->ViewValue = $this->valor_comision->CurrentValue;
			$this->valor_comision->ViewValue = FormatNumber($this->valor_comision->ViewValue, 2, -2, -2, -2);
			$this->valor_comision->ViewCustomAttributes = "";

			// tipo_comision
			$this->tipo_comision->ViewValue = $this->tipo_comision->CurrentValue;
			$this->tipo_comision->ViewCustomAttributes = "";

			// certificado
			$this->certificado->ViewValue = $this->certificado->CurrentValue;
			$this->certificado->ViewCustomAttributes = "";

			// nombre_propietario
			$this->nombre_propietario->ViewValue = $this->nombre_propietario->CurrentValue;
			$this->nombre_propietario->ViewCustomAttributes = "";

			// movil_propietario
			$this->movil_propietario->ViewValue = $this->movil_propietario->CurrentValue;
			$this->movil_propietario->ViewCustomAttributes = "";

			// telefono_propietario
			$this->telefono_propietario->ViewValue = $this->telefono_propietario->CurrentValue;
			$this->telefono_propietario->ViewCustomAttributes = "";

			// correo_propietario
			$this->correo_propietario->ViewValue = $this->correo_propietario->CurrentValue;
			$this->correo_propietario->ViewCustomAttributes = "";

			// vinculo
			$this->vinculo->ViewValue = $this->vinculo->CurrentValue;
			$this->vinculo->ViewCustomAttributes = "";

			// portales
			$this->portales->ViewValue = $this->portales->CurrentValue;
			$this->portales->ViewCustomAttributes = "";

			// notas
			$this->notas->ViewValue = $this->notas->CurrentValue;
			$this->notas->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto1
			$this->foto1->ViewValue = $this->foto1->CurrentValue;
			$this->foto1->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// descripcion
			$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
			$this->descripcion->ViewCustomAttributes = "";

			// descripcion1
			$this->descripcion1->ViewValue = $this->descripcion1->CurrentValue;
			$this->descripcion1->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// precio_mayorista
			$this->precio_mayorista->ViewValue = $this->precio_mayorista->CurrentValue;
			$this->precio_mayorista->ViewValue = FormatNumber($this->precio_mayorista->ViewValue, 2, -2, -2, -2);
			$this->precio_mayorista->ViewCustomAttributes = "";

			// precio_vendedor
			$this->precio_vendedor->ViewValue = $this->precio_vendedor->CurrentValue;
			$this->precio_vendedor->ViewValue = FormatNumber($this->precio_vendedor->ViewValue, 2, -2, -2, -2);
			$this->precio_vendedor->ViewCustomAttributes = "";

			// medida1
			$this->medida1->ViewValue = $this->medida1->CurrentValue;
			$this->medida1->ViewCustomAttributes = "";

			// medida2
			$this->medida2->ViewValue = $this->medida2->CurrentValue;
			$this->medida2->ViewCustomAttributes = "";

			// medida3
			$this->medida3->ViewValue = $this->medida3->CurrentValue;
			$this->medida3->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// urlstreetview
			$this->urlstreetview->ViewValue = $this->urlstreetview->CurrentValue;
			$this->urlstreetview->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";
			$this->nombre_producto->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";
			$this->departamento->TooltipValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";
			$this->distrito->TooltipValue = "";

			// localidad
			$this->localidad->LinkCustomAttributes = "";
			$this->localidad->HrefValue = "";
			$this->localidad->TooltipValue = "";

			// zona
			$this->zona->LinkCustomAttributes = "";
			$this->zona->HrefValue = "";
			$this->zona->TooltipValue = "";

			// tipo_inmueble
			$this->tipo_inmueble->LinkCustomAttributes = "";
			$this->tipo_inmueble->HrefValue = "";
			$this->tipo_inmueble->TooltipValue = "";

			// tipo_negocio
			$this->tipo_negocio->LinkCustomAttributes = "";
			$this->tipo_negocio->HrefValue = "";
			$this->tipo_negocio->TooltipValue = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->LinkCustomAttributes = "";
			$this->tiempo_alquiler->HrefValue = "";
			$this->tiempo_alquiler->TooltipValue = "";

			// moneda
			$this->moneda->LinkCustomAttributes = "";
			$this->moneda->HrefValue = "";
			$this->moneda->TooltipValue = "";

			// estado_inmueble
			$this->estado_inmueble->LinkCustomAttributes = "";
			$this->estado_inmueble->HrefValue = "";
			$this->estado_inmueble->TooltipValue = "";

			// area_construida
			$this->area_construida->LinkCustomAttributes = "";
			$this->area_construida->HrefValue = "";
			$this->area_construida->TooltipValue = "";

			// area_privada
			$this->area_privada->LinkCustomAttributes = "";
			$this->area_privada->HrefValue = "";
			$this->area_privada->TooltipValue = "";

			// area_terreno
			$this->area_terreno->LinkCustomAttributes = "";
			$this->area_terreno->HrefValue = "";
			$this->area_terreno->TooltipValue = "";

			// valor_administracion
			$this->valor_administracion->LinkCustomAttributes = "";
			$this->valor_administracion->HrefValue = "";
			$this->valor_administracion->TooltipValue = "";

			// dormitorios
			$this->dormitorios->LinkCustomAttributes = "";
			$this->dormitorios->HrefValue = "";
			$this->dormitorios->TooltipValue = "";

			// banios
			$this->banios->LinkCustomAttributes = "";
			$this->banios->HrefValue = "";
			$this->banios->TooltipValue = "";

			// garaje
			$this->garaje->LinkCustomAttributes = "";
			$this->garaje->HrefValue = "";
			$this->garaje->TooltipValue = "";

			// piso
			$this->piso->LinkCustomAttributes = "";
			$this->piso->HrefValue = "";
			$this->piso->TooltipValue = "";

			// estrato
			$this->estrato->LinkCustomAttributes = "";
			$this->estrato->HrefValue = "";
			$this->estrato->TooltipValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";
			$this->direccion->TooltipValue = "";

			// codigo_postal
			$this->codigo_postal->LinkCustomAttributes = "";
			$this->codigo_postal->HrefValue = "";
			$this->codigo_postal->TooltipValue = "";

			// mapa
			$this->mapa->LinkCustomAttributes = "";
			$this->mapa->HrefValue = "";
			$this->mapa->TooltipValue = "";

			// latitud
			$this->latitud->LinkCustomAttributes = "";
			$this->latitud->HrefValue = "";
			$this->latitud->TooltipValue = "";

			// longitud
			$this->longitud->LinkCustomAttributes = "";
			$this->longitud->HrefValue = "";
			$this->longitud->TooltipValue = "";

			// opciones_mapa
			$this->opciones_mapa->LinkCustomAttributes = "";
			$this->opciones_mapa->HrefValue = "";
			$this->opciones_mapa->TooltipValue = "";

			// red
			$this->red->LinkCustomAttributes = "";
			$this->red->HrefValue = "";
			$this->red->TooltipValue = "";

			// video
			$this->video->LinkCustomAttributes = "";
			$this->video->HrefValue = "";
			$this->video->TooltipValue = "";

			// disponibilidad
			$this->disponibilidad->LinkCustomAttributes = "";
			$this->disponibilidad->HrefValue = "";
			$this->disponibilidad->TooltipValue = "";

			// anio_construccion
			$this->anio_construccion->LinkCustomAttributes = "";
			$this->anio_construccion->HrefValue = "";
			$this->anio_construccion->TooltipValue = "";

			// encargado
			$this->encargado->LinkCustomAttributes = "";
			$this->encargado->HrefValue = "";
			$this->encargado->TooltipValue = "";

			// comentario
			$this->comentario->LinkCustomAttributes = "";
			$this->comentario->HrefValue = "";
			$this->comentario->TooltipValue = "";

			// visitas
			$this->visitas->LinkCustomAttributes = "";
			$this->visitas->HrefValue = "";
			$this->visitas->TooltipValue = "";

			// valor_comision
			$this->valor_comision->LinkCustomAttributes = "";
			$this->valor_comision->HrefValue = "";
			$this->valor_comision->TooltipValue = "";

			// tipo_comision
			$this->tipo_comision->LinkCustomAttributes = "";
			$this->tipo_comision->HrefValue = "";
			$this->tipo_comision->TooltipValue = "";

			// certificado
			$this->certificado->LinkCustomAttributes = "";
			$this->certificado->HrefValue = "";
			$this->certificado->TooltipValue = "";

			// nombre_propietario
			$this->nombre_propietario->LinkCustomAttributes = "";
			$this->nombre_propietario->HrefValue = "";
			$this->nombre_propietario->TooltipValue = "";

			// movil_propietario
			$this->movil_propietario->LinkCustomAttributes = "";
			$this->movil_propietario->HrefValue = "";
			$this->movil_propietario->TooltipValue = "";

			// telefono_propietario
			$this->telefono_propietario->LinkCustomAttributes = "";
			$this->telefono_propietario->HrefValue = "";
			$this->telefono_propietario->TooltipValue = "";

			// correo_propietario
			$this->correo_propietario->LinkCustomAttributes = "";
			$this->correo_propietario->HrefValue = "";
			$this->correo_propietario->TooltipValue = "";

			// vinculo
			$this->vinculo->LinkCustomAttributes = "";
			$this->vinculo->HrefValue = "";
			$this->vinculo->TooltipValue = "";

			// portales
			$this->portales->LinkCustomAttributes = "";
			$this->portales->HrefValue = "";
			$this->portales->TooltipValue = "";

			// notas
			$this->notas->LinkCustomAttributes = "";
			$this->notas->HrefValue = "";
			$this->notas->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";
			$this->foto1->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";
			$this->descripcion->TooltipValue = "";

			// descripcion1
			$this->descripcion1->LinkCustomAttributes = "";
			$this->descripcion1->HrefValue = "";
			$this->descripcion1->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// precio_mayorista
			$this->precio_mayorista->LinkCustomAttributes = "";
			$this->precio_mayorista->HrefValue = "";
			$this->precio_mayorista->TooltipValue = "";

			// precio_vendedor
			$this->precio_vendedor->LinkCustomAttributes = "";
			$this->precio_vendedor->HrefValue = "";
			$this->precio_vendedor->TooltipValue = "";

			// medida1
			$this->medida1->LinkCustomAttributes = "";
			$this->medida1->HrefValue = "";
			$this->medida1->TooltipValue = "";

			// medida2
			$this->medida2->LinkCustomAttributes = "";
			$this->medida2->HrefValue = "";
			$this->medida2->TooltipValue = "";

			// medida3
			$this->medida3->LinkCustomAttributes = "";
			$this->medida3->HrefValue = "";
			$this->medida3->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// urlstreetview
			$this->urlstreetview->LinkCustomAttributes = "";
			$this->urlstreetview->HrefValue = "";
			$this->urlstreetview->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id_producto
			$this->id_producto->EditAttrs["class"] = "form-control";
			$this->id_producto->EditCustomAttributes = "";
			$this->id_producto->EditValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->EditAttrs["class"] = "form-control";
			$this->codigo_producto->EditCustomAttributes = "";
			if (!$this->codigo_producto->Raw)
				$this->codigo_producto->CurrentValue = HtmlDecode($this->codigo_producto->CurrentValue);
			$this->codigo_producto->EditValue = HtmlEncode($this->codigo_producto->CurrentValue);
			$this->codigo_producto->PlaceHolder = RemoveHtml($this->codigo_producto->caption());

			// nombre_producto
			$this->nombre_producto->EditAttrs["class"] = "form-control";
			$this->nombre_producto->EditCustomAttributes = "";
			$this->nombre_producto->EditValue = HtmlEncode($this->nombre_producto->CurrentValue);
			$this->nombre_producto->PlaceHolder = RemoveHtml($this->nombre_producto->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// status_producto
			$this->status_producto->EditAttrs["class"] = "form-control";
			$this->status_producto->EditCustomAttributes = "";
			$this->status_producto->EditValue = HtmlEncode($this->status_producto->CurrentValue);
			$this->status_producto->PlaceHolder = RemoveHtml($this->status_producto->caption());

			// date_added
			$this->date_added->EditAttrs["class"] = "form-control";
			$this->date_added->EditCustomAttributes = "";
			$this->date_added->EditValue = HtmlEncode(FormatDateTime($this->date_added->CurrentValue, 8));
			$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

			// precio_producto
			$this->precio_producto->EditAttrs["class"] = "form-control";
			$this->precio_producto->EditCustomAttributes = "";
			$this->precio_producto->EditValue = HtmlEncode($this->precio_producto->CurrentValue);
			$this->precio_producto->PlaceHolder = RemoveHtml($this->precio_producto->caption());
			if (strval($this->precio_producto->EditValue) != "" && is_numeric($this->precio_producto->EditValue))
				$this->precio_producto->EditValue = FormatNumber($this->precio_producto->EditValue, -2, -2, -2, -2);
			

			// costo_producto
			$this->costo_producto->EditAttrs["class"] = "form-control";
			$this->costo_producto->EditCustomAttributes = "";
			$this->costo_producto->EditValue = HtmlEncode($this->costo_producto->CurrentValue);
			$this->costo_producto->PlaceHolder = RemoveHtml($this->costo_producto->caption());
			if (strval($this->costo_producto->EditValue) != "" && is_numeric($this->costo_producto->EditValue))
				$this->costo_producto->EditValue = FormatNumber($this->costo_producto->EditValue, -2, -2, -2, -2);
			

			// mon_costo
			$this->mon_costo->EditAttrs["class"] = "form-control";
			$this->mon_costo->EditCustomAttributes = "";
			$this->mon_costo->EditValue = HtmlEncode($this->mon_costo->CurrentValue);
			$this->mon_costo->PlaceHolder = RemoveHtml($this->mon_costo->caption());
			if (strval($this->mon_costo->EditValue) != "" && is_numeric($this->mon_costo->EditValue))
				$this->mon_costo->EditValue = FormatNumber($this->mon_costo->EditValue, -2, -2, -2, -2);
			

			// mon_venta
			$this->mon_venta->EditAttrs["class"] = "form-control";
			$this->mon_venta->EditCustomAttributes = "";
			$this->mon_venta->EditValue = HtmlEncode($this->mon_venta->CurrentValue);
			$this->mon_venta->PlaceHolder = RemoveHtml($this->mon_venta->caption());

			// pais
			$this->pais->EditAttrs["class"] = "form-control";
			$this->pais->EditCustomAttributes = "";
			if (!$this->pais->Raw)
				$this->pais->CurrentValue = HtmlDecode($this->pais->CurrentValue);
			$this->pais->EditValue = HtmlEncode($this->pais->CurrentValue);
			$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

			// departamento
			$this->departamento->EditAttrs["class"] = "form-control";
			$this->departamento->EditCustomAttributes = "";
			if (!$this->departamento->Raw)
				$this->departamento->CurrentValue = HtmlDecode($this->departamento->CurrentValue);
			$this->departamento->EditValue = HtmlEncode($this->departamento->CurrentValue);
			$this->departamento->PlaceHolder = RemoveHtml($this->departamento->caption());

			// distrito
			$this->distrito->EditAttrs["class"] = "form-control";
			$this->distrito->EditCustomAttributes = "";
			if (!$this->distrito->Raw)
				$this->distrito->CurrentValue = HtmlDecode($this->distrito->CurrentValue);
			$this->distrito->EditValue = HtmlEncode($this->distrito->CurrentValue);
			$this->distrito->PlaceHolder = RemoveHtml($this->distrito->caption());

			// localidad
			$this->localidad->EditAttrs["class"] = "form-control";
			$this->localidad->EditCustomAttributes = "";
			if (!$this->localidad->Raw)
				$this->localidad->CurrentValue = HtmlDecode($this->localidad->CurrentValue);
			$this->localidad->EditValue = HtmlEncode($this->localidad->CurrentValue);
			$this->localidad->PlaceHolder = RemoveHtml($this->localidad->caption());

			// zona
			$this->zona->EditAttrs["class"] = "form-control";
			$this->zona->EditCustomAttributes = "";
			if (!$this->zona->Raw)
				$this->zona->CurrentValue = HtmlDecode($this->zona->CurrentValue);
			$this->zona->EditValue = HtmlEncode($this->zona->CurrentValue);
			$this->zona->PlaceHolder = RemoveHtml($this->zona->caption());

			// tipo_inmueble
			$this->tipo_inmueble->EditAttrs["class"] = "form-control";
			$this->tipo_inmueble->EditCustomAttributes = "";
			$this->tipo_inmueble->EditValue = HtmlEncode($this->tipo_inmueble->CurrentValue);
			$this->tipo_inmueble->PlaceHolder = RemoveHtml($this->tipo_inmueble->caption());

			// tipo_negocio
			$this->tipo_negocio->EditAttrs["class"] = "form-control";
			$this->tipo_negocio->EditCustomAttributes = "";
			if (!$this->tipo_negocio->Raw)
				$this->tipo_negocio->CurrentValue = HtmlDecode($this->tipo_negocio->CurrentValue);
			$this->tipo_negocio->EditValue = HtmlEncode($this->tipo_negocio->CurrentValue);
			$this->tipo_negocio->PlaceHolder = RemoveHtml($this->tipo_negocio->caption());

			// tiempo_alquiler
			$this->tiempo_alquiler->EditAttrs["class"] = "form-control";
			$this->tiempo_alquiler->EditCustomAttributes = "";
			if (!$this->tiempo_alquiler->Raw)
				$this->tiempo_alquiler->CurrentValue = HtmlDecode($this->tiempo_alquiler->CurrentValue);
			$this->tiempo_alquiler->EditValue = HtmlEncode($this->tiempo_alquiler->CurrentValue);
			$this->tiempo_alquiler->PlaceHolder = RemoveHtml($this->tiempo_alquiler->caption());

			// moneda
			$this->moneda->EditAttrs["class"] = "form-control";
			$this->moneda->EditCustomAttributes = "";
			if (!$this->moneda->Raw)
				$this->moneda->CurrentValue = HtmlDecode($this->moneda->CurrentValue);
			$this->moneda->EditValue = HtmlEncode($this->moneda->CurrentValue);
			$this->moneda->PlaceHolder = RemoveHtml($this->moneda->caption());

			// estado_inmueble
			$this->estado_inmueble->EditAttrs["class"] = "form-control";
			$this->estado_inmueble->EditCustomAttributes = "";
			if (!$this->estado_inmueble->Raw)
				$this->estado_inmueble->CurrentValue = HtmlDecode($this->estado_inmueble->CurrentValue);
			$this->estado_inmueble->EditValue = HtmlEncode($this->estado_inmueble->CurrentValue);
			$this->estado_inmueble->PlaceHolder = RemoveHtml($this->estado_inmueble->caption());

			// area_construida
			$this->area_construida->EditAttrs["class"] = "form-control";
			$this->area_construida->EditCustomAttributes = "";
			if (!$this->area_construida->Raw)
				$this->area_construida->CurrentValue = HtmlDecode($this->area_construida->CurrentValue);
			$this->area_construida->EditValue = HtmlEncode($this->area_construida->CurrentValue);
			$this->area_construida->PlaceHolder = RemoveHtml($this->area_construida->caption());

			// area_privada
			$this->area_privada->EditAttrs["class"] = "form-control";
			$this->area_privada->EditCustomAttributes = "";
			if (!$this->area_privada->Raw)
				$this->area_privada->CurrentValue = HtmlDecode($this->area_privada->CurrentValue);
			$this->area_privada->EditValue = HtmlEncode($this->area_privada->CurrentValue);
			$this->area_privada->PlaceHolder = RemoveHtml($this->area_privada->caption());

			// area_terreno
			$this->area_terreno->EditAttrs["class"] = "form-control";
			$this->area_terreno->EditCustomAttributes = "";
			if (!$this->area_terreno->Raw)
				$this->area_terreno->CurrentValue = HtmlDecode($this->area_terreno->CurrentValue);
			$this->area_terreno->EditValue = HtmlEncode($this->area_terreno->CurrentValue);
			$this->area_terreno->PlaceHolder = RemoveHtml($this->area_terreno->caption());

			// valor_administracion
			$this->valor_administracion->EditAttrs["class"] = "form-control";
			$this->valor_administracion->EditCustomAttributes = "";
			if (!$this->valor_administracion->Raw)
				$this->valor_administracion->CurrentValue = HtmlDecode($this->valor_administracion->CurrentValue);
			$this->valor_administracion->EditValue = HtmlEncode($this->valor_administracion->CurrentValue);
			$this->valor_administracion->PlaceHolder = RemoveHtml($this->valor_administracion->caption());

			// dormitorios
			$this->dormitorios->EditAttrs["class"] = "form-control";
			$this->dormitorios->EditCustomAttributes = "";
			if (!$this->dormitorios->Raw)
				$this->dormitorios->CurrentValue = HtmlDecode($this->dormitorios->CurrentValue);
			$this->dormitorios->EditValue = HtmlEncode($this->dormitorios->CurrentValue);
			$this->dormitorios->PlaceHolder = RemoveHtml($this->dormitorios->caption());

			// banios
			$this->banios->EditAttrs["class"] = "form-control";
			$this->banios->EditCustomAttributes = "";
			if (!$this->banios->Raw)
				$this->banios->CurrentValue = HtmlDecode($this->banios->CurrentValue);
			$this->banios->EditValue = HtmlEncode($this->banios->CurrentValue);
			$this->banios->PlaceHolder = RemoveHtml($this->banios->caption());

			// garaje
			$this->garaje->EditAttrs["class"] = "form-control";
			$this->garaje->EditCustomAttributes = "";
			if (!$this->garaje->Raw)
				$this->garaje->CurrentValue = HtmlDecode($this->garaje->CurrentValue);
			$this->garaje->EditValue = HtmlEncode($this->garaje->CurrentValue);
			$this->garaje->PlaceHolder = RemoveHtml($this->garaje->caption());

			// piso
			$this->piso->EditAttrs["class"] = "form-control";
			$this->piso->EditCustomAttributes = "";
			if (!$this->piso->Raw)
				$this->piso->CurrentValue = HtmlDecode($this->piso->CurrentValue);
			$this->piso->EditValue = HtmlEncode($this->piso->CurrentValue);
			$this->piso->PlaceHolder = RemoveHtml($this->piso->caption());

			// estrato
			$this->estrato->EditAttrs["class"] = "form-control";
			$this->estrato->EditCustomAttributes = "";
			if (!$this->estrato->Raw)
				$this->estrato->CurrentValue = HtmlDecode($this->estrato->CurrentValue);
			$this->estrato->EditValue = HtmlEncode($this->estrato->CurrentValue);
			$this->estrato->PlaceHolder = RemoveHtml($this->estrato->caption());

			// direccion
			$this->direccion->EditAttrs["class"] = "form-control";
			$this->direccion->EditCustomAttributes = "";
			$this->direccion->EditValue = HtmlEncode($this->direccion->CurrentValue);
			$this->direccion->PlaceHolder = RemoveHtml($this->direccion->caption());

			// codigo_postal
			$this->codigo_postal->EditAttrs["class"] = "form-control";
			$this->codigo_postal->EditCustomAttributes = "";
			if (!$this->codigo_postal->Raw)
				$this->codigo_postal->CurrentValue = HtmlDecode($this->codigo_postal->CurrentValue);
			$this->codigo_postal->EditValue = HtmlEncode($this->codigo_postal->CurrentValue);
			$this->codigo_postal->PlaceHolder = RemoveHtml($this->codigo_postal->caption());

			// mapa
			$this->mapa->EditAttrs["class"] = "form-control";
			$this->mapa->EditCustomAttributes = "";
			if (!$this->mapa->Raw)
				$this->mapa->CurrentValue = HtmlDecode($this->mapa->CurrentValue);
			$this->mapa->EditValue = HtmlEncode($this->mapa->CurrentValue);
			$this->mapa->PlaceHolder = RemoveHtml($this->mapa->caption());

			// latitud
			$this->latitud->EditAttrs["class"] = "form-control";
			$this->latitud->EditCustomAttributes = "";
			if (!$this->latitud->Raw)
				$this->latitud->CurrentValue = HtmlDecode($this->latitud->CurrentValue);
			$this->latitud->EditValue = HtmlEncode($this->latitud->CurrentValue);
			$this->latitud->PlaceHolder = RemoveHtml($this->latitud->caption());

			// longitud
			$this->longitud->EditAttrs["class"] = "form-control";
			$this->longitud->EditCustomAttributes = "";
			if (!$this->longitud->Raw)
				$this->longitud->CurrentValue = HtmlDecode($this->longitud->CurrentValue);
			$this->longitud->EditValue = HtmlEncode($this->longitud->CurrentValue);
			$this->longitud->PlaceHolder = RemoveHtml($this->longitud->caption());

			// opciones_mapa
			$this->opciones_mapa->EditAttrs["class"] = "form-control";
			$this->opciones_mapa->EditCustomAttributes = "";
			if (!$this->opciones_mapa->Raw)
				$this->opciones_mapa->CurrentValue = HtmlDecode($this->opciones_mapa->CurrentValue);
			$this->opciones_mapa->EditValue = HtmlEncode($this->opciones_mapa->CurrentValue);
			$this->opciones_mapa->PlaceHolder = RemoveHtml($this->opciones_mapa->caption());

			// red
			$this->red->EditAttrs["class"] = "form-control";
			$this->red->EditCustomAttributes = "";
			if (!$this->red->Raw)
				$this->red->CurrentValue = HtmlDecode($this->red->CurrentValue);
			$this->red->EditValue = HtmlEncode($this->red->CurrentValue);
			$this->red->PlaceHolder = RemoveHtml($this->red->caption());

			// video
			$this->video->EditAttrs["class"] = "form-control";
			$this->video->EditCustomAttributes = "";
			$this->video->EditValue = HtmlEncode($this->video->CurrentValue);
			$this->video->PlaceHolder = RemoveHtml($this->video->caption());

			// disponibilidad
			$this->disponibilidad->EditAttrs["class"] = "form-control";
			$this->disponibilidad->EditCustomAttributes = "";
			if (!$this->disponibilidad->Raw)
				$this->disponibilidad->CurrentValue = HtmlDecode($this->disponibilidad->CurrentValue);
			$this->disponibilidad->EditValue = HtmlEncode($this->disponibilidad->CurrentValue);
			$this->disponibilidad->PlaceHolder = RemoveHtml($this->disponibilidad->caption());

			// anio_construccion
			$this->anio_construccion->EditAttrs["class"] = "form-control";
			$this->anio_construccion->EditCustomAttributes = "";
			if (!$this->anio_construccion->Raw)
				$this->anio_construccion->CurrentValue = HtmlDecode($this->anio_construccion->CurrentValue);
			$this->anio_construccion->EditValue = HtmlEncode($this->anio_construccion->CurrentValue);
			$this->anio_construccion->PlaceHolder = RemoveHtml($this->anio_construccion->caption());

			// encargado
			$this->encargado->EditAttrs["class"] = "form-control";
			$this->encargado->EditCustomAttributes = "";
			if (!$this->encargado->Raw)
				$this->encargado->CurrentValue = HtmlDecode($this->encargado->CurrentValue);
			$this->encargado->EditValue = HtmlEncode($this->encargado->CurrentValue);
			$this->encargado->PlaceHolder = RemoveHtml($this->encargado->caption());

			// comentario
			$this->comentario->EditAttrs["class"] = "form-control";
			$this->comentario->EditCustomAttributes = "";
			$this->comentario->EditValue = HtmlEncode($this->comentario->CurrentValue);
			$this->comentario->PlaceHolder = RemoveHtml($this->comentario->caption());

			// visitas
			$this->visitas->EditAttrs["class"] = "form-control";
			$this->visitas->EditCustomAttributes = "";
			if (!$this->visitas->Raw)
				$this->visitas->CurrentValue = HtmlDecode($this->visitas->CurrentValue);
			$this->visitas->EditValue = HtmlEncode($this->visitas->CurrentValue);
			$this->visitas->PlaceHolder = RemoveHtml($this->visitas->caption());

			// valor_comision
			$this->valor_comision->EditAttrs["class"] = "form-control";
			$this->valor_comision->EditCustomAttributes = "";
			$this->valor_comision->EditValue = HtmlEncode($this->valor_comision->CurrentValue);
			$this->valor_comision->PlaceHolder = RemoveHtml($this->valor_comision->caption());
			if (strval($this->valor_comision->EditValue) != "" && is_numeric($this->valor_comision->EditValue))
				$this->valor_comision->EditValue = FormatNumber($this->valor_comision->EditValue, -2, -2, -2, -2);
			

			// tipo_comision
			$this->tipo_comision->EditAttrs["class"] = "form-control";
			$this->tipo_comision->EditCustomAttributes = "";
			if (!$this->tipo_comision->Raw)
				$this->tipo_comision->CurrentValue = HtmlDecode($this->tipo_comision->CurrentValue);
			$this->tipo_comision->EditValue = HtmlEncode($this->tipo_comision->CurrentValue);
			$this->tipo_comision->PlaceHolder = RemoveHtml($this->tipo_comision->caption());

			// certificado
			$this->certificado->EditAttrs["class"] = "form-control";
			$this->certificado->EditCustomAttributes = "";
			if (!$this->certificado->Raw)
				$this->certificado->CurrentValue = HtmlDecode($this->certificado->CurrentValue);
			$this->certificado->EditValue = HtmlEncode($this->certificado->CurrentValue);
			$this->certificado->PlaceHolder = RemoveHtml($this->certificado->caption());

			// nombre_propietario
			$this->nombre_propietario->EditAttrs["class"] = "form-control";
			$this->nombre_propietario->EditCustomAttributes = "";
			if (!$this->nombre_propietario->Raw)
				$this->nombre_propietario->CurrentValue = HtmlDecode($this->nombre_propietario->CurrentValue);
			$this->nombre_propietario->EditValue = HtmlEncode($this->nombre_propietario->CurrentValue);
			$this->nombre_propietario->PlaceHolder = RemoveHtml($this->nombre_propietario->caption());

			// movil_propietario
			$this->movil_propietario->EditAttrs["class"] = "form-control";
			$this->movil_propietario->EditCustomAttributes = "";
			if (!$this->movil_propietario->Raw)
				$this->movil_propietario->CurrentValue = HtmlDecode($this->movil_propietario->CurrentValue);
			$this->movil_propietario->EditValue = HtmlEncode($this->movil_propietario->CurrentValue);
			$this->movil_propietario->PlaceHolder = RemoveHtml($this->movil_propietario->caption());

			// telefono_propietario
			$this->telefono_propietario->EditAttrs["class"] = "form-control";
			$this->telefono_propietario->EditCustomAttributes = "";
			if (!$this->telefono_propietario->Raw)
				$this->telefono_propietario->CurrentValue = HtmlDecode($this->telefono_propietario->CurrentValue);
			$this->telefono_propietario->EditValue = HtmlEncode($this->telefono_propietario->CurrentValue);
			$this->telefono_propietario->PlaceHolder = RemoveHtml($this->telefono_propietario->caption());

			// correo_propietario
			$this->correo_propietario->EditAttrs["class"] = "form-control";
			$this->correo_propietario->EditCustomAttributes = "";
			if (!$this->correo_propietario->Raw)
				$this->correo_propietario->CurrentValue = HtmlDecode($this->correo_propietario->CurrentValue);
			$this->correo_propietario->EditValue = HtmlEncode($this->correo_propietario->CurrentValue);
			$this->correo_propietario->PlaceHolder = RemoveHtml($this->correo_propietario->caption());

			// vinculo
			$this->vinculo->EditAttrs["class"] = "form-control";
			$this->vinculo->EditCustomAttributes = "";
			if (!$this->vinculo->Raw)
				$this->vinculo->CurrentValue = HtmlDecode($this->vinculo->CurrentValue);
			$this->vinculo->EditValue = HtmlEncode($this->vinculo->CurrentValue);
			$this->vinculo->PlaceHolder = RemoveHtml($this->vinculo->caption());

			// portales
			$this->portales->EditAttrs["class"] = "form-control";
			$this->portales->EditCustomAttributes = "";
			$this->portales->EditValue = HtmlEncode($this->portales->CurrentValue);
			$this->portales->PlaceHolder = RemoveHtml($this->portales->caption());

			// notas
			$this->notas->EditAttrs["class"] = "form-control";
			$this->notas->EditCustomAttributes = "";
			if (!$this->notas->Raw)
				$this->notas->CurrentValue = HtmlDecode($this->notas->CurrentValue);
			$this->notas->EditValue = HtmlEncode($this->notas->CurrentValue);
			$this->notas->PlaceHolder = RemoveHtml($this->notas->caption());

			// marca
			$this->marca->EditAttrs["class"] = "form-control";
			$this->marca->EditCustomAttributes = "";
			if (!$this->marca->Raw)
				$this->marca->CurrentValue = HtmlDecode($this->marca->CurrentValue);
			$this->marca->EditValue = HtmlEncode($this->marca->CurrentValue);
			$this->marca->PlaceHolder = RemoveHtml($this->marca->caption());

			// modelo
			$this->modelo->EditAttrs["class"] = "form-control";
			$this->modelo->EditCustomAttributes = "";
			if (!$this->modelo->Raw)
				$this->modelo->CurrentValue = HtmlDecode($this->modelo->CurrentValue);
			$this->modelo->EditValue = HtmlEncode($this->modelo->CurrentValue);
			$this->modelo->PlaceHolder = RemoveHtml($this->modelo->caption());

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (!$this->color->Raw)
				$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
			$this->color->EditValue = HtmlEncode($this->color->CurrentValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// b1
			$this->b1->EditAttrs["class"] = "form-control";
			$this->b1->EditCustomAttributes = "";
			$this->b1->EditValue = HtmlEncode($this->b1->CurrentValue);
			$this->b1->PlaceHolder = RemoveHtml($this->b1->caption());
			if (strval($this->b1->EditValue) != "" && is_numeric($this->b1->EditValue))
				$this->b1->EditValue = FormatNumber($this->b1->EditValue, -2, -2, -2, -2);
			

			// b2
			$this->b2->EditAttrs["class"] = "form-control";
			$this->b2->EditCustomAttributes = "";
			$this->b2->EditValue = HtmlEncode($this->b2->CurrentValue);
			$this->b2->PlaceHolder = RemoveHtml($this->b2->caption());
			if (strval($this->b2->EditValue) != "" && is_numeric($this->b2->EditValue))
				$this->b2->EditValue = FormatNumber($this->b2->EditValue, -2, -2, -2, -2);
			

			// b3
			$this->b3->EditAttrs["class"] = "form-control";
			$this->b3->EditCustomAttributes = "";
			$this->b3->EditValue = HtmlEncode($this->b3->CurrentValue);
			$this->b3->PlaceHolder = RemoveHtml($this->b3->caption());
			if (strval($this->b3->EditValue) != "" && is_numeric($this->b3->EditValue))
				$this->b3->EditValue = FormatNumber($this->b3->EditValue, -2, -2, -2, -2);
			

			// b4
			$this->b4->EditAttrs["class"] = "form-control";
			$this->b4->EditCustomAttributes = "";
			$this->b4->EditValue = HtmlEncode($this->b4->CurrentValue);
			$this->b4->PlaceHolder = RemoveHtml($this->b4->caption());
			if (strval($this->b4->EditValue) != "" && is_numeric($this->b4->EditValue))
				$this->b4->EditValue = FormatNumber($this->b4->EditValue, -2, -2, -2, -2);
			

			// b5
			$this->b5->EditAttrs["class"] = "form-control";
			$this->b5->EditCustomAttributes = "";
			$this->b5->EditValue = HtmlEncode($this->b5->CurrentValue);
			$this->b5->PlaceHolder = RemoveHtml($this->b5->caption());
			if (strval($this->b5->EditValue) != "" && is_numeric($this->b5->EditValue))
				$this->b5->EditValue = FormatNumber($this->b5->EditValue, -2, -2, -2, -2);
			

			// b6
			$this->b6->EditAttrs["class"] = "form-control";
			$this->b6->EditCustomAttributes = "";
			$this->b6->EditValue = HtmlEncode($this->b6->CurrentValue);
			$this->b6->PlaceHolder = RemoveHtml($this->b6->caption());
			if (strval($this->b6->EditValue) != "" && is_numeric($this->b6->EditValue))
				$this->b6->EditValue = FormatNumber($this->b6->EditValue, -2, -2, -2, -2);
			

			// cat_pro
			$this->cat_pro->EditAttrs["class"] = "form-control";
			$this->cat_pro->EditCustomAttributes = "";
			$this->cat_pro->EditValue = HtmlEncode($this->cat_pro->CurrentValue);
			$this->cat_pro->PlaceHolder = RemoveHtml($this->cat_pro->caption());

			// pro_ser
			$this->pro_ser->EditAttrs["class"] = "form-control";
			$this->pro_ser->EditCustomAttributes = "";
			$this->pro_ser->EditValue = HtmlEncode($this->pro_ser->CurrentValue);
			$this->pro_ser->PlaceHolder = RemoveHtml($this->pro_ser->caption());

			// foto1
			$this->foto1->EditAttrs["class"] = "form-control";
			$this->foto1->EditCustomAttributes = "";
			$this->foto1->EditValue = HtmlEncode($this->foto1->CurrentValue);
			$this->foto1->PlaceHolder = RemoveHtml($this->foto1->caption());

			// foto2
			$this->foto2->EditAttrs["class"] = "form-control";
			$this->foto2->EditCustomAttributes = "";
			if (!$this->foto2->Raw)
				$this->foto2->CurrentValue = HtmlDecode($this->foto2->CurrentValue);
			$this->foto2->EditValue = HtmlEncode($this->foto2->CurrentValue);
			$this->foto2->PlaceHolder = RemoveHtml($this->foto2->caption());

			// foto3
			$this->foto3->EditAttrs["class"] = "form-control";
			$this->foto3->EditCustomAttributes = "";
			if (!$this->foto3->Raw)
				$this->foto3->CurrentValue = HtmlDecode($this->foto3->CurrentValue);
			$this->foto3->EditValue = HtmlEncode($this->foto3->CurrentValue);
			$this->foto3->PlaceHolder = RemoveHtml($this->foto3->caption());

			// foto4
			$this->foto4->EditAttrs["class"] = "form-control";
			$this->foto4->EditCustomAttributes = "";
			if (!$this->foto4->Raw)
				$this->foto4->CurrentValue = HtmlDecode($this->foto4->CurrentValue);
			$this->foto4->EditValue = HtmlEncode($this->foto4->CurrentValue);
			$this->foto4->PlaceHolder = RemoveHtml($this->foto4->caption());

			// web
			$this->web->EditAttrs["class"] = "form-control";
			$this->web->EditCustomAttributes = "";
			$this->web->EditValue = HtmlEncode($this->web->CurrentValue);
			$this->web->PlaceHolder = RemoveHtml($this->web->caption());

			// pre_web
			$this->pre_web->EditAttrs["class"] = "form-control";
			$this->pre_web->EditCustomAttributes = "";
			$this->pre_web->EditValue = HtmlEncode($this->pre_web->CurrentValue);
			$this->pre_web->PlaceHolder = RemoveHtml($this->pre_web->caption());
			if (strval($this->pre_web->EditValue) != "" && is_numeric($this->pre_web->EditValue))
				$this->pre_web->EditValue = FormatNumber($this->pre_web->EditValue, -2, -2, -2, -2);
			

			// descripcion
			$this->descripcion->EditAttrs["class"] = "form-control";
			$this->descripcion->EditCustomAttributes = "";
			$this->descripcion->EditValue = HtmlEncode($this->descripcion->CurrentValue);
			$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

			// descripcion1
			$this->descripcion1->EditAttrs["class"] = "form-control";
			$this->descripcion1->EditCustomAttributes = "";
			$this->descripcion1->EditValue = HtmlEncode($this->descripcion1->CurrentValue);
			$this->descripcion1->PlaceHolder = RemoveHtml($this->descripcion1->caption());

			// megusta
			$this->megusta->EditAttrs["class"] = "form-control";
			$this->megusta->EditCustomAttributes = "";
			$this->megusta->EditValue = HtmlEncode($this->megusta->CurrentValue);
			$this->megusta->PlaceHolder = RemoveHtml($this->megusta->caption());

			// nomegusta
			$this->nomegusta->EditAttrs["class"] = "form-control";
			$this->nomegusta->EditCustomAttributes = "";
			$this->nomegusta->EditValue = HtmlEncode($this->nomegusta->CurrentValue);
			$this->nomegusta->PlaceHolder = RemoveHtml($this->nomegusta->caption());

			// precio2
			$this->precio2->EditAttrs["class"] = "form-control";
			$this->precio2->EditCustomAttributes = "";
			$this->precio2->EditValue = HtmlEncode($this->precio2->CurrentValue);
			$this->precio2->PlaceHolder = RemoveHtml($this->precio2->caption());
			if (strval($this->precio2->EditValue) != "" && is_numeric($this->precio2->EditValue))
				$this->precio2->EditValue = FormatNumber($this->precio2->EditValue, -2, -2, -2, -2);
			

			// precio3
			$this->precio3->EditAttrs["class"] = "form-control";
			$this->precio3->EditCustomAttributes = "";
			$this->precio3->EditValue = HtmlEncode($this->precio3->CurrentValue);
			$this->precio3->PlaceHolder = RemoveHtml($this->precio3->caption());
			if (strval($this->precio3->EditValue) != "" && is_numeric($this->precio3->EditValue))
				$this->precio3->EditValue = FormatNumber($this->precio3->EditValue, -2, -2, -2, -2);
			

			// und_pro
			$this->und_pro->EditAttrs["class"] = "form-control";
			$this->und_pro->EditCustomAttributes = "";
			$this->und_pro->EditValue = HtmlEncode($this->und_pro->CurrentValue);
			$this->und_pro->PlaceHolder = RemoveHtml($this->und_pro->caption());

			// barras
			$this->barras->EditAttrs["class"] = "form-control";
			$this->barras->EditCustomAttributes = "";
			if (!$this->barras->Raw)
				$this->barras->CurrentValue = HtmlDecode($this->barras->CurrentValue);
			$this->barras->EditValue = HtmlEncode($this->barras->CurrentValue);
			$this->barras->PlaceHolder = RemoveHtml($this->barras->caption());

			// stockmin
			$this->stockmin->EditAttrs["class"] = "form-control";
			$this->stockmin->EditCustomAttributes = "";
			$this->stockmin->EditValue = HtmlEncode($this->stockmin->CurrentValue);
			$this->stockmin->PlaceHolder = RemoveHtml($this->stockmin->caption());
			if (strval($this->stockmin->EditValue) != "" && is_numeric($this->stockmin->EditValue))
				$this->stockmin->EditValue = FormatNumber($this->stockmin->EditValue, -2, -2, -2, -2);
			

			// id_grupo
			$this->id_grupo->EditAttrs["class"] = "form-control";
			$this->id_grupo->EditCustomAttributes = "";
			$this->id_grupo->EditValue = HtmlEncode($this->id_grupo->CurrentValue);
			$this->id_grupo->PlaceHolder = RemoveHtml($this->id_grupo->caption());

			// talla
			$this->talla->EditAttrs["class"] = "form-control";
			$this->talla->EditCustomAttributes = "";
			if (!$this->talla->Raw)
				$this->talla->CurrentValue = HtmlDecode($this->talla->CurrentValue);
			$this->talla->EditValue = HtmlEncode($this->talla->CurrentValue);
			$this->talla->PlaceHolder = RemoveHtml($this->talla->caption());

			// mostrarcolor
			$this->mostrarcolor->EditAttrs["class"] = "form-control";
			$this->mostrarcolor->EditCustomAttributes = "";
			$this->mostrarcolor->EditValue = HtmlEncode($this->mostrarcolor->CurrentValue);
			$this->mostrarcolor->PlaceHolder = RemoveHtml($this->mostrarcolor->caption());

			// precio_mayorista
			$this->precio_mayorista->EditAttrs["class"] = "form-control";
			$this->precio_mayorista->EditCustomAttributes = "";
			$this->precio_mayorista->EditValue = HtmlEncode($this->precio_mayorista->CurrentValue);
			$this->precio_mayorista->PlaceHolder = RemoveHtml($this->precio_mayorista->caption());
			if (strval($this->precio_mayorista->EditValue) != "" && is_numeric($this->precio_mayorista->EditValue))
				$this->precio_mayorista->EditValue = FormatNumber($this->precio_mayorista->EditValue, -2, -2, -2, -2);
			

			// precio_vendedor
			$this->precio_vendedor->EditAttrs["class"] = "form-control";
			$this->precio_vendedor->EditCustomAttributes = "";
			$this->precio_vendedor->EditValue = HtmlEncode($this->precio_vendedor->CurrentValue);
			$this->precio_vendedor->PlaceHolder = RemoveHtml($this->precio_vendedor->caption());
			if (strval($this->precio_vendedor->EditValue) != "" && is_numeric($this->precio_vendedor->EditValue))
				$this->precio_vendedor->EditValue = FormatNumber($this->precio_vendedor->EditValue, -2, -2, -2, -2);
			

			// medida1
			$this->medida1->EditAttrs["class"] = "form-control";
			$this->medida1->EditCustomAttributes = "";
			if (!$this->medida1->Raw)
				$this->medida1->CurrentValue = HtmlDecode($this->medida1->CurrentValue);
			$this->medida1->EditValue = HtmlEncode($this->medida1->CurrentValue);
			$this->medida1->PlaceHolder = RemoveHtml($this->medida1->caption());

			// medida2
			$this->medida2->EditAttrs["class"] = "form-control";
			$this->medida2->EditCustomAttributes = "";
			if (!$this->medida2->Raw)
				$this->medida2->CurrentValue = HtmlDecode($this->medida2->CurrentValue);
			$this->medida2->EditValue = HtmlEncode($this->medida2->CurrentValue);
			$this->medida2->PlaceHolder = RemoveHtml($this->medida2->caption());

			// medida3
			$this->medida3->EditAttrs["class"] = "form-control";
			$this->medida3->EditCustomAttributes = "";
			if (!$this->medida3->Raw)
				$this->medida3->CurrentValue = HtmlDecode($this->medida3->CurrentValue);
			$this->medida3->EditValue = HtmlEncode($this->medida3->CurrentValue);
			$this->medida3->PlaceHolder = RemoveHtml($this->medida3->caption());

			// codlogin
			$this->codlogin->EditAttrs["class"] = "form-control";
			$this->codlogin->EditCustomAttributes = "";
			if (!$this->codlogin->Raw)
				$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
			$this->codlogin->EditValue = HtmlEncode($this->codlogin->CurrentValue);
			$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

			// idempresa
			$this->idempresa->EditAttrs["class"] = "form-control";
			$this->idempresa->EditCustomAttributes = "";
			$this->idempresa->EditValue = HtmlEncode($this->idempresa->CurrentValue);
			$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

			// urlstreetview
			$this->urlstreetview->EditAttrs["class"] = "form-control";
			$this->urlstreetview->EditCustomAttributes = "";
			if (!$this->urlstreetview->Raw)
				$this->urlstreetview->CurrentValue = HtmlDecode($this->urlstreetview->CurrentValue);
			$this->urlstreetview->EditValue = HtmlEncode($this->urlstreetview->CurrentValue);
			$this->urlstreetview->PlaceHolder = RemoveHtml($this->urlstreetview->caption());

			// Edit refer script
			// id_producto

			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";

			// localidad
			$this->localidad->LinkCustomAttributes = "";
			$this->localidad->HrefValue = "";

			// zona
			$this->zona->LinkCustomAttributes = "";
			$this->zona->HrefValue = "";

			// tipo_inmueble
			$this->tipo_inmueble->LinkCustomAttributes = "";
			$this->tipo_inmueble->HrefValue = "";

			// tipo_negocio
			$this->tipo_negocio->LinkCustomAttributes = "";
			$this->tipo_negocio->HrefValue = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->LinkCustomAttributes = "";
			$this->tiempo_alquiler->HrefValue = "";

			// moneda
			$this->moneda->LinkCustomAttributes = "";
			$this->moneda->HrefValue = "";

			// estado_inmueble
			$this->estado_inmueble->LinkCustomAttributes = "";
			$this->estado_inmueble->HrefValue = "";

			// area_construida
			$this->area_construida->LinkCustomAttributes = "";
			$this->area_construida->HrefValue = "";

			// area_privada
			$this->area_privada->LinkCustomAttributes = "";
			$this->area_privada->HrefValue = "";

			// area_terreno
			$this->area_terreno->LinkCustomAttributes = "";
			$this->area_terreno->HrefValue = "";

			// valor_administracion
			$this->valor_administracion->LinkCustomAttributes = "";
			$this->valor_administracion->HrefValue = "";

			// dormitorios
			$this->dormitorios->LinkCustomAttributes = "";
			$this->dormitorios->HrefValue = "";

			// banios
			$this->banios->LinkCustomAttributes = "";
			$this->banios->HrefValue = "";

			// garaje
			$this->garaje->LinkCustomAttributes = "";
			$this->garaje->HrefValue = "";

			// piso
			$this->piso->LinkCustomAttributes = "";
			$this->piso->HrefValue = "";

			// estrato
			$this->estrato->LinkCustomAttributes = "";
			$this->estrato->HrefValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";

			// codigo_postal
			$this->codigo_postal->LinkCustomAttributes = "";
			$this->codigo_postal->HrefValue = "";

			// mapa
			$this->mapa->LinkCustomAttributes = "";
			$this->mapa->HrefValue = "";

			// latitud
			$this->latitud->LinkCustomAttributes = "";
			$this->latitud->HrefValue = "";

			// longitud
			$this->longitud->LinkCustomAttributes = "";
			$this->longitud->HrefValue = "";

			// opciones_mapa
			$this->opciones_mapa->LinkCustomAttributes = "";
			$this->opciones_mapa->HrefValue = "";

			// red
			$this->red->LinkCustomAttributes = "";
			$this->red->HrefValue = "";

			// video
			$this->video->LinkCustomAttributes = "";
			$this->video->HrefValue = "";

			// disponibilidad
			$this->disponibilidad->LinkCustomAttributes = "";
			$this->disponibilidad->HrefValue = "";

			// anio_construccion
			$this->anio_construccion->LinkCustomAttributes = "";
			$this->anio_construccion->HrefValue = "";

			// encargado
			$this->encargado->LinkCustomAttributes = "";
			$this->encargado->HrefValue = "";

			// comentario
			$this->comentario->LinkCustomAttributes = "";
			$this->comentario->HrefValue = "";

			// visitas
			$this->visitas->LinkCustomAttributes = "";
			$this->visitas->HrefValue = "";

			// valor_comision
			$this->valor_comision->LinkCustomAttributes = "";
			$this->valor_comision->HrefValue = "";

			// tipo_comision
			$this->tipo_comision->LinkCustomAttributes = "";
			$this->tipo_comision->HrefValue = "";

			// certificado
			$this->certificado->LinkCustomAttributes = "";
			$this->certificado->HrefValue = "";

			// nombre_propietario
			$this->nombre_propietario->LinkCustomAttributes = "";
			$this->nombre_propietario->HrefValue = "";

			// movil_propietario
			$this->movil_propietario->LinkCustomAttributes = "";
			$this->movil_propietario->HrefValue = "";

			// telefono_propietario
			$this->telefono_propietario->LinkCustomAttributes = "";
			$this->telefono_propietario->HrefValue = "";

			// correo_propietario
			$this->correo_propietario->LinkCustomAttributes = "";
			$this->correo_propietario->HrefValue = "";

			// vinculo
			$this->vinculo->LinkCustomAttributes = "";
			$this->vinculo->HrefValue = "";

			// portales
			$this->portales->LinkCustomAttributes = "";
			$this->portales->HrefValue = "";

			// notas
			$this->notas->LinkCustomAttributes = "";
			$this->notas->HrefValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";

			// descripcion1
			$this->descripcion1->LinkCustomAttributes = "";
			$this->descripcion1->HrefValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";

			// precio_mayorista
			$this->precio_mayorista->LinkCustomAttributes = "";
			$this->precio_mayorista->HrefValue = "";

			// precio_vendedor
			$this->precio_vendedor->LinkCustomAttributes = "";
			$this->precio_vendedor->HrefValue = "";

			// medida1
			$this->medida1->LinkCustomAttributes = "";
			$this->medida1->HrefValue = "";

			// medida2
			$this->medida2->LinkCustomAttributes = "";
			$this->medida2->HrefValue = "";

			// medida3
			$this->medida3->LinkCustomAttributes = "";
			$this->medida3->HrefValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";

			// urlstreetview
			$this->urlstreetview->LinkCustomAttributes = "";
			$this->urlstreetview->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->id_producto->Required) {
			if (!$this->id_producto->IsDetailKey && $this->id_producto->FormValue != NULL && $this->id_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_producto->caption(), $this->id_producto->RequiredErrorMessage));
			}
		}
		if ($this->codigo_producto->Required) {
			if (!$this->codigo_producto->IsDetailKey && $this->codigo_producto->FormValue != NULL && $this->codigo_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codigo_producto->caption(), $this->codigo_producto->RequiredErrorMessage));
			}
		}
		if ($this->nombre_producto->Required) {
			if (!$this->nombre_producto->IsDetailKey && $this->nombre_producto->FormValue != NULL && $this->nombre_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombre_producto->caption(), $this->nombre_producto->RequiredErrorMessage));
			}
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->status_producto->Required) {
			if (!$this->status_producto->IsDetailKey && $this->status_producto->FormValue != NULL && $this->status_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_producto->caption(), $this->status_producto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status_producto->FormValue)) {
			AddMessage($FormError, $this->status_producto->errorMessage());
		}
		if ($this->date_added->Required) {
			if (!$this->date_added->IsDetailKey && $this->date_added->FormValue != NULL && $this->date_added->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_added->caption(), $this->date_added->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date_added->FormValue)) {
			AddMessage($FormError, $this->date_added->errorMessage());
		}
		if ($this->precio_producto->Required) {
			if (!$this->precio_producto->IsDetailKey && $this->precio_producto->FormValue != NULL && $this->precio_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio_producto->caption(), $this->precio_producto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio_producto->FormValue)) {
			AddMessage($FormError, $this->precio_producto->errorMessage());
		}
		if ($this->costo_producto->Required) {
			if (!$this->costo_producto->IsDetailKey && $this->costo_producto->FormValue != NULL && $this->costo_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->costo_producto->caption(), $this->costo_producto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->costo_producto->FormValue)) {
			AddMessage($FormError, $this->costo_producto->errorMessage());
		}
		if ($this->mon_costo->Required) {
			if (!$this->mon_costo->IsDetailKey && $this->mon_costo->FormValue != NULL && $this->mon_costo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mon_costo->caption(), $this->mon_costo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->mon_costo->FormValue)) {
			AddMessage($FormError, $this->mon_costo->errorMessage());
		}
		if ($this->mon_venta->Required) {
			if (!$this->mon_venta->IsDetailKey && $this->mon_venta->FormValue != NULL && $this->mon_venta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mon_venta->caption(), $this->mon_venta->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mon_venta->FormValue)) {
			AddMessage($FormError, $this->mon_venta->errorMessage());
		}
		if ($this->pais->Required) {
			if (!$this->pais->IsDetailKey && $this->pais->FormValue != NULL && $this->pais->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pais->caption(), $this->pais->RequiredErrorMessage));
			}
		}
		if ($this->departamento->Required) {
			if (!$this->departamento->IsDetailKey && $this->departamento->FormValue != NULL && $this->departamento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->departamento->caption(), $this->departamento->RequiredErrorMessage));
			}
		}
		if ($this->distrito->Required) {
			if (!$this->distrito->IsDetailKey && $this->distrito->FormValue != NULL && $this->distrito->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->distrito->caption(), $this->distrito->RequiredErrorMessage));
			}
		}
		if ($this->localidad->Required) {
			if (!$this->localidad->IsDetailKey && $this->localidad->FormValue != NULL && $this->localidad->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->localidad->caption(), $this->localidad->RequiredErrorMessage));
			}
		}
		if ($this->zona->Required) {
			if (!$this->zona->IsDetailKey && $this->zona->FormValue != NULL && $this->zona->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->zona->caption(), $this->zona->RequiredErrorMessage));
			}
		}
		if ($this->tipo_inmueble->Required) {
			if (!$this->tipo_inmueble->IsDetailKey && $this->tipo_inmueble->FormValue != NULL && $this->tipo_inmueble->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_inmueble->caption(), $this->tipo_inmueble->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_inmueble->FormValue)) {
			AddMessage($FormError, $this->tipo_inmueble->errorMessage());
		}
		if ($this->tipo_negocio->Required) {
			if (!$this->tipo_negocio->IsDetailKey && $this->tipo_negocio->FormValue != NULL && $this->tipo_negocio->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_negocio->caption(), $this->tipo_negocio->RequiredErrorMessage));
			}
		}
		if ($this->tiempo_alquiler->Required) {
			if (!$this->tiempo_alquiler->IsDetailKey && $this->tiempo_alquiler->FormValue != NULL && $this->tiempo_alquiler->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tiempo_alquiler->caption(), $this->tiempo_alquiler->RequiredErrorMessage));
			}
		}
		if ($this->moneda->Required) {
			if (!$this->moneda->IsDetailKey && $this->moneda->FormValue != NULL && $this->moneda->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->moneda->caption(), $this->moneda->RequiredErrorMessage));
			}
		}
		if ($this->estado_inmueble->Required) {
			if (!$this->estado_inmueble->IsDetailKey && $this->estado_inmueble->FormValue != NULL && $this->estado_inmueble->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado_inmueble->caption(), $this->estado_inmueble->RequiredErrorMessage));
			}
		}
		if ($this->area_construida->Required) {
			if (!$this->area_construida->IsDetailKey && $this->area_construida->FormValue != NULL && $this->area_construida->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->area_construida->caption(), $this->area_construida->RequiredErrorMessage));
			}
		}
		if ($this->area_privada->Required) {
			if (!$this->area_privada->IsDetailKey && $this->area_privada->FormValue != NULL && $this->area_privada->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->area_privada->caption(), $this->area_privada->RequiredErrorMessage));
			}
		}
		if ($this->area_terreno->Required) {
			if (!$this->area_terreno->IsDetailKey && $this->area_terreno->FormValue != NULL && $this->area_terreno->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->area_terreno->caption(), $this->area_terreno->RequiredErrorMessage));
			}
		}
		if ($this->valor_administracion->Required) {
			if (!$this->valor_administracion->IsDetailKey && $this->valor_administracion->FormValue != NULL && $this->valor_administracion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valor_administracion->caption(), $this->valor_administracion->RequiredErrorMessage));
			}
		}
		if ($this->dormitorios->Required) {
			if (!$this->dormitorios->IsDetailKey && $this->dormitorios->FormValue != NULL && $this->dormitorios->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dormitorios->caption(), $this->dormitorios->RequiredErrorMessage));
			}
		}
		if ($this->banios->Required) {
			if (!$this->banios->IsDetailKey && $this->banios->FormValue != NULL && $this->banios->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->banios->caption(), $this->banios->RequiredErrorMessage));
			}
		}
		if ($this->garaje->Required) {
			if (!$this->garaje->IsDetailKey && $this->garaje->FormValue != NULL && $this->garaje->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->garaje->caption(), $this->garaje->RequiredErrorMessage));
			}
		}
		if ($this->piso->Required) {
			if (!$this->piso->IsDetailKey && $this->piso->FormValue != NULL && $this->piso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->piso->caption(), $this->piso->RequiredErrorMessage));
			}
		}
		if ($this->estrato->Required) {
			if (!$this->estrato->IsDetailKey && $this->estrato->FormValue != NULL && $this->estrato->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estrato->caption(), $this->estrato->RequiredErrorMessage));
			}
		}
		if ($this->direccion->Required) {
			if (!$this->direccion->IsDetailKey && $this->direccion->FormValue != NULL && $this->direccion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->direccion->caption(), $this->direccion->RequiredErrorMessage));
			}
		}
		if ($this->codigo_postal->Required) {
			if (!$this->codigo_postal->IsDetailKey && $this->codigo_postal->FormValue != NULL && $this->codigo_postal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codigo_postal->caption(), $this->codigo_postal->RequiredErrorMessage));
			}
		}
		if ($this->mapa->Required) {
			if (!$this->mapa->IsDetailKey && $this->mapa->FormValue != NULL && $this->mapa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mapa->caption(), $this->mapa->RequiredErrorMessage));
			}
		}
		if ($this->latitud->Required) {
			if (!$this->latitud->IsDetailKey && $this->latitud->FormValue != NULL && $this->latitud->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->latitud->caption(), $this->latitud->RequiredErrorMessage));
			}
		}
		if ($this->longitud->Required) {
			if (!$this->longitud->IsDetailKey && $this->longitud->FormValue != NULL && $this->longitud->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->longitud->caption(), $this->longitud->RequiredErrorMessage));
			}
		}
		if ($this->opciones_mapa->Required) {
			if (!$this->opciones_mapa->IsDetailKey && $this->opciones_mapa->FormValue != NULL && $this->opciones_mapa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->opciones_mapa->caption(), $this->opciones_mapa->RequiredErrorMessage));
			}
		}
		if ($this->red->Required) {
			if (!$this->red->IsDetailKey && $this->red->FormValue != NULL && $this->red->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->red->caption(), $this->red->RequiredErrorMessage));
			}
		}
		if ($this->video->Required) {
			if (!$this->video->IsDetailKey && $this->video->FormValue != NULL && $this->video->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->video->caption(), $this->video->RequiredErrorMessage));
			}
		}
		if ($this->disponibilidad->Required) {
			if (!$this->disponibilidad->IsDetailKey && $this->disponibilidad->FormValue != NULL && $this->disponibilidad->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->disponibilidad->caption(), $this->disponibilidad->RequiredErrorMessage));
			}
		}
		if ($this->anio_construccion->Required) {
			if (!$this->anio_construccion->IsDetailKey && $this->anio_construccion->FormValue != NULL && $this->anio_construccion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->anio_construccion->caption(), $this->anio_construccion->RequiredErrorMessage));
			}
		}
		if ($this->encargado->Required) {
			if (!$this->encargado->IsDetailKey && $this->encargado->FormValue != NULL && $this->encargado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->encargado->caption(), $this->encargado->RequiredErrorMessage));
			}
		}
		if ($this->comentario->Required) {
			if (!$this->comentario->IsDetailKey && $this->comentario->FormValue != NULL && $this->comentario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->comentario->caption(), $this->comentario->RequiredErrorMessage));
			}
		}
		if ($this->visitas->Required) {
			if (!$this->visitas->IsDetailKey && $this->visitas->FormValue != NULL && $this->visitas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->visitas->caption(), $this->visitas->RequiredErrorMessage));
			}
		}
		if ($this->valor_comision->Required) {
			if (!$this->valor_comision->IsDetailKey && $this->valor_comision->FormValue != NULL && $this->valor_comision->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valor_comision->caption(), $this->valor_comision->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->valor_comision->FormValue)) {
			AddMessage($FormError, $this->valor_comision->errorMessage());
		}
		if ($this->tipo_comision->Required) {
			if (!$this->tipo_comision->IsDetailKey && $this->tipo_comision->FormValue != NULL && $this->tipo_comision->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_comision->caption(), $this->tipo_comision->RequiredErrorMessage));
			}
		}
		if ($this->certificado->Required) {
			if (!$this->certificado->IsDetailKey && $this->certificado->FormValue != NULL && $this->certificado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->certificado->caption(), $this->certificado->RequiredErrorMessage));
			}
		}
		if ($this->nombre_propietario->Required) {
			if (!$this->nombre_propietario->IsDetailKey && $this->nombre_propietario->FormValue != NULL && $this->nombre_propietario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombre_propietario->caption(), $this->nombre_propietario->RequiredErrorMessage));
			}
		}
		if ($this->movil_propietario->Required) {
			if (!$this->movil_propietario->IsDetailKey && $this->movil_propietario->FormValue != NULL && $this->movil_propietario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->movil_propietario->caption(), $this->movil_propietario->RequiredErrorMessage));
			}
		}
		if ($this->telefono_propietario->Required) {
			if (!$this->telefono_propietario->IsDetailKey && $this->telefono_propietario->FormValue != NULL && $this->telefono_propietario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->telefono_propietario->caption(), $this->telefono_propietario->RequiredErrorMessage));
			}
		}
		if ($this->correo_propietario->Required) {
			if (!$this->correo_propietario->IsDetailKey && $this->correo_propietario->FormValue != NULL && $this->correo_propietario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->correo_propietario->caption(), $this->correo_propietario->RequiredErrorMessage));
			}
		}
		if ($this->vinculo->Required) {
			if (!$this->vinculo->IsDetailKey && $this->vinculo->FormValue != NULL && $this->vinculo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vinculo->caption(), $this->vinculo->RequiredErrorMessage));
			}
		}
		if ($this->portales->Required) {
			if (!$this->portales->IsDetailKey && $this->portales->FormValue != NULL && $this->portales->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portales->caption(), $this->portales->RequiredErrorMessage));
			}
		}
		if ($this->notas->Required) {
			if (!$this->notas->IsDetailKey && $this->notas->FormValue != NULL && $this->notas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->notas->caption(), $this->notas->RequiredErrorMessage));
			}
		}
		if ($this->marca->Required) {
			if (!$this->marca->IsDetailKey && $this->marca->FormValue != NULL && $this->marca->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->marca->caption(), $this->marca->RequiredErrorMessage));
			}
		}
		if ($this->modelo->Required) {
			if (!$this->modelo->IsDetailKey && $this->modelo->FormValue != NULL && $this->modelo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->modelo->caption(), $this->modelo->RequiredErrorMessage));
			}
		}
		if ($this->color->Required) {
			if (!$this->color->IsDetailKey && $this->color->FormValue != NULL && $this->color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
			}
		}
		if ($this->b1->Required) {
			if (!$this->b1->IsDetailKey && $this->b1->FormValue != NULL && $this->b1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b1->caption(), $this->b1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b1->FormValue)) {
			AddMessage($FormError, $this->b1->errorMessage());
		}
		if ($this->b2->Required) {
			if (!$this->b2->IsDetailKey && $this->b2->FormValue != NULL && $this->b2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b2->caption(), $this->b2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b2->FormValue)) {
			AddMessage($FormError, $this->b2->errorMessage());
		}
		if ($this->b3->Required) {
			if (!$this->b3->IsDetailKey && $this->b3->FormValue != NULL && $this->b3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b3->caption(), $this->b3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b3->FormValue)) {
			AddMessage($FormError, $this->b3->errorMessage());
		}
		if ($this->b4->Required) {
			if (!$this->b4->IsDetailKey && $this->b4->FormValue != NULL && $this->b4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b4->caption(), $this->b4->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b4->FormValue)) {
			AddMessage($FormError, $this->b4->errorMessage());
		}
		if ($this->b5->Required) {
			if (!$this->b5->IsDetailKey && $this->b5->FormValue != NULL && $this->b5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b5->caption(), $this->b5->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b5->FormValue)) {
			AddMessage($FormError, $this->b5->errorMessage());
		}
		if ($this->b6->Required) {
			if (!$this->b6->IsDetailKey && $this->b6->FormValue != NULL && $this->b6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b6->caption(), $this->b6->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b6->FormValue)) {
			AddMessage($FormError, $this->b6->errorMessage());
		}
		if ($this->cat_pro->Required) {
			if (!$this->cat_pro->IsDetailKey && $this->cat_pro->FormValue != NULL && $this->cat_pro->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cat_pro->caption(), $this->cat_pro->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cat_pro->FormValue)) {
			AddMessage($FormError, $this->cat_pro->errorMessage());
		}
		if ($this->pro_ser->Required) {
			if (!$this->pro_ser->IsDetailKey && $this->pro_ser->FormValue != NULL && $this->pro_ser->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pro_ser->caption(), $this->pro_ser->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pro_ser->FormValue)) {
			AddMessage($FormError, $this->pro_ser->errorMessage());
		}
		if ($this->foto1->Required) {
			if (!$this->foto1->IsDetailKey && $this->foto1->FormValue != NULL && $this->foto1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto1->caption(), $this->foto1->RequiredErrorMessage));
			}
		}
		if ($this->foto2->Required) {
			if (!$this->foto2->IsDetailKey && $this->foto2->FormValue != NULL && $this->foto2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto2->caption(), $this->foto2->RequiredErrorMessage));
			}
		}
		if ($this->foto3->Required) {
			if (!$this->foto3->IsDetailKey && $this->foto3->FormValue != NULL && $this->foto3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto3->caption(), $this->foto3->RequiredErrorMessage));
			}
		}
		if ($this->foto4->Required) {
			if (!$this->foto4->IsDetailKey && $this->foto4->FormValue != NULL && $this->foto4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto4->caption(), $this->foto4->RequiredErrorMessage));
			}
		}
		if ($this->web->Required) {
			if (!$this->web->IsDetailKey && $this->web->FormValue != NULL && $this->web->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->web->caption(), $this->web->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->web->FormValue)) {
			AddMessage($FormError, $this->web->errorMessage());
		}
		if ($this->pre_web->Required) {
			if (!$this->pre_web->IsDetailKey && $this->pre_web->FormValue != NULL && $this->pre_web->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pre_web->caption(), $this->pre_web->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->pre_web->FormValue)) {
			AddMessage($FormError, $this->pre_web->errorMessage());
		}
		if ($this->descripcion->Required) {
			if (!$this->descripcion->IsDetailKey && $this->descripcion->FormValue != NULL && $this->descripcion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcion->caption(), $this->descripcion->RequiredErrorMessage));
			}
		}
		if ($this->descripcion1->Required) {
			if (!$this->descripcion1->IsDetailKey && $this->descripcion1->FormValue != NULL && $this->descripcion1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcion1->caption(), $this->descripcion1->RequiredErrorMessage));
			}
		}
		if ($this->megusta->Required) {
			if (!$this->megusta->IsDetailKey && $this->megusta->FormValue != NULL && $this->megusta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->megusta->caption(), $this->megusta->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->megusta->FormValue)) {
			AddMessage($FormError, $this->megusta->errorMessage());
		}
		if ($this->nomegusta->Required) {
			if (!$this->nomegusta->IsDetailKey && $this->nomegusta->FormValue != NULL && $this->nomegusta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomegusta->caption(), $this->nomegusta->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->nomegusta->FormValue)) {
			AddMessage($FormError, $this->nomegusta->errorMessage());
		}
		if ($this->precio2->Required) {
			if (!$this->precio2->IsDetailKey && $this->precio2->FormValue != NULL && $this->precio2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio2->caption(), $this->precio2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio2->FormValue)) {
			AddMessage($FormError, $this->precio2->errorMessage());
		}
		if ($this->precio3->Required) {
			if (!$this->precio3->IsDetailKey && $this->precio3->FormValue != NULL && $this->precio3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio3->caption(), $this->precio3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio3->FormValue)) {
			AddMessage($FormError, $this->precio3->errorMessage());
		}
		if ($this->und_pro->Required) {
			if (!$this->und_pro->IsDetailKey && $this->und_pro->FormValue != NULL && $this->und_pro->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->und_pro->caption(), $this->und_pro->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->und_pro->FormValue)) {
			AddMessage($FormError, $this->und_pro->errorMessage());
		}
		if ($this->barras->Required) {
			if (!$this->barras->IsDetailKey && $this->barras->FormValue != NULL && $this->barras->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->barras->caption(), $this->barras->RequiredErrorMessage));
			}
		}
		if ($this->stockmin->Required) {
			if (!$this->stockmin->IsDetailKey && $this->stockmin->FormValue != NULL && $this->stockmin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stockmin->caption(), $this->stockmin->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->stockmin->FormValue)) {
			AddMessage($FormError, $this->stockmin->errorMessage());
		}
		if ($this->id_grupo->Required) {
			if (!$this->id_grupo->IsDetailKey && $this->id_grupo->FormValue != NULL && $this->id_grupo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_grupo->caption(), $this->id_grupo->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_grupo->FormValue)) {
			AddMessage($FormError, $this->id_grupo->errorMessage());
		}
		if ($this->talla->Required) {
			if (!$this->talla->IsDetailKey && $this->talla->FormValue != NULL && $this->talla->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->talla->caption(), $this->talla->RequiredErrorMessage));
			}
		}
		if ($this->mostrarcolor->Required) {
			if (!$this->mostrarcolor->IsDetailKey && $this->mostrarcolor->FormValue != NULL && $this->mostrarcolor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mostrarcolor->caption(), $this->mostrarcolor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mostrarcolor->FormValue)) {
			AddMessage($FormError, $this->mostrarcolor->errorMessage());
		}
		if ($this->precio_mayorista->Required) {
			if (!$this->precio_mayorista->IsDetailKey && $this->precio_mayorista->FormValue != NULL && $this->precio_mayorista->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio_mayorista->caption(), $this->precio_mayorista->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio_mayorista->FormValue)) {
			AddMessage($FormError, $this->precio_mayorista->errorMessage());
		}
		if ($this->precio_vendedor->Required) {
			if (!$this->precio_vendedor->IsDetailKey && $this->precio_vendedor->FormValue != NULL && $this->precio_vendedor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio_vendedor->caption(), $this->precio_vendedor->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio_vendedor->FormValue)) {
			AddMessage($FormError, $this->precio_vendedor->errorMessage());
		}
		if ($this->medida1->Required) {
			if (!$this->medida1->IsDetailKey && $this->medida1->FormValue != NULL && $this->medida1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->medida1->caption(), $this->medida1->RequiredErrorMessage));
			}
		}
		if ($this->medida2->Required) {
			if (!$this->medida2->IsDetailKey && $this->medida2->FormValue != NULL && $this->medida2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->medida2->caption(), $this->medida2->RequiredErrorMessage));
			}
		}
		if ($this->medida3->Required) {
			if (!$this->medida3->IsDetailKey && $this->medida3->FormValue != NULL && $this->medida3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->medida3->caption(), $this->medida3->RequiredErrorMessage));
			}
		}
		if ($this->codlogin->Required) {
			if (!$this->codlogin->IsDetailKey && $this->codlogin->FormValue != NULL && $this->codlogin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codlogin->caption(), $this->codlogin->RequiredErrorMessage));
			}
		}
		if ($this->idempresa->Required) {
			if (!$this->idempresa->IsDetailKey && $this->idempresa->FormValue != NULL && $this->idempresa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idempresa->caption(), $this->idempresa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idempresa->FormValue)) {
			AddMessage($FormError, $this->idempresa->errorMessage());
		}
		if ($this->urlstreetview->Required) {
			if (!$this->urlstreetview->IsDetailKey && $this->urlstreetview->FormValue != NULL && $this->urlstreetview->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->urlstreetview->caption(), $this->urlstreetview->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// codigo_producto
			$this->codigo_producto->setDbValueDef($rsnew, $this->codigo_producto->CurrentValue, NULL, $this->codigo_producto->ReadOnly);

			// nombre_producto
			$this->nombre_producto->setDbValueDef($rsnew, $this->nombre_producto->CurrentValue, NULL, $this->nombre_producto->ReadOnly);

			// estado
			$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, $this->estado->ReadOnly);

			// status_producto
			$this->status_producto->setDbValueDef($rsnew, $this->status_producto->CurrentValue, NULL, $this->status_producto->ReadOnly);

			// date_added
			$this->date_added->setDbValueDef($rsnew, UnFormatDateTime($this->date_added->CurrentValue, 0), NULL, $this->date_added->ReadOnly);

			// precio_producto
			$this->precio_producto->setDbValueDef($rsnew, $this->precio_producto->CurrentValue, NULL, $this->precio_producto->ReadOnly);

			// costo_producto
			$this->costo_producto->setDbValueDef($rsnew, $this->costo_producto->CurrentValue, NULL, $this->costo_producto->ReadOnly);

			// mon_costo
			$this->mon_costo->setDbValueDef($rsnew, $this->mon_costo->CurrentValue, NULL, $this->mon_costo->ReadOnly);

			// mon_venta
			$this->mon_venta->setDbValueDef($rsnew, $this->mon_venta->CurrentValue, NULL, $this->mon_venta->ReadOnly);

			// pais
			$this->pais->setDbValueDef($rsnew, $this->pais->CurrentValue, NULL, $this->pais->ReadOnly);

			// departamento
			$this->departamento->setDbValueDef($rsnew, $this->departamento->CurrentValue, NULL, $this->departamento->ReadOnly);

			// distrito
			$this->distrito->setDbValueDef($rsnew, $this->distrito->CurrentValue, NULL, $this->distrito->ReadOnly);

			// localidad
			$this->localidad->setDbValueDef($rsnew, $this->localidad->CurrentValue, NULL, $this->localidad->ReadOnly);

			// zona
			$this->zona->setDbValueDef($rsnew, $this->zona->CurrentValue, NULL, $this->zona->ReadOnly);

			// tipo_inmueble
			$this->tipo_inmueble->setDbValueDef($rsnew, $this->tipo_inmueble->CurrentValue, NULL, $this->tipo_inmueble->ReadOnly);

			// tipo_negocio
			$this->tipo_negocio->setDbValueDef($rsnew, $this->tipo_negocio->CurrentValue, NULL, $this->tipo_negocio->ReadOnly);

			// tiempo_alquiler
			$this->tiempo_alquiler->setDbValueDef($rsnew, $this->tiempo_alquiler->CurrentValue, NULL, $this->tiempo_alquiler->ReadOnly);

			// moneda
			$this->moneda->setDbValueDef($rsnew, $this->moneda->CurrentValue, NULL, $this->moneda->ReadOnly);

			// estado_inmueble
			$this->estado_inmueble->setDbValueDef($rsnew, $this->estado_inmueble->CurrentValue, NULL, $this->estado_inmueble->ReadOnly);

			// area_construida
			$this->area_construida->setDbValueDef($rsnew, $this->area_construida->CurrentValue, NULL, $this->area_construida->ReadOnly);

			// area_privada
			$this->area_privada->setDbValueDef($rsnew, $this->area_privada->CurrentValue, NULL, $this->area_privada->ReadOnly);

			// area_terreno
			$this->area_terreno->setDbValueDef($rsnew, $this->area_terreno->CurrentValue, NULL, $this->area_terreno->ReadOnly);

			// valor_administracion
			$this->valor_administracion->setDbValueDef($rsnew, $this->valor_administracion->CurrentValue, NULL, $this->valor_administracion->ReadOnly);

			// dormitorios
			$this->dormitorios->setDbValueDef($rsnew, $this->dormitorios->CurrentValue, NULL, $this->dormitorios->ReadOnly);

			// banios
			$this->banios->setDbValueDef($rsnew, $this->banios->CurrentValue, NULL, $this->banios->ReadOnly);

			// garaje
			$this->garaje->setDbValueDef($rsnew, $this->garaje->CurrentValue, NULL, $this->garaje->ReadOnly);

			// piso
			$this->piso->setDbValueDef($rsnew, $this->piso->CurrentValue, NULL, $this->piso->ReadOnly);

			// estrato
			$this->estrato->setDbValueDef($rsnew, $this->estrato->CurrentValue, NULL, $this->estrato->ReadOnly);

			// direccion
			$this->direccion->setDbValueDef($rsnew, $this->direccion->CurrentValue, NULL, $this->direccion->ReadOnly);

			// codigo_postal
			$this->codigo_postal->setDbValueDef($rsnew, $this->codigo_postal->CurrentValue, NULL, $this->codigo_postal->ReadOnly);

			// mapa
			$this->mapa->setDbValueDef($rsnew, $this->mapa->CurrentValue, NULL, $this->mapa->ReadOnly);

			// latitud
			$this->latitud->setDbValueDef($rsnew, $this->latitud->CurrentValue, NULL, $this->latitud->ReadOnly);

			// longitud
			$this->longitud->setDbValueDef($rsnew, $this->longitud->CurrentValue, NULL, $this->longitud->ReadOnly);

			// opciones_mapa
			$this->opciones_mapa->setDbValueDef($rsnew, $this->opciones_mapa->CurrentValue, NULL, $this->opciones_mapa->ReadOnly);

			// red
			$this->red->setDbValueDef($rsnew, $this->red->CurrentValue, NULL, $this->red->ReadOnly);

			// video
			$this->video->setDbValueDef($rsnew, $this->video->CurrentValue, NULL, $this->video->ReadOnly);

			// disponibilidad
			$this->disponibilidad->setDbValueDef($rsnew, $this->disponibilidad->CurrentValue, NULL, $this->disponibilidad->ReadOnly);

			// anio_construccion
			$this->anio_construccion->setDbValueDef($rsnew, $this->anio_construccion->CurrentValue, NULL, $this->anio_construccion->ReadOnly);

			// encargado
			$this->encargado->setDbValueDef($rsnew, $this->encargado->CurrentValue, NULL, $this->encargado->ReadOnly);

			// comentario
			$this->comentario->setDbValueDef($rsnew, $this->comentario->CurrentValue, NULL, $this->comentario->ReadOnly);

			// visitas
			$this->visitas->setDbValueDef($rsnew, $this->visitas->CurrentValue, NULL, $this->visitas->ReadOnly);

			// valor_comision
			$this->valor_comision->setDbValueDef($rsnew, $this->valor_comision->CurrentValue, NULL, $this->valor_comision->ReadOnly);

			// tipo_comision
			$this->tipo_comision->setDbValueDef($rsnew, $this->tipo_comision->CurrentValue, NULL, $this->tipo_comision->ReadOnly);

			// certificado
			$this->certificado->setDbValueDef($rsnew, $this->certificado->CurrentValue, NULL, $this->certificado->ReadOnly);

			// nombre_propietario
			$this->nombre_propietario->setDbValueDef($rsnew, $this->nombre_propietario->CurrentValue, NULL, $this->nombre_propietario->ReadOnly);

			// movil_propietario
			$this->movil_propietario->setDbValueDef($rsnew, $this->movil_propietario->CurrentValue, NULL, $this->movil_propietario->ReadOnly);

			// telefono_propietario
			$this->telefono_propietario->setDbValueDef($rsnew, $this->telefono_propietario->CurrentValue, NULL, $this->telefono_propietario->ReadOnly);

			// correo_propietario
			$this->correo_propietario->setDbValueDef($rsnew, $this->correo_propietario->CurrentValue, NULL, $this->correo_propietario->ReadOnly);

			// vinculo
			$this->vinculo->setDbValueDef($rsnew, $this->vinculo->CurrentValue, NULL, $this->vinculo->ReadOnly);

			// portales
			$this->portales->setDbValueDef($rsnew, $this->portales->CurrentValue, NULL, $this->portales->ReadOnly);

			// notas
			$this->notas->setDbValueDef($rsnew, $this->notas->CurrentValue, NULL, $this->notas->ReadOnly);

			// marca
			$this->marca->setDbValueDef($rsnew, $this->marca->CurrentValue, NULL, $this->marca->ReadOnly);

			// modelo
			$this->modelo->setDbValueDef($rsnew, $this->modelo->CurrentValue, NULL, $this->modelo->ReadOnly);

			// color
			$this->color->setDbValueDef($rsnew, $this->color->CurrentValue, NULL, $this->color->ReadOnly);

			// b1
			$this->b1->setDbValueDef($rsnew, $this->b1->CurrentValue, NULL, $this->b1->ReadOnly);

			// b2
			$this->b2->setDbValueDef($rsnew, $this->b2->CurrentValue, NULL, $this->b2->ReadOnly);

			// b3
			$this->b3->setDbValueDef($rsnew, $this->b3->CurrentValue, NULL, $this->b3->ReadOnly);

			// b4
			$this->b4->setDbValueDef($rsnew, $this->b4->CurrentValue, NULL, $this->b4->ReadOnly);

			// b5
			$this->b5->setDbValueDef($rsnew, $this->b5->CurrentValue, NULL, $this->b5->ReadOnly);

			// b6
			$this->b6->setDbValueDef($rsnew, $this->b6->CurrentValue, NULL, $this->b6->ReadOnly);

			// cat_pro
			$this->cat_pro->setDbValueDef($rsnew, $this->cat_pro->CurrentValue, NULL, $this->cat_pro->ReadOnly);

			// pro_ser
			$this->pro_ser->setDbValueDef($rsnew, $this->pro_ser->CurrentValue, NULL, $this->pro_ser->ReadOnly);

			// foto1
			$this->foto1->setDbValueDef($rsnew, $this->foto1->CurrentValue, NULL, $this->foto1->ReadOnly);

			// foto2
			$this->foto2->setDbValueDef($rsnew, $this->foto2->CurrentValue, NULL, $this->foto2->ReadOnly);

			// foto3
			$this->foto3->setDbValueDef($rsnew, $this->foto3->CurrentValue, NULL, $this->foto3->ReadOnly);

			// foto4
			$this->foto4->setDbValueDef($rsnew, $this->foto4->CurrentValue, NULL, $this->foto4->ReadOnly);

			// web
			$this->web->setDbValueDef($rsnew, $this->web->CurrentValue, NULL, $this->web->ReadOnly);

			// pre_web
			$this->pre_web->setDbValueDef($rsnew, $this->pre_web->CurrentValue, NULL, $this->pre_web->ReadOnly);

			// descripcion
			$this->descripcion->setDbValueDef($rsnew, $this->descripcion->CurrentValue, NULL, $this->descripcion->ReadOnly);

			// descripcion1
			$this->descripcion1->setDbValueDef($rsnew, $this->descripcion1->CurrentValue, NULL, $this->descripcion1->ReadOnly);

			// megusta
			$this->megusta->setDbValueDef($rsnew, $this->megusta->CurrentValue, NULL, $this->megusta->ReadOnly);

			// nomegusta
			$this->nomegusta->setDbValueDef($rsnew, $this->nomegusta->CurrentValue, NULL, $this->nomegusta->ReadOnly);

			// precio2
			$this->precio2->setDbValueDef($rsnew, $this->precio2->CurrentValue, NULL, $this->precio2->ReadOnly);

			// precio3
			$this->precio3->setDbValueDef($rsnew, $this->precio3->CurrentValue, NULL, $this->precio3->ReadOnly);

			// und_pro
			$this->und_pro->setDbValueDef($rsnew, $this->und_pro->CurrentValue, NULL, $this->und_pro->ReadOnly);

			// barras
			$this->barras->setDbValueDef($rsnew, $this->barras->CurrentValue, NULL, $this->barras->ReadOnly);

			// stockmin
			$this->stockmin->setDbValueDef($rsnew, $this->stockmin->CurrentValue, NULL, $this->stockmin->ReadOnly);

			// id_grupo
			$this->id_grupo->setDbValueDef($rsnew, $this->id_grupo->CurrentValue, NULL, $this->id_grupo->ReadOnly);

			// talla
			$this->talla->setDbValueDef($rsnew, $this->talla->CurrentValue, NULL, $this->talla->ReadOnly);

			// mostrarcolor
			$this->mostrarcolor->setDbValueDef($rsnew, $this->mostrarcolor->CurrentValue, NULL, $this->mostrarcolor->ReadOnly);

			// precio_mayorista
			$this->precio_mayorista->setDbValueDef($rsnew, $this->precio_mayorista->CurrentValue, NULL, $this->precio_mayorista->ReadOnly);

			// precio_vendedor
			$this->precio_vendedor->setDbValueDef($rsnew, $this->precio_vendedor->CurrentValue, NULL, $this->precio_vendedor->ReadOnly);

			// medida1
			$this->medida1->setDbValueDef($rsnew, $this->medida1->CurrentValue, NULL, $this->medida1->ReadOnly);

			// medida2
			$this->medida2->setDbValueDef($rsnew, $this->medida2->CurrentValue, NULL, $this->medida2->ReadOnly);

			// medida3
			$this->medida3->setDbValueDef($rsnew, $this->medida3->CurrentValue, NULL, $this->medida3->ReadOnly);

			// codlogin
			$this->codlogin->setDbValueDef($rsnew, $this->codlogin->CurrentValue, NULL, $this->codlogin->ReadOnly);

			// idempresa
			$this->idempresa->setDbValueDef($rsnew, $this->idempresa->CurrentValue, NULL, $this->idempresa->ReadOnly);

			// urlstreetview
			$this->urlstreetview->setDbValueDef($rsnew, $this->urlstreetview->CurrentValue, NULL, $this->urlstreetview->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew); 
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>