<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class lotes_list extends lotes
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'lotes';

	// Page object name
	public $PageObjName = "lotes_list";

	// Grid form hidden field names
	public $FormName = "floteslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (lotes)
		if (!isset($GLOBALS["lotes"]) || get_class($GLOBALS["lotes"]) == PROJECT_NAMESPACE . "lotes") {
			$GLOBALS["lotes"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["lotes"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "lotesadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "lotesdelete.php";
		$this->MultiUpdateUrl = "lotesupdate.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'lotes');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option floteslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $lotes;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($lotes);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id_producto->setVisibility();
		$this->id_proyecto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->setVisibility();
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->Visible = FALSE;
		$this->descripcion1->Visible = FALSE;
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->lote->setVisibility();
		$this->manzana->setVisibility();
		$this->etapa->setVisibility();
		$this->estado->setVisibility();
		$this->icon->setVisibility();
		$this->topy->setVisibility();
		$this->leftx->setVisibility();
		$this->codlogin->setVisibility();
		$this->id_cliente->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->id_producto->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->id_producto->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->id_producto->AdvancedSearch->toJson(), ","); // Field id_producto
		$filterList = Concat($filterList, $this->id_proyecto->AdvancedSearch->toJson(), ","); // Field id_proyecto
		$filterList = Concat($filterList, $this->codigo_producto->AdvancedSearch->toJson(), ","); // Field codigo_producto
		$filterList = Concat($filterList, $this->nombre_producto->AdvancedSearch->toJson(), ","); // Field nombre_producto
		$filterList = Concat($filterList, $this->status_producto->AdvancedSearch->toJson(), ","); // Field status_producto
		$filterList = Concat($filterList, $this->date_added->AdvancedSearch->toJson(), ","); // Field date_added
		$filterList = Concat($filterList, $this->precio_producto->AdvancedSearch->toJson(), ","); // Field precio_producto
		$filterList = Concat($filterList, $this->costo_producto->AdvancedSearch->toJson(), ","); // Field costo_producto
		$filterList = Concat($filterList, $this->mon_costo->AdvancedSearch->toJson(), ","); // Field mon_costo
		$filterList = Concat($filterList, $this->mon_venta->AdvancedSearch->toJson(), ","); // Field mon_venta
		$filterList = Concat($filterList, $this->marca->AdvancedSearch->toJson(), ","); // Field marca
		$filterList = Concat($filterList, $this->modelo->AdvancedSearch->toJson(), ","); // Field modelo
		$filterList = Concat($filterList, $this->color->AdvancedSearch->toJson(), ","); // Field color
		$filterList = Concat($filterList, $this->b1->AdvancedSearch->toJson(), ","); // Field b1
		$filterList = Concat($filterList, $this->b2->AdvancedSearch->toJson(), ","); // Field b2
		$filterList = Concat($filterList, $this->b3->AdvancedSearch->toJson(), ","); // Field b3
		$filterList = Concat($filterList, $this->b4->AdvancedSearch->toJson(), ","); // Field b4
		$filterList = Concat($filterList, $this->b5->AdvancedSearch->toJson(), ","); // Field b5
		$filterList = Concat($filterList, $this->b6->AdvancedSearch->toJson(), ","); // Field b6
		$filterList = Concat($filterList, $this->cat_pro->AdvancedSearch->toJson(), ","); // Field cat_pro
		$filterList = Concat($filterList, $this->pro_ser->AdvancedSearch->toJson(), ","); // Field pro_ser
		$filterList = Concat($filterList, $this->foto1->AdvancedSearch->toJson(), ","); // Field foto1
		$filterList = Concat($filterList, $this->foto2->AdvancedSearch->toJson(), ","); // Field foto2
		$filterList = Concat($filterList, $this->foto3->AdvancedSearch->toJson(), ","); // Field foto3
		$filterList = Concat($filterList, $this->foto4->AdvancedSearch->toJson(), ","); // Field foto4
		$filterList = Concat($filterList, $this->web->AdvancedSearch->toJson(), ","); // Field web
		$filterList = Concat($filterList, $this->pre_web->AdvancedSearch->toJson(), ","); // Field pre_web
		$filterList = Concat($filterList, $this->descripcion->AdvancedSearch->toJson(), ","); // Field descripcion
		$filterList = Concat($filterList, $this->descripcion1->AdvancedSearch->toJson(), ","); // Field descripcion1
		$filterList = Concat($filterList, $this->megusta->AdvancedSearch->toJson(), ","); // Field megusta
		$filterList = Concat($filterList, $this->nomegusta->AdvancedSearch->toJson(), ","); // Field nomegusta
		$filterList = Concat($filterList, $this->precio2->AdvancedSearch->toJson(), ","); // Field precio2
		$filterList = Concat($filterList, $this->precio3->AdvancedSearch->toJson(), ","); // Field precio3
		$filterList = Concat($filterList, $this->und_pro->AdvancedSearch->toJson(), ","); // Field und_pro
		$filterList = Concat($filterList, $this->barras->AdvancedSearch->toJson(), ","); // Field barras
		$filterList = Concat($filterList, $this->stockmin->AdvancedSearch->toJson(), ","); // Field stockmin
		$filterList = Concat($filterList, $this->id_grupo->AdvancedSearch->toJson(), ","); // Field id_grupo
		$filterList = Concat($filterList, $this->talla->AdvancedSearch->toJson(), ","); // Field talla
		$filterList = Concat($filterList, $this->mostrarcolor->AdvancedSearch->toJson(), ","); // Field mostrarcolor
		$filterList = Concat($filterList, $this->lote->AdvancedSearch->toJson(), ","); // Field lote
		$filterList = Concat($filterList, $this->manzana->AdvancedSearch->toJson(), ","); // Field manzana
		$filterList = Concat($filterList, $this->etapa->AdvancedSearch->toJson(), ","); // Field etapa
		$filterList = Concat($filterList, $this->estado->AdvancedSearch->toJson(), ","); // Field estado
		$filterList = Concat($filterList, $this->icon->AdvancedSearch->toJson(), ","); // Field icon
		$filterList = Concat($filterList, $this->topy->AdvancedSearch->toJson(), ","); // Field topy
		$filterList = Concat($filterList, $this->leftx->AdvancedSearch->toJson(), ","); // Field leftx
		$filterList = Concat($filterList, $this->codlogin->AdvancedSearch->toJson(), ","); // Field codlogin
		$filterList = Concat($filterList, $this->id_cliente->AdvancedSearch->toJson(), ","); // Field id_cliente
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "floteslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id_producto
		$this->id_producto->AdvancedSearch->SearchValue = @$filter["x_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator = @$filter["z_id_producto"];
		$this->id_producto->AdvancedSearch->SearchCondition = @$filter["v_id_producto"];
		$this->id_producto->AdvancedSearch->SearchValue2 = @$filter["y_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator2 = @$filter["w_id_producto"];
		$this->id_producto->AdvancedSearch->save();

		// Field id_proyecto
		$this->id_proyecto->AdvancedSearch->SearchValue = @$filter["x_id_proyecto"];
		$this->id_proyecto->AdvancedSearch->SearchOperator = @$filter["z_id_proyecto"];
		$this->id_proyecto->AdvancedSearch->SearchCondition = @$filter["v_id_proyecto"];
		$this->id_proyecto->AdvancedSearch->SearchValue2 = @$filter["y_id_proyecto"];
		$this->id_proyecto->AdvancedSearch->SearchOperator2 = @$filter["w_id_proyecto"];
		$this->id_proyecto->AdvancedSearch->save();

		// Field codigo_producto
		$this->codigo_producto->AdvancedSearch->SearchValue = @$filter["x_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchOperator = @$filter["z_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchCondition = @$filter["v_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchValue2 = @$filter["y_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchOperator2 = @$filter["w_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->save();

		// Field nombre_producto
		$this->nombre_producto->AdvancedSearch->SearchValue = @$filter["x_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchOperator = @$filter["z_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchCondition = @$filter["v_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchValue2 = @$filter["y_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchOperator2 = @$filter["w_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->save();

		// Field status_producto
		$this->status_producto->AdvancedSearch->SearchValue = @$filter["x_status_producto"];
		$this->status_producto->AdvancedSearch->SearchOperator = @$filter["z_status_producto"];
		$this->status_producto->AdvancedSearch->SearchCondition = @$filter["v_status_producto"];
		$this->status_producto->AdvancedSearch->SearchValue2 = @$filter["y_status_producto"];
		$this->status_producto->AdvancedSearch->SearchOperator2 = @$filter["w_status_producto"];
		$this->status_producto->AdvancedSearch->save();

		// Field date_added
		$this->date_added->AdvancedSearch->SearchValue = @$filter["x_date_added"];
		$this->date_added->AdvancedSearch->SearchOperator = @$filter["z_date_added"];
		$this->date_added->AdvancedSearch->SearchCondition = @$filter["v_date_added"];
		$this->date_added->AdvancedSearch->SearchValue2 = @$filter["y_date_added"];
		$this->date_added->AdvancedSearch->SearchOperator2 = @$filter["w_date_added"];
		$this->date_added->AdvancedSearch->save();

		// Field precio_producto
		$this->precio_producto->AdvancedSearch->SearchValue = @$filter["x_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchOperator = @$filter["z_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchCondition = @$filter["v_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchValue2 = @$filter["y_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchOperator2 = @$filter["w_precio_producto"];
		$this->precio_producto->AdvancedSearch->save();

		// Field costo_producto
		$this->costo_producto->AdvancedSearch->SearchValue = @$filter["x_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchOperator = @$filter["z_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchCondition = @$filter["v_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchValue2 = @$filter["y_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchOperator2 = @$filter["w_costo_producto"];
		$this->costo_producto->AdvancedSearch->save();

		// Field mon_costo
		$this->mon_costo->AdvancedSearch->SearchValue = @$filter["x_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchOperator = @$filter["z_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchCondition = @$filter["v_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchValue2 = @$filter["y_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchOperator2 = @$filter["w_mon_costo"];
		$this->mon_costo->AdvancedSearch->save();

		// Field mon_venta
		$this->mon_venta->AdvancedSearch->SearchValue = @$filter["x_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchOperator = @$filter["z_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchCondition = @$filter["v_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchValue2 = @$filter["y_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchOperator2 = @$filter["w_mon_venta"];
		$this->mon_venta->AdvancedSearch->save();

		// Field marca
		$this->marca->AdvancedSearch->SearchValue = @$filter["x_marca"];
		$this->marca->AdvancedSearch->SearchOperator = @$filter["z_marca"];
		$this->marca->AdvancedSearch->SearchCondition = @$filter["v_marca"];
		$this->marca->AdvancedSearch->SearchValue2 = @$filter["y_marca"];
		$this->marca->AdvancedSearch->SearchOperator2 = @$filter["w_marca"];
		$this->marca->AdvancedSearch->save();

		// Field modelo
		$this->modelo->AdvancedSearch->SearchValue = @$filter["x_modelo"];
		$this->modelo->AdvancedSearch->SearchOperator = @$filter["z_modelo"];
		$this->modelo->AdvancedSearch->SearchCondition = @$filter["v_modelo"];
		$this->modelo->AdvancedSearch->SearchValue2 = @$filter["y_modelo"];
		$this->modelo->AdvancedSearch->SearchOperator2 = @$filter["w_modelo"];
		$this->modelo->AdvancedSearch->save();

		// Field color
		$this->color->AdvancedSearch->SearchValue = @$filter["x_color"];
		$this->color->AdvancedSearch->SearchOperator = @$filter["z_color"];
		$this->color->AdvancedSearch->SearchCondition = @$filter["v_color"];
		$this->color->AdvancedSearch->SearchValue2 = @$filter["y_color"];
		$this->color->AdvancedSearch->SearchOperator2 = @$filter["w_color"];
		$this->color->AdvancedSearch->save();

		// Field b1
		$this->b1->AdvancedSearch->SearchValue = @$filter["x_b1"];
		$this->b1->AdvancedSearch->SearchOperator = @$filter["z_b1"];
		$this->b1->AdvancedSearch->SearchCondition = @$filter["v_b1"];
		$this->b1->AdvancedSearch->SearchValue2 = @$filter["y_b1"];
		$this->b1->AdvancedSearch->SearchOperator2 = @$filter["w_b1"];
		$this->b1->AdvancedSearch->save();

		// Field b2
		$this->b2->AdvancedSearch->SearchValue = @$filter["x_b2"];
		$this->b2->AdvancedSearch->SearchOperator = @$filter["z_b2"];
		$this->b2->AdvancedSearch->SearchCondition = @$filter["v_b2"];
		$this->b2->AdvancedSearch->SearchValue2 = @$filter["y_b2"];
		$this->b2->AdvancedSearch->SearchOperator2 = @$filter["w_b2"];
		$this->b2->AdvancedSearch->save();

		// Field b3
		$this->b3->AdvancedSearch->SearchValue = @$filter["x_b3"];
		$this->b3->AdvancedSearch->SearchOperator = @$filter["z_b3"];
		$this->b3->AdvancedSearch->SearchCondition = @$filter["v_b3"];
		$this->b3->AdvancedSearch->SearchValue2 = @$filter["y_b3"];
		$this->b3->AdvancedSearch->SearchOperator2 = @$filter["w_b3"];
		$this->b3->AdvancedSearch->save();

		// Field b4
		$this->b4->AdvancedSearch->SearchValue = @$filter["x_b4"];
		$this->b4->AdvancedSearch->SearchOperator = @$filter["z_b4"];
		$this->b4->AdvancedSearch->SearchCondition = @$filter["v_b4"];
		$this->b4->AdvancedSearch->SearchValue2 = @$filter["y_b4"];
		$this->b4->AdvancedSearch->SearchOperator2 = @$filter["w_b4"];
		$this->b4->AdvancedSearch->save();

		// Field b5
		$this->b5->AdvancedSearch->SearchValue = @$filter["x_b5"];
		$this->b5->AdvancedSearch->SearchOperator = @$filter["z_b5"];
		$this->b5->AdvancedSearch->SearchCondition = @$filter["v_b5"];
		$this->b5->AdvancedSearch->SearchValue2 = @$filter["y_b5"];
		$this->b5->AdvancedSearch->SearchOperator2 = @$filter["w_b5"];
		$this->b5->AdvancedSearch->save();

		// Field b6
		$this->b6->AdvancedSearch->SearchValue = @$filter["x_b6"];
		$this->b6->AdvancedSearch->SearchOperator = @$filter["z_b6"];
		$this->b6->AdvancedSearch->SearchCondition = @$filter["v_b6"];
		$this->b6->AdvancedSearch->SearchValue2 = @$filter["y_b6"];
		$this->b6->AdvancedSearch->SearchOperator2 = @$filter["w_b6"];
		$this->b6->AdvancedSearch->save();

		// Field cat_pro
		$this->cat_pro->AdvancedSearch->SearchValue = @$filter["x_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchOperator = @$filter["z_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchCondition = @$filter["v_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchValue2 = @$filter["y_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchOperator2 = @$filter["w_cat_pro"];
		$this->cat_pro->AdvancedSearch->save();

		// Field pro_ser
		$this->pro_ser->AdvancedSearch->SearchValue = @$filter["x_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchOperator = @$filter["z_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchCondition = @$filter["v_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchValue2 = @$filter["y_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchOperator2 = @$filter["w_pro_ser"];
		$this->pro_ser->AdvancedSearch->save();

		// Field foto1
		$this->foto1->AdvancedSearch->SearchValue = @$filter["x_foto1"];
		$this->foto1->AdvancedSearch->SearchOperator = @$filter["z_foto1"];
		$this->foto1->AdvancedSearch->SearchCondition = @$filter["v_foto1"];
		$this->foto1->AdvancedSearch->SearchValue2 = @$filter["y_foto1"];
		$this->foto1->AdvancedSearch->SearchOperator2 = @$filter["w_foto1"];
		$this->foto1->AdvancedSearch->save();

		// Field foto2
		$this->foto2->AdvancedSearch->SearchValue = @$filter["x_foto2"];
		$this->foto2->AdvancedSearch->SearchOperator = @$filter["z_foto2"];
		$this->foto2->AdvancedSearch->SearchCondition = @$filter["v_foto2"];
		$this->foto2->AdvancedSearch->SearchValue2 = @$filter["y_foto2"];
		$this->foto2->AdvancedSearch->SearchOperator2 = @$filter["w_foto2"];
		$this->foto2->AdvancedSearch->save();

		// Field foto3
		$this->foto3->AdvancedSearch->SearchValue = @$filter["x_foto3"];
		$this->foto3->AdvancedSearch->SearchOperator = @$filter["z_foto3"];
		$this->foto3->AdvancedSearch->SearchCondition = @$filter["v_foto3"];
		$this->foto3->AdvancedSearch->SearchValue2 = @$filter["y_foto3"];
		$this->foto3->AdvancedSearch->SearchOperator2 = @$filter["w_foto3"];
		$this->foto3->AdvancedSearch->save();

		// Field foto4
		$this->foto4->AdvancedSearch->SearchValue = @$filter["x_foto4"];
		$this->foto4->AdvancedSearch->SearchOperator = @$filter["z_foto4"];
		$this->foto4->AdvancedSearch->SearchCondition = @$filter["v_foto4"];
		$this->foto4->AdvancedSearch->SearchValue2 = @$filter["y_foto4"];
		$this->foto4->AdvancedSearch->SearchOperator2 = @$filter["w_foto4"];
		$this->foto4->AdvancedSearch->save();

		// Field web
		$this->web->AdvancedSearch->SearchValue = @$filter["x_web"];
		$this->web->AdvancedSearch->SearchOperator = @$filter["z_web"];
		$this->web->AdvancedSearch->SearchCondition = @$filter["v_web"];
		$this->web->AdvancedSearch->SearchValue2 = @$filter["y_web"];
		$this->web->AdvancedSearch->SearchOperator2 = @$filter["w_web"];
		$this->web->AdvancedSearch->save();

		// Field pre_web
		$this->pre_web->AdvancedSearch->SearchValue = @$filter["x_pre_web"];
		$this->pre_web->AdvancedSearch->SearchOperator = @$filter["z_pre_web"];
		$this->pre_web->AdvancedSearch->SearchCondition = @$filter["v_pre_web"];
		$this->pre_web->AdvancedSearch->SearchValue2 = @$filter["y_pre_web"];
		$this->pre_web->AdvancedSearch->SearchOperator2 = @$filter["w_pre_web"];
		$this->pre_web->AdvancedSearch->save();

		// Field descripcion
		$this->descripcion->AdvancedSearch->SearchValue = @$filter["x_descripcion"];
		$this->descripcion->AdvancedSearch->SearchOperator = @$filter["z_descripcion"];
		$this->descripcion->AdvancedSearch->SearchCondition = @$filter["v_descripcion"];
		$this->descripcion->AdvancedSearch->SearchValue2 = @$filter["y_descripcion"];
		$this->descripcion->AdvancedSearch->SearchOperator2 = @$filter["w_descripcion"];
		$this->descripcion->AdvancedSearch->save();

		// Field descripcion1
		$this->descripcion1->AdvancedSearch->SearchValue = @$filter["x_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchOperator = @$filter["z_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchCondition = @$filter["v_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchValue2 = @$filter["y_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchOperator2 = @$filter["w_descripcion1"];
		$this->descripcion1->AdvancedSearch->save();

		// Field megusta
		$this->megusta->AdvancedSearch->SearchValue = @$filter["x_megusta"];
		$this->megusta->AdvancedSearch->SearchOperator = @$filter["z_megusta"];
		$this->megusta->AdvancedSearch->SearchCondition = @$filter["v_megusta"];
		$this->megusta->AdvancedSearch->SearchValue2 = @$filter["y_megusta"];
		$this->megusta->AdvancedSearch->SearchOperator2 = @$filter["w_megusta"];
		$this->megusta->AdvancedSearch->save();

		// Field nomegusta
		$this->nomegusta->AdvancedSearch->SearchValue = @$filter["x_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchOperator = @$filter["z_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchCondition = @$filter["v_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchValue2 = @$filter["y_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchOperator2 = @$filter["w_nomegusta"];
		$this->nomegusta->AdvancedSearch->save();

		// Field precio2
		$this->precio2->AdvancedSearch->SearchValue = @$filter["x_precio2"];
		$this->precio2->AdvancedSearch->SearchOperator = @$filter["z_precio2"];
		$this->precio2->AdvancedSearch->SearchCondition = @$filter["v_precio2"];
		$this->precio2->AdvancedSearch->SearchValue2 = @$filter["y_precio2"];
		$this->precio2->AdvancedSearch->SearchOperator2 = @$filter["w_precio2"];
		$this->precio2->AdvancedSearch->save();

		// Field precio3
		$this->precio3->AdvancedSearch->SearchValue = @$filter["x_precio3"];
		$this->precio3->AdvancedSearch->SearchOperator = @$filter["z_precio3"];
		$this->precio3->AdvancedSearch->SearchCondition = @$filter["v_precio3"];
		$this->precio3->AdvancedSearch->SearchValue2 = @$filter["y_precio3"];
		$this->precio3->AdvancedSearch->SearchOperator2 = @$filter["w_precio3"];
		$this->precio3->AdvancedSearch->save();

		// Field und_pro
		$this->und_pro->AdvancedSearch->SearchValue = @$filter["x_und_pro"];
		$this->und_pro->AdvancedSearch->SearchOperator = @$filter["z_und_pro"];
		$this->und_pro->AdvancedSearch->SearchCondition = @$filter["v_und_pro"];
		$this->und_pro->AdvancedSearch->SearchValue2 = @$filter["y_und_pro"];
		$this->und_pro->AdvancedSearch->SearchOperator2 = @$filter["w_und_pro"];
		$this->und_pro->AdvancedSearch->save();

		// Field barras
		$this->barras->AdvancedSearch->SearchValue = @$filter["x_barras"];
		$this->barras->AdvancedSearch->SearchOperator = @$filter["z_barras"];
		$this->barras->AdvancedSearch->SearchCondition = @$filter["v_barras"];
		$this->barras->AdvancedSearch->SearchValue2 = @$filter["y_barras"];
		$this->barras->AdvancedSearch->SearchOperator2 = @$filter["w_barras"];
		$this->barras->AdvancedSearch->save();

		// Field stockmin
		$this->stockmin->AdvancedSearch->SearchValue = @$filter["x_stockmin"];
		$this->stockmin->AdvancedSearch->SearchOperator = @$filter["z_stockmin"];
		$this->stockmin->AdvancedSearch->SearchCondition = @$filter["v_stockmin"];
		$this->stockmin->AdvancedSearch->SearchValue2 = @$filter["y_stockmin"];
		$this->stockmin->AdvancedSearch->SearchOperator2 = @$filter["w_stockmin"];
		$this->stockmin->AdvancedSearch->save();

		// Field id_grupo
		$this->id_grupo->AdvancedSearch->SearchValue = @$filter["x_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchOperator = @$filter["z_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchCondition = @$filter["v_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchValue2 = @$filter["y_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchOperator2 = @$filter["w_id_grupo"];
		$this->id_grupo->AdvancedSearch->save();

		// Field talla
		$this->talla->AdvancedSearch->SearchValue = @$filter["x_talla"];
		$this->talla->AdvancedSearch->SearchOperator = @$filter["z_talla"];
		$this->talla->AdvancedSearch->SearchCondition = @$filter["v_talla"];
		$this->talla->AdvancedSearch->SearchValue2 = @$filter["y_talla"];
		$this->talla->AdvancedSearch->SearchOperator2 = @$filter["w_talla"];
		$this->talla->AdvancedSearch->save();

		// Field mostrarcolor
		$this->mostrarcolor->AdvancedSearch->SearchValue = @$filter["x_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchOperator = @$filter["z_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchCondition = @$filter["v_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchValue2 = @$filter["y_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchOperator2 = @$filter["w_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->save();

		// Field lote
		$this->lote->AdvancedSearch->SearchValue = @$filter["x_lote"];
		$this->lote->AdvancedSearch->SearchOperator = @$filter["z_lote"];
		$this->lote->AdvancedSearch->SearchCondition = @$filter["v_lote"];
		$this->lote->AdvancedSearch->SearchValue2 = @$filter["y_lote"];
		$this->lote->AdvancedSearch->SearchOperator2 = @$filter["w_lote"];
		$this->lote->AdvancedSearch->save();

		// Field manzana
		$this->manzana->AdvancedSearch->SearchValue = @$filter["x_manzana"];
		$this->manzana->AdvancedSearch->SearchOperator = @$filter["z_manzana"];
		$this->manzana->AdvancedSearch->SearchCondition = @$filter["v_manzana"];
		$this->manzana->AdvancedSearch->SearchValue2 = @$filter["y_manzana"];
		$this->manzana->AdvancedSearch->SearchOperator2 = @$filter["w_manzana"];
		$this->manzana->AdvancedSearch->save();

		// Field etapa
		$this->etapa->AdvancedSearch->SearchValue = @$filter["x_etapa"];
		$this->etapa->AdvancedSearch->SearchOperator = @$filter["z_etapa"];
		$this->etapa->AdvancedSearch->SearchCondition = @$filter["v_etapa"];
		$this->etapa->AdvancedSearch->SearchValue2 = @$filter["y_etapa"];
		$this->etapa->AdvancedSearch->SearchOperator2 = @$filter["w_etapa"];
		$this->etapa->AdvancedSearch->save();

		// Field estado
		$this->estado->AdvancedSearch->SearchValue = @$filter["x_estado"];
		$this->estado->AdvancedSearch->SearchOperator = @$filter["z_estado"];
		$this->estado->AdvancedSearch->SearchCondition = @$filter["v_estado"];
		$this->estado->AdvancedSearch->SearchValue2 = @$filter["y_estado"];
		$this->estado->AdvancedSearch->SearchOperator2 = @$filter["w_estado"];
		$this->estado->AdvancedSearch->save();

		// Field icon
		$this->icon->AdvancedSearch->SearchValue = @$filter["x_icon"];
		$this->icon->AdvancedSearch->SearchOperator = @$filter["z_icon"];
		$this->icon->AdvancedSearch->SearchCondition = @$filter["v_icon"];
		$this->icon->AdvancedSearch->SearchValue2 = @$filter["y_icon"];
		$this->icon->AdvancedSearch->SearchOperator2 = @$filter["w_icon"];
		$this->icon->AdvancedSearch->save();

		// Field topy
		$this->topy->AdvancedSearch->SearchValue = @$filter["x_topy"];
		$this->topy->AdvancedSearch->SearchOperator = @$filter["z_topy"];
		$this->topy->AdvancedSearch->SearchCondition = @$filter["v_topy"];
		$this->topy->AdvancedSearch->SearchValue2 = @$filter["y_topy"];
		$this->topy->AdvancedSearch->SearchOperator2 = @$filter["w_topy"];
		$this->topy->AdvancedSearch->save();

		// Field leftx
		$this->leftx->AdvancedSearch->SearchValue = @$filter["x_leftx"];
		$this->leftx->AdvancedSearch->SearchOperator = @$filter["z_leftx"];
		$this->leftx->AdvancedSearch->SearchCondition = @$filter["v_leftx"];
		$this->leftx->AdvancedSearch->SearchValue2 = @$filter["y_leftx"];
		$this->leftx->AdvancedSearch->SearchOperator2 = @$filter["w_leftx"];
		$this->leftx->AdvancedSearch->save();

		// Field codlogin
		$this->codlogin->AdvancedSearch->SearchValue = @$filter["x_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator = @$filter["z_codlogin"];
		$this->codlogin->AdvancedSearch->SearchCondition = @$filter["v_codlogin"];
		$this->codlogin->AdvancedSearch->SearchValue2 = @$filter["y_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator2 = @$filter["w_codlogin"];
		$this->codlogin->AdvancedSearch->save();

		// Field id_cliente
		$this->id_cliente->AdvancedSearch->SearchValue = @$filter["x_id_cliente"];
		$this->id_cliente->AdvancedSearch->SearchOperator = @$filter["z_id_cliente"];
		$this->id_cliente->AdvancedSearch->SearchCondition = @$filter["v_id_cliente"];
		$this->id_cliente->AdvancedSearch->SearchValue2 = @$filter["y_id_cliente"];
		$this->id_cliente->AdvancedSearch->SearchOperator2 = @$filter["w_id_cliente"];
		$this->id_cliente->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->codigo_producto, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombre_producto, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->marca, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->modelo, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->color, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto4, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->descripcion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->descripcion1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->barras, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->talla, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lote, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->manzana, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->icon, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->topy, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->leftx, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->codlogin, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id_producto); // id_producto
			$this->updateSort($this->id_proyecto); // id_proyecto
			$this->updateSort($this->codigo_producto); // codigo_producto
			$this->updateSort($this->nombre_producto); // nombre_producto
			$this->updateSort($this->status_producto); // status_producto
			$this->updateSort($this->date_added); // date_added
			$this->updateSort($this->precio_producto); // precio_producto
			$this->updateSort($this->costo_producto); // costo_producto
			$this->updateSort($this->mon_costo); // mon_costo
			$this->updateSort($this->mon_venta); // mon_venta
			$this->updateSort($this->marca); // marca
			$this->updateSort($this->modelo); // modelo
			$this->updateSort($this->color); // color
			$this->updateSort($this->b1); // b1
			$this->updateSort($this->b2); // b2
			$this->updateSort($this->b3); // b3
			$this->updateSort($this->b4); // b4
			$this->updateSort($this->b5); // b5
			$this->updateSort($this->b6); // b6
			$this->updateSort($this->cat_pro); // cat_pro
			$this->updateSort($this->pro_ser); // pro_ser
			$this->updateSort($this->foto1); // foto1
			$this->updateSort($this->foto2); // foto2
			$this->updateSort($this->foto3); // foto3
			$this->updateSort($this->foto4); // foto4
			$this->updateSort($this->web); // web
			$this->updateSort($this->pre_web); // pre_web
			$this->updateSort($this->megusta); // megusta
			$this->updateSort($this->nomegusta); // nomegusta
			$this->updateSort($this->precio2); // precio2
			$this->updateSort($this->precio3); // precio3
			$this->updateSort($this->und_pro); // und_pro
			$this->updateSort($this->barras); // barras
			$this->updateSort($this->stockmin); // stockmin
			$this->updateSort($this->id_grupo); // id_grupo
			$this->updateSort($this->talla); // talla
			$this->updateSort($this->mostrarcolor); // mostrarcolor
			$this->updateSort($this->lote); // lote
			$this->updateSort($this->manzana); // manzana
			$this->updateSort($this->etapa); // etapa
			$this->updateSort($this->estado); // estado
			$this->updateSort($this->icon); // icon
			$this->updateSort($this->topy); // topy
			$this->updateSort($this->leftx); // leftx
			$this->updateSort($this->codlogin); // codlogin
			$this->updateSort($this->id_cliente); // id_cliente
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id_producto->setSort("");
				$this->id_proyecto->setSort("");
				$this->codigo_producto->setSort("");
				$this->nombre_producto->setSort("");
				$this->status_producto->setSort("");
				$this->date_added->setSort("");
				$this->precio_producto->setSort("");
				$this->costo_producto->setSort("");
				$this->mon_costo->setSort("");
				$this->mon_venta->setSort("");
				$this->marca->setSort("");
				$this->modelo->setSort("");
				$this->color->setSort("");
				$this->b1->setSort("");
				$this->b2->setSort("");
				$this->b3->setSort("");
				$this->b4->setSort("");
				$this->b5->setSort("");
				$this->b6->setSort("");
				$this->cat_pro->setSort("");
				$this->pro_ser->setSort("");
				$this->foto1->setSort("");
				$this->foto2->setSort("");
				$this->foto3->setSort("");
				$this->foto4->setSort("");
				$this->web->setSort("");
				$this->pre_web->setSort("");
				$this->megusta->setSort("");
				$this->nomegusta->setSort("");
				$this->precio2->setSort("");
				$this->precio3->setSort("");
				$this->und_pro->setSort("");
				$this->barras->setSort("");
				$this->stockmin->setSort("");
				$this->id_grupo->setSort("");
				$this->talla->setSort("");
				$this->mostrarcolor->setSort("");
				$this->lote->setSort("");
				$this->manzana->setSort("");
				$this->etapa->setSort("");
				$this->estado->setSort("");
				$this->icon->setSort("");
				$this->topy->setSort("");
				$this->leftx->setSort("");
				$this->codlogin->setSort("");
				$this->id_cliente->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = $this->ListOptions["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = $this->ListOptions["delete"];
		if ($Security->isLoggedIn())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->id_producto->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = $this->AddUrl != "" && $Security->isLoggedIn();
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"floteslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"floteslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.floteslist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->id_proyecto->setDbValue($row['id_proyecto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->lote->setDbValue($row['lote']);
		$this->manzana->setDbValue($row['manzana']);
		$this->etapa->setDbValue($row['etapa']);
		$this->estado->setDbValue($row['estado']);
		$this->icon->setDbValue($row['icon']);
		$this->topy->setDbValue($row['topy']);
		$this->leftx->setDbValue($row['leftx']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->id_cliente->setDbValue($row['id_cliente']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_producto'] = NULL;
		$row['id_proyecto'] = NULL;
		$row['codigo_producto'] = NULL;
		$row['nombre_producto'] = NULL;
		$row['status_producto'] = NULL;
		$row['date_added'] = NULL;
		$row['precio_producto'] = NULL;
		$row['costo_producto'] = NULL;
		$row['mon_costo'] = NULL;
		$row['mon_venta'] = NULL;
		$row['marca'] = NULL;
		$row['modelo'] = NULL;
		$row['color'] = NULL;
		$row['b1'] = NULL;
		$row['b2'] = NULL;
		$row['b3'] = NULL;
		$row['b4'] = NULL;
		$row['b5'] = NULL;
		$row['b6'] = NULL;
		$row['cat_pro'] = NULL;
		$row['pro_ser'] = NULL;
		$row['foto1'] = NULL;
		$row['foto2'] = NULL;
		$row['foto3'] = NULL;
		$row['foto4'] = NULL;
		$row['web'] = NULL;
		$row['pre_web'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcion1'] = NULL;
		$row['megusta'] = NULL;
		$row['nomegusta'] = NULL;
		$row['precio2'] = NULL;
		$row['precio3'] = NULL;
		$row['und_pro'] = NULL;
		$row['barras'] = NULL;
		$row['stockmin'] = NULL;
		$row['id_grupo'] = NULL;
		$row['talla'] = NULL;
		$row['mostrarcolor'] = NULL;
		$row['lote'] = NULL;
		$row['manzana'] = NULL;
		$row['etapa'] = NULL;
		$row['estado'] = NULL;
		$row['icon'] = NULL;
		$row['topy'] = NULL;
		$row['leftx'] = NULL;
		$row['codlogin'] = NULL;
		$row['id_cliente'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_producto")) != "")
			$this->id_producto->OldValue = $this->getKey("id_producto"); // id_producto
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_venta->FormValue == $this->mon_venta->CurrentValue && is_numeric(ConvertToFloatString($this->mon_venta->CurrentValue)))
			$this->mon_venta->CurrentValue = ConvertToFloatString($this->mon_venta->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// id_proyecto
		// codigo_producto
		// nombre_producto
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// lote
		// manzana
		// etapa
		// estado
		// icon
		// topy
		// leftx
		// codlogin
		// id_cliente

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// id_proyecto
			$this->id_proyecto->ViewValue = $this->id_proyecto->CurrentValue;
			$this->id_proyecto->ViewValue = FormatNumber($this->id_proyecto->ViewValue, 0, -2, -2, -2);
			$this->id_proyecto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// nombre_producto
			$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
			$this->nombre_producto->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 2, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto1
			$this->foto1->ViewValue = $this->foto1->CurrentValue;
			$this->foto1->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// lote
			$this->lote->ViewValue = $this->lote->CurrentValue;
			$this->lote->ViewCustomAttributes = "";

			// manzana
			$this->manzana->ViewValue = $this->manzana->CurrentValue;
			$this->manzana->ViewCustomAttributes = "";

			// etapa
			$this->etapa->ViewValue = $this->etapa->CurrentValue;
			$this->etapa->ViewValue = FormatNumber($this->etapa->ViewValue, 0, -2, -2, -2);
			$this->etapa->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// icon
			$this->icon->ViewValue = $this->icon->CurrentValue;
			$this->icon->ViewCustomAttributes = "";

			// topy
			$this->topy->ViewValue = $this->topy->CurrentValue;
			$this->topy->ViewCustomAttributes = "";

			// leftx
			$this->leftx->ViewValue = $this->leftx->CurrentValue;
			$this->leftx->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// id_cliente
			$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
			$this->id_cliente->ViewValue = FormatNumber($this->id_cliente->ViewValue, 0, -2, -2, -2);
			$this->id_cliente->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// id_proyecto
			$this->id_proyecto->LinkCustomAttributes = "";
			$this->id_proyecto->HrefValue = "";
			$this->id_proyecto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";
			$this->nombre_producto->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";
			$this->foto1->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// lote
			$this->lote->LinkCustomAttributes = "";
			$this->lote->HrefValue = "";
			$this->lote->TooltipValue = "";

			// manzana
			$this->manzana->LinkCustomAttributes = "";
			$this->manzana->HrefValue = "";
			$this->manzana->TooltipValue = "";

			// etapa
			$this->etapa->LinkCustomAttributes = "";
			$this->etapa->HrefValue = "";
			$this->etapa->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// icon
			$this->icon->LinkCustomAttributes = "";
			$this->icon->HrefValue = "";
			$this->icon->TooltipValue = "";

			// topy
			$this->topy->LinkCustomAttributes = "";
			$this->topy->HrefValue = "";
			$this->topy->TooltipValue = "";

			// leftx
			$this->leftx->LinkCustomAttributes = "";
			$this->leftx->HrefValue = "";
			$this->leftx->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// id_cliente
			$this->id_cliente->LinkCustomAttributes = "";
			$this->id_cliente->HrefValue = "";
			$this->id_cliente->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"floteslistsrch\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>