<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kt_driver_task_list extends kt_driver_task
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kt_driver_task';

	// Page object name
	public $PageObjName = "kt_driver_task_list";

	// Grid form hidden field names
	public $FormName = "fkt_driver_tasklist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kt_driver_task)
		if (!isset($GLOBALS["kt_driver_task"]) || get_class($GLOBALS["kt_driver_task"]) == PROJECT_NAMESPACE . "kt_driver_task") {
			$GLOBALS["kt_driver_task"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kt_driver_task"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "kt_driver_taskadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "kt_driver_taskdelete.php";
		$this->MultiUpdateUrl = "kt_driver_taskupdate.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kt_driver_task');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option fkt_driver_tasklistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kt_driver_task;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kt_driver_task);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['task_id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->task_id->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->task_id->setVisibility();
		$this->task_description->setVisibility();
		$this->trans_type->setVisibility();
		$this->contact_number->setVisibility();
		$this->email_address->setVisibility();
		$this->customer_name->setVisibility();
		$this->delivery_date->setVisibility();
		$this->delivery_address->Visible = FALSE;
		$this->team_id->setVisibility();
		$this->driver_id->setVisibility();
		$this->task_lat->setVisibility();
		$this->task_lng->setVisibility();
		$this->customer_signature->setVisibility();
		$this->date_created->setVisibility();
		$this->date_modified->setVisibility();
		$this->ip_address->setVisibility();
		$this->auto_assign_type->setVisibility();
		$this->assign_started->setVisibility();
		$this->assignment_status->setVisibility();
		$this->dropoff_contact_name->setVisibility();
		$this->dropoff_contact_number->setVisibility();
		$this->drop_address->setVisibility();
		$this->dropoff_task_lat->setVisibility();
		$this->dropoff_task_lng->setVisibility();
		$this->task_token->setVisibility();
		$this->ratings->setVisibility();
		$this->rating_comment->setVisibility();
		$this->critical->setVisibility();
		$this->souce_e->setVisibility();
		$this->shop_code_e->setVisibility();
		$this->Received_Channel_e->setVisibility();
		$this->PayMethod_e->setVisibility();
		$this->Type_e->setVisibility();
		$this->Request_Code_e->setVisibility();
		$this->Status_e->setVisibility();
		$this->PlanType_e->setVisibility();
		$this->Plan_e->setVisibility();
		$this->Isdn_e->setVisibility();
		$this->serial_sim_handset_e->setVisibility();
		$this->handset_e->setVisibility();
		$this->Connect_Reason_e->setVisibility();
		$this->Price_e->setVisibility();
		$this->Current_Operator_e->setVisibility();
		$this->Current_Plan_Type_e->setVisibility();
		$this->Document_Number_e->setVisibility();
		$this->Document_Type_e->setVisibility();
		$this->assignStaffCode_e->setVisibility();
		$this->Delivery_Type_e->setVisibility();
		$this->assignStaffType_e->setVisibility();
		$this->receiveStaffCode_e->setVisibility();
		$this->receiveStaffType_e->setVisibility();
		$this->connectStaffCode_e->setVisibility();
		$this->connectStaffType_e->setVisibility();
		$this->shopName_e->setVisibility();
		$this->saleOrderCode_e->setVisibility();
		$this->consultantCode_e->setVisibility();
		$this->consultantName_e->setVisibility();
		$this->consultantType_e->setVisibility();
		$this->created_By_e->setVisibility();
		$this->createdBranch_e->setVisibility();
		$this->generated_Code_By_e->setVisibility();
		$this->approve_Paid_By_e->setVisibility();
		$this->Delivery_Note_e->setVisibility();
		$this->Delivery_Code_e->setVisibility();
		$this->Customer_Note_e->setVisibility();
		$this->saleOrderCreateDate_e->setVisibility();
		$this->saleOrderPayDate_e->setVisibility();
		$this->Time_of_Procesing_e->setVisibility();
		$this->Time_of_new_e->setVisibility();
		$this->Time_of_Finished_e->setVisibility();
		$this->KPI_CC_Hour_e->setVisibility();
		$this->KPI_NEW_Hour_e->setVisibility();
		$this->KPI_PROCESING_Hour_e->setVisibility();
		$this->KPI_ALL_Hour_e->setVisibility();
		$this->Kpi_Register_Hour_e->setVisibility();
		$this->Kpi_Bitel_Hour_e->setVisibility();
		$this->AmountGB_e->setVisibility();
		$this->Price_1_e->setVisibility();
		$this->Status_1_e->setVisibility();
		$this->Registered_Date_e->setVisibility();
		$this->Sumary_e->setVisibility();
		$this->Plans_e->setVisibility();
		$this->Isdns_e->setVisibility();
		$this->PlanTypes_e->setVisibility();
		$this->Serials_e->setVisibility();
		$this->Status_2_e->setVisibility();
		$this->Registered_Date_2_e->setVisibility();
		$this->Summary_2_e->setVisibility();
		$this->serial_2_e->setVisibility();
		$this->HandsetCode_e->setVisibility();
		$this->HandsetName_e->setVisibility();
		$this->Status_3_e->setVisibility();
		$this->Summary_3_e->setVisibility();
		$this->fecha_activa_e->setVisibility();
		$this->mes_activa_e->setVisibility();
		$this->SOURCE_OUT_e->setVisibility();
		$this->fecha_crea_e->setVisibility();
		$this->mes_crea_e->setVisibility();
		$this->moto_e->setVisibility();
		$this->customer_id->setVisibility();
		$this->status->setVisibility();
		$this->address_e->Visible = FALSE;
		$this->branch_e->setVisibility();
		$this->CreatedTime_e->setVisibility();
		$this->Status_n->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->task_id->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->task_id->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->task_id->AdvancedSearch->toJson(), ","); // Field task_id
		$filterList = Concat($filterList, $this->task_description->AdvancedSearch->toJson(), ","); // Field task_description
		$filterList = Concat($filterList, $this->trans_type->AdvancedSearch->toJson(), ","); // Field trans_type
		$filterList = Concat($filterList, $this->contact_number->AdvancedSearch->toJson(), ","); // Field contact_number
		$filterList = Concat($filterList, $this->email_address->AdvancedSearch->toJson(), ","); // Field email_address
		$filterList = Concat($filterList, $this->customer_name->AdvancedSearch->toJson(), ","); // Field customer_name
		$filterList = Concat($filterList, $this->delivery_date->AdvancedSearch->toJson(), ","); // Field delivery_date
		$filterList = Concat($filterList, $this->delivery_address->AdvancedSearch->toJson(), ","); // Field delivery_address
		$filterList = Concat($filterList, $this->team_id->AdvancedSearch->toJson(), ","); // Field team_id
		$filterList = Concat($filterList, $this->driver_id->AdvancedSearch->toJson(), ","); // Field driver_id
		$filterList = Concat($filterList, $this->task_lat->AdvancedSearch->toJson(), ","); // Field task_lat
		$filterList = Concat($filterList, $this->task_lng->AdvancedSearch->toJson(), ","); // Field task_lng
		$filterList = Concat($filterList, $this->customer_signature->AdvancedSearch->toJson(), ","); // Field customer_signature
		$filterList = Concat($filterList, $this->date_created->AdvancedSearch->toJson(), ","); // Field date_created
		$filterList = Concat($filterList, $this->date_modified->AdvancedSearch->toJson(), ","); // Field date_modified
		$filterList = Concat($filterList, $this->ip_address->AdvancedSearch->toJson(), ","); // Field ip_address
		$filterList = Concat($filterList, $this->auto_assign_type->AdvancedSearch->toJson(), ","); // Field auto_assign_type
		$filterList = Concat($filterList, $this->assign_started->AdvancedSearch->toJson(), ","); // Field assign_started
		$filterList = Concat($filterList, $this->assignment_status->AdvancedSearch->toJson(), ","); // Field assignment_status
		$filterList = Concat($filterList, $this->dropoff_contact_name->AdvancedSearch->toJson(), ","); // Field dropoff_contact_name
		$filterList = Concat($filterList, $this->dropoff_contact_number->AdvancedSearch->toJson(), ","); // Field dropoff_contact_number
		$filterList = Concat($filterList, $this->drop_address->AdvancedSearch->toJson(), ","); // Field drop_address
		$filterList = Concat($filterList, $this->dropoff_task_lat->AdvancedSearch->toJson(), ","); // Field dropoff_task_lat
		$filterList = Concat($filterList, $this->dropoff_task_lng->AdvancedSearch->toJson(), ","); // Field dropoff_task_lng
		$filterList = Concat($filterList, $this->task_token->AdvancedSearch->toJson(), ","); // Field task_token
		$filterList = Concat($filterList, $this->ratings->AdvancedSearch->toJson(), ","); // Field ratings
		$filterList = Concat($filterList, $this->rating_comment->AdvancedSearch->toJson(), ","); // Field rating_comment
		$filterList = Concat($filterList, $this->critical->AdvancedSearch->toJson(), ","); // Field critical
		$filterList = Concat($filterList, $this->souce_e->AdvancedSearch->toJson(), ","); // Field souce_e
		$filterList = Concat($filterList, $this->shop_code_e->AdvancedSearch->toJson(), ","); // Field shop_code_e
		$filterList = Concat($filterList, $this->Received_Channel_e->AdvancedSearch->toJson(), ","); // Field Received_Channel_e
		$filterList = Concat($filterList, $this->PayMethod_e->AdvancedSearch->toJson(), ","); // Field PayMethod_e
		$filterList = Concat($filterList, $this->Type_e->AdvancedSearch->toJson(), ","); // Field Type_e
		$filterList = Concat($filterList, $this->Request_Code_e->AdvancedSearch->toJson(), ","); // Field Request_Code_e
		$filterList = Concat($filterList, $this->Status_e->AdvancedSearch->toJson(), ","); // Field Status_e
		$filterList = Concat($filterList, $this->PlanType_e->AdvancedSearch->toJson(), ","); // Field PlanType_e
		$filterList = Concat($filterList, $this->Plan_e->AdvancedSearch->toJson(), ","); // Field Plan_e
		$filterList = Concat($filterList, $this->Isdn_e->AdvancedSearch->toJson(), ","); // Field Isdn_e
		$filterList = Concat($filterList, $this->serial_sim_handset_e->AdvancedSearch->toJson(), ","); // Field serial_sim_handset_e
		$filterList = Concat($filterList, $this->handset_e->AdvancedSearch->toJson(), ","); // Field handset_e
		$filterList = Concat($filterList, $this->Connect_Reason_e->AdvancedSearch->toJson(), ","); // Field Connect_Reason_e
		$filterList = Concat($filterList, $this->Price_e->AdvancedSearch->toJson(), ","); // Field Price_e
		$filterList = Concat($filterList, $this->Current_Operator_e->AdvancedSearch->toJson(), ","); // Field Current_Operator_e
		$filterList = Concat($filterList, $this->Current_Plan_Type_e->AdvancedSearch->toJson(), ","); // Field Current_Plan_Type_e
		$filterList = Concat($filterList, $this->Document_Number_e->AdvancedSearch->toJson(), ","); // Field Document_Number_e
		$filterList = Concat($filterList, $this->Document_Type_e->AdvancedSearch->toJson(), ","); // Field Document_Type_e
		$filterList = Concat($filterList, $this->assignStaffCode_e->AdvancedSearch->toJson(), ","); // Field assignStaffCode_e
		$filterList = Concat($filterList, $this->Delivery_Type_e->AdvancedSearch->toJson(), ","); // Field Delivery_Type_e
		$filterList = Concat($filterList, $this->assignStaffType_e->AdvancedSearch->toJson(), ","); // Field assignStaffType_e
		$filterList = Concat($filterList, $this->receiveStaffCode_e->AdvancedSearch->toJson(), ","); // Field receiveStaffCode_e
		$filterList = Concat($filterList, $this->receiveStaffType_e->AdvancedSearch->toJson(), ","); // Field receiveStaffType_e
		$filterList = Concat($filterList, $this->connectStaffCode_e->AdvancedSearch->toJson(), ","); // Field connectStaffCode_e
		$filterList = Concat($filterList, $this->connectStaffType_e->AdvancedSearch->toJson(), ","); // Field connectStaffType_e
		$filterList = Concat($filterList, $this->shopName_e->AdvancedSearch->toJson(), ","); // Field shopName_e
		$filterList = Concat($filterList, $this->saleOrderCode_e->AdvancedSearch->toJson(), ","); // Field saleOrderCode_e
		$filterList = Concat($filterList, $this->consultantCode_e->AdvancedSearch->toJson(), ","); // Field consultantCode_e
		$filterList = Concat($filterList, $this->consultantName_e->AdvancedSearch->toJson(), ","); // Field consultantName_e
		$filterList = Concat($filterList, $this->consultantType_e->AdvancedSearch->toJson(), ","); // Field consultantType_e
		$filterList = Concat($filterList, $this->created_By_e->AdvancedSearch->toJson(), ","); // Field created_By_e
		$filterList = Concat($filterList, $this->createdBranch_e->AdvancedSearch->toJson(), ","); // Field createdBranch_e
		$filterList = Concat($filterList, $this->generated_Code_By_e->AdvancedSearch->toJson(), ","); // Field generated_Code_By_e
		$filterList = Concat($filterList, $this->approve_Paid_By_e->AdvancedSearch->toJson(), ","); // Field approve_Paid_By_e
		$filterList = Concat($filterList, $this->Delivery_Note_e->AdvancedSearch->toJson(), ","); // Field Delivery_Note_e
		$filterList = Concat($filterList, $this->Delivery_Code_e->AdvancedSearch->toJson(), ","); // Field Delivery_Code_e
		$filterList = Concat($filterList, $this->Customer_Note_e->AdvancedSearch->toJson(), ","); // Field Customer_Note_e
		$filterList = Concat($filterList, $this->saleOrderCreateDate_e->AdvancedSearch->toJson(), ","); // Field saleOrderCreateDate_e
		$filterList = Concat($filterList, $this->saleOrderPayDate_e->AdvancedSearch->toJson(), ","); // Field saleOrderPayDate_e
		$filterList = Concat($filterList, $this->Time_of_Procesing_e->AdvancedSearch->toJson(), ","); // Field Time_of_Procesing_e
		$filterList = Concat($filterList, $this->Time_of_new_e->AdvancedSearch->toJson(), ","); // Field Time_of_new_e
		$filterList = Concat($filterList, $this->Time_of_Finished_e->AdvancedSearch->toJson(), ","); // Field Time_of_Finished_e
		$filterList = Concat($filterList, $this->KPI_CC_Hour_e->AdvancedSearch->toJson(), ","); // Field KPI_CC_Hour_e
		$filterList = Concat($filterList, $this->KPI_NEW_Hour_e->AdvancedSearch->toJson(), ","); // Field KPI_NEW_Hour_e
		$filterList = Concat($filterList, $this->KPI_PROCESING_Hour_e->AdvancedSearch->toJson(), ","); // Field KPI_PROCESING_Hour_e
		$filterList = Concat($filterList, $this->KPI_ALL_Hour_e->AdvancedSearch->toJson(), ","); // Field KPI_ALL_Hour_e
		$filterList = Concat($filterList, $this->Kpi_Register_Hour_e->AdvancedSearch->toJson(), ","); // Field Kpi_Register_Hour_e
		$filterList = Concat($filterList, $this->Kpi_Bitel_Hour_e->AdvancedSearch->toJson(), ","); // Field Kpi_Bitel_Hour_e
		$filterList = Concat($filterList, $this->AmountGB_e->AdvancedSearch->toJson(), ","); // Field AmountGB_e
		$filterList = Concat($filterList, $this->Price_1_e->AdvancedSearch->toJson(), ","); // Field Price_1_e
		$filterList = Concat($filterList, $this->Status_1_e->AdvancedSearch->toJson(), ","); // Field Status_1_e
		$filterList = Concat($filterList, $this->Registered_Date_e->AdvancedSearch->toJson(), ","); // Field Registered_Date_e
		$filterList = Concat($filterList, $this->Sumary_e->AdvancedSearch->toJson(), ","); // Field Sumary_e
		$filterList = Concat($filterList, $this->Plans_e->AdvancedSearch->toJson(), ","); // Field Plans_e
		$filterList = Concat($filterList, $this->Isdns_e->AdvancedSearch->toJson(), ","); // Field Isdns_e
		$filterList = Concat($filterList, $this->PlanTypes_e->AdvancedSearch->toJson(), ","); // Field PlanTypes_e
		$filterList = Concat($filterList, $this->Serials_e->AdvancedSearch->toJson(), ","); // Field Serials_e
		$filterList = Concat($filterList, $this->Status_2_e->AdvancedSearch->toJson(), ","); // Field Status_2_e
		$filterList = Concat($filterList, $this->Registered_Date_2_e->AdvancedSearch->toJson(), ","); // Field Registered_Date_2_e
		$filterList = Concat($filterList, $this->Summary_2_e->AdvancedSearch->toJson(), ","); // Field Summary_2_e
		$filterList = Concat($filterList, $this->serial_2_e->AdvancedSearch->toJson(), ","); // Field serial_2_e
		$filterList = Concat($filterList, $this->HandsetCode_e->AdvancedSearch->toJson(), ","); // Field HandsetCode_e
		$filterList = Concat($filterList, $this->HandsetName_e->AdvancedSearch->toJson(), ","); // Field HandsetName_e
		$filterList = Concat($filterList, $this->Status_3_e->AdvancedSearch->toJson(), ","); // Field Status_3_e
		$filterList = Concat($filterList, $this->Summary_3_e->AdvancedSearch->toJson(), ","); // Field Summary_3_e
		$filterList = Concat($filterList, $this->fecha_activa_e->AdvancedSearch->toJson(), ","); // Field fecha_activa_e
		$filterList = Concat($filterList, $this->mes_activa_e->AdvancedSearch->toJson(), ","); // Field mes_activa_e
		$filterList = Concat($filterList, $this->SOURCE_OUT_e->AdvancedSearch->toJson(), ","); // Field SOURCE_OUT_e
		$filterList = Concat($filterList, $this->fecha_crea_e->AdvancedSearch->toJson(), ","); // Field fecha_crea_e
		$filterList = Concat($filterList, $this->mes_crea_e->AdvancedSearch->toJson(), ","); // Field mes_crea_e
		$filterList = Concat($filterList, $this->moto_e->AdvancedSearch->toJson(), ","); // Field moto_e
		$filterList = Concat($filterList, $this->customer_id->AdvancedSearch->toJson(), ","); // Field customer_id
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->address_e->AdvancedSearch->toJson(), ","); // Field address_e
		$filterList = Concat($filterList, $this->branch_e->AdvancedSearch->toJson(), ","); // Field branch_e
		$filterList = Concat($filterList, $this->CreatedTime_e->AdvancedSearch->toJson(), ","); // Field CreatedTime_e
		$filterList = Concat($filterList, $this->Status_n->AdvancedSearch->toJson(), ","); // Field Status_n
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fkt_driver_tasklistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field task_id
		$this->task_id->AdvancedSearch->SearchValue = @$filter["x_task_id"];
		$this->task_id->AdvancedSearch->SearchOperator = @$filter["z_task_id"];
		$this->task_id->AdvancedSearch->SearchCondition = @$filter["v_task_id"];
		$this->task_id->AdvancedSearch->SearchValue2 = @$filter["y_task_id"];
		$this->task_id->AdvancedSearch->SearchOperator2 = @$filter["w_task_id"];
		$this->task_id->AdvancedSearch->save();

		// Field task_description
		$this->task_description->AdvancedSearch->SearchValue = @$filter["x_task_description"];
		$this->task_description->AdvancedSearch->SearchOperator = @$filter["z_task_description"];
		$this->task_description->AdvancedSearch->SearchCondition = @$filter["v_task_description"];
		$this->task_description->AdvancedSearch->SearchValue2 = @$filter["y_task_description"];
		$this->task_description->AdvancedSearch->SearchOperator2 = @$filter["w_task_description"];
		$this->task_description->AdvancedSearch->save();

		// Field trans_type
		$this->trans_type->AdvancedSearch->SearchValue = @$filter["x_trans_type"];
		$this->trans_type->AdvancedSearch->SearchOperator = @$filter["z_trans_type"];
		$this->trans_type->AdvancedSearch->SearchCondition = @$filter["v_trans_type"];
		$this->trans_type->AdvancedSearch->SearchValue2 = @$filter["y_trans_type"];
		$this->trans_type->AdvancedSearch->SearchOperator2 = @$filter["w_trans_type"];
		$this->trans_type->AdvancedSearch->save();

		// Field contact_number
		$this->contact_number->AdvancedSearch->SearchValue = @$filter["x_contact_number"];
		$this->contact_number->AdvancedSearch->SearchOperator = @$filter["z_contact_number"];
		$this->contact_number->AdvancedSearch->SearchCondition = @$filter["v_contact_number"];
		$this->contact_number->AdvancedSearch->SearchValue2 = @$filter["y_contact_number"];
		$this->contact_number->AdvancedSearch->SearchOperator2 = @$filter["w_contact_number"];
		$this->contact_number->AdvancedSearch->save();

		// Field email_address
		$this->email_address->AdvancedSearch->SearchValue = @$filter["x_email_address"];
		$this->email_address->AdvancedSearch->SearchOperator = @$filter["z_email_address"];
		$this->email_address->AdvancedSearch->SearchCondition = @$filter["v_email_address"];
		$this->email_address->AdvancedSearch->SearchValue2 = @$filter["y_email_address"];
		$this->email_address->AdvancedSearch->SearchOperator2 = @$filter["w_email_address"];
		$this->email_address->AdvancedSearch->save();

		// Field customer_name
		$this->customer_name->AdvancedSearch->SearchValue = @$filter["x_customer_name"];
		$this->customer_name->AdvancedSearch->SearchOperator = @$filter["z_customer_name"];
		$this->customer_name->AdvancedSearch->SearchCondition = @$filter["v_customer_name"];
		$this->customer_name->AdvancedSearch->SearchValue2 = @$filter["y_customer_name"];
		$this->customer_name->AdvancedSearch->SearchOperator2 = @$filter["w_customer_name"];
		$this->customer_name->AdvancedSearch->save();

		// Field delivery_date
		$this->delivery_date->AdvancedSearch->SearchValue = @$filter["x_delivery_date"];
		$this->delivery_date->AdvancedSearch->SearchOperator = @$filter["z_delivery_date"];
		$this->delivery_date->AdvancedSearch->SearchCondition = @$filter["v_delivery_date"];
		$this->delivery_date->AdvancedSearch->SearchValue2 = @$filter["y_delivery_date"];
		$this->delivery_date->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_date"];
		$this->delivery_date->AdvancedSearch->save();

		// Field delivery_address
		$this->delivery_address->AdvancedSearch->SearchValue = @$filter["x_delivery_address"];
		$this->delivery_address->AdvancedSearch->SearchOperator = @$filter["z_delivery_address"];
		$this->delivery_address->AdvancedSearch->SearchCondition = @$filter["v_delivery_address"];
		$this->delivery_address->AdvancedSearch->SearchValue2 = @$filter["y_delivery_address"];
		$this->delivery_address->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_address"];
		$this->delivery_address->AdvancedSearch->save();

		// Field team_id
		$this->team_id->AdvancedSearch->SearchValue = @$filter["x_team_id"];
		$this->team_id->AdvancedSearch->SearchOperator = @$filter["z_team_id"];
		$this->team_id->AdvancedSearch->SearchCondition = @$filter["v_team_id"];
		$this->team_id->AdvancedSearch->SearchValue2 = @$filter["y_team_id"];
		$this->team_id->AdvancedSearch->SearchOperator2 = @$filter["w_team_id"];
		$this->team_id->AdvancedSearch->save();

		// Field driver_id
		$this->driver_id->AdvancedSearch->SearchValue = @$filter["x_driver_id"];
		$this->driver_id->AdvancedSearch->SearchOperator = @$filter["z_driver_id"];
		$this->driver_id->AdvancedSearch->SearchCondition = @$filter["v_driver_id"];
		$this->driver_id->AdvancedSearch->SearchValue2 = @$filter["y_driver_id"];
		$this->driver_id->AdvancedSearch->SearchOperator2 = @$filter["w_driver_id"];
		$this->driver_id->AdvancedSearch->save();

		// Field task_lat
		$this->task_lat->AdvancedSearch->SearchValue = @$filter["x_task_lat"];
		$this->task_lat->AdvancedSearch->SearchOperator = @$filter["z_task_lat"];
		$this->task_lat->AdvancedSearch->SearchCondition = @$filter["v_task_lat"];
		$this->task_lat->AdvancedSearch->SearchValue2 = @$filter["y_task_lat"];
		$this->task_lat->AdvancedSearch->SearchOperator2 = @$filter["w_task_lat"];
		$this->task_lat->AdvancedSearch->save();

		// Field task_lng
		$this->task_lng->AdvancedSearch->SearchValue = @$filter["x_task_lng"];
		$this->task_lng->AdvancedSearch->SearchOperator = @$filter["z_task_lng"];
		$this->task_lng->AdvancedSearch->SearchCondition = @$filter["v_task_lng"];
		$this->task_lng->AdvancedSearch->SearchValue2 = @$filter["y_task_lng"];
		$this->task_lng->AdvancedSearch->SearchOperator2 = @$filter["w_task_lng"];
		$this->task_lng->AdvancedSearch->save();

		// Field customer_signature
		$this->customer_signature->AdvancedSearch->SearchValue = @$filter["x_customer_signature"];
		$this->customer_signature->AdvancedSearch->SearchOperator = @$filter["z_customer_signature"];
		$this->customer_signature->AdvancedSearch->SearchCondition = @$filter["v_customer_signature"];
		$this->customer_signature->AdvancedSearch->SearchValue2 = @$filter["y_customer_signature"];
		$this->customer_signature->AdvancedSearch->SearchOperator2 = @$filter["w_customer_signature"];
		$this->customer_signature->AdvancedSearch->save();

		// Field date_created
		$this->date_created->AdvancedSearch->SearchValue = @$filter["x_date_created"];
		$this->date_created->AdvancedSearch->SearchOperator = @$filter["z_date_created"];
		$this->date_created->AdvancedSearch->SearchCondition = @$filter["v_date_created"];
		$this->date_created->AdvancedSearch->SearchValue2 = @$filter["y_date_created"];
		$this->date_created->AdvancedSearch->SearchOperator2 = @$filter["w_date_created"];
		$this->date_created->AdvancedSearch->save();

		// Field date_modified
		$this->date_modified->AdvancedSearch->SearchValue = @$filter["x_date_modified"];
		$this->date_modified->AdvancedSearch->SearchOperator = @$filter["z_date_modified"];
		$this->date_modified->AdvancedSearch->SearchCondition = @$filter["v_date_modified"];
		$this->date_modified->AdvancedSearch->SearchValue2 = @$filter["y_date_modified"];
		$this->date_modified->AdvancedSearch->SearchOperator2 = @$filter["w_date_modified"];
		$this->date_modified->AdvancedSearch->save();

		// Field ip_address
		$this->ip_address->AdvancedSearch->SearchValue = @$filter["x_ip_address"];
		$this->ip_address->AdvancedSearch->SearchOperator = @$filter["z_ip_address"];
		$this->ip_address->AdvancedSearch->SearchCondition = @$filter["v_ip_address"];
		$this->ip_address->AdvancedSearch->SearchValue2 = @$filter["y_ip_address"];
		$this->ip_address->AdvancedSearch->SearchOperator2 = @$filter["w_ip_address"];
		$this->ip_address->AdvancedSearch->save();

		// Field auto_assign_type
		$this->auto_assign_type->AdvancedSearch->SearchValue = @$filter["x_auto_assign_type"];
		$this->auto_assign_type->AdvancedSearch->SearchOperator = @$filter["z_auto_assign_type"];
		$this->auto_assign_type->AdvancedSearch->SearchCondition = @$filter["v_auto_assign_type"];
		$this->auto_assign_type->AdvancedSearch->SearchValue2 = @$filter["y_auto_assign_type"];
		$this->auto_assign_type->AdvancedSearch->SearchOperator2 = @$filter["w_auto_assign_type"];
		$this->auto_assign_type->AdvancedSearch->save();

		// Field assign_started
		$this->assign_started->AdvancedSearch->SearchValue = @$filter["x_assign_started"];
		$this->assign_started->AdvancedSearch->SearchOperator = @$filter["z_assign_started"];
		$this->assign_started->AdvancedSearch->SearchCondition = @$filter["v_assign_started"];
		$this->assign_started->AdvancedSearch->SearchValue2 = @$filter["y_assign_started"];
		$this->assign_started->AdvancedSearch->SearchOperator2 = @$filter["w_assign_started"];
		$this->assign_started->AdvancedSearch->save();

		// Field assignment_status
		$this->assignment_status->AdvancedSearch->SearchValue = @$filter["x_assignment_status"];
		$this->assignment_status->AdvancedSearch->SearchOperator = @$filter["z_assignment_status"];
		$this->assignment_status->AdvancedSearch->SearchCondition = @$filter["v_assignment_status"];
		$this->assignment_status->AdvancedSearch->SearchValue2 = @$filter["y_assignment_status"];
		$this->assignment_status->AdvancedSearch->SearchOperator2 = @$filter["w_assignment_status"];
		$this->assignment_status->AdvancedSearch->save();

		// Field dropoff_contact_name
		$this->dropoff_contact_name->AdvancedSearch->SearchValue = @$filter["x_dropoff_contact_name"];
		$this->dropoff_contact_name->AdvancedSearch->SearchOperator = @$filter["z_dropoff_contact_name"];
		$this->dropoff_contact_name->AdvancedSearch->SearchCondition = @$filter["v_dropoff_contact_name"];
		$this->dropoff_contact_name->AdvancedSearch->SearchValue2 = @$filter["y_dropoff_contact_name"];
		$this->dropoff_contact_name->AdvancedSearch->SearchOperator2 = @$filter["w_dropoff_contact_name"];
		$this->dropoff_contact_name->AdvancedSearch->save();

		// Field dropoff_contact_number
		$this->dropoff_contact_number->AdvancedSearch->SearchValue = @$filter["x_dropoff_contact_number"];
		$this->dropoff_contact_number->AdvancedSearch->SearchOperator = @$filter["z_dropoff_contact_number"];
		$this->dropoff_contact_number->AdvancedSearch->SearchCondition = @$filter["v_dropoff_contact_number"];
		$this->dropoff_contact_number->AdvancedSearch->SearchValue2 = @$filter["y_dropoff_contact_number"];
		$this->dropoff_contact_number->AdvancedSearch->SearchOperator2 = @$filter["w_dropoff_contact_number"];
		$this->dropoff_contact_number->AdvancedSearch->save();

		// Field drop_address
		$this->drop_address->AdvancedSearch->SearchValue = @$filter["x_drop_address"];
		$this->drop_address->AdvancedSearch->SearchOperator = @$filter["z_drop_address"];
		$this->drop_address->AdvancedSearch->SearchCondition = @$filter["v_drop_address"];
		$this->drop_address->AdvancedSearch->SearchValue2 = @$filter["y_drop_address"];
		$this->drop_address->AdvancedSearch->SearchOperator2 = @$filter["w_drop_address"];
		$this->drop_address->AdvancedSearch->save();

		// Field dropoff_task_lat
		$this->dropoff_task_lat->AdvancedSearch->SearchValue = @$filter["x_dropoff_task_lat"];
		$this->dropoff_task_lat->AdvancedSearch->SearchOperator = @$filter["z_dropoff_task_lat"];
		$this->dropoff_task_lat->AdvancedSearch->SearchCondition = @$filter["v_dropoff_task_lat"];
		$this->dropoff_task_lat->AdvancedSearch->SearchValue2 = @$filter["y_dropoff_task_lat"];
		$this->dropoff_task_lat->AdvancedSearch->SearchOperator2 = @$filter["w_dropoff_task_lat"];
		$this->dropoff_task_lat->AdvancedSearch->save();

		// Field dropoff_task_lng
		$this->dropoff_task_lng->AdvancedSearch->SearchValue = @$filter["x_dropoff_task_lng"];
		$this->dropoff_task_lng->AdvancedSearch->SearchOperator = @$filter["z_dropoff_task_lng"];
		$this->dropoff_task_lng->AdvancedSearch->SearchCondition = @$filter["v_dropoff_task_lng"];
		$this->dropoff_task_lng->AdvancedSearch->SearchValue2 = @$filter["y_dropoff_task_lng"];
		$this->dropoff_task_lng->AdvancedSearch->SearchOperator2 = @$filter["w_dropoff_task_lng"];
		$this->dropoff_task_lng->AdvancedSearch->save();

		// Field task_token
		$this->task_token->AdvancedSearch->SearchValue = @$filter["x_task_token"];
		$this->task_token->AdvancedSearch->SearchOperator = @$filter["z_task_token"];
		$this->task_token->AdvancedSearch->SearchCondition = @$filter["v_task_token"];
		$this->task_token->AdvancedSearch->SearchValue2 = @$filter["y_task_token"];
		$this->task_token->AdvancedSearch->SearchOperator2 = @$filter["w_task_token"];
		$this->task_token->AdvancedSearch->save();

		// Field ratings
		$this->ratings->AdvancedSearch->SearchValue = @$filter["x_ratings"];
		$this->ratings->AdvancedSearch->SearchOperator = @$filter["z_ratings"];
		$this->ratings->AdvancedSearch->SearchCondition = @$filter["v_ratings"];
		$this->ratings->AdvancedSearch->SearchValue2 = @$filter["y_ratings"];
		$this->ratings->AdvancedSearch->SearchOperator2 = @$filter["w_ratings"];
		$this->ratings->AdvancedSearch->save();

		// Field rating_comment
		$this->rating_comment->AdvancedSearch->SearchValue = @$filter["x_rating_comment"];
		$this->rating_comment->AdvancedSearch->SearchOperator = @$filter["z_rating_comment"];
		$this->rating_comment->AdvancedSearch->SearchCondition = @$filter["v_rating_comment"];
		$this->rating_comment->AdvancedSearch->SearchValue2 = @$filter["y_rating_comment"];
		$this->rating_comment->AdvancedSearch->SearchOperator2 = @$filter["w_rating_comment"];
		$this->rating_comment->AdvancedSearch->save();

		// Field critical
		$this->critical->AdvancedSearch->SearchValue = @$filter["x_critical"];
		$this->critical->AdvancedSearch->SearchOperator = @$filter["z_critical"];
		$this->critical->AdvancedSearch->SearchCondition = @$filter["v_critical"];
		$this->critical->AdvancedSearch->SearchValue2 = @$filter["y_critical"];
		$this->critical->AdvancedSearch->SearchOperator2 = @$filter["w_critical"];
		$this->critical->AdvancedSearch->save();

		// Field souce_e
		$this->souce_e->AdvancedSearch->SearchValue = @$filter["x_souce_e"];
		$this->souce_e->AdvancedSearch->SearchOperator = @$filter["z_souce_e"];
		$this->souce_e->AdvancedSearch->SearchCondition = @$filter["v_souce_e"];
		$this->souce_e->AdvancedSearch->SearchValue2 = @$filter["y_souce_e"];
		$this->souce_e->AdvancedSearch->SearchOperator2 = @$filter["w_souce_e"];
		$this->souce_e->AdvancedSearch->save();

		// Field shop_code_e
		$this->shop_code_e->AdvancedSearch->SearchValue = @$filter["x_shop_code_e"];
		$this->shop_code_e->AdvancedSearch->SearchOperator = @$filter["z_shop_code_e"];
		$this->shop_code_e->AdvancedSearch->SearchCondition = @$filter["v_shop_code_e"];
		$this->shop_code_e->AdvancedSearch->SearchValue2 = @$filter["y_shop_code_e"];
		$this->shop_code_e->AdvancedSearch->SearchOperator2 = @$filter["w_shop_code_e"];
		$this->shop_code_e->AdvancedSearch->save();

		// Field Received_Channel_e
		$this->Received_Channel_e->AdvancedSearch->SearchValue = @$filter["x_Received_Channel_e"];
		$this->Received_Channel_e->AdvancedSearch->SearchOperator = @$filter["z_Received_Channel_e"];
		$this->Received_Channel_e->AdvancedSearch->SearchCondition = @$filter["v_Received_Channel_e"];
		$this->Received_Channel_e->AdvancedSearch->SearchValue2 = @$filter["y_Received_Channel_e"];
		$this->Received_Channel_e->AdvancedSearch->SearchOperator2 = @$filter["w_Received_Channel_e"];
		$this->Received_Channel_e->AdvancedSearch->save();

		// Field PayMethod_e
		$this->PayMethod_e->AdvancedSearch->SearchValue = @$filter["x_PayMethod_e"];
		$this->PayMethod_e->AdvancedSearch->SearchOperator = @$filter["z_PayMethod_e"];
		$this->PayMethod_e->AdvancedSearch->SearchCondition = @$filter["v_PayMethod_e"];
		$this->PayMethod_e->AdvancedSearch->SearchValue2 = @$filter["y_PayMethod_e"];
		$this->PayMethod_e->AdvancedSearch->SearchOperator2 = @$filter["w_PayMethod_e"];
		$this->PayMethod_e->AdvancedSearch->save();

		// Field Type_e
		$this->Type_e->AdvancedSearch->SearchValue = @$filter["x_Type_e"];
		$this->Type_e->AdvancedSearch->SearchOperator = @$filter["z_Type_e"];
		$this->Type_e->AdvancedSearch->SearchCondition = @$filter["v_Type_e"];
		$this->Type_e->AdvancedSearch->SearchValue2 = @$filter["y_Type_e"];
		$this->Type_e->AdvancedSearch->SearchOperator2 = @$filter["w_Type_e"];
		$this->Type_e->AdvancedSearch->save();

		// Field Request_Code_e
		$this->Request_Code_e->AdvancedSearch->SearchValue = @$filter["x_Request_Code_e"];
		$this->Request_Code_e->AdvancedSearch->SearchOperator = @$filter["z_Request_Code_e"];
		$this->Request_Code_e->AdvancedSearch->SearchCondition = @$filter["v_Request_Code_e"];
		$this->Request_Code_e->AdvancedSearch->SearchValue2 = @$filter["y_Request_Code_e"];
		$this->Request_Code_e->AdvancedSearch->SearchOperator2 = @$filter["w_Request_Code_e"];
		$this->Request_Code_e->AdvancedSearch->save();

		// Field Status_e
		$this->Status_e->AdvancedSearch->SearchValue = @$filter["x_Status_e"];
		$this->Status_e->AdvancedSearch->SearchOperator = @$filter["z_Status_e"];
		$this->Status_e->AdvancedSearch->SearchCondition = @$filter["v_Status_e"];
		$this->Status_e->AdvancedSearch->SearchValue2 = @$filter["y_Status_e"];
		$this->Status_e->AdvancedSearch->SearchOperator2 = @$filter["w_Status_e"];
		$this->Status_e->AdvancedSearch->save();

		// Field PlanType_e
		$this->PlanType_e->AdvancedSearch->SearchValue = @$filter["x_PlanType_e"];
		$this->PlanType_e->AdvancedSearch->SearchOperator = @$filter["z_PlanType_e"];
		$this->PlanType_e->AdvancedSearch->SearchCondition = @$filter["v_PlanType_e"];
		$this->PlanType_e->AdvancedSearch->SearchValue2 = @$filter["y_PlanType_e"];
		$this->PlanType_e->AdvancedSearch->SearchOperator2 = @$filter["w_PlanType_e"];
		$this->PlanType_e->AdvancedSearch->save();

		// Field Plan_e
		$this->Plan_e->AdvancedSearch->SearchValue = @$filter["x_Plan_e"];
		$this->Plan_e->AdvancedSearch->SearchOperator = @$filter["z_Plan_e"];
		$this->Plan_e->AdvancedSearch->SearchCondition = @$filter["v_Plan_e"];
		$this->Plan_e->AdvancedSearch->SearchValue2 = @$filter["y_Plan_e"];
		$this->Plan_e->AdvancedSearch->SearchOperator2 = @$filter["w_Plan_e"];
		$this->Plan_e->AdvancedSearch->save();

		// Field Isdn_e
		$this->Isdn_e->AdvancedSearch->SearchValue = @$filter["x_Isdn_e"];
		$this->Isdn_e->AdvancedSearch->SearchOperator = @$filter["z_Isdn_e"];
		$this->Isdn_e->AdvancedSearch->SearchCondition = @$filter["v_Isdn_e"];
		$this->Isdn_e->AdvancedSearch->SearchValue2 = @$filter["y_Isdn_e"];
		$this->Isdn_e->AdvancedSearch->SearchOperator2 = @$filter["w_Isdn_e"];
		$this->Isdn_e->AdvancedSearch->save();

		// Field serial_sim_handset_e
		$this->serial_sim_handset_e->AdvancedSearch->SearchValue = @$filter["x_serial_sim_handset_e"];
		$this->serial_sim_handset_e->AdvancedSearch->SearchOperator = @$filter["z_serial_sim_handset_e"];
		$this->serial_sim_handset_e->AdvancedSearch->SearchCondition = @$filter["v_serial_sim_handset_e"];
		$this->serial_sim_handset_e->AdvancedSearch->SearchValue2 = @$filter["y_serial_sim_handset_e"];
		$this->serial_sim_handset_e->AdvancedSearch->SearchOperator2 = @$filter["w_serial_sim_handset_e"];
		$this->serial_sim_handset_e->AdvancedSearch->save();

		// Field handset_e
		$this->handset_e->AdvancedSearch->SearchValue = @$filter["x_handset_e"];
		$this->handset_e->AdvancedSearch->SearchOperator = @$filter["z_handset_e"];
		$this->handset_e->AdvancedSearch->SearchCondition = @$filter["v_handset_e"];
		$this->handset_e->AdvancedSearch->SearchValue2 = @$filter["y_handset_e"];
		$this->handset_e->AdvancedSearch->SearchOperator2 = @$filter["w_handset_e"];
		$this->handset_e->AdvancedSearch->save();

		// Field Connect_Reason_e
		$this->Connect_Reason_e->AdvancedSearch->SearchValue = @$filter["x_Connect_Reason_e"];
		$this->Connect_Reason_e->AdvancedSearch->SearchOperator = @$filter["z_Connect_Reason_e"];
		$this->Connect_Reason_e->AdvancedSearch->SearchCondition = @$filter["v_Connect_Reason_e"];
		$this->Connect_Reason_e->AdvancedSearch->SearchValue2 = @$filter["y_Connect_Reason_e"];
		$this->Connect_Reason_e->AdvancedSearch->SearchOperator2 = @$filter["w_Connect_Reason_e"];
		$this->Connect_Reason_e->AdvancedSearch->save();

		// Field Price_e
		$this->Price_e->AdvancedSearch->SearchValue = @$filter["x_Price_e"];
		$this->Price_e->AdvancedSearch->SearchOperator = @$filter["z_Price_e"];
		$this->Price_e->AdvancedSearch->SearchCondition = @$filter["v_Price_e"];
		$this->Price_e->AdvancedSearch->SearchValue2 = @$filter["y_Price_e"];
		$this->Price_e->AdvancedSearch->SearchOperator2 = @$filter["w_Price_e"];
		$this->Price_e->AdvancedSearch->save();

		// Field Current_Operator_e
		$this->Current_Operator_e->AdvancedSearch->SearchValue = @$filter["x_Current_Operator_e"];
		$this->Current_Operator_e->AdvancedSearch->SearchOperator = @$filter["z_Current_Operator_e"];
		$this->Current_Operator_e->AdvancedSearch->SearchCondition = @$filter["v_Current_Operator_e"];
		$this->Current_Operator_e->AdvancedSearch->SearchValue2 = @$filter["y_Current_Operator_e"];
		$this->Current_Operator_e->AdvancedSearch->SearchOperator2 = @$filter["w_Current_Operator_e"];
		$this->Current_Operator_e->AdvancedSearch->save();

		// Field Current_Plan_Type_e
		$this->Current_Plan_Type_e->AdvancedSearch->SearchValue = @$filter["x_Current_Plan_Type_e"];
		$this->Current_Plan_Type_e->AdvancedSearch->SearchOperator = @$filter["z_Current_Plan_Type_e"];
		$this->Current_Plan_Type_e->AdvancedSearch->SearchCondition = @$filter["v_Current_Plan_Type_e"];
		$this->Current_Plan_Type_e->AdvancedSearch->SearchValue2 = @$filter["y_Current_Plan_Type_e"];
		$this->Current_Plan_Type_e->AdvancedSearch->SearchOperator2 = @$filter["w_Current_Plan_Type_e"];
		$this->Current_Plan_Type_e->AdvancedSearch->save();

		// Field Document_Number_e
		$this->Document_Number_e->AdvancedSearch->SearchValue = @$filter["x_Document_Number_e"];
		$this->Document_Number_e->AdvancedSearch->SearchOperator = @$filter["z_Document_Number_e"];
		$this->Document_Number_e->AdvancedSearch->SearchCondition = @$filter["v_Document_Number_e"];
		$this->Document_Number_e->AdvancedSearch->SearchValue2 = @$filter["y_Document_Number_e"];
		$this->Document_Number_e->AdvancedSearch->SearchOperator2 = @$filter["w_Document_Number_e"];
		$this->Document_Number_e->AdvancedSearch->save();

		// Field Document_Type_e
		$this->Document_Type_e->AdvancedSearch->SearchValue = @$filter["x_Document_Type_e"];
		$this->Document_Type_e->AdvancedSearch->SearchOperator = @$filter["z_Document_Type_e"];
		$this->Document_Type_e->AdvancedSearch->SearchCondition = @$filter["v_Document_Type_e"];
		$this->Document_Type_e->AdvancedSearch->SearchValue2 = @$filter["y_Document_Type_e"];
		$this->Document_Type_e->AdvancedSearch->SearchOperator2 = @$filter["w_Document_Type_e"];
		$this->Document_Type_e->AdvancedSearch->save();

		// Field assignStaffCode_e
		$this->assignStaffCode_e->AdvancedSearch->SearchValue = @$filter["x_assignStaffCode_e"];
		$this->assignStaffCode_e->AdvancedSearch->SearchOperator = @$filter["z_assignStaffCode_e"];
		$this->assignStaffCode_e->AdvancedSearch->SearchCondition = @$filter["v_assignStaffCode_e"];
		$this->assignStaffCode_e->AdvancedSearch->SearchValue2 = @$filter["y_assignStaffCode_e"];
		$this->assignStaffCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_assignStaffCode_e"];
		$this->assignStaffCode_e->AdvancedSearch->save();

		// Field Delivery_Type_e
		$this->Delivery_Type_e->AdvancedSearch->SearchValue = @$filter["x_Delivery_Type_e"];
		$this->Delivery_Type_e->AdvancedSearch->SearchOperator = @$filter["z_Delivery_Type_e"];
		$this->Delivery_Type_e->AdvancedSearch->SearchCondition = @$filter["v_Delivery_Type_e"];
		$this->Delivery_Type_e->AdvancedSearch->SearchValue2 = @$filter["y_Delivery_Type_e"];
		$this->Delivery_Type_e->AdvancedSearch->SearchOperator2 = @$filter["w_Delivery_Type_e"];
		$this->Delivery_Type_e->AdvancedSearch->save();

		// Field assignStaffType_e
		$this->assignStaffType_e->AdvancedSearch->SearchValue = @$filter["x_assignStaffType_e"];
		$this->assignStaffType_e->AdvancedSearch->SearchOperator = @$filter["z_assignStaffType_e"];
		$this->assignStaffType_e->AdvancedSearch->SearchCondition = @$filter["v_assignStaffType_e"];
		$this->assignStaffType_e->AdvancedSearch->SearchValue2 = @$filter["y_assignStaffType_e"];
		$this->assignStaffType_e->AdvancedSearch->SearchOperator2 = @$filter["w_assignStaffType_e"];
		$this->assignStaffType_e->AdvancedSearch->save();

		// Field receiveStaffCode_e
		$this->receiveStaffCode_e->AdvancedSearch->SearchValue = @$filter["x_receiveStaffCode_e"];
		$this->receiveStaffCode_e->AdvancedSearch->SearchOperator = @$filter["z_receiveStaffCode_e"];
		$this->receiveStaffCode_e->AdvancedSearch->SearchCondition = @$filter["v_receiveStaffCode_e"];
		$this->receiveStaffCode_e->AdvancedSearch->SearchValue2 = @$filter["y_receiveStaffCode_e"];
		$this->receiveStaffCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_receiveStaffCode_e"];
		$this->receiveStaffCode_e->AdvancedSearch->save();

		// Field receiveStaffType_e
		$this->receiveStaffType_e->AdvancedSearch->SearchValue = @$filter["x_receiveStaffType_e"];
		$this->receiveStaffType_e->AdvancedSearch->SearchOperator = @$filter["z_receiveStaffType_e"];
		$this->receiveStaffType_e->AdvancedSearch->SearchCondition = @$filter["v_receiveStaffType_e"];
		$this->receiveStaffType_e->AdvancedSearch->SearchValue2 = @$filter["y_receiveStaffType_e"];
		$this->receiveStaffType_e->AdvancedSearch->SearchOperator2 = @$filter["w_receiveStaffType_e"];
		$this->receiveStaffType_e->AdvancedSearch->save();

		// Field connectStaffCode_e
		$this->connectStaffCode_e->AdvancedSearch->SearchValue = @$filter["x_connectStaffCode_e"];
		$this->connectStaffCode_e->AdvancedSearch->SearchOperator = @$filter["z_connectStaffCode_e"];
		$this->connectStaffCode_e->AdvancedSearch->SearchCondition = @$filter["v_connectStaffCode_e"];
		$this->connectStaffCode_e->AdvancedSearch->SearchValue2 = @$filter["y_connectStaffCode_e"];
		$this->connectStaffCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_connectStaffCode_e"];
		$this->connectStaffCode_e->AdvancedSearch->save();

		// Field connectStaffType_e
		$this->connectStaffType_e->AdvancedSearch->SearchValue = @$filter["x_connectStaffType_e"];
		$this->connectStaffType_e->AdvancedSearch->SearchOperator = @$filter["z_connectStaffType_e"];
		$this->connectStaffType_e->AdvancedSearch->SearchCondition = @$filter["v_connectStaffType_e"];
		$this->connectStaffType_e->AdvancedSearch->SearchValue2 = @$filter["y_connectStaffType_e"];
		$this->connectStaffType_e->AdvancedSearch->SearchOperator2 = @$filter["w_connectStaffType_e"];
		$this->connectStaffType_e->AdvancedSearch->save();

		// Field shopName_e
		$this->shopName_e->AdvancedSearch->SearchValue = @$filter["x_shopName_e"];
		$this->shopName_e->AdvancedSearch->SearchOperator = @$filter["z_shopName_e"];
		$this->shopName_e->AdvancedSearch->SearchCondition = @$filter["v_shopName_e"];
		$this->shopName_e->AdvancedSearch->SearchValue2 = @$filter["y_shopName_e"];
		$this->shopName_e->AdvancedSearch->SearchOperator2 = @$filter["w_shopName_e"];
		$this->shopName_e->AdvancedSearch->save();

		// Field saleOrderCode_e
		$this->saleOrderCode_e->AdvancedSearch->SearchValue = @$filter["x_saleOrderCode_e"];
		$this->saleOrderCode_e->AdvancedSearch->SearchOperator = @$filter["z_saleOrderCode_e"];
		$this->saleOrderCode_e->AdvancedSearch->SearchCondition = @$filter["v_saleOrderCode_e"];
		$this->saleOrderCode_e->AdvancedSearch->SearchValue2 = @$filter["y_saleOrderCode_e"];
		$this->saleOrderCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_saleOrderCode_e"];
		$this->saleOrderCode_e->AdvancedSearch->save();

		// Field consultantCode_e
		$this->consultantCode_e->AdvancedSearch->SearchValue = @$filter["x_consultantCode_e"];
		$this->consultantCode_e->AdvancedSearch->SearchOperator = @$filter["z_consultantCode_e"];
		$this->consultantCode_e->AdvancedSearch->SearchCondition = @$filter["v_consultantCode_e"];
		$this->consultantCode_e->AdvancedSearch->SearchValue2 = @$filter["y_consultantCode_e"];
		$this->consultantCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_consultantCode_e"];
		$this->consultantCode_e->AdvancedSearch->save();

		// Field consultantName_e
		$this->consultantName_e->AdvancedSearch->SearchValue = @$filter["x_consultantName_e"];
		$this->consultantName_e->AdvancedSearch->SearchOperator = @$filter["z_consultantName_e"];
		$this->consultantName_e->AdvancedSearch->SearchCondition = @$filter["v_consultantName_e"];
		$this->consultantName_e->AdvancedSearch->SearchValue2 = @$filter["y_consultantName_e"];
		$this->consultantName_e->AdvancedSearch->SearchOperator2 = @$filter["w_consultantName_e"];
		$this->consultantName_e->AdvancedSearch->save();

		// Field consultantType_e
		$this->consultantType_e->AdvancedSearch->SearchValue = @$filter["x_consultantType_e"];
		$this->consultantType_e->AdvancedSearch->SearchOperator = @$filter["z_consultantType_e"];
		$this->consultantType_e->AdvancedSearch->SearchCondition = @$filter["v_consultantType_e"];
		$this->consultantType_e->AdvancedSearch->SearchValue2 = @$filter["y_consultantType_e"];
		$this->consultantType_e->AdvancedSearch->SearchOperator2 = @$filter["w_consultantType_e"];
		$this->consultantType_e->AdvancedSearch->save();

		// Field created_By_e
		$this->created_By_e->AdvancedSearch->SearchValue = @$filter["x_created_By_e"];
		$this->created_By_e->AdvancedSearch->SearchOperator = @$filter["z_created_By_e"];
		$this->created_By_e->AdvancedSearch->SearchCondition = @$filter["v_created_By_e"];
		$this->created_By_e->AdvancedSearch->SearchValue2 = @$filter["y_created_By_e"];
		$this->created_By_e->AdvancedSearch->SearchOperator2 = @$filter["w_created_By_e"];
		$this->created_By_e->AdvancedSearch->save();

		// Field createdBranch_e
		$this->createdBranch_e->AdvancedSearch->SearchValue = @$filter["x_createdBranch_e"];
		$this->createdBranch_e->AdvancedSearch->SearchOperator = @$filter["z_createdBranch_e"];
		$this->createdBranch_e->AdvancedSearch->SearchCondition = @$filter["v_createdBranch_e"];
		$this->createdBranch_e->AdvancedSearch->SearchValue2 = @$filter["y_createdBranch_e"];
		$this->createdBranch_e->AdvancedSearch->SearchOperator2 = @$filter["w_createdBranch_e"];
		$this->createdBranch_e->AdvancedSearch->save();

		// Field generated_Code_By_e
		$this->generated_Code_By_e->AdvancedSearch->SearchValue = @$filter["x_generated_Code_By_e"];
		$this->generated_Code_By_e->AdvancedSearch->SearchOperator = @$filter["z_generated_Code_By_e"];
		$this->generated_Code_By_e->AdvancedSearch->SearchCondition = @$filter["v_generated_Code_By_e"];
		$this->generated_Code_By_e->AdvancedSearch->SearchValue2 = @$filter["y_generated_Code_By_e"];
		$this->generated_Code_By_e->AdvancedSearch->SearchOperator2 = @$filter["w_generated_Code_By_e"];
		$this->generated_Code_By_e->AdvancedSearch->save();

		// Field approve_Paid_By_e
		$this->approve_Paid_By_e->AdvancedSearch->SearchValue = @$filter["x_approve_Paid_By_e"];
		$this->approve_Paid_By_e->AdvancedSearch->SearchOperator = @$filter["z_approve_Paid_By_e"];
		$this->approve_Paid_By_e->AdvancedSearch->SearchCondition = @$filter["v_approve_Paid_By_e"];
		$this->approve_Paid_By_e->AdvancedSearch->SearchValue2 = @$filter["y_approve_Paid_By_e"];
		$this->approve_Paid_By_e->AdvancedSearch->SearchOperator2 = @$filter["w_approve_Paid_By_e"];
		$this->approve_Paid_By_e->AdvancedSearch->save();

		// Field Delivery_Note_e
		$this->Delivery_Note_e->AdvancedSearch->SearchValue = @$filter["x_Delivery_Note_e"];
		$this->Delivery_Note_e->AdvancedSearch->SearchOperator = @$filter["z_Delivery_Note_e"];
		$this->Delivery_Note_e->AdvancedSearch->SearchCondition = @$filter["v_Delivery_Note_e"];
		$this->Delivery_Note_e->AdvancedSearch->SearchValue2 = @$filter["y_Delivery_Note_e"];
		$this->Delivery_Note_e->AdvancedSearch->SearchOperator2 = @$filter["w_Delivery_Note_e"];
		$this->Delivery_Note_e->AdvancedSearch->save();

		// Field Delivery_Code_e
		$this->Delivery_Code_e->AdvancedSearch->SearchValue = @$filter["x_Delivery_Code_e"];
		$this->Delivery_Code_e->AdvancedSearch->SearchOperator = @$filter["z_Delivery_Code_e"];
		$this->Delivery_Code_e->AdvancedSearch->SearchCondition = @$filter["v_Delivery_Code_e"];
		$this->Delivery_Code_e->AdvancedSearch->SearchValue2 = @$filter["y_Delivery_Code_e"];
		$this->Delivery_Code_e->AdvancedSearch->SearchOperator2 = @$filter["w_Delivery_Code_e"];
		$this->Delivery_Code_e->AdvancedSearch->save();

		// Field Customer_Note_e
		$this->Customer_Note_e->AdvancedSearch->SearchValue = @$filter["x_Customer_Note_e"];
		$this->Customer_Note_e->AdvancedSearch->SearchOperator = @$filter["z_Customer_Note_e"];
		$this->Customer_Note_e->AdvancedSearch->SearchCondition = @$filter["v_Customer_Note_e"];
		$this->Customer_Note_e->AdvancedSearch->SearchValue2 = @$filter["y_Customer_Note_e"];
		$this->Customer_Note_e->AdvancedSearch->SearchOperator2 = @$filter["w_Customer_Note_e"];
		$this->Customer_Note_e->AdvancedSearch->save();

		// Field saleOrderCreateDate_e
		$this->saleOrderCreateDate_e->AdvancedSearch->SearchValue = @$filter["x_saleOrderCreateDate_e"];
		$this->saleOrderCreateDate_e->AdvancedSearch->SearchOperator = @$filter["z_saleOrderCreateDate_e"];
		$this->saleOrderCreateDate_e->AdvancedSearch->SearchCondition = @$filter["v_saleOrderCreateDate_e"];
		$this->saleOrderCreateDate_e->AdvancedSearch->SearchValue2 = @$filter["y_saleOrderCreateDate_e"];
		$this->saleOrderCreateDate_e->AdvancedSearch->SearchOperator2 = @$filter["w_saleOrderCreateDate_e"];
		$this->saleOrderCreateDate_e->AdvancedSearch->save();

		// Field saleOrderPayDate_e
		$this->saleOrderPayDate_e->AdvancedSearch->SearchValue = @$filter["x_saleOrderPayDate_e"];
		$this->saleOrderPayDate_e->AdvancedSearch->SearchOperator = @$filter["z_saleOrderPayDate_e"];
		$this->saleOrderPayDate_e->AdvancedSearch->SearchCondition = @$filter["v_saleOrderPayDate_e"];
		$this->saleOrderPayDate_e->AdvancedSearch->SearchValue2 = @$filter["y_saleOrderPayDate_e"];
		$this->saleOrderPayDate_e->AdvancedSearch->SearchOperator2 = @$filter["w_saleOrderPayDate_e"];
		$this->saleOrderPayDate_e->AdvancedSearch->save();

		// Field Time_of_Procesing_e
		$this->Time_of_Procesing_e->AdvancedSearch->SearchValue = @$filter["x_Time_of_Procesing_e"];
		$this->Time_of_Procesing_e->AdvancedSearch->SearchOperator = @$filter["z_Time_of_Procesing_e"];
		$this->Time_of_Procesing_e->AdvancedSearch->SearchCondition = @$filter["v_Time_of_Procesing_e"];
		$this->Time_of_Procesing_e->AdvancedSearch->SearchValue2 = @$filter["y_Time_of_Procesing_e"];
		$this->Time_of_Procesing_e->AdvancedSearch->SearchOperator2 = @$filter["w_Time_of_Procesing_e"];
		$this->Time_of_Procesing_e->AdvancedSearch->save();

		// Field Time_of_new_e
		$this->Time_of_new_e->AdvancedSearch->SearchValue = @$filter["x_Time_of_new_e"];
		$this->Time_of_new_e->AdvancedSearch->SearchOperator = @$filter["z_Time_of_new_e"];
		$this->Time_of_new_e->AdvancedSearch->SearchCondition = @$filter["v_Time_of_new_e"];
		$this->Time_of_new_e->AdvancedSearch->SearchValue2 = @$filter["y_Time_of_new_e"];
		$this->Time_of_new_e->AdvancedSearch->SearchOperator2 = @$filter["w_Time_of_new_e"];
		$this->Time_of_new_e->AdvancedSearch->save();

		// Field Time_of_Finished_e
		$this->Time_of_Finished_e->AdvancedSearch->SearchValue = @$filter["x_Time_of_Finished_e"];
		$this->Time_of_Finished_e->AdvancedSearch->SearchOperator = @$filter["z_Time_of_Finished_e"];
		$this->Time_of_Finished_e->AdvancedSearch->SearchCondition = @$filter["v_Time_of_Finished_e"];
		$this->Time_of_Finished_e->AdvancedSearch->SearchValue2 = @$filter["y_Time_of_Finished_e"];
		$this->Time_of_Finished_e->AdvancedSearch->SearchOperator2 = @$filter["w_Time_of_Finished_e"];
		$this->Time_of_Finished_e->AdvancedSearch->save();

		// Field KPI_CC_Hour_e
		$this->KPI_CC_Hour_e->AdvancedSearch->SearchValue = @$filter["x_KPI_CC_Hour_e"];
		$this->KPI_CC_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_KPI_CC_Hour_e"];
		$this->KPI_CC_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_KPI_CC_Hour_e"];
		$this->KPI_CC_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_KPI_CC_Hour_e"];
		$this->KPI_CC_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_KPI_CC_Hour_e"];
		$this->KPI_CC_Hour_e->AdvancedSearch->save();

		// Field KPI_NEW_Hour_e
		$this->KPI_NEW_Hour_e->AdvancedSearch->SearchValue = @$filter["x_KPI_NEW_Hour_e"];
		$this->KPI_NEW_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_KPI_NEW_Hour_e"];
		$this->KPI_NEW_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_KPI_NEW_Hour_e"];
		$this->KPI_NEW_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_KPI_NEW_Hour_e"];
		$this->KPI_NEW_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_KPI_NEW_Hour_e"];
		$this->KPI_NEW_Hour_e->AdvancedSearch->save();

		// Field KPI_PROCESING_Hour_e
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->SearchValue = @$filter["x_KPI_PROCESING_Hour_e"];
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_KPI_PROCESING_Hour_e"];
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_KPI_PROCESING_Hour_e"];
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_KPI_PROCESING_Hour_e"];
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_KPI_PROCESING_Hour_e"];
		$this->KPI_PROCESING_Hour_e->AdvancedSearch->save();

		// Field KPI_ALL_Hour_e
		$this->KPI_ALL_Hour_e->AdvancedSearch->SearchValue = @$filter["x_KPI_ALL_Hour_e"];
		$this->KPI_ALL_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_KPI_ALL_Hour_e"];
		$this->KPI_ALL_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_KPI_ALL_Hour_e"];
		$this->KPI_ALL_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_KPI_ALL_Hour_e"];
		$this->KPI_ALL_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_KPI_ALL_Hour_e"];
		$this->KPI_ALL_Hour_e->AdvancedSearch->save();

		// Field Kpi_Register_Hour_e
		$this->Kpi_Register_Hour_e->AdvancedSearch->SearchValue = @$filter["x_Kpi_Register_Hour_e"];
		$this->Kpi_Register_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_Kpi_Register_Hour_e"];
		$this->Kpi_Register_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_Kpi_Register_Hour_e"];
		$this->Kpi_Register_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_Kpi_Register_Hour_e"];
		$this->Kpi_Register_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_Kpi_Register_Hour_e"];
		$this->Kpi_Register_Hour_e->AdvancedSearch->save();

		// Field Kpi_Bitel_Hour_e
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->SearchValue = @$filter["x_Kpi_Bitel_Hour_e"];
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->SearchOperator = @$filter["z_Kpi_Bitel_Hour_e"];
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->SearchCondition = @$filter["v_Kpi_Bitel_Hour_e"];
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->SearchValue2 = @$filter["y_Kpi_Bitel_Hour_e"];
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->SearchOperator2 = @$filter["w_Kpi_Bitel_Hour_e"];
		$this->Kpi_Bitel_Hour_e->AdvancedSearch->save();

		// Field AmountGB_e
		$this->AmountGB_e->AdvancedSearch->SearchValue = @$filter["x_AmountGB_e"];
		$this->AmountGB_e->AdvancedSearch->SearchOperator = @$filter["z_AmountGB_e"];
		$this->AmountGB_e->AdvancedSearch->SearchCondition = @$filter["v_AmountGB_e"];
		$this->AmountGB_e->AdvancedSearch->SearchValue2 = @$filter["y_AmountGB_e"];
		$this->AmountGB_e->AdvancedSearch->SearchOperator2 = @$filter["w_AmountGB_e"];
		$this->AmountGB_e->AdvancedSearch->save();

		// Field Price_1_e
		$this->Price_1_e->AdvancedSearch->SearchValue = @$filter["x_Price_1_e"];
		$this->Price_1_e->AdvancedSearch->SearchOperator = @$filter["z_Price_1_e"];
		$this->Price_1_e->AdvancedSearch->SearchCondition = @$filter["v_Price_1_e"];
		$this->Price_1_e->AdvancedSearch->SearchValue2 = @$filter["y_Price_1_e"];
		$this->Price_1_e->AdvancedSearch->SearchOperator2 = @$filter["w_Price_1_e"];
		$this->Price_1_e->AdvancedSearch->save();

		// Field Status_1_e
		$this->Status_1_e->AdvancedSearch->SearchValue = @$filter["x_Status_1_e"];
		$this->Status_1_e->AdvancedSearch->SearchOperator = @$filter["z_Status_1_e"];
		$this->Status_1_e->AdvancedSearch->SearchCondition = @$filter["v_Status_1_e"];
		$this->Status_1_e->AdvancedSearch->SearchValue2 = @$filter["y_Status_1_e"];
		$this->Status_1_e->AdvancedSearch->SearchOperator2 = @$filter["w_Status_1_e"];
		$this->Status_1_e->AdvancedSearch->save();

		// Field Registered_Date_e
		$this->Registered_Date_e->AdvancedSearch->SearchValue = @$filter["x_Registered_Date_e"];
		$this->Registered_Date_e->AdvancedSearch->SearchOperator = @$filter["z_Registered_Date_e"];
		$this->Registered_Date_e->AdvancedSearch->SearchCondition = @$filter["v_Registered_Date_e"];
		$this->Registered_Date_e->AdvancedSearch->SearchValue2 = @$filter["y_Registered_Date_e"];
		$this->Registered_Date_e->AdvancedSearch->SearchOperator2 = @$filter["w_Registered_Date_e"];
		$this->Registered_Date_e->AdvancedSearch->save();

		// Field Sumary_e
		$this->Sumary_e->AdvancedSearch->SearchValue = @$filter["x_Sumary_e"];
		$this->Sumary_e->AdvancedSearch->SearchOperator = @$filter["z_Sumary_e"];
		$this->Sumary_e->AdvancedSearch->SearchCondition = @$filter["v_Sumary_e"];
		$this->Sumary_e->AdvancedSearch->SearchValue2 = @$filter["y_Sumary_e"];
		$this->Sumary_e->AdvancedSearch->SearchOperator2 = @$filter["w_Sumary_e"];
		$this->Sumary_e->AdvancedSearch->save();

		// Field Plans_e
		$this->Plans_e->AdvancedSearch->SearchValue = @$filter["x_Plans_e"];
		$this->Plans_e->AdvancedSearch->SearchOperator = @$filter["z_Plans_e"];
		$this->Plans_e->AdvancedSearch->SearchCondition = @$filter["v_Plans_e"];
		$this->Plans_e->AdvancedSearch->SearchValue2 = @$filter["y_Plans_e"];
		$this->Plans_e->AdvancedSearch->SearchOperator2 = @$filter["w_Plans_e"];
		$this->Plans_e->AdvancedSearch->save();

		// Field Isdns_e
		$this->Isdns_e->AdvancedSearch->SearchValue = @$filter["x_Isdns_e"];
		$this->Isdns_e->AdvancedSearch->SearchOperator = @$filter["z_Isdns_e"];
		$this->Isdns_e->AdvancedSearch->SearchCondition = @$filter["v_Isdns_e"];
		$this->Isdns_e->AdvancedSearch->SearchValue2 = @$filter["y_Isdns_e"];
		$this->Isdns_e->AdvancedSearch->SearchOperator2 = @$filter["w_Isdns_e"];
		$this->Isdns_e->AdvancedSearch->save();

		// Field PlanTypes_e
		$this->PlanTypes_e->AdvancedSearch->SearchValue = @$filter["x_PlanTypes_e"];
		$this->PlanTypes_e->AdvancedSearch->SearchOperator = @$filter["z_PlanTypes_e"];
		$this->PlanTypes_e->AdvancedSearch->SearchCondition = @$filter["v_PlanTypes_e"];
		$this->PlanTypes_e->AdvancedSearch->SearchValue2 = @$filter["y_PlanTypes_e"];
		$this->PlanTypes_e->AdvancedSearch->SearchOperator2 = @$filter["w_PlanTypes_e"];
		$this->PlanTypes_e->AdvancedSearch->save();

		// Field Serials_e
		$this->Serials_e->AdvancedSearch->SearchValue = @$filter["x_Serials_e"];
		$this->Serials_e->AdvancedSearch->SearchOperator = @$filter["z_Serials_e"];
		$this->Serials_e->AdvancedSearch->SearchCondition = @$filter["v_Serials_e"];
		$this->Serials_e->AdvancedSearch->SearchValue2 = @$filter["y_Serials_e"];
		$this->Serials_e->AdvancedSearch->SearchOperator2 = @$filter["w_Serials_e"];
		$this->Serials_e->AdvancedSearch->save();

		// Field Status_2_e
		$this->Status_2_e->AdvancedSearch->SearchValue = @$filter["x_Status_2_e"];
		$this->Status_2_e->AdvancedSearch->SearchOperator = @$filter["z_Status_2_e"];
		$this->Status_2_e->AdvancedSearch->SearchCondition = @$filter["v_Status_2_e"];
		$this->Status_2_e->AdvancedSearch->SearchValue2 = @$filter["y_Status_2_e"];
		$this->Status_2_e->AdvancedSearch->SearchOperator2 = @$filter["w_Status_2_e"];
		$this->Status_2_e->AdvancedSearch->save();

		// Field Registered_Date_2_e
		$this->Registered_Date_2_e->AdvancedSearch->SearchValue = @$filter["x_Registered_Date_2_e"];
		$this->Registered_Date_2_e->AdvancedSearch->SearchOperator = @$filter["z_Registered_Date_2_e"];
		$this->Registered_Date_2_e->AdvancedSearch->SearchCondition = @$filter["v_Registered_Date_2_e"];
		$this->Registered_Date_2_e->AdvancedSearch->SearchValue2 = @$filter["y_Registered_Date_2_e"];
		$this->Registered_Date_2_e->AdvancedSearch->SearchOperator2 = @$filter["w_Registered_Date_2_e"];
		$this->Registered_Date_2_e->AdvancedSearch->save();

		// Field Summary_2_e
		$this->Summary_2_e->AdvancedSearch->SearchValue = @$filter["x_Summary_2_e"];
		$this->Summary_2_e->AdvancedSearch->SearchOperator = @$filter["z_Summary_2_e"];
		$this->Summary_2_e->AdvancedSearch->SearchCondition = @$filter["v_Summary_2_e"];
		$this->Summary_2_e->AdvancedSearch->SearchValue2 = @$filter["y_Summary_2_e"];
		$this->Summary_2_e->AdvancedSearch->SearchOperator2 = @$filter["w_Summary_2_e"];
		$this->Summary_2_e->AdvancedSearch->save();

		// Field serial_2_e
		$this->serial_2_e->AdvancedSearch->SearchValue = @$filter["x_serial_2_e"];
		$this->serial_2_e->AdvancedSearch->SearchOperator = @$filter["z_serial_2_e"];
		$this->serial_2_e->AdvancedSearch->SearchCondition = @$filter["v_serial_2_e"];
		$this->serial_2_e->AdvancedSearch->SearchValue2 = @$filter["y_serial_2_e"];
		$this->serial_2_e->AdvancedSearch->SearchOperator2 = @$filter["w_serial_2_e"];
		$this->serial_2_e->AdvancedSearch->save();

		// Field HandsetCode_e
		$this->HandsetCode_e->AdvancedSearch->SearchValue = @$filter["x_HandsetCode_e"];
		$this->HandsetCode_e->AdvancedSearch->SearchOperator = @$filter["z_HandsetCode_e"];
		$this->HandsetCode_e->AdvancedSearch->SearchCondition = @$filter["v_HandsetCode_e"];
		$this->HandsetCode_e->AdvancedSearch->SearchValue2 = @$filter["y_HandsetCode_e"];
		$this->HandsetCode_e->AdvancedSearch->SearchOperator2 = @$filter["w_HandsetCode_e"];
		$this->HandsetCode_e->AdvancedSearch->save();

		// Field HandsetName_e
		$this->HandsetName_e->AdvancedSearch->SearchValue = @$filter["x_HandsetName_e"];
		$this->HandsetName_e->AdvancedSearch->SearchOperator = @$filter["z_HandsetName_e"];
		$this->HandsetName_e->AdvancedSearch->SearchCondition = @$filter["v_HandsetName_e"];
		$this->HandsetName_e->AdvancedSearch->SearchValue2 = @$filter["y_HandsetName_e"];
		$this->HandsetName_e->AdvancedSearch->SearchOperator2 = @$filter["w_HandsetName_e"];
		$this->HandsetName_e->AdvancedSearch->save();

		// Field Status_3_e
		$this->Status_3_e->AdvancedSearch->SearchValue = @$filter["x_Status_3_e"];
		$this->Status_3_e->AdvancedSearch->SearchOperator = @$filter["z_Status_3_e"];
		$this->Status_3_e->AdvancedSearch->SearchCondition = @$filter["v_Status_3_e"];
		$this->Status_3_e->AdvancedSearch->SearchValue2 = @$filter["y_Status_3_e"];
		$this->Status_3_e->AdvancedSearch->SearchOperator2 = @$filter["w_Status_3_e"];
		$this->Status_3_e->AdvancedSearch->save();

		// Field Summary_3_e
		$this->Summary_3_e->AdvancedSearch->SearchValue = @$filter["x_Summary_3_e"];
		$this->Summary_3_e->AdvancedSearch->SearchOperator = @$filter["z_Summary_3_e"];
		$this->Summary_3_e->AdvancedSearch->SearchCondition = @$filter["v_Summary_3_e"];
		$this->Summary_3_e->AdvancedSearch->SearchValue2 = @$filter["y_Summary_3_e"];
		$this->Summary_3_e->AdvancedSearch->SearchOperator2 = @$filter["w_Summary_3_e"];
		$this->Summary_3_e->AdvancedSearch->save();

		// Field fecha_activa_e
		$this->fecha_activa_e->AdvancedSearch->SearchValue = @$filter["x_fecha_activa_e"];
		$this->fecha_activa_e->AdvancedSearch->SearchOperator = @$filter["z_fecha_activa_e"];
		$this->fecha_activa_e->AdvancedSearch->SearchCondition = @$filter["v_fecha_activa_e"];
		$this->fecha_activa_e->AdvancedSearch->SearchValue2 = @$filter["y_fecha_activa_e"];
		$this->fecha_activa_e->AdvancedSearch->SearchOperator2 = @$filter["w_fecha_activa_e"];
		$this->fecha_activa_e->AdvancedSearch->save();

		// Field mes_activa_e
		$this->mes_activa_e->AdvancedSearch->SearchValue = @$filter["x_mes_activa_e"];
		$this->mes_activa_e->AdvancedSearch->SearchOperator = @$filter["z_mes_activa_e"];
		$this->mes_activa_e->AdvancedSearch->SearchCondition = @$filter["v_mes_activa_e"];
		$this->mes_activa_e->AdvancedSearch->SearchValue2 = @$filter["y_mes_activa_e"];
		$this->mes_activa_e->AdvancedSearch->SearchOperator2 = @$filter["w_mes_activa_e"];
		$this->mes_activa_e->AdvancedSearch->save();

		// Field SOURCE_OUT_e
		$this->SOURCE_OUT_e->AdvancedSearch->SearchValue = @$filter["x_SOURCE_OUT_e"];
		$this->SOURCE_OUT_e->AdvancedSearch->SearchOperator = @$filter["z_SOURCE_OUT_e"];
		$this->SOURCE_OUT_e->AdvancedSearch->SearchCondition = @$filter["v_SOURCE_OUT_e"];
		$this->SOURCE_OUT_e->AdvancedSearch->SearchValue2 = @$filter["y_SOURCE_OUT_e"];
		$this->SOURCE_OUT_e->AdvancedSearch->SearchOperator2 = @$filter["w_SOURCE_OUT_e"];
		$this->SOURCE_OUT_e->AdvancedSearch->save();

		// Field fecha_crea_e
		$this->fecha_crea_e->AdvancedSearch->SearchValue = @$filter["x_fecha_crea_e"];
		$this->fecha_crea_e->AdvancedSearch->SearchOperator = @$filter["z_fecha_crea_e"];
		$this->fecha_crea_e->AdvancedSearch->SearchCondition = @$filter["v_fecha_crea_e"];
		$this->fecha_crea_e->AdvancedSearch->SearchValue2 = @$filter["y_fecha_crea_e"];
		$this->fecha_crea_e->AdvancedSearch->SearchOperator2 = @$filter["w_fecha_crea_e"];
		$this->fecha_crea_e->AdvancedSearch->save();

		// Field mes_crea_e
		$this->mes_crea_e->AdvancedSearch->SearchValue = @$filter["x_mes_crea_e"];
		$this->mes_crea_e->AdvancedSearch->SearchOperator = @$filter["z_mes_crea_e"];
		$this->mes_crea_e->AdvancedSearch->SearchCondition = @$filter["v_mes_crea_e"];
		$this->mes_crea_e->AdvancedSearch->SearchValue2 = @$filter["y_mes_crea_e"];
		$this->mes_crea_e->AdvancedSearch->SearchOperator2 = @$filter["w_mes_crea_e"];
		$this->mes_crea_e->AdvancedSearch->save();

		// Field moto_e
		$this->moto_e->AdvancedSearch->SearchValue = @$filter["x_moto_e"];
		$this->moto_e->AdvancedSearch->SearchOperator = @$filter["z_moto_e"];
		$this->moto_e->AdvancedSearch->SearchCondition = @$filter["v_moto_e"];
		$this->moto_e->AdvancedSearch->SearchValue2 = @$filter["y_moto_e"];
		$this->moto_e->AdvancedSearch->SearchOperator2 = @$filter["w_moto_e"];
		$this->moto_e->AdvancedSearch->save();

		// Field customer_id
		$this->customer_id->AdvancedSearch->SearchValue = @$filter["x_customer_id"];
		$this->customer_id->AdvancedSearch->SearchOperator = @$filter["z_customer_id"];
		$this->customer_id->AdvancedSearch->SearchCondition = @$filter["v_customer_id"];
		$this->customer_id->AdvancedSearch->SearchValue2 = @$filter["y_customer_id"];
		$this->customer_id->AdvancedSearch->SearchOperator2 = @$filter["w_customer_id"];
		$this->customer_id->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field address_e
		$this->address_e->AdvancedSearch->SearchValue = @$filter["x_address_e"];
		$this->address_e->AdvancedSearch->SearchOperator = @$filter["z_address_e"];
		$this->address_e->AdvancedSearch->SearchCondition = @$filter["v_address_e"];
		$this->address_e->AdvancedSearch->SearchValue2 = @$filter["y_address_e"];
		$this->address_e->AdvancedSearch->SearchOperator2 = @$filter["w_address_e"];
		$this->address_e->AdvancedSearch->save();

		// Field branch_e
		$this->branch_e->AdvancedSearch->SearchValue = @$filter["x_branch_e"];
		$this->branch_e->AdvancedSearch->SearchOperator = @$filter["z_branch_e"];
		$this->branch_e->AdvancedSearch->SearchCondition = @$filter["v_branch_e"];
		$this->branch_e->AdvancedSearch->SearchValue2 = @$filter["y_branch_e"];
		$this->branch_e->AdvancedSearch->SearchOperator2 = @$filter["w_branch_e"];
		$this->branch_e->AdvancedSearch->save();

		// Field CreatedTime_e
		$this->CreatedTime_e->AdvancedSearch->SearchValue = @$filter["x_CreatedTime_e"];
		$this->CreatedTime_e->AdvancedSearch->SearchOperator = @$filter["z_CreatedTime_e"];
		$this->CreatedTime_e->AdvancedSearch->SearchCondition = @$filter["v_CreatedTime_e"];
		$this->CreatedTime_e->AdvancedSearch->SearchValue2 = @$filter["y_CreatedTime_e"];
		$this->CreatedTime_e->AdvancedSearch->SearchOperator2 = @$filter["w_CreatedTime_e"];
		$this->CreatedTime_e->AdvancedSearch->save();

		// Field Status_n
		$this->Status_n->AdvancedSearch->SearchValue = @$filter["x_Status_n"];
		$this->Status_n->AdvancedSearch->SearchOperator = @$filter["z_Status_n"];
		$this->Status_n->AdvancedSearch->SearchCondition = @$filter["v_Status_n"];
		$this->Status_n->AdvancedSearch->SearchValue2 = @$filter["y_Status_n"];
		$this->Status_n->AdvancedSearch->SearchOperator2 = @$filter["w_Status_n"];
		$this->Status_n->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->task_description, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->trans_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->contact_number, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->email_address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->customer_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->delivery_address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->task_lat, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->task_lng, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->customer_signature, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ip_address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->auto_assign_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->assignment_status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dropoff_contact_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dropoff_contact_number, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->drop_address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dropoff_task_lat, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dropoff_task_lng, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->task_token, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ratings, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rating_comment, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->souce_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shop_code_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Received_Channel_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PayMethod_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Type_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Request_Code_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PlanType_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Plan_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Isdn_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->serial_sim_handset_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->handset_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Connect_Reason_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Current_Operator_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Current_Plan_Type_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Document_Number_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Document_Type_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->assignStaffCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Delivery_Type_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->assignStaffType_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->receiveStaffCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->receiveStaffType_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->connectStaffCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->connectStaffType_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shopName_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->saleOrderCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consultantCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consultantName_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consultantType_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->created_By_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->createdBranch_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->generated_Code_By_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->approve_Paid_By_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Delivery_Note_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Delivery_Code_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Customer_Note_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->saleOrderCreateDate_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->saleOrderPayDate_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Time_of_Procesing_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Time_of_new_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Time_of_Finished_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KPI_CC_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KPI_NEW_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KPI_PROCESING_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KPI_ALL_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kpi_Register_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kpi_Bitel_Hour_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->AmountGB_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Price_1_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_1_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Registered_Date_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Sumary_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Plans_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Isdns_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PlanTypes_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Serials_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_2_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Registered_Date_2_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Summary_2_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->serial_2_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->HandsetCode_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->HandsetName_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_3_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Summary_3_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fecha_activa_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mes_activa_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SOURCE_OUT_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fecha_crea_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mes_crea_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->moto_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->address_e, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->branch_e, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->task_id); // task_id
			$this->updateSort($this->task_description); // task_description
			$this->updateSort($this->trans_type); // trans_type
			$this->updateSort($this->contact_number); // contact_number
			$this->updateSort($this->email_address); // email_address
			$this->updateSort($this->customer_name); // customer_name
			$this->updateSort($this->delivery_date); // delivery_date
			$this->updateSort($this->team_id); // team_id
			$this->updateSort($this->driver_id); // driver_id
			$this->updateSort($this->task_lat); // task_lat
			$this->updateSort($this->task_lng); // task_lng
			$this->updateSort($this->customer_signature); // customer_signature
			$this->updateSort($this->date_created); // date_created
			$this->updateSort($this->date_modified); // date_modified
			$this->updateSort($this->ip_address); // ip_address
			$this->updateSort($this->auto_assign_type); // auto_assign_type
			$this->updateSort($this->assign_started); // assign_started
			$this->updateSort($this->assignment_status); // assignment_status
			$this->updateSort($this->dropoff_contact_name); // dropoff_contact_name
			$this->updateSort($this->dropoff_contact_number); // dropoff_contact_number
			$this->updateSort($this->drop_address); // drop_address
			$this->updateSort($this->dropoff_task_lat); // dropoff_task_lat
			$this->updateSort($this->dropoff_task_lng); // dropoff_task_lng
			$this->updateSort($this->task_token); // task_token
			$this->updateSort($this->ratings); // ratings
			$this->updateSort($this->rating_comment); // rating_comment
			$this->updateSort($this->critical); // critical
			$this->updateSort($this->souce_e); // souce_e
			$this->updateSort($this->shop_code_e); // shop_code_e
			$this->updateSort($this->Received_Channel_e); // Received_Channel_e
			$this->updateSort($this->PayMethod_e); // PayMethod_e
			$this->updateSort($this->Type_e); // Type_e
			$this->updateSort($this->Request_Code_e); // Request_Code_e
			$this->updateSort($this->Status_e); // Status_e
			$this->updateSort($this->PlanType_e); // PlanType_e
			$this->updateSort($this->Plan_e); // Plan_e
			$this->updateSort($this->Isdn_e); // Isdn_e
			$this->updateSort($this->serial_sim_handset_e); // serial_sim_handset_e
			$this->updateSort($this->handset_e); // handset_e
			$this->updateSort($this->Connect_Reason_e); // Connect_Reason_e
			$this->updateSort($this->Price_e); // Price_e
			$this->updateSort($this->Current_Operator_e); // Current_Operator_e
			$this->updateSort($this->Current_Plan_Type_e); // Current_Plan_Type_e
			$this->updateSort($this->Document_Number_e); // Document_Number_e
			$this->updateSort($this->Document_Type_e); // Document_Type_e
			$this->updateSort($this->assignStaffCode_e); // assignStaffCode_e
			$this->updateSort($this->Delivery_Type_e); // Delivery_Type_e
			$this->updateSort($this->assignStaffType_e); // assignStaffType_e
			$this->updateSort($this->receiveStaffCode_e); // receiveStaffCode_e
			$this->updateSort($this->receiveStaffType_e); // receiveStaffType_e
			$this->updateSort($this->connectStaffCode_e); // connectStaffCode_e
			$this->updateSort($this->connectStaffType_e); // connectStaffType_e
			$this->updateSort($this->shopName_e); // shopName_e
			$this->updateSort($this->saleOrderCode_e); // saleOrderCode_e
			$this->updateSort($this->consultantCode_e); // consultantCode_e
			$this->updateSort($this->consultantName_e); // consultantName_e
			$this->updateSort($this->consultantType_e); // consultantType_e
			$this->updateSort($this->created_By_e); // created_By_e
			$this->updateSort($this->createdBranch_e); // createdBranch_e
			$this->updateSort($this->generated_Code_By_e); // generated_Code_By_e
			$this->updateSort($this->approve_Paid_By_e); // approve_Paid_By_e
			$this->updateSort($this->Delivery_Note_e); // Delivery_Note_e
			$this->updateSort($this->Delivery_Code_e); // Delivery_Code_e
			$this->updateSort($this->Customer_Note_e); // Customer_Note_e
			$this->updateSort($this->saleOrderCreateDate_e); // saleOrderCreateDate_e
			$this->updateSort($this->saleOrderPayDate_e); // saleOrderPayDate_e
			$this->updateSort($this->Time_of_Procesing_e); // Time_of_Procesing_e
			$this->updateSort($this->Time_of_new_e); // Time_of_new_e
			$this->updateSort($this->Time_of_Finished_e); // Time_of_Finished_e
			$this->updateSort($this->KPI_CC_Hour_e); // KPI_CC_Hour_e
			$this->updateSort($this->KPI_NEW_Hour_e); // KPI_NEW_Hour_e
			$this->updateSort($this->KPI_PROCESING_Hour_e); // KPI_PROCESING_Hour_e
			$this->updateSort($this->KPI_ALL_Hour_e); // KPI_ALL_Hour_e
			$this->updateSort($this->Kpi_Register_Hour_e); // Kpi_Register_Hour_e
			$this->updateSort($this->Kpi_Bitel_Hour_e); // Kpi_Bitel_Hour_e
			$this->updateSort($this->AmountGB_e); // AmountGB_e
			$this->updateSort($this->Price_1_e); // Price_1_e
			$this->updateSort($this->Status_1_e); // Status_1_e
			$this->updateSort($this->Registered_Date_e); // Registered_Date_e
			$this->updateSort($this->Sumary_e); // Sumary_e
			$this->updateSort($this->Plans_e); // Plans_e
			$this->updateSort($this->Isdns_e); // Isdns_e
			$this->updateSort($this->PlanTypes_e); // PlanTypes_e
			$this->updateSort($this->Serials_e); // Serials_e
			$this->updateSort($this->Status_2_e); // Status_2_e
			$this->updateSort($this->Registered_Date_2_e); // Registered_Date_2_e
			$this->updateSort($this->Summary_2_e); // Summary_2_e
			$this->updateSort($this->serial_2_e); // serial_2_e
			$this->updateSort($this->HandsetCode_e); // HandsetCode_e
			$this->updateSort($this->HandsetName_e); // HandsetName_e
			$this->updateSort($this->Status_3_e); // Status_3_e
			$this->updateSort($this->Summary_3_e); // Summary_3_e
			$this->updateSort($this->fecha_activa_e); // fecha_activa_e
			$this->updateSort($this->mes_activa_e); // mes_activa_e
			$this->updateSort($this->SOURCE_OUT_e); // SOURCE_OUT_e
			$this->updateSort($this->fecha_crea_e); // fecha_crea_e
			$this->updateSort($this->mes_crea_e); // mes_crea_e
			$this->updateSort($this->moto_e); // moto_e
			$this->updateSort($this->customer_id); // customer_id
			$this->updateSort($this->status); // status
			$this->updateSort($this->branch_e); // branch_e
			$this->updateSort($this->CreatedTime_e); // CreatedTime_e
			$this->updateSort($this->Status_n); // Status_n
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->task_id->setSort("");
				$this->task_description->setSort("");
				$this->trans_type->setSort("");
				$this->contact_number->setSort("");
				$this->email_address->setSort("");
				$this->customer_name->setSort("");
				$this->delivery_date->setSort("");
				$this->team_id->setSort("");
				$this->driver_id->setSort("");
				$this->task_lat->setSort("");
				$this->task_lng->setSort("");
				$this->customer_signature->setSort("");
				$this->date_created->setSort("");
				$this->date_modified->setSort("");
				$this->ip_address->setSort("");
				$this->auto_assign_type->setSort("");
				$this->assign_started->setSort("");
				$this->assignment_status->setSort("");
				$this->dropoff_contact_name->setSort("");
				$this->dropoff_contact_number->setSort("");
				$this->drop_address->setSort("");
				$this->dropoff_task_lat->setSort("");
				$this->dropoff_task_lng->setSort("");
				$this->task_token->setSort("");
				$this->ratings->setSort("");
				$this->rating_comment->setSort("");
				$this->critical->setSort("");
				$this->souce_e->setSort("");
				$this->shop_code_e->setSort("");
				$this->Received_Channel_e->setSort("");
				$this->PayMethod_e->setSort("");
				$this->Type_e->setSort("");
				$this->Request_Code_e->setSort("");
				$this->Status_e->setSort("");
				$this->PlanType_e->setSort("");
				$this->Plan_e->setSort("");
				$this->Isdn_e->setSort("");
				$this->serial_sim_handset_e->setSort("");
				$this->handset_e->setSort("");
				$this->Connect_Reason_e->setSort("");
				$this->Price_e->setSort("");
				$this->Current_Operator_e->setSort("");
				$this->Current_Plan_Type_e->setSort("");
				$this->Document_Number_e->setSort("");
				$this->Document_Type_e->setSort("");
				$this->assignStaffCode_e->setSort("");
				$this->Delivery_Type_e->setSort("");
				$this->assignStaffType_e->setSort("");
				$this->receiveStaffCode_e->setSort("");
				$this->receiveStaffType_e->setSort("");
				$this->connectStaffCode_e->setSort("");
				$this->connectStaffType_e->setSort("");
				$this->shopName_e->setSort("");
				$this->saleOrderCode_e->setSort("");
				$this->consultantCode_e->setSort("");
				$this->consultantName_e->setSort("");
				$this->consultantType_e->setSort("");
				$this->created_By_e->setSort("");
				$this->createdBranch_e->setSort("");
				$this->generated_Code_By_e->setSort("");
				$this->approve_Paid_By_e->setSort("");
				$this->Delivery_Note_e->setSort("");
				$this->Delivery_Code_e->setSort("");
				$this->Customer_Note_e->setSort("");
				$this->saleOrderCreateDate_e->setSort("");
				$this->saleOrderPayDate_e->setSort("");
				$this->Time_of_Procesing_e->setSort("");
				$this->Time_of_new_e->setSort("");
				$this->Time_of_Finished_e->setSort("");
				$this->KPI_CC_Hour_e->setSort("");
				$this->KPI_NEW_Hour_e->setSort("");
				$this->KPI_PROCESING_Hour_e->setSort("");
				$this->KPI_ALL_Hour_e->setSort("");
				$this->Kpi_Register_Hour_e->setSort("");
				$this->Kpi_Bitel_Hour_e->setSort("");
				$this->AmountGB_e->setSort("");
				$this->Price_1_e->setSort("");
				$this->Status_1_e->setSort("");
				$this->Registered_Date_e->setSort("");
				$this->Sumary_e->setSort("");
				$this->Plans_e->setSort("");
				$this->Isdns_e->setSort("");
				$this->PlanTypes_e->setSort("");
				$this->Serials_e->setSort("");
				$this->Status_2_e->setSort("");
				$this->Registered_Date_2_e->setSort("");
				$this->Summary_2_e->setSort("");
				$this->serial_2_e->setSort("");
				$this->HandsetCode_e->setSort("");
				$this->HandsetName_e->setSort("");
				$this->Status_3_e->setSort("");
				$this->Summary_3_e->setSort("");
				$this->fecha_activa_e->setSort("");
				$this->mes_activa_e->setSort("");
				$this->SOURCE_OUT_e->setSort("");
				$this->fecha_crea_e->setSort("");
				$this->mes_crea_e->setSort("");
				$this->moto_e->setSort("");
				$this->customer_id->setSort("");
				$this->status->setSort("");
				$this->branch_e->setSort("");
				$this->CreatedTime_e->setSort("");
				$this->Status_n->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = $this->ListOptions["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = $this->ListOptions["delete"];
		if ($Security->isLoggedIn())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->task_id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = $this->AddUrl != "" && $Security->isLoggedIn();
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fkt_driver_tasklistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fkt_driver_tasklistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.fkt_driver_tasklist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->task_id->setDbValue($row['task_id']);
		$this->task_description->setDbValue($row['task_description']);
		$this->trans_type->setDbValue($row['trans_type']);
		$this->contact_number->setDbValue($row['contact_number']);
		$this->email_address->setDbValue($row['email_address']);
		$this->customer_name->setDbValue($row['customer_name']);
		$this->delivery_date->setDbValue($row['delivery_date']);
		$this->delivery_address->setDbValue($row['delivery_address']);
		$this->team_id->setDbValue($row['team_id']);
		$this->driver_id->setDbValue($row['driver_id']);
		$this->task_lat->setDbValue($row['task_lat']);
		$this->task_lng->setDbValue($row['task_lng']);
		$this->customer_signature->setDbValue($row['customer_signature']);
		$this->date_created->setDbValue($row['date_created']);
		$this->date_modified->setDbValue($row['date_modified']);
		$this->ip_address->setDbValue($row['ip_address']);
		$this->auto_assign_type->setDbValue($row['auto_assign_type']);
		$this->assign_started->setDbValue($row['assign_started']);
		$this->assignment_status->setDbValue($row['assignment_status']);
		$this->dropoff_contact_name->setDbValue($row['dropoff_contact_name']);
		$this->dropoff_contact_number->setDbValue($row['dropoff_contact_number']);
		$this->drop_address->setDbValue($row['drop_address']);
		$this->dropoff_task_lat->setDbValue($row['dropoff_task_lat']);
		$this->dropoff_task_lng->setDbValue($row['dropoff_task_lng']);
		$this->task_token->setDbValue($row['task_token']);
		$this->ratings->setDbValue($row['ratings']);
		$this->rating_comment->setDbValue($row['rating_comment']);
		$this->critical->setDbValue($row['critical']);
		$this->souce_e->setDbValue($row['souce_e']);
		$this->shop_code_e->setDbValue($row['shop_code_e']);
		$this->Received_Channel_e->setDbValue($row['Received_Channel_e']);
		$this->PayMethod_e->setDbValue($row['PayMethod_e']);
		$this->Type_e->setDbValue($row['Type_e']);
		$this->Request_Code_e->setDbValue($row['Request_Code_e']);
		$this->Status_e->setDbValue($row['Status_e']);
		$this->PlanType_e->setDbValue($row['PlanType_e']);
		$this->Plan_e->setDbValue($row['Plan_e']);
		$this->Isdn_e->setDbValue($row['Isdn_e']);
		$this->serial_sim_handset_e->setDbValue($row['serial_sim_handset_e']);
		$this->handset_e->setDbValue($row['handset_e']);
		$this->Connect_Reason_e->setDbValue($row['Connect_Reason_e']);
		$this->Price_e->setDbValue($row['Price_e']);
		$this->Current_Operator_e->setDbValue($row['Current_Operator_e']);
		$this->Current_Plan_Type_e->setDbValue($row['Current_Plan_Type_e']);
		$this->Document_Number_e->setDbValue($row['Document_Number_e']);
		$this->Document_Type_e->setDbValue($row['Document_Type_e']);
		$this->assignStaffCode_e->setDbValue($row['assignStaffCode_e']);
		$this->Delivery_Type_e->setDbValue($row['Delivery_Type_e']);
		$this->assignStaffType_e->setDbValue($row['assignStaffType_e']);
		$this->receiveStaffCode_e->setDbValue($row['receiveStaffCode_e']);
		$this->receiveStaffType_e->setDbValue($row['receiveStaffType_e']);
		$this->connectStaffCode_e->setDbValue($row['connectStaffCode_e']);
		$this->connectStaffType_e->setDbValue($row['connectStaffType_e']);
		$this->shopName_e->setDbValue($row['shopName_e']);
		$this->saleOrderCode_e->setDbValue($row['saleOrderCode_e']);
		$this->consultantCode_e->setDbValue($row['consultantCode_e']);
		$this->consultantName_e->setDbValue($row['consultantName_e']);
		$this->consultantType_e->setDbValue($row['consultantType_e']);
		$this->created_By_e->setDbValue($row['created_By_e']);
		$this->createdBranch_e->setDbValue($row['createdBranch_e']);
		$this->generated_Code_By_e->setDbValue($row['generated_Code_By_e']);
		$this->approve_Paid_By_e->setDbValue($row['approve_Paid_By_e']);
		$this->Delivery_Note_e->setDbValue($row['Delivery_Note_e']);
		$this->Delivery_Code_e->setDbValue($row['Delivery_Code_e']);
		$this->Customer_Note_e->setDbValue($row['Customer_Note_e']);
		$this->saleOrderCreateDate_e->setDbValue($row['saleOrderCreateDate_e']);
		$this->saleOrderPayDate_e->setDbValue($row['saleOrderPayDate_e']);
		$this->Time_of_Procesing_e->setDbValue($row['Time_of_Procesing_e']);
		$this->Time_of_new_e->setDbValue($row['Time_of_new_e']);
		$this->Time_of_Finished_e->setDbValue($row['Time_of_Finished_e']);
		$this->KPI_CC_Hour_e->setDbValue($row['KPI_CC_Hour_e']);
		$this->KPI_NEW_Hour_e->setDbValue($row['KPI_NEW_Hour_e']);
		$this->KPI_PROCESING_Hour_e->setDbValue($row['KPI_PROCESING_Hour_e']);
		$this->KPI_ALL_Hour_e->setDbValue($row['KPI_ALL_Hour_e']);
		$this->Kpi_Register_Hour_e->setDbValue($row['Kpi_Register_Hour_e']);
		$this->Kpi_Bitel_Hour_e->setDbValue($row['Kpi_Bitel_Hour_e']);
		$this->AmountGB_e->setDbValue($row['AmountGB_e']);
		$this->Price_1_e->setDbValue($row['Price_1_e']);
		$this->Status_1_e->setDbValue($row['Status_1_e']);
		$this->Registered_Date_e->setDbValue($row['Registered_Date_e']);
		$this->Sumary_e->setDbValue($row['Sumary_e']);
		$this->Plans_e->setDbValue($row['Plans_e']);
		$this->Isdns_e->setDbValue($row['Isdns_e']);
		$this->PlanTypes_e->setDbValue($row['PlanTypes_e']);
		$this->Serials_e->setDbValue($row['Serials_e']);
		$this->Status_2_e->setDbValue($row['Status_2_e']);
		$this->Registered_Date_2_e->setDbValue($row['Registered_Date_2_e']);
		$this->Summary_2_e->setDbValue($row['Summary_2_e']);
		$this->serial_2_e->setDbValue($row['serial_2_e']);
		$this->HandsetCode_e->setDbValue($row['HandsetCode_e']);
		$this->HandsetName_e->setDbValue($row['HandsetName_e']);
		$this->Status_3_e->setDbValue($row['Status_3_e']);
		$this->Summary_3_e->setDbValue($row['Summary_3_e']);
		$this->fecha_activa_e->setDbValue($row['fecha_activa_e']);
		$this->mes_activa_e->setDbValue($row['mes_activa_e']);
		$this->SOURCE_OUT_e->setDbValue($row['SOURCE_OUT_e']);
		$this->fecha_crea_e->setDbValue($row['fecha_crea_e']);
		$this->mes_crea_e->setDbValue($row['mes_crea_e']);
		$this->moto_e->setDbValue($row['moto_e']);
		$this->customer_id->setDbValue($row['customer_id']);
		$this->status->setDbValue($row['status']);
		$this->address_e->setDbValue($row['address_e']);
		$this->branch_e->setDbValue($row['branch_e']);
		$this->CreatedTime_e->setDbValue($row['CreatedTime_e']);
		$this->Status_n->setDbValue($row['Status_n']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['task_id'] = NULL;
		$row['task_description'] = NULL;
		$row['trans_type'] = NULL;
		$row['contact_number'] = NULL;
		$row['email_address'] = NULL;
		$row['customer_name'] = NULL;
		$row['delivery_date'] = NULL;
		$row['delivery_address'] = NULL;
		$row['team_id'] = NULL;
		$row['driver_id'] = NULL;
		$row['task_lat'] = NULL;
		$row['task_lng'] = NULL;
		$row['customer_signature'] = NULL;
		$row['date_created'] = NULL;
		$row['date_modified'] = NULL;
		$row['ip_address'] = NULL;
		$row['auto_assign_type'] = NULL;
		$row['assign_started'] = NULL;
		$row['assignment_status'] = NULL;
		$row['dropoff_contact_name'] = NULL;
		$row['dropoff_contact_number'] = NULL;
		$row['drop_address'] = NULL;
		$row['dropoff_task_lat'] = NULL;
		$row['dropoff_task_lng'] = NULL;
		$row['task_token'] = NULL;
		$row['ratings'] = NULL;
		$row['rating_comment'] = NULL;
		$row['critical'] = NULL;
		$row['souce_e'] = NULL;
		$row['shop_code_e'] = NULL;
		$row['Received_Channel_e'] = NULL;
		$row['PayMethod_e'] = NULL;
		$row['Type_e'] = NULL;
		$row['Request_Code_e'] = NULL;
		$row['Status_e'] = NULL;
		$row['PlanType_e'] = NULL;
		$row['Plan_e'] = NULL;
		$row['Isdn_e'] = NULL;
		$row['serial_sim_handset_e'] = NULL;
		$row['handset_e'] = NULL;
		$row['Connect_Reason_e'] = NULL;
		$row['Price_e'] = NULL;
		$row['Current_Operator_e'] = NULL;
		$row['Current_Plan_Type_e'] = NULL;
		$row['Document_Number_e'] = NULL;
		$row['Document_Type_e'] = NULL;
		$row['assignStaffCode_e'] = NULL;
		$row['Delivery_Type_e'] = NULL;
		$row['assignStaffType_e'] = NULL;
		$row['receiveStaffCode_e'] = NULL;
		$row['receiveStaffType_e'] = NULL;
		$row['connectStaffCode_e'] = NULL;
		$row['connectStaffType_e'] = NULL;
		$row['shopName_e'] = NULL;
		$row['saleOrderCode_e'] = NULL;
		$row['consultantCode_e'] = NULL;
		$row['consultantName_e'] = NULL;
		$row['consultantType_e'] = NULL;
		$row['created_By_e'] = NULL;
		$row['createdBranch_e'] = NULL;
		$row['generated_Code_By_e'] = NULL;
		$row['approve_Paid_By_e'] = NULL;
		$row['Delivery_Note_e'] = NULL;
		$row['Delivery_Code_e'] = NULL;
		$row['Customer_Note_e'] = NULL;
		$row['saleOrderCreateDate_e'] = NULL;
		$row['saleOrderPayDate_e'] = NULL;
		$row['Time_of_Procesing_e'] = NULL;
		$row['Time_of_new_e'] = NULL;
		$row['Time_of_Finished_e'] = NULL;
		$row['KPI_CC_Hour_e'] = NULL;
		$row['KPI_NEW_Hour_e'] = NULL;
		$row['KPI_PROCESING_Hour_e'] = NULL;
		$row['KPI_ALL_Hour_e'] = NULL;
		$row['Kpi_Register_Hour_e'] = NULL;
		$row['Kpi_Bitel_Hour_e'] = NULL;
		$row['AmountGB_e'] = NULL;
		$row['Price_1_e'] = NULL;
		$row['Status_1_e'] = NULL;
		$row['Registered_Date_e'] = NULL;
		$row['Sumary_e'] = NULL;
		$row['Plans_e'] = NULL;
		$row['Isdns_e'] = NULL;
		$row['PlanTypes_e'] = NULL;
		$row['Serials_e'] = NULL;
		$row['Status_2_e'] = NULL;
		$row['Registered_Date_2_e'] = NULL;
		$row['Summary_2_e'] = NULL;
		$row['serial_2_e'] = NULL;
		$row['HandsetCode_e'] = NULL;
		$row['HandsetName_e'] = NULL;
		$row['Status_3_e'] = NULL;
		$row['Summary_3_e'] = NULL;
		$row['fecha_activa_e'] = NULL;
		$row['mes_activa_e'] = NULL;
		$row['SOURCE_OUT_e'] = NULL;
		$row['fecha_crea_e'] = NULL;
		$row['mes_crea_e'] = NULL;
		$row['moto_e'] = NULL;
		$row['customer_id'] = NULL;
		$row['status'] = NULL;
		$row['address_e'] = NULL;
		$row['branch_e'] = NULL;
		$row['CreatedTime_e'] = NULL;
		$row['Status_n'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("task_id")) != "")
			$this->task_id->OldValue = $this->getKey("task_id"); // task_id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->Price_e->FormValue == $this->Price_e->CurrentValue && is_numeric(ConvertToFloatString($this->Price_e->CurrentValue)))
			$this->Price_e->CurrentValue = ConvertToFloatString($this->Price_e->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// task_id
		// task_description
		// trans_type
		// contact_number
		// email_address
		// customer_name
		// delivery_date
		// delivery_address
		// team_id
		// driver_id
		// task_lat
		// task_lng
		// customer_signature
		// date_created
		// date_modified
		// ip_address
		// auto_assign_type
		// assign_started
		// assignment_status
		// dropoff_contact_name
		// dropoff_contact_number
		// drop_address
		// dropoff_task_lat
		// dropoff_task_lng
		// task_token
		// ratings
		// rating_comment
		// critical
		// souce_e
		// shop_code_e
		// Received_Channel_e
		// PayMethod_e
		// Type_e
		// Request_Code_e
		// Status_e
		// PlanType_e
		// Plan_e
		// Isdn_e
		// serial_sim_handset_e
		// handset_e
		// Connect_Reason_e
		// Price_e
		// Current_Operator_e
		// Current_Plan_Type_e
		// Document_Number_e
		// Document_Type_e
		// assignStaffCode_e
		// Delivery_Type_e
		// assignStaffType_e
		// receiveStaffCode_e
		// receiveStaffType_e
		// connectStaffCode_e
		// connectStaffType_e
		// shopName_e
		// saleOrderCode_e
		// consultantCode_e
		// consultantName_e
		// consultantType_e
		// created_By_e
		// createdBranch_e
		// generated_Code_By_e
		// approve_Paid_By_e
		// Delivery_Note_e
		// Delivery_Code_e
		// Customer_Note_e
		// saleOrderCreateDate_e
		// saleOrderPayDate_e
		// Time_of_Procesing_e
		// Time_of_new_e
		// Time_of_Finished_e
		// KPI_CC_Hour_e
		// KPI_NEW_Hour_e
		// KPI_PROCESING_Hour_e
		// KPI_ALL_Hour_e
		// Kpi_Register_Hour_e
		// Kpi_Bitel_Hour_e
		// AmountGB_e
		// Price_1_e
		// Status_1_e
		// Registered_Date_e
		// Sumary_e
		// Plans_e
		// Isdns_e
		// PlanTypes_e
		// Serials_e
		// Status_2_e
		// Registered_Date_2_e
		// Summary_2_e
		// serial_2_e
		// HandsetCode_e
		// HandsetName_e
		// Status_3_e
		// Summary_3_e
		// fecha_activa_e
		// mes_activa_e
		// SOURCE_OUT_e
		// fecha_crea_e
		// mes_crea_e
		// moto_e
		// customer_id
		// status
		// address_e
		// branch_e
		// CreatedTime_e
		// Status_n

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// task_id
			$this->task_id->ViewValue = $this->task_id->CurrentValue;
			$this->task_id->ViewCustomAttributes = "";

			// task_description
			$this->task_description->ViewValue = $this->task_description->CurrentValue;
			$this->task_description->ViewCustomAttributes = "";

			// trans_type
			$this->trans_type->ViewValue = $this->trans_type->CurrentValue;
			$this->trans_type->ViewCustomAttributes = "";

			// contact_number
			$this->contact_number->ViewValue = $this->contact_number->CurrentValue;
			$this->contact_number->ViewCustomAttributes = "";

			// email_address
			$this->email_address->ViewValue = $this->email_address->CurrentValue;
			$this->email_address->ViewCustomAttributes = "";

			// customer_name
			$this->customer_name->ViewValue = $this->customer_name->CurrentValue;
			$this->customer_name->ViewCustomAttributes = "";

			// delivery_date
			$this->delivery_date->ViewValue = $this->delivery_date->CurrentValue;
			$this->delivery_date->ViewValue = FormatDateTime($this->delivery_date->ViewValue, 0);
			$this->delivery_date->ViewCustomAttributes = "";

			// team_id
			$this->team_id->ViewValue = $this->team_id->CurrentValue;
			$this->team_id->ViewValue = FormatNumber($this->team_id->ViewValue, 0, -2, -2, -2);
			$this->team_id->ViewCustomAttributes = "";

			// driver_id
			$this->driver_id->ViewValue = $this->driver_id->CurrentValue;
			$this->driver_id->ViewValue = FormatNumber($this->driver_id->ViewValue, 0, -2, -2, -2);
			$this->driver_id->ViewCustomAttributes = "";

			// task_lat
			$this->task_lat->ViewValue = $this->task_lat->CurrentValue;
			$this->task_lat->ViewCustomAttributes = "";

			// task_lng
			$this->task_lng->ViewValue = $this->task_lng->CurrentValue;
			$this->task_lng->ViewCustomAttributes = "";

			// customer_signature
			$this->customer_signature->ViewValue = $this->customer_signature->CurrentValue;
			$this->customer_signature->ViewCustomAttributes = "";

			// date_created
			$this->date_created->ViewValue = $this->date_created->CurrentValue;
			$this->date_created->ViewValue = FormatDateTime($this->date_created->ViewValue, 0);
			$this->date_created->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = FormatDateTime($this->date_modified->ViewValue, 0);
			$this->date_modified->ViewCustomAttributes = "";

			// ip_address
			$this->ip_address->ViewValue = $this->ip_address->CurrentValue;
			$this->ip_address->ViewCustomAttributes = "";

			// auto_assign_type
			$this->auto_assign_type->ViewValue = $this->auto_assign_type->CurrentValue;
			$this->auto_assign_type->ViewCustomAttributes = "";

			// assign_started
			$this->assign_started->ViewValue = $this->assign_started->CurrentValue;
			$this->assign_started->ViewValue = FormatDateTime($this->assign_started->ViewValue, 0);
			$this->assign_started->ViewCustomAttributes = "";

			// assignment_status
			$this->assignment_status->ViewValue = $this->assignment_status->CurrentValue;
			$this->assignment_status->ViewCustomAttributes = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->ViewValue = $this->dropoff_contact_name->CurrentValue;
			$this->dropoff_contact_name->ViewCustomAttributes = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->ViewValue = $this->dropoff_contact_number->CurrentValue;
			$this->dropoff_contact_number->ViewCustomAttributes = "";

			// drop_address
			$this->drop_address->ViewValue = $this->drop_address->CurrentValue;
			$this->drop_address->ViewCustomAttributes = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->ViewValue = $this->dropoff_task_lat->CurrentValue;
			$this->dropoff_task_lat->ViewCustomAttributes = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->ViewValue = $this->dropoff_task_lng->CurrentValue;
			$this->dropoff_task_lng->ViewCustomAttributes = "";

			// task_token
			$this->task_token->ViewValue = $this->task_token->CurrentValue;
			$this->task_token->ViewCustomAttributes = "";

			// ratings
			$this->ratings->ViewValue = $this->ratings->CurrentValue;
			$this->ratings->ViewCustomAttributes = "";

			// rating_comment
			$this->rating_comment->ViewValue = $this->rating_comment->CurrentValue;
			$this->rating_comment->ViewCustomAttributes = "";

			// critical
			$this->critical->ViewValue = $this->critical->CurrentValue;
			$this->critical->ViewValue = FormatNumber($this->critical->ViewValue, 0, -2, -2, -2);
			$this->critical->ViewCustomAttributes = "";

			// souce_e
			$this->souce_e->ViewValue = $this->souce_e->CurrentValue;
			$this->souce_e->ViewCustomAttributes = "";

			// shop_code_e
			$this->shop_code_e->ViewValue = $this->shop_code_e->CurrentValue;
			$this->shop_code_e->ViewCustomAttributes = "";

			// Received_Channel_e
			$this->Received_Channel_e->ViewValue = $this->Received_Channel_e->CurrentValue;
			$this->Received_Channel_e->ViewCustomAttributes = "";

			// PayMethod_e
			$this->PayMethod_e->ViewValue = $this->PayMethod_e->CurrentValue;
			$this->PayMethod_e->ViewCustomAttributes = "";

			// Type_e
			$this->Type_e->ViewValue = $this->Type_e->CurrentValue;
			$this->Type_e->ViewCustomAttributes = "";

			// Request_Code_e
			$this->Request_Code_e->ViewValue = $this->Request_Code_e->CurrentValue;
			$this->Request_Code_e->ViewCustomAttributes = "";

			// Status_e
			$this->Status_e->ViewValue = $this->Status_e->CurrentValue;
			$this->Status_e->ViewCustomAttributes = "";

			// PlanType_e
			$this->PlanType_e->ViewValue = $this->PlanType_e->CurrentValue;
			$this->PlanType_e->ViewCustomAttributes = "";

			// Plan_e
			$this->Plan_e->ViewValue = $this->Plan_e->CurrentValue;
			$this->Plan_e->ViewCustomAttributes = "";

			// Isdn_e
			$this->Isdn_e->ViewValue = $this->Isdn_e->CurrentValue;
			$this->Isdn_e->ViewCustomAttributes = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->ViewValue = $this->serial_sim_handset_e->CurrentValue;
			$this->serial_sim_handset_e->ViewCustomAttributes = "";

			// handset_e
			$this->handset_e->ViewValue = $this->handset_e->CurrentValue;
			$this->handset_e->ViewCustomAttributes = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->ViewValue = $this->Connect_Reason_e->CurrentValue;
			$this->Connect_Reason_e->ViewCustomAttributes = "";

			// Price_e
			$this->Price_e->ViewValue = $this->Price_e->CurrentValue;
			$this->Price_e->ViewValue = FormatNumber($this->Price_e->ViewValue, 2, -2, -2, -2);
			$this->Price_e->ViewCustomAttributes = "";

			// Current_Operator_e
			$this->Current_Operator_e->ViewValue = $this->Current_Operator_e->CurrentValue;
			$this->Current_Operator_e->ViewCustomAttributes = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->ViewValue = $this->Current_Plan_Type_e->CurrentValue;
			$this->Current_Plan_Type_e->ViewCustomAttributes = "";

			// Document_Number_e
			$this->Document_Number_e->ViewValue = $this->Document_Number_e->CurrentValue;
			$this->Document_Number_e->ViewCustomAttributes = "";

			// Document_Type_e
			$this->Document_Type_e->ViewValue = $this->Document_Type_e->CurrentValue;
			$this->Document_Type_e->ViewCustomAttributes = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->ViewValue = $this->assignStaffCode_e->CurrentValue;
			$this->assignStaffCode_e->ViewCustomAttributes = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->ViewValue = $this->Delivery_Type_e->CurrentValue;
			$this->Delivery_Type_e->ViewCustomAttributes = "";

			// assignStaffType_e
			$this->assignStaffType_e->ViewValue = $this->assignStaffType_e->CurrentValue;
			$this->assignStaffType_e->ViewCustomAttributes = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->ViewValue = $this->receiveStaffCode_e->CurrentValue;
			$this->receiveStaffCode_e->ViewCustomAttributes = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->ViewValue = $this->receiveStaffType_e->CurrentValue;
			$this->receiveStaffType_e->ViewCustomAttributes = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->ViewValue = $this->connectStaffCode_e->CurrentValue;
			$this->connectStaffCode_e->ViewCustomAttributes = "";

			// connectStaffType_e
			$this->connectStaffType_e->ViewValue = $this->connectStaffType_e->CurrentValue;
			$this->connectStaffType_e->ViewCustomAttributes = "";

			// shopName_e
			$this->shopName_e->ViewValue = $this->shopName_e->CurrentValue;
			$this->shopName_e->ViewCustomAttributes = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->ViewValue = $this->saleOrderCode_e->CurrentValue;
			$this->saleOrderCode_e->ViewCustomAttributes = "";

			// consultantCode_e
			$this->consultantCode_e->ViewValue = $this->consultantCode_e->CurrentValue;
			$this->consultantCode_e->ViewCustomAttributes = "";

			// consultantName_e
			$this->consultantName_e->ViewValue = $this->consultantName_e->CurrentValue;
			$this->consultantName_e->ViewCustomAttributes = "";

			// consultantType_e
			$this->consultantType_e->ViewValue = $this->consultantType_e->CurrentValue;
			$this->consultantType_e->ViewCustomAttributes = "";

			// created_By_e
			$this->created_By_e->ViewValue = $this->created_By_e->CurrentValue;
			$this->created_By_e->ViewCustomAttributes = "";

			// createdBranch_e
			$this->createdBranch_e->ViewValue = $this->createdBranch_e->CurrentValue;
			$this->createdBranch_e->ViewCustomAttributes = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->ViewValue = $this->generated_Code_By_e->CurrentValue;
			$this->generated_Code_By_e->ViewCustomAttributes = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->ViewValue = $this->approve_Paid_By_e->CurrentValue;
			$this->approve_Paid_By_e->ViewCustomAttributes = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->ViewValue = $this->Delivery_Note_e->CurrentValue;
			$this->Delivery_Note_e->ViewCustomAttributes = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->ViewValue = $this->Delivery_Code_e->CurrentValue;
			$this->Delivery_Code_e->ViewCustomAttributes = "";

			// Customer_Note_e
			$this->Customer_Note_e->ViewValue = $this->Customer_Note_e->CurrentValue;
			$this->Customer_Note_e->ViewCustomAttributes = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->ViewValue = $this->saleOrderCreateDate_e->CurrentValue;
			$this->saleOrderCreateDate_e->ViewCustomAttributes = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->ViewValue = $this->saleOrderPayDate_e->CurrentValue;
			$this->saleOrderPayDate_e->ViewCustomAttributes = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->ViewValue = $this->Time_of_Procesing_e->CurrentValue;
			$this->Time_of_Procesing_e->ViewCustomAttributes = "";

			// Time_of_new_e
			$this->Time_of_new_e->ViewValue = $this->Time_of_new_e->CurrentValue;
			$this->Time_of_new_e->ViewCustomAttributes = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->ViewValue = $this->Time_of_Finished_e->CurrentValue;
			$this->Time_of_Finished_e->ViewCustomAttributes = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->ViewValue = $this->KPI_CC_Hour_e->CurrentValue;
			$this->KPI_CC_Hour_e->ViewCustomAttributes = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->ViewValue = $this->KPI_NEW_Hour_e->CurrentValue;
			$this->KPI_NEW_Hour_e->ViewCustomAttributes = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->ViewValue = $this->KPI_PROCESING_Hour_e->CurrentValue;
			$this->KPI_PROCESING_Hour_e->ViewCustomAttributes = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->ViewValue = $this->KPI_ALL_Hour_e->CurrentValue;
			$this->KPI_ALL_Hour_e->ViewCustomAttributes = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->ViewValue = $this->Kpi_Register_Hour_e->CurrentValue;
			$this->Kpi_Register_Hour_e->ViewCustomAttributes = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->ViewValue = $this->Kpi_Bitel_Hour_e->CurrentValue;
			$this->Kpi_Bitel_Hour_e->ViewCustomAttributes = "";

			// AmountGB_e
			$this->AmountGB_e->ViewValue = $this->AmountGB_e->CurrentValue;
			$this->AmountGB_e->ViewCustomAttributes = "";

			// Price_1_e
			$this->Price_1_e->ViewValue = $this->Price_1_e->CurrentValue;
			$this->Price_1_e->ViewCustomAttributes = "";

			// Status_1_e
			$this->Status_1_e->ViewValue = $this->Status_1_e->CurrentValue;
			$this->Status_1_e->ViewCustomAttributes = "";

			// Registered_Date_e
			$this->Registered_Date_e->ViewValue = $this->Registered_Date_e->CurrentValue;
			$this->Registered_Date_e->ViewCustomAttributes = "";

			// Sumary_e
			$this->Sumary_e->ViewValue = $this->Sumary_e->CurrentValue;
			$this->Sumary_e->ViewCustomAttributes = "";

			// Plans_e
			$this->Plans_e->ViewValue = $this->Plans_e->CurrentValue;
			$this->Plans_e->ViewCustomAttributes = "";

			// Isdns_e
			$this->Isdns_e->ViewValue = $this->Isdns_e->CurrentValue;
			$this->Isdns_e->ViewCustomAttributes = "";

			// PlanTypes_e
			$this->PlanTypes_e->ViewValue = $this->PlanTypes_e->CurrentValue;
			$this->PlanTypes_e->ViewCustomAttributes = "";

			// Serials_e
			$this->Serials_e->ViewValue = $this->Serials_e->CurrentValue;
			$this->Serials_e->ViewCustomAttributes = "";

			// Status_2_e
			$this->Status_2_e->ViewValue = $this->Status_2_e->CurrentValue;
			$this->Status_2_e->ViewCustomAttributes = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->ViewValue = $this->Registered_Date_2_e->CurrentValue;
			$this->Registered_Date_2_e->ViewCustomAttributes = "";

			// Summary_2_e
			$this->Summary_2_e->ViewValue = $this->Summary_2_e->CurrentValue;
			$this->Summary_2_e->ViewCustomAttributes = "";

			// serial_2_e
			$this->serial_2_e->ViewValue = $this->serial_2_e->CurrentValue;
			$this->serial_2_e->ViewCustomAttributes = "";

			// HandsetCode_e
			$this->HandsetCode_e->ViewValue = $this->HandsetCode_e->CurrentValue;
			$this->HandsetCode_e->ViewCustomAttributes = "";

			// HandsetName_e
			$this->HandsetName_e->ViewValue = $this->HandsetName_e->CurrentValue;
			$this->HandsetName_e->ViewCustomAttributes = "";

			// Status_3_e
			$this->Status_3_e->ViewValue = $this->Status_3_e->CurrentValue;
			$this->Status_3_e->ViewCustomAttributes = "";

			// Summary_3_e
			$this->Summary_3_e->ViewValue = $this->Summary_3_e->CurrentValue;
			$this->Summary_3_e->ViewCustomAttributes = "";

			// fecha_activa_e
			$this->fecha_activa_e->ViewValue = $this->fecha_activa_e->CurrentValue;
			$this->fecha_activa_e->ViewCustomAttributes = "";

			// mes_activa_e
			$this->mes_activa_e->ViewValue = $this->mes_activa_e->CurrentValue;
			$this->mes_activa_e->ViewCustomAttributes = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->ViewValue = $this->SOURCE_OUT_e->CurrentValue;
			$this->SOURCE_OUT_e->ViewCustomAttributes = "";

			// fecha_crea_e
			$this->fecha_crea_e->ViewValue = $this->fecha_crea_e->CurrentValue;
			$this->fecha_crea_e->ViewCustomAttributes = "";

			// mes_crea_e
			$this->mes_crea_e->ViewValue = $this->mes_crea_e->CurrentValue;
			$this->mes_crea_e->ViewCustomAttributes = "";

			// moto_e
			$this->moto_e->ViewValue = $this->moto_e->CurrentValue;
			$this->moto_e->ViewCustomAttributes = "";

			// customer_id
			$this->customer_id->ViewValue = $this->customer_id->CurrentValue;
			$this->customer_id->ViewValue = FormatNumber($this->customer_id->ViewValue, 0, -2, -2, -2);
			$this->customer_id->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewCustomAttributes = "";

			// branch_e
			$this->branch_e->ViewValue = $this->branch_e->CurrentValue;
			$this->branch_e->ViewCustomAttributes = "";

			// CreatedTime_e
			$this->CreatedTime_e->ViewValue = $this->CreatedTime_e->CurrentValue;
			$this->CreatedTime_e->ViewValue = FormatDateTime($this->CreatedTime_e->ViewValue, 0);
			$this->CreatedTime_e->ViewCustomAttributes = "";

			// Status_n
			$this->Status_n->ViewValue = $this->Status_n->CurrentValue;
			$this->Status_n->ViewValue = FormatNumber($this->Status_n->ViewValue, 0, -2, -2, -2);
			$this->Status_n->ViewCustomAttributes = "";

			// task_id
			$this->task_id->LinkCustomAttributes = "";
			$this->task_id->HrefValue = "";
			$this->task_id->TooltipValue = "";

			// task_description
			$this->task_description->LinkCustomAttributes = "";
			$this->task_description->HrefValue = "";
			$this->task_description->TooltipValue = "";

			// trans_type
			$this->trans_type->LinkCustomAttributes = "";
			$this->trans_type->HrefValue = "";
			$this->trans_type->TooltipValue = "";

			// contact_number
			$this->contact_number->LinkCustomAttributes = "";
			$this->contact_number->HrefValue = "";
			$this->contact_number->TooltipValue = "";

			// email_address
			$this->email_address->LinkCustomAttributes = "";
			$this->email_address->HrefValue = "";
			$this->email_address->TooltipValue = "";

			// customer_name
			$this->customer_name->LinkCustomAttributes = "";
			$this->customer_name->HrefValue = "";
			$this->customer_name->TooltipValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";
			$this->delivery_date->TooltipValue = "";

			// team_id
			$this->team_id->LinkCustomAttributes = "";
			$this->team_id->HrefValue = "";
			$this->team_id->TooltipValue = "";

			// driver_id
			$this->driver_id->LinkCustomAttributes = "";
			$this->driver_id->HrefValue = "";
			$this->driver_id->TooltipValue = "";

			// task_lat
			$this->task_lat->LinkCustomAttributes = "";
			$this->task_lat->HrefValue = "";
			$this->task_lat->TooltipValue = "";

			// task_lng
			$this->task_lng->LinkCustomAttributes = "";
			$this->task_lng->HrefValue = "";
			$this->task_lng->TooltipValue = "";

			// customer_signature
			$this->customer_signature->LinkCustomAttributes = "";
			$this->customer_signature->HrefValue = "";
			$this->customer_signature->TooltipValue = "";

			// date_created
			$this->date_created->LinkCustomAttributes = "";
			$this->date_created->HrefValue = "";
			$this->date_created->TooltipValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";
			$this->date_modified->TooltipValue = "";

			// ip_address
			$this->ip_address->LinkCustomAttributes = "";
			$this->ip_address->HrefValue = "";
			$this->ip_address->TooltipValue = "";

			// auto_assign_type
			$this->auto_assign_type->LinkCustomAttributes = "";
			$this->auto_assign_type->HrefValue = "";
			$this->auto_assign_type->TooltipValue = "";

			// assign_started
			$this->assign_started->LinkCustomAttributes = "";
			$this->assign_started->HrefValue = "";
			$this->assign_started->TooltipValue = "";

			// assignment_status
			$this->assignment_status->LinkCustomAttributes = "";
			$this->assignment_status->HrefValue = "";
			$this->assignment_status->TooltipValue = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->LinkCustomAttributes = "";
			$this->dropoff_contact_name->HrefValue = "";
			$this->dropoff_contact_name->TooltipValue = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->LinkCustomAttributes = "";
			$this->dropoff_contact_number->HrefValue = "";
			$this->dropoff_contact_number->TooltipValue = "";

			// drop_address
			$this->drop_address->LinkCustomAttributes = "";
			$this->drop_address->HrefValue = "";
			$this->drop_address->TooltipValue = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->LinkCustomAttributes = "";
			$this->dropoff_task_lat->HrefValue = "";
			$this->dropoff_task_lat->TooltipValue = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->LinkCustomAttributes = "";
			$this->dropoff_task_lng->HrefValue = "";
			$this->dropoff_task_lng->TooltipValue = "";

			// task_token
			$this->task_token->LinkCustomAttributes = "";
			$this->task_token->HrefValue = "";
			$this->task_token->TooltipValue = "";

			// ratings
			$this->ratings->LinkCustomAttributes = "";
			$this->ratings->HrefValue = "";
			$this->ratings->TooltipValue = "";

			// rating_comment
			$this->rating_comment->LinkCustomAttributes = "";
			$this->rating_comment->HrefValue = "";
			$this->rating_comment->TooltipValue = "";

			// critical
			$this->critical->LinkCustomAttributes = "";
			$this->critical->HrefValue = "";
			$this->critical->TooltipValue = "";

			// souce_e
			$this->souce_e->LinkCustomAttributes = "";
			$this->souce_e->HrefValue = "";
			$this->souce_e->TooltipValue = "";

			// shop_code_e
			$this->shop_code_e->LinkCustomAttributes = "";
			$this->shop_code_e->HrefValue = "";
			$this->shop_code_e->TooltipValue = "";

			// Received_Channel_e
			$this->Received_Channel_e->LinkCustomAttributes = "";
			$this->Received_Channel_e->HrefValue = "";
			$this->Received_Channel_e->TooltipValue = "";

			// PayMethod_e
			$this->PayMethod_e->LinkCustomAttributes = "";
			$this->PayMethod_e->HrefValue = "";
			$this->PayMethod_e->TooltipValue = "";

			// Type_e
			$this->Type_e->LinkCustomAttributes = "";
			$this->Type_e->HrefValue = "";
			$this->Type_e->TooltipValue = "";

			// Request_Code_e
			$this->Request_Code_e->LinkCustomAttributes = "";
			$this->Request_Code_e->HrefValue = "";
			$this->Request_Code_e->TooltipValue = "";

			// Status_e
			$this->Status_e->LinkCustomAttributes = "";
			$this->Status_e->HrefValue = "";
			$this->Status_e->TooltipValue = "";

			// PlanType_e
			$this->PlanType_e->LinkCustomAttributes = "";
			$this->PlanType_e->HrefValue = "";
			$this->PlanType_e->TooltipValue = "";

			// Plan_e
			$this->Plan_e->LinkCustomAttributes = "";
			$this->Plan_e->HrefValue = "";
			$this->Plan_e->TooltipValue = "";

			// Isdn_e
			$this->Isdn_e->LinkCustomAttributes = "";
			$this->Isdn_e->HrefValue = "";
			$this->Isdn_e->TooltipValue = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->LinkCustomAttributes = "";
			$this->serial_sim_handset_e->HrefValue = "";
			$this->serial_sim_handset_e->TooltipValue = "";

			// handset_e
			$this->handset_e->LinkCustomAttributes = "";
			$this->handset_e->HrefValue = "";
			$this->handset_e->TooltipValue = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->LinkCustomAttributes = "";
			$this->Connect_Reason_e->HrefValue = "";
			$this->Connect_Reason_e->TooltipValue = "";

			// Price_e
			$this->Price_e->LinkCustomAttributes = "";
			$this->Price_e->HrefValue = "";
			$this->Price_e->TooltipValue = "";

			// Current_Operator_e
			$this->Current_Operator_e->LinkCustomAttributes = "";
			$this->Current_Operator_e->HrefValue = "";
			$this->Current_Operator_e->TooltipValue = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->LinkCustomAttributes = "";
			$this->Current_Plan_Type_e->HrefValue = "";
			$this->Current_Plan_Type_e->TooltipValue = "";

			// Document_Number_e
			$this->Document_Number_e->LinkCustomAttributes = "";
			$this->Document_Number_e->HrefValue = "";
			$this->Document_Number_e->TooltipValue = "";

			// Document_Type_e
			$this->Document_Type_e->LinkCustomAttributes = "";
			$this->Document_Type_e->HrefValue = "";
			$this->Document_Type_e->TooltipValue = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->LinkCustomAttributes = "";
			$this->assignStaffCode_e->HrefValue = "";
			$this->assignStaffCode_e->TooltipValue = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->LinkCustomAttributes = "";
			$this->Delivery_Type_e->HrefValue = "";
			$this->Delivery_Type_e->TooltipValue = "";

			// assignStaffType_e
			$this->assignStaffType_e->LinkCustomAttributes = "";
			$this->assignStaffType_e->HrefValue = "";
			$this->assignStaffType_e->TooltipValue = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->LinkCustomAttributes = "";
			$this->receiveStaffCode_e->HrefValue = "";
			$this->receiveStaffCode_e->TooltipValue = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->LinkCustomAttributes = "";
			$this->receiveStaffType_e->HrefValue = "";
			$this->receiveStaffType_e->TooltipValue = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->LinkCustomAttributes = "";
			$this->connectStaffCode_e->HrefValue = "";
			$this->connectStaffCode_e->TooltipValue = "";

			// connectStaffType_e
			$this->connectStaffType_e->LinkCustomAttributes = "";
			$this->connectStaffType_e->HrefValue = "";
			$this->connectStaffType_e->TooltipValue = "";

			// shopName_e
			$this->shopName_e->LinkCustomAttributes = "";
			$this->shopName_e->HrefValue = "";
			$this->shopName_e->TooltipValue = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->LinkCustomAttributes = "";
			$this->saleOrderCode_e->HrefValue = "";
			$this->saleOrderCode_e->TooltipValue = "";

			// consultantCode_e
			$this->consultantCode_e->LinkCustomAttributes = "";
			$this->consultantCode_e->HrefValue = "";
			$this->consultantCode_e->TooltipValue = "";

			// consultantName_e
			$this->consultantName_e->LinkCustomAttributes = "";
			$this->consultantName_e->HrefValue = "";
			$this->consultantName_e->TooltipValue = "";

			// consultantType_e
			$this->consultantType_e->LinkCustomAttributes = "";
			$this->consultantType_e->HrefValue = "";
			$this->consultantType_e->TooltipValue = "";

			// created_By_e
			$this->created_By_e->LinkCustomAttributes = "";
			$this->created_By_e->HrefValue = "";
			$this->created_By_e->TooltipValue = "";

			// createdBranch_e
			$this->createdBranch_e->LinkCustomAttributes = "";
			$this->createdBranch_e->HrefValue = "";
			$this->createdBranch_e->TooltipValue = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->LinkCustomAttributes = "";
			$this->generated_Code_By_e->HrefValue = "";
			$this->generated_Code_By_e->TooltipValue = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->LinkCustomAttributes = "";
			$this->approve_Paid_By_e->HrefValue = "";
			$this->approve_Paid_By_e->TooltipValue = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->LinkCustomAttributes = "";
			$this->Delivery_Note_e->HrefValue = "";
			$this->Delivery_Note_e->TooltipValue = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->LinkCustomAttributes = "";
			$this->Delivery_Code_e->HrefValue = "";
			$this->Delivery_Code_e->TooltipValue = "";

			// Customer_Note_e
			$this->Customer_Note_e->LinkCustomAttributes = "";
			$this->Customer_Note_e->HrefValue = "";
			$this->Customer_Note_e->TooltipValue = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->LinkCustomAttributes = "";
			$this->saleOrderCreateDate_e->HrefValue = "";
			$this->saleOrderCreateDate_e->TooltipValue = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->LinkCustomAttributes = "";
			$this->saleOrderPayDate_e->HrefValue = "";
			$this->saleOrderPayDate_e->TooltipValue = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->LinkCustomAttributes = "";
			$this->Time_of_Procesing_e->HrefValue = "";
			$this->Time_of_Procesing_e->TooltipValue = "";

			// Time_of_new_e
			$this->Time_of_new_e->LinkCustomAttributes = "";
			$this->Time_of_new_e->HrefValue = "";
			$this->Time_of_new_e->TooltipValue = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->LinkCustomAttributes = "";
			$this->Time_of_Finished_e->HrefValue = "";
			$this->Time_of_Finished_e->TooltipValue = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->LinkCustomAttributes = "";
			$this->KPI_CC_Hour_e->HrefValue = "";
			$this->KPI_CC_Hour_e->TooltipValue = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->LinkCustomAttributes = "";
			$this->KPI_NEW_Hour_e->HrefValue = "";
			$this->KPI_NEW_Hour_e->TooltipValue = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->LinkCustomAttributes = "";
			$this->KPI_PROCESING_Hour_e->HrefValue = "";
			$this->KPI_PROCESING_Hour_e->TooltipValue = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->LinkCustomAttributes = "";
			$this->KPI_ALL_Hour_e->HrefValue = "";
			$this->KPI_ALL_Hour_e->TooltipValue = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Register_Hour_e->HrefValue = "";
			$this->Kpi_Register_Hour_e->TooltipValue = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Bitel_Hour_e->HrefValue = "";
			$this->Kpi_Bitel_Hour_e->TooltipValue = "";

			// AmountGB_e
			$this->AmountGB_e->LinkCustomAttributes = "";
			$this->AmountGB_e->HrefValue = "";
			$this->AmountGB_e->TooltipValue = "";

			// Price_1_e
			$this->Price_1_e->LinkCustomAttributes = "";
			$this->Price_1_e->HrefValue = "";
			$this->Price_1_e->TooltipValue = "";

			// Status_1_e
			$this->Status_1_e->LinkCustomAttributes = "";
			$this->Status_1_e->HrefValue = "";
			$this->Status_1_e->TooltipValue = "";

			// Registered_Date_e
			$this->Registered_Date_e->LinkCustomAttributes = "";
			$this->Registered_Date_e->HrefValue = "";
			$this->Registered_Date_e->TooltipValue = "";

			// Sumary_e
			$this->Sumary_e->LinkCustomAttributes = "";
			$this->Sumary_e->HrefValue = "";
			$this->Sumary_e->TooltipValue = "";

			// Plans_e
			$this->Plans_e->LinkCustomAttributes = "";
			$this->Plans_e->HrefValue = "";
			$this->Plans_e->TooltipValue = "";

			// Isdns_e
			$this->Isdns_e->LinkCustomAttributes = "";
			$this->Isdns_e->HrefValue = "";
			$this->Isdns_e->TooltipValue = "";

			// PlanTypes_e
			$this->PlanTypes_e->LinkCustomAttributes = "";
			$this->PlanTypes_e->HrefValue = "";
			$this->PlanTypes_e->TooltipValue = "";

			// Serials_e
			$this->Serials_e->LinkCustomAttributes = "";
			$this->Serials_e->HrefValue = "";
			$this->Serials_e->TooltipValue = "";

			// Status_2_e
			$this->Status_2_e->LinkCustomAttributes = "";
			$this->Status_2_e->HrefValue = "";
			$this->Status_2_e->TooltipValue = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->LinkCustomAttributes = "";
			$this->Registered_Date_2_e->HrefValue = "";
			$this->Registered_Date_2_e->TooltipValue = "";

			// Summary_2_e
			$this->Summary_2_e->LinkCustomAttributes = "";
			$this->Summary_2_e->HrefValue = "";
			$this->Summary_2_e->TooltipValue = "";

			// serial_2_e
			$this->serial_2_e->LinkCustomAttributes = "";
			$this->serial_2_e->HrefValue = "";
			$this->serial_2_e->TooltipValue = "";

			// HandsetCode_e
			$this->HandsetCode_e->LinkCustomAttributes = "";
			$this->HandsetCode_e->HrefValue = "";
			$this->HandsetCode_e->TooltipValue = "";

			// HandsetName_e
			$this->HandsetName_e->LinkCustomAttributes = "";
			$this->HandsetName_e->HrefValue = "";
			$this->HandsetName_e->TooltipValue = "";

			// Status_3_e
			$this->Status_3_e->LinkCustomAttributes = "";
			$this->Status_3_e->HrefValue = "";
			$this->Status_3_e->TooltipValue = "";

			// Summary_3_e
			$this->Summary_3_e->LinkCustomAttributes = "";
			$this->Summary_3_e->HrefValue = "";
			$this->Summary_3_e->TooltipValue = "";

			// fecha_activa_e
			$this->fecha_activa_e->LinkCustomAttributes = "";
			$this->fecha_activa_e->HrefValue = "";
			$this->fecha_activa_e->TooltipValue = "";

			// mes_activa_e
			$this->mes_activa_e->LinkCustomAttributes = "";
			$this->mes_activa_e->HrefValue = "";
			$this->mes_activa_e->TooltipValue = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->LinkCustomAttributes = "";
			$this->SOURCE_OUT_e->HrefValue = "";
			$this->SOURCE_OUT_e->TooltipValue = "";

			// fecha_crea_e
			$this->fecha_crea_e->LinkCustomAttributes = "";
			$this->fecha_crea_e->HrefValue = "";
			$this->fecha_crea_e->TooltipValue = "";

			// mes_crea_e
			$this->mes_crea_e->LinkCustomAttributes = "";
			$this->mes_crea_e->HrefValue = "";
			$this->mes_crea_e->TooltipValue = "";

			// moto_e
			$this->moto_e->LinkCustomAttributes = "";
			$this->moto_e->HrefValue = "";
			$this->moto_e->TooltipValue = "";

			// customer_id
			$this->customer_id->LinkCustomAttributes = "";
			$this->customer_id->HrefValue = "";
			$this->customer_id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// branch_e
			$this->branch_e->LinkCustomAttributes = "";
			$this->branch_e->HrefValue = "";
			$this->branch_e->TooltipValue = "";

			// CreatedTime_e
			$this->CreatedTime_e->LinkCustomAttributes = "";
			$this->CreatedTime_e->HrefValue = "";
			$this->CreatedTime_e->TooltipValue = "";

			// Status_n
			$this->Status_n->LinkCustomAttributes = "";
			$this->Status_n->HrefValue = "";
			$this->Status_n->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fkt_driver_tasklistsrch\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>