<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kp_permiso_add extends kp_permiso
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kp_permiso';

	// Page object name
	public $PageObjName = "kp_permiso_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kp_permiso)
		if (!isset($GLOBALS["kp_permiso"]) || get_class($GLOBALS["kp_permiso"]) == PROJECT_NAMESPACE . "kp_permiso") {
			$GLOBALS["kp_permiso"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kp_permiso"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kp_permiso');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kp_permiso;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kp_permiso);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "kp_permisoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idpermiso'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idpermiso->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kp_permisolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idpermiso->Visible = FALSE;
		$this->idperfil->setVisibility();
		$this->idmodulo->setVisibility();
		$this->listarpermiso->setVisibility();
		$this->registrarpermiso->setVisibility();
		$this->editarpermiso->setVisibility();
		$this->eliminarpermiso->setVisibility();
		$this->exportarpermiso->setVisibility();
		$this->importarpermiso->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("idpermiso") !== NULL) {
				$this->idpermiso->setQueryStringValue(Get("idpermiso"));
				$this->setKey("idpermiso", $this->idpermiso->CurrentValue); // Set up key
			} else {
				$this->setKey("idpermiso", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("kp_permisolist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "kp_permisolist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "kp_permisoview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->idpermiso->CurrentValue = NULL;
		$this->idpermiso->OldValue = $this->idpermiso->CurrentValue;
		$this->idperfil->CurrentValue = NULL;
		$this->idperfil->OldValue = $this->idperfil->CurrentValue;
		$this->idmodulo->CurrentValue = NULL;
		$this->idmodulo->OldValue = $this->idmodulo->CurrentValue;
		$this->listarpermiso->CurrentValue = "1";
		$this->registrarpermiso->CurrentValue = "1";
		$this->editarpermiso->CurrentValue = "1";
		$this->eliminarpermiso->CurrentValue = "1";
		$this->exportarpermiso->CurrentValue = "1";
		$this->importarpermiso->CurrentValue = "1";
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'idperfil' first before field var 'x_idperfil'
		$val = $CurrentForm->hasValue("idperfil") ? $CurrentForm->getValue("idperfil") : $CurrentForm->getValue("x_idperfil");
		if (!$this->idperfil->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idperfil->Visible = FALSE; // Disable update for API request
			else
				$this->idperfil->setFormValue($val);
		}

		// Check field name 'idmodulo' first before field var 'x_idmodulo'
		$val = $CurrentForm->hasValue("idmodulo") ? $CurrentForm->getValue("idmodulo") : $CurrentForm->getValue("x_idmodulo");
		if (!$this->idmodulo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idmodulo->Visible = FALSE; // Disable update for API request
			else
				$this->idmodulo->setFormValue($val);
		}

		// Check field name 'listarpermiso' first before field var 'x_listarpermiso'
		$val = $CurrentForm->hasValue("listarpermiso") ? $CurrentForm->getValue("listarpermiso") : $CurrentForm->getValue("x_listarpermiso");
		if (!$this->listarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->listarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->listarpermiso->setFormValue($val);
		}

		// Check field name 'registrarpermiso' first before field var 'x_registrarpermiso'
		$val = $CurrentForm->hasValue("registrarpermiso") ? $CurrentForm->getValue("registrarpermiso") : $CurrentForm->getValue("x_registrarpermiso");
		if (!$this->registrarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->registrarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->registrarpermiso->setFormValue($val);
		}

		// Check field name 'editarpermiso' first before field var 'x_editarpermiso'
		$val = $CurrentForm->hasValue("editarpermiso") ? $CurrentForm->getValue("editarpermiso") : $CurrentForm->getValue("x_editarpermiso");
		if (!$this->editarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->editarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->editarpermiso->setFormValue($val);
		}

		// Check field name 'eliminarpermiso' first before field var 'x_eliminarpermiso'
		$val = $CurrentForm->hasValue("eliminarpermiso") ? $CurrentForm->getValue("eliminarpermiso") : $CurrentForm->getValue("x_eliminarpermiso");
		if (!$this->eliminarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->eliminarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->eliminarpermiso->setFormValue($val);
		}

		// Check field name 'exportarpermiso' first before field var 'x_exportarpermiso'
		$val = $CurrentForm->hasValue("exportarpermiso") ? $CurrentForm->getValue("exportarpermiso") : $CurrentForm->getValue("x_exportarpermiso");
		if (!$this->exportarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->exportarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->exportarpermiso->setFormValue($val);
		}

		// Check field name 'importarpermiso' first before field var 'x_importarpermiso'
		$val = $CurrentForm->hasValue("importarpermiso") ? $CurrentForm->getValue("importarpermiso") : $CurrentForm->getValue("x_importarpermiso");
		if (!$this->importarpermiso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->importarpermiso->Visible = FALSE; // Disable update for API request
			else
				$this->importarpermiso->setFormValue($val);
		}

		// Check field name 'idpermiso' first before field var 'x_idpermiso'
		$val = $CurrentForm->hasValue("idpermiso") ? $CurrentForm->getValue("idpermiso") : $CurrentForm->getValue("x_idpermiso");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->idperfil->CurrentValue = $this->idperfil->FormValue;
		$this->idmodulo->CurrentValue = $this->idmodulo->FormValue;
		$this->listarpermiso->CurrentValue = $this->listarpermiso->FormValue;
		$this->registrarpermiso->CurrentValue = $this->registrarpermiso->FormValue;
		$this->editarpermiso->CurrentValue = $this->editarpermiso->FormValue;
		$this->eliminarpermiso->CurrentValue = $this->eliminarpermiso->FormValue;
		$this->exportarpermiso->CurrentValue = $this->exportarpermiso->FormValue;
		$this->importarpermiso->CurrentValue = $this->importarpermiso->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idpermiso->setDbValue($row['idpermiso']);
		$this->idperfil->setDbValue($row['idperfil']);
		$this->idmodulo->setDbValue($row['idmodulo']);
		$this->listarpermiso->setDbValue($row['listarpermiso']);
		$this->registrarpermiso->setDbValue($row['registrarpermiso']);
		$this->editarpermiso->setDbValue($row['editarpermiso']);
		$this->eliminarpermiso->setDbValue($row['eliminarpermiso']);
		$this->exportarpermiso->setDbValue($row['exportarpermiso']);
		$this->importarpermiso->setDbValue($row['importarpermiso']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['idpermiso'] = $this->idpermiso->CurrentValue;
		$row['idperfil'] = $this->idperfil->CurrentValue;
		$row['idmodulo'] = $this->idmodulo->CurrentValue;
		$row['listarpermiso'] = $this->listarpermiso->CurrentValue;
		$row['registrarpermiso'] = $this->registrarpermiso->CurrentValue;
		$row['editarpermiso'] = $this->editarpermiso->CurrentValue;
		$row['eliminarpermiso'] = $this->eliminarpermiso->CurrentValue;
		$row['exportarpermiso'] = $this->exportarpermiso->CurrentValue;
		$row['importarpermiso'] = $this->importarpermiso->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idpermiso")) != "")
			$this->idpermiso->OldValue = $this->getKey("idpermiso"); // idpermiso
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// idpermiso
		// idperfil
		// idmodulo
		// listarpermiso
		// registrarpermiso
		// editarpermiso
		// eliminarpermiso
		// exportarpermiso
		// importarpermiso

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idpermiso
			$this->idpermiso->ViewValue = $this->idpermiso->CurrentValue;
			$this->idpermiso->ViewCustomAttributes = "";

			// idperfil
			$this->idperfil->ViewValue = $this->idperfil->CurrentValue;
			$this->idperfil->ViewValue = FormatNumber($this->idperfil->ViewValue, 0, -2, -2, -2);
			$this->idperfil->ViewCustomAttributes = "";

			// idmodulo
			$this->idmodulo->ViewValue = $this->idmodulo->CurrentValue;
			$this->idmodulo->ViewCustomAttributes = "";

			// listarpermiso
			$this->listarpermiso->ViewValue = $this->listarpermiso->CurrentValue;
			$this->listarpermiso->ViewCustomAttributes = "";

			// registrarpermiso
			$this->registrarpermiso->ViewValue = $this->registrarpermiso->CurrentValue;
			$this->registrarpermiso->ViewCustomAttributes = "";

			// editarpermiso
			$this->editarpermiso->ViewValue = $this->editarpermiso->CurrentValue;
			$this->editarpermiso->ViewCustomAttributes = "";

			// eliminarpermiso
			$this->eliminarpermiso->ViewValue = $this->eliminarpermiso->CurrentValue;
			$this->eliminarpermiso->ViewCustomAttributes = "";

			// exportarpermiso
			$this->exportarpermiso->ViewValue = $this->exportarpermiso->CurrentValue;
			$this->exportarpermiso->ViewCustomAttributes = "";

			// importarpermiso
			$this->importarpermiso->ViewValue = $this->importarpermiso->CurrentValue;
			$this->importarpermiso->ViewCustomAttributes = "";

			// idperfil
			$this->idperfil->LinkCustomAttributes = "";
			$this->idperfil->HrefValue = "";
			$this->idperfil->TooltipValue = "";

			// idmodulo
			$this->idmodulo->LinkCustomAttributes = "";
			$this->idmodulo->HrefValue = "";
			$this->idmodulo->TooltipValue = "";

			// listarpermiso
			$this->listarpermiso->LinkCustomAttributes = "";
			$this->listarpermiso->HrefValue = "";
			$this->listarpermiso->TooltipValue = "";

			// registrarpermiso
			$this->registrarpermiso->LinkCustomAttributes = "";
			$this->registrarpermiso->HrefValue = "";
			$this->registrarpermiso->TooltipValue = "";

			// editarpermiso
			$this->editarpermiso->LinkCustomAttributes = "";
			$this->editarpermiso->HrefValue = "";
			$this->editarpermiso->TooltipValue = "";

			// eliminarpermiso
			$this->eliminarpermiso->LinkCustomAttributes = "";
			$this->eliminarpermiso->HrefValue = "";
			$this->eliminarpermiso->TooltipValue = "";

			// exportarpermiso
			$this->exportarpermiso->LinkCustomAttributes = "";
			$this->exportarpermiso->HrefValue = "";
			$this->exportarpermiso->TooltipValue = "";

			// importarpermiso
			$this->importarpermiso->LinkCustomAttributes = "";
			$this->importarpermiso->HrefValue = "";
			$this->importarpermiso->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// idperfil
			$this->idperfil->EditAttrs["class"] = "form-control";
			$this->idperfil->EditCustomAttributes = "";
			$this->idperfil->EditValue = HtmlEncode($this->idperfil->CurrentValue);
			$this->idperfil->PlaceHolder = RemoveHtml($this->idperfil->caption());

			// idmodulo
			$this->idmodulo->EditAttrs["class"] = "form-control";
			$this->idmodulo->EditCustomAttributes = "";
			if (!$this->idmodulo->Raw)
				$this->idmodulo->CurrentValue = HtmlDecode($this->idmodulo->CurrentValue);
			$this->idmodulo->EditValue = HtmlEncode($this->idmodulo->CurrentValue);
			$this->idmodulo->PlaceHolder = RemoveHtml($this->idmodulo->caption());

			// listarpermiso
			$this->listarpermiso->EditAttrs["class"] = "form-control";
			$this->listarpermiso->EditCustomAttributes = "";
			if (!$this->listarpermiso->Raw)
				$this->listarpermiso->CurrentValue = HtmlDecode($this->listarpermiso->CurrentValue);
			$this->listarpermiso->EditValue = HtmlEncode($this->listarpermiso->CurrentValue);
			$this->listarpermiso->PlaceHolder = RemoveHtml($this->listarpermiso->caption());

			// registrarpermiso
			$this->registrarpermiso->EditAttrs["class"] = "form-control";
			$this->registrarpermiso->EditCustomAttributes = "";
			if (!$this->registrarpermiso->Raw)
				$this->registrarpermiso->CurrentValue = HtmlDecode($this->registrarpermiso->CurrentValue);
			$this->registrarpermiso->EditValue = HtmlEncode($this->registrarpermiso->CurrentValue);
			$this->registrarpermiso->PlaceHolder = RemoveHtml($this->registrarpermiso->caption());

			// editarpermiso
			$this->editarpermiso->EditAttrs["class"] = "form-control";
			$this->editarpermiso->EditCustomAttributes = "";
			if (!$this->editarpermiso->Raw)
				$this->editarpermiso->CurrentValue = HtmlDecode($this->editarpermiso->CurrentValue);
			$this->editarpermiso->EditValue = HtmlEncode($this->editarpermiso->CurrentValue);
			$this->editarpermiso->PlaceHolder = RemoveHtml($this->editarpermiso->caption());

			// eliminarpermiso
			$this->eliminarpermiso->EditAttrs["class"] = "form-control";
			$this->eliminarpermiso->EditCustomAttributes = "";
			if (!$this->eliminarpermiso->Raw)
				$this->eliminarpermiso->CurrentValue = HtmlDecode($this->eliminarpermiso->CurrentValue);
			$this->eliminarpermiso->EditValue = HtmlEncode($this->eliminarpermiso->CurrentValue);
			$this->eliminarpermiso->PlaceHolder = RemoveHtml($this->eliminarpermiso->caption());

			// exportarpermiso
			$this->exportarpermiso->EditAttrs["class"] = "form-control";
			$this->exportarpermiso->EditCustomAttributes = "";
			if (!$this->exportarpermiso->Raw)
				$this->exportarpermiso->CurrentValue = HtmlDecode($this->exportarpermiso->CurrentValue);
			$this->exportarpermiso->EditValue = HtmlEncode($this->exportarpermiso->CurrentValue);
			$this->exportarpermiso->PlaceHolder = RemoveHtml($this->exportarpermiso->caption());

			// importarpermiso
			$this->importarpermiso->EditAttrs["class"] = "form-control";
			$this->importarpermiso->EditCustomAttributes = "";
			if (!$this->importarpermiso->Raw)
				$this->importarpermiso->CurrentValue = HtmlDecode($this->importarpermiso->CurrentValue);
			$this->importarpermiso->EditValue = HtmlEncode($this->importarpermiso->CurrentValue);
			$this->importarpermiso->PlaceHolder = RemoveHtml($this->importarpermiso->caption());

			// Add refer script
			// idperfil

			$this->idperfil->LinkCustomAttributes = "";
			$this->idperfil->HrefValue = "";

			// idmodulo
			$this->idmodulo->LinkCustomAttributes = "";
			$this->idmodulo->HrefValue = "";

			// listarpermiso
			$this->listarpermiso->LinkCustomAttributes = "";
			$this->listarpermiso->HrefValue = "";

			// registrarpermiso
			$this->registrarpermiso->LinkCustomAttributes = "";
			$this->registrarpermiso->HrefValue = "";

			// editarpermiso
			$this->editarpermiso->LinkCustomAttributes = "";
			$this->editarpermiso->HrefValue = "";

			// eliminarpermiso
			$this->eliminarpermiso->LinkCustomAttributes = "";
			$this->eliminarpermiso->HrefValue = "";

			// exportarpermiso
			$this->exportarpermiso->LinkCustomAttributes = "";
			$this->exportarpermiso->HrefValue = "";

			// importarpermiso
			$this->importarpermiso->LinkCustomAttributes = "";
			$this->importarpermiso->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->idperfil->Required) {
			if (!$this->idperfil->IsDetailKey && $this->idperfil->FormValue != NULL && $this->idperfil->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idperfil->caption(), $this->idperfil->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idperfil->FormValue)) {
			AddMessage($FormError, $this->idperfil->errorMessage());
		}
		if ($this->idmodulo->Required) {
			if (!$this->idmodulo->IsDetailKey && $this->idmodulo->FormValue != NULL && $this->idmodulo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idmodulo->caption(), $this->idmodulo->RequiredErrorMessage));
			}
		}
		if ($this->listarpermiso->Required) {
			if (!$this->listarpermiso->IsDetailKey && $this->listarpermiso->FormValue != NULL && $this->listarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->listarpermiso->caption(), $this->listarpermiso->RequiredErrorMessage));
			}
		}
		if ($this->registrarpermiso->Required) {
			if (!$this->registrarpermiso->IsDetailKey && $this->registrarpermiso->FormValue != NULL && $this->registrarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->registrarpermiso->caption(), $this->registrarpermiso->RequiredErrorMessage));
			}
		}
		if ($this->editarpermiso->Required) {
			if (!$this->editarpermiso->IsDetailKey && $this->editarpermiso->FormValue != NULL && $this->editarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->editarpermiso->caption(), $this->editarpermiso->RequiredErrorMessage));
			}
		}
		if ($this->eliminarpermiso->Required) {
			if (!$this->eliminarpermiso->IsDetailKey && $this->eliminarpermiso->FormValue != NULL && $this->eliminarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->eliminarpermiso->caption(), $this->eliminarpermiso->RequiredErrorMessage));
			}
		}
		if ($this->exportarpermiso->Required) {
			if (!$this->exportarpermiso->IsDetailKey && $this->exportarpermiso->FormValue != NULL && $this->exportarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->exportarpermiso->caption(), $this->exportarpermiso->RequiredErrorMessage));
			}
		}
		if ($this->importarpermiso->Required) {
			if (!$this->importarpermiso->IsDetailKey && $this->importarpermiso->FormValue != NULL && $this->importarpermiso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->importarpermiso->caption(), $this->importarpermiso->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// idperfil
		$this->idperfil->setDbValueDef($rsnew, $this->idperfil->CurrentValue, NULL, FALSE);

		// idmodulo
		$this->idmodulo->setDbValueDef($rsnew, $this->idmodulo->CurrentValue, NULL, FALSE);

		// listarpermiso
		$this->listarpermiso->setDbValueDef($rsnew, $this->listarpermiso->CurrentValue, NULL, strval($this->listarpermiso->CurrentValue) == "");

		// registrarpermiso
		$this->registrarpermiso->setDbValueDef($rsnew, $this->registrarpermiso->CurrentValue, NULL, strval($this->registrarpermiso->CurrentValue) == "");

		// editarpermiso
		$this->editarpermiso->setDbValueDef($rsnew, $this->editarpermiso->CurrentValue, NULL, strval($this->editarpermiso->CurrentValue) == "");

		// eliminarpermiso
		$this->eliminarpermiso->setDbValueDef($rsnew, $this->eliminarpermiso->CurrentValue, NULL, strval($this->eliminarpermiso->CurrentValue) == "");

		// exportarpermiso
		$this->exportarpermiso->setDbValueDef($rsnew, $this->exportarpermiso->CurrentValue, NULL, strval($this->exportarpermiso->CurrentValue) == "");

		// importarpermiso
		$this->importarpermiso->setDbValueDef($rsnew, $this->importarpermiso->CurrentValue, NULL, strval($this->importarpermiso->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kp_permisolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>