<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class interesados_edit extends interesados
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'interesados';

	// Page object name
	public $PageObjName = "interesados_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (interesados)
		if (!isset($GLOBALS["interesados"]) || get_class($GLOBALS["interesados"]) == PROJECT_NAMESPACE . "interesados") {
			$GLOBALS["interesados"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["interesados"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'interesados');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $interesados;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($interesados);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "interesadosview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idinteresado'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idinteresado->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("interesadoslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idinteresado->setVisibility();
		$this->id_usuarioencargado->setVisibility();
		$this->fecha->setVisibility();
		$this->_email->setVisibility();
		$this->cursos->setVisibility();
		$this->categorias->setVisibility();
		$this->nombres->setVisibility();
		$this->apellidos->setVisibility();
		$this->direccion->setVisibility();
		$this->ciudad->setVisibility();
		$this->provincia->setVisibility();
		$this->pais->setVisibility();
		$this->telefono->setVisibility();
		$this->tipo_certificado->setVisibility();
		$this->tipo_pago->setVisibility();
		$this->nombretarjeta->setVisibility();
		$this->numerotarjeta->setVisibility();
		$this->mes->setVisibility();
		$this->anio->setVisibility();
		$this->tipo_tarjeta->setVisibility();
		$this->nombrepaypal->setVisibility();
		$this->montopaypal->setVisibility();
		$this->emailpaypal->setVisibility();
		$this->don->setVisibility();
		$this->tipo_condicion->setVisibility();
		$this->acciones->setVisibility();
		$this->solicitud->setVisibility();
		$this->examen->setVisibility();
		$this->estado->setVisibility();
		$this->tipo->setVisibility();
		$this->codigo_certificado->setVisibility();
		$this->estado_entrega->setVisibility();
		$this->idioma->setVisibility();
		$this->tipo_documento->setVisibility();
		$this->n_documento->setVisibility();
		$this->condicion1->setVisibility();
		$this->condicion2->setVisibility();
		$this->consulta->setVisibility();
		$this->status->setVisibility();
		$this->codlogin->setVisibility();
		$this->idproyecto->setVisibility();
		$this->id_producto->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_idinteresado")) {
				$this->idinteresado->setFormValue($CurrentForm->getValue("x_idinteresado"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("idinteresado") !== NULL) {
				$this->idinteresado->setQueryStringValue(Get("idinteresado"));
				$loadByQuery = TRUE;
			} else {
				$this->idinteresado->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("interesadoslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "interesadoslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'idinteresado' first before field var 'x_idinteresado'
		$val = $CurrentForm->hasValue("idinteresado") ? $CurrentForm->getValue("idinteresado") : $CurrentForm->getValue("x_idinteresado");
		if (!$this->idinteresado->IsDetailKey)
			$this->idinteresado->setFormValue($val);

		// Check field name 'id_usuarioencargado' first before field var 'x_id_usuarioencargado'
		$val = $CurrentForm->hasValue("id_usuarioencargado") ? $CurrentForm->getValue("id_usuarioencargado") : $CurrentForm->getValue("x_id_usuarioencargado");
		if (!$this->id_usuarioencargado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_usuarioencargado->Visible = FALSE; // Disable update for API request
			else
				$this->id_usuarioencargado->setFormValue($val);
		}

		// Check field name 'fecha' first before field var 'x_fecha'
		$val = $CurrentForm->hasValue("fecha") ? $CurrentForm->getValue("fecha") : $CurrentForm->getValue("x_fecha");
		if (!$this->fecha->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha->Visible = FALSE; // Disable update for API request
			else
				$this->fecha->setFormValue($val);
			$this->fecha->CurrentValue = UnFormatDateTime($this->fecha->CurrentValue, 0);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'cursos' first before field var 'x_cursos'
		$val = $CurrentForm->hasValue("cursos") ? $CurrentForm->getValue("cursos") : $CurrentForm->getValue("x_cursos");
		if (!$this->cursos->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cursos->Visible = FALSE; // Disable update for API request
			else
				$this->cursos->setFormValue($val);
		}

		// Check field name 'categorias' first before field var 'x_categorias'
		$val = $CurrentForm->hasValue("categorias") ? $CurrentForm->getValue("categorias") : $CurrentForm->getValue("x_categorias");
		if (!$this->categorias->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->categorias->Visible = FALSE; // Disable update for API request
			else
				$this->categorias->setFormValue($val);
		}

		// Check field name 'nombres' first before field var 'x_nombres'
		$val = $CurrentForm->hasValue("nombres") ? $CurrentForm->getValue("nombres") : $CurrentForm->getValue("x_nombres");
		if (!$this->nombres->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombres->Visible = FALSE; // Disable update for API request
			else
				$this->nombres->setFormValue($val);
		}

		// Check field name 'apellidos' first before field var 'x_apellidos'
		$val = $CurrentForm->hasValue("apellidos") ? $CurrentForm->getValue("apellidos") : $CurrentForm->getValue("x_apellidos");
		if (!$this->apellidos->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->apellidos->Visible = FALSE; // Disable update for API request
			else
				$this->apellidos->setFormValue($val);
		}

		// Check field name 'direccion' first before field var 'x_direccion'
		$val = $CurrentForm->hasValue("direccion") ? $CurrentForm->getValue("direccion") : $CurrentForm->getValue("x_direccion");
		if (!$this->direccion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->direccion->Visible = FALSE; // Disable update for API request
			else
				$this->direccion->setFormValue($val);
		}

		// Check field name 'ciudad' first before field var 'x_ciudad'
		$val = $CurrentForm->hasValue("ciudad") ? $CurrentForm->getValue("ciudad") : $CurrentForm->getValue("x_ciudad");
		if (!$this->ciudad->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ciudad->Visible = FALSE; // Disable update for API request
			else
				$this->ciudad->setFormValue($val);
		}

		// Check field name 'provincia' first before field var 'x_provincia'
		$val = $CurrentForm->hasValue("provincia") ? $CurrentForm->getValue("provincia") : $CurrentForm->getValue("x_provincia");
		if (!$this->provincia->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->provincia->Visible = FALSE; // Disable update for API request
			else
				$this->provincia->setFormValue($val);
		}

		// Check field name 'pais' first before field var 'x_pais'
		$val = $CurrentForm->hasValue("pais") ? $CurrentForm->getValue("pais") : $CurrentForm->getValue("x_pais");
		if (!$this->pais->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pais->Visible = FALSE; // Disable update for API request
			else
				$this->pais->setFormValue($val);
		}

		// Check field name 'telefono' first before field var 'x_telefono'
		$val = $CurrentForm->hasValue("telefono") ? $CurrentForm->getValue("telefono") : $CurrentForm->getValue("x_telefono");
		if (!$this->telefono->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->telefono->Visible = FALSE; // Disable update for API request
			else
				$this->telefono->setFormValue($val);
		}

		// Check field name 'tipo_certificado' first before field var 'x_tipo_certificado'
		$val = $CurrentForm->hasValue("tipo_certificado") ? $CurrentForm->getValue("tipo_certificado") : $CurrentForm->getValue("x_tipo_certificado");
		if (!$this->tipo_certificado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_certificado->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_certificado->setFormValue($val);
		}

		// Check field name 'tipo_pago' first before field var 'x_tipo_pago'
		$val = $CurrentForm->hasValue("tipo_pago") ? $CurrentForm->getValue("tipo_pago") : $CurrentForm->getValue("x_tipo_pago");
		if (!$this->tipo_pago->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_pago->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_pago->setFormValue($val);
		}

		// Check field name 'nombretarjeta' first before field var 'x_nombretarjeta'
		$val = $CurrentForm->hasValue("nombretarjeta") ? $CurrentForm->getValue("nombretarjeta") : $CurrentForm->getValue("x_nombretarjeta");
		if (!$this->nombretarjeta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombretarjeta->Visible = FALSE; // Disable update for API request
			else
				$this->nombretarjeta->setFormValue($val);
		}

		// Check field name 'numerotarjeta' first before field var 'x_numerotarjeta'
		$val = $CurrentForm->hasValue("numerotarjeta") ? $CurrentForm->getValue("numerotarjeta") : $CurrentForm->getValue("x_numerotarjeta");
		if (!$this->numerotarjeta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numerotarjeta->Visible = FALSE; // Disable update for API request
			else
				$this->numerotarjeta->setFormValue($val);
		}

		// Check field name 'mes' first before field var 'x_mes'
		$val = $CurrentForm->hasValue("mes") ? $CurrentForm->getValue("mes") : $CurrentForm->getValue("x_mes");
		if (!$this->mes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mes->Visible = FALSE; // Disable update for API request
			else
				$this->mes->setFormValue($val);
		}

		// Check field name 'anio' first before field var 'x_anio'
		$val = $CurrentForm->hasValue("anio") ? $CurrentForm->getValue("anio") : $CurrentForm->getValue("x_anio");
		if (!$this->anio->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->anio->Visible = FALSE; // Disable update for API request
			else
				$this->anio->setFormValue($val);
		}

		// Check field name 'tipo_tarjeta' first before field var 'x_tipo_tarjeta'
		$val = $CurrentForm->hasValue("tipo_tarjeta") ? $CurrentForm->getValue("tipo_tarjeta") : $CurrentForm->getValue("x_tipo_tarjeta");
		if (!$this->tipo_tarjeta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_tarjeta->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_tarjeta->setFormValue($val);
		}

		// Check field name 'nombrepaypal' first before field var 'x_nombrepaypal'
		$val = $CurrentForm->hasValue("nombrepaypal") ? $CurrentForm->getValue("nombrepaypal") : $CurrentForm->getValue("x_nombrepaypal");
		if (!$this->nombrepaypal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombrepaypal->Visible = FALSE; // Disable update for API request
			else
				$this->nombrepaypal->setFormValue($val);
		}

		// Check field name 'montopaypal' first before field var 'x_montopaypal'
		$val = $CurrentForm->hasValue("montopaypal") ? $CurrentForm->getValue("montopaypal") : $CurrentForm->getValue("x_montopaypal");
		if (!$this->montopaypal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->montopaypal->Visible = FALSE; // Disable update for API request
			else
				$this->montopaypal->setFormValue($val);
		}

		// Check field name 'emailpaypal' first before field var 'x_emailpaypal'
		$val = $CurrentForm->hasValue("emailpaypal") ? $CurrentForm->getValue("emailpaypal") : $CurrentForm->getValue("x_emailpaypal");
		if (!$this->emailpaypal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emailpaypal->Visible = FALSE; // Disable update for API request
			else
				$this->emailpaypal->setFormValue($val);
		}

		// Check field name 'don' first before field var 'x_don'
		$val = $CurrentForm->hasValue("don") ? $CurrentForm->getValue("don") : $CurrentForm->getValue("x_don");
		if (!$this->don->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->don->Visible = FALSE; // Disable update for API request
			else
				$this->don->setFormValue($val);
		}

		// Check field name 'tipo_condicion' first before field var 'x_tipo_condicion'
		$val = $CurrentForm->hasValue("tipo_condicion") ? $CurrentForm->getValue("tipo_condicion") : $CurrentForm->getValue("x_tipo_condicion");
		if (!$this->tipo_condicion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_condicion->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_condicion->setFormValue($val);
		}

		// Check field name 'acciones' first before field var 'x_acciones'
		$val = $CurrentForm->hasValue("acciones") ? $CurrentForm->getValue("acciones") : $CurrentForm->getValue("x_acciones");
		if (!$this->acciones->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->acciones->Visible = FALSE; // Disable update for API request
			else
				$this->acciones->setFormValue($val);
		}

		// Check field name 'solicitud' first before field var 'x_solicitud'
		$val = $CurrentForm->hasValue("solicitud") ? $CurrentForm->getValue("solicitud") : $CurrentForm->getValue("x_solicitud");
		if (!$this->solicitud->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->solicitud->Visible = FALSE; // Disable update for API request
			else
				$this->solicitud->setFormValue($val);
		}

		// Check field name 'examen' first before field var 'x_examen'
		$val = $CurrentForm->hasValue("examen") ? $CurrentForm->getValue("examen") : $CurrentForm->getValue("x_examen");
		if (!$this->examen->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->examen->Visible = FALSE; // Disable update for API request
			else
				$this->examen->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'tipo' first before field var 'x_tipo'
		$val = $CurrentForm->hasValue("tipo") ? $CurrentForm->getValue("tipo") : $CurrentForm->getValue("x_tipo");
		if (!$this->tipo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo->Visible = FALSE; // Disable update for API request
			else
				$this->tipo->setFormValue($val);
		}

		// Check field name 'codigo_certificado' first before field var 'x_codigo_certificado'
		$val = $CurrentForm->hasValue("codigo_certificado") ? $CurrentForm->getValue("codigo_certificado") : $CurrentForm->getValue("x_codigo_certificado");
		if (!$this->codigo_certificado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codigo_certificado->Visible = FALSE; // Disable update for API request
			else
				$this->codigo_certificado->setFormValue($val);
		}

		// Check field name 'estado_entrega' first before field var 'x_estado_entrega'
		$val = $CurrentForm->hasValue("estado_entrega") ? $CurrentForm->getValue("estado_entrega") : $CurrentForm->getValue("x_estado_entrega");
		if (!$this->estado_entrega->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado_entrega->Visible = FALSE; // Disable update for API request
			else
				$this->estado_entrega->setFormValue($val);
		}

		// Check field name 'idioma' first before field var 'x_idioma'
		$val = $CurrentForm->hasValue("idioma") ? $CurrentForm->getValue("idioma") : $CurrentForm->getValue("x_idioma");
		if (!$this->idioma->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idioma->Visible = FALSE; // Disable update for API request
			else
				$this->idioma->setFormValue($val);
		}

		// Check field name 'tipo_documento' first before field var 'x_tipo_documento'
		$val = $CurrentForm->hasValue("tipo_documento") ? $CurrentForm->getValue("tipo_documento") : $CurrentForm->getValue("x_tipo_documento");
		if (!$this->tipo_documento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_documento->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_documento->setFormValue($val);
		}

		// Check field name 'n_documento' first before field var 'x_n_documento'
		$val = $CurrentForm->hasValue("n_documento") ? $CurrentForm->getValue("n_documento") : $CurrentForm->getValue("x_n_documento");
		if (!$this->n_documento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->n_documento->Visible = FALSE; // Disable update for API request
			else
				$this->n_documento->setFormValue($val);
		}

		// Check field name 'condicion1' first before field var 'x_condicion1'
		$val = $CurrentForm->hasValue("condicion1") ? $CurrentForm->getValue("condicion1") : $CurrentForm->getValue("x_condicion1");
		if (!$this->condicion1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->condicion1->Visible = FALSE; // Disable update for API request
			else
				$this->condicion1->setFormValue($val);
		}

		// Check field name 'condicion2' first before field var 'x_condicion2'
		$val = $CurrentForm->hasValue("condicion2") ? $CurrentForm->getValue("condicion2") : $CurrentForm->getValue("x_condicion2");
		if (!$this->condicion2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->condicion2->Visible = FALSE; // Disable update for API request
			else
				$this->condicion2->setFormValue($val);
		}

		// Check field name 'consulta' first before field var 'x_consulta'
		$val = $CurrentForm->hasValue("consulta") ? $CurrentForm->getValue("consulta") : $CurrentForm->getValue("x_consulta");
		if (!$this->consulta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consulta->Visible = FALSE; // Disable update for API request
			else
				$this->consulta->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'codlogin' first before field var 'x_codlogin'
		$val = $CurrentForm->hasValue("codlogin") ? $CurrentForm->getValue("codlogin") : $CurrentForm->getValue("x_codlogin");
		if (!$this->codlogin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codlogin->Visible = FALSE; // Disable update for API request
			else
				$this->codlogin->setFormValue($val);
		}

		// Check field name 'idproyecto' first before field var 'x_idproyecto'
		$val = $CurrentForm->hasValue("idproyecto") ? $CurrentForm->getValue("idproyecto") : $CurrentForm->getValue("x_idproyecto");
		if (!$this->idproyecto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idproyecto->Visible = FALSE; // Disable update for API request
			else
				$this->idproyecto->setFormValue($val);
		}

		// Check field name 'id_producto' first before field var 'x_id_producto'
		$val = $CurrentForm->hasValue("id_producto") ? $CurrentForm->getValue("id_producto") : $CurrentForm->getValue("x_id_producto");
		if (!$this->id_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_producto->Visible = FALSE; // Disable update for API request
			else
				$this->id_producto->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->idinteresado->CurrentValue = $this->idinteresado->FormValue;
		$this->id_usuarioencargado->CurrentValue = $this->id_usuarioencargado->FormValue;
		$this->fecha->CurrentValue = $this->fecha->FormValue;
		$this->fecha->CurrentValue = UnFormatDateTime($this->fecha->CurrentValue, 0);
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->cursos->CurrentValue = $this->cursos->FormValue;
		$this->categorias->CurrentValue = $this->categorias->FormValue;
		$this->nombres->CurrentValue = $this->nombres->FormValue;
		$this->apellidos->CurrentValue = $this->apellidos->FormValue;
		$this->direccion->CurrentValue = $this->direccion->FormValue;
		$this->ciudad->CurrentValue = $this->ciudad->FormValue;
		$this->provincia->CurrentValue = $this->provincia->FormValue;
		$this->pais->CurrentValue = $this->pais->FormValue;
		$this->telefono->CurrentValue = $this->telefono->FormValue;
		$this->tipo_certificado->CurrentValue = $this->tipo_certificado->FormValue;
		$this->tipo_pago->CurrentValue = $this->tipo_pago->FormValue;
		$this->nombretarjeta->CurrentValue = $this->nombretarjeta->FormValue;
		$this->numerotarjeta->CurrentValue = $this->numerotarjeta->FormValue;
		$this->mes->CurrentValue = $this->mes->FormValue;
		$this->anio->CurrentValue = $this->anio->FormValue;
		$this->tipo_tarjeta->CurrentValue = $this->tipo_tarjeta->FormValue;
		$this->nombrepaypal->CurrentValue = $this->nombrepaypal->FormValue;
		$this->montopaypal->CurrentValue = $this->montopaypal->FormValue;
		$this->emailpaypal->CurrentValue = $this->emailpaypal->FormValue;
		$this->don->CurrentValue = $this->don->FormValue;
		$this->tipo_condicion->CurrentValue = $this->tipo_condicion->FormValue;
		$this->acciones->CurrentValue = $this->acciones->FormValue;
		$this->solicitud->CurrentValue = $this->solicitud->FormValue;
		$this->examen->CurrentValue = $this->examen->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->tipo->CurrentValue = $this->tipo->FormValue;
		$this->codigo_certificado->CurrentValue = $this->codigo_certificado->FormValue;
		$this->estado_entrega->CurrentValue = $this->estado_entrega->FormValue;
		$this->idioma->CurrentValue = $this->idioma->FormValue;
		$this->tipo_documento->CurrentValue = $this->tipo_documento->FormValue;
		$this->n_documento->CurrentValue = $this->n_documento->FormValue;
		$this->condicion1->CurrentValue = $this->condicion1->FormValue;
		$this->condicion2->CurrentValue = $this->condicion2->FormValue;
		$this->consulta->CurrentValue = $this->consulta->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->codlogin->CurrentValue = $this->codlogin->FormValue;
		$this->idproyecto->CurrentValue = $this->idproyecto->FormValue;
		$this->id_producto->CurrentValue = $this->id_producto->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idinteresado->setDbValue($row['idinteresado']);
		$this->id_usuarioencargado->setDbValue($row['id_usuarioencargado']);
		$this->fecha->setDbValue($row['fecha']);
		$this->_email->setDbValue($row['email']);
		$this->cursos->setDbValue($row['cursos']);
		$this->categorias->setDbValue($row['categorias']);
		$this->nombres->setDbValue($row['nombres']);
		$this->apellidos->setDbValue($row['apellidos']);
		$this->direccion->setDbValue($row['direccion']);
		$this->ciudad->setDbValue($row['ciudad']);
		$this->provincia->setDbValue($row['provincia']);
		$this->pais->setDbValue($row['pais']);
		$this->telefono->setDbValue($row['telefono']);
		$this->tipo_certificado->setDbValue($row['tipo_certificado']);
		$this->tipo_pago->setDbValue($row['tipo_pago']);
		$this->nombretarjeta->setDbValue($row['nombretarjeta']);
		$this->numerotarjeta->setDbValue($row['numerotarjeta']);
		$this->mes->setDbValue($row['mes']);
		$this->anio->setDbValue($row['anio']);
		$this->tipo_tarjeta->setDbValue($row['tipo_tarjeta']);
		$this->nombrepaypal->setDbValue($row['nombrepaypal']);
		$this->montopaypal->setDbValue($row['montopaypal']);
		$this->emailpaypal->setDbValue($row['emailpaypal']);
		$this->don->setDbValue($row['don']);
		$this->tipo_condicion->setDbValue($row['tipo_condicion']);
		$this->acciones->setDbValue($row['acciones']);
		$this->solicitud->setDbValue($row['solicitud']);
		$this->examen->setDbValue($row['examen']);
		$this->estado->setDbValue($row['estado']);
		$this->tipo->setDbValue($row['tipo']);
		$this->codigo_certificado->setDbValue($row['codigo_certificado']);
		$this->estado_entrega->setDbValue($row['estado_entrega']);
		$this->idioma->setDbValue($row['idioma']);
		$this->tipo_documento->setDbValue($row['tipo_documento']);
		$this->n_documento->setDbValue($row['n_documento']);
		$this->condicion1->setDbValue($row['condicion1']);
		$this->condicion2->setDbValue($row['condicion2']);
		$this->consulta->setDbValue($row['consulta']);
		$this->status->setDbValue($row['status']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idproyecto->setDbValue($row['idproyecto']);
		$this->id_producto->setDbValue($row['id_producto']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idinteresado'] = NULL;
		$row['id_usuarioencargado'] = NULL;
		$row['fecha'] = NULL;
		$row['email'] = NULL;
		$row['cursos'] = NULL;
		$row['categorias'] = NULL;
		$row['nombres'] = NULL;
		$row['apellidos'] = NULL;
		$row['direccion'] = NULL;
		$row['ciudad'] = NULL;
		$row['provincia'] = NULL;
		$row['pais'] = NULL;
		$row['telefono'] = NULL;
		$row['tipo_certificado'] = NULL;
		$row['tipo_pago'] = NULL;
		$row['nombretarjeta'] = NULL;
		$row['numerotarjeta'] = NULL;
		$row['mes'] = NULL;
		$row['anio'] = NULL;
		$row['tipo_tarjeta'] = NULL;
		$row['nombrepaypal'] = NULL;
		$row['montopaypal'] = NULL;
		$row['emailpaypal'] = NULL;
		$row['don'] = NULL;
		$row['tipo_condicion'] = NULL;
		$row['acciones'] = NULL;
		$row['solicitud'] = NULL;
		$row['examen'] = NULL;
		$row['estado'] = NULL;
		$row['tipo'] = NULL;
		$row['codigo_certificado'] = NULL;
		$row['estado_entrega'] = NULL;
		$row['idioma'] = NULL;
		$row['tipo_documento'] = NULL;
		$row['n_documento'] = NULL;
		$row['condicion1'] = NULL;
		$row['condicion2'] = NULL;
		$row['consulta'] = NULL;
		$row['status'] = NULL;
		$row['codlogin'] = NULL;
		$row['idproyecto'] = NULL;
		$row['id_producto'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idinteresado")) != "")
			$this->idinteresado->OldValue = $this->getKey("idinteresado"); // idinteresado
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->examen->FormValue == $this->examen->CurrentValue && is_numeric(ConvertToFloatString($this->examen->CurrentValue)))
			$this->examen->CurrentValue = ConvertToFloatString($this->examen->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idinteresado
		// id_usuarioencargado
		// fecha
		// email
		// cursos
		// categorias
		// nombres
		// apellidos
		// direccion
		// ciudad
		// provincia
		// pais
		// telefono
		// tipo_certificado
		// tipo_pago
		// nombretarjeta
		// numerotarjeta
		// mes
		// anio
		// tipo_tarjeta
		// nombrepaypal
		// montopaypal
		// emailpaypal
		// don
		// tipo_condicion
		// acciones
		// solicitud
		// examen
		// estado
		// tipo
		// codigo_certificado
		// estado_entrega
		// idioma
		// tipo_documento
		// n_documento
		// condicion1
		// condicion2
		// consulta
		// status
		// codlogin
		// idproyecto
		// id_producto

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idinteresado
			$this->idinteresado->ViewValue = $this->idinteresado->CurrentValue;
			$this->idinteresado->ViewCustomAttributes = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->ViewValue = $this->id_usuarioencargado->CurrentValue;
			$this->id_usuarioencargado->ViewValue = FormatNumber($this->id_usuarioencargado->ViewValue, 0, -2, -2, -2);
			$this->id_usuarioencargado->ViewCustomAttributes = "";

			// fecha
			$this->fecha->ViewValue = $this->fecha->CurrentValue;
			$this->fecha->ViewValue = FormatDateTime($this->fecha->ViewValue, 0);
			$this->fecha->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// cursos
			$this->cursos->ViewValue = $this->cursos->CurrentValue;
			$this->cursos->ViewValue = FormatNumber($this->cursos->ViewValue, 0, -2, -2, -2);
			$this->cursos->ViewCustomAttributes = "";

			// categorias
			$this->categorias->ViewValue = $this->categorias->CurrentValue;
			$this->categorias->ViewValue = FormatNumber($this->categorias->ViewValue, 0, -2, -2, -2);
			$this->categorias->ViewCustomAttributes = "";

			// nombres
			$this->nombres->ViewValue = $this->nombres->CurrentValue;
			$this->nombres->ViewCustomAttributes = "";

			// apellidos
			$this->apellidos->ViewValue = $this->apellidos->CurrentValue;
			$this->apellidos->ViewCustomAttributes = "";

			// direccion
			$this->direccion->ViewValue = $this->direccion->CurrentValue;
			$this->direccion->ViewCustomAttributes = "";

			// ciudad
			$this->ciudad->ViewValue = $this->ciudad->CurrentValue;
			$this->ciudad->ViewCustomAttributes = "";

			// provincia
			$this->provincia->ViewValue = $this->provincia->CurrentValue;
			$this->provincia->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// telefono
			$this->telefono->ViewValue = $this->telefono->CurrentValue;
			$this->telefono->ViewCustomAttributes = "";

			// tipo_certificado
			$this->tipo_certificado->ViewValue = $this->tipo_certificado->CurrentValue;
			$this->tipo_certificado->ViewValue = FormatNumber($this->tipo_certificado->ViewValue, 0, -2, -2, -2);
			$this->tipo_certificado->ViewCustomAttributes = "";

			// tipo_pago
			$this->tipo_pago->ViewValue = $this->tipo_pago->CurrentValue;
			$this->tipo_pago->ViewValue = FormatNumber($this->tipo_pago->ViewValue, 0, -2, -2, -2);
			$this->tipo_pago->ViewCustomAttributes = "";

			// nombretarjeta
			$this->nombretarjeta->ViewValue = $this->nombretarjeta->CurrentValue;
			$this->nombretarjeta->ViewCustomAttributes = "";

			// numerotarjeta
			$this->numerotarjeta->ViewValue = $this->numerotarjeta->CurrentValue;
			$this->numerotarjeta->ViewCustomAttributes = "";

			// mes
			$this->mes->ViewValue = $this->mes->CurrentValue;
			$this->mes->ViewCustomAttributes = "";

			// anio
			$this->anio->ViewValue = $this->anio->CurrentValue;
			$this->anio->ViewCustomAttributes = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->ViewValue = $this->tipo_tarjeta->CurrentValue;
			$this->tipo_tarjeta->ViewCustomAttributes = "";

			// nombrepaypal
			$this->nombrepaypal->ViewValue = $this->nombrepaypal->CurrentValue;
			$this->nombrepaypal->ViewCustomAttributes = "";

			// montopaypal
			$this->montopaypal->ViewValue = $this->montopaypal->CurrentValue;
			$this->montopaypal->ViewCustomAttributes = "";

			// emailpaypal
			$this->emailpaypal->ViewValue = $this->emailpaypal->CurrentValue;
			$this->emailpaypal->ViewCustomAttributes = "";

			// don
			$this->don->ViewValue = $this->don->CurrentValue;
			$this->don->ViewCustomAttributes = "";

			// tipo_condicion
			$this->tipo_condicion->ViewValue = $this->tipo_condicion->CurrentValue;
			$this->tipo_condicion->ViewValue = FormatNumber($this->tipo_condicion->ViewValue, 0, -2, -2, -2);
			$this->tipo_condicion->ViewCustomAttributes = "";

			// acciones
			$this->acciones->ViewValue = $this->acciones->CurrentValue;
			$this->acciones->ViewValue = FormatNumber($this->acciones->ViewValue, 0, -2, -2, -2);
			$this->acciones->ViewCustomAttributes = "";

			// solicitud
			$this->solicitud->ViewValue = $this->solicitud->CurrentValue;
			$this->solicitud->ViewValue = FormatNumber($this->solicitud->ViewValue, 0, -2, -2, -2);
			$this->solicitud->ViewCustomAttributes = "";

			// examen
			$this->examen->ViewValue = $this->examen->CurrentValue;
			$this->examen->ViewValue = FormatNumber($this->examen->ViewValue, 2, -2, -2, -2);
			$this->examen->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// tipo
			$this->tipo->ViewValue = $this->tipo->CurrentValue;
			$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
			$this->tipo->ViewCustomAttributes = "";

			// codigo_certificado
			$this->codigo_certificado->ViewValue = $this->codigo_certificado->CurrentValue;
			$this->codigo_certificado->ViewCustomAttributes = "";

			// estado_entrega
			$this->estado_entrega->ViewValue = $this->estado_entrega->CurrentValue;
			$this->estado_entrega->ViewValue = FormatNumber($this->estado_entrega->ViewValue, 0, -2, -2, -2);
			$this->estado_entrega->ViewCustomAttributes = "";

			// idioma
			$this->idioma->ViewValue = $this->idioma->CurrentValue;
			$this->idioma->ViewValue = FormatNumber($this->idioma->ViewValue, 0, -2, -2, -2);
			$this->idioma->ViewCustomAttributes = "";

			// tipo_documento
			$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
			$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
			$this->tipo_documento->ViewCustomAttributes = "";

			// n_documento
			$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
			$this->n_documento->ViewValue = FormatNumber($this->n_documento->ViewValue, 0, -2, -2, -2);
			$this->n_documento->ViewCustomAttributes = "";

			// condicion1
			$this->condicion1->ViewValue = $this->condicion1->CurrentValue;
			$this->condicion1->ViewValue = FormatNumber($this->condicion1->ViewValue, 0, -2, -2, -2);
			$this->condicion1->ViewCustomAttributes = "";

			// condicion2
			$this->condicion2->ViewValue = $this->condicion2->CurrentValue;
			$this->condicion2->ViewValue = FormatNumber($this->condicion2->ViewValue, 0, -2, -2, -2);
			$this->condicion2->ViewCustomAttributes = "";

			// consulta
			$this->consulta->ViewValue = $this->consulta->CurrentValue;
			$this->consulta->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idproyecto
			$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
			$this->idproyecto->ViewValue = FormatNumber($this->idproyecto->ViewValue, 0, -2, -2, -2);
			$this->idproyecto->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
			$this->id_producto->ViewCustomAttributes = "";

			// idinteresado
			$this->idinteresado->LinkCustomAttributes = "";
			$this->idinteresado->HrefValue = "";
			$this->idinteresado->TooltipValue = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->LinkCustomAttributes = "";
			$this->id_usuarioencargado->HrefValue = "";
			$this->id_usuarioencargado->TooltipValue = "";

			// fecha
			$this->fecha->LinkCustomAttributes = "";
			$this->fecha->HrefValue = "";
			$this->fecha->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// cursos
			$this->cursos->LinkCustomAttributes = "";
			$this->cursos->HrefValue = "";
			$this->cursos->TooltipValue = "";

			// categorias
			$this->categorias->LinkCustomAttributes = "";
			$this->categorias->HrefValue = "";
			$this->categorias->TooltipValue = "";

			// nombres
			$this->nombres->LinkCustomAttributes = "";
			$this->nombres->HrefValue = "";
			$this->nombres->TooltipValue = "";

			// apellidos
			$this->apellidos->LinkCustomAttributes = "";
			$this->apellidos->HrefValue = "";
			$this->apellidos->TooltipValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";
			$this->direccion->TooltipValue = "";

			// ciudad
			$this->ciudad->LinkCustomAttributes = "";
			$this->ciudad->HrefValue = "";
			$this->ciudad->TooltipValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";
			$this->provincia->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// telefono
			$this->telefono->LinkCustomAttributes = "";
			$this->telefono->HrefValue = "";
			$this->telefono->TooltipValue = "";

			// tipo_certificado
			$this->tipo_certificado->LinkCustomAttributes = "";
			$this->tipo_certificado->HrefValue = "";
			$this->tipo_certificado->TooltipValue = "";

			// tipo_pago
			$this->tipo_pago->LinkCustomAttributes = "";
			$this->tipo_pago->HrefValue = "";
			$this->tipo_pago->TooltipValue = "";

			// nombretarjeta
			$this->nombretarjeta->LinkCustomAttributes = "";
			$this->nombretarjeta->HrefValue = "";
			$this->nombretarjeta->TooltipValue = "";

			// numerotarjeta
			$this->numerotarjeta->LinkCustomAttributes = "";
			$this->numerotarjeta->HrefValue = "";
			$this->numerotarjeta->TooltipValue = "";

			// mes
			$this->mes->LinkCustomAttributes = "";
			$this->mes->HrefValue = "";
			$this->mes->TooltipValue = "";

			// anio
			$this->anio->LinkCustomAttributes = "";
			$this->anio->HrefValue = "";
			$this->anio->TooltipValue = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->LinkCustomAttributes = "";
			$this->tipo_tarjeta->HrefValue = "";
			$this->tipo_tarjeta->TooltipValue = "";

			// nombrepaypal
			$this->nombrepaypal->LinkCustomAttributes = "";
			$this->nombrepaypal->HrefValue = "";
			$this->nombrepaypal->TooltipValue = "";

			// montopaypal
			$this->montopaypal->LinkCustomAttributes = "";
			$this->montopaypal->HrefValue = "";
			$this->montopaypal->TooltipValue = "";

			// emailpaypal
			$this->emailpaypal->LinkCustomAttributes = "";
			$this->emailpaypal->HrefValue = "";
			$this->emailpaypal->TooltipValue = "";

			// don
			$this->don->LinkCustomAttributes = "";
			$this->don->HrefValue = "";
			$this->don->TooltipValue = "";

			// tipo_condicion
			$this->tipo_condicion->LinkCustomAttributes = "";
			$this->tipo_condicion->HrefValue = "";
			$this->tipo_condicion->TooltipValue = "";

			// acciones
			$this->acciones->LinkCustomAttributes = "";
			$this->acciones->HrefValue = "";
			$this->acciones->TooltipValue = "";

			// solicitud
			$this->solicitud->LinkCustomAttributes = "";
			$this->solicitud->HrefValue = "";
			$this->solicitud->TooltipValue = "";

			// examen
			$this->examen->LinkCustomAttributes = "";
			$this->examen->HrefValue = "";
			$this->examen->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";
			$this->tipo->TooltipValue = "";

			// codigo_certificado
			$this->codigo_certificado->LinkCustomAttributes = "";
			$this->codigo_certificado->HrefValue = "";
			$this->codigo_certificado->TooltipValue = "";

			// estado_entrega
			$this->estado_entrega->LinkCustomAttributes = "";
			$this->estado_entrega->HrefValue = "";
			$this->estado_entrega->TooltipValue = "";

			// idioma
			$this->idioma->LinkCustomAttributes = "";
			$this->idioma->HrefValue = "";
			$this->idioma->TooltipValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";
			$this->tipo_documento->TooltipValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";
			$this->n_documento->TooltipValue = "";

			// condicion1
			$this->condicion1->LinkCustomAttributes = "";
			$this->condicion1->HrefValue = "";
			$this->condicion1->TooltipValue = "";

			// condicion2
			$this->condicion2->LinkCustomAttributes = "";
			$this->condicion2->HrefValue = "";
			$this->condicion2->TooltipValue = "";

			// consulta
			$this->consulta->LinkCustomAttributes = "";
			$this->consulta->HrefValue = "";
			$this->consulta->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idproyecto
			$this->idproyecto->LinkCustomAttributes = "";
			$this->idproyecto->HrefValue = "";
			$this->idproyecto->TooltipValue = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// idinteresado
			$this->idinteresado->EditAttrs["class"] = "form-control";
			$this->idinteresado->EditCustomAttributes = "";
			$this->idinteresado->EditValue = $this->idinteresado->CurrentValue;
			$this->idinteresado->ViewCustomAttributes = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->EditAttrs["class"] = "form-control";
			$this->id_usuarioencargado->EditCustomAttributes = "";
			$this->id_usuarioencargado->EditValue = HtmlEncode($this->id_usuarioencargado->CurrentValue);
			$this->id_usuarioencargado->PlaceHolder = RemoveHtml($this->id_usuarioencargado->caption());

			// fecha
			$this->fecha->EditAttrs["class"] = "form-control";
			$this->fecha->EditCustomAttributes = "";
			$this->fecha->EditValue = HtmlEncode(FormatDateTime($this->fecha->CurrentValue, 8));
			$this->fecha->PlaceHolder = RemoveHtml($this->fecha->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (!$this->_email->Raw)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// cursos
			$this->cursos->EditAttrs["class"] = "form-control";
			$this->cursos->EditCustomAttributes = "";
			$this->cursos->EditValue = HtmlEncode($this->cursos->CurrentValue);
			$this->cursos->PlaceHolder = RemoveHtml($this->cursos->caption());

			// categorias
			$this->categorias->EditAttrs["class"] = "form-control";
			$this->categorias->EditCustomAttributes = "";
			$this->categorias->EditValue = HtmlEncode($this->categorias->CurrentValue);
			$this->categorias->PlaceHolder = RemoveHtml($this->categorias->caption());

			// nombres
			$this->nombres->EditAttrs["class"] = "form-control";
			$this->nombres->EditCustomAttributes = "";
			if (!$this->nombres->Raw)
				$this->nombres->CurrentValue = HtmlDecode($this->nombres->CurrentValue);
			$this->nombres->EditValue = HtmlEncode($this->nombres->CurrentValue);
			$this->nombres->PlaceHolder = RemoveHtml($this->nombres->caption());

			// apellidos
			$this->apellidos->EditAttrs["class"] = "form-control";
			$this->apellidos->EditCustomAttributes = "";
			if (!$this->apellidos->Raw)
				$this->apellidos->CurrentValue = HtmlDecode($this->apellidos->CurrentValue);
			$this->apellidos->EditValue = HtmlEncode($this->apellidos->CurrentValue);
			$this->apellidos->PlaceHolder = RemoveHtml($this->apellidos->caption());

			// direccion
			$this->direccion->EditAttrs["class"] = "form-control";
			$this->direccion->EditCustomAttributes = "";
			if (!$this->direccion->Raw)
				$this->direccion->CurrentValue = HtmlDecode($this->direccion->CurrentValue);
			$this->direccion->EditValue = HtmlEncode($this->direccion->CurrentValue);
			$this->direccion->PlaceHolder = RemoveHtml($this->direccion->caption());

			// ciudad
			$this->ciudad->EditAttrs["class"] = "form-control";
			$this->ciudad->EditCustomAttributes = "";
			if (!$this->ciudad->Raw)
				$this->ciudad->CurrentValue = HtmlDecode($this->ciudad->CurrentValue);
			$this->ciudad->EditValue = HtmlEncode($this->ciudad->CurrentValue);
			$this->ciudad->PlaceHolder = RemoveHtml($this->ciudad->caption());

			// provincia
			$this->provincia->EditAttrs["class"] = "form-control";
			$this->provincia->EditCustomAttributes = "";
			if (!$this->provincia->Raw)
				$this->provincia->CurrentValue = HtmlDecode($this->provincia->CurrentValue);
			$this->provincia->EditValue = HtmlEncode($this->provincia->CurrentValue);
			$this->provincia->PlaceHolder = RemoveHtml($this->provincia->caption());

			// pais
			$this->pais->EditAttrs["class"] = "form-control";
			$this->pais->EditCustomAttributes = "";
			if (!$this->pais->Raw)
				$this->pais->CurrentValue = HtmlDecode($this->pais->CurrentValue);
			$this->pais->EditValue = HtmlEncode($this->pais->CurrentValue);
			$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

			// telefono
			$this->telefono->EditAttrs["class"] = "form-control";
			$this->telefono->EditCustomAttributes = "";
			if (!$this->telefono->Raw)
				$this->telefono->CurrentValue = HtmlDecode($this->telefono->CurrentValue);
			$this->telefono->EditValue = HtmlEncode($this->telefono->CurrentValue);
			$this->telefono->PlaceHolder = RemoveHtml($this->telefono->caption());

			// tipo_certificado
			$this->tipo_certificado->EditAttrs["class"] = "form-control";
			$this->tipo_certificado->EditCustomAttributes = "";
			$this->tipo_certificado->EditValue = HtmlEncode($this->tipo_certificado->CurrentValue);
			$this->tipo_certificado->PlaceHolder = RemoveHtml($this->tipo_certificado->caption());

			// tipo_pago
			$this->tipo_pago->EditAttrs["class"] = "form-control";
			$this->tipo_pago->EditCustomAttributes = "";
			$this->tipo_pago->EditValue = HtmlEncode($this->tipo_pago->CurrentValue);
			$this->tipo_pago->PlaceHolder = RemoveHtml($this->tipo_pago->caption());

			// nombretarjeta
			$this->nombretarjeta->EditAttrs["class"] = "form-control";
			$this->nombretarjeta->EditCustomAttributes = "";
			if (!$this->nombretarjeta->Raw)
				$this->nombretarjeta->CurrentValue = HtmlDecode($this->nombretarjeta->CurrentValue);
			$this->nombretarjeta->EditValue = HtmlEncode($this->nombretarjeta->CurrentValue);
			$this->nombretarjeta->PlaceHolder = RemoveHtml($this->nombretarjeta->caption());

			// numerotarjeta
			$this->numerotarjeta->EditAttrs["class"] = "form-control";
			$this->numerotarjeta->EditCustomAttributes = "";
			if (!$this->numerotarjeta->Raw)
				$this->numerotarjeta->CurrentValue = HtmlDecode($this->numerotarjeta->CurrentValue);
			$this->numerotarjeta->EditValue = HtmlEncode($this->numerotarjeta->CurrentValue);
			$this->numerotarjeta->PlaceHolder = RemoveHtml($this->numerotarjeta->caption());

			// mes
			$this->mes->EditAttrs["class"] = "form-control";
			$this->mes->EditCustomAttributes = "";
			if (!$this->mes->Raw)
				$this->mes->CurrentValue = HtmlDecode($this->mes->CurrentValue);
			$this->mes->EditValue = HtmlEncode($this->mes->CurrentValue);
			$this->mes->PlaceHolder = RemoveHtml($this->mes->caption());

			// anio
			$this->anio->EditAttrs["class"] = "form-control";
			$this->anio->EditCustomAttributes = "";
			if (!$this->anio->Raw)
				$this->anio->CurrentValue = HtmlDecode($this->anio->CurrentValue);
			$this->anio->EditValue = HtmlEncode($this->anio->CurrentValue);
			$this->anio->PlaceHolder = RemoveHtml($this->anio->caption());

			// tipo_tarjeta
			$this->tipo_tarjeta->EditAttrs["class"] = "form-control";
			$this->tipo_tarjeta->EditCustomAttributes = "";
			if (!$this->tipo_tarjeta->Raw)
				$this->tipo_tarjeta->CurrentValue = HtmlDecode($this->tipo_tarjeta->CurrentValue);
			$this->tipo_tarjeta->EditValue = HtmlEncode($this->tipo_tarjeta->CurrentValue);
			$this->tipo_tarjeta->PlaceHolder = RemoveHtml($this->tipo_tarjeta->caption());

			// nombrepaypal
			$this->nombrepaypal->EditAttrs["class"] = "form-control";
			$this->nombrepaypal->EditCustomAttributes = "";
			if (!$this->nombrepaypal->Raw)
				$this->nombrepaypal->CurrentValue = HtmlDecode($this->nombrepaypal->CurrentValue);
			$this->nombrepaypal->EditValue = HtmlEncode($this->nombrepaypal->CurrentValue);
			$this->nombrepaypal->PlaceHolder = RemoveHtml($this->nombrepaypal->caption());

			// montopaypal
			$this->montopaypal->EditAttrs["class"] = "form-control";
			$this->montopaypal->EditCustomAttributes = "";
			if (!$this->montopaypal->Raw)
				$this->montopaypal->CurrentValue = HtmlDecode($this->montopaypal->CurrentValue);
			$this->montopaypal->EditValue = HtmlEncode($this->montopaypal->CurrentValue);
			$this->montopaypal->PlaceHolder = RemoveHtml($this->montopaypal->caption());

			// emailpaypal
			$this->emailpaypal->EditAttrs["class"] = "form-control";
			$this->emailpaypal->EditCustomAttributes = "";
			if (!$this->emailpaypal->Raw)
				$this->emailpaypal->CurrentValue = HtmlDecode($this->emailpaypal->CurrentValue);
			$this->emailpaypal->EditValue = HtmlEncode($this->emailpaypal->CurrentValue);
			$this->emailpaypal->PlaceHolder = RemoveHtml($this->emailpaypal->caption());

			// don
			$this->don->EditAttrs["class"] = "form-control";
			$this->don->EditCustomAttributes = "";
			if (!$this->don->Raw)
				$this->don->CurrentValue = HtmlDecode($this->don->CurrentValue);
			$this->don->EditValue = HtmlEncode($this->don->CurrentValue);
			$this->don->PlaceHolder = RemoveHtml($this->don->caption());

			// tipo_condicion
			$this->tipo_condicion->EditAttrs["class"] = "form-control";
			$this->tipo_condicion->EditCustomAttributes = "";
			$this->tipo_condicion->EditValue = HtmlEncode($this->tipo_condicion->CurrentValue);
			$this->tipo_condicion->PlaceHolder = RemoveHtml($this->tipo_condicion->caption());

			// acciones
			$this->acciones->EditAttrs["class"] = "form-control";
			$this->acciones->EditCustomAttributes = "";
			$this->acciones->EditValue = HtmlEncode($this->acciones->CurrentValue);
			$this->acciones->PlaceHolder = RemoveHtml($this->acciones->caption());

			// solicitud
			$this->solicitud->EditAttrs["class"] = "form-control";
			$this->solicitud->EditCustomAttributes = "";
			$this->solicitud->EditValue = HtmlEncode($this->solicitud->CurrentValue);
			$this->solicitud->PlaceHolder = RemoveHtml($this->solicitud->caption());

			// examen
			$this->examen->EditAttrs["class"] = "form-control";
			$this->examen->EditCustomAttributes = "";
			$this->examen->EditValue = HtmlEncode($this->examen->CurrentValue);
			$this->examen->PlaceHolder = RemoveHtml($this->examen->caption());
			if (strval($this->examen->EditValue) != "" && is_numeric($this->examen->EditValue))
				$this->examen->EditValue = FormatNumber($this->examen->EditValue, -2, -2, -2, -2);
			

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// tipo
			$this->tipo->EditAttrs["class"] = "form-control";
			$this->tipo->EditCustomAttributes = "";
			$this->tipo->EditValue = HtmlEncode($this->tipo->CurrentValue);
			$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

			// codigo_certificado
			$this->codigo_certificado->EditAttrs["class"] = "form-control";
			$this->codigo_certificado->EditCustomAttributes = "";
			if (!$this->codigo_certificado->Raw)
				$this->codigo_certificado->CurrentValue = HtmlDecode($this->codigo_certificado->CurrentValue);
			$this->codigo_certificado->EditValue = HtmlEncode($this->codigo_certificado->CurrentValue);
			$this->codigo_certificado->PlaceHolder = RemoveHtml($this->codigo_certificado->caption());

			// estado_entrega
			$this->estado_entrega->EditAttrs["class"] = "form-control";
			$this->estado_entrega->EditCustomAttributes = "";
			$this->estado_entrega->EditValue = HtmlEncode($this->estado_entrega->CurrentValue);
			$this->estado_entrega->PlaceHolder = RemoveHtml($this->estado_entrega->caption());

			// idioma
			$this->idioma->EditAttrs["class"] = "form-control";
			$this->idioma->EditCustomAttributes = "";
			$this->idioma->EditValue = HtmlEncode($this->idioma->CurrentValue);
			$this->idioma->PlaceHolder = RemoveHtml($this->idioma->caption());

			// tipo_documento
			$this->tipo_documento->EditAttrs["class"] = "form-control";
			$this->tipo_documento->EditCustomAttributes = "";
			$this->tipo_documento->EditValue = HtmlEncode($this->tipo_documento->CurrentValue);
			$this->tipo_documento->PlaceHolder = RemoveHtml($this->tipo_documento->caption());

			// n_documento
			$this->n_documento->EditAttrs["class"] = "form-control";
			$this->n_documento->EditCustomAttributes = "";
			$this->n_documento->EditValue = HtmlEncode($this->n_documento->CurrentValue);
			$this->n_documento->PlaceHolder = RemoveHtml($this->n_documento->caption());

			// condicion1
			$this->condicion1->EditAttrs["class"] = "form-control";
			$this->condicion1->EditCustomAttributes = "";
			$this->condicion1->EditValue = HtmlEncode($this->condicion1->CurrentValue);
			$this->condicion1->PlaceHolder = RemoveHtml($this->condicion1->caption());

			// condicion2
			$this->condicion2->EditAttrs["class"] = "form-control";
			$this->condicion2->EditCustomAttributes = "";
			$this->condicion2->EditValue = HtmlEncode($this->condicion2->CurrentValue);
			$this->condicion2->PlaceHolder = RemoveHtml($this->condicion2->caption());

			// consulta
			$this->consulta->EditAttrs["class"] = "form-control";
			$this->consulta->EditCustomAttributes = "";
			if (!$this->consulta->Raw)
				$this->consulta->CurrentValue = HtmlDecode($this->consulta->CurrentValue);
			$this->consulta->EditValue = HtmlEncode($this->consulta->CurrentValue);
			$this->consulta->PlaceHolder = RemoveHtml($this->consulta->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// codlogin
			$this->codlogin->EditAttrs["class"] = "form-control";
			$this->codlogin->EditCustomAttributes = "";
			if (!$this->codlogin->Raw)
				$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
			$this->codlogin->EditValue = HtmlEncode($this->codlogin->CurrentValue);
			$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

			// idproyecto
			$this->idproyecto->EditAttrs["class"] = "form-control";
			$this->idproyecto->EditCustomAttributes = "";
			$this->idproyecto->EditValue = HtmlEncode($this->idproyecto->CurrentValue);
			$this->idproyecto->PlaceHolder = RemoveHtml($this->idproyecto->caption());

			// id_producto
			$this->id_producto->EditAttrs["class"] = "form-control";
			$this->id_producto->EditCustomAttributes = "";
			$this->id_producto->EditValue = HtmlEncode($this->id_producto->CurrentValue);
			$this->id_producto->PlaceHolder = RemoveHtml($this->id_producto->caption());

			// Edit refer script
			// idinteresado

			$this->idinteresado->LinkCustomAttributes = "";
			$this->idinteresado->HrefValue = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->LinkCustomAttributes = "";
			$this->id_usuarioencargado->HrefValue = "";

			// fecha
			$this->fecha->LinkCustomAttributes = "";
			$this->fecha->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// cursos
			$this->cursos->LinkCustomAttributes = "";
			$this->cursos->HrefValue = "";

			// categorias
			$this->categorias->LinkCustomAttributes = "";
			$this->categorias->HrefValue = "";

			// nombres
			$this->nombres->LinkCustomAttributes = "";
			$this->nombres->HrefValue = "";

			// apellidos
			$this->apellidos->LinkCustomAttributes = "";
			$this->apellidos->HrefValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";

			// ciudad
			$this->ciudad->LinkCustomAttributes = "";
			$this->ciudad->HrefValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";

			// telefono
			$this->telefono->LinkCustomAttributes = "";
			$this->telefono->HrefValue = "";

			// tipo_certificado
			$this->tipo_certificado->LinkCustomAttributes = "";
			$this->tipo_certificado->HrefValue = "";

			// tipo_pago
			$this->tipo_pago->LinkCustomAttributes = "";
			$this->tipo_pago->HrefValue = "";

			// nombretarjeta
			$this->nombretarjeta->LinkCustomAttributes = "";
			$this->nombretarjeta->HrefValue = "";

			// numerotarjeta
			$this->numerotarjeta->LinkCustomAttributes = "";
			$this->numerotarjeta->HrefValue = "";

			// mes
			$this->mes->LinkCustomAttributes = "";
			$this->mes->HrefValue = "";

			// anio
			$this->anio->LinkCustomAttributes = "";
			$this->anio->HrefValue = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->LinkCustomAttributes = "";
			$this->tipo_tarjeta->HrefValue = "";

			// nombrepaypal
			$this->nombrepaypal->LinkCustomAttributes = "";
			$this->nombrepaypal->HrefValue = "";

			// montopaypal
			$this->montopaypal->LinkCustomAttributes = "";
			$this->montopaypal->HrefValue = "";

			// emailpaypal
			$this->emailpaypal->LinkCustomAttributes = "";
			$this->emailpaypal->HrefValue = "";

			// don
			$this->don->LinkCustomAttributes = "";
			$this->don->HrefValue = "";

			// tipo_condicion
			$this->tipo_condicion->LinkCustomAttributes = "";
			$this->tipo_condicion->HrefValue = "";

			// acciones
			$this->acciones->LinkCustomAttributes = "";
			$this->acciones->HrefValue = "";

			// solicitud
			$this->solicitud->LinkCustomAttributes = "";
			$this->solicitud->HrefValue = "";

			// examen
			$this->examen->LinkCustomAttributes = "";
			$this->examen->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";

			// codigo_certificado
			$this->codigo_certificado->LinkCustomAttributes = "";
			$this->codigo_certificado->HrefValue = "";

			// estado_entrega
			$this->estado_entrega->LinkCustomAttributes = "";
			$this->estado_entrega->HrefValue = "";

			// idioma
			$this->idioma->LinkCustomAttributes = "";
			$this->idioma->HrefValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";

			// condicion1
			$this->condicion1->LinkCustomAttributes = "";
			$this->condicion1->HrefValue = "";

			// condicion2
			$this->condicion2->LinkCustomAttributes = "";
			$this->condicion2->HrefValue = "";

			// consulta
			$this->consulta->LinkCustomAttributes = "";
			$this->consulta->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";

			// idproyecto
			$this->idproyecto->LinkCustomAttributes = "";
			$this->idproyecto->HrefValue = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->idinteresado->Required) {
			if (!$this->idinteresado->IsDetailKey && $this->idinteresado->FormValue != NULL && $this->idinteresado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idinteresado->caption(), $this->idinteresado->RequiredErrorMessage));
			}
		}
		if ($this->id_usuarioencargado->Required) {
			if (!$this->id_usuarioencargado->IsDetailKey && $this->id_usuarioencargado->FormValue != NULL && $this->id_usuarioencargado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_usuarioencargado->caption(), $this->id_usuarioencargado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_usuarioencargado->FormValue)) {
			AddMessage($FormError, $this->id_usuarioencargado->errorMessage());
		}
		if ($this->fecha->Required) {
			if (!$this->fecha->IsDetailKey && $this->fecha->FormValue != NULL && $this->fecha->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha->caption(), $this->fecha->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha->FormValue)) {
			AddMessage($FormError, $this->fecha->errorMessage());
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->cursos->Required) {
			if (!$this->cursos->IsDetailKey && $this->cursos->FormValue != NULL && $this->cursos->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cursos->caption(), $this->cursos->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cursos->FormValue)) {
			AddMessage($FormError, $this->cursos->errorMessage());
		}
		if ($this->categorias->Required) {
			if (!$this->categorias->IsDetailKey && $this->categorias->FormValue != NULL && $this->categorias->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->categorias->caption(), $this->categorias->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->categorias->FormValue)) {
			AddMessage($FormError, $this->categorias->errorMessage());
		}
		if ($this->nombres->Required) {
			if (!$this->nombres->IsDetailKey && $this->nombres->FormValue != NULL && $this->nombres->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombres->caption(), $this->nombres->RequiredErrorMessage));
			}
		}
		if ($this->apellidos->Required) {
			if (!$this->apellidos->IsDetailKey && $this->apellidos->FormValue != NULL && $this->apellidos->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->apellidos->caption(), $this->apellidos->RequiredErrorMessage));
			}
		}
		if ($this->direccion->Required) {
			if (!$this->direccion->IsDetailKey && $this->direccion->FormValue != NULL && $this->direccion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->direccion->caption(), $this->direccion->RequiredErrorMessage));
			}
		}
		if ($this->ciudad->Required) {
			if (!$this->ciudad->IsDetailKey && $this->ciudad->FormValue != NULL && $this->ciudad->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ciudad->caption(), $this->ciudad->RequiredErrorMessage));
			}
		}
		if ($this->provincia->Required) {
			if (!$this->provincia->IsDetailKey && $this->provincia->FormValue != NULL && $this->provincia->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->provincia->caption(), $this->provincia->RequiredErrorMessage));
			}
		}
		if ($this->pais->Required) {
			if (!$this->pais->IsDetailKey && $this->pais->FormValue != NULL && $this->pais->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pais->caption(), $this->pais->RequiredErrorMessage));
			}
		}
		if ($this->telefono->Required) {
			if (!$this->telefono->IsDetailKey && $this->telefono->FormValue != NULL && $this->telefono->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->telefono->caption(), $this->telefono->RequiredErrorMessage));
			}
		}
		if ($this->tipo_certificado->Required) {
			if (!$this->tipo_certificado->IsDetailKey && $this->tipo_certificado->FormValue != NULL && $this->tipo_certificado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_certificado->caption(), $this->tipo_certificado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_certificado->FormValue)) {
			AddMessage($FormError, $this->tipo_certificado->errorMessage());
		}
		if ($this->tipo_pago->Required) {
			if (!$this->tipo_pago->IsDetailKey && $this->tipo_pago->FormValue != NULL && $this->tipo_pago->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_pago->caption(), $this->tipo_pago->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_pago->FormValue)) {
			AddMessage($FormError, $this->tipo_pago->errorMessage());
		}
		if ($this->nombretarjeta->Required) {
			if (!$this->nombretarjeta->IsDetailKey && $this->nombretarjeta->FormValue != NULL && $this->nombretarjeta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombretarjeta->caption(), $this->nombretarjeta->RequiredErrorMessage));
			}
		}
		if ($this->numerotarjeta->Required) {
			if (!$this->numerotarjeta->IsDetailKey && $this->numerotarjeta->FormValue != NULL && $this->numerotarjeta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numerotarjeta->caption(), $this->numerotarjeta->RequiredErrorMessage));
			}
		}
		if ($this->mes->Required) {
			if (!$this->mes->IsDetailKey && $this->mes->FormValue != NULL && $this->mes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mes->caption(), $this->mes->RequiredErrorMessage));
			}
		}
		if ($this->anio->Required) {
			if (!$this->anio->IsDetailKey && $this->anio->FormValue != NULL && $this->anio->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->anio->caption(), $this->anio->RequiredErrorMessage));
			}
		}
		if ($this->tipo_tarjeta->Required) {
			if (!$this->tipo_tarjeta->IsDetailKey && $this->tipo_tarjeta->FormValue != NULL && $this->tipo_tarjeta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_tarjeta->caption(), $this->tipo_tarjeta->RequiredErrorMessage));
			}
		}
		if ($this->nombrepaypal->Required) {
			if (!$this->nombrepaypal->IsDetailKey && $this->nombrepaypal->FormValue != NULL && $this->nombrepaypal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombrepaypal->caption(), $this->nombrepaypal->RequiredErrorMessage));
			}
		}
		if ($this->montopaypal->Required) {
			if (!$this->montopaypal->IsDetailKey && $this->montopaypal->FormValue != NULL && $this->montopaypal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->montopaypal->caption(), $this->montopaypal->RequiredErrorMessage));
			}
		}
		if ($this->emailpaypal->Required) {
			if (!$this->emailpaypal->IsDetailKey && $this->emailpaypal->FormValue != NULL && $this->emailpaypal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emailpaypal->caption(), $this->emailpaypal->RequiredErrorMessage));
			}
		}
		if ($this->don->Required) {
			if (!$this->don->IsDetailKey && $this->don->FormValue != NULL && $this->don->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->don->caption(), $this->don->RequiredErrorMessage));
			}
		}
		if ($this->tipo_condicion->Required) {
			if (!$this->tipo_condicion->IsDetailKey && $this->tipo_condicion->FormValue != NULL && $this->tipo_condicion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_condicion->caption(), $this->tipo_condicion->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_condicion->FormValue)) {
			AddMessage($FormError, $this->tipo_condicion->errorMessage());
		}
		if ($this->acciones->Required) {
			if (!$this->acciones->IsDetailKey && $this->acciones->FormValue != NULL && $this->acciones->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->acciones->caption(), $this->acciones->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->acciones->FormValue)) {
			AddMessage($FormError, $this->acciones->errorMessage());
		}
		if ($this->solicitud->Required) {
			if (!$this->solicitud->IsDetailKey && $this->solicitud->FormValue != NULL && $this->solicitud->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->solicitud->caption(), $this->solicitud->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->solicitud->FormValue)) {
			AddMessage($FormError, $this->solicitud->errorMessage());
		}
		if ($this->examen->Required) {
			if (!$this->examen->IsDetailKey && $this->examen->FormValue != NULL && $this->examen->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->examen->caption(), $this->examen->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->examen->FormValue)) {
			AddMessage($FormError, $this->examen->errorMessage());
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->tipo->Required) {
			if (!$this->tipo->IsDetailKey && $this->tipo->FormValue != NULL && $this->tipo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo->caption(), $this->tipo->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo->FormValue)) {
			AddMessage($FormError, $this->tipo->errorMessage());
		}
		if ($this->codigo_certificado->Required) {
			if (!$this->codigo_certificado->IsDetailKey && $this->codigo_certificado->FormValue != NULL && $this->codigo_certificado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codigo_certificado->caption(), $this->codigo_certificado->RequiredErrorMessage));
			}
		}
		if ($this->estado_entrega->Required) {
			if (!$this->estado_entrega->IsDetailKey && $this->estado_entrega->FormValue != NULL && $this->estado_entrega->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado_entrega->caption(), $this->estado_entrega->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado_entrega->FormValue)) {
			AddMessage($FormError, $this->estado_entrega->errorMessage());
		}
		if ($this->idioma->Required) {
			if (!$this->idioma->IsDetailKey && $this->idioma->FormValue != NULL && $this->idioma->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idioma->caption(), $this->idioma->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idioma->FormValue)) {
			AddMessage($FormError, $this->idioma->errorMessage());
		}
		if ($this->tipo_documento->Required) {
			if (!$this->tipo_documento->IsDetailKey && $this->tipo_documento->FormValue != NULL && $this->tipo_documento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_documento->caption(), $this->tipo_documento->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_documento->FormValue)) {
			AddMessage($FormError, $this->tipo_documento->errorMessage());
		}
		if ($this->n_documento->Required) {
			if (!$this->n_documento->IsDetailKey && $this->n_documento->FormValue != NULL && $this->n_documento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->n_documento->caption(), $this->n_documento->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->n_documento->FormValue)) {
			AddMessage($FormError, $this->n_documento->errorMessage());
		}
		if ($this->condicion1->Required) {
			if (!$this->condicion1->IsDetailKey && $this->condicion1->FormValue != NULL && $this->condicion1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->condicion1->caption(), $this->condicion1->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->condicion1->FormValue)) {
			AddMessage($FormError, $this->condicion1->errorMessage());
		}
		if ($this->condicion2->Required) {
			if (!$this->condicion2->IsDetailKey && $this->condicion2->FormValue != NULL && $this->condicion2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->condicion2->caption(), $this->condicion2->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->condicion2->FormValue)) {
			AddMessage($FormError, $this->condicion2->errorMessage());
		}
		if ($this->consulta->Required) {
			if (!$this->consulta->IsDetailKey && $this->consulta->FormValue != NULL && $this->consulta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consulta->caption(), $this->consulta->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status->FormValue)) {
			AddMessage($FormError, $this->status->errorMessage());
		}
		if ($this->codlogin->Required) {
			if (!$this->codlogin->IsDetailKey && $this->codlogin->FormValue != NULL && $this->codlogin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codlogin->caption(), $this->codlogin->RequiredErrorMessage));
			}
		}
		if ($this->idproyecto->Required) {
			if (!$this->idproyecto->IsDetailKey && $this->idproyecto->FormValue != NULL && $this->idproyecto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idproyecto->caption(), $this->idproyecto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idproyecto->FormValue)) {
			AddMessage($FormError, $this->idproyecto->errorMessage());
		}
		if ($this->id_producto->Required) {
			if (!$this->id_producto->IsDetailKey && $this->id_producto->FormValue != NULL && $this->id_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_producto->caption(), $this->id_producto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_producto->FormValue)) {
			AddMessage($FormError, $this->id_producto->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// id_usuarioencargado
			$this->id_usuarioencargado->setDbValueDef($rsnew, $this->id_usuarioencargado->CurrentValue, NULL, $this->id_usuarioencargado->ReadOnly);

			// fecha
			$this->fecha->setDbValueDef($rsnew, UnFormatDateTime($this->fecha->CurrentValue, 0), CurrentDate(), $this->fecha->ReadOnly);

			// email
			$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, $this->_email->ReadOnly);

			// cursos
			$this->cursos->setDbValueDef($rsnew, $this->cursos->CurrentValue, NULL, $this->cursos->ReadOnly);

			// categorias
			$this->categorias->setDbValueDef($rsnew, $this->categorias->CurrentValue, NULL, $this->categorias->ReadOnly);

			// nombres
			$this->nombres->setDbValueDef($rsnew, $this->nombres->CurrentValue, NULL, $this->nombres->ReadOnly);

			// apellidos
			$this->apellidos->setDbValueDef($rsnew, $this->apellidos->CurrentValue, NULL, $this->apellidos->ReadOnly);

			// direccion
			$this->direccion->setDbValueDef($rsnew, $this->direccion->CurrentValue, NULL, $this->direccion->ReadOnly);

			// ciudad
			$this->ciudad->setDbValueDef($rsnew, $this->ciudad->CurrentValue, NULL, $this->ciudad->ReadOnly);

			// provincia
			$this->provincia->setDbValueDef($rsnew, $this->provincia->CurrentValue, NULL, $this->provincia->ReadOnly);

			// pais
			$this->pais->setDbValueDef($rsnew, $this->pais->CurrentValue, NULL, $this->pais->ReadOnly);

			// telefono
			$this->telefono->setDbValueDef($rsnew, $this->telefono->CurrentValue, NULL, $this->telefono->ReadOnly);

			// tipo_certificado
			$this->tipo_certificado->setDbValueDef($rsnew, $this->tipo_certificado->CurrentValue, NULL, $this->tipo_certificado->ReadOnly);

			// tipo_pago
			$this->tipo_pago->setDbValueDef($rsnew, $this->tipo_pago->CurrentValue, NULL, $this->tipo_pago->ReadOnly);

			// nombretarjeta
			$this->nombretarjeta->setDbValueDef($rsnew, $this->nombretarjeta->CurrentValue, NULL, $this->nombretarjeta->ReadOnly);

			// numerotarjeta
			$this->numerotarjeta->setDbValueDef($rsnew, $this->numerotarjeta->CurrentValue, NULL, $this->numerotarjeta->ReadOnly);

			// mes
			$this->mes->setDbValueDef($rsnew, $this->mes->CurrentValue, NULL, $this->mes->ReadOnly);

			// anio
			$this->anio->setDbValueDef($rsnew, $this->anio->CurrentValue, NULL, $this->anio->ReadOnly);

			// tipo_tarjeta
			$this->tipo_tarjeta->setDbValueDef($rsnew, $this->tipo_tarjeta->CurrentValue, NULL, $this->tipo_tarjeta->ReadOnly);

			// nombrepaypal
			$this->nombrepaypal->setDbValueDef($rsnew, $this->nombrepaypal->CurrentValue, NULL, $this->nombrepaypal->ReadOnly);

			// montopaypal
			$this->montopaypal->setDbValueDef($rsnew, $this->montopaypal->CurrentValue, NULL, $this->montopaypal->ReadOnly);

			// emailpaypal
			$this->emailpaypal->setDbValueDef($rsnew, $this->emailpaypal->CurrentValue, NULL, $this->emailpaypal->ReadOnly);

			// don
			$this->don->setDbValueDef($rsnew, $this->don->CurrentValue, NULL, $this->don->ReadOnly);

			// tipo_condicion
			$this->tipo_condicion->setDbValueDef($rsnew, $this->tipo_condicion->CurrentValue, NULL, $this->tipo_condicion->ReadOnly);

			// acciones
			$this->acciones->setDbValueDef($rsnew, $this->acciones->CurrentValue, NULL, $this->acciones->ReadOnly);

			// solicitud
			$this->solicitud->setDbValueDef($rsnew, $this->solicitud->CurrentValue, NULL, $this->solicitud->ReadOnly);

			// examen
			$this->examen->setDbValueDef($rsnew, $this->examen->CurrentValue, NULL, $this->examen->ReadOnly);

			// estado
			$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, $this->estado->ReadOnly);

			// tipo
			$this->tipo->setDbValueDef($rsnew, $this->tipo->CurrentValue, NULL, $this->tipo->ReadOnly);

			// codigo_certificado
			$this->codigo_certificado->setDbValueDef($rsnew, $this->codigo_certificado->CurrentValue, NULL, $this->codigo_certificado->ReadOnly);

			// estado_entrega
			$this->estado_entrega->setDbValueDef($rsnew, $this->estado_entrega->CurrentValue, NULL, $this->estado_entrega->ReadOnly);

			// idioma
			$this->idioma->setDbValueDef($rsnew, $this->idioma->CurrentValue, NULL, $this->idioma->ReadOnly);

			// tipo_documento
			$this->tipo_documento->setDbValueDef($rsnew, $this->tipo_documento->CurrentValue, NULL, $this->tipo_documento->ReadOnly);

			// n_documento
			$this->n_documento->setDbValueDef($rsnew, $this->n_documento->CurrentValue, NULL, $this->n_documento->ReadOnly);

			// condicion1
			$this->condicion1->setDbValueDef($rsnew, $this->condicion1->CurrentValue, NULL, $this->condicion1->ReadOnly);

			// condicion2
			$this->condicion2->setDbValueDef($rsnew, $this->condicion2->CurrentValue, NULL, $this->condicion2->ReadOnly);

			// consulta
			$this->consulta->setDbValueDef($rsnew, $this->consulta->CurrentValue, NULL, $this->consulta->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// codlogin
			$this->codlogin->setDbValueDef($rsnew, $this->codlogin->CurrentValue, NULL, $this->codlogin->ReadOnly);

			// idproyecto
			$this->idproyecto->setDbValueDef($rsnew, $this->idproyecto->CurrentValue, 0, $this->idproyecto->ReadOnly);

			// id_producto
			$this->id_producto->setDbValueDef($rsnew, $this->id_producto->CurrentValue, 0, $this->id_producto->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew); 
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("interesadoslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>