<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for detalle_cuota
 */
class detalle_cuota extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_detallecuota;
	public $id_producto;
	public $id_cuota;
	public $num_plazos;
	public $monto_pagar;
	public $fecha_pago;
	public $estado;
	public $metodo_pago;
	public $monto_deposito;
	public $cuenta_banco;
	public $tipo_transferencia;
	public $numero_operacion;
	public $fecha_deposito;
	public $referencia;
	public $imagen;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'detalle_cuota';
		$this->TableName = 'detalle_cuota';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`detalle_cuota`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_detallecuota
		$this->id_detallecuota = new DbField('detalle_cuota', 'detalle_cuota', 'x_id_detallecuota', 'id_detallecuota', '`id_detallecuota`', '`id_detallecuota`', 3, 11, -1, FALSE, '`id_detallecuota`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_detallecuota->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_detallecuota->IsPrimaryKey = TRUE; // Primary key field
		$this->id_detallecuota->Sortable = TRUE; // Allow sort
		$this->id_detallecuota->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_detallecuota'] = &$this->id_detallecuota;

		// id_producto
		$this->id_producto = new DbField('detalle_cuota', 'detalle_cuota', 'x_id_producto', 'id_producto', '`id_producto`', '`id_producto`', 3, 11, -1, FALSE, '`id_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_producto->Sortable = TRUE; // Allow sort
		$this->id_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_producto'] = &$this->id_producto;

		// id_cuota
		$this->id_cuota = new DbField('detalle_cuota', 'detalle_cuota', 'x_id_cuota', 'id_cuota', '`id_cuota`', '`id_cuota`', 3, 11, -1, FALSE, '`id_cuota`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_cuota->Sortable = TRUE; // Allow sort
		$this->id_cuota->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_cuota'] = &$this->id_cuota;

		// num_plazos
		$this->num_plazos = new DbField('detalle_cuota', 'detalle_cuota', 'x_num_plazos', 'num_plazos', '`num_plazos`', '`num_plazos`', 3, 11, -1, FALSE, '`num_plazos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->num_plazos->Sortable = TRUE; // Allow sort
		$this->num_plazos->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['num_plazos'] = &$this->num_plazos;

		// monto_pagar
		$this->monto_pagar = new DbField('detalle_cuota', 'detalle_cuota', 'x_monto_pagar', 'monto_pagar', '`monto_pagar`', '`monto_pagar`', 131, 12, -1, FALSE, '`monto_pagar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->monto_pagar->Sortable = TRUE; // Allow sort
		$this->monto_pagar->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['monto_pagar'] = &$this->monto_pagar;

		// fecha_pago
		$this->fecha_pago = new DbField('detalle_cuota', 'detalle_cuota', 'x_fecha_pago', 'fecha_pago', '`fecha_pago`', CastDateFieldForLike("`fecha_pago`", 0, "DB"), 133, 10, 0, FALSE, '`fecha_pago`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha_pago->Sortable = TRUE; // Allow sort
		$this->fecha_pago->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha_pago'] = &$this->fecha_pago;

		// estado
		$this->estado = new DbField('detalle_cuota', 'detalle_cuota', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Nullable = FALSE; // NOT NULL field
		$this->estado->Required = TRUE; // Required field
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// metodo_pago
		$this->metodo_pago = new DbField('detalle_cuota', 'detalle_cuota', 'x_metodo_pago', 'metodo_pago', '`metodo_pago`', '`metodo_pago`', 3, 11, -1, FALSE, '`metodo_pago`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->metodo_pago->Sortable = TRUE; // Allow sort
		$this->metodo_pago->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['metodo_pago'] = &$this->metodo_pago;

		// monto_deposito
		$this->monto_deposito = new DbField('detalle_cuota', 'detalle_cuota', 'x_monto_deposito', 'monto_deposito', '`monto_deposito`', '`monto_deposito`', 131, 11, -1, FALSE, '`monto_deposito`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->monto_deposito->Sortable = TRUE; // Allow sort
		$this->monto_deposito->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['monto_deposito'] = &$this->monto_deposito;

		// cuenta_banco
		$this->cuenta_banco = new DbField('detalle_cuota', 'detalle_cuota', 'x_cuenta_banco', 'cuenta_banco', '`cuenta_banco`', '`cuenta_banco`', 200, 50, -1, FALSE, '`cuenta_banco`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cuenta_banco->Sortable = TRUE; // Allow sort
		$this->fields['cuenta_banco'] = &$this->cuenta_banco;

		// tipo_transferencia
		$this->tipo_transferencia = new DbField('detalle_cuota', 'detalle_cuota', 'x_tipo_transferencia', 'tipo_transferencia', '`tipo_transferencia`', '`tipo_transferencia`', 3, 11, -1, FALSE, '`tipo_transferencia`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_transferencia->Sortable = TRUE; // Allow sort
		$this->tipo_transferencia->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_transferencia'] = &$this->tipo_transferencia;

		// numero_operacion
		$this->numero_operacion = new DbField('detalle_cuota', 'detalle_cuota', 'x_numero_operacion', 'numero_operacion', '`numero_operacion`', '`numero_operacion`', 200, 50, -1, FALSE, '`numero_operacion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numero_operacion->Sortable = TRUE; // Allow sort
		$this->fields['numero_operacion'] = &$this->numero_operacion;

		// fecha_deposito
		$this->fecha_deposito = new DbField('detalle_cuota', 'detalle_cuota', 'x_fecha_deposito', 'fecha_deposito', '`fecha_deposito`', CastDateFieldForLike("`fecha_deposito`", 0, "DB"), 133, 10, 0, FALSE, '`fecha_deposito`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha_deposito->Sortable = TRUE; // Allow sort
		$this->fecha_deposito->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha_deposito'] = &$this->fecha_deposito;

		// referencia
		$this->referencia = new DbField('detalle_cuota', 'detalle_cuota', 'x_referencia', 'referencia', '`referencia`', '`referencia`', 200, 250, -1, FALSE, '`referencia`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->referencia->Sortable = TRUE; // Allow sort
		$this->fields['referencia'] = &$this->referencia;

		// imagen
		$this->imagen = new DbField('detalle_cuota', 'detalle_cuota', 'x_imagen', 'imagen', '`imagen`', '`imagen`', 201, 65535, -1, FALSE, '`imagen`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->imagen->Sortable = TRUE; // Allow sort
		$this->fields['imagen'] = &$this->imagen;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`detalle_cuota`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_detallecuota->setDbValue($conn->insert_ID());
			$rs['id_detallecuota'] = $this->id_detallecuota->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_detallecuota', $rs))
				AddFilter($where, QuotedName('id_detallecuota', $this->Dbid) . '=' . QuotedValue($rs['id_detallecuota'], $this->id_detallecuota->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_detallecuota->DbValue = $row['id_detallecuota'];
		$this->id_producto->DbValue = $row['id_producto'];
		$this->id_cuota->DbValue = $row['id_cuota'];
		$this->num_plazos->DbValue = $row['num_plazos'];
		$this->monto_pagar->DbValue = $row['monto_pagar'];
		$this->fecha_pago->DbValue = $row['fecha_pago'];
		$this->estado->DbValue = $row['estado'];
		$this->metodo_pago->DbValue = $row['metodo_pago'];
		$this->monto_deposito->DbValue = $row['monto_deposito'];
		$this->cuenta_banco->DbValue = $row['cuenta_banco'];
		$this->tipo_transferencia->DbValue = $row['tipo_transferencia'];
		$this->numero_operacion->DbValue = $row['numero_operacion'];
		$this->fecha_deposito->DbValue = $row['fecha_deposito'];
		$this->referencia->DbValue = $row['referencia'];
		$this->imagen->DbValue = $row['imagen'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_detallecuota` = @id_detallecuota@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_detallecuota', $row) ? $row['id_detallecuota'] : NULL;
		else
			$val = $this->id_detallecuota->OldValue !== NULL ? $this->id_detallecuota->OldValue : $this->id_detallecuota->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_detallecuota@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "detalle_cuotalist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "detalle_cuotaview.php")
			return $Language->phrase("View");
		elseif ($pageName == "detalle_cuotaedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "detalle_cuotaadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "detalle_cuotalist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("detalle_cuotaview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("detalle_cuotaview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "detalle_cuotaadd.php?" . $this->getUrlParm($parm);
		else
			$url = "detalle_cuotaadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("detalle_cuotaedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("detalle_cuotaadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("detalle_cuotadelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_detallecuota:" . JsonEncode($this->id_detallecuota->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_detallecuota->CurrentValue != NULL) {
			$url .= "id_detallecuota=" . urlencode($this->id_detallecuota->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_detallecuota") !== NULL)
				$arKeys[] = Param("id_detallecuota");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_detallecuota->CurrentValue = $key;
			else
				$this->id_detallecuota->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_detallecuota->setDbValue($rs->fields('id_detallecuota'));
		$this->id_producto->setDbValue($rs->fields('id_producto'));
		$this->id_cuota->setDbValue($rs->fields('id_cuota'));
		$this->num_plazos->setDbValue($rs->fields('num_plazos'));
		$this->monto_pagar->setDbValue($rs->fields('monto_pagar'));
		$this->fecha_pago->setDbValue($rs->fields('fecha_pago'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->metodo_pago->setDbValue($rs->fields('metodo_pago'));
		$this->monto_deposito->setDbValue($rs->fields('monto_deposito'));
		$this->cuenta_banco->setDbValue($rs->fields('cuenta_banco'));
		$this->tipo_transferencia->setDbValue($rs->fields('tipo_transferencia'));
		$this->numero_operacion->setDbValue($rs->fields('numero_operacion'));
		$this->fecha_deposito->setDbValue($rs->fields('fecha_deposito'));
		$this->referencia->setDbValue($rs->fields('referencia'));
		$this->imagen->setDbValue($rs->fields('imagen'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_detallecuota
		// id_producto
		// id_cuota
		// num_plazos
		// monto_pagar
		// fecha_pago
		// estado
		// metodo_pago
		// monto_deposito
		// cuenta_banco
		// tipo_transferencia
		// numero_operacion
		// fecha_deposito
		// referencia
		// imagen
		// id_detallecuota

		$this->id_detallecuota->ViewValue = $this->id_detallecuota->CurrentValue;
		$this->id_detallecuota->ViewCustomAttributes = "";

		// id_producto
		$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
		$this->id_producto->ViewCustomAttributes = "";

		// id_cuota
		$this->id_cuota->ViewValue = $this->id_cuota->CurrentValue;
		$this->id_cuota->ViewValue = FormatNumber($this->id_cuota->ViewValue, 0, -2, -2, -2);
		$this->id_cuota->ViewCustomAttributes = "";

		// num_plazos
		$this->num_plazos->ViewValue = $this->num_plazos->CurrentValue;
		$this->num_plazos->ViewValue = FormatNumber($this->num_plazos->ViewValue, 0, -2, -2, -2);
		$this->num_plazos->ViewCustomAttributes = "";

		// monto_pagar
		$this->monto_pagar->ViewValue = $this->monto_pagar->CurrentValue;
		$this->monto_pagar->ViewValue = FormatNumber($this->monto_pagar->ViewValue, 2, -2, -2, -2);
		$this->monto_pagar->ViewCustomAttributes = "";

		// fecha_pago
		$this->fecha_pago->ViewValue = $this->fecha_pago->CurrentValue;
		$this->fecha_pago->ViewValue = FormatDateTime($this->fecha_pago->ViewValue, 0);
		$this->fecha_pago->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// metodo_pago
		$this->metodo_pago->ViewValue = $this->metodo_pago->CurrentValue;
		$this->metodo_pago->ViewValue = FormatNumber($this->metodo_pago->ViewValue, 0, -2, -2, -2);
		$this->metodo_pago->ViewCustomAttributes = "";

		// monto_deposito
		$this->monto_deposito->ViewValue = $this->monto_deposito->CurrentValue;
		$this->monto_deposito->ViewValue = FormatNumber($this->monto_deposito->ViewValue, 2, -2, -2, -2);
		$this->monto_deposito->ViewCustomAttributes = "";

		// cuenta_banco
		$this->cuenta_banco->ViewValue = $this->cuenta_banco->CurrentValue;
		$this->cuenta_banco->ViewCustomAttributes = "";

		// tipo_transferencia
		$this->tipo_transferencia->ViewValue = $this->tipo_transferencia->CurrentValue;
		$this->tipo_transferencia->ViewValue = FormatNumber($this->tipo_transferencia->ViewValue, 0, -2, -2, -2);
		$this->tipo_transferencia->ViewCustomAttributes = "";

		// numero_operacion
		$this->numero_operacion->ViewValue = $this->numero_operacion->CurrentValue;
		$this->numero_operacion->ViewCustomAttributes = "";

		// fecha_deposito
		$this->fecha_deposito->ViewValue = $this->fecha_deposito->CurrentValue;
		$this->fecha_deposito->ViewValue = FormatDateTime($this->fecha_deposito->ViewValue, 0);
		$this->fecha_deposito->ViewCustomAttributes = "";

		// referencia
		$this->referencia->ViewValue = $this->referencia->CurrentValue;
		$this->referencia->ViewCustomAttributes = "";

		// imagen
		$this->imagen->ViewValue = $this->imagen->CurrentValue;
		$this->imagen->ViewCustomAttributes = "";

		// id_detallecuota
		$this->id_detallecuota->LinkCustomAttributes = "";
		$this->id_detallecuota->HrefValue = "";
		$this->id_detallecuota->TooltipValue = "";

		// id_producto
		$this->id_producto->LinkCustomAttributes = "";
		$this->id_producto->HrefValue = "";
		$this->id_producto->TooltipValue = "";

		// id_cuota
		$this->id_cuota->LinkCustomAttributes = "";
		$this->id_cuota->HrefValue = "";
		$this->id_cuota->TooltipValue = "";

		// num_plazos
		$this->num_plazos->LinkCustomAttributes = "";
		$this->num_plazos->HrefValue = "";
		$this->num_plazos->TooltipValue = "";

		// monto_pagar
		$this->monto_pagar->LinkCustomAttributes = "";
		$this->monto_pagar->HrefValue = "";
		$this->monto_pagar->TooltipValue = "";

		// fecha_pago
		$this->fecha_pago->LinkCustomAttributes = "";
		$this->fecha_pago->HrefValue = "";
		$this->fecha_pago->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// metodo_pago
		$this->metodo_pago->LinkCustomAttributes = "";
		$this->metodo_pago->HrefValue = "";
		$this->metodo_pago->TooltipValue = "";

		// monto_deposito
		$this->monto_deposito->LinkCustomAttributes = "";
		$this->monto_deposito->HrefValue = "";
		$this->monto_deposito->TooltipValue = "";

		// cuenta_banco
		$this->cuenta_banco->LinkCustomAttributes = "";
		$this->cuenta_banco->HrefValue = "";
		$this->cuenta_banco->TooltipValue = "";

		// tipo_transferencia
		$this->tipo_transferencia->LinkCustomAttributes = "";
		$this->tipo_transferencia->HrefValue = "";
		$this->tipo_transferencia->TooltipValue = "";

		// numero_operacion
		$this->numero_operacion->LinkCustomAttributes = "";
		$this->numero_operacion->HrefValue = "";
		$this->numero_operacion->TooltipValue = "";

		// fecha_deposito
		$this->fecha_deposito->LinkCustomAttributes = "";
		$this->fecha_deposito->HrefValue = "";
		$this->fecha_deposito->TooltipValue = "";

		// referencia
		$this->referencia->LinkCustomAttributes = "";
		$this->referencia->HrefValue = "";
		$this->referencia->TooltipValue = "";

		// imagen
		$this->imagen->LinkCustomAttributes = "";
		$this->imagen->HrefValue = "";
		$this->imagen->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_detallecuota
		$this->id_detallecuota->EditAttrs["class"] = "form-control";
		$this->id_detallecuota->EditCustomAttributes = "";
		$this->id_detallecuota->EditValue = $this->id_detallecuota->CurrentValue;
		$this->id_detallecuota->ViewCustomAttributes = "";

		// id_producto
		$this->id_producto->EditAttrs["class"] = "form-control";
		$this->id_producto->EditCustomAttributes = "";
		$this->id_producto->EditValue = $this->id_producto->CurrentValue;
		$this->id_producto->PlaceHolder = RemoveHtml($this->id_producto->caption());

		// id_cuota
		$this->id_cuota->EditAttrs["class"] = "form-control";
		$this->id_cuota->EditCustomAttributes = "";
		$this->id_cuota->EditValue = $this->id_cuota->CurrentValue;
		$this->id_cuota->PlaceHolder = RemoveHtml($this->id_cuota->caption());

		// num_plazos
		$this->num_plazos->EditAttrs["class"] = "form-control";
		$this->num_plazos->EditCustomAttributes = "";
		$this->num_plazos->EditValue = $this->num_plazos->CurrentValue;
		$this->num_plazos->PlaceHolder = RemoveHtml($this->num_plazos->caption());

		// monto_pagar
		$this->monto_pagar->EditAttrs["class"] = "form-control";
		$this->monto_pagar->EditCustomAttributes = "";
		$this->monto_pagar->EditValue = $this->monto_pagar->CurrentValue;
		$this->monto_pagar->PlaceHolder = RemoveHtml($this->monto_pagar->caption());
		if (strval($this->monto_pagar->EditValue) != "" && is_numeric($this->monto_pagar->EditValue))
			$this->monto_pagar->EditValue = FormatNumber($this->monto_pagar->EditValue, -2, -2, -2, -2);
		

		// fecha_pago
		$this->fecha_pago->EditAttrs["class"] = "form-control";
		$this->fecha_pago->EditCustomAttributes = "";
		$this->fecha_pago->EditValue = FormatDateTime($this->fecha_pago->CurrentValue, 8);
		$this->fecha_pago->PlaceHolder = RemoveHtml($this->fecha_pago->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// metodo_pago
		$this->metodo_pago->EditAttrs["class"] = "form-control";
		$this->metodo_pago->EditCustomAttributes = "";
		$this->metodo_pago->EditValue = $this->metodo_pago->CurrentValue;
		$this->metodo_pago->PlaceHolder = RemoveHtml($this->metodo_pago->caption());

		// monto_deposito
		$this->monto_deposito->EditAttrs["class"] = "form-control";
		$this->monto_deposito->EditCustomAttributes = "";
		$this->monto_deposito->EditValue = $this->monto_deposito->CurrentValue;
		$this->monto_deposito->PlaceHolder = RemoveHtml($this->monto_deposito->caption());
		if (strval($this->monto_deposito->EditValue) != "" && is_numeric($this->monto_deposito->EditValue))
			$this->monto_deposito->EditValue = FormatNumber($this->monto_deposito->EditValue, -2, -2, -2, -2);
		

		// cuenta_banco
		$this->cuenta_banco->EditAttrs["class"] = "form-control";
		$this->cuenta_banco->EditCustomAttributes = "";
		if (!$this->cuenta_banco->Raw)
			$this->cuenta_banco->CurrentValue = HtmlDecode($this->cuenta_banco->CurrentValue);
		$this->cuenta_banco->EditValue = $this->cuenta_banco->CurrentValue;
		$this->cuenta_banco->PlaceHolder = RemoveHtml($this->cuenta_banco->caption());

		// tipo_transferencia
		$this->tipo_transferencia->EditAttrs["class"] = "form-control";
		$this->tipo_transferencia->EditCustomAttributes = "";
		$this->tipo_transferencia->EditValue = $this->tipo_transferencia->CurrentValue;
		$this->tipo_transferencia->PlaceHolder = RemoveHtml($this->tipo_transferencia->caption());

		// numero_operacion
		$this->numero_operacion->EditAttrs["class"] = "form-control";
		$this->numero_operacion->EditCustomAttributes = "";
		if (!$this->numero_operacion->Raw)
			$this->numero_operacion->CurrentValue = HtmlDecode($this->numero_operacion->CurrentValue);
		$this->numero_operacion->EditValue = $this->numero_operacion->CurrentValue;
		$this->numero_operacion->PlaceHolder = RemoveHtml($this->numero_operacion->caption());

		// fecha_deposito
		$this->fecha_deposito->EditAttrs["class"] = "form-control";
		$this->fecha_deposito->EditCustomAttributes = "";
		$this->fecha_deposito->EditValue = FormatDateTime($this->fecha_deposito->CurrentValue, 8);
		$this->fecha_deposito->PlaceHolder = RemoveHtml($this->fecha_deposito->caption());

		// referencia
		$this->referencia->EditAttrs["class"] = "form-control";
		$this->referencia->EditCustomAttributes = "";
		if (!$this->referencia->Raw)
			$this->referencia->CurrentValue = HtmlDecode($this->referencia->CurrentValue);
		$this->referencia->EditValue = $this->referencia->CurrentValue;
		$this->referencia->PlaceHolder = RemoveHtml($this->referencia->caption());

		// imagen
		$this->imagen->EditAttrs["class"] = "form-control";
		$this->imagen->EditCustomAttributes = "";
		$this->imagen->EditValue = $this->imagen->CurrentValue;
		$this->imagen->PlaceHolder = RemoveHtml($this->imagen->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_detallecuota);
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->id_cuota);
					$doc->exportCaption($this->num_plazos);
					$doc->exportCaption($this->monto_pagar);
					$doc->exportCaption($this->fecha_pago);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->metodo_pago);
					$doc->exportCaption($this->monto_deposito);
					$doc->exportCaption($this->cuenta_banco);
					$doc->exportCaption($this->tipo_transferencia);
					$doc->exportCaption($this->numero_operacion);
					$doc->exportCaption($this->fecha_deposito);
					$doc->exportCaption($this->referencia);
					$doc->exportCaption($this->imagen);
				} else {
					$doc->exportCaption($this->id_detallecuota);
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->id_cuota);
					$doc->exportCaption($this->num_plazos);
					$doc->exportCaption($this->monto_pagar);
					$doc->exportCaption($this->fecha_pago);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->metodo_pago);
					$doc->exportCaption($this->monto_deposito);
					$doc->exportCaption($this->cuenta_banco);
					$doc->exportCaption($this->tipo_transferencia);
					$doc->exportCaption($this->numero_operacion);
					$doc->exportCaption($this->fecha_deposito);
					$doc->exportCaption($this->referencia);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_detallecuota);
						$doc->exportField($this->id_producto);
						$doc->exportField($this->id_cuota);
						$doc->exportField($this->num_plazos);
						$doc->exportField($this->monto_pagar);
						$doc->exportField($this->fecha_pago);
						$doc->exportField($this->estado);
						$doc->exportField($this->metodo_pago);
						$doc->exportField($this->monto_deposito);
						$doc->exportField($this->cuenta_banco);
						$doc->exportField($this->tipo_transferencia);
						$doc->exportField($this->numero_operacion);
						$doc->exportField($this->fecha_deposito);
						$doc->exportField($this->referencia);
						$doc->exportField($this->imagen);
					} else {
						$doc->exportField($this->id_detallecuota);
						$doc->exportField($this->id_producto);
						$doc->exportField($this->id_cuota);
						$doc->exportField($this->num_plazos);
						$doc->exportField($this->monto_pagar);
						$doc->exportField($this->fecha_pago);
						$doc->exportField($this->estado);
						$doc->exportField($this->metodo_pago);
						$doc->exportField($this->monto_deposito);
						$doc->exportField($this->cuenta_banco);
						$doc->exportField($this->tipo_transferencia);
						$doc->exportField($this->numero_operacion);
						$doc->exportField($this->fecha_deposito);
						$doc->exportField($this->referencia);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>