<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class bkp_master_articulos_add extends bkp_master_articulos
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'bkp_master_articulos';

	// Page object name
	public $PageObjName = "bkp_master_articulos_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bkp_master_articulos)
		if (!isset($GLOBALS["bkp_master_articulos"]) || get_class($GLOBALS["bkp_master_articulos"]) == PROJECT_NAMESPACE . "bkp_master_articulos") {
			$GLOBALS["bkp_master_articulos"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bkp_master_articulos"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bkp_master_articulos');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $bkp_master_articulos;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($bkp_master_articulos);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bkp_master_articulosview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_reg'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_reg->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bkp_master_articuloslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_reg->Visible = FALSE;
		$this->idempresa->setVisibility();
		$this->idarticuloemp->setVisibility();
		$this->codproveedor->setVisibility();
		$this->estado->setVisibility();
		$this->coddum->setVisibility();
		$this->descripcion->setVisibility();
		$this->descripcioncorta->setVisibility();
		$this->idcategoria->setVisibility();
		$this->articuloaltura->setVisibility();
		$this->articuloancho->setVisibility();
		$this->articulolargo->setVisibility();
		$this->articulopeso->setVisibility();
		$this->articulocosto->setVisibility();
		$this->cajaaltura->setVisibility();
		$this->cajaancho->setVisibility();
		$this->cajalargo->setVisibility();
		$this->cajapeso->setVisibility();
		$this->numpiezas->setVisibility();
		$this->unidadcaja->setVisibility();
		$this->diasventa->setVisibility();
		$this->fecha_reg->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id_reg") !== NULL) {
				$this->id_reg->setQueryStringValue(Get("id_reg"));
				$this->setKey("id_reg", $this->id_reg->CurrentValue); // Set up key
			} else {
				$this->setKey("id_reg", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("bkp_master_articuloslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "bkp_master_articuloslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "bkp_master_articulosview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id_reg->CurrentValue = NULL;
		$this->id_reg->OldValue = $this->id_reg->CurrentValue;
		$this->idempresa->CurrentValue = NULL;
		$this->idempresa->OldValue = $this->idempresa->CurrentValue;
		$this->idarticuloemp->CurrentValue = NULL;
		$this->idarticuloemp->OldValue = $this->idarticuloemp->CurrentValue;
		$this->codproveedor->CurrentValue = NULL;
		$this->codproveedor->OldValue = $this->codproveedor->CurrentValue;
		$this->estado->CurrentValue = "1";
		$this->coddum->CurrentValue = NULL;
		$this->coddum->OldValue = $this->coddum->CurrentValue;
		$this->descripcion->CurrentValue = NULL;
		$this->descripcion->OldValue = $this->descripcion->CurrentValue;
		$this->descripcioncorta->CurrentValue = NULL;
		$this->descripcioncorta->OldValue = $this->descripcioncorta->CurrentValue;
		$this->idcategoria->CurrentValue = NULL;
		$this->idcategoria->OldValue = $this->idcategoria->CurrentValue;
		$this->articuloaltura->CurrentValue = 0.000;
		$this->articuloancho->CurrentValue = 0.000;
		$this->articulolargo->CurrentValue = 0.000;
		$this->articulopeso->CurrentValue = 0.000;
		$this->articulocosto->CurrentValue = 0.000;
		$this->cajaaltura->CurrentValue = 0.000;
		$this->cajaancho->CurrentValue = 0.000;
		$this->cajalargo->CurrentValue = 0.000;
		$this->cajapeso->CurrentValue = 0.000;
		$this->numpiezas->CurrentValue = NULL;
		$this->numpiezas->OldValue = $this->numpiezas->CurrentValue;
		$this->unidadcaja->CurrentValue = NULL;
		$this->unidadcaja->OldValue = $this->unidadcaja->CurrentValue;
		$this->diasventa->CurrentValue = NULL;
		$this->diasventa->OldValue = $this->diasventa->CurrentValue;
		$this->fecha_reg->CurrentValue = NULL;
		$this->fecha_reg->OldValue = $this->fecha_reg->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'idempresa' first before field var 'x_idempresa'
		$val = $CurrentForm->hasValue("idempresa") ? $CurrentForm->getValue("idempresa") : $CurrentForm->getValue("x_idempresa");
		if (!$this->idempresa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idempresa->Visible = FALSE; // Disable update for API request
			else
				$this->idempresa->setFormValue($val);
		}

		// Check field name 'idarticuloemp' first before field var 'x_idarticuloemp'
		$val = $CurrentForm->hasValue("idarticuloemp") ? $CurrentForm->getValue("idarticuloemp") : $CurrentForm->getValue("x_idarticuloemp");
		if (!$this->idarticuloemp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idarticuloemp->Visible = FALSE; // Disable update for API request
			else
				$this->idarticuloemp->setFormValue($val);
		}

		// Check field name 'codproveedor' first before field var 'x_codproveedor'
		$val = $CurrentForm->hasValue("codproveedor") ? $CurrentForm->getValue("codproveedor") : $CurrentForm->getValue("x_codproveedor");
		if (!$this->codproveedor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codproveedor->Visible = FALSE; // Disable update for API request
			else
				$this->codproveedor->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'coddum' first before field var 'x_coddum'
		$val = $CurrentForm->hasValue("coddum") ? $CurrentForm->getValue("coddum") : $CurrentForm->getValue("x_coddum");
		if (!$this->coddum->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->coddum->Visible = FALSE; // Disable update for API request
			else
				$this->coddum->setFormValue($val);
		}

		// Check field name 'descripcion' first before field var 'x_descripcion'
		$val = $CurrentForm->hasValue("descripcion") ? $CurrentForm->getValue("descripcion") : $CurrentForm->getValue("x_descripcion");
		if (!$this->descripcion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcion->Visible = FALSE; // Disable update for API request
			else
				$this->descripcion->setFormValue($val);
		}

		// Check field name 'descripcioncorta' first before field var 'x_descripcioncorta'
		$val = $CurrentForm->hasValue("descripcioncorta") ? $CurrentForm->getValue("descripcioncorta") : $CurrentForm->getValue("x_descripcioncorta");
		if (!$this->descripcioncorta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcioncorta->Visible = FALSE; // Disable update for API request
			else
				$this->descripcioncorta->setFormValue($val);
		}

		// Check field name 'idcategoria' first before field var 'x_idcategoria'
		$val = $CurrentForm->hasValue("idcategoria") ? $CurrentForm->getValue("idcategoria") : $CurrentForm->getValue("x_idcategoria");
		if (!$this->idcategoria->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idcategoria->Visible = FALSE; // Disable update for API request
			else
				$this->idcategoria->setFormValue($val);
		}

		// Check field name 'articuloaltura' first before field var 'x_articuloaltura'
		$val = $CurrentForm->hasValue("articuloaltura") ? $CurrentForm->getValue("articuloaltura") : $CurrentForm->getValue("x_articuloaltura");
		if (!$this->articuloaltura->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->articuloaltura->Visible = FALSE; // Disable update for API request
			else
				$this->articuloaltura->setFormValue($val);
		}

		// Check field name 'articuloancho' first before field var 'x_articuloancho'
		$val = $CurrentForm->hasValue("articuloancho") ? $CurrentForm->getValue("articuloancho") : $CurrentForm->getValue("x_articuloancho");
		if (!$this->articuloancho->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->articuloancho->Visible = FALSE; // Disable update for API request
			else
				$this->articuloancho->setFormValue($val);
		}

		// Check field name 'articulolargo' first before field var 'x_articulolargo'
		$val = $CurrentForm->hasValue("articulolargo") ? $CurrentForm->getValue("articulolargo") : $CurrentForm->getValue("x_articulolargo");
		if (!$this->articulolargo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->articulolargo->Visible = FALSE; // Disable update for API request
			else
				$this->articulolargo->setFormValue($val);
		}

		// Check field name 'articulopeso' first before field var 'x_articulopeso'
		$val = $CurrentForm->hasValue("articulopeso") ? $CurrentForm->getValue("articulopeso") : $CurrentForm->getValue("x_articulopeso");
		if (!$this->articulopeso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->articulopeso->Visible = FALSE; // Disable update for API request
			else
				$this->articulopeso->setFormValue($val);
		}

		// Check field name 'articulocosto' first before field var 'x_articulocosto'
		$val = $CurrentForm->hasValue("articulocosto") ? $CurrentForm->getValue("articulocosto") : $CurrentForm->getValue("x_articulocosto");
		if (!$this->articulocosto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->articulocosto->Visible = FALSE; // Disable update for API request
			else
				$this->articulocosto->setFormValue($val);
		}

		// Check field name 'cajaaltura' first before field var 'x_cajaaltura'
		$val = $CurrentForm->hasValue("cajaaltura") ? $CurrentForm->getValue("cajaaltura") : $CurrentForm->getValue("x_cajaaltura");
		if (!$this->cajaaltura->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cajaaltura->Visible = FALSE; // Disable update for API request
			else
				$this->cajaaltura->setFormValue($val);
		}

		// Check field name 'cajaancho' first before field var 'x_cajaancho'
		$val = $CurrentForm->hasValue("cajaancho") ? $CurrentForm->getValue("cajaancho") : $CurrentForm->getValue("x_cajaancho");
		if (!$this->cajaancho->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cajaancho->Visible = FALSE; // Disable update for API request
			else
				$this->cajaancho->setFormValue($val);
		}

		// Check field name 'cajalargo' first before field var 'x_cajalargo'
		$val = $CurrentForm->hasValue("cajalargo") ? $CurrentForm->getValue("cajalargo") : $CurrentForm->getValue("x_cajalargo");
		if (!$this->cajalargo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cajalargo->Visible = FALSE; // Disable update for API request
			else
				$this->cajalargo->setFormValue($val);
		}

		// Check field name 'cajapeso' first before field var 'x_cajapeso'
		$val = $CurrentForm->hasValue("cajapeso") ? $CurrentForm->getValue("cajapeso") : $CurrentForm->getValue("x_cajapeso");
		if (!$this->cajapeso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cajapeso->Visible = FALSE; // Disable update for API request
			else
				$this->cajapeso->setFormValue($val);
		}

		// Check field name 'numpiezas' first before field var 'x_numpiezas'
		$val = $CurrentForm->hasValue("numpiezas") ? $CurrentForm->getValue("numpiezas") : $CurrentForm->getValue("x_numpiezas");
		if (!$this->numpiezas->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numpiezas->Visible = FALSE; // Disable update for API request
			else
				$this->numpiezas->setFormValue($val);
		}

		// Check field name 'unidadcaja' first before field var 'x_unidadcaja'
		$val = $CurrentForm->hasValue("unidadcaja") ? $CurrentForm->getValue("unidadcaja") : $CurrentForm->getValue("x_unidadcaja");
		if (!$this->unidadcaja->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unidadcaja->Visible = FALSE; // Disable update for API request
			else
				$this->unidadcaja->setFormValue($val);
		}

		// Check field name 'diasventa' first before field var 'x_diasventa'
		$val = $CurrentForm->hasValue("diasventa") ? $CurrentForm->getValue("diasventa") : $CurrentForm->getValue("x_diasventa");
		if (!$this->diasventa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diasventa->Visible = FALSE; // Disable update for API request
			else
				$this->diasventa->setFormValue($val);
		}

		// Check field name 'fecha_reg' first before field var 'x_fecha_reg'
		$val = $CurrentForm->hasValue("fecha_reg") ? $CurrentForm->getValue("fecha_reg") : $CurrentForm->getValue("x_fecha_reg");
		if (!$this->fecha_reg->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_reg->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_reg->setFormValue($val);
			$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
		}

		// Check field name 'id_reg' first before field var 'x_id_reg'
		$val = $CurrentForm->hasValue("id_reg") ? $CurrentForm->getValue("id_reg") : $CurrentForm->getValue("x_id_reg");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->idempresa->CurrentValue = $this->idempresa->FormValue;
		$this->idarticuloemp->CurrentValue = $this->idarticuloemp->FormValue;
		$this->codproveedor->CurrentValue = $this->codproveedor->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->coddum->CurrentValue = $this->coddum->FormValue;
		$this->descripcion->CurrentValue = $this->descripcion->FormValue;
		$this->descripcioncorta->CurrentValue = $this->descripcioncorta->FormValue;
		$this->idcategoria->CurrentValue = $this->idcategoria->FormValue;
		$this->articuloaltura->CurrentValue = $this->articuloaltura->FormValue;
		$this->articuloancho->CurrentValue = $this->articuloancho->FormValue;
		$this->articulolargo->CurrentValue = $this->articulolargo->FormValue;
		$this->articulopeso->CurrentValue = $this->articulopeso->FormValue;
		$this->articulocosto->CurrentValue = $this->articulocosto->FormValue;
		$this->cajaaltura->CurrentValue = $this->cajaaltura->FormValue;
		$this->cajaancho->CurrentValue = $this->cajaancho->FormValue;
		$this->cajalargo->CurrentValue = $this->cajalargo->FormValue;
		$this->cajapeso->CurrentValue = $this->cajapeso->FormValue;
		$this->numpiezas->CurrentValue = $this->numpiezas->FormValue;
		$this->unidadcaja->CurrentValue = $this->unidadcaja->FormValue;
		$this->diasventa->CurrentValue = $this->diasventa->FormValue;
		$this->fecha_reg->CurrentValue = $this->fecha_reg->FormValue;
		$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_reg->setDbValue($row['id_reg']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->idarticuloemp->setDbValue($row['idarticuloemp']);
		$this->codproveedor->setDbValue($row['codproveedor']);
		$this->estado->setDbValue($row['estado']);
		$this->coddum->setDbValue($row['coddum']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcioncorta->setDbValue($row['descripcioncorta']);
		$this->idcategoria->setDbValue($row['idcategoria']);
		$this->articuloaltura->setDbValue($row['articuloaltura']);
		$this->articuloancho->setDbValue($row['articuloancho']);
		$this->articulolargo->setDbValue($row['articulolargo']);
		$this->articulopeso->setDbValue($row['articulopeso']);
		$this->articulocosto->setDbValue($row['articulocosto']);
		$this->cajaaltura->setDbValue($row['cajaaltura']);
		$this->cajaancho->setDbValue($row['cajaancho']);
		$this->cajalargo->setDbValue($row['cajalargo']);
		$this->cajapeso->setDbValue($row['cajapeso']);
		$this->numpiezas->setDbValue($row['numpiezas']);
		$this->unidadcaja->setDbValue($row['unidadcaja']);
		$this->diasventa->setDbValue($row['diasventa']);
		$this->fecha_reg->setDbValue($row['fecha_reg']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id_reg'] = $this->id_reg->CurrentValue;
		$row['idempresa'] = $this->idempresa->CurrentValue;
		$row['idarticuloemp'] = $this->idarticuloemp->CurrentValue;
		$row['codproveedor'] = $this->codproveedor->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		$row['coddum'] = $this->coddum->CurrentValue;
		$row['descripcion'] = $this->descripcion->CurrentValue;
		$row['descripcioncorta'] = $this->descripcioncorta->CurrentValue;
		$row['idcategoria'] = $this->idcategoria->CurrentValue;
		$row['articuloaltura'] = $this->articuloaltura->CurrentValue;
		$row['articuloancho'] = $this->articuloancho->CurrentValue;
		$row['articulolargo'] = $this->articulolargo->CurrentValue;
		$row['articulopeso'] = $this->articulopeso->CurrentValue;
		$row['articulocosto'] = $this->articulocosto->CurrentValue;
		$row['cajaaltura'] = $this->cajaaltura->CurrentValue;
		$row['cajaancho'] = $this->cajaancho->CurrentValue;
		$row['cajalargo'] = $this->cajalargo->CurrentValue;
		$row['cajapeso'] = $this->cajapeso->CurrentValue;
		$row['numpiezas'] = $this->numpiezas->CurrentValue;
		$row['unidadcaja'] = $this->unidadcaja->CurrentValue;
		$row['diasventa'] = $this->diasventa->CurrentValue;
		$row['fecha_reg'] = $this->fecha_reg->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_reg")) != "")
			$this->id_reg->OldValue = $this->getKey("id_reg"); // id_reg
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->articuloaltura->FormValue == $this->articuloaltura->CurrentValue && is_numeric(ConvertToFloatString($this->articuloaltura->CurrentValue)))
			$this->articuloaltura->CurrentValue = ConvertToFloatString($this->articuloaltura->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articuloancho->FormValue == $this->articuloancho->CurrentValue && is_numeric(ConvertToFloatString($this->articuloancho->CurrentValue)))
			$this->articuloancho->CurrentValue = ConvertToFloatString($this->articuloancho->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulolargo->FormValue == $this->articulolargo->CurrentValue && is_numeric(ConvertToFloatString($this->articulolargo->CurrentValue)))
			$this->articulolargo->CurrentValue = ConvertToFloatString($this->articulolargo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulopeso->FormValue == $this->articulopeso->CurrentValue && is_numeric(ConvertToFloatString($this->articulopeso->CurrentValue)))
			$this->articulopeso->CurrentValue = ConvertToFloatString($this->articulopeso->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulocosto->FormValue == $this->articulocosto->CurrentValue && is_numeric(ConvertToFloatString($this->articulocosto->CurrentValue)))
			$this->articulocosto->CurrentValue = ConvertToFloatString($this->articulocosto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajaaltura->FormValue == $this->cajaaltura->CurrentValue && is_numeric(ConvertToFloatString($this->cajaaltura->CurrentValue)))
			$this->cajaaltura->CurrentValue = ConvertToFloatString($this->cajaaltura->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajaancho->FormValue == $this->cajaancho->CurrentValue && is_numeric(ConvertToFloatString($this->cajaancho->CurrentValue)))
			$this->cajaancho->CurrentValue = ConvertToFloatString($this->cajaancho->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajalargo->FormValue == $this->cajalargo->CurrentValue && is_numeric(ConvertToFloatString($this->cajalargo->CurrentValue)))
			$this->cajalargo->CurrentValue = ConvertToFloatString($this->cajalargo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajapeso->FormValue == $this->cajapeso->CurrentValue && is_numeric(ConvertToFloatString($this->cajapeso->CurrentValue)))
			$this->cajapeso->CurrentValue = ConvertToFloatString($this->cajapeso->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_reg
		// idempresa
		// idarticuloemp
		// codproveedor
		// estado
		// coddum
		// descripcion
		// descripcioncorta
		// idcategoria
		// articuloaltura
		// articuloancho
		// articulolargo
		// articulopeso
		// articulocosto
		// cajaaltura
		// cajaancho
		// cajalargo
		// cajapeso
		// numpiezas
		// unidadcaja
		// diasventa
		// fecha_reg

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_reg
			$this->id_reg->ViewValue = $this->id_reg->CurrentValue;
			$this->id_reg->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// idarticuloemp
			$this->idarticuloemp->ViewValue = $this->idarticuloemp->CurrentValue;
			$this->idarticuloemp->ViewCustomAttributes = "";

			// codproveedor
			$this->codproveedor->ViewValue = $this->codproveedor->CurrentValue;
			$this->codproveedor->ViewValue = FormatNumber($this->codproveedor->ViewValue, 0, -2, -2, -2);
			$this->codproveedor->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewCustomAttributes = "";

			// coddum
			$this->coddum->ViewValue = $this->coddum->CurrentValue;
			$this->coddum->ViewCustomAttributes = "";

			// descripcion
			$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
			$this->descripcion->ViewCustomAttributes = "";

			// descripcioncorta
			$this->descripcioncorta->ViewValue = $this->descripcioncorta->CurrentValue;
			$this->descripcioncorta->ViewCustomAttributes = "";

			// idcategoria
			$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
			$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
			$this->idcategoria->ViewCustomAttributes = "";

			// articuloaltura
			$this->articuloaltura->ViewValue = $this->articuloaltura->CurrentValue;
			$this->articuloaltura->ViewValue = FormatNumber($this->articuloaltura->ViewValue, 2, -2, -2, -2);
			$this->articuloaltura->ViewCustomAttributes = "";

			// articuloancho
			$this->articuloancho->ViewValue = $this->articuloancho->CurrentValue;
			$this->articuloancho->ViewValue = FormatNumber($this->articuloancho->ViewValue, 2, -2, -2, -2);
			$this->articuloancho->ViewCustomAttributes = "";

			// articulolargo
			$this->articulolargo->ViewValue = $this->articulolargo->CurrentValue;
			$this->articulolargo->ViewValue = FormatNumber($this->articulolargo->ViewValue, 2, -2, -2, -2);
			$this->articulolargo->ViewCustomAttributes = "";

			// articulopeso
			$this->articulopeso->ViewValue = $this->articulopeso->CurrentValue;
			$this->articulopeso->ViewValue = FormatNumber($this->articulopeso->ViewValue, 2, -2, -2, -2);
			$this->articulopeso->ViewCustomAttributes = "";

			// articulocosto
			$this->articulocosto->ViewValue = $this->articulocosto->CurrentValue;
			$this->articulocosto->ViewValue = FormatNumber($this->articulocosto->ViewValue, 2, -2, -2, -2);
			$this->articulocosto->ViewCustomAttributes = "";

			// cajaaltura
			$this->cajaaltura->ViewValue = $this->cajaaltura->CurrentValue;
			$this->cajaaltura->ViewValue = FormatNumber($this->cajaaltura->ViewValue, 2, -2, -2, -2);
			$this->cajaaltura->ViewCustomAttributes = "";

			// cajaancho
			$this->cajaancho->ViewValue = $this->cajaancho->CurrentValue;
			$this->cajaancho->ViewValue = FormatNumber($this->cajaancho->ViewValue, 2, -2, -2, -2);
			$this->cajaancho->ViewCustomAttributes = "";

			// cajalargo
			$this->cajalargo->ViewValue = $this->cajalargo->CurrentValue;
			$this->cajalargo->ViewValue = FormatNumber($this->cajalargo->ViewValue, 2, -2, -2, -2);
			$this->cajalargo->ViewCustomAttributes = "";

			// cajapeso
			$this->cajapeso->ViewValue = $this->cajapeso->CurrentValue;
			$this->cajapeso->ViewValue = FormatNumber($this->cajapeso->ViewValue, 2, -2, -2, -2);
			$this->cajapeso->ViewCustomAttributes = "";

			// numpiezas
			$this->numpiezas->ViewValue = $this->numpiezas->CurrentValue;
			$this->numpiezas->ViewValue = FormatNumber($this->numpiezas->ViewValue, 0, -2, -2, -2);
			$this->numpiezas->ViewCustomAttributes = "";

			// unidadcaja
			$this->unidadcaja->ViewValue = $this->unidadcaja->CurrentValue;
			$this->unidadcaja->ViewValue = FormatNumber($this->unidadcaja->ViewValue, 0, -2, -2, -2);
			$this->unidadcaja->ViewCustomAttributes = "";

			// diasventa
			$this->diasventa->ViewValue = $this->diasventa->CurrentValue;
			$this->diasventa->ViewCustomAttributes = "";

			// fecha_reg
			$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
			$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
			$this->fecha_reg->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// idarticuloemp
			$this->idarticuloemp->LinkCustomAttributes = "";
			$this->idarticuloemp->HrefValue = "";
			$this->idarticuloemp->TooltipValue = "";

			// codproveedor
			$this->codproveedor->LinkCustomAttributes = "";
			$this->codproveedor->HrefValue = "";
			$this->codproveedor->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// coddum
			$this->coddum->LinkCustomAttributes = "";
			$this->coddum->HrefValue = "";
			$this->coddum->TooltipValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";
			$this->descripcion->TooltipValue = "";

			// descripcioncorta
			$this->descripcioncorta->LinkCustomAttributes = "";
			$this->descripcioncorta->HrefValue = "";
			$this->descripcioncorta->TooltipValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";
			$this->idcategoria->TooltipValue = "";

			// articuloaltura
			$this->articuloaltura->LinkCustomAttributes = "";
			$this->articuloaltura->HrefValue = "";
			$this->articuloaltura->TooltipValue = "";

			// articuloancho
			$this->articuloancho->LinkCustomAttributes = "";
			$this->articuloancho->HrefValue = "";
			$this->articuloancho->TooltipValue = "";

			// articulolargo
			$this->articulolargo->LinkCustomAttributes = "";
			$this->articulolargo->HrefValue = "";
			$this->articulolargo->TooltipValue = "";

			// articulopeso
			$this->articulopeso->LinkCustomAttributes = "";
			$this->articulopeso->HrefValue = "";
			$this->articulopeso->TooltipValue = "";

			// articulocosto
			$this->articulocosto->LinkCustomAttributes = "";
			$this->articulocosto->HrefValue = "";
			$this->articulocosto->TooltipValue = "";

			// cajaaltura
			$this->cajaaltura->LinkCustomAttributes = "";
			$this->cajaaltura->HrefValue = "";
			$this->cajaaltura->TooltipValue = "";

			// cajaancho
			$this->cajaancho->LinkCustomAttributes = "";
			$this->cajaancho->HrefValue = "";
			$this->cajaancho->TooltipValue = "";

			// cajalargo
			$this->cajalargo->LinkCustomAttributes = "";
			$this->cajalargo->HrefValue = "";
			$this->cajalargo->TooltipValue = "";

			// cajapeso
			$this->cajapeso->LinkCustomAttributes = "";
			$this->cajapeso->HrefValue = "";
			$this->cajapeso->TooltipValue = "";

			// numpiezas
			$this->numpiezas->LinkCustomAttributes = "";
			$this->numpiezas->HrefValue = "";
			$this->numpiezas->TooltipValue = "";

			// unidadcaja
			$this->unidadcaja->LinkCustomAttributes = "";
			$this->unidadcaja->HrefValue = "";
			$this->unidadcaja->TooltipValue = "";

			// diasventa
			$this->diasventa->LinkCustomAttributes = "";
			$this->diasventa->HrefValue = "";
			$this->diasventa->TooltipValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
			$this->fecha_reg->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// idempresa
			$this->idempresa->EditAttrs["class"] = "form-control";
			$this->idempresa->EditCustomAttributes = "";
			$this->idempresa->EditValue = HtmlEncode($this->idempresa->CurrentValue);
			$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

			// idarticuloemp
			$this->idarticuloemp->EditAttrs["class"] = "form-control";
			$this->idarticuloemp->EditCustomAttributes = "";
			if (!$this->idarticuloemp->Raw)
				$this->idarticuloemp->CurrentValue = HtmlDecode($this->idarticuloemp->CurrentValue);
			$this->idarticuloemp->EditValue = HtmlEncode($this->idarticuloemp->CurrentValue);
			$this->idarticuloemp->PlaceHolder = RemoveHtml($this->idarticuloemp->caption());

			// codproveedor
			$this->codproveedor->EditAttrs["class"] = "form-control";
			$this->codproveedor->EditCustomAttributes = "";
			$this->codproveedor->EditValue = HtmlEncode($this->codproveedor->CurrentValue);
			$this->codproveedor->PlaceHolder = RemoveHtml($this->codproveedor->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			if (!$this->estado->Raw)
				$this->estado->CurrentValue = HtmlDecode($this->estado->CurrentValue);
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// coddum
			$this->coddum->EditAttrs["class"] = "form-control";
			$this->coddum->EditCustomAttributes = "";
			if (!$this->coddum->Raw)
				$this->coddum->CurrentValue = HtmlDecode($this->coddum->CurrentValue);
			$this->coddum->EditValue = HtmlEncode($this->coddum->CurrentValue);
			$this->coddum->PlaceHolder = RemoveHtml($this->coddum->caption());

			// descripcion
			$this->descripcion->EditAttrs["class"] = "form-control";
			$this->descripcion->EditCustomAttributes = "";
			if (!$this->descripcion->Raw)
				$this->descripcion->CurrentValue = HtmlDecode($this->descripcion->CurrentValue);
			$this->descripcion->EditValue = HtmlEncode($this->descripcion->CurrentValue);
			$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

			// descripcioncorta
			$this->descripcioncorta->EditAttrs["class"] = "form-control";
			$this->descripcioncorta->EditCustomAttributes = "";
			if (!$this->descripcioncorta->Raw)
				$this->descripcioncorta->CurrentValue = HtmlDecode($this->descripcioncorta->CurrentValue);
			$this->descripcioncorta->EditValue = HtmlEncode($this->descripcioncorta->CurrentValue);
			$this->descripcioncorta->PlaceHolder = RemoveHtml($this->descripcioncorta->caption());

			// idcategoria
			$this->idcategoria->EditAttrs["class"] = "form-control";
			$this->idcategoria->EditCustomAttributes = "";
			$this->idcategoria->EditValue = HtmlEncode($this->idcategoria->CurrentValue);
			$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

			// articuloaltura
			$this->articuloaltura->EditAttrs["class"] = "form-control";
			$this->articuloaltura->EditCustomAttributes = "";
			$this->articuloaltura->EditValue = HtmlEncode($this->articuloaltura->CurrentValue);
			$this->articuloaltura->PlaceHolder = RemoveHtml($this->articuloaltura->caption());
			if (strval($this->articuloaltura->EditValue) != "" && is_numeric($this->articuloaltura->EditValue))
				$this->articuloaltura->EditValue = FormatNumber($this->articuloaltura->EditValue, -2, -2, -2, -2);
			

			// articuloancho
			$this->articuloancho->EditAttrs["class"] = "form-control";
			$this->articuloancho->EditCustomAttributes = "";
			$this->articuloancho->EditValue = HtmlEncode($this->articuloancho->CurrentValue);
			$this->articuloancho->PlaceHolder = RemoveHtml($this->articuloancho->caption());
			if (strval($this->articuloancho->EditValue) != "" && is_numeric($this->articuloancho->EditValue))
				$this->articuloancho->EditValue = FormatNumber($this->articuloancho->EditValue, -2, -2, -2, -2);
			

			// articulolargo
			$this->articulolargo->EditAttrs["class"] = "form-control";
			$this->articulolargo->EditCustomAttributes = "";
			$this->articulolargo->EditValue = HtmlEncode($this->articulolargo->CurrentValue);
			$this->articulolargo->PlaceHolder = RemoveHtml($this->articulolargo->caption());
			if (strval($this->articulolargo->EditValue) != "" && is_numeric($this->articulolargo->EditValue))
				$this->articulolargo->EditValue = FormatNumber($this->articulolargo->EditValue, -2, -2, -2, -2);
			

			// articulopeso
			$this->articulopeso->EditAttrs["class"] = "form-control";
			$this->articulopeso->EditCustomAttributes = "";
			$this->articulopeso->EditValue = HtmlEncode($this->articulopeso->CurrentValue);
			$this->articulopeso->PlaceHolder = RemoveHtml($this->articulopeso->caption());
			if (strval($this->articulopeso->EditValue) != "" && is_numeric($this->articulopeso->EditValue))
				$this->articulopeso->EditValue = FormatNumber($this->articulopeso->EditValue, -2, -2, -2, -2);
			

			// articulocosto
			$this->articulocosto->EditAttrs["class"] = "form-control";
			$this->articulocosto->EditCustomAttributes = "";
			$this->articulocosto->EditValue = HtmlEncode($this->articulocosto->CurrentValue);
			$this->articulocosto->PlaceHolder = RemoveHtml($this->articulocosto->caption());
			if (strval($this->articulocosto->EditValue) != "" && is_numeric($this->articulocosto->EditValue))
				$this->articulocosto->EditValue = FormatNumber($this->articulocosto->EditValue, -2, -2, -2, -2);
			

			// cajaaltura
			$this->cajaaltura->EditAttrs["class"] = "form-control";
			$this->cajaaltura->EditCustomAttributes = "";
			$this->cajaaltura->EditValue = HtmlEncode($this->cajaaltura->CurrentValue);
			$this->cajaaltura->PlaceHolder = RemoveHtml($this->cajaaltura->caption());
			if (strval($this->cajaaltura->EditValue) != "" && is_numeric($this->cajaaltura->EditValue))
				$this->cajaaltura->EditValue = FormatNumber($this->cajaaltura->EditValue, -2, -2, -2, -2);
			

			// cajaancho
			$this->cajaancho->EditAttrs["class"] = "form-control";
			$this->cajaancho->EditCustomAttributes = "";
			$this->cajaancho->EditValue = HtmlEncode($this->cajaancho->CurrentValue);
			$this->cajaancho->PlaceHolder = RemoveHtml($this->cajaancho->caption());
			if (strval($this->cajaancho->EditValue) != "" && is_numeric($this->cajaancho->EditValue))
				$this->cajaancho->EditValue = FormatNumber($this->cajaancho->EditValue, -2, -2, -2, -2);
			

			// cajalargo
			$this->cajalargo->EditAttrs["class"] = "form-control";
			$this->cajalargo->EditCustomAttributes = "";
			$this->cajalargo->EditValue = HtmlEncode($this->cajalargo->CurrentValue);
			$this->cajalargo->PlaceHolder = RemoveHtml($this->cajalargo->caption());
			if (strval($this->cajalargo->EditValue) != "" && is_numeric($this->cajalargo->EditValue))
				$this->cajalargo->EditValue = FormatNumber($this->cajalargo->EditValue, -2, -2, -2, -2);
			

			// cajapeso
			$this->cajapeso->EditAttrs["class"] = "form-control";
			$this->cajapeso->EditCustomAttributes = "";
			$this->cajapeso->EditValue = HtmlEncode($this->cajapeso->CurrentValue);
			$this->cajapeso->PlaceHolder = RemoveHtml($this->cajapeso->caption());
			if (strval($this->cajapeso->EditValue) != "" && is_numeric($this->cajapeso->EditValue))
				$this->cajapeso->EditValue = FormatNumber($this->cajapeso->EditValue, -2, -2, -2, -2);
			

			// numpiezas
			$this->numpiezas->EditAttrs["class"] = "form-control";
			$this->numpiezas->EditCustomAttributes = "";
			$this->numpiezas->EditValue = HtmlEncode($this->numpiezas->CurrentValue);
			$this->numpiezas->PlaceHolder = RemoveHtml($this->numpiezas->caption());

			// unidadcaja
			$this->unidadcaja->EditAttrs["class"] = "form-control";
			$this->unidadcaja->EditCustomAttributes = "";
			$this->unidadcaja->EditValue = HtmlEncode($this->unidadcaja->CurrentValue);
			$this->unidadcaja->PlaceHolder = RemoveHtml($this->unidadcaja->caption());

			// diasventa
			$this->diasventa->EditAttrs["class"] = "form-control";
			$this->diasventa->EditCustomAttributes = "";
			if (!$this->diasventa->Raw)
				$this->diasventa->CurrentValue = HtmlDecode($this->diasventa->CurrentValue);
			$this->diasventa->EditValue = HtmlEncode($this->diasventa->CurrentValue);
			$this->diasventa->PlaceHolder = RemoveHtml($this->diasventa->caption());

			// fecha_reg
			$this->fecha_reg->EditAttrs["class"] = "form-control";
			$this->fecha_reg->EditCustomAttributes = "";
			$this->fecha_reg->EditValue = HtmlEncode(FormatDateTime($this->fecha_reg->CurrentValue, 8));
			$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

			// Add refer script
			// idempresa

			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";

			// idarticuloemp
			$this->idarticuloemp->LinkCustomAttributes = "";
			$this->idarticuloemp->HrefValue = "";

			// codproveedor
			$this->codproveedor->LinkCustomAttributes = "";
			$this->codproveedor->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// coddum
			$this->coddum->LinkCustomAttributes = "";
			$this->coddum->HrefValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";

			// descripcioncorta
			$this->descripcioncorta->LinkCustomAttributes = "";
			$this->descripcioncorta->HrefValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";

			// articuloaltura
			$this->articuloaltura->LinkCustomAttributes = "";
			$this->articuloaltura->HrefValue = "";

			// articuloancho
			$this->articuloancho->LinkCustomAttributes = "";
			$this->articuloancho->HrefValue = "";

			// articulolargo
			$this->articulolargo->LinkCustomAttributes = "";
			$this->articulolargo->HrefValue = "";

			// articulopeso
			$this->articulopeso->LinkCustomAttributes = "";
			$this->articulopeso->HrefValue = "";

			// articulocosto
			$this->articulocosto->LinkCustomAttributes = "";
			$this->articulocosto->HrefValue = "";

			// cajaaltura
			$this->cajaaltura->LinkCustomAttributes = "";
			$this->cajaaltura->HrefValue = "";

			// cajaancho
			$this->cajaancho->LinkCustomAttributes = "";
			$this->cajaancho->HrefValue = "";

			// cajalargo
			$this->cajalargo->LinkCustomAttributes = "";
			$this->cajalargo->HrefValue = "";

			// cajapeso
			$this->cajapeso->LinkCustomAttributes = "";
			$this->cajapeso->HrefValue = "";

			// numpiezas
			$this->numpiezas->LinkCustomAttributes = "";
			$this->numpiezas->HrefValue = "";

			// unidadcaja
			$this->unidadcaja->LinkCustomAttributes = "";
			$this->unidadcaja->HrefValue = "";

			// diasventa
			$this->diasventa->LinkCustomAttributes = "";
			$this->diasventa->HrefValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->idempresa->Required) {
			if (!$this->idempresa->IsDetailKey && $this->idempresa->FormValue != NULL && $this->idempresa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idempresa->caption(), $this->idempresa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idempresa->FormValue)) {
			AddMessage($FormError, $this->idempresa->errorMessage());
		}
		if ($this->idarticuloemp->Required) {
			if (!$this->idarticuloemp->IsDetailKey && $this->idarticuloemp->FormValue != NULL && $this->idarticuloemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idarticuloemp->caption(), $this->idarticuloemp->RequiredErrorMessage));
			}
		}
		if ($this->codproveedor->Required) {
			if (!$this->codproveedor->IsDetailKey && $this->codproveedor->FormValue != NULL && $this->codproveedor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codproveedor->caption(), $this->codproveedor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->codproveedor->FormValue)) {
			AddMessage($FormError, $this->codproveedor->errorMessage());
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if ($this->coddum->Required) {
			if (!$this->coddum->IsDetailKey && $this->coddum->FormValue != NULL && $this->coddum->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->coddum->caption(), $this->coddum->RequiredErrorMessage));
			}
		}
		if ($this->descripcion->Required) {
			if (!$this->descripcion->IsDetailKey && $this->descripcion->FormValue != NULL && $this->descripcion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcion->caption(), $this->descripcion->RequiredErrorMessage));
			}
		}
		if ($this->descripcioncorta->Required) {
			if (!$this->descripcioncorta->IsDetailKey && $this->descripcioncorta->FormValue != NULL && $this->descripcioncorta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcioncorta->caption(), $this->descripcioncorta->RequiredErrorMessage));
			}
		}
		if ($this->idcategoria->Required) {
			if (!$this->idcategoria->IsDetailKey && $this->idcategoria->FormValue != NULL && $this->idcategoria->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idcategoria->caption(), $this->idcategoria->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idcategoria->FormValue)) {
			AddMessage($FormError, $this->idcategoria->errorMessage());
		}
		if ($this->articuloaltura->Required) {
			if (!$this->articuloaltura->IsDetailKey && $this->articuloaltura->FormValue != NULL && $this->articuloaltura->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->articuloaltura->caption(), $this->articuloaltura->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->articuloaltura->FormValue)) {
			AddMessage($FormError, $this->articuloaltura->errorMessage());
		}
		if ($this->articuloancho->Required) {
			if (!$this->articuloancho->IsDetailKey && $this->articuloancho->FormValue != NULL && $this->articuloancho->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->articuloancho->caption(), $this->articuloancho->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->articuloancho->FormValue)) {
			AddMessage($FormError, $this->articuloancho->errorMessage());
		}
		if ($this->articulolargo->Required) {
			if (!$this->articulolargo->IsDetailKey && $this->articulolargo->FormValue != NULL && $this->articulolargo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->articulolargo->caption(), $this->articulolargo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->articulolargo->FormValue)) {
			AddMessage($FormError, $this->articulolargo->errorMessage());
		}
		if ($this->articulopeso->Required) {
			if (!$this->articulopeso->IsDetailKey && $this->articulopeso->FormValue != NULL && $this->articulopeso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->articulopeso->caption(), $this->articulopeso->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->articulopeso->FormValue)) {
			AddMessage($FormError, $this->articulopeso->errorMessage());
		}
		if ($this->articulocosto->Required) {
			if (!$this->articulocosto->IsDetailKey && $this->articulocosto->FormValue != NULL && $this->articulocosto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->articulocosto->caption(), $this->articulocosto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->articulocosto->FormValue)) {
			AddMessage($FormError, $this->articulocosto->errorMessage());
		}
		if ($this->cajaaltura->Required) {
			if (!$this->cajaaltura->IsDetailKey && $this->cajaaltura->FormValue != NULL && $this->cajaaltura->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cajaaltura->caption(), $this->cajaaltura->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cajaaltura->FormValue)) {
			AddMessage($FormError, $this->cajaaltura->errorMessage());
		}
		if ($this->cajaancho->Required) {
			if (!$this->cajaancho->IsDetailKey && $this->cajaancho->FormValue != NULL && $this->cajaancho->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cajaancho->caption(), $this->cajaancho->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cajaancho->FormValue)) {
			AddMessage($FormError, $this->cajaancho->errorMessage());
		}
		if ($this->cajalargo->Required) {
			if (!$this->cajalargo->IsDetailKey && $this->cajalargo->FormValue != NULL && $this->cajalargo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cajalargo->caption(), $this->cajalargo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cajalargo->FormValue)) {
			AddMessage($FormError, $this->cajalargo->errorMessage());
		}
		if ($this->cajapeso->Required) {
			if (!$this->cajapeso->IsDetailKey && $this->cajapeso->FormValue != NULL && $this->cajapeso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cajapeso->caption(), $this->cajapeso->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cajapeso->FormValue)) {
			AddMessage($FormError, $this->cajapeso->errorMessage());
		}
		if ($this->numpiezas->Required) {
			if (!$this->numpiezas->IsDetailKey && $this->numpiezas->FormValue != NULL && $this->numpiezas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numpiezas->caption(), $this->numpiezas->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->numpiezas->FormValue)) {
			AddMessage($FormError, $this->numpiezas->errorMessage());
		}
		if ($this->unidadcaja->Required) {
			if (!$this->unidadcaja->IsDetailKey && $this->unidadcaja->FormValue != NULL && $this->unidadcaja->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unidadcaja->caption(), $this->unidadcaja->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unidadcaja->FormValue)) {
			AddMessage($FormError, $this->unidadcaja->errorMessage());
		}
		if ($this->diasventa->Required) {
			if (!$this->diasventa->IsDetailKey && $this->diasventa->FormValue != NULL && $this->diasventa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diasventa->caption(), $this->diasventa->RequiredErrorMessage));
			}
		}
		if ($this->fecha_reg->Required) {
			if (!$this->fecha_reg->IsDetailKey && $this->fecha_reg->FormValue != NULL && $this->fecha_reg->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_reg->caption(), $this->fecha_reg->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha_reg->FormValue)) {
			AddMessage($FormError, $this->fecha_reg->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// idempresa
		$this->idempresa->setDbValueDef($rsnew, $this->idempresa->CurrentValue, 0, FALSE);

		// idarticuloemp
		$this->idarticuloemp->setDbValueDef($rsnew, $this->idarticuloemp->CurrentValue, "", FALSE);

		// codproveedor
		$this->codproveedor->setDbValueDef($rsnew, $this->codproveedor->CurrentValue, NULL, FALSE);

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, strval($this->estado->CurrentValue) == "");

		// coddum
		$this->coddum->setDbValueDef($rsnew, $this->coddum->CurrentValue, NULL, FALSE);

		// descripcion
		$this->descripcion->setDbValueDef($rsnew, $this->descripcion->CurrentValue, "", FALSE);

		// descripcioncorta
		$this->descripcioncorta->setDbValueDef($rsnew, $this->descripcioncorta->CurrentValue, NULL, FALSE);

		// idcategoria
		$this->idcategoria->setDbValueDef($rsnew, $this->idcategoria->CurrentValue, 0, FALSE);

		// articuloaltura
		$this->articuloaltura->setDbValueDef($rsnew, $this->articuloaltura->CurrentValue, NULL, strval($this->articuloaltura->CurrentValue) == "");

		// articuloancho
		$this->articuloancho->setDbValueDef($rsnew, $this->articuloancho->CurrentValue, NULL, strval($this->articuloancho->CurrentValue) == "");

		// articulolargo
		$this->articulolargo->setDbValueDef($rsnew, $this->articulolargo->CurrentValue, NULL, strval($this->articulolargo->CurrentValue) == "");

		// articulopeso
		$this->articulopeso->setDbValueDef($rsnew, $this->articulopeso->CurrentValue, NULL, strval($this->articulopeso->CurrentValue) == "");

		// articulocosto
		$this->articulocosto->setDbValueDef($rsnew, $this->articulocosto->CurrentValue, NULL, strval($this->articulocosto->CurrentValue) == "");

		// cajaaltura
		$this->cajaaltura->setDbValueDef($rsnew, $this->cajaaltura->CurrentValue, NULL, strval($this->cajaaltura->CurrentValue) == "");

		// cajaancho
		$this->cajaancho->setDbValueDef($rsnew, $this->cajaancho->CurrentValue, NULL, strval($this->cajaancho->CurrentValue) == "");

		// cajalargo
		$this->cajalargo->setDbValueDef($rsnew, $this->cajalargo->CurrentValue, NULL, strval($this->cajalargo->CurrentValue) == "");

		// cajapeso
		$this->cajapeso->setDbValueDef($rsnew, $this->cajapeso->CurrentValue, NULL, strval($this->cajapeso->CurrentValue) == "");

		// numpiezas
		$this->numpiezas->setDbValueDef($rsnew, $this->numpiezas->CurrentValue, NULL, FALSE);

		// unidadcaja
		$this->unidadcaja->setDbValueDef($rsnew, $this->unidadcaja->CurrentValue, NULL, FALSE);

		// diasventa
		$this->diasventa->setDbValueDef($rsnew, $this->diasventa->CurrentValue, NULL, FALSE);

		// fecha_reg
		$this->fecha_reg->setDbValueDef($rsnew, UnFormatDateTime($this->fecha_reg->CurrentValue, 0), CurrentDate(), FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bkp_master_articuloslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>