<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for bkp_master_articulos
 */
class bkp_master_articulos extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_reg;
	public $idempresa;
	public $idarticuloemp;
	public $codproveedor;
	public $estado;
	public $coddum;
	public $descripcion;
	public $descripcioncorta;
	public $idcategoria;
	public $articuloaltura;
	public $articuloancho;
	public $articulolargo;
	public $articulopeso;
	public $articulocosto;
	public $cajaaltura;
	public $cajaancho;
	public $cajalargo;
	public $cajapeso;
	public $numpiezas;
	public $unidadcaja;
	public $diasventa;
	public $fecha_reg;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'bkp_master_articulos';
		$this->TableName = 'bkp_master_articulos';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`bkp_master_articulos`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_reg
		$this->id_reg = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_id_reg', 'id_reg', '`id_reg`', '`id_reg`', 3, 11, -1, FALSE, '`id_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_reg->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_reg->IsPrimaryKey = TRUE; // Primary key field
		$this->id_reg->Sortable = TRUE; // Allow sort
		$this->id_reg->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_reg'] = &$this->id_reg;

		// idempresa
		$this->idempresa = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_idempresa', 'idempresa', '`idempresa`', '`idempresa`', 3, 11, -1, FALSE, '`idempresa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idempresa->Nullable = FALSE; // NOT NULL field
		$this->idempresa->Required = TRUE; // Required field
		$this->idempresa->Sortable = TRUE; // Allow sort
		$this->idempresa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idempresa'] = &$this->idempresa;

		// idarticuloemp
		$this->idarticuloemp = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_idarticuloemp', 'idarticuloemp', '`idarticuloemp`', '`idarticuloemp`', 200, 25, -1, FALSE, '`idarticuloemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idarticuloemp->Nullable = FALSE; // NOT NULL field
		$this->idarticuloemp->Required = TRUE; // Required field
		$this->idarticuloemp->Sortable = TRUE; // Allow sort
		$this->fields['idarticuloemp'] = &$this->idarticuloemp;

		// codproveedor
		$this->codproveedor = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_codproveedor', 'codproveedor', '`codproveedor`', '`codproveedor`', 3, 11, -1, FALSE, '`codproveedor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codproveedor->Sortable = TRUE; // Allow sort
		$this->codproveedor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['codproveedor'] = &$this->codproveedor;

		// estado
		$this->estado = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_estado', 'estado', '`estado`', '`estado`', 200, 1, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->fields['estado'] = &$this->estado;

		// coddum
		$this->coddum = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_coddum', 'coddum', '`coddum`', '`coddum`', 200, 25, -1, FALSE, '`coddum`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->coddum->Sortable = TRUE; // Allow sort
		$this->fields['coddum'] = &$this->coddum;

		// descripcion
		$this->descripcion = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_descripcion', 'descripcion', '`descripcion`', '`descripcion`', 200, 100, -1, FALSE, '`descripcion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->descripcion->Nullable = FALSE; // NOT NULL field
		$this->descripcion->Required = TRUE; // Required field
		$this->descripcion->Sortable = TRUE; // Allow sort
		$this->fields['descripcion'] = &$this->descripcion;

		// descripcioncorta
		$this->descripcioncorta = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_descripcioncorta', 'descripcioncorta', '`descripcioncorta`', '`descripcioncorta`', 200, 65, -1, FALSE, '`descripcioncorta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->descripcioncorta->Sortable = TRUE; // Allow sort
		$this->fields['descripcioncorta'] = &$this->descripcioncorta;

		// idcategoria
		$this->idcategoria = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_idcategoria', 'idcategoria', '`idcategoria`', '`idcategoria`', 3, 11, -1, FALSE, '`idcategoria`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idcategoria->Nullable = FALSE; // NOT NULL field
		$this->idcategoria->Required = TRUE; // Required field
		$this->idcategoria->Sortable = TRUE; // Allow sort
		$this->idcategoria->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idcategoria'] = &$this->idcategoria;

		// articuloaltura
		$this->articuloaltura = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_articuloaltura', 'articuloaltura', '`articuloaltura`', '`articuloaltura`', 131, 6, -1, FALSE, '`articuloaltura`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->articuloaltura->Sortable = TRUE; // Allow sort
		$this->articuloaltura->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['articuloaltura'] = &$this->articuloaltura;

		// articuloancho
		$this->articuloancho = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_articuloancho', 'articuloancho', '`articuloancho`', '`articuloancho`', 131, 6, -1, FALSE, '`articuloancho`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->articuloancho->Sortable = TRUE; // Allow sort
		$this->articuloancho->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['articuloancho'] = &$this->articuloancho;

		// articulolargo
		$this->articulolargo = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_articulolargo', 'articulolargo', '`articulolargo`', '`articulolargo`', 131, 6, -1, FALSE, '`articulolargo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->articulolargo->Sortable = TRUE; // Allow sort
		$this->articulolargo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['articulolargo'] = &$this->articulolargo;

		// articulopeso
		$this->articulopeso = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_articulopeso', 'articulopeso', '`articulopeso`', '`articulopeso`', 131, 12, -1, FALSE, '`articulopeso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->articulopeso->Sortable = TRUE; // Allow sort
		$this->articulopeso->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['articulopeso'] = &$this->articulopeso;

		// articulocosto
		$this->articulocosto = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_articulocosto', 'articulocosto', '`articulocosto`', '`articulocosto`', 131, 6, -1, FALSE, '`articulocosto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->articulocosto->Sortable = TRUE; // Allow sort
		$this->articulocosto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['articulocosto'] = &$this->articulocosto;

		// cajaaltura
		$this->cajaaltura = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_cajaaltura', 'cajaaltura', '`cajaaltura`', '`cajaaltura`', 131, 7, -1, FALSE, '`cajaaltura`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cajaaltura->Sortable = TRUE; // Allow sort
		$this->cajaaltura->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cajaaltura'] = &$this->cajaaltura;

		// cajaancho
		$this->cajaancho = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_cajaancho', 'cajaancho', '`cajaancho`', '`cajaancho`', 131, 7, -1, FALSE, '`cajaancho`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cajaancho->Sortable = TRUE; // Allow sort
		$this->cajaancho->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cajaancho'] = &$this->cajaancho;

		// cajalargo
		$this->cajalargo = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_cajalargo', 'cajalargo', '`cajalargo`', '`cajalargo`', 131, 7, -1, FALSE, '`cajalargo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cajalargo->Sortable = TRUE; // Allow sort
		$this->cajalargo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cajalargo'] = &$this->cajalargo;

		// cajapeso
		$this->cajapeso = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_cajapeso', 'cajapeso', '`cajapeso`', '`cajapeso`', 131, 7, -1, FALSE, '`cajapeso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cajapeso->Sortable = TRUE; // Allow sort
		$this->cajapeso->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cajapeso'] = &$this->cajapeso;

		// numpiezas
		$this->numpiezas = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_numpiezas', 'numpiezas', '`numpiezas`', '`numpiezas`', 3, 11, -1, FALSE, '`numpiezas`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numpiezas->Sortable = TRUE; // Allow sort
		$this->numpiezas->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['numpiezas'] = &$this->numpiezas;

		// unidadcaja
		$this->unidadcaja = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_unidadcaja', 'unidadcaja', '`unidadcaja`', '`unidadcaja`', 3, 11, -1, FALSE, '`unidadcaja`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unidadcaja->Sortable = TRUE; // Allow sort
		$this->unidadcaja->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unidadcaja'] = &$this->unidadcaja;

		// diasventa
		$this->diasventa = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_diasventa', 'diasventa', '`diasventa`', '`diasventa`', 200, 5, -1, FALSE, '`diasventa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diasventa->Sortable = TRUE; // Allow sort
		$this->fields['diasventa'] = &$this->diasventa;

		// fecha_reg
		$this->fecha_reg = new DbField('bkp_master_articulos', 'bkp_master_articulos', 'x_fecha_reg', 'fecha_reg', '`fecha_reg`', CastDateFieldForLike("`fecha_reg`", 0, "DB"), 135, 19, 0, FALSE, '`fecha_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha_reg->Nullable = FALSE; // NOT NULL field
		$this->fecha_reg->Required = TRUE; // Required field
		$this->fecha_reg->Sortable = TRUE; // Allow sort
		$this->fecha_reg->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha_reg'] = &$this->fecha_reg;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`bkp_master_articulos`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_reg->setDbValue($conn->insert_ID());
			$rs['id_reg'] = $this->id_reg->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_reg', $rs))
				AddFilter($where, QuotedName('id_reg', $this->Dbid) . '=' . QuotedValue($rs['id_reg'], $this->id_reg->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_reg->DbValue = $row['id_reg'];
		$this->idempresa->DbValue = $row['idempresa'];
		$this->idarticuloemp->DbValue = $row['idarticuloemp'];
		$this->codproveedor->DbValue = $row['codproveedor'];
		$this->estado->DbValue = $row['estado'];
		$this->coddum->DbValue = $row['coddum'];
		$this->descripcion->DbValue = $row['descripcion'];
		$this->descripcioncorta->DbValue = $row['descripcioncorta'];
		$this->idcategoria->DbValue = $row['idcategoria'];
		$this->articuloaltura->DbValue = $row['articuloaltura'];
		$this->articuloancho->DbValue = $row['articuloancho'];
		$this->articulolargo->DbValue = $row['articulolargo'];
		$this->articulopeso->DbValue = $row['articulopeso'];
		$this->articulocosto->DbValue = $row['articulocosto'];
		$this->cajaaltura->DbValue = $row['cajaaltura'];
		$this->cajaancho->DbValue = $row['cajaancho'];
		$this->cajalargo->DbValue = $row['cajalargo'];
		$this->cajapeso->DbValue = $row['cajapeso'];
		$this->numpiezas->DbValue = $row['numpiezas'];
		$this->unidadcaja->DbValue = $row['unidadcaja'];
		$this->diasventa->DbValue = $row['diasventa'];
		$this->fecha_reg->DbValue = $row['fecha_reg'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_reg` = @id_reg@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_reg', $row) ? $row['id_reg'] : NULL;
		else
			$val = $this->id_reg->OldValue !== NULL ? $this->id_reg->OldValue : $this->id_reg->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_reg@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "bkp_master_articuloslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "bkp_master_articulosview.php")
			return $Language->phrase("View");
		elseif ($pageName == "bkp_master_articulosedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "bkp_master_articulosadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "bkp_master_articuloslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("bkp_master_articulosview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("bkp_master_articulosview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "bkp_master_articulosadd.php?" . $this->getUrlParm($parm);
		else
			$url = "bkp_master_articulosadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("bkp_master_articulosedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("bkp_master_articulosadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("bkp_master_articulosdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_reg:" . JsonEncode($this->id_reg->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_reg->CurrentValue != NULL) {
			$url .= "id_reg=" . urlencode($this->id_reg->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_reg") !== NULL)
				$arKeys[] = Param("id_reg");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_reg->CurrentValue = $key;
			else
				$this->id_reg->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_reg->setDbValue($rs->fields('id_reg'));
		$this->idempresa->setDbValue($rs->fields('idempresa'));
		$this->idarticuloemp->setDbValue($rs->fields('idarticuloemp'));
		$this->codproveedor->setDbValue($rs->fields('codproveedor'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->coddum->setDbValue($rs->fields('coddum'));
		$this->descripcion->setDbValue($rs->fields('descripcion'));
		$this->descripcioncorta->setDbValue($rs->fields('descripcioncorta'));
		$this->idcategoria->setDbValue($rs->fields('idcategoria'));
		$this->articuloaltura->setDbValue($rs->fields('articuloaltura'));
		$this->articuloancho->setDbValue($rs->fields('articuloancho'));
		$this->articulolargo->setDbValue($rs->fields('articulolargo'));
		$this->articulopeso->setDbValue($rs->fields('articulopeso'));
		$this->articulocosto->setDbValue($rs->fields('articulocosto'));
		$this->cajaaltura->setDbValue($rs->fields('cajaaltura'));
		$this->cajaancho->setDbValue($rs->fields('cajaancho'));
		$this->cajalargo->setDbValue($rs->fields('cajalargo'));
		$this->cajapeso->setDbValue($rs->fields('cajapeso'));
		$this->numpiezas->setDbValue($rs->fields('numpiezas'));
		$this->unidadcaja->setDbValue($rs->fields('unidadcaja'));
		$this->diasventa->setDbValue($rs->fields('diasventa'));
		$this->fecha_reg->setDbValue($rs->fields('fecha_reg'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_reg
		// idempresa
		// idarticuloemp
		// codproveedor
		// estado
		// coddum
		// descripcion
		// descripcioncorta
		// idcategoria
		// articuloaltura
		// articuloancho
		// articulolargo
		// articulopeso
		// articulocosto
		// cajaaltura
		// cajaancho
		// cajalargo
		// cajapeso
		// numpiezas
		// unidadcaja
		// diasventa
		// fecha_reg
		// id_reg

		$this->id_reg->ViewValue = $this->id_reg->CurrentValue;
		$this->id_reg->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
		$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
		$this->idempresa->ViewCustomAttributes = "";

		// idarticuloemp
		$this->idarticuloemp->ViewValue = $this->idarticuloemp->CurrentValue;
		$this->idarticuloemp->ViewCustomAttributes = "";

		// codproveedor
		$this->codproveedor->ViewValue = $this->codproveedor->CurrentValue;
		$this->codproveedor->ViewValue = FormatNumber($this->codproveedor->ViewValue, 0, -2, -2, -2);
		$this->codproveedor->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewCustomAttributes = "";

		// coddum
		$this->coddum->ViewValue = $this->coddum->CurrentValue;
		$this->coddum->ViewCustomAttributes = "";

		// descripcion
		$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
		$this->descripcion->ViewCustomAttributes = "";

		// descripcioncorta
		$this->descripcioncorta->ViewValue = $this->descripcioncorta->CurrentValue;
		$this->descripcioncorta->ViewCustomAttributes = "";

		// idcategoria
		$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
		$this->idcategoria->ViewCustomAttributes = "";

		// articuloaltura
		$this->articuloaltura->ViewValue = $this->articuloaltura->CurrentValue;
		$this->articuloaltura->ViewValue = FormatNumber($this->articuloaltura->ViewValue, 2, -2, -2, -2);
		$this->articuloaltura->ViewCustomAttributes = "";

		// articuloancho
		$this->articuloancho->ViewValue = $this->articuloancho->CurrentValue;
		$this->articuloancho->ViewValue = FormatNumber($this->articuloancho->ViewValue, 2, -2, -2, -2);
		$this->articuloancho->ViewCustomAttributes = "";

		// articulolargo
		$this->articulolargo->ViewValue = $this->articulolargo->CurrentValue;
		$this->articulolargo->ViewValue = FormatNumber($this->articulolargo->ViewValue, 2, -2, -2, -2);
		$this->articulolargo->ViewCustomAttributes = "";

		// articulopeso
		$this->articulopeso->ViewValue = $this->articulopeso->CurrentValue;
		$this->articulopeso->ViewValue = FormatNumber($this->articulopeso->ViewValue, 2, -2, -2, -2);
		$this->articulopeso->ViewCustomAttributes = "";

		// articulocosto
		$this->articulocosto->ViewValue = $this->articulocosto->CurrentValue;
		$this->articulocosto->ViewValue = FormatNumber($this->articulocosto->ViewValue, 2, -2, -2, -2);
		$this->articulocosto->ViewCustomAttributes = "";

		// cajaaltura
		$this->cajaaltura->ViewValue = $this->cajaaltura->CurrentValue;
		$this->cajaaltura->ViewValue = FormatNumber($this->cajaaltura->ViewValue, 2, -2, -2, -2);
		$this->cajaaltura->ViewCustomAttributes = "";

		// cajaancho
		$this->cajaancho->ViewValue = $this->cajaancho->CurrentValue;
		$this->cajaancho->ViewValue = FormatNumber($this->cajaancho->ViewValue, 2, -2, -2, -2);
		$this->cajaancho->ViewCustomAttributes = "";

		// cajalargo
		$this->cajalargo->ViewValue = $this->cajalargo->CurrentValue;
		$this->cajalargo->ViewValue = FormatNumber($this->cajalargo->ViewValue, 2, -2, -2, -2);
		$this->cajalargo->ViewCustomAttributes = "";

		// cajapeso
		$this->cajapeso->ViewValue = $this->cajapeso->CurrentValue;
		$this->cajapeso->ViewValue = FormatNumber($this->cajapeso->ViewValue, 2, -2, -2, -2);
		$this->cajapeso->ViewCustomAttributes = "";

		// numpiezas
		$this->numpiezas->ViewValue = $this->numpiezas->CurrentValue;
		$this->numpiezas->ViewValue = FormatNumber($this->numpiezas->ViewValue, 0, -2, -2, -2);
		$this->numpiezas->ViewCustomAttributes = "";

		// unidadcaja
		$this->unidadcaja->ViewValue = $this->unidadcaja->CurrentValue;
		$this->unidadcaja->ViewValue = FormatNumber($this->unidadcaja->ViewValue, 0, -2, -2, -2);
		$this->unidadcaja->ViewCustomAttributes = "";

		// diasventa
		$this->diasventa->ViewValue = $this->diasventa->CurrentValue;
		$this->diasventa->ViewCustomAttributes = "";

		// fecha_reg
		$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
		$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
		$this->fecha_reg->ViewCustomAttributes = "";

		// id_reg
		$this->id_reg->LinkCustomAttributes = "";
		$this->id_reg->HrefValue = "";
		$this->id_reg->TooltipValue = "";

		// idempresa
		$this->idempresa->LinkCustomAttributes = "";
		$this->idempresa->HrefValue = "";
		$this->idempresa->TooltipValue = "";

		// idarticuloemp
		$this->idarticuloemp->LinkCustomAttributes = "";
		$this->idarticuloemp->HrefValue = "";
		$this->idarticuloemp->TooltipValue = "";

		// codproveedor
		$this->codproveedor->LinkCustomAttributes = "";
		$this->codproveedor->HrefValue = "";
		$this->codproveedor->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// coddum
		$this->coddum->LinkCustomAttributes = "";
		$this->coddum->HrefValue = "";
		$this->coddum->TooltipValue = "";

		// descripcion
		$this->descripcion->LinkCustomAttributes = "";
		$this->descripcion->HrefValue = "";
		$this->descripcion->TooltipValue = "";

		// descripcioncorta
		$this->descripcioncorta->LinkCustomAttributes = "";
		$this->descripcioncorta->HrefValue = "";
		$this->descripcioncorta->TooltipValue = "";

		// idcategoria
		$this->idcategoria->LinkCustomAttributes = "";
		$this->idcategoria->HrefValue = "";
		$this->idcategoria->TooltipValue = "";

		// articuloaltura
		$this->articuloaltura->LinkCustomAttributes = "";
		$this->articuloaltura->HrefValue = "";
		$this->articuloaltura->TooltipValue = "";

		// articuloancho
		$this->articuloancho->LinkCustomAttributes = "";
		$this->articuloancho->HrefValue = "";
		$this->articuloancho->TooltipValue = "";

		// articulolargo
		$this->articulolargo->LinkCustomAttributes = "";
		$this->articulolargo->HrefValue = "";
		$this->articulolargo->TooltipValue = "";

		// articulopeso
		$this->articulopeso->LinkCustomAttributes = "";
		$this->articulopeso->HrefValue = "";
		$this->articulopeso->TooltipValue = "";

		// articulocosto
		$this->articulocosto->LinkCustomAttributes = "";
		$this->articulocosto->HrefValue = "";
		$this->articulocosto->TooltipValue = "";

		// cajaaltura
		$this->cajaaltura->LinkCustomAttributes = "";
		$this->cajaaltura->HrefValue = "";
		$this->cajaaltura->TooltipValue = "";

		// cajaancho
		$this->cajaancho->LinkCustomAttributes = "";
		$this->cajaancho->HrefValue = "";
		$this->cajaancho->TooltipValue = "";

		// cajalargo
		$this->cajalargo->LinkCustomAttributes = "";
		$this->cajalargo->HrefValue = "";
		$this->cajalargo->TooltipValue = "";

		// cajapeso
		$this->cajapeso->LinkCustomAttributes = "";
		$this->cajapeso->HrefValue = "";
		$this->cajapeso->TooltipValue = "";

		// numpiezas
		$this->numpiezas->LinkCustomAttributes = "";
		$this->numpiezas->HrefValue = "";
		$this->numpiezas->TooltipValue = "";

		// unidadcaja
		$this->unidadcaja->LinkCustomAttributes = "";
		$this->unidadcaja->HrefValue = "";
		$this->unidadcaja->TooltipValue = "";

		// diasventa
		$this->diasventa->LinkCustomAttributes = "";
		$this->diasventa->HrefValue = "";
		$this->diasventa->TooltipValue = "";

		// fecha_reg
		$this->fecha_reg->LinkCustomAttributes = "";
		$this->fecha_reg->HrefValue = "";
		$this->fecha_reg->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_reg
		$this->id_reg->EditAttrs["class"] = "form-control";
		$this->id_reg->EditCustomAttributes = "";
		$this->id_reg->EditValue = $this->id_reg->CurrentValue;
		$this->id_reg->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->EditAttrs["class"] = "form-control";
		$this->idempresa->EditCustomAttributes = "";
		$this->idempresa->EditValue = $this->idempresa->CurrentValue;
		$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

		// idarticuloemp
		$this->idarticuloemp->EditAttrs["class"] = "form-control";
		$this->idarticuloemp->EditCustomAttributes = "";
		if (!$this->idarticuloemp->Raw)
			$this->idarticuloemp->CurrentValue = HtmlDecode($this->idarticuloemp->CurrentValue);
		$this->idarticuloemp->EditValue = $this->idarticuloemp->CurrentValue;
		$this->idarticuloemp->PlaceHolder = RemoveHtml($this->idarticuloemp->caption());

		// codproveedor
		$this->codproveedor->EditAttrs["class"] = "form-control";
		$this->codproveedor->EditCustomAttributes = "";
		$this->codproveedor->EditValue = $this->codproveedor->CurrentValue;
		$this->codproveedor->PlaceHolder = RemoveHtml($this->codproveedor->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		if (!$this->estado->Raw)
			$this->estado->CurrentValue = HtmlDecode($this->estado->CurrentValue);
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// coddum
		$this->coddum->EditAttrs["class"] = "form-control";
		$this->coddum->EditCustomAttributes = "";
		if (!$this->coddum->Raw)
			$this->coddum->CurrentValue = HtmlDecode($this->coddum->CurrentValue);
		$this->coddum->EditValue = $this->coddum->CurrentValue;
		$this->coddum->PlaceHolder = RemoveHtml($this->coddum->caption());

		// descripcion
		$this->descripcion->EditAttrs["class"] = "form-control";
		$this->descripcion->EditCustomAttributes = "";
		if (!$this->descripcion->Raw)
			$this->descripcion->CurrentValue = HtmlDecode($this->descripcion->CurrentValue);
		$this->descripcion->EditValue = $this->descripcion->CurrentValue;
		$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

		// descripcioncorta
		$this->descripcioncorta->EditAttrs["class"] = "form-control";
		$this->descripcioncorta->EditCustomAttributes = "";
		if (!$this->descripcioncorta->Raw)
			$this->descripcioncorta->CurrentValue = HtmlDecode($this->descripcioncorta->CurrentValue);
		$this->descripcioncorta->EditValue = $this->descripcioncorta->CurrentValue;
		$this->descripcioncorta->PlaceHolder = RemoveHtml($this->descripcioncorta->caption());

		// idcategoria
		$this->idcategoria->EditAttrs["class"] = "form-control";
		$this->idcategoria->EditCustomAttributes = "";
		$this->idcategoria->EditValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

		// articuloaltura
		$this->articuloaltura->EditAttrs["class"] = "form-control";
		$this->articuloaltura->EditCustomAttributes = "";
		$this->articuloaltura->EditValue = $this->articuloaltura->CurrentValue;
		$this->articuloaltura->PlaceHolder = RemoveHtml($this->articuloaltura->caption());
		if (strval($this->articuloaltura->EditValue) != "" && is_numeric($this->articuloaltura->EditValue))
			$this->articuloaltura->EditValue = FormatNumber($this->articuloaltura->EditValue, -2, -2, -2, -2);
		

		// articuloancho
		$this->articuloancho->EditAttrs["class"] = "form-control";
		$this->articuloancho->EditCustomAttributes = "";
		$this->articuloancho->EditValue = $this->articuloancho->CurrentValue;
		$this->articuloancho->PlaceHolder = RemoveHtml($this->articuloancho->caption());
		if (strval($this->articuloancho->EditValue) != "" && is_numeric($this->articuloancho->EditValue))
			$this->articuloancho->EditValue = FormatNumber($this->articuloancho->EditValue, -2, -2, -2, -2);
		

		// articulolargo
		$this->articulolargo->EditAttrs["class"] = "form-control";
		$this->articulolargo->EditCustomAttributes = "";
		$this->articulolargo->EditValue = $this->articulolargo->CurrentValue;
		$this->articulolargo->PlaceHolder = RemoveHtml($this->articulolargo->caption());
		if (strval($this->articulolargo->EditValue) != "" && is_numeric($this->articulolargo->EditValue))
			$this->articulolargo->EditValue = FormatNumber($this->articulolargo->EditValue, -2, -2, -2, -2);
		

		// articulopeso
		$this->articulopeso->EditAttrs["class"] = "form-control";
		$this->articulopeso->EditCustomAttributes = "";
		$this->articulopeso->EditValue = $this->articulopeso->CurrentValue;
		$this->articulopeso->PlaceHolder = RemoveHtml($this->articulopeso->caption());
		if (strval($this->articulopeso->EditValue) != "" && is_numeric($this->articulopeso->EditValue))
			$this->articulopeso->EditValue = FormatNumber($this->articulopeso->EditValue, -2, -2, -2, -2);
		

		// articulocosto
		$this->articulocosto->EditAttrs["class"] = "form-control";
		$this->articulocosto->EditCustomAttributes = "";
		$this->articulocosto->EditValue = $this->articulocosto->CurrentValue;
		$this->articulocosto->PlaceHolder = RemoveHtml($this->articulocosto->caption());
		if (strval($this->articulocosto->EditValue) != "" && is_numeric($this->articulocosto->EditValue))
			$this->articulocosto->EditValue = FormatNumber($this->articulocosto->EditValue, -2, -2, -2, -2);
		

		// cajaaltura
		$this->cajaaltura->EditAttrs["class"] = "form-control";
		$this->cajaaltura->EditCustomAttributes = "";
		$this->cajaaltura->EditValue = $this->cajaaltura->CurrentValue;
		$this->cajaaltura->PlaceHolder = RemoveHtml($this->cajaaltura->caption());
		if (strval($this->cajaaltura->EditValue) != "" && is_numeric($this->cajaaltura->EditValue))
			$this->cajaaltura->EditValue = FormatNumber($this->cajaaltura->EditValue, -2, -2, -2, -2);
		

		// cajaancho
		$this->cajaancho->EditAttrs["class"] = "form-control";
		$this->cajaancho->EditCustomAttributes = "";
		$this->cajaancho->EditValue = $this->cajaancho->CurrentValue;
		$this->cajaancho->PlaceHolder = RemoveHtml($this->cajaancho->caption());
		if (strval($this->cajaancho->EditValue) != "" && is_numeric($this->cajaancho->EditValue))
			$this->cajaancho->EditValue = FormatNumber($this->cajaancho->EditValue, -2, -2, -2, -2);
		

		// cajalargo
		$this->cajalargo->EditAttrs["class"] = "form-control";
		$this->cajalargo->EditCustomAttributes = "";
		$this->cajalargo->EditValue = $this->cajalargo->CurrentValue;
		$this->cajalargo->PlaceHolder = RemoveHtml($this->cajalargo->caption());
		if (strval($this->cajalargo->EditValue) != "" && is_numeric($this->cajalargo->EditValue))
			$this->cajalargo->EditValue = FormatNumber($this->cajalargo->EditValue, -2, -2, -2, -2);
		

		// cajapeso
		$this->cajapeso->EditAttrs["class"] = "form-control";
		$this->cajapeso->EditCustomAttributes = "";
		$this->cajapeso->EditValue = $this->cajapeso->CurrentValue;
		$this->cajapeso->PlaceHolder = RemoveHtml($this->cajapeso->caption());
		if (strval($this->cajapeso->EditValue) != "" && is_numeric($this->cajapeso->EditValue))
			$this->cajapeso->EditValue = FormatNumber($this->cajapeso->EditValue, -2, -2, -2, -2);
		

		// numpiezas
		$this->numpiezas->EditAttrs["class"] = "form-control";
		$this->numpiezas->EditCustomAttributes = "";
		$this->numpiezas->EditValue = $this->numpiezas->CurrentValue;
		$this->numpiezas->PlaceHolder = RemoveHtml($this->numpiezas->caption());

		// unidadcaja
		$this->unidadcaja->EditAttrs["class"] = "form-control";
		$this->unidadcaja->EditCustomAttributes = "";
		$this->unidadcaja->EditValue = $this->unidadcaja->CurrentValue;
		$this->unidadcaja->PlaceHolder = RemoveHtml($this->unidadcaja->caption());

		// diasventa
		$this->diasventa->EditAttrs["class"] = "form-control";
		$this->diasventa->EditCustomAttributes = "";
		if (!$this->diasventa->Raw)
			$this->diasventa->CurrentValue = HtmlDecode($this->diasventa->CurrentValue);
		$this->diasventa->EditValue = $this->diasventa->CurrentValue;
		$this->diasventa->PlaceHolder = RemoveHtml($this->diasventa->caption());

		// fecha_reg
		$this->fecha_reg->EditAttrs["class"] = "form-control";
		$this->fecha_reg->EditCustomAttributes = "";
		$this->fecha_reg->EditValue = FormatDateTime($this->fecha_reg->CurrentValue, 8);
		$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_reg);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->idarticuloemp);
					$doc->exportCaption($this->codproveedor);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->coddum);
					$doc->exportCaption($this->descripcion);
					$doc->exportCaption($this->descripcioncorta);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->articuloaltura);
					$doc->exportCaption($this->articuloancho);
					$doc->exportCaption($this->articulolargo);
					$doc->exportCaption($this->articulopeso);
					$doc->exportCaption($this->articulocosto);
					$doc->exportCaption($this->cajaaltura);
					$doc->exportCaption($this->cajaancho);
					$doc->exportCaption($this->cajalargo);
					$doc->exportCaption($this->cajapeso);
					$doc->exportCaption($this->numpiezas);
					$doc->exportCaption($this->unidadcaja);
					$doc->exportCaption($this->diasventa);
					$doc->exportCaption($this->fecha_reg);
				} else {
					$doc->exportCaption($this->id_reg);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->idarticuloemp);
					$doc->exportCaption($this->codproveedor);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->coddum);
					$doc->exportCaption($this->descripcion);
					$doc->exportCaption($this->descripcioncorta);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->articuloaltura);
					$doc->exportCaption($this->articuloancho);
					$doc->exportCaption($this->articulolargo);
					$doc->exportCaption($this->articulopeso);
					$doc->exportCaption($this->articulocosto);
					$doc->exportCaption($this->cajaaltura);
					$doc->exportCaption($this->cajaancho);
					$doc->exportCaption($this->cajalargo);
					$doc->exportCaption($this->cajapeso);
					$doc->exportCaption($this->numpiezas);
					$doc->exportCaption($this->unidadcaja);
					$doc->exportCaption($this->diasventa);
					$doc->exportCaption($this->fecha_reg);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_reg);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->idarticuloemp);
						$doc->exportField($this->codproveedor);
						$doc->exportField($this->estado);
						$doc->exportField($this->coddum);
						$doc->exportField($this->descripcion);
						$doc->exportField($this->descripcioncorta);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->articuloaltura);
						$doc->exportField($this->articuloancho);
						$doc->exportField($this->articulolargo);
						$doc->exportField($this->articulopeso);
						$doc->exportField($this->articulocosto);
						$doc->exportField($this->cajaaltura);
						$doc->exportField($this->cajaancho);
						$doc->exportField($this->cajalargo);
						$doc->exportField($this->cajapeso);
						$doc->exportField($this->numpiezas);
						$doc->exportField($this->unidadcaja);
						$doc->exportField($this->diasventa);
						$doc->exportField($this->fecha_reg);
					} else {
						$doc->exportField($this->id_reg);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->idarticuloemp);
						$doc->exportField($this->codproveedor);
						$doc->exportField($this->estado);
						$doc->exportField($this->coddum);
						$doc->exportField($this->descripcion);
						$doc->exportField($this->descripcioncorta);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->articuloaltura);
						$doc->exportField($this->articuloancho);
						$doc->exportField($this->articulolargo);
						$doc->exportField($this->articulopeso);
						$doc->exportField($this->articulocosto);
						$doc->exportField($this->cajaaltura);
						$doc->exportField($this->cajaancho);
						$doc->exportField($this->cajalargo);
						$doc->exportField($this->cajapeso);
						$doc->exportField($this->numpiezas);
						$doc->exportField($this->unidadcaja);
						$doc->exportField($this->diasventa);
						$doc->exportField($this->fecha_reg);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>