<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$categories_edit = new categories_edit();

// Run the page
$categories_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$categories_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fcategoriesedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fcategoriesedit = currentForm = new ew.Form("fcategoriesedit", "edit");

	// Validate form
	fcategoriesedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($categories_edit->id->Required) { ?>
				elm = this.getElements("x" + infix + "_id");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->id->caption(), $categories_edit->id->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($categories_edit->courses_id->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_id");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->courses_id->caption(), $categories_edit->courses_id->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_courses_id");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_edit->courses_id->errorMessage()) ?>");
			<?php if ($categories_edit->category_name->Required) { ?>
				elm = this.getElements("x" + infix + "_category_name");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->category_name->caption(), $categories_edit->category_name->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($categories_edit->description->Required) { ?>
				elm = this.getElements("x" + infix + "_description");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->description->caption(), $categories_edit->description->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($categories_edit->time->Required) { ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->time->caption(), $categories_edit->time->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_edit->time->errorMessage()) ?>");
			<?php if ($categories_edit->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_edit->estado->caption(), $categories_edit->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_edit->estado->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fcategoriesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fcategoriesedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fcategoriesedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $categories_edit->showPageHeader(); ?>
<?php
$categories_edit->showMessage();
?>
<form name="fcategoriesedit" id="fcategoriesedit" class="<?php echo $categories_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="categories">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$categories_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($categories_edit->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_categories_id" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->id->caption() ?><?php echo $categories_edit->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->id->cellAttributes() ?>>
<span id="el_categories_id">
<span<?php echo $categories_edit->id->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($categories_edit->id->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="categories" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($categories_edit->id->CurrentValue) ?>">
<?php echo $categories_edit->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_edit->courses_id->Visible) { // courses_id ?>
	<div id="r_courses_id" class="form-group row">
		<label id="elh_categories_courses_id" for="x_courses_id" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->courses_id->caption() ?><?php echo $categories_edit->courses_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->courses_id->cellAttributes() ?>>
<span id="el_categories_courses_id">
<input type="text" data-table="categories" data-field="x_courses_id" name="x_courses_id" id="x_courses_id" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_edit->courses_id->getPlaceHolder()) ?>" value="<?php echo $categories_edit->courses_id->EditValue ?>"<?php echo $categories_edit->courses_id->editAttributes() ?>>
</span>
<?php echo $categories_edit->courses_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_edit->category_name->Visible) { // category_name ?>
	<div id="r_category_name" class="form-group row">
		<label id="elh_categories_category_name" for="x_category_name" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->category_name->caption() ?><?php echo $categories_edit->category_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->category_name->cellAttributes() ?>>
<span id="el_categories_category_name">
<input type="text" data-table="categories" data-field="x_category_name" name="x_category_name" id="x_category_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($categories_edit->category_name->getPlaceHolder()) ?>" value="<?php echo $categories_edit->category_name->EditValue ?>"<?php echo $categories_edit->category_name->editAttributes() ?>>
</span>
<?php echo $categories_edit->category_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_edit->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_categories_description" for="x_description" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->description->caption() ?><?php echo $categories_edit->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->description->cellAttributes() ?>>
<span id="el_categories_description">
<input type="text" data-table="categories" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($categories_edit->description->getPlaceHolder()) ?>" value="<?php echo $categories_edit->description->EditValue ?>"<?php echo $categories_edit->description->editAttributes() ?>>
</span>
<?php echo $categories_edit->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_edit->time->Visible) { // time ?>
	<div id="r_time" class="form-group row">
		<label id="elh_categories_time" for="x_time" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->time->caption() ?><?php echo $categories_edit->time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->time->cellAttributes() ?>>
<span id="el_categories_time">
<input type="text" data-table="categories" data-field="x_time" name="x_time" id="x_time" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_edit->time->getPlaceHolder()) ?>" value="<?php echo $categories_edit->time->EditValue ?>"<?php echo $categories_edit->time->editAttributes() ?>>
</span>
<?php echo $categories_edit->time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_edit->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_categories_estado" for="x_estado" class="<?php echo $categories_edit->LeftColumnClass ?>"><?php echo $categories_edit->estado->caption() ?><?php echo $categories_edit->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_edit->RightColumnClass ?>"><div <?php echo $categories_edit->estado->cellAttributes() ?>>
<span id="el_categories_estado">
<input type="text" data-table="categories" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_edit->estado->getPlaceHolder()) ?>" value="<?php echo $categories_edit->estado->EditValue ?>"<?php echo $categories_edit->estado->editAttributes() ?>>
</span>
<?php echo $categories_edit->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$categories_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $categories_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $categories_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$categories_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$categories_edit->terminate();
?>