<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$procesos_nuevo_list = new procesos_nuevo_list();

// Run the page
$procesos_nuevo_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$procesos_nuevo_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$procesos_nuevo_list->isExport()) { ?>
<script>
var fprocesos_nuevolist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fprocesos_nuevolist = currentForm = new ew.Form("fprocesos_nuevolist", "list");
	fprocesos_nuevolist.formKeyCountName = '<?php echo $procesos_nuevo_list->FormKeyCountName ?>';
	loadjs.done("fprocesos_nuevolist");
});
var fprocesos_nuevolistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fprocesos_nuevolistsrch = currentSearchForm = new ew.Form("fprocesos_nuevolistsrch");

	// Dynamic selection lists
	// Filters

	fprocesos_nuevolistsrch.filterList = <?php echo $procesos_nuevo_list->getFilterList() ?>;
	loadjs.done("fprocesos_nuevolistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$procesos_nuevo_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($procesos_nuevo_list->TotalRecords > 0 && $procesos_nuevo_list->ExportOptions->visible()) { ?>
<?php $procesos_nuevo_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ImportOptions->visible()) { ?>
<?php $procesos_nuevo_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SearchOptions->visible()) { ?>
<?php $procesos_nuevo_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FilterOptions->visible()) { ?>
<?php $procesos_nuevo_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$procesos_nuevo_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$procesos_nuevo_list->isExport() && !$procesos_nuevo->CurrentAction) { ?>
<form name="fprocesos_nuevolistsrch" id="fprocesos_nuevolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fprocesos_nuevolistsrch-search-panel" class="<?php echo $procesos_nuevo_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="procesos_nuevo">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $procesos_nuevo_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($procesos_nuevo_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($procesos_nuevo_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $procesos_nuevo_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($procesos_nuevo_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($procesos_nuevo_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($procesos_nuevo_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($procesos_nuevo_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $procesos_nuevo_list->showPageHeader(); ?>
<?php
$procesos_nuevo_list->showMessage();
?>
<?php if ($procesos_nuevo_list->TotalRecords > 0 || $procesos_nuevo->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($procesos_nuevo_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> procesos_nuevo">
<form name="fprocesos_nuevolist" id="fprocesos_nuevolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="procesos_nuevo">
<div id="gmp_procesos_nuevo" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($procesos_nuevo_list->TotalRecords > 0 || $procesos_nuevo_list->isGridEdit()) { ?>
<table id="tbl_procesos_nuevolist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$procesos_nuevo->RowType = ROWTYPE_HEADER;

// Render list options
$procesos_nuevo_list->renderListOptions();

// Render list options (header, left)
$procesos_nuevo_list->ListOptions->render("header", "left");
?>
<?php if ($procesos_nuevo_list->codigo->Visible) { // codigo ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->codigo) == "") { ?>
		<th data-name="codigo" class="<?php echo $procesos_nuevo_list->codigo->headerCellClass() ?>"><div id="elh_procesos_nuevo_codigo" class="procesos_nuevo_codigo"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->codigo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo" class="<?php echo $procesos_nuevo_list->codigo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->codigo) ?>', 1);"><div id="elh_procesos_nuevo_codigo" class="procesos_nuevo_codigo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->codigo->caption() ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->codigo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->codigo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->codigo_proceso->Visible) { // codigo_proceso ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->codigo_proceso) == "") { ?>
		<th data-name="codigo_proceso" class="<?php echo $procesos_nuevo_list->codigo_proceso->headerCellClass() ?>"><div id="elh_procesos_nuevo_codigo_proceso" class="procesos_nuevo_codigo_proceso"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->codigo_proceso->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo_proceso" class="<?php echo $procesos_nuevo_list->codigo_proceso->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->codigo_proceso) ?>', 1);"><div id="elh_procesos_nuevo_codigo_proceso" class="procesos_nuevo_codigo_proceso">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->codigo_proceso->caption() ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->codigo_proceso->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->codigo_proceso->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->no->Visible) { // no ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->no) == "") { ?>
		<th data-name="no" class="<?php echo $procesos_nuevo_list->no->headerCellClass() ?>"><div id="elh_procesos_nuevo_no" class="procesos_nuevo_no"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $procesos_nuevo_list->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->no) ?>', 1);"><div id="elh_procesos_nuevo_no" class="procesos_nuevo_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->no->caption() ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->no->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->no->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->usuarios->Visible) { // usuarios ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->usuarios) == "") { ?>
		<th data-name="usuarios" class="<?php echo $procesos_nuevo_list->usuarios->headerCellClass() ?>"><div id="elh_procesos_nuevo_usuarios" class="procesos_nuevo_usuarios"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->usuarios->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="usuarios" class="<?php echo $procesos_nuevo_list->usuarios->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->usuarios) ?>', 1);"><div id="elh_procesos_nuevo_usuarios" class="procesos_nuevo_usuarios">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->usuarios->caption() ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->usuarios->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->usuarios->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SEC_EJEC->Visible) { // SEC_EJEC ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SEC_EJEC) == "") { ?>
		<th data-name="SEC_EJEC" class="<?php echo $procesos_nuevo_list->SEC_EJEC->headerCellClass() ?>"><div id="elh_procesos_nuevo_SEC_EJEC" class="procesos_nuevo_SEC_EJEC"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SEC_EJEC->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SEC_EJEC" class="<?php echo $procesos_nuevo_list->SEC_EJEC->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SEC_EJEC) ?>', 1);"><div id="elh_procesos_nuevo_SEC_EJEC" class="procesos_nuevo_SEC_EJEC">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SEC_EJEC->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SEC_EJEC->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SEC_EJEC->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIPO_MODALIDAD->Visible) { // TIPO_MODALIDAD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_MODALIDAD) == "") { ?>
		<th data-name="TIPO_MODALIDAD" class="<?php echo $procesos_nuevo_list->TIPO_MODALIDAD->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIPO_MODALIDAD" class="procesos_nuevo_TIPO_MODALIDAD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_MODALIDAD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIPO_MODALIDAD" class="<?php echo $procesos_nuevo_list->TIPO_MODALIDAD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_MODALIDAD) ?>', 1);"><div id="elh_procesos_nuevo_TIPO_MODALIDAD" class="procesos_nuevo_TIPO_MODALIDAD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_MODALIDAD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIPO_MODALIDAD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIPO_MODALIDAD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SECUENCIA->Visible) { // SECUENCIA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SECUENCIA) == "") { ?>
		<th data-name="SECUENCIA" class="<?php echo $procesos_nuevo_list->SECUENCIA->headerCellClass() ?>"><div id="elh_procesos_nuevo_SECUENCIA" class="procesos_nuevo_SECUENCIA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SECUENCIA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SECUENCIA" class="<?php echo $procesos_nuevo_list->SECUENCIA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SECUENCIA) ?>', 1);"><div id="elh_procesos_nuevo_SECUENCIA" class="procesos_nuevo_SECUENCIA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SECUENCIA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SECUENCIA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SECUENCIA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->AMBIENTE->Visible) { // AMBIENTE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->AMBIENTE) == "") { ?>
		<th data-name="AMBIENTE" class="<?php echo $procesos_nuevo_list->AMBIENTE->headerCellClass() ?>"><div id="elh_procesos_nuevo_AMBIENTE" class="procesos_nuevo_AMBIENTE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->AMBIENTE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AMBIENTE" class="<?php echo $procesos_nuevo_list->AMBIENTE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->AMBIENTE) ?>', 1);"><div id="elh_procesos_nuevo_AMBIENTE" class="procesos_nuevo_AMBIENTE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->AMBIENTE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->AMBIENTE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->AMBIENTE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->RUC_ENTIDAD->Visible) { // RUC_ENTIDAD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->RUC_ENTIDAD) == "") { ?>
		<th data-name="RUC_ENTIDAD" class="<?php echo $procesos_nuevo_list->RUC_ENTIDAD->headerCellClass() ?>"><div id="elh_procesos_nuevo_RUC_ENTIDAD" class="procesos_nuevo_RUC_ENTIDAD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->RUC_ENTIDAD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RUC_ENTIDAD" class="<?php echo $procesos_nuevo_list->RUC_ENTIDAD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->RUC_ENTIDAD) ?>', 1);"><div id="elh_procesos_nuevo_RUC_ENTIDAD" class="procesos_nuevo_RUC_ENTIDAD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->RUC_ENTIDAD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->RUC_ENTIDAD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->RUC_ENTIDAD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->LOCAL->Visible) { // LOCAL ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->LOCAL) == "") { ?>
		<th data-name="LOCAL" class="<?php echo $procesos_nuevo_list->LOCAL->headerCellClass() ?>"><div id="elh_procesos_nuevo_LOCAL" class="procesos_nuevo_LOCAL"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->LOCAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LOCAL" class="<?php echo $procesos_nuevo_list->LOCAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->LOCAL) ?>', 1);"><div id="elh_procesos_nuevo_LOCAL" class="procesos_nuevo_LOCAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->LOCAL->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->LOCAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->LOCAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DEPARTAMENTO->Visible) { // DEPARTAMENTO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DEPARTAMENTO) == "") { ?>
		<th data-name="DEPARTAMENTO" class="<?php echo $procesos_nuevo_list->DEPARTAMENTO->headerCellClass() ?>"><div id="elh_procesos_nuevo_DEPARTAMENTO" class="procesos_nuevo_DEPARTAMENTO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DEPARTAMENTO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DEPARTAMENTO" class="<?php echo $procesos_nuevo_list->DEPARTAMENTO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DEPARTAMENTO) ?>', 1);"><div id="elh_procesos_nuevo_DEPARTAMENTO" class="procesos_nuevo_DEPARTAMENTO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DEPARTAMENTO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DEPARTAMENTO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DEPARTAMENTO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PROVINCIA->Visible) { // PROVINCIA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PROVINCIA) == "") { ?>
		<th data-name="PROVINCIA" class="<?php echo $procesos_nuevo_list->PROVINCIA->headerCellClass() ?>"><div id="elh_procesos_nuevo_PROVINCIA" class="procesos_nuevo_PROVINCIA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PROVINCIA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PROVINCIA" class="<?php echo $procesos_nuevo_list->PROVINCIA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PROVINCIA) ?>', 1);"><div id="elh_procesos_nuevo_PROVINCIA" class="procesos_nuevo_PROVINCIA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PROVINCIA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PROVINCIA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PROVINCIA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DISTRITO->Visible) { // DISTRITO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DISTRITO) == "") { ?>
		<th data-name="DISTRITO" class="<?php echo $procesos_nuevo_list->DISTRITO->headerCellClass() ?>"><div id="elh_procesos_nuevo_DISTRITO" class="procesos_nuevo_DISTRITO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DISTRITO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DISTRITO" class="<?php echo $procesos_nuevo_list->DISTRITO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DISTRITO) ?>', 1);"><div id="elh_procesos_nuevo_DISTRITO" class="procesos_nuevo_DISTRITO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DISTRITO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DISTRITO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DISTRITO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->AREA->Visible) { // AREA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->AREA) == "") { ?>
		<th data-name="AREA" class="<?php echo $procesos_nuevo_list->AREA->headerCellClass() ?>"><div id="elh_procesos_nuevo_AREA" class="procesos_nuevo_AREA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->AREA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AREA" class="<?php echo $procesos_nuevo_list->AREA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->AREA) ?>', 1);"><div id="elh_procesos_nuevo_AREA" class="procesos_nuevo_AREA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->AREA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->AREA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->AREA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->OFICINA->Visible) { // OFICINA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->OFICINA) == "") { ?>
		<th data-name="OFICINA" class="<?php echo $procesos_nuevo_list->OFICINA->headerCellClass() ?>"><div id="elh_procesos_nuevo_OFICINA" class="procesos_nuevo_OFICINA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OFICINA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OFICINA" class="<?php echo $procesos_nuevo_list->OFICINA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->OFICINA) ?>', 1);"><div id="elh_procesos_nuevo_OFICINA" class="procesos_nuevo_OFICINA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OFICINA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->OFICINA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->OFICINA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PISO_OFICINA->Visible) { // PISO_OFICINA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PISO_OFICINA) == "") { ?>
		<th data-name="PISO_OFICINA" class="<?php echo $procesos_nuevo_list->PISO_OFICINA->headerCellClass() ?>"><div id="elh_procesos_nuevo_PISO_OFICINA" class="procesos_nuevo_PISO_OFICINA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PISO_OFICINA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PISO_OFICINA" class="<?php echo $procesos_nuevo_list->PISO_OFICINA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PISO_OFICINA) ?>', 1);"><div id="elh_procesos_nuevo_PISO_OFICINA" class="procesos_nuevo_PISO_OFICINA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PISO_OFICINA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PISO_OFICINA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PISO_OFICINA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->Visible) { // NRO_DOC_IDENT_PERSONAL ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL) == "") { ?>
		<th data-name="NRO_DOC_IDENT_PERSONAL" class="<?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_DOC_IDENT_PERSONAL" class="procesos_nuevo_NRO_DOC_IDENT_PERSONAL"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_DOC_IDENT_PERSONAL" class="<?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL) ?>', 1);"><div id="elh_procesos_nuevo_NRO_DOC_IDENT_PERSONAL" class="procesos_nuevo_NRO_DOC_IDENT_PERSONAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->APELLIDO_PATERNO->Visible) { // APELLIDO_PATERNO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->APELLIDO_PATERNO) == "") { ?>
		<th data-name="APELLIDO_PATERNO" class="<?php echo $procesos_nuevo_list->APELLIDO_PATERNO->headerCellClass() ?>"><div id="elh_procesos_nuevo_APELLIDO_PATERNO" class="procesos_nuevo_APELLIDO_PATERNO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->APELLIDO_PATERNO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="APELLIDO_PATERNO" class="<?php echo $procesos_nuevo_list->APELLIDO_PATERNO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->APELLIDO_PATERNO) ?>', 1);"><div id="elh_procesos_nuevo_APELLIDO_PATERNO" class="procesos_nuevo_APELLIDO_PATERNO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->APELLIDO_PATERNO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->APELLIDO_PATERNO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->APELLIDO_PATERNO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->APELLIDO_MATERNO->Visible) { // APELLIDO_MATERNO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->APELLIDO_MATERNO) == "") { ?>
		<th data-name="APELLIDO_MATERNO" class="<?php echo $procesos_nuevo_list->APELLIDO_MATERNO->headerCellClass() ?>"><div id="elh_procesos_nuevo_APELLIDO_MATERNO" class="procesos_nuevo_APELLIDO_MATERNO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->APELLIDO_MATERNO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="APELLIDO_MATERNO" class="<?php echo $procesos_nuevo_list->APELLIDO_MATERNO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->APELLIDO_MATERNO) ?>', 1);"><div id="elh_procesos_nuevo_APELLIDO_MATERNO" class="procesos_nuevo_APELLIDO_MATERNO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->APELLIDO_MATERNO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->APELLIDO_MATERNO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->APELLIDO_MATERNO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NOMBRES->Visible) { // NOMBRES ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NOMBRES) == "") { ?>
		<th data-name="NOMBRES" class="<?php echo $procesos_nuevo_list->NOMBRES->headerCellClass() ?>"><div id="elh_procesos_nuevo_NOMBRES" class="procesos_nuevo_NOMBRES"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NOMBRES->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NOMBRES" class="<?php echo $procesos_nuevo_list->NOMBRES->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NOMBRES) ?>', 1);"><div id="elh_procesos_nuevo_NOMBRES" class="procesos_nuevo_NOMBRES">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NOMBRES->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NOMBRES->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NOMBRES->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->OPERATIVO->Visible) { // OPERATIVO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->OPERATIVO) == "") { ?>
		<th data-name="OPERATIVO" class="<?php echo $procesos_nuevo_list->OPERATIVO->headerCellClass() ?>"><div id="elh_procesos_nuevo_OPERATIVO" class="procesos_nuevo_OPERATIVO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OPERATIVO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OPERATIVO" class="<?php echo $procesos_nuevo_list->OPERATIVO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->OPERATIVO) ?>', 1);"><div id="elh_procesos_nuevo_OPERATIVO" class="procesos_nuevo_OPERATIVO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OPERATIVO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->OPERATIVO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->OPERATIVO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIPO_DOC_IDENTIDAD->Visible) { // TIPO_DOC_IDENTIDAD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_DOC_IDENTIDAD) == "") { ?>
		<th data-name="TIPO_DOC_IDENTIDAD" class="<?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIPO_DOC_IDENTIDAD" class="procesos_nuevo_TIPO_DOC_IDENTIDAD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIPO_DOC_IDENTIDAD" class="<?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_DOC_IDENTIDAD) ?>', 1);"><div id="elh_procesos_nuevo_TIPO_DOC_IDENTIDAD" class="procesos_nuevo_TIPO_DOC_IDENTIDAD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIPO_DOC_IDENTIDAD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIPO_DOC_IDENTIDAD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->MODALIDAD_CONTRATO->Visible) { // MODALIDAD_CONTRATO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->MODALIDAD_CONTRATO) == "") { ?>
		<th data-name="MODALIDAD_CONTRATO" class="<?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->headerCellClass() ?>"><div id="elh_procesos_nuevo_MODALIDAD_CONTRATO" class="procesos_nuevo_MODALIDAD_CONTRATO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MODALIDAD_CONTRATO" class="<?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->MODALIDAD_CONTRATO) ?>', 1);"><div id="elh_procesos_nuevo_MODALIDAD_CONTRATO" class="procesos_nuevo_MODALIDAD_CONTRATO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->MODALIDAD_CONTRATO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->MODALIDAD_CONTRATO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CODIGO_PATRIMONIAL->Visible) { // CODIGO_PATRIMONIAL ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_PATRIMONIAL) == "") { ?>
		<th data-name="CODIGO_PATRIMONIAL" class="<?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->headerCellClass() ?>"><div id="elh_procesos_nuevo_CODIGO_PATRIMONIAL" class="procesos_nuevo_CODIGO_PATRIMONIAL"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CODIGO_PATRIMONIAL" class="<?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_PATRIMONIAL) ?>', 1);"><div id="elh_procesos_nuevo_CODIGO_PATRIMONIAL" class="procesos_nuevo_CODIGO_PATRIMONIAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CODIGO_PATRIMONIAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CODIGO_PATRIMONIAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DENOMINACION_BIEN->Visible) { // DENOMINACION_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DENOMINACION_BIEN) == "") { ?>
		<th data-name="DENOMINACION_BIEN" class="<?php echo $procesos_nuevo_list->DENOMINACION_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_DENOMINACION_BIEN" class="procesos_nuevo_DENOMINACION_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DENOMINACION_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DENOMINACION_BIEN" class="<?php echo $procesos_nuevo_list->DENOMINACION_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DENOMINACION_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_DENOMINACION_BIEN" class="procesos_nuevo_DENOMINACION_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DENOMINACION_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DENOMINACION_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DENOMINACION_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIPO_CAUSAL_ALTA->Visible) { // TIPO_CAUSAL_ALTA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_CAUSAL_ALTA) == "") { ?>
		<th data-name="TIPO_CAUSAL_ALTA" class="<?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIPO_CAUSAL_ALTA" class="procesos_nuevo_TIPO_CAUSAL_ALTA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIPO_CAUSAL_ALTA" class="<?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_CAUSAL_ALTA) ?>', 1);"><div id="elh_procesos_nuevo_TIPO_CAUSAL_ALTA" class="procesos_nuevo_TIPO_CAUSAL_ALTA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIPO_CAUSAL_ALTA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIPO_CAUSAL_ALTA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_DOC_ADQUISICION->Visible) { // NRO_DOC_ADQUISICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_DOC_ADQUISICION) == "") { ?>
		<th data-name="NRO_DOC_ADQUISICION" class="<?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_DOC_ADQUISICION" class="procesos_nuevo_NRO_DOC_ADQUISICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_DOC_ADQUISICION" class="<?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_DOC_ADQUISICION) ?>', 1);"><div id="elh_procesos_nuevo_NRO_DOC_ADQUISICION" class="procesos_nuevo_NRO_DOC_ADQUISICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_DOC_ADQUISICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_DOC_ADQUISICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_ADQUISICION->Visible) { // FECHA_ADQUISICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_ADQUISICION) == "") { ?>
		<th data-name="FECHA_ADQUISICION" class="<?php echo $procesos_nuevo_list->FECHA_ADQUISICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_ADQUISICION" class="procesos_nuevo_FECHA_ADQUISICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_ADQUISICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_ADQUISICION" class="<?php echo $procesos_nuevo_list->FECHA_ADQUISICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_ADQUISICION) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_ADQUISICION" class="procesos_nuevo_FECHA_ADQUISICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_ADQUISICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_ADQUISICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_ADQUISICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->VALOR_ADQUISICION->Visible) { // VALOR_ADQUISICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_ADQUISICION) == "") { ?>
		<th data-name="VALOR_ADQUISICION" class="<?php echo $procesos_nuevo_list->VALOR_ADQUISICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_VALOR_ADQUISICION" class="procesos_nuevo_VALOR_ADQUISICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_ADQUISICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="VALOR_ADQUISICION" class="<?php echo $procesos_nuevo_list->VALOR_ADQUISICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_ADQUISICION) ?>', 1);"><div id="elh_procesos_nuevo_VALOR_ADQUISICION" class="procesos_nuevo_VALOR_ADQUISICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_ADQUISICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->VALOR_ADQUISICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->VALOR_ADQUISICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_DEPRECIACION->Visible) { // FECHA_DEPRECIACION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_DEPRECIACION) == "") { ?>
		<th data-name="FECHA_DEPRECIACION" class="<?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_DEPRECIACION" class="procesos_nuevo_FECHA_DEPRECIACION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_DEPRECIACION" class="<?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_DEPRECIACION) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_DEPRECIACION" class="procesos_nuevo_FECHA_DEPRECIACION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_DEPRECIACION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_DEPRECIACION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->Visible) { // VALOR_DEPREC_EJERCICIO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO) == "") { ?>
		<th data-name="VALOR_DEPREC_EJERCICIO" class="<?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->headerCellClass() ?>"><div id="elh_procesos_nuevo_VALOR_DEPREC_EJERCICIO" class="procesos_nuevo_VALOR_DEPREC_EJERCICIO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="VALOR_DEPREC_EJERCICIO" class="<?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO) ?>', 1);"><div id="elh_procesos_nuevo_VALOR_DEPREC_EJERCICIO" class="procesos_nuevo_VALOR_DEPREC_EJERCICIO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->Visible) { // VALOR_DEPREC_ACUMULADO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO) == "") { ?>
		<th data-name="VALOR_DEPREC_ACUMULADO" class="<?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->headerCellClass() ?>"><div id="elh_procesos_nuevo_VALOR_DEPREC_ACUMULADO" class="procesos_nuevo_VALOR_DEPREC_ACUMULADO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="VALOR_DEPREC_ACUMULADO" class="<?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO) ?>', 1);"><div id="elh_procesos_nuevo_VALOR_DEPREC_ACUMULADO" class="procesos_nuevo_VALOR_DEPREC_ACUMULADO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->VALOR_NETO->Visible) { // VALOR_NETO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_NETO) == "") { ?>
		<th data-name="VALOR_NETO" class="<?php echo $procesos_nuevo_list->VALOR_NETO->headerCellClass() ?>"><div id="elh_procesos_nuevo_VALOR_NETO" class="procesos_nuevo_VALOR_NETO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_NETO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="VALOR_NETO" class="<?php echo $procesos_nuevo_list->VALOR_NETO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->VALOR_NETO) ?>', 1);"><div id="elh_procesos_nuevo_VALOR_NETO" class="procesos_nuevo_VALOR_NETO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->VALOR_NETO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->VALOR_NETO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->VALOR_NETO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIP_USO_CUENTA->Visible) { // TIP_USO_CUENTA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIP_USO_CUENTA) == "") { ?>
		<th data-name="TIP_USO_CUENTA" class="<?php echo $procesos_nuevo_list->TIP_USO_CUENTA->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIP_USO_CUENTA" class="procesos_nuevo_TIP_USO_CUENTA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIP_USO_CUENTA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIP_USO_CUENTA" class="<?php echo $procesos_nuevo_list->TIP_USO_CUENTA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIP_USO_CUENTA) ?>', 1);"><div id="elh_procesos_nuevo_TIP_USO_CUENTA" class="procesos_nuevo_TIP_USO_CUENTA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIP_USO_CUENTA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIP_USO_CUENTA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIP_USO_CUENTA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIPO_CUENTA->Visible) { // TIPO_CUENTA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_CUENTA) == "") { ?>
		<th data-name="TIPO_CUENTA" class="<?php echo $procesos_nuevo_list->TIPO_CUENTA->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIPO_CUENTA" class="procesos_nuevo_TIPO_CUENTA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_CUENTA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIPO_CUENTA" class="<?php echo $procesos_nuevo_list->TIPO_CUENTA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO_CUENTA) ?>', 1);"><div id="elh_procesos_nuevo_TIPO_CUENTA" class="procesos_nuevo_TIPO_CUENTA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO_CUENTA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIPO_CUENTA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIPO_CUENTA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_CUENTA_CONTABLE->Visible) { // NRO_CUENTA_CONTABLE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_CUENTA_CONTABLE) == "") { ?>
		<th data-name="NRO_CUENTA_CONTABLE" class="<?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_CUENTA_CONTABLE" class="procesos_nuevo_NRO_CUENTA_CONTABLE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_CUENTA_CONTABLE" class="<?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_CUENTA_CONTABLE) ?>', 1);"><div id="elh_procesos_nuevo_NRO_CUENTA_CONTABLE" class="procesos_nuevo_NRO_CUENTA_CONTABLE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_CUENTA_CONTABLE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_CUENTA_CONTABLE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CTA_CON_SEGURO->Visible) { // CTA_CON_SEGURO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CTA_CON_SEGURO) == "") { ?>
		<th data-name="CTA_CON_SEGURO" class="<?php echo $procesos_nuevo_list->CTA_CON_SEGURO->headerCellClass() ?>"><div id="elh_procesos_nuevo_CTA_CON_SEGURO" class="procesos_nuevo_CTA_CON_SEGURO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CTA_CON_SEGURO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CTA_CON_SEGURO" class="<?php echo $procesos_nuevo_list->CTA_CON_SEGURO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CTA_CON_SEGURO) ?>', 1);"><div id="elh_procesos_nuevo_CTA_CON_SEGURO" class="procesos_nuevo_CTA_CON_SEGURO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CTA_CON_SEGURO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CTA_CON_SEGURO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CTA_CON_SEGURO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ESTADO_BIEN->Visible) { // ESTADO_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESTADO_BIEN) == "") { ?>
		<th data-name="ESTADO_BIEN" class="<?php echo $procesos_nuevo_list->ESTADO_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_ESTADO_BIEN" class="procesos_nuevo_ESTADO_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESTADO_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ESTADO_BIEN" class="<?php echo $procesos_nuevo_list->ESTADO_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESTADO_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_ESTADO_BIEN" class="procesos_nuevo_ESTADO_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESTADO_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ESTADO_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ESTADO_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CONDICION->Visible) { // CONDICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CONDICION) == "") { ?>
		<th data-name="CONDICION" class="<?php echo $procesos_nuevo_list->CONDICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_CONDICION" class="procesos_nuevo_CONDICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CONDICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CONDICION" class="<?php echo $procesos_nuevo_list->CONDICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CONDICION) ?>', 1);"><div id="elh_procesos_nuevo_CONDICION" class="procesos_nuevo_CONDICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CONDICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CONDICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CONDICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->MARCA->Visible) { // MARCA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->MARCA) == "") { ?>
		<th data-name="MARCA" class="<?php echo $procesos_nuevo_list->MARCA->headerCellClass() ?>"><div id="elh_procesos_nuevo_MARCA" class="procesos_nuevo_MARCA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MARCA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MARCA" class="<?php echo $procesos_nuevo_list->MARCA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->MARCA) ?>', 1);"><div id="elh_procesos_nuevo_MARCA" class="procesos_nuevo_MARCA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MARCA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->MARCA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->MARCA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->MODELO->Visible) { // MODELO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->MODELO) == "") { ?>
		<th data-name="MODELO" class="<?php echo $procesos_nuevo_list->MODELO->headerCellClass() ?>"><div id="elh_procesos_nuevo_MODELO" class="procesos_nuevo_MODELO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MODELO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MODELO" class="<?php echo $procesos_nuevo_list->MODELO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->MODELO) ?>', 1);"><div id="elh_procesos_nuevo_MODELO" class="procesos_nuevo_MODELO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MODELO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->MODELO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->MODELO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->TIPO->Visible) { // TIPO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO) == "") { ?>
		<th data-name="TIPO" class="<?php echo $procesos_nuevo_list->TIPO->headerCellClass() ?>"><div id="elh_procesos_nuevo_TIPO" class="procesos_nuevo_TIPO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TIPO" class="<?php echo $procesos_nuevo_list->TIPO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->TIPO) ?>', 1);"><div id="elh_procesos_nuevo_TIPO" class="procesos_nuevo_TIPO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->TIPO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->TIPO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->TIPO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->COLOR->Visible) { // COLOR ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->COLOR) == "") { ?>
		<th data-name="COLOR" class="<?php echo $procesos_nuevo_list->COLOR->headerCellClass() ?>"><div id="elh_procesos_nuevo_COLOR" class="procesos_nuevo_COLOR"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->COLOR->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="COLOR" class="<?php echo $procesos_nuevo_list->COLOR->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->COLOR) ?>', 1);"><div id="elh_procesos_nuevo_COLOR" class="procesos_nuevo_COLOR">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->COLOR->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->COLOR->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->COLOR->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SERIE->Visible) { // SERIE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SERIE) == "") { ?>
		<th data-name="SERIE" class="<?php echo $procesos_nuevo_list->SERIE->headerCellClass() ?>"><div id="elh_procesos_nuevo_SERIE" class="procesos_nuevo_SERIE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SERIE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SERIE" class="<?php echo $procesos_nuevo_list->SERIE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SERIE) ?>', 1);"><div id="elh_procesos_nuevo_SERIE" class="procesos_nuevo_SERIE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SERIE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SERIE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SERIE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DIMENSION->Visible) { // DIMENSION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DIMENSION) == "") { ?>
		<th data-name="DIMENSION" class="<?php echo $procesos_nuevo_list->DIMENSION->headerCellClass() ?>"><div id="elh_procesos_nuevo_DIMENSION" class="procesos_nuevo_DIMENSION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DIMENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DIMENSION" class="<?php echo $procesos_nuevo_list->DIMENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DIMENSION) ?>', 1);"><div id="elh_procesos_nuevo_DIMENSION" class="procesos_nuevo_DIMENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DIMENSION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DIMENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DIMENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PLACA->Visible) { // PLACA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PLACA) == "") { ?>
		<th data-name="PLACA" class="<?php echo $procesos_nuevo_list->PLACA->headerCellClass() ?>"><div id="elh_procesos_nuevo_PLACA" class="procesos_nuevo_PLACA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PLACA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PLACA" class="<?php echo $procesos_nuevo_list->PLACA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PLACA) ?>', 1);"><div id="elh_procesos_nuevo_PLACA" class="procesos_nuevo_PLACA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PLACA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PLACA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PLACA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_MOTOR->Visible) { // NRO_MOTOR ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_MOTOR) == "") { ?>
		<th data-name="NRO_MOTOR" class="<?php echo $procesos_nuevo_list->NRO_MOTOR->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_MOTOR" class="procesos_nuevo_NRO_MOTOR"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_MOTOR->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_MOTOR" class="<?php echo $procesos_nuevo_list->NRO_MOTOR->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_MOTOR) ?>', 1);"><div id="elh_procesos_nuevo_NRO_MOTOR" class="procesos_nuevo_NRO_MOTOR">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_MOTOR->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_MOTOR->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_MOTOR->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_CHASIS->Visible) { // NRO_CHASIS ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_CHASIS) == "") { ?>
		<th data-name="NRO_CHASIS" class="<?php echo $procesos_nuevo_list->NRO_CHASIS->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_CHASIS" class="procesos_nuevo_NRO_CHASIS"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_CHASIS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_CHASIS" class="<?php echo $procesos_nuevo_list->NRO_CHASIS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_CHASIS) ?>', 1);"><div id="elh_procesos_nuevo_NRO_CHASIS" class="procesos_nuevo_NRO_CHASIS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_CHASIS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_CHASIS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_CHASIS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->MATRICULA->Visible) { // MATRICULA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->MATRICULA) == "") { ?>
		<th data-name="MATRICULA" class="<?php echo $procesos_nuevo_list->MATRICULA->headerCellClass() ?>"><div id="elh_procesos_nuevo_MATRICULA" class="procesos_nuevo_MATRICULA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MATRICULA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MATRICULA" class="<?php echo $procesos_nuevo_list->MATRICULA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->MATRICULA) ?>', 1);"><div id="elh_procesos_nuevo_MATRICULA" class="procesos_nuevo_MATRICULA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MATRICULA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->MATRICULA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->MATRICULA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ANIO_FABRICACION->Visible) { // ANIO_FABRICACION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ANIO_FABRICACION) == "") { ?>
		<th data-name="ANIO_FABRICACION" class="<?php echo $procesos_nuevo_list->ANIO_FABRICACION->headerCellClass() ?>"><div id="elh_procesos_nuevo_ANIO_FABRICACION" class="procesos_nuevo_ANIO_FABRICACION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ANIO_FABRICACION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ANIO_FABRICACION" class="<?php echo $procesos_nuevo_list->ANIO_FABRICACION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ANIO_FABRICACION) ?>', 1);"><div id="elh_procesos_nuevo_ANIO_FABRICACION" class="procesos_nuevo_ANIO_FABRICACION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ANIO_FABRICACION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ANIO_FABRICACION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ANIO_FABRICACION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->LONGITUD->Visible) { // LONGITUD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->LONGITUD) == "") { ?>
		<th data-name="LONGITUD" class="<?php echo $procesos_nuevo_list->LONGITUD->headerCellClass() ?>"><div id="elh_procesos_nuevo_LONGITUD" class="procesos_nuevo_LONGITUD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->LONGITUD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LONGITUD" class="<?php echo $procesos_nuevo_list->LONGITUD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->LONGITUD) ?>', 1);"><div id="elh_procesos_nuevo_LONGITUD" class="procesos_nuevo_LONGITUD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->LONGITUD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->LONGITUD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->LONGITUD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ALTURA->Visible) { // ALTURA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ALTURA) == "") { ?>
		<th data-name="ALTURA" class="<?php echo $procesos_nuevo_list->ALTURA->headerCellClass() ?>"><div id="elh_procesos_nuevo_ALTURA" class="procesos_nuevo_ALTURA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ALTURA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ALTURA" class="<?php echo $procesos_nuevo_list->ALTURA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ALTURA) ?>', 1);"><div id="elh_procesos_nuevo_ALTURA" class="procesos_nuevo_ALTURA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ALTURA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ALTURA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ALTURA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ANCHO->Visible) { // ANCHO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ANCHO) == "") { ?>
		<th data-name="ANCHO" class="<?php echo $procesos_nuevo_list->ANCHO->headerCellClass() ?>"><div id="elh_procesos_nuevo_ANCHO" class="procesos_nuevo_ANCHO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ANCHO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ANCHO" class="<?php echo $procesos_nuevo_list->ANCHO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ANCHO) ?>', 1);"><div id="elh_procesos_nuevo_ANCHO" class="procesos_nuevo_ANCHO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ANCHO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ANCHO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ANCHO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->RAZA->Visible) { // RAZA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->RAZA) == "") { ?>
		<th data-name="RAZA" class="<?php echo $procesos_nuevo_list->RAZA->headerCellClass() ?>"><div id="elh_procesos_nuevo_RAZA" class="procesos_nuevo_RAZA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->RAZA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RAZA" class="<?php echo $procesos_nuevo_list->RAZA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->RAZA) ?>', 1);"><div id="elh_procesos_nuevo_RAZA" class="procesos_nuevo_RAZA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->RAZA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->RAZA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->RAZA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ESPECIE->Visible) { // ESPECIE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESPECIE) == "") { ?>
		<th data-name="ESPECIE" class="<?php echo $procesos_nuevo_list->ESPECIE->headerCellClass() ?>"><div id="elh_procesos_nuevo_ESPECIE" class="procesos_nuevo_ESPECIE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESPECIE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ESPECIE" class="<?php echo $procesos_nuevo_list->ESPECIE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESPECIE) ?>', 1);"><div id="elh_procesos_nuevo_ESPECIE" class="procesos_nuevo_ESPECIE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESPECIE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ESPECIE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ESPECIE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->EDAD->Visible) { // EDAD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->EDAD) == "") { ?>
		<th data-name="EDAD" class="<?php echo $procesos_nuevo_list->EDAD->headerCellClass() ?>"><div id="elh_procesos_nuevo_EDAD" class="procesos_nuevo_EDAD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->EDAD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EDAD" class="<?php echo $procesos_nuevo_list->EDAD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->EDAD) ?>', 1);"><div id="elh_procesos_nuevo_EDAD" class="procesos_nuevo_EDAD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->EDAD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->EDAD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->EDAD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PAIS->Visible) { // PAIS ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PAIS) == "") { ?>
		<th data-name="PAIS" class="<?php echo $procesos_nuevo_list->PAIS->headerCellClass() ?>"><div id="elh_procesos_nuevo_PAIS" class="procesos_nuevo_PAIS"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PAIS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PAIS" class="<?php echo $procesos_nuevo_list->PAIS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PAIS) ?>', 1);"><div id="elh_procesos_nuevo_PAIS" class="procesos_nuevo_PAIS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PAIS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PAIS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PAIS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->OTRAS_CARACT->Visible) { // OTRAS_CARACT ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->OTRAS_CARACT) == "") { ?>
		<th data-name="OTRAS_CARACT" class="<?php echo $procesos_nuevo_list->OTRAS_CARACT->headerCellClass() ?>"><div id="elh_procesos_nuevo_OTRAS_CARACT" class="procesos_nuevo_OTRAS_CARACT"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OTRAS_CARACT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OTRAS_CARACT" class="<?php echo $procesos_nuevo_list->OTRAS_CARACT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->OTRAS_CARACT) ?>', 1);"><div id="elh_procesos_nuevo_OTRAS_CARACT" class="procesos_nuevo_OTRAS_CARACT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OTRAS_CARACT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->OTRAS_CARACT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->OTRAS_CARACT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->Visible) { // DESCRIPCION_UBICACION_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN) == "") { ?>
		<th data-name="DESCRIPCION_UBICACION_BIEN" class="<?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_DESCRIPCION_UBICACION_BIEN" class="procesos_nuevo_DESCRIPCION_UBICACION_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DESCRIPCION_UBICACION_BIEN" class="<?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_DESCRIPCION_UBICACION_BIEN" class="procesos_nuevo_DESCRIPCION_UBICACION_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CAUSAL_BAJA->Visible) { // CAUSAL_BAJA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CAUSAL_BAJA) == "") { ?>
		<th data-name="CAUSAL_BAJA" class="<?php echo $procesos_nuevo_list->CAUSAL_BAJA->headerCellClass() ?>"><div id="elh_procesos_nuevo_CAUSAL_BAJA" class="procesos_nuevo_CAUSAL_BAJA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CAUSAL_BAJA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CAUSAL_BAJA" class="<?php echo $procesos_nuevo_list->CAUSAL_BAJA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CAUSAL_BAJA) ?>', 1);"><div id="elh_procesos_nuevo_CAUSAL_BAJA" class="procesos_nuevo_CAUSAL_BAJA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CAUSAL_BAJA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CAUSAL_BAJA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CAUSAL_BAJA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_RESOLUCION_BAJA->Visible) { // NRO_RESOLUCION_BAJA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_RESOLUCION_BAJA) == "") { ?>
		<th data-name="NRO_RESOLUCION_BAJA" class="<?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_RESOLUCION_BAJA" class="procesos_nuevo_NRO_RESOLUCION_BAJA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_RESOLUCION_BAJA" class="<?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_RESOLUCION_BAJA) ?>', 1);"><div id="elh_procesos_nuevo_NRO_RESOLUCION_BAJA" class="procesos_nuevo_NRO_RESOLUCION_BAJA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_RESOLUCION_BAJA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_RESOLUCION_BAJA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_BAJA->Visible) { // FECHA_BAJA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_BAJA) == "") { ?>
		<th data-name="FECHA_BAJA" class="<?php echo $procesos_nuevo_list->FECHA_BAJA->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_BAJA" class="procesos_nuevo_FECHA_BAJA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_BAJA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_BAJA" class="<?php echo $procesos_nuevo_list->FECHA_BAJA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_BAJA) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_BAJA" class="procesos_nuevo_FECHA_BAJA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_BAJA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_BAJA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_BAJA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ACTO_DISPOSICION_BIEN->Visible) { // ACTO_DISPOSICION_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ACTO_DISPOSICION_BIEN) == "") { ?>
		<th data-name="ACTO_DISPOSICION_BIEN" class="<?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_ACTO_DISPOSICION_BIEN" class="procesos_nuevo_ACTO_DISPOSICION_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACTO_DISPOSICION_BIEN" class="<?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ACTO_DISPOSICION_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_ACTO_DISPOSICION_BIEN" class="procesos_nuevo_ACTO_DISPOSICION_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ACTO_DISPOSICION_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ACTO_DISPOSICION_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NRO_RESOLUCION_DISP->Visible) { // NRO_RESOLUCION_DISP ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_RESOLUCION_DISP) == "") { ?>
		<th data-name="NRO_RESOLUCION_DISP" class="<?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->headerCellClass() ?>"><div id="elh_procesos_nuevo_NRO_RESOLUCION_DISP" class="procesos_nuevo_NRO_RESOLUCION_DISP"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NRO_RESOLUCION_DISP" class="<?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NRO_RESOLUCION_DISP) ?>', 1);"><div id="elh_procesos_nuevo_NRO_RESOLUCION_DISP" class="procesos_nuevo_NRO_RESOLUCION_DISP">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NRO_RESOLUCION_DISP->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NRO_RESOLUCION_DISP->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_DISPOSICION->Visible) { // FECHA_DISPOSICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_DISPOSICION) == "") { ?>
		<th data-name="FECHA_DISPOSICION" class="<?php echo $procesos_nuevo_list->FECHA_DISPOSICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_DISPOSICION" class="procesos_nuevo_FECHA_DISPOSICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_DISPOSICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_DISPOSICION" class="<?php echo $procesos_nuevo_list->FECHA_DISPOSICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_DISPOSICION) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_DISPOSICION" class="procesos_nuevo_FECHA_DISPOSICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_DISPOSICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_DISPOSICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_DISPOSICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Visible) { // ENTIDAD_BENEFICIADA_ACTO_DISPOSICION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION) == "") { ?>
		<th data-name="ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->headerCellClass() ?>"><div id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION) ?>', 1);"><div id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->Visible) { // MOTIVO_ELIMINACION_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN) == "") { ?>
		<th data-name="MOTIVO_ELIMINACION_BIEN" class="<?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_MOTIVO_ELIMINACION_BIEN" class="procesos_nuevo_MOTIVO_ELIMINACION_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MOTIVO_ELIMINACION_BIEN" class="<?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_MOTIVO_ELIMINACION_BIEN" class="procesos_nuevo_MOTIVO_ELIMINACION_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->Visible) { // ACTO_ADMINISTRACION_BIEN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN) == "") { ?>
		<th data-name="ACTO_ADMINISTRACION_BIEN" class="<?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->headerCellClass() ?>"><div id="elh_procesos_nuevo_ACTO_ADMINISTRACION_BIEN" class="procesos_nuevo_ACTO_ADMINISTRACION_BIEN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACTO_ADMINISTRACION_BIEN" class="<?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN) ?>', 1);"><div id="elh_procesos_nuevo_ACTO_ADMINISTRACION_BIEN" class="procesos_nuevo_ACTO_ADMINISTRACION_BIEN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->Visible) { // NUM_RESOLUCION_ADMINISTRACION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION) == "") { ?>
		<th data-name="NUM_RESOLUCION_ADMINISTRACION" class="<?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->headerCellClass() ?>"><div id="elh_procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION" class="procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NUM_RESOLUCION_ADMINISTRACION" class="<?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION) ?>', 1);"><div id="elh_procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION" class="procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_ADMINISTRACION->Visible) { // FECHA_ADMINISTRACION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_ADMINISTRACION) == "") { ?>
		<th data-name="FECHA_ADMINISTRACION" class="<?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_ADMINISTRACION" class="procesos_nuevo_FECHA_ADMINISTRACION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_ADMINISTRACION" class="<?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_ADMINISTRACION) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_ADMINISTRACION" class="procesos_nuevo_FECHA_ADMINISTRACION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_ADMINISTRACION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_ADMINISTRACION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->Visible) { // FECHA_VENC_ACTO_ADMIN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN) == "") { ?>
		<th data-name="FECHA_VENC_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_VENC_ACTO_ADMIN" class="procesos_nuevo_FECHA_VENC_ACTO_ADMIN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_VENC_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_VENC_ACTO_ADMIN" class="procesos_nuevo_FECHA_VENC_ACTO_ADMIN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Visible) { // ENTIDAD_BENEFICIADA_ACTO_ADMIN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN) == "") { ?>
		<th data-name="ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->headerCellClass() ?>"><div id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN) ?>', 1);"><div id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DOC_ALTA_SBN->Visible) { // DOC_ALTA_SBN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DOC_ALTA_SBN) == "") { ?>
		<th data-name="DOC_ALTA_SBN" class="<?php echo $procesos_nuevo_list->DOC_ALTA_SBN->headerCellClass() ?>"><div id="elh_procesos_nuevo_DOC_ALTA_SBN" class="procesos_nuevo_DOC_ALTA_SBN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DOC_ALTA_SBN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DOC_ALTA_SBN" class="<?php echo $procesos_nuevo_list->DOC_ALTA_SBN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DOC_ALTA_SBN) ?>', 1);"><div id="elh_procesos_nuevo_DOC_ALTA_SBN" class="procesos_nuevo_DOC_ALTA_SBN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DOC_ALTA_SBN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DOC_ALTA_SBN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DOC_ALTA_SBN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DOC_BAJA_SBN->Visible) { // DOC_BAJA_SBN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DOC_BAJA_SBN) == "") { ?>
		<th data-name="DOC_BAJA_SBN" class="<?php echo $procesos_nuevo_list->DOC_BAJA_SBN->headerCellClass() ?>"><div id="elh_procesos_nuevo_DOC_BAJA_SBN" class="procesos_nuevo_DOC_BAJA_SBN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DOC_BAJA_SBN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DOC_BAJA_SBN" class="<?php echo $procesos_nuevo_list->DOC_BAJA_SBN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DOC_BAJA_SBN) ?>', 1);"><div id="elh_procesos_nuevo_DOC_BAJA_SBN" class="procesos_nuevo_DOC_BAJA_SBN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DOC_BAJA_SBN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DOC_BAJA_SBN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DOC_BAJA_SBN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->DEPENDENCIAS->Visible) { // DEPENDENCIAS ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->DEPENDENCIAS) == "") { ?>
		<th data-name="DEPENDENCIAS" class="<?php echo $procesos_nuevo_list->DEPENDENCIAS->headerCellClass() ?>"><div id="elh_procesos_nuevo_DEPENDENCIAS" class="procesos_nuevo_DEPENDENCIAS"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DEPENDENCIAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DEPENDENCIAS" class="<?php echo $procesos_nuevo_list->DEPENDENCIAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->DEPENDENCIAS) ?>', 1);"><div id="elh_procesos_nuevo_DEPENDENCIAS" class="procesos_nuevo_DEPENDENCIAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->DEPENDENCIAS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->DEPENDENCIAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->DEPENDENCIAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NUMERO_FICHA->Visible) { // NUMERO_FICHA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NUMERO_FICHA) == "") { ?>
		<th data-name="NUMERO_FICHA" class="<?php echo $procesos_nuevo_list->NUMERO_FICHA->headerCellClass() ?>"><div id="elh_procesos_nuevo_NUMERO_FICHA" class="procesos_nuevo_NUMERO_FICHA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NUMERO_FICHA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NUMERO_FICHA" class="<?php echo $procesos_nuevo_list->NUMERO_FICHA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NUMERO_FICHA) ?>', 1);"><div id="elh_procesos_nuevo_NUMERO_FICHA" class="procesos_nuevo_NUMERO_FICHA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NUMERO_FICHA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NUMERO_FICHA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NUMERO_FICHA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CODIGO_INTERNO->Visible) { // CODIGO_INTERNO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_INTERNO) == "") { ?>
		<th data-name="CODIGO_INTERNO" class="<?php echo $procesos_nuevo_list->CODIGO_INTERNO->headerCellClass() ?>"><div id="elh_procesos_nuevo_CODIGO_INTERNO" class="procesos_nuevo_CODIGO_INTERNO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_INTERNO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CODIGO_INTERNO" class="<?php echo $procesos_nuevo_list->CODIGO_INTERNO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_INTERNO) ?>', 1);"><div id="elh_procesos_nuevo_CODIGO_INTERNO" class="procesos_nuevo_CODIGO_INTERNO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_INTERNO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CODIGO_INTERNO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CODIGO_INTERNO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ESTADO->Visible) { // ESTADO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESTADO) == "") { ?>
		<th data-name="ESTADO" class="<?php echo $procesos_nuevo_list->ESTADO->headerCellClass() ?>"><div id="elh_procesos_nuevo_ESTADO" class="procesos_nuevo_ESTADO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESTADO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ESTADO" class="<?php echo $procesos_nuevo_list->ESTADO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ESTADO) ?>', 1);"><div id="elh_procesos_nuevo_ESTADO" class="procesos_nuevo_ESTADO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ESTADO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ESTADO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ESTADO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->USO->Visible) { // USO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->USO) == "") { ?>
		<th data-name="USO" class="<?php echo $procesos_nuevo_list->USO->headerCellClass() ?>"><div id="elh_procesos_nuevo_USO" class="procesos_nuevo_USO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->USO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="USO" class="<?php echo $procesos_nuevo_list->USO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->USO) ?>', 1);"><div id="elh_procesos_nuevo_USO" class="procesos_nuevo_USO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->USO->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->USO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->USO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->STICKER->Visible) { // STICKER ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->STICKER) == "") { ?>
		<th data-name="STICKER" class="<?php echo $procesos_nuevo_list->STICKER->headerCellClass() ?>"><div id="elh_procesos_nuevo_STICKER" class="procesos_nuevo_STICKER"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->STICKER->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="STICKER" class="<?php echo $procesos_nuevo_list->STICKER->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->STICKER) ?>', 1);"><div id="elh_procesos_nuevo_STICKER" class="procesos_nuevo_STICKER">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->STICKER->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->STICKER->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->STICKER->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SEDE->Visible) { // SEDE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SEDE) == "") { ?>
		<th data-name="SEDE" class="<?php echo $procesos_nuevo_list->SEDE->headerCellClass() ?>"><div id="elh_procesos_nuevo_SEDE" class="procesos_nuevo_SEDE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SEDE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SEDE" class="<?php echo $procesos_nuevo_list->SEDE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SEDE) ?>', 1);"><div id="elh_procesos_nuevo_SEDE" class="procesos_nuevo_SEDE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SEDE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SEDE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SEDE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SBN->Visible) { // SBN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SBN) == "") { ?>
		<th data-name="SBN" class="<?php echo $procesos_nuevo_list->SBN->headerCellClass() ?>"><div id="elh_procesos_nuevo_SBN" class="procesos_nuevo_SBN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SBN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SBN" class="<?php echo $procesos_nuevo_list->SBN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SBN) ?>', 1);"><div id="elh_procesos_nuevo_SBN" class="procesos_nuevo_SBN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SBN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SBN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SBN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->ETIQUETA->Visible) { // ETIQUETA ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->ETIQUETA) == "") { ?>
		<th data-name="ETIQUETA" class="<?php echo $procesos_nuevo_list->ETIQUETA->headerCellClass() ?>"><div id="elh_procesos_nuevo_ETIQUETA" class="procesos_nuevo_ETIQUETA"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ETIQUETA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ETIQUETA" class="<?php echo $procesos_nuevo_list->ETIQUETA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->ETIQUETA) ?>', 1);"><div id="elh_procesos_nuevo_ETIQUETA" class="procesos_nuevo_ETIQUETA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->ETIQUETA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->ETIQUETA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->ETIQUETA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Visible) { // NOMBRE_BENEFICIARIO_ACTO_ADMIN ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN) == "") { ?>
		<th data-name="NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->headerCellClass() ?>"><div id="elh_procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="<?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN) ?>', 1);"><div id="elh_procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PLACA_RODAJE->Visible) { // PLACA_RODAJE ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PLACA_RODAJE) == "") { ?>
		<th data-name="PLACA_RODAJE" class="<?php echo $procesos_nuevo_list->PLACA_RODAJE->headerCellClass() ?>"><div id="elh_procesos_nuevo_PLACA_RODAJE" class="procesos_nuevo_PLACA_RODAJE"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PLACA_RODAJE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PLACA_RODAJE" class="<?php echo $procesos_nuevo_list->PLACA_RODAJE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PLACA_RODAJE) ?>', 1);"><div id="elh_procesos_nuevo_PLACA_RODAJE" class="procesos_nuevo_PLACA_RODAJE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PLACA_RODAJE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PLACA_RODAJE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PLACA_RODAJE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CODIGO_ACTUAL->Visible) { // CODIGO_ACTUAL ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_ACTUAL) == "") { ?>
		<th data-name="CODIGO_ACTUAL" class="<?php echo $procesos_nuevo_list->CODIGO_ACTUAL->headerCellClass() ?>"><div id="elh_procesos_nuevo_CODIGO_ACTUAL" class="procesos_nuevo_CODIGO_ACTUAL"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_ACTUAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CODIGO_ACTUAL" class="<?php echo $procesos_nuevo_list->CODIGO_ACTUAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_ACTUAL) ?>', 1);"><div id="elh_procesos_nuevo_CODIGO_ACTUAL" class="procesos_nuevo_CODIGO_ACTUAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_ACTUAL->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CODIGO_ACTUAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CODIGO_ACTUAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->CODIGO_ANTERIOR->Visible) { // CODIGO_ANTERIOR ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_ANTERIOR) == "") { ?>
		<th data-name="CODIGO_ANTERIOR" class="<?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->headerCellClass() ?>"><div id="elh_procesos_nuevo_CODIGO_ANTERIOR" class="procesos_nuevo_CODIGO_ANTERIOR"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CODIGO_ANTERIOR" class="<?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->CODIGO_ANTERIOR) ?>', 1);"><div id="elh_procesos_nuevo_CODIGO_ANTERIOR" class="procesos_nuevo_CODIGO_ANTERIOR">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->CODIGO_ANTERIOR->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->CODIGO_ANTERIOR->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->PROPIEDAD->Visible) { // PROPIEDAD ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->PROPIEDAD) == "") { ?>
		<th data-name="PROPIEDAD" class="<?php echo $procesos_nuevo_list->PROPIEDAD->headerCellClass() ?>"><div id="elh_procesos_nuevo_PROPIEDAD" class="procesos_nuevo_PROPIEDAD"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PROPIEDAD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PROPIEDAD" class="<?php echo $procesos_nuevo_list->PROPIEDAD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->PROPIEDAD) ?>', 1);"><div id="elh_procesos_nuevo_PROPIEDAD" class="procesos_nuevo_PROPIEDAD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->PROPIEDAD->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->PROPIEDAD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->PROPIEDAD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->SITUACION->Visible) { // SITUACION ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->SITUACION) == "") { ?>
		<th data-name="SITUACION" class="<?php echo $procesos_nuevo_list->SITUACION->headerCellClass() ?>"><div id="elh_procesos_nuevo_SITUACION" class="procesos_nuevo_SITUACION"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SITUACION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SITUACION" class="<?php echo $procesos_nuevo_list->SITUACION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->SITUACION) ?>', 1);"><div id="elh_procesos_nuevo_SITUACION" class="procesos_nuevo_SITUACION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->SITUACION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->SITUACION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->SITUACION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->OBSERVACIONES->Visible) { // OBSERVACIONES ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->OBSERVACIONES) == "") { ?>
		<th data-name="OBSERVACIONES" class="<?php echo $procesos_nuevo_list->OBSERVACIONES->headerCellClass() ?>"><div id="elh_procesos_nuevo_OBSERVACIONES" class="procesos_nuevo_OBSERVACIONES"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OBSERVACIONES->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OBSERVACIONES" class="<?php echo $procesos_nuevo_list->OBSERVACIONES->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->OBSERVACIONES) ?>', 1);"><div id="elh_procesos_nuevo_OBSERVACIONES" class="procesos_nuevo_OBSERVACIONES">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->OBSERVACIONES->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->OBSERVACIONES->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->OBSERVACIONES->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($procesos_nuevo_list->FECHA_REGISTRO->Visible) { // FECHA_REGISTRO ?>
	<?php if ($procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_REGISTRO) == "") { ?>
		<th data-name="FECHA_REGISTRO" class="<?php echo $procesos_nuevo_list->FECHA_REGISTRO->headerCellClass() ?>"><div id="elh_procesos_nuevo_FECHA_REGISTRO" class="procesos_nuevo_FECHA_REGISTRO"><div class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_REGISTRO->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FECHA_REGISTRO" class="<?php echo $procesos_nuevo_list->FECHA_REGISTRO->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $procesos_nuevo_list->SortUrl($procesos_nuevo_list->FECHA_REGISTRO) ?>', 1);"><div id="elh_procesos_nuevo_FECHA_REGISTRO" class="procesos_nuevo_FECHA_REGISTRO">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $procesos_nuevo_list->FECHA_REGISTRO->caption() ?></span><span class="ew-table-header-sort"><?php if ($procesos_nuevo_list->FECHA_REGISTRO->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($procesos_nuevo_list->FECHA_REGISTRO->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$procesos_nuevo_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($procesos_nuevo_list->ExportAll && $procesos_nuevo_list->isExport()) {
	$procesos_nuevo_list->StopRecord = $procesos_nuevo_list->TotalRecords;
} else {

	// Set the last record to display
	if ($procesos_nuevo_list->TotalRecords > $procesos_nuevo_list->StartRecord + $procesos_nuevo_list->DisplayRecords - 1)
		$procesos_nuevo_list->StopRecord = $procesos_nuevo_list->StartRecord + $procesos_nuevo_list->DisplayRecords - 1;
	else
		$procesos_nuevo_list->StopRecord = $procesos_nuevo_list->TotalRecords;
}
$procesos_nuevo_list->RecordCount = $procesos_nuevo_list->StartRecord - 1;
if ($procesos_nuevo_list->Recordset && !$procesos_nuevo_list->Recordset->EOF) {
	$procesos_nuevo_list->Recordset->moveFirst();
	$selectLimit = $procesos_nuevo_list->UseSelectLimit;
	if (!$selectLimit && $procesos_nuevo_list->StartRecord > 1)
		$procesos_nuevo_list->Recordset->move($procesos_nuevo_list->StartRecord - 1);
} elseif (!$procesos_nuevo->AllowAddDeleteRow && $procesos_nuevo_list->StopRecord == 0) {
	$procesos_nuevo_list->StopRecord = $procesos_nuevo->GridAddRowCount;
}

// Initialize aggregate
$procesos_nuevo->RowType = ROWTYPE_AGGREGATEINIT;
$procesos_nuevo->resetAttributes();
$procesos_nuevo_list->renderRow();
while ($procesos_nuevo_list->RecordCount < $procesos_nuevo_list->StopRecord) {
	$procesos_nuevo_list->RecordCount++;
	if ($procesos_nuevo_list->RecordCount >= $procesos_nuevo_list->StartRecord) {
		$procesos_nuevo_list->RowCount++;

		// Set up key count
		$procesos_nuevo_list->KeyCount = $procesos_nuevo_list->RowIndex;

		// Init row class and style
		$procesos_nuevo->resetAttributes();
		$procesos_nuevo->CssClass = "";
		if ($procesos_nuevo_list->isGridAdd()) {
		} else {
			$procesos_nuevo_list->loadRowValues($procesos_nuevo_list->Recordset); // Load row values
		}
		$procesos_nuevo->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$procesos_nuevo->RowAttrs->merge(["data-rowindex" => $procesos_nuevo_list->RowCount, "id" => "r" . $procesos_nuevo_list->RowCount . "_procesos_nuevo", "data-rowtype" => $procesos_nuevo->RowType]);

		// Render row
		$procesos_nuevo_list->renderRow();

		// Render list options
		$procesos_nuevo_list->renderListOptions();
?>
	<tr <?php echo $procesos_nuevo->rowAttributes() ?>>
<?php

// Render list options (body, left)
$procesos_nuevo_list->ListOptions->render("body", "left", $procesos_nuevo_list->RowCount);
?>
	<?php if ($procesos_nuevo_list->codigo->Visible) { // codigo ?>
		<td data-name="codigo" <?php echo $procesos_nuevo_list->codigo->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_codigo" class="procesos_nuevo_codigo">
<span<?php echo $procesos_nuevo_list->codigo->viewAttributes() ?>><?php echo $procesos_nuevo_list->codigo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->codigo_proceso->Visible) { // codigo_proceso ?>
		<td data-name="codigo_proceso" <?php echo $procesos_nuevo_list->codigo_proceso->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_codigo_proceso" class="procesos_nuevo_codigo_proceso">
<span<?php echo $procesos_nuevo_list->codigo_proceso->viewAttributes() ?>><?php echo $procesos_nuevo_list->codigo_proceso->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->no->Visible) { // no ?>
		<td data-name="no" <?php echo $procesos_nuevo_list->no->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_no" class="procesos_nuevo_no">
<span<?php echo $procesos_nuevo_list->no->viewAttributes() ?>><?php echo $procesos_nuevo_list->no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->usuarios->Visible) { // usuarios ?>
		<td data-name="usuarios" <?php echo $procesos_nuevo_list->usuarios->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_usuarios" class="procesos_nuevo_usuarios">
<span<?php echo $procesos_nuevo_list->usuarios->viewAttributes() ?>><?php echo $procesos_nuevo_list->usuarios->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SEC_EJEC->Visible) { // SEC_EJEC ?>
		<td data-name="SEC_EJEC" <?php echo $procesos_nuevo_list->SEC_EJEC->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SEC_EJEC" class="procesos_nuevo_SEC_EJEC">
<span<?php echo $procesos_nuevo_list->SEC_EJEC->viewAttributes() ?>><?php echo $procesos_nuevo_list->SEC_EJEC->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIPO_MODALIDAD->Visible) { // TIPO_MODALIDAD ?>
		<td data-name="TIPO_MODALIDAD" <?php echo $procesos_nuevo_list->TIPO_MODALIDAD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIPO_MODALIDAD" class="procesos_nuevo_TIPO_MODALIDAD">
<span<?php echo $procesos_nuevo_list->TIPO_MODALIDAD->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIPO_MODALIDAD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SECUENCIA->Visible) { // SECUENCIA ?>
		<td data-name="SECUENCIA" <?php echo $procesos_nuevo_list->SECUENCIA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SECUENCIA" class="procesos_nuevo_SECUENCIA">
<span<?php echo $procesos_nuevo_list->SECUENCIA->viewAttributes() ?>><?php echo $procesos_nuevo_list->SECUENCIA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->AMBIENTE->Visible) { // AMBIENTE ?>
		<td data-name="AMBIENTE" <?php echo $procesos_nuevo_list->AMBIENTE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_AMBIENTE" class="procesos_nuevo_AMBIENTE">
<span<?php echo $procesos_nuevo_list->AMBIENTE->viewAttributes() ?>><?php echo $procesos_nuevo_list->AMBIENTE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->RUC_ENTIDAD->Visible) { // RUC_ENTIDAD ?>
		<td data-name="RUC_ENTIDAD" <?php echo $procesos_nuevo_list->RUC_ENTIDAD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_RUC_ENTIDAD" class="procesos_nuevo_RUC_ENTIDAD">
<span<?php echo $procesos_nuevo_list->RUC_ENTIDAD->viewAttributes() ?>><?php echo $procesos_nuevo_list->RUC_ENTIDAD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->LOCAL->Visible) { // LOCAL ?>
		<td data-name="LOCAL" <?php echo $procesos_nuevo_list->LOCAL->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_LOCAL" class="procesos_nuevo_LOCAL">
<span<?php echo $procesos_nuevo_list->LOCAL->viewAttributes() ?>><?php echo $procesos_nuevo_list->LOCAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DEPARTAMENTO->Visible) { // DEPARTAMENTO ?>
		<td data-name="DEPARTAMENTO" <?php echo $procesos_nuevo_list->DEPARTAMENTO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DEPARTAMENTO" class="procesos_nuevo_DEPARTAMENTO">
<span<?php echo $procesos_nuevo_list->DEPARTAMENTO->viewAttributes() ?>><?php echo $procesos_nuevo_list->DEPARTAMENTO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PROVINCIA->Visible) { // PROVINCIA ?>
		<td data-name="PROVINCIA" <?php echo $procesos_nuevo_list->PROVINCIA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PROVINCIA" class="procesos_nuevo_PROVINCIA">
<span<?php echo $procesos_nuevo_list->PROVINCIA->viewAttributes() ?>><?php echo $procesos_nuevo_list->PROVINCIA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DISTRITO->Visible) { // DISTRITO ?>
		<td data-name="DISTRITO" <?php echo $procesos_nuevo_list->DISTRITO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DISTRITO" class="procesos_nuevo_DISTRITO">
<span<?php echo $procesos_nuevo_list->DISTRITO->viewAttributes() ?>><?php echo $procesos_nuevo_list->DISTRITO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->AREA->Visible) { // AREA ?>
		<td data-name="AREA" <?php echo $procesos_nuevo_list->AREA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_AREA" class="procesos_nuevo_AREA">
<span<?php echo $procesos_nuevo_list->AREA->viewAttributes() ?>><?php echo $procesos_nuevo_list->AREA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->OFICINA->Visible) { // OFICINA ?>
		<td data-name="OFICINA" <?php echo $procesos_nuevo_list->OFICINA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_OFICINA" class="procesos_nuevo_OFICINA">
<span<?php echo $procesos_nuevo_list->OFICINA->viewAttributes() ?>><?php echo $procesos_nuevo_list->OFICINA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PISO_OFICINA->Visible) { // PISO_OFICINA ?>
		<td data-name="PISO_OFICINA" <?php echo $procesos_nuevo_list->PISO_OFICINA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PISO_OFICINA" class="procesos_nuevo_PISO_OFICINA">
<span<?php echo $procesos_nuevo_list->PISO_OFICINA->viewAttributes() ?>><?php echo $procesos_nuevo_list->PISO_OFICINA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->Visible) { // NRO_DOC_IDENT_PERSONAL ?>
		<td data-name="NRO_DOC_IDENT_PERSONAL" <?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_DOC_IDENT_PERSONAL" class="procesos_nuevo_NRO_DOC_IDENT_PERSONAL">
<span<?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_DOC_IDENT_PERSONAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->APELLIDO_PATERNO->Visible) { // APELLIDO_PATERNO ?>
		<td data-name="APELLIDO_PATERNO" <?php echo $procesos_nuevo_list->APELLIDO_PATERNO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_APELLIDO_PATERNO" class="procesos_nuevo_APELLIDO_PATERNO">
<span<?php echo $procesos_nuevo_list->APELLIDO_PATERNO->viewAttributes() ?>><?php echo $procesos_nuevo_list->APELLIDO_PATERNO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->APELLIDO_MATERNO->Visible) { // APELLIDO_MATERNO ?>
		<td data-name="APELLIDO_MATERNO" <?php echo $procesos_nuevo_list->APELLIDO_MATERNO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_APELLIDO_MATERNO" class="procesos_nuevo_APELLIDO_MATERNO">
<span<?php echo $procesos_nuevo_list->APELLIDO_MATERNO->viewAttributes() ?>><?php echo $procesos_nuevo_list->APELLIDO_MATERNO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NOMBRES->Visible) { // NOMBRES ?>
		<td data-name="NOMBRES" <?php echo $procesos_nuevo_list->NOMBRES->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NOMBRES" class="procesos_nuevo_NOMBRES">
<span<?php echo $procesos_nuevo_list->NOMBRES->viewAttributes() ?>><?php echo $procesos_nuevo_list->NOMBRES->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->OPERATIVO->Visible) { // OPERATIVO ?>
		<td data-name="OPERATIVO" <?php echo $procesos_nuevo_list->OPERATIVO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_OPERATIVO" class="procesos_nuevo_OPERATIVO">
<span<?php echo $procesos_nuevo_list->OPERATIVO->viewAttributes() ?>><?php echo $procesos_nuevo_list->OPERATIVO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIPO_DOC_IDENTIDAD->Visible) { // TIPO_DOC_IDENTIDAD ?>
		<td data-name="TIPO_DOC_IDENTIDAD" <?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIPO_DOC_IDENTIDAD" class="procesos_nuevo_TIPO_DOC_IDENTIDAD">
<span<?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIPO_DOC_IDENTIDAD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->MODALIDAD_CONTRATO->Visible) { // MODALIDAD_CONTRATO ?>
		<td data-name="MODALIDAD_CONTRATO" <?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_MODALIDAD_CONTRATO" class="procesos_nuevo_MODALIDAD_CONTRATO">
<span<?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->viewAttributes() ?>><?php echo $procesos_nuevo_list->MODALIDAD_CONTRATO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CODIGO_PATRIMONIAL->Visible) { // CODIGO_PATRIMONIAL ?>
		<td data-name="CODIGO_PATRIMONIAL" <?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CODIGO_PATRIMONIAL" class="procesos_nuevo_CODIGO_PATRIMONIAL">
<span<?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->viewAttributes() ?>><?php echo $procesos_nuevo_list->CODIGO_PATRIMONIAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DENOMINACION_BIEN->Visible) { // DENOMINACION_BIEN ?>
		<td data-name="DENOMINACION_BIEN" <?php echo $procesos_nuevo_list->DENOMINACION_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DENOMINACION_BIEN" class="procesos_nuevo_DENOMINACION_BIEN">
<span<?php echo $procesos_nuevo_list->DENOMINACION_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->DENOMINACION_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIPO_CAUSAL_ALTA->Visible) { // TIPO_CAUSAL_ALTA ?>
		<td data-name="TIPO_CAUSAL_ALTA" <?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIPO_CAUSAL_ALTA" class="procesos_nuevo_TIPO_CAUSAL_ALTA">
<span<?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIPO_CAUSAL_ALTA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_DOC_ADQUISICION->Visible) { // NRO_DOC_ADQUISICION ?>
		<td data-name="NRO_DOC_ADQUISICION" <?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_DOC_ADQUISICION" class="procesos_nuevo_NRO_DOC_ADQUISICION">
<span<?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_DOC_ADQUISICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_ADQUISICION->Visible) { // FECHA_ADQUISICION ?>
		<td data-name="FECHA_ADQUISICION" <?php echo $procesos_nuevo_list->FECHA_ADQUISICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_ADQUISICION" class="procesos_nuevo_FECHA_ADQUISICION">
<span<?php echo $procesos_nuevo_list->FECHA_ADQUISICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_ADQUISICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->VALOR_ADQUISICION->Visible) { // VALOR_ADQUISICION ?>
		<td data-name="VALOR_ADQUISICION" <?php echo $procesos_nuevo_list->VALOR_ADQUISICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_VALOR_ADQUISICION" class="procesos_nuevo_VALOR_ADQUISICION">
<span<?php echo $procesos_nuevo_list->VALOR_ADQUISICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->VALOR_ADQUISICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_DEPRECIACION->Visible) { // FECHA_DEPRECIACION ?>
		<td data-name="FECHA_DEPRECIACION" <?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_DEPRECIACION" class="procesos_nuevo_FECHA_DEPRECIACION">
<span<?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_DEPRECIACION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->Visible) { // VALOR_DEPREC_EJERCICIO ?>
		<td data-name="VALOR_DEPREC_EJERCICIO" <?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_VALOR_DEPREC_EJERCICIO" class="procesos_nuevo_VALOR_DEPREC_EJERCICIO">
<span<?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->viewAttributes() ?>><?php echo $procesos_nuevo_list->VALOR_DEPREC_EJERCICIO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->Visible) { // VALOR_DEPREC_ACUMULADO ?>
		<td data-name="VALOR_DEPREC_ACUMULADO" <?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_VALOR_DEPREC_ACUMULADO" class="procesos_nuevo_VALOR_DEPREC_ACUMULADO">
<span<?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->viewAttributes() ?>><?php echo $procesos_nuevo_list->VALOR_DEPREC_ACUMULADO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->VALOR_NETO->Visible) { // VALOR_NETO ?>
		<td data-name="VALOR_NETO" <?php echo $procesos_nuevo_list->VALOR_NETO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_VALOR_NETO" class="procesos_nuevo_VALOR_NETO">
<span<?php echo $procesos_nuevo_list->VALOR_NETO->viewAttributes() ?>><?php echo $procesos_nuevo_list->VALOR_NETO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIP_USO_CUENTA->Visible) { // TIP_USO_CUENTA ?>
		<td data-name="TIP_USO_CUENTA" <?php echo $procesos_nuevo_list->TIP_USO_CUENTA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIP_USO_CUENTA" class="procesos_nuevo_TIP_USO_CUENTA">
<span<?php echo $procesos_nuevo_list->TIP_USO_CUENTA->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIP_USO_CUENTA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIPO_CUENTA->Visible) { // TIPO_CUENTA ?>
		<td data-name="TIPO_CUENTA" <?php echo $procesos_nuevo_list->TIPO_CUENTA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIPO_CUENTA" class="procesos_nuevo_TIPO_CUENTA">
<span<?php echo $procesos_nuevo_list->TIPO_CUENTA->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIPO_CUENTA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_CUENTA_CONTABLE->Visible) { // NRO_CUENTA_CONTABLE ?>
		<td data-name="NRO_CUENTA_CONTABLE" <?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_CUENTA_CONTABLE" class="procesos_nuevo_NRO_CUENTA_CONTABLE">
<span<?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_CUENTA_CONTABLE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CTA_CON_SEGURO->Visible) { // CTA_CON_SEGURO ?>
		<td data-name="CTA_CON_SEGURO" <?php echo $procesos_nuevo_list->CTA_CON_SEGURO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CTA_CON_SEGURO" class="procesos_nuevo_CTA_CON_SEGURO">
<span<?php echo $procesos_nuevo_list->CTA_CON_SEGURO->viewAttributes() ?>><?php echo $procesos_nuevo_list->CTA_CON_SEGURO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ESTADO_BIEN->Visible) { // ESTADO_BIEN ?>
		<td data-name="ESTADO_BIEN" <?php echo $procesos_nuevo_list->ESTADO_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ESTADO_BIEN" class="procesos_nuevo_ESTADO_BIEN">
<span<?php echo $procesos_nuevo_list->ESTADO_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->ESTADO_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CONDICION->Visible) { // CONDICION ?>
		<td data-name="CONDICION" <?php echo $procesos_nuevo_list->CONDICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CONDICION" class="procesos_nuevo_CONDICION">
<span<?php echo $procesos_nuevo_list->CONDICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->CONDICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->MARCA->Visible) { // MARCA ?>
		<td data-name="MARCA" <?php echo $procesos_nuevo_list->MARCA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_MARCA" class="procesos_nuevo_MARCA">
<span<?php echo $procesos_nuevo_list->MARCA->viewAttributes() ?>><?php echo $procesos_nuevo_list->MARCA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->MODELO->Visible) { // MODELO ?>
		<td data-name="MODELO" <?php echo $procesos_nuevo_list->MODELO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_MODELO" class="procesos_nuevo_MODELO">
<span<?php echo $procesos_nuevo_list->MODELO->viewAttributes() ?>><?php echo $procesos_nuevo_list->MODELO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->TIPO->Visible) { // TIPO ?>
		<td data-name="TIPO" <?php echo $procesos_nuevo_list->TIPO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_TIPO" class="procesos_nuevo_TIPO">
<span<?php echo $procesos_nuevo_list->TIPO->viewAttributes() ?>><?php echo $procesos_nuevo_list->TIPO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->COLOR->Visible) { // COLOR ?>
		<td data-name="COLOR" <?php echo $procesos_nuevo_list->COLOR->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_COLOR" class="procesos_nuevo_COLOR">
<span<?php echo $procesos_nuevo_list->COLOR->viewAttributes() ?>><?php echo $procesos_nuevo_list->COLOR->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SERIE->Visible) { // SERIE ?>
		<td data-name="SERIE" <?php echo $procesos_nuevo_list->SERIE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SERIE" class="procesos_nuevo_SERIE">
<span<?php echo $procesos_nuevo_list->SERIE->viewAttributes() ?>><?php echo $procesos_nuevo_list->SERIE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DIMENSION->Visible) { // DIMENSION ?>
		<td data-name="DIMENSION" <?php echo $procesos_nuevo_list->DIMENSION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DIMENSION" class="procesos_nuevo_DIMENSION">
<span<?php echo $procesos_nuevo_list->DIMENSION->viewAttributes() ?>><?php echo $procesos_nuevo_list->DIMENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PLACA->Visible) { // PLACA ?>
		<td data-name="PLACA" <?php echo $procesos_nuevo_list->PLACA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PLACA" class="procesos_nuevo_PLACA">
<span<?php echo $procesos_nuevo_list->PLACA->viewAttributes() ?>><?php echo $procesos_nuevo_list->PLACA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_MOTOR->Visible) { // NRO_MOTOR ?>
		<td data-name="NRO_MOTOR" <?php echo $procesos_nuevo_list->NRO_MOTOR->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_MOTOR" class="procesos_nuevo_NRO_MOTOR">
<span<?php echo $procesos_nuevo_list->NRO_MOTOR->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_MOTOR->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_CHASIS->Visible) { // NRO_CHASIS ?>
		<td data-name="NRO_CHASIS" <?php echo $procesos_nuevo_list->NRO_CHASIS->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_CHASIS" class="procesos_nuevo_NRO_CHASIS">
<span<?php echo $procesos_nuevo_list->NRO_CHASIS->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_CHASIS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->MATRICULA->Visible) { // MATRICULA ?>
		<td data-name="MATRICULA" <?php echo $procesos_nuevo_list->MATRICULA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_MATRICULA" class="procesos_nuevo_MATRICULA">
<span<?php echo $procesos_nuevo_list->MATRICULA->viewAttributes() ?>><?php echo $procesos_nuevo_list->MATRICULA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ANIO_FABRICACION->Visible) { // ANIO_FABRICACION ?>
		<td data-name="ANIO_FABRICACION" <?php echo $procesos_nuevo_list->ANIO_FABRICACION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ANIO_FABRICACION" class="procesos_nuevo_ANIO_FABRICACION">
<span<?php echo $procesos_nuevo_list->ANIO_FABRICACION->viewAttributes() ?>><?php echo $procesos_nuevo_list->ANIO_FABRICACION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->LONGITUD->Visible) { // LONGITUD ?>
		<td data-name="LONGITUD" <?php echo $procesos_nuevo_list->LONGITUD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_LONGITUD" class="procesos_nuevo_LONGITUD">
<span<?php echo $procesos_nuevo_list->LONGITUD->viewAttributes() ?>><?php echo $procesos_nuevo_list->LONGITUD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ALTURA->Visible) { // ALTURA ?>
		<td data-name="ALTURA" <?php echo $procesos_nuevo_list->ALTURA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ALTURA" class="procesos_nuevo_ALTURA">
<span<?php echo $procesos_nuevo_list->ALTURA->viewAttributes() ?>><?php echo $procesos_nuevo_list->ALTURA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ANCHO->Visible) { // ANCHO ?>
		<td data-name="ANCHO" <?php echo $procesos_nuevo_list->ANCHO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ANCHO" class="procesos_nuevo_ANCHO">
<span<?php echo $procesos_nuevo_list->ANCHO->viewAttributes() ?>><?php echo $procesos_nuevo_list->ANCHO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->RAZA->Visible) { // RAZA ?>
		<td data-name="RAZA" <?php echo $procesos_nuevo_list->RAZA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_RAZA" class="procesos_nuevo_RAZA">
<span<?php echo $procesos_nuevo_list->RAZA->viewAttributes() ?>><?php echo $procesos_nuevo_list->RAZA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ESPECIE->Visible) { // ESPECIE ?>
		<td data-name="ESPECIE" <?php echo $procesos_nuevo_list->ESPECIE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ESPECIE" class="procesos_nuevo_ESPECIE">
<span<?php echo $procesos_nuevo_list->ESPECIE->viewAttributes() ?>><?php echo $procesos_nuevo_list->ESPECIE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->EDAD->Visible) { // EDAD ?>
		<td data-name="EDAD" <?php echo $procesos_nuevo_list->EDAD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_EDAD" class="procesos_nuevo_EDAD">
<span<?php echo $procesos_nuevo_list->EDAD->viewAttributes() ?>><?php echo $procesos_nuevo_list->EDAD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PAIS->Visible) { // PAIS ?>
		<td data-name="PAIS" <?php echo $procesos_nuevo_list->PAIS->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PAIS" class="procesos_nuevo_PAIS">
<span<?php echo $procesos_nuevo_list->PAIS->viewAttributes() ?>><?php echo $procesos_nuevo_list->PAIS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->OTRAS_CARACT->Visible) { // OTRAS_CARACT ?>
		<td data-name="OTRAS_CARACT" <?php echo $procesos_nuevo_list->OTRAS_CARACT->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_OTRAS_CARACT" class="procesos_nuevo_OTRAS_CARACT">
<span<?php echo $procesos_nuevo_list->OTRAS_CARACT->viewAttributes() ?>><?php echo $procesos_nuevo_list->OTRAS_CARACT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->Visible) { // DESCRIPCION_UBICACION_BIEN ?>
		<td data-name="DESCRIPCION_UBICACION_BIEN" <?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DESCRIPCION_UBICACION_BIEN" class="procesos_nuevo_DESCRIPCION_UBICACION_BIEN">
<span<?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->DESCRIPCION_UBICACION_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CAUSAL_BAJA->Visible) { // CAUSAL_BAJA ?>
		<td data-name="CAUSAL_BAJA" <?php echo $procesos_nuevo_list->CAUSAL_BAJA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CAUSAL_BAJA" class="procesos_nuevo_CAUSAL_BAJA">
<span<?php echo $procesos_nuevo_list->CAUSAL_BAJA->viewAttributes() ?>><?php echo $procesos_nuevo_list->CAUSAL_BAJA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_RESOLUCION_BAJA->Visible) { // NRO_RESOLUCION_BAJA ?>
		<td data-name="NRO_RESOLUCION_BAJA" <?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_RESOLUCION_BAJA" class="procesos_nuevo_NRO_RESOLUCION_BAJA">
<span<?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_RESOLUCION_BAJA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_BAJA->Visible) { // FECHA_BAJA ?>
		<td data-name="FECHA_BAJA" <?php echo $procesos_nuevo_list->FECHA_BAJA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_BAJA" class="procesos_nuevo_FECHA_BAJA">
<span<?php echo $procesos_nuevo_list->FECHA_BAJA->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_BAJA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ACTO_DISPOSICION_BIEN->Visible) { // ACTO_DISPOSICION_BIEN ?>
		<td data-name="ACTO_DISPOSICION_BIEN" <?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ACTO_DISPOSICION_BIEN" class="procesos_nuevo_ACTO_DISPOSICION_BIEN">
<span<?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->ACTO_DISPOSICION_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NRO_RESOLUCION_DISP->Visible) { // NRO_RESOLUCION_DISP ?>
		<td data-name="NRO_RESOLUCION_DISP" <?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NRO_RESOLUCION_DISP" class="procesos_nuevo_NRO_RESOLUCION_DISP">
<span<?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->viewAttributes() ?>><?php echo $procesos_nuevo_list->NRO_RESOLUCION_DISP->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_DISPOSICION->Visible) { // FECHA_DISPOSICION ?>
		<td data-name="FECHA_DISPOSICION" <?php echo $procesos_nuevo_list->FECHA_DISPOSICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_DISPOSICION" class="procesos_nuevo_FECHA_DISPOSICION">
<span<?php echo $procesos_nuevo_list->FECHA_DISPOSICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_DISPOSICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Visible) { // ENTIDAD_BENEFICIADA_ACTO_DISPOSICION ?>
		<td data-name="ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" <?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION">
<span<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->viewAttributes() ?>><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->Visible) { // MOTIVO_ELIMINACION_BIEN ?>
		<td data-name="MOTIVO_ELIMINACION_BIEN" <?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_MOTIVO_ELIMINACION_BIEN" class="procesos_nuevo_MOTIVO_ELIMINACION_BIEN">
<span<?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->MOTIVO_ELIMINACION_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->Visible) { // ACTO_ADMINISTRACION_BIEN ?>
		<td data-name="ACTO_ADMINISTRACION_BIEN" <?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ACTO_ADMINISTRACION_BIEN" class="procesos_nuevo_ACTO_ADMINISTRACION_BIEN">
<span<?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->viewAttributes() ?>><?php echo $procesos_nuevo_list->ACTO_ADMINISTRACION_BIEN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->Visible) { // NUM_RESOLUCION_ADMINISTRACION ?>
		<td data-name="NUM_RESOLUCION_ADMINISTRACION" <?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION" class="procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION">
<span<?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->viewAttributes() ?>><?php echo $procesos_nuevo_list->NUM_RESOLUCION_ADMINISTRACION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_ADMINISTRACION->Visible) { // FECHA_ADMINISTRACION ?>
		<td data-name="FECHA_ADMINISTRACION" <?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_ADMINISTRACION" class="procesos_nuevo_FECHA_ADMINISTRACION">
<span<?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_ADMINISTRACION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->Visible) { // FECHA_VENC_ACTO_ADMIN ?>
		<td data-name="FECHA_VENC_ACTO_ADMIN" <?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_VENC_ACTO_ADMIN" class="procesos_nuevo_FECHA_VENC_ACTO_ADMIN">
<span<?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_VENC_ACTO_ADMIN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Visible) { // ENTIDAD_BENEFICIADA_ACTO_ADMIN ?>
		<td data-name="ENTIDAD_BENEFICIADA_ACTO_ADMIN" <?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN">
<span<?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->viewAttributes() ?>><?php echo $procesos_nuevo_list->ENTIDAD_BENEFICIADA_ACTO_ADMIN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DOC_ALTA_SBN->Visible) { // DOC_ALTA_SBN ?>
		<td data-name="DOC_ALTA_SBN" <?php echo $procesos_nuevo_list->DOC_ALTA_SBN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DOC_ALTA_SBN" class="procesos_nuevo_DOC_ALTA_SBN">
<span<?php echo $procesos_nuevo_list->DOC_ALTA_SBN->viewAttributes() ?>><?php echo $procesos_nuevo_list->DOC_ALTA_SBN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DOC_BAJA_SBN->Visible) { // DOC_BAJA_SBN ?>
		<td data-name="DOC_BAJA_SBN" <?php echo $procesos_nuevo_list->DOC_BAJA_SBN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DOC_BAJA_SBN" class="procesos_nuevo_DOC_BAJA_SBN">
<span<?php echo $procesos_nuevo_list->DOC_BAJA_SBN->viewAttributes() ?>><?php echo $procesos_nuevo_list->DOC_BAJA_SBN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->DEPENDENCIAS->Visible) { // DEPENDENCIAS ?>
		<td data-name="DEPENDENCIAS" <?php echo $procesos_nuevo_list->DEPENDENCIAS->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_DEPENDENCIAS" class="procesos_nuevo_DEPENDENCIAS">
<span<?php echo $procesos_nuevo_list->DEPENDENCIAS->viewAttributes() ?>><?php echo $procesos_nuevo_list->DEPENDENCIAS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NUMERO_FICHA->Visible) { // NUMERO_FICHA ?>
		<td data-name="NUMERO_FICHA" <?php echo $procesos_nuevo_list->NUMERO_FICHA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NUMERO_FICHA" class="procesos_nuevo_NUMERO_FICHA">
<span<?php echo $procesos_nuevo_list->NUMERO_FICHA->viewAttributes() ?>><?php echo $procesos_nuevo_list->NUMERO_FICHA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CODIGO_INTERNO->Visible) { // CODIGO_INTERNO ?>
		<td data-name="CODIGO_INTERNO" <?php echo $procesos_nuevo_list->CODIGO_INTERNO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CODIGO_INTERNO" class="procesos_nuevo_CODIGO_INTERNO">
<span<?php echo $procesos_nuevo_list->CODIGO_INTERNO->viewAttributes() ?>><?php echo $procesos_nuevo_list->CODIGO_INTERNO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ESTADO->Visible) { // ESTADO ?>
		<td data-name="ESTADO" <?php echo $procesos_nuevo_list->ESTADO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ESTADO" class="procesos_nuevo_ESTADO">
<span<?php echo $procesos_nuevo_list->ESTADO->viewAttributes() ?>><?php echo $procesos_nuevo_list->ESTADO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->USO->Visible) { // USO ?>
		<td data-name="USO" <?php echo $procesos_nuevo_list->USO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_USO" class="procesos_nuevo_USO">
<span<?php echo $procesos_nuevo_list->USO->viewAttributes() ?>><?php echo $procesos_nuevo_list->USO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->STICKER->Visible) { // STICKER ?>
		<td data-name="STICKER" <?php echo $procesos_nuevo_list->STICKER->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_STICKER" class="procesos_nuevo_STICKER">
<span<?php echo $procesos_nuevo_list->STICKER->viewAttributes() ?>><?php echo $procesos_nuevo_list->STICKER->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SEDE->Visible) { // SEDE ?>
		<td data-name="SEDE" <?php echo $procesos_nuevo_list->SEDE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SEDE" class="procesos_nuevo_SEDE">
<span<?php echo $procesos_nuevo_list->SEDE->viewAttributes() ?>><?php echo $procesos_nuevo_list->SEDE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SBN->Visible) { // SBN ?>
		<td data-name="SBN" <?php echo $procesos_nuevo_list->SBN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SBN" class="procesos_nuevo_SBN">
<span<?php echo $procesos_nuevo_list->SBN->viewAttributes() ?>><?php echo $procesos_nuevo_list->SBN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->ETIQUETA->Visible) { // ETIQUETA ?>
		<td data-name="ETIQUETA" <?php echo $procesos_nuevo_list->ETIQUETA->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_ETIQUETA" class="procesos_nuevo_ETIQUETA">
<span<?php echo $procesos_nuevo_list->ETIQUETA->viewAttributes() ?>><?php echo $procesos_nuevo_list->ETIQUETA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Visible) { // NOMBRE_BENEFICIARIO_ACTO_ADMIN ?>
		<td data-name="NOMBRE_BENEFICIARIO_ACTO_ADMIN" <?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN">
<span<?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->viewAttributes() ?>><?php echo $procesos_nuevo_list->NOMBRE_BENEFICIARIO_ACTO_ADMIN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PLACA_RODAJE->Visible) { // PLACA_RODAJE ?>
		<td data-name="PLACA_RODAJE" <?php echo $procesos_nuevo_list->PLACA_RODAJE->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PLACA_RODAJE" class="procesos_nuevo_PLACA_RODAJE">
<span<?php echo $procesos_nuevo_list->PLACA_RODAJE->viewAttributes() ?>><?php echo $procesos_nuevo_list->PLACA_RODAJE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CODIGO_ACTUAL->Visible) { // CODIGO_ACTUAL ?>
		<td data-name="CODIGO_ACTUAL" <?php echo $procesos_nuevo_list->CODIGO_ACTUAL->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CODIGO_ACTUAL" class="procesos_nuevo_CODIGO_ACTUAL">
<span<?php echo $procesos_nuevo_list->CODIGO_ACTUAL->viewAttributes() ?>><?php echo $procesos_nuevo_list->CODIGO_ACTUAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->CODIGO_ANTERIOR->Visible) { // CODIGO_ANTERIOR ?>
		<td data-name="CODIGO_ANTERIOR" <?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_CODIGO_ANTERIOR" class="procesos_nuevo_CODIGO_ANTERIOR">
<span<?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->viewAttributes() ?>><?php echo $procesos_nuevo_list->CODIGO_ANTERIOR->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->PROPIEDAD->Visible) { // PROPIEDAD ?>
		<td data-name="PROPIEDAD" <?php echo $procesos_nuevo_list->PROPIEDAD->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_PROPIEDAD" class="procesos_nuevo_PROPIEDAD">
<span<?php echo $procesos_nuevo_list->PROPIEDAD->viewAttributes() ?>><?php echo $procesos_nuevo_list->PROPIEDAD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->SITUACION->Visible) { // SITUACION ?>
		<td data-name="SITUACION" <?php echo $procesos_nuevo_list->SITUACION->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_SITUACION" class="procesos_nuevo_SITUACION">
<span<?php echo $procesos_nuevo_list->SITUACION->viewAttributes() ?>><?php echo $procesos_nuevo_list->SITUACION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->OBSERVACIONES->Visible) { // OBSERVACIONES ?>
		<td data-name="OBSERVACIONES" <?php echo $procesos_nuevo_list->OBSERVACIONES->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_OBSERVACIONES" class="procesos_nuevo_OBSERVACIONES">
<span<?php echo $procesos_nuevo_list->OBSERVACIONES->viewAttributes() ?>><?php echo $procesos_nuevo_list->OBSERVACIONES->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($procesos_nuevo_list->FECHA_REGISTRO->Visible) { // FECHA_REGISTRO ?>
		<td data-name="FECHA_REGISTRO" <?php echo $procesos_nuevo_list->FECHA_REGISTRO->cellAttributes() ?>>
<span id="el<?php echo $procesos_nuevo_list->RowCount ?>_procesos_nuevo_FECHA_REGISTRO" class="procesos_nuevo_FECHA_REGISTRO">
<span<?php echo $procesos_nuevo_list->FECHA_REGISTRO->viewAttributes() ?>><?php echo $procesos_nuevo_list->FECHA_REGISTRO->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$procesos_nuevo_list->ListOptions->render("body", "right", $procesos_nuevo_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$procesos_nuevo_list->isGridAdd())
		$procesos_nuevo_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$procesos_nuevo->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($procesos_nuevo_list->Recordset)
	$procesos_nuevo_list->Recordset->Close();
?>
<?php if (!$procesos_nuevo_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$procesos_nuevo_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $procesos_nuevo_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $procesos_nuevo_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($procesos_nuevo_list->TotalRecords == 0 && !$procesos_nuevo->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $procesos_nuevo_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$procesos_nuevo_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$procesos_nuevo_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$procesos_nuevo_list->terminate();
?>