<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pais_view = new pais_view();

// Run the page
$pais_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pais_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$pais_view->isExport()) { ?>
<script>
var fpaisview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpaisview = currentForm = new ew.Form("fpaisview", "view");
	loadjs.done("fpaisview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$pais_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $pais_view->ExportOptions->render("body") ?>
<?php $pais_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $pais_view->showPageHeader(); ?>
<?php
$pais_view->showMessage();
?>
<form name="fpaisview" id="fpaisview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pais">
<input type="hidden" name="modal" value="<?php echo (int)$pais_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($pais_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $pais_view->TableLeftColumnClass ?>"><span id="elh_pais_id"><?php echo $pais_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $pais_view->id->cellAttributes() ?>>
<span id="el_pais_id">
<span<?php echo $pais_view->id->viewAttributes() ?>><?php echo $pais_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pais_view->iso->Visible) { // iso ?>
	<tr id="r_iso">
		<td class="<?php echo $pais_view->TableLeftColumnClass ?>"><span id="elh_pais_iso"><?php echo $pais_view->iso->caption() ?></span></td>
		<td data-name="iso" <?php echo $pais_view->iso->cellAttributes() ?>>
<span id="el_pais_iso">
<span<?php echo $pais_view->iso->viewAttributes() ?>><?php echo $pais_view->iso->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pais_view->nombre->Visible) { // nombre ?>
	<tr id="r_nombre">
		<td class="<?php echo $pais_view->TableLeftColumnClass ?>"><span id="elh_pais_nombre"><?php echo $pais_view->nombre->caption() ?></span></td>
		<td data-name="nombre" <?php echo $pais_view->nombre->cellAttributes() ?>>
<span id="el_pais_nombre">
<span<?php echo $pais_view->nombre->viewAttributes() ?>><?php echo $pais_view->nombre->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$pais_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$pais_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$pais_view->terminate();
?>