<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pais_add = new pais_add();

// Run the page
$pais_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pais_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpaisadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fpaisadd = currentForm = new ew.Form("fpaisadd", "add");

	// Validate form
	fpaisadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($pais_add->iso->Required) { ?>
				elm = this.getElements("x" + infix + "_iso");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pais_add->iso->caption(), $pais_add->iso->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($pais_add->nombre->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pais_add->nombre->caption(), $pais_add->nombre->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpaisadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpaisadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fpaisadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $pais_add->showPageHeader(); ?>
<?php
$pais_add->showMessage();
?>
<form name="fpaisadd" id="fpaisadd" class="<?php echo $pais_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pais">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$pais_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($pais_add->iso->Visible) { // iso ?>
	<div id="r_iso" class="form-group row">
		<label id="elh_pais_iso" for="x_iso" class="<?php echo $pais_add->LeftColumnClass ?>"><?php echo $pais_add->iso->caption() ?><?php echo $pais_add->iso->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pais_add->RightColumnClass ?>"><div <?php echo $pais_add->iso->cellAttributes() ?>>
<span id="el_pais_iso">
<input type="text" data-table="pais" data-field="x_iso" name="x_iso" id="x_iso" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($pais_add->iso->getPlaceHolder()) ?>" value="<?php echo $pais_add->iso->EditValue ?>"<?php echo $pais_add->iso->editAttributes() ?>>
</span>
<?php echo $pais_add->iso->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pais_add->nombre->Visible) { // nombre ?>
	<div id="r_nombre" class="form-group row">
		<label id="elh_pais_nombre" for="x_nombre" class="<?php echo $pais_add->LeftColumnClass ?>"><?php echo $pais_add->nombre->caption() ?><?php echo $pais_add->nombre->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pais_add->RightColumnClass ?>"><div <?php echo $pais_add->nombre->cellAttributes() ?>>
<span id="el_pais_nombre">
<input type="text" data-table="pais" data-field="x_nombre" name="x_nombre" id="x_nombre" size="30" maxlength="80" placeholder="<?php echo HtmlEncode($pais_add->nombre->getPlaceHolder()) ?>" value="<?php echo $pais_add->nombre->EditValue ?>"<?php echo $pais_add->nombre->editAttributes() ?>>
</span>
<?php echo $pais_add->nombre->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$pais_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $pais_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $pais_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$pais_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$pais_add->terminate();
?>