<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lotes_edit = new lotes_edit();

// Run the page
$lotes_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lotes_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var flotesedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	flotesedit = currentForm = new ew.Form("flotesedit", "edit");

	// Validate form
	flotesedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($lotes_edit->id_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_id_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->id_producto->caption(), $lotes_edit->id_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->id_proyecto->Required) { ?>
				elm = this.getElements("x" + infix + "_id_proyecto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->id_proyecto->caption(), $lotes_edit->id_proyecto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_proyecto");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->id_proyecto->errorMessage()) ?>");
			<?php if ($lotes_edit->codigo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->codigo_producto->caption(), $lotes_edit->codigo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->nombre_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->nombre_producto->caption(), $lotes_edit->nombre_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->status_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->status_producto->caption(), $lotes_edit->status_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->status_producto->errorMessage()) ?>");
			<?php if ($lotes_edit->date_added->Required) { ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->date_added->caption(), $lotes_edit->date_added->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->date_added->errorMessage()) ?>");
			<?php if ($lotes_edit->precio_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->precio_producto->caption(), $lotes_edit->precio_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->precio_producto->errorMessage()) ?>");
			<?php if ($lotes_edit->costo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->costo_producto->caption(), $lotes_edit->costo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->costo_producto->errorMessage()) ?>");
			<?php if ($lotes_edit->mon_costo->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->mon_costo->caption(), $lotes_edit->mon_costo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->mon_costo->errorMessage()) ?>");
			<?php if ($lotes_edit->mon_venta->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->mon_venta->caption(), $lotes_edit->mon_venta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->mon_venta->errorMessage()) ?>");
			<?php if ($lotes_edit->marca->Required) { ?>
				elm = this.getElements("x" + infix + "_marca");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->marca->caption(), $lotes_edit->marca->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->modelo->Required) { ?>
				elm = this.getElements("x" + infix + "_modelo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->modelo->caption(), $lotes_edit->modelo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->color->Required) { ?>
				elm = this.getElements("x" + infix + "_color");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->color->caption(), $lotes_edit->color->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->b1->Required) { ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b1->caption(), $lotes_edit->b1->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b1->errorMessage()) ?>");
			<?php if ($lotes_edit->b2->Required) { ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b2->caption(), $lotes_edit->b2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b2->errorMessage()) ?>");
			<?php if ($lotes_edit->b3->Required) { ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b3->caption(), $lotes_edit->b3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b3->errorMessage()) ?>");
			<?php if ($lotes_edit->b4->Required) { ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b4->caption(), $lotes_edit->b4->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b4->errorMessage()) ?>");
			<?php if ($lotes_edit->b5->Required) { ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b5->caption(), $lotes_edit->b5->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b5->errorMessage()) ?>");
			<?php if ($lotes_edit->b6->Required) { ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->b6->caption(), $lotes_edit->b6->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->b6->errorMessage()) ?>");
			<?php if ($lotes_edit->cat_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->cat_pro->caption(), $lotes_edit->cat_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->cat_pro->errorMessage()) ?>");
			<?php if ($lotes_edit->pro_ser->Required) { ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->pro_ser->caption(), $lotes_edit->pro_ser->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->pro_ser->errorMessage()) ?>");
			<?php if ($lotes_edit->foto1->Required) { ?>
				elm = this.getElements("x" + infix + "_foto1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->foto1->caption(), $lotes_edit->foto1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->foto2->Required) { ?>
				elm = this.getElements("x" + infix + "_foto2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->foto2->caption(), $lotes_edit->foto2->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->foto3->Required) { ?>
				elm = this.getElements("x" + infix + "_foto3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->foto3->caption(), $lotes_edit->foto3->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->foto4->Required) { ?>
				elm = this.getElements("x" + infix + "_foto4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->foto4->caption(), $lotes_edit->foto4->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->web->Required) { ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->web->caption(), $lotes_edit->web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->web->errorMessage()) ?>");
			<?php if ($lotes_edit->pre_web->Required) { ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->pre_web->caption(), $lotes_edit->pre_web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->pre_web->errorMessage()) ?>");
			<?php if ($lotes_edit->descripcion->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->descripcion->caption(), $lotes_edit->descripcion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->descripcion1->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->descripcion1->caption(), $lotes_edit->descripcion1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->megusta->Required) { ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->megusta->caption(), $lotes_edit->megusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->megusta->errorMessage()) ?>");
			<?php if ($lotes_edit->nomegusta->Required) { ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->nomegusta->caption(), $lotes_edit->nomegusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->nomegusta->errorMessage()) ?>");
			<?php if ($lotes_edit->precio2->Required) { ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->precio2->caption(), $lotes_edit->precio2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->precio2->errorMessage()) ?>");
			<?php if ($lotes_edit->precio3->Required) { ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->precio3->caption(), $lotes_edit->precio3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->precio3->errorMessage()) ?>");
			<?php if ($lotes_edit->und_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->und_pro->caption(), $lotes_edit->und_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->und_pro->errorMessage()) ?>");
			<?php if ($lotes_edit->barras->Required) { ?>
				elm = this.getElements("x" + infix + "_barras");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->barras->caption(), $lotes_edit->barras->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->stockmin->Required) { ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->stockmin->caption(), $lotes_edit->stockmin->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->stockmin->errorMessage()) ?>");
			<?php if ($lotes_edit->id_grupo->Required) { ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->id_grupo->caption(), $lotes_edit->id_grupo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->id_grupo->errorMessage()) ?>");
			<?php if ($lotes_edit->talla->Required) { ?>
				elm = this.getElements("x" + infix + "_talla");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->talla->caption(), $lotes_edit->talla->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->mostrarcolor->Required) { ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->mostrarcolor->caption(), $lotes_edit->mostrarcolor->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->mostrarcolor->errorMessage()) ?>");
			<?php if ($lotes_edit->lote->Required) { ?>
				elm = this.getElements("x" + infix + "_lote");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->lote->caption(), $lotes_edit->lote->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->manzana->Required) { ?>
				elm = this.getElements("x" + infix + "_manzana");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->manzana->caption(), $lotes_edit->manzana->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->etapa->Required) { ?>
				elm = this.getElements("x" + infix + "_etapa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->etapa->caption(), $lotes_edit->etapa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_etapa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->etapa->errorMessage()) ?>");
			<?php if ($lotes_edit->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->estado->caption(), $lotes_edit->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->estado->errorMessage()) ?>");
			<?php if ($lotes_edit->icon->Required) { ?>
				elm = this.getElements("x" + infix + "_icon");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->icon->caption(), $lotes_edit->icon->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->topy->Required) { ?>
				elm = this.getElements("x" + infix + "_topy");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->topy->caption(), $lotes_edit->topy->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->leftx->Required) { ?>
				elm = this.getElements("x" + infix + "_leftx");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->leftx->caption(), $lotes_edit->leftx->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->codlogin->Required) { ?>
				elm = this.getElements("x" + infix + "_codlogin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->codlogin->caption(), $lotes_edit->codlogin->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($lotes_edit->id_cliente->Required) { ?>
				elm = this.getElements("x" + infix + "_id_cliente");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lotes_edit->id_cliente->caption(), $lotes_edit->id_cliente->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_cliente");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($lotes_edit->id_cliente->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	flotesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	flotesedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("flotesedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $lotes_edit->showPageHeader(); ?>
<?php
$lotes_edit->showMessage();
?>
<form name="flotesedit" id="flotesedit" class="<?php echo $lotes_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lotes">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$lotes_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($lotes_edit->id_producto->Visible) { // id_producto ?>
	<div id="r_id_producto" class="form-group row">
		<label id="elh_lotes_id_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->id_producto->caption() ?><?php echo $lotes_edit->id_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->id_producto->cellAttributes() ?>>
<span id="el_lotes_id_producto">
<span<?php echo $lotes_edit->id_producto->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($lotes_edit->id_producto->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="lotes" data-field="x_id_producto" name="x_id_producto" id="x_id_producto" value="<?php echo HtmlEncode($lotes_edit->id_producto->CurrentValue) ?>">
<?php echo $lotes_edit->id_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->id_proyecto->Visible) { // id_proyecto ?>
	<div id="r_id_proyecto" class="form-group row">
		<label id="elh_lotes_id_proyecto" for="x_id_proyecto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->id_proyecto->caption() ?><?php echo $lotes_edit->id_proyecto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->id_proyecto->cellAttributes() ?>>
<span id="el_lotes_id_proyecto">
<input type="text" data-table="lotes" data-field="x_id_proyecto" name="x_id_proyecto" id="x_id_proyecto" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->id_proyecto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->id_proyecto->EditValue ?>"<?php echo $lotes_edit->id_proyecto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->id_proyecto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->codigo_producto->Visible) { // codigo_producto ?>
	<div id="r_codigo_producto" class="form-group row">
		<label id="elh_lotes_codigo_producto" for="x_codigo_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->codigo_producto->caption() ?><?php echo $lotes_edit->codigo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->codigo_producto->cellAttributes() ?>>
<span id="el_lotes_codigo_producto">
<input type="text" data-table="lotes" data-field="x_codigo_producto" name="x_codigo_producto" id="x_codigo_producto" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($lotes_edit->codigo_producto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->codigo_producto->EditValue ?>"<?php echo $lotes_edit->codigo_producto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->codigo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->nombre_producto->Visible) { // nombre_producto ?>
	<div id="r_nombre_producto" class="form-group row">
		<label id="elh_lotes_nombre_producto" for="x_nombre_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->nombre_producto->caption() ?><?php echo $lotes_edit->nombre_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->nombre_producto->cellAttributes() ?>>
<span id="el_lotes_nombre_producto">
<input type="text" data-table="lotes" data-field="x_nombre_producto" name="x_nombre_producto" id="x_nombre_producto" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($lotes_edit->nombre_producto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->nombre_producto->EditValue ?>"<?php echo $lotes_edit->nombre_producto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->nombre_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->status_producto->Visible) { // status_producto ?>
	<div id="r_status_producto" class="form-group row">
		<label id="elh_lotes_status_producto" for="x_status_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->status_producto->caption() ?><?php echo $lotes_edit->status_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->status_producto->cellAttributes() ?>>
<span id="el_lotes_status_producto">
<input type="text" data-table="lotes" data-field="x_status_producto" name="x_status_producto" id="x_status_producto" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($lotes_edit->status_producto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->status_producto->EditValue ?>"<?php echo $lotes_edit->status_producto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->status_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->date_added->Visible) { // date_added ?>
	<div id="r_date_added" class="form-group row">
		<label id="elh_lotes_date_added" for="x_date_added" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->date_added->caption() ?><?php echo $lotes_edit->date_added->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->date_added->cellAttributes() ?>>
<span id="el_lotes_date_added">
<input type="text" data-table="lotes" data-field="x_date_added" name="x_date_added" id="x_date_added" maxlength="19" placeholder="<?php echo HtmlEncode($lotes_edit->date_added->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->date_added->EditValue ?>"<?php echo $lotes_edit->date_added->editAttributes() ?>>
<?php if (!$lotes_edit->date_added->ReadOnly && !$lotes_edit->date_added->Disabled && !isset($lotes_edit->date_added->EditAttrs["readonly"]) && !isset($lotes_edit->date_added->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["flotesedit", "datetimepicker"], function() {
	ew.createDateTimePicker("flotesedit", "x_date_added", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $lotes_edit->date_added->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->precio_producto->Visible) { // precio_producto ?>
	<div id="r_precio_producto" class="form-group row">
		<label id="elh_lotes_precio_producto" for="x_precio_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->precio_producto->caption() ?><?php echo $lotes_edit->precio_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->precio_producto->cellAttributes() ?>>
<span id="el_lotes_precio_producto">
<input type="text" data-table="lotes" data-field="x_precio_producto" name="x_precio_producto" id="x_precio_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->precio_producto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->precio_producto->EditValue ?>"<?php echo $lotes_edit->precio_producto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->precio_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->costo_producto->Visible) { // costo_producto ?>
	<div id="r_costo_producto" class="form-group row">
		<label id="elh_lotes_costo_producto" for="x_costo_producto" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->costo_producto->caption() ?><?php echo $lotes_edit->costo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->costo_producto->cellAttributes() ?>>
<span id="el_lotes_costo_producto">
<input type="text" data-table="lotes" data-field="x_costo_producto" name="x_costo_producto" id="x_costo_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->costo_producto->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->costo_producto->EditValue ?>"<?php echo $lotes_edit->costo_producto->editAttributes() ?>>
</span>
<?php echo $lotes_edit->costo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->mon_costo->Visible) { // mon_costo ?>
	<div id="r_mon_costo" class="form-group row">
		<label id="elh_lotes_mon_costo" for="x_mon_costo" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->mon_costo->caption() ?><?php echo $lotes_edit->mon_costo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->mon_costo->cellAttributes() ?>>
<span id="el_lotes_mon_costo">
<input type="text" data-table="lotes" data-field="x_mon_costo" name="x_mon_costo" id="x_mon_costo" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($lotes_edit->mon_costo->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->mon_costo->EditValue ?>"<?php echo $lotes_edit->mon_costo->editAttributes() ?>>
</span>
<?php echo $lotes_edit->mon_costo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->mon_venta->Visible) { // mon_venta ?>
	<div id="r_mon_venta" class="form-group row">
		<label id="elh_lotes_mon_venta" for="x_mon_venta" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->mon_venta->caption() ?><?php echo $lotes_edit->mon_venta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->mon_venta->cellAttributes() ?>>
<span id="el_lotes_mon_venta">
<input type="text" data-table="lotes" data-field="x_mon_venta" name="x_mon_venta" id="x_mon_venta" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->mon_venta->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->mon_venta->EditValue ?>"<?php echo $lotes_edit->mon_venta->editAttributes() ?>>
</span>
<?php echo $lotes_edit->mon_venta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->marca->Visible) { // marca ?>
	<div id="r_marca" class="form-group row">
		<label id="elh_lotes_marca" for="x_marca" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->marca->caption() ?><?php echo $lotes_edit->marca->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->marca->cellAttributes() ?>>
<span id="el_lotes_marca">
<input type="text" data-table="lotes" data-field="x_marca" name="x_marca" id="x_marca" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lotes_edit->marca->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->marca->EditValue ?>"<?php echo $lotes_edit->marca->editAttributes() ?>>
</span>
<?php echo $lotes_edit->marca->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->modelo->Visible) { // modelo ?>
	<div id="r_modelo" class="form-group row">
		<label id="elh_lotes_modelo" for="x_modelo" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->modelo->caption() ?><?php echo $lotes_edit->modelo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->modelo->cellAttributes() ?>>
<span id="el_lotes_modelo">
<input type="text" data-table="lotes" data-field="x_modelo" name="x_modelo" id="x_modelo" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lotes_edit->modelo->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->modelo->EditValue ?>"<?php echo $lotes_edit->modelo->editAttributes() ?>>
</span>
<?php echo $lotes_edit->modelo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_lotes_color" for="x_color" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->color->caption() ?><?php echo $lotes_edit->color->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->color->cellAttributes() ?>>
<span id="el_lotes_color">
<input type="text" data-table="lotes" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lotes_edit->color->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->color->EditValue ?>"<?php echo $lotes_edit->color->editAttributes() ?>>
</span>
<?php echo $lotes_edit->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b1->Visible) { // b1 ?>
	<div id="r_b1" class="form-group row">
		<label id="elh_lotes_b1" for="x_b1" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b1->caption() ?><?php echo $lotes_edit->b1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b1->cellAttributes() ?>>
<span id="el_lotes_b1">
<input type="text" data-table="lotes" data-field="x_b1" name="x_b1" id="x_b1" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b1->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b1->EditValue ?>"<?php echo $lotes_edit->b1->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b2->Visible) { // b2 ?>
	<div id="r_b2" class="form-group row">
		<label id="elh_lotes_b2" for="x_b2" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b2->caption() ?><?php echo $lotes_edit->b2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b2->cellAttributes() ?>>
<span id="el_lotes_b2">
<input type="text" data-table="lotes" data-field="x_b2" name="x_b2" id="x_b2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b2->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b2->EditValue ?>"<?php echo $lotes_edit->b2->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b3->Visible) { // b3 ?>
	<div id="r_b3" class="form-group row">
		<label id="elh_lotes_b3" for="x_b3" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b3->caption() ?><?php echo $lotes_edit->b3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b3->cellAttributes() ?>>
<span id="el_lotes_b3">
<input type="text" data-table="lotes" data-field="x_b3" name="x_b3" id="x_b3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b3->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b3->EditValue ?>"<?php echo $lotes_edit->b3->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b4->Visible) { // b4 ?>
	<div id="r_b4" class="form-group row">
		<label id="elh_lotes_b4" for="x_b4" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b4->caption() ?><?php echo $lotes_edit->b4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b4->cellAttributes() ?>>
<span id="el_lotes_b4">
<input type="text" data-table="lotes" data-field="x_b4" name="x_b4" id="x_b4" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b4->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b4->EditValue ?>"<?php echo $lotes_edit->b4->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b5->Visible) { // b5 ?>
	<div id="r_b5" class="form-group row">
		<label id="elh_lotes_b5" for="x_b5" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b5->caption() ?><?php echo $lotes_edit->b5->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b5->cellAttributes() ?>>
<span id="el_lotes_b5">
<input type="text" data-table="lotes" data-field="x_b5" name="x_b5" id="x_b5" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b5->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b5->EditValue ?>"<?php echo $lotes_edit->b5->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->b6->Visible) { // b6 ?>
	<div id="r_b6" class="form-group row">
		<label id="elh_lotes_b6" for="x_b6" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->b6->caption() ?><?php echo $lotes_edit->b6->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->b6->cellAttributes() ?>>
<span id="el_lotes_b6">
<input type="text" data-table="lotes" data-field="x_b6" name="x_b6" id="x_b6" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->b6->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->b6->EditValue ?>"<?php echo $lotes_edit->b6->editAttributes() ?>>
</span>
<?php echo $lotes_edit->b6->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->cat_pro->Visible) { // cat_pro ?>
	<div id="r_cat_pro" class="form-group row">
		<label id="elh_lotes_cat_pro" for="x_cat_pro" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->cat_pro->caption() ?><?php echo $lotes_edit->cat_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->cat_pro->cellAttributes() ?>>
<span id="el_lotes_cat_pro">
<input type="text" data-table="lotes" data-field="x_cat_pro" name="x_cat_pro" id="x_cat_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->cat_pro->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->cat_pro->EditValue ?>"<?php echo $lotes_edit->cat_pro->editAttributes() ?>>
</span>
<?php echo $lotes_edit->cat_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->pro_ser->Visible) { // pro_ser ?>
	<div id="r_pro_ser" class="form-group row">
		<label id="elh_lotes_pro_ser" for="x_pro_ser" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->pro_ser->caption() ?><?php echo $lotes_edit->pro_ser->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->pro_ser->cellAttributes() ?>>
<span id="el_lotes_pro_ser">
<input type="text" data-table="lotes" data-field="x_pro_ser" name="x_pro_ser" id="x_pro_ser" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->pro_ser->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->pro_ser->EditValue ?>"<?php echo $lotes_edit->pro_ser->editAttributes() ?>>
</span>
<?php echo $lotes_edit->pro_ser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->foto1->Visible) { // foto1 ?>
	<div id="r_foto1" class="form-group row">
		<label id="elh_lotes_foto1" for="x_foto1" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->foto1->caption() ?><?php echo $lotes_edit->foto1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->foto1->cellAttributes() ?>>
<span id="el_lotes_foto1">
<input type="text" data-table="lotes" data-field="x_foto1" name="x_foto1" id="x_foto1" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lotes_edit->foto1->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->foto1->EditValue ?>"<?php echo $lotes_edit->foto1->editAttributes() ?>>
</span>
<?php echo $lotes_edit->foto1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->foto2->Visible) { // foto2 ?>
	<div id="r_foto2" class="form-group row">
		<label id="elh_lotes_foto2" for="x_foto2" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->foto2->caption() ?><?php echo $lotes_edit->foto2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->foto2->cellAttributes() ?>>
<span id="el_lotes_foto2">
<input type="text" data-table="lotes" data-field="x_foto2" name="x_foto2" id="x_foto2" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lotes_edit->foto2->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->foto2->EditValue ?>"<?php echo $lotes_edit->foto2->editAttributes() ?>>
</span>
<?php echo $lotes_edit->foto2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->foto3->Visible) { // foto3 ?>
	<div id="r_foto3" class="form-group row">
		<label id="elh_lotes_foto3" for="x_foto3" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->foto3->caption() ?><?php echo $lotes_edit->foto3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->foto3->cellAttributes() ?>>
<span id="el_lotes_foto3">
<input type="text" data-table="lotes" data-field="x_foto3" name="x_foto3" id="x_foto3" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lotes_edit->foto3->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->foto3->EditValue ?>"<?php echo $lotes_edit->foto3->editAttributes() ?>>
</span>
<?php echo $lotes_edit->foto3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->foto4->Visible) { // foto4 ?>
	<div id="r_foto4" class="form-group row">
		<label id="elh_lotes_foto4" for="x_foto4" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->foto4->caption() ?><?php echo $lotes_edit->foto4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->foto4->cellAttributes() ?>>
<span id="el_lotes_foto4">
<input type="text" data-table="lotes" data-field="x_foto4" name="x_foto4" id="x_foto4" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lotes_edit->foto4->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->foto4->EditValue ?>"<?php echo $lotes_edit->foto4->editAttributes() ?>>
</span>
<?php echo $lotes_edit->foto4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->web->Visible) { // web ?>
	<div id="r_web" class="form-group row">
		<label id="elh_lotes_web" for="x_web" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->web->caption() ?><?php echo $lotes_edit->web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->web->cellAttributes() ?>>
<span id="el_lotes_web">
<input type="text" data-table="lotes" data-field="x_web" name="x_web" id="x_web" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->web->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->web->EditValue ?>"<?php echo $lotes_edit->web->editAttributes() ?>>
</span>
<?php echo $lotes_edit->web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->pre_web->Visible) { // pre_web ?>
	<div id="r_pre_web" class="form-group row">
		<label id="elh_lotes_pre_web" for="x_pre_web" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->pre_web->caption() ?><?php echo $lotes_edit->pre_web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->pre_web->cellAttributes() ?>>
<span id="el_lotes_pre_web">
<input type="text" data-table="lotes" data-field="x_pre_web" name="x_pre_web" id="x_pre_web" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->pre_web->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->pre_web->EditValue ?>"<?php echo $lotes_edit->pre_web->editAttributes() ?>>
</span>
<?php echo $lotes_edit->pre_web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->descripcion->Visible) { // descripcion ?>
	<div id="r_descripcion" class="form-group row">
		<label id="elh_lotes_descripcion" for="x_descripcion" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->descripcion->caption() ?><?php echo $lotes_edit->descripcion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->descripcion->cellAttributes() ?>>
<span id="el_lotes_descripcion">
<textarea data-table="lotes" data-field="x_descripcion" name="x_descripcion" id="x_descripcion" cols="35" rows="4" placeholder="<?php echo HtmlEncode($lotes_edit->descripcion->getPlaceHolder()) ?>"<?php echo $lotes_edit->descripcion->editAttributes() ?>><?php echo $lotes_edit->descripcion->EditValue ?></textarea>
</span>
<?php echo $lotes_edit->descripcion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->descripcion1->Visible) { // descripcion1 ?>
	<div id="r_descripcion1" class="form-group row">
		<label id="elh_lotes_descripcion1" for="x_descripcion1" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->descripcion1->caption() ?><?php echo $lotes_edit->descripcion1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->descripcion1->cellAttributes() ?>>
<span id="el_lotes_descripcion1">
<textarea data-table="lotes" data-field="x_descripcion1" name="x_descripcion1" id="x_descripcion1" cols="35" rows="4" placeholder="<?php echo HtmlEncode($lotes_edit->descripcion1->getPlaceHolder()) ?>"<?php echo $lotes_edit->descripcion1->editAttributes() ?>><?php echo $lotes_edit->descripcion1->EditValue ?></textarea>
</span>
<?php echo $lotes_edit->descripcion1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->megusta->Visible) { // megusta ?>
	<div id="r_megusta" class="form-group row">
		<label id="elh_lotes_megusta" for="x_megusta" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->megusta->caption() ?><?php echo $lotes_edit->megusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->megusta->cellAttributes() ?>>
<span id="el_lotes_megusta">
<input type="text" data-table="lotes" data-field="x_megusta" name="x_megusta" id="x_megusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->megusta->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->megusta->EditValue ?>"<?php echo $lotes_edit->megusta->editAttributes() ?>>
</span>
<?php echo $lotes_edit->megusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->nomegusta->Visible) { // nomegusta ?>
	<div id="r_nomegusta" class="form-group row">
		<label id="elh_lotes_nomegusta" for="x_nomegusta" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->nomegusta->caption() ?><?php echo $lotes_edit->nomegusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->nomegusta->cellAttributes() ?>>
<span id="el_lotes_nomegusta">
<input type="text" data-table="lotes" data-field="x_nomegusta" name="x_nomegusta" id="x_nomegusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->nomegusta->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->nomegusta->EditValue ?>"<?php echo $lotes_edit->nomegusta->editAttributes() ?>>
</span>
<?php echo $lotes_edit->nomegusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->precio2->Visible) { // precio2 ?>
	<div id="r_precio2" class="form-group row">
		<label id="elh_lotes_precio2" for="x_precio2" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->precio2->caption() ?><?php echo $lotes_edit->precio2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->precio2->cellAttributes() ?>>
<span id="el_lotes_precio2">
<input type="text" data-table="lotes" data-field="x_precio2" name="x_precio2" id="x_precio2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->precio2->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->precio2->EditValue ?>"<?php echo $lotes_edit->precio2->editAttributes() ?>>
</span>
<?php echo $lotes_edit->precio2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->precio3->Visible) { // precio3 ?>
	<div id="r_precio3" class="form-group row">
		<label id="elh_lotes_precio3" for="x_precio3" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->precio3->caption() ?><?php echo $lotes_edit->precio3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->precio3->cellAttributes() ?>>
<span id="el_lotes_precio3">
<input type="text" data-table="lotes" data-field="x_precio3" name="x_precio3" id="x_precio3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($lotes_edit->precio3->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->precio3->EditValue ?>"<?php echo $lotes_edit->precio3->editAttributes() ?>>
</span>
<?php echo $lotes_edit->precio3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->und_pro->Visible) { // und_pro ?>
	<div id="r_und_pro" class="form-group row">
		<label id="elh_lotes_und_pro" for="x_und_pro" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->und_pro->caption() ?><?php echo $lotes_edit->und_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->und_pro->cellAttributes() ?>>
<span id="el_lotes_und_pro">
<input type="text" data-table="lotes" data-field="x_und_pro" name="x_und_pro" id="x_und_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->und_pro->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->und_pro->EditValue ?>"<?php echo $lotes_edit->und_pro->editAttributes() ?>>
</span>
<?php echo $lotes_edit->und_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->barras->Visible) { // barras ?>
	<div id="r_barras" class="form-group row">
		<label id="elh_lotes_barras" for="x_barras" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->barras->caption() ?><?php echo $lotes_edit->barras->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->barras->cellAttributes() ?>>
<span id="el_lotes_barras">
<input type="text" data-table="lotes" data-field="x_barras" name="x_barras" id="x_barras" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($lotes_edit->barras->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->barras->EditValue ?>"<?php echo $lotes_edit->barras->editAttributes() ?>>
</span>
<?php echo $lotes_edit->barras->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->stockmin->Visible) { // stockmin ?>
	<div id="r_stockmin" class="form-group row">
		<label id="elh_lotes_stockmin" for="x_stockmin" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->stockmin->caption() ?><?php echo $lotes_edit->stockmin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->stockmin->cellAttributes() ?>>
<span id="el_lotes_stockmin">
<input type="text" data-table="lotes" data-field="x_stockmin" name="x_stockmin" id="x_stockmin" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lotes_edit->stockmin->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->stockmin->EditValue ?>"<?php echo $lotes_edit->stockmin->editAttributes() ?>>
</span>
<?php echo $lotes_edit->stockmin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->id_grupo->Visible) { // id_grupo ?>
	<div id="r_id_grupo" class="form-group row">
		<label id="elh_lotes_id_grupo" for="x_id_grupo" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->id_grupo->caption() ?><?php echo $lotes_edit->id_grupo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->id_grupo->cellAttributes() ?>>
<span id="el_lotes_id_grupo">
<input type="text" data-table="lotes" data-field="x_id_grupo" name="x_id_grupo" id="x_id_grupo" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->id_grupo->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->id_grupo->EditValue ?>"<?php echo $lotes_edit->id_grupo->editAttributes() ?>>
</span>
<?php echo $lotes_edit->id_grupo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->talla->Visible) { // talla ?>
	<div id="r_talla" class="form-group row">
		<label id="elh_lotes_talla" for="x_talla" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->talla->caption() ?><?php echo $lotes_edit->talla->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->talla->cellAttributes() ?>>
<span id="el_lotes_talla">
<input type="text" data-table="lotes" data-field="x_talla" name="x_talla" id="x_talla" size="30" maxlength="110" placeholder="<?php echo HtmlEncode($lotes_edit->talla->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->talla->EditValue ?>"<?php echo $lotes_edit->talla->editAttributes() ?>>
</span>
<?php echo $lotes_edit->talla->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->mostrarcolor->Visible) { // mostrarcolor ?>
	<div id="r_mostrarcolor" class="form-group row">
		<label id="elh_lotes_mostrarcolor" for="x_mostrarcolor" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->mostrarcolor->caption() ?><?php echo $lotes_edit->mostrarcolor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->mostrarcolor->cellAttributes() ?>>
<span id="el_lotes_mostrarcolor">
<input type="text" data-table="lotes" data-field="x_mostrarcolor" name="x_mostrarcolor" id="x_mostrarcolor" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->mostrarcolor->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->mostrarcolor->EditValue ?>"<?php echo $lotes_edit->mostrarcolor->editAttributes() ?>>
</span>
<?php echo $lotes_edit->mostrarcolor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->lote->Visible) { // lote ?>
	<div id="r_lote" class="form-group row">
		<label id="elh_lotes_lote" for="x_lote" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->lote->caption() ?><?php echo $lotes_edit->lote->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->lote->cellAttributes() ?>>
<span id="el_lotes_lote">
<input type="text" data-table="lotes" data-field="x_lote" name="x_lote" id="x_lote" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lotes_edit->lote->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->lote->EditValue ?>"<?php echo $lotes_edit->lote->editAttributes() ?>>
</span>
<?php echo $lotes_edit->lote->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->manzana->Visible) { // manzana ?>
	<div id="r_manzana" class="form-group row">
		<label id="elh_lotes_manzana" for="x_manzana" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->manzana->caption() ?><?php echo $lotes_edit->manzana->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->manzana->cellAttributes() ?>>
<span id="el_lotes_manzana">
<input type="text" data-table="lotes" data-field="x_manzana" name="x_manzana" id="x_manzana" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lotes_edit->manzana->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->manzana->EditValue ?>"<?php echo $lotes_edit->manzana->editAttributes() ?>>
</span>
<?php echo $lotes_edit->manzana->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->etapa->Visible) { // etapa ?>
	<div id="r_etapa" class="form-group row">
		<label id="elh_lotes_etapa" for="x_etapa" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->etapa->caption() ?><?php echo $lotes_edit->etapa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->etapa->cellAttributes() ?>>
<span id="el_lotes_etapa">
<input type="text" data-table="lotes" data-field="x_etapa" name="x_etapa" id="x_etapa" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->etapa->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->etapa->EditValue ?>"<?php echo $lotes_edit->etapa->editAttributes() ?>>
</span>
<?php echo $lotes_edit->etapa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_lotes_estado" for="x_estado" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->estado->caption() ?><?php echo $lotes_edit->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->estado->cellAttributes() ?>>
<span id="el_lotes_estado">
<input type="text" data-table="lotes" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->estado->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->estado->EditValue ?>"<?php echo $lotes_edit->estado->editAttributes() ?>>
</span>
<?php echo $lotes_edit->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->icon->Visible) { // icon ?>
	<div id="r_icon" class="form-group row">
		<label id="elh_lotes_icon" for="x_icon" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->icon->caption() ?><?php echo $lotes_edit->icon->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->icon->cellAttributes() ?>>
<span id="el_lotes_icon">
<input type="text" data-table="lotes" data-field="x_icon" name="x_icon" id="x_icon" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($lotes_edit->icon->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->icon->EditValue ?>"<?php echo $lotes_edit->icon->editAttributes() ?>>
</span>
<?php echo $lotes_edit->icon->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->topy->Visible) { // topy ?>
	<div id="r_topy" class="form-group row">
		<label id="elh_lotes_topy" for="x_topy" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->topy->caption() ?><?php echo $lotes_edit->topy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->topy->cellAttributes() ?>>
<span id="el_lotes_topy">
<input type="text" data-table="lotes" data-field="x_topy" name="x_topy" id="x_topy" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($lotes_edit->topy->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->topy->EditValue ?>"<?php echo $lotes_edit->topy->editAttributes() ?>>
</span>
<?php echo $lotes_edit->topy->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->leftx->Visible) { // leftx ?>
	<div id="r_leftx" class="form-group row">
		<label id="elh_lotes_leftx" for="x_leftx" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->leftx->caption() ?><?php echo $lotes_edit->leftx->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->leftx->cellAttributes() ?>>
<span id="el_lotes_leftx">
<input type="text" data-table="lotes" data-field="x_leftx" name="x_leftx" id="x_leftx" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($lotes_edit->leftx->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->leftx->EditValue ?>"<?php echo $lotes_edit->leftx->editAttributes() ?>>
</span>
<?php echo $lotes_edit->leftx->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->codlogin->Visible) { // codlogin ?>
	<div id="r_codlogin" class="form-group row">
		<label id="elh_lotes_codlogin" for="x_codlogin" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->codlogin->caption() ?><?php echo $lotes_edit->codlogin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->codlogin->cellAttributes() ?>>
<span id="el_lotes_codlogin">
<input type="text" data-table="lotes" data-field="x_codlogin" name="x_codlogin" id="x_codlogin" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lotes_edit->codlogin->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->codlogin->EditValue ?>"<?php echo $lotes_edit->codlogin->editAttributes() ?>>
</span>
<?php echo $lotes_edit->codlogin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($lotes_edit->id_cliente->Visible) { // id_cliente ?>
	<div id="r_id_cliente" class="form-group row">
		<label id="elh_lotes_id_cliente" for="x_id_cliente" class="<?php echo $lotes_edit->LeftColumnClass ?>"><?php echo $lotes_edit->id_cliente->caption() ?><?php echo $lotes_edit->id_cliente->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $lotes_edit->RightColumnClass ?>"><div <?php echo $lotes_edit->id_cliente->cellAttributes() ?>>
<span id="el_lotes_id_cliente">
<input type="text" data-table="lotes" data-field="x_id_cliente" name="x_id_cliente" id="x_id_cliente" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($lotes_edit->id_cliente->getPlaceHolder()) ?>" value="<?php echo $lotes_edit->id_cliente->EditValue ?>"<?php echo $lotes_edit->id_cliente->editAttributes() ?>>
</span>
<?php echo $lotes_edit->id_cliente->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$lotes_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $lotes_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $lotes_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$lotes_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$lotes_edit->terminate();
?>