<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kt_driver_task_view = new kt_driver_task_view();

// Run the page
$kt_driver_task_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kt_driver_task_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kt_driver_task_view->isExport()) { ?>
<script>
var fkt_driver_taskview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fkt_driver_taskview = currentForm = new ew.Form("fkt_driver_taskview", "view");
	loadjs.done("fkt_driver_taskview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kt_driver_task_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $kt_driver_task_view->ExportOptions->render("body") ?>
<?php $kt_driver_task_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $kt_driver_task_view->showPageHeader(); ?>
<?php
$kt_driver_task_view->showMessage();
?>
<form name="fkt_driver_taskview" id="fkt_driver_taskview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kt_driver_task">
<input type="hidden" name="modal" value="<?php echo (int)$kt_driver_task_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($kt_driver_task_view->task_id->Visible) { // task_id ?>
	<tr id="r_task_id">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_task_id"><?php echo $kt_driver_task_view->task_id->caption() ?></span></td>
		<td data-name="task_id" <?php echo $kt_driver_task_view->task_id->cellAttributes() ?>>
<span id="el_kt_driver_task_task_id">
<span<?php echo $kt_driver_task_view->task_id->viewAttributes() ?>><?php echo $kt_driver_task_view->task_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->task_description->Visible) { // task_description ?>
	<tr id="r_task_description">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_task_description"><?php echo $kt_driver_task_view->task_description->caption() ?></span></td>
		<td data-name="task_description" <?php echo $kt_driver_task_view->task_description->cellAttributes() ?>>
<span id="el_kt_driver_task_task_description">
<span<?php echo $kt_driver_task_view->task_description->viewAttributes() ?>><?php echo $kt_driver_task_view->task_description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->trans_type->Visible) { // trans_type ?>
	<tr id="r_trans_type">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_trans_type"><?php echo $kt_driver_task_view->trans_type->caption() ?></span></td>
		<td data-name="trans_type" <?php echo $kt_driver_task_view->trans_type->cellAttributes() ?>>
<span id="el_kt_driver_task_trans_type">
<span<?php echo $kt_driver_task_view->trans_type->viewAttributes() ?>><?php echo $kt_driver_task_view->trans_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->contact_number->Visible) { // contact_number ?>
	<tr id="r_contact_number">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_contact_number"><?php echo $kt_driver_task_view->contact_number->caption() ?></span></td>
		<td data-name="contact_number" <?php echo $kt_driver_task_view->contact_number->cellAttributes() ?>>
<span id="el_kt_driver_task_contact_number">
<span<?php echo $kt_driver_task_view->contact_number->viewAttributes() ?>><?php echo $kt_driver_task_view->contact_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->email_address->Visible) { // email_address ?>
	<tr id="r_email_address">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_email_address"><?php echo $kt_driver_task_view->email_address->caption() ?></span></td>
		<td data-name="email_address" <?php echo $kt_driver_task_view->email_address->cellAttributes() ?>>
<span id="el_kt_driver_task_email_address">
<span<?php echo $kt_driver_task_view->email_address->viewAttributes() ?>><?php echo $kt_driver_task_view->email_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->customer_name->Visible) { // customer_name ?>
	<tr id="r_customer_name">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_customer_name"><?php echo $kt_driver_task_view->customer_name->caption() ?></span></td>
		<td data-name="customer_name" <?php echo $kt_driver_task_view->customer_name->cellAttributes() ?>>
<span id="el_kt_driver_task_customer_name">
<span<?php echo $kt_driver_task_view->customer_name->viewAttributes() ?>><?php echo $kt_driver_task_view->customer_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->delivery_date->Visible) { // delivery_date ?>
	<tr id="r_delivery_date">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_delivery_date"><?php echo $kt_driver_task_view->delivery_date->caption() ?></span></td>
		<td data-name="delivery_date" <?php echo $kt_driver_task_view->delivery_date->cellAttributes() ?>>
<span id="el_kt_driver_task_delivery_date">
<span<?php echo $kt_driver_task_view->delivery_date->viewAttributes() ?>><?php echo $kt_driver_task_view->delivery_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->delivery_address->Visible) { // delivery_address ?>
	<tr id="r_delivery_address">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_delivery_address"><?php echo $kt_driver_task_view->delivery_address->caption() ?></span></td>
		<td data-name="delivery_address" <?php echo $kt_driver_task_view->delivery_address->cellAttributes() ?>>
<span id="el_kt_driver_task_delivery_address">
<span<?php echo $kt_driver_task_view->delivery_address->viewAttributes() ?>><?php echo $kt_driver_task_view->delivery_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->team_id->Visible) { // team_id ?>
	<tr id="r_team_id">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_team_id"><?php echo $kt_driver_task_view->team_id->caption() ?></span></td>
		<td data-name="team_id" <?php echo $kt_driver_task_view->team_id->cellAttributes() ?>>
<span id="el_kt_driver_task_team_id">
<span<?php echo $kt_driver_task_view->team_id->viewAttributes() ?>><?php echo $kt_driver_task_view->team_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->driver_id->Visible) { // driver_id ?>
	<tr id="r_driver_id">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_driver_id"><?php echo $kt_driver_task_view->driver_id->caption() ?></span></td>
		<td data-name="driver_id" <?php echo $kt_driver_task_view->driver_id->cellAttributes() ?>>
<span id="el_kt_driver_task_driver_id">
<span<?php echo $kt_driver_task_view->driver_id->viewAttributes() ?>><?php echo $kt_driver_task_view->driver_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->task_lat->Visible) { // task_lat ?>
	<tr id="r_task_lat">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_task_lat"><?php echo $kt_driver_task_view->task_lat->caption() ?></span></td>
		<td data-name="task_lat" <?php echo $kt_driver_task_view->task_lat->cellAttributes() ?>>
<span id="el_kt_driver_task_task_lat">
<span<?php echo $kt_driver_task_view->task_lat->viewAttributes() ?>><?php echo $kt_driver_task_view->task_lat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->task_lng->Visible) { // task_lng ?>
	<tr id="r_task_lng">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_task_lng"><?php echo $kt_driver_task_view->task_lng->caption() ?></span></td>
		<td data-name="task_lng" <?php echo $kt_driver_task_view->task_lng->cellAttributes() ?>>
<span id="el_kt_driver_task_task_lng">
<span<?php echo $kt_driver_task_view->task_lng->viewAttributes() ?>><?php echo $kt_driver_task_view->task_lng->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->customer_signature->Visible) { // customer_signature ?>
	<tr id="r_customer_signature">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_customer_signature"><?php echo $kt_driver_task_view->customer_signature->caption() ?></span></td>
		<td data-name="customer_signature" <?php echo $kt_driver_task_view->customer_signature->cellAttributes() ?>>
<span id="el_kt_driver_task_customer_signature">
<span<?php echo $kt_driver_task_view->customer_signature->viewAttributes() ?>><?php echo $kt_driver_task_view->customer_signature->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->date_created->Visible) { // date_created ?>
	<tr id="r_date_created">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_date_created"><?php echo $kt_driver_task_view->date_created->caption() ?></span></td>
		<td data-name="date_created" <?php echo $kt_driver_task_view->date_created->cellAttributes() ?>>
<span id="el_kt_driver_task_date_created">
<span<?php echo $kt_driver_task_view->date_created->viewAttributes() ?>><?php echo $kt_driver_task_view->date_created->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->date_modified->Visible) { // date_modified ?>
	<tr id="r_date_modified">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_date_modified"><?php echo $kt_driver_task_view->date_modified->caption() ?></span></td>
		<td data-name="date_modified" <?php echo $kt_driver_task_view->date_modified->cellAttributes() ?>>
<span id="el_kt_driver_task_date_modified">
<span<?php echo $kt_driver_task_view->date_modified->viewAttributes() ?>><?php echo $kt_driver_task_view->date_modified->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->ip_address->Visible) { // ip_address ?>
	<tr id="r_ip_address">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_ip_address"><?php echo $kt_driver_task_view->ip_address->caption() ?></span></td>
		<td data-name="ip_address" <?php echo $kt_driver_task_view->ip_address->cellAttributes() ?>>
<span id="el_kt_driver_task_ip_address">
<span<?php echo $kt_driver_task_view->ip_address->viewAttributes() ?>><?php echo $kt_driver_task_view->ip_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->auto_assign_type->Visible) { // auto_assign_type ?>
	<tr id="r_auto_assign_type">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_auto_assign_type"><?php echo $kt_driver_task_view->auto_assign_type->caption() ?></span></td>
		<td data-name="auto_assign_type" <?php echo $kt_driver_task_view->auto_assign_type->cellAttributes() ?>>
<span id="el_kt_driver_task_auto_assign_type">
<span<?php echo $kt_driver_task_view->auto_assign_type->viewAttributes() ?>><?php echo $kt_driver_task_view->auto_assign_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->assign_started->Visible) { // assign_started ?>
	<tr id="r_assign_started">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_assign_started"><?php echo $kt_driver_task_view->assign_started->caption() ?></span></td>
		<td data-name="assign_started" <?php echo $kt_driver_task_view->assign_started->cellAttributes() ?>>
<span id="el_kt_driver_task_assign_started">
<span<?php echo $kt_driver_task_view->assign_started->viewAttributes() ?>><?php echo $kt_driver_task_view->assign_started->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->assignment_status->Visible) { // assignment_status ?>
	<tr id="r_assignment_status">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_assignment_status"><?php echo $kt_driver_task_view->assignment_status->caption() ?></span></td>
		<td data-name="assignment_status" <?php echo $kt_driver_task_view->assignment_status->cellAttributes() ?>>
<span id="el_kt_driver_task_assignment_status">
<span<?php echo $kt_driver_task_view->assignment_status->viewAttributes() ?>><?php echo $kt_driver_task_view->assignment_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->dropoff_contact_name->Visible) { // dropoff_contact_name ?>
	<tr id="r_dropoff_contact_name">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_dropoff_contact_name"><?php echo $kt_driver_task_view->dropoff_contact_name->caption() ?></span></td>
		<td data-name="dropoff_contact_name" <?php echo $kt_driver_task_view->dropoff_contact_name->cellAttributes() ?>>
<span id="el_kt_driver_task_dropoff_contact_name">
<span<?php echo $kt_driver_task_view->dropoff_contact_name->viewAttributes() ?>><?php echo $kt_driver_task_view->dropoff_contact_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->dropoff_contact_number->Visible) { // dropoff_contact_number ?>
	<tr id="r_dropoff_contact_number">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_dropoff_contact_number"><?php echo $kt_driver_task_view->dropoff_contact_number->caption() ?></span></td>
		<td data-name="dropoff_contact_number" <?php echo $kt_driver_task_view->dropoff_contact_number->cellAttributes() ?>>
<span id="el_kt_driver_task_dropoff_contact_number">
<span<?php echo $kt_driver_task_view->dropoff_contact_number->viewAttributes() ?>><?php echo $kt_driver_task_view->dropoff_contact_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->drop_address->Visible) { // drop_address ?>
	<tr id="r_drop_address">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_drop_address"><?php echo $kt_driver_task_view->drop_address->caption() ?></span></td>
		<td data-name="drop_address" <?php echo $kt_driver_task_view->drop_address->cellAttributes() ?>>
<span id="el_kt_driver_task_drop_address">
<span<?php echo $kt_driver_task_view->drop_address->viewAttributes() ?>><?php echo $kt_driver_task_view->drop_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->dropoff_task_lat->Visible) { // dropoff_task_lat ?>
	<tr id="r_dropoff_task_lat">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_dropoff_task_lat"><?php echo $kt_driver_task_view->dropoff_task_lat->caption() ?></span></td>
		<td data-name="dropoff_task_lat" <?php echo $kt_driver_task_view->dropoff_task_lat->cellAttributes() ?>>
<span id="el_kt_driver_task_dropoff_task_lat">
<span<?php echo $kt_driver_task_view->dropoff_task_lat->viewAttributes() ?>><?php echo $kt_driver_task_view->dropoff_task_lat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->dropoff_task_lng->Visible) { // dropoff_task_lng ?>
	<tr id="r_dropoff_task_lng">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_dropoff_task_lng"><?php echo $kt_driver_task_view->dropoff_task_lng->caption() ?></span></td>
		<td data-name="dropoff_task_lng" <?php echo $kt_driver_task_view->dropoff_task_lng->cellAttributes() ?>>
<span id="el_kt_driver_task_dropoff_task_lng">
<span<?php echo $kt_driver_task_view->dropoff_task_lng->viewAttributes() ?>><?php echo $kt_driver_task_view->dropoff_task_lng->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->task_token->Visible) { // task_token ?>
	<tr id="r_task_token">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_task_token"><?php echo $kt_driver_task_view->task_token->caption() ?></span></td>
		<td data-name="task_token" <?php echo $kt_driver_task_view->task_token->cellAttributes() ?>>
<span id="el_kt_driver_task_task_token">
<span<?php echo $kt_driver_task_view->task_token->viewAttributes() ?>><?php echo $kt_driver_task_view->task_token->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->ratings->Visible) { // ratings ?>
	<tr id="r_ratings">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_ratings"><?php echo $kt_driver_task_view->ratings->caption() ?></span></td>
		<td data-name="ratings" <?php echo $kt_driver_task_view->ratings->cellAttributes() ?>>
<span id="el_kt_driver_task_ratings">
<span<?php echo $kt_driver_task_view->ratings->viewAttributes() ?>><?php echo $kt_driver_task_view->ratings->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->rating_comment->Visible) { // rating_comment ?>
	<tr id="r_rating_comment">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_rating_comment"><?php echo $kt_driver_task_view->rating_comment->caption() ?></span></td>
		<td data-name="rating_comment" <?php echo $kt_driver_task_view->rating_comment->cellAttributes() ?>>
<span id="el_kt_driver_task_rating_comment">
<span<?php echo $kt_driver_task_view->rating_comment->viewAttributes() ?>><?php echo $kt_driver_task_view->rating_comment->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->critical->Visible) { // critical ?>
	<tr id="r_critical">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_critical"><?php echo $kt_driver_task_view->critical->caption() ?></span></td>
		<td data-name="critical" <?php echo $kt_driver_task_view->critical->cellAttributes() ?>>
<span id="el_kt_driver_task_critical">
<span<?php echo $kt_driver_task_view->critical->viewAttributes() ?>><?php echo $kt_driver_task_view->critical->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->souce_e->Visible) { // souce_e ?>
	<tr id="r_souce_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_souce_e"><?php echo $kt_driver_task_view->souce_e->caption() ?></span></td>
		<td data-name="souce_e" <?php echo $kt_driver_task_view->souce_e->cellAttributes() ?>>
<span id="el_kt_driver_task_souce_e">
<span<?php echo $kt_driver_task_view->souce_e->viewAttributes() ?>><?php echo $kt_driver_task_view->souce_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->shop_code_e->Visible) { // shop_code_e ?>
	<tr id="r_shop_code_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_shop_code_e"><?php echo $kt_driver_task_view->shop_code_e->caption() ?></span></td>
		<td data-name="shop_code_e" <?php echo $kt_driver_task_view->shop_code_e->cellAttributes() ?>>
<span id="el_kt_driver_task_shop_code_e">
<span<?php echo $kt_driver_task_view->shop_code_e->viewAttributes() ?>><?php echo $kt_driver_task_view->shop_code_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Received_Channel_e->Visible) { // Received_Channel_e ?>
	<tr id="r_Received_Channel_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Received_Channel_e"><?php echo $kt_driver_task_view->Received_Channel_e->caption() ?></span></td>
		<td data-name="Received_Channel_e" <?php echo $kt_driver_task_view->Received_Channel_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Received_Channel_e">
<span<?php echo $kt_driver_task_view->Received_Channel_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Received_Channel_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->PayMethod_e->Visible) { // PayMethod_e ?>
	<tr id="r_PayMethod_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_PayMethod_e"><?php echo $kt_driver_task_view->PayMethod_e->caption() ?></span></td>
		<td data-name="PayMethod_e" <?php echo $kt_driver_task_view->PayMethod_e->cellAttributes() ?>>
<span id="el_kt_driver_task_PayMethod_e">
<span<?php echo $kt_driver_task_view->PayMethod_e->viewAttributes() ?>><?php echo $kt_driver_task_view->PayMethod_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Type_e->Visible) { // Type_e ?>
	<tr id="r_Type_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Type_e"><?php echo $kt_driver_task_view->Type_e->caption() ?></span></td>
		<td data-name="Type_e" <?php echo $kt_driver_task_view->Type_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Type_e">
<span<?php echo $kt_driver_task_view->Type_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Type_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Request_Code_e->Visible) { // Request_Code_e ?>
	<tr id="r_Request_Code_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Request_Code_e"><?php echo $kt_driver_task_view->Request_Code_e->caption() ?></span></td>
		<td data-name="Request_Code_e" <?php echo $kt_driver_task_view->Request_Code_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Request_Code_e">
<span<?php echo $kt_driver_task_view->Request_Code_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Request_Code_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Status_e->Visible) { // Status_e ?>
	<tr id="r_Status_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Status_e"><?php echo $kt_driver_task_view->Status_e->caption() ?></span></td>
		<td data-name="Status_e" <?php echo $kt_driver_task_view->Status_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Status_e">
<span<?php echo $kt_driver_task_view->Status_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Status_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->PlanType_e->Visible) { // PlanType_e ?>
	<tr id="r_PlanType_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_PlanType_e"><?php echo $kt_driver_task_view->PlanType_e->caption() ?></span></td>
		<td data-name="PlanType_e" <?php echo $kt_driver_task_view->PlanType_e->cellAttributes() ?>>
<span id="el_kt_driver_task_PlanType_e">
<span<?php echo $kt_driver_task_view->PlanType_e->viewAttributes() ?>><?php echo $kt_driver_task_view->PlanType_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Plan_e->Visible) { // Plan_e ?>
	<tr id="r_Plan_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Plan_e"><?php echo $kt_driver_task_view->Plan_e->caption() ?></span></td>
		<td data-name="Plan_e" <?php echo $kt_driver_task_view->Plan_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Plan_e">
<span<?php echo $kt_driver_task_view->Plan_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Plan_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Isdn_e->Visible) { // Isdn_e ?>
	<tr id="r_Isdn_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Isdn_e"><?php echo $kt_driver_task_view->Isdn_e->caption() ?></span></td>
		<td data-name="Isdn_e" <?php echo $kt_driver_task_view->Isdn_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Isdn_e">
<span<?php echo $kt_driver_task_view->Isdn_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Isdn_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->serial_sim_handset_e->Visible) { // serial_sim_handset_e ?>
	<tr id="r_serial_sim_handset_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_serial_sim_handset_e"><?php echo $kt_driver_task_view->serial_sim_handset_e->caption() ?></span></td>
		<td data-name="serial_sim_handset_e" <?php echo $kt_driver_task_view->serial_sim_handset_e->cellAttributes() ?>>
<span id="el_kt_driver_task_serial_sim_handset_e">
<span<?php echo $kt_driver_task_view->serial_sim_handset_e->viewAttributes() ?>><?php echo $kt_driver_task_view->serial_sim_handset_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->handset_e->Visible) { // handset_e ?>
	<tr id="r_handset_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_handset_e"><?php echo $kt_driver_task_view->handset_e->caption() ?></span></td>
		<td data-name="handset_e" <?php echo $kt_driver_task_view->handset_e->cellAttributes() ?>>
<span id="el_kt_driver_task_handset_e">
<span<?php echo $kt_driver_task_view->handset_e->viewAttributes() ?>><?php echo $kt_driver_task_view->handset_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Connect_Reason_e->Visible) { // Connect_Reason_e ?>
	<tr id="r_Connect_Reason_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Connect_Reason_e"><?php echo $kt_driver_task_view->Connect_Reason_e->caption() ?></span></td>
		<td data-name="Connect_Reason_e" <?php echo $kt_driver_task_view->Connect_Reason_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Connect_Reason_e">
<span<?php echo $kt_driver_task_view->Connect_Reason_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Connect_Reason_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Price_e->Visible) { // Price_e ?>
	<tr id="r_Price_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Price_e"><?php echo $kt_driver_task_view->Price_e->caption() ?></span></td>
		<td data-name="Price_e" <?php echo $kt_driver_task_view->Price_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Price_e">
<span<?php echo $kt_driver_task_view->Price_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Price_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Current_Operator_e->Visible) { // Current_Operator_e ?>
	<tr id="r_Current_Operator_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Current_Operator_e"><?php echo $kt_driver_task_view->Current_Operator_e->caption() ?></span></td>
		<td data-name="Current_Operator_e" <?php echo $kt_driver_task_view->Current_Operator_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Current_Operator_e">
<span<?php echo $kt_driver_task_view->Current_Operator_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Current_Operator_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Current_Plan_Type_e->Visible) { // Current_Plan_Type_e ?>
	<tr id="r_Current_Plan_Type_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Current_Plan_Type_e"><?php echo $kt_driver_task_view->Current_Plan_Type_e->caption() ?></span></td>
		<td data-name="Current_Plan_Type_e" <?php echo $kt_driver_task_view->Current_Plan_Type_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Current_Plan_Type_e">
<span<?php echo $kt_driver_task_view->Current_Plan_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Current_Plan_Type_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Document_Number_e->Visible) { // Document_Number_e ?>
	<tr id="r_Document_Number_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Document_Number_e"><?php echo $kt_driver_task_view->Document_Number_e->caption() ?></span></td>
		<td data-name="Document_Number_e" <?php echo $kt_driver_task_view->Document_Number_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Document_Number_e">
<span<?php echo $kt_driver_task_view->Document_Number_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Document_Number_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Document_Type_e->Visible) { // Document_Type_e ?>
	<tr id="r_Document_Type_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Document_Type_e"><?php echo $kt_driver_task_view->Document_Type_e->caption() ?></span></td>
		<td data-name="Document_Type_e" <?php echo $kt_driver_task_view->Document_Type_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Document_Type_e">
<span<?php echo $kt_driver_task_view->Document_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Document_Type_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->assignStaffCode_e->Visible) { // assignStaffCode_e ?>
	<tr id="r_assignStaffCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_assignStaffCode_e"><?php echo $kt_driver_task_view->assignStaffCode_e->caption() ?></span></td>
		<td data-name="assignStaffCode_e" <?php echo $kt_driver_task_view->assignStaffCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_assignStaffCode_e">
<span<?php echo $kt_driver_task_view->assignStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->assignStaffCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Delivery_Type_e->Visible) { // Delivery_Type_e ?>
	<tr id="r_Delivery_Type_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Delivery_Type_e"><?php echo $kt_driver_task_view->Delivery_Type_e->caption() ?></span></td>
		<td data-name="Delivery_Type_e" <?php echo $kt_driver_task_view->Delivery_Type_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Delivery_Type_e">
<span<?php echo $kt_driver_task_view->Delivery_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Delivery_Type_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->assignStaffType_e->Visible) { // assignStaffType_e ?>
	<tr id="r_assignStaffType_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_assignStaffType_e"><?php echo $kt_driver_task_view->assignStaffType_e->caption() ?></span></td>
		<td data-name="assignStaffType_e" <?php echo $kt_driver_task_view->assignStaffType_e->cellAttributes() ?>>
<span id="el_kt_driver_task_assignStaffType_e">
<span<?php echo $kt_driver_task_view->assignStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_view->assignStaffType_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->receiveStaffCode_e->Visible) { // receiveStaffCode_e ?>
	<tr id="r_receiveStaffCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_receiveStaffCode_e"><?php echo $kt_driver_task_view->receiveStaffCode_e->caption() ?></span></td>
		<td data-name="receiveStaffCode_e" <?php echo $kt_driver_task_view->receiveStaffCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_receiveStaffCode_e">
<span<?php echo $kt_driver_task_view->receiveStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->receiveStaffCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->receiveStaffType_e->Visible) { // receiveStaffType_e ?>
	<tr id="r_receiveStaffType_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_receiveStaffType_e"><?php echo $kt_driver_task_view->receiveStaffType_e->caption() ?></span></td>
		<td data-name="receiveStaffType_e" <?php echo $kt_driver_task_view->receiveStaffType_e->cellAttributes() ?>>
<span id="el_kt_driver_task_receiveStaffType_e">
<span<?php echo $kt_driver_task_view->receiveStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_view->receiveStaffType_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->connectStaffCode_e->Visible) { // connectStaffCode_e ?>
	<tr id="r_connectStaffCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_connectStaffCode_e"><?php echo $kt_driver_task_view->connectStaffCode_e->caption() ?></span></td>
		<td data-name="connectStaffCode_e" <?php echo $kt_driver_task_view->connectStaffCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_connectStaffCode_e">
<span<?php echo $kt_driver_task_view->connectStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->connectStaffCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->connectStaffType_e->Visible) { // connectStaffType_e ?>
	<tr id="r_connectStaffType_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_connectStaffType_e"><?php echo $kt_driver_task_view->connectStaffType_e->caption() ?></span></td>
		<td data-name="connectStaffType_e" <?php echo $kt_driver_task_view->connectStaffType_e->cellAttributes() ?>>
<span id="el_kt_driver_task_connectStaffType_e">
<span<?php echo $kt_driver_task_view->connectStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_view->connectStaffType_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->shopName_e->Visible) { // shopName_e ?>
	<tr id="r_shopName_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_shopName_e"><?php echo $kt_driver_task_view->shopName_e->caption() ?></span></td>
		<td data-name="shopName_e" <?php echo $kt_driver_task_view->shopName_e->cellAttributes() ?>>
<span id="el_kt_driver_task_shopName_e">
<span<?php echo $kt_driver_task_view->shopName_e->viewAttributes() ?>><?php echo $kt_driver_task_view->shopName_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->saleOrderCode_e->Visible) { // saleOrderCode_e ?>
	<tr id="r_saleOrderCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_saleOrderCode_e"><?php echo $kt_driver_task_view->saleOrderCode_e->caption() ?></span></td>
		<td data-name="saleOrderCode_e" <?php echo $kt_driver_task_view->saleOrderCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_saleOrderCode_e">
<span<?php echo $kt_driver_task_view->saleOrderCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->saleOrderCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->consultantCode_e->Visible) { // consultantCode_e ?>
	<tr id="r_consultantCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_consultantCode_e"><?php echo $kt_driver_task_view->consultantCode_e->caption() ?></span></td>
		<td data-name="consultantCode_e" <?php echo $kt_driver_task_view->consultantCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_consultantCode_e">
<span<?php echo $kt_driver_task_view->consultantCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->consultantCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->consultantName_e->Visible) { // consultantName_e ?>
	<tr id="r_consultantName_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_consultantName_e"><?php echo $kt_driver_task_view->consultantName_e->caption() ?></span></td>
		<td data-name="consultantName_e" <?php echo $kt_driver_task_view->consultantName_e->cellAttributes() ?>>
<span id="el_kt_driver_task_consultantName_e">
<span<?php echo $kt_driver_task_view->consultantName_e->viewAttributes() ?>><?php echo $kt_driver_task_view->consultantName_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->consultantType_e->Visible) { // consultantType_e ?>
	<tr id="r_consultantType_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_consultantType_e"><?php echo $kt_driver_task_view->consultantType_e->caption() ?></span></td>
		<td data-name="consultantType_e" <?php echo $kt_driver_task_view->consultantType_e->cellAttributes() ?>>
<span id="el_kt_driver_task_consultantType_e">
<span<?php echo $kt_driver_task_view->consultantType_e->viewAttributes() ?>><?php echo $kt_driver_task_view->consultantType_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->created_By_e->Visible) { // created_By_e ?>
	<tr id="r_created_By_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_created_By_e"><?php echo $kt_driver_task_view->created_By_e->caption() ?></span></td>
		<td data-name="created_By_e" <?php echo $kt_driver_task_view->created_By_e->cellAttributes() ?>>
<span id="el_kt_driver_task_created_By_e">
<span<?php echo $kt_driver_task_view->created_By_e->viewAttributes() ?>><?php echo $kt_driver_task_view->created_By_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->createdBranch_e->Visible) { // createdBranch_e ?>
	<tr id="r_createdBranch_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_createdBranch_e"><?php echo $kt_driver_task_view->createdBranch_e->caption() ?></span></td>
		<td data-name="createdBranch_e" <?php echo $kt_driver_task_view->createdBranch_e->cellAttributes() ?>>
<span id="el_kt_driver_task_createdBranch_e">
<span<?php echo $kt_driver_task_view->createdBranch_e->viewAttributes() ?>><?php echo $kt_driver_task_view->createdBranch_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->generated_Code_By_e->Visible) { // generated_Code_By_e ?>
	<tr id="r_generated_Code_By_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_generated_Code_By_e"><?php echo $kt_driver_task_view->generated_Code_By_e->caption() ?></span></td>
		<td data-name="generated_Code_By_e" <?php echo $kt_driver_task_view->generated_Code_By_e->cellAttributes() ?>>
<span id="el_kt_driver_task_generated_Code_By_e">
<span<?php echo $kt_driver_task_view->generated_Code_By_e->viewAttributes() ?>><?php echo $kt_driver_task_view->generated_Code_By_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->approve_Paid_By_e->Visible) { // approve_Paid_By_e ?>
	<tr id="r_approve_Paid_By_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_approve_Paid_By_e"><?php echo $kt_driver_task_view->approve_Paid_By_e->caption() ?></span></td>
		<td data-name="approve_Paid_By_e" <?php echo $kt_driver_task_view->approve_Paid_By_e->cellAttributes() ?>>
<span id="el_kt_driver_task_approve_Paid_By_e">
<span<?php echo $kt_driver_task_view->approve_Paid_By_e->viewAttributes() ?>><?php echo $kt_driver_task_view->approve_Paid_By_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Delivery_Note_e->Visible) { // Delivery_Note_e ?>
	<tr id="r_Delivery_Note_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Delivery_Note_e"><?php echo $kt_driver_task_view->Delivery_Note_e->caption() ?></span></td>
		<td data-name="Delivery_Note_e" <?php echo $kt_driver_task_view->Delivery_Note_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Delivery_Note_e">
<span<?php echo $kt_driver_task_view->Delivery_Note_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Delivery_Note_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Delivery_Code_e->Visible) { // Delivery_Code_e ?>
	<tr id="r_Delivery_Code_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Delivery_Code_e"><?php echo $kt_driver_task_view->Delivery_Code_e->caption() ?></span></td>
		<td data-name="Delivery_Code_e" <?php echo $kt_driver_task_view->Delivery_Code_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Delivery_Code_e">
<span<?php echo $kt_driver_task_view->Delivery_Code_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Delivery_Code_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Customer_Note_e->Visible) { // Customer_Note_e ?>
	<tr id="r_Customer_Note_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Customer_Note_e"><?php echo $kt_driver_task_view->Customer_Note_e->caption() ?></span></td>
		<td data-name="Customer_Note_e" <?php echo $kt_driver_task_view->Customer_Note_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Customer_Note_e">
<span<?php echo $kt_driver_task_view->Customer_Note_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Customer_Note_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->saleOrderCreateDate_e->Visible) { // saleOrderCreateDate_e ?>
	<tr id="r_saleOrderCreateDate_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_saleOrderCreateDate_e"><?php echo $kt_driver_task_view->saleOrderCreateDate_e->caption() ?></span></td>
		<td data-name="saleOrderCreateDate_e" <?php echo $kt_driver_task_view->saleOrderCreateDate_e->cellAttributes() ?>>
<span id="el_kt_driver_task_saleOrderCreateDate_e">
<span<?php echo $kt_driver_task_view->saleOrderCreateDate_e->viewAttributes() ?>><?php echo $kt_driver_task_view->saleOrderCreateDate_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->saleOrderPayDate_e->Visible) { // saleOrderPayDate_e ?>
	<tr id="r_saleOrderPayDate_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_saleOrderPayDate_e"><?php echo $kt_driver_task_view->saleOrderPayDate_e->caption() ?></span></td>
		<td data-name="saleOrderPayDate_e" <?php echo $kt_driver_task_view->saleOrderPayDate_e->cellAttributes() ?>>
<span id="el_kt_driver_task_saleOrderPayDate_e">
<span<?php echo $kt_driver_task_view->saleOrderPayDate_e->viewAttributes() ?>><?php echo $kt_driver_task_view->saleOrderPayDate_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Time_of_Procesing_e->Visible) { // Time_of_Procesing_e ?>
	<tr id="r_Time_of_Procesing_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Time_of_Procesing_e"><?php echo $kt_driver_task_view->Time_of_Procesing_e->caption() ?></span></td>
		<td data-name="Time_of_Procesing_e" <?php echo $kt_driver_task_view->Time_of_Procesing_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Time_of_Procesing_e">
<span<?php echo $kt_driver_task_view->Time_of_Procesing_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Time_of_Procesing_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Time_of_new_e->Visible) { // Time_of_new_e ?>
	<tr id="r_Time_of_new_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Time_of_new_e"><?php echo $kt_driver_task_view->Time_of_new_e->caption() ?></span></td>
		<td data-name="Time_of_new_e" <?php echo $kt_driver_task_view->Time_of_new_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Time_of_new_e">
<span<?php echo $kt_driver_task_view->Time_of_new_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Time_of_new_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Time_of_Finished_e->Visible) { // Time_of_Finished_e ?>
	<tr id="r_Time_of_Finished_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Time_of_Finished_e"><?php echo $kt_driver_task_view->Time_of_Finished_e->caption() ?></span></td>
		<td data-name="Time_of_Finished_e" <?php echo $kt_driver_task_view->Time_of_Finished_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Time_of_Finished_e">
<span<?php echo $kt_driver_task_view->Time_of_Finished_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Time_of_Finished_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->KPI_CC_Hour_e->Visible) { // KPI_CC_Hour_e ?>
	<tr id="r_KPI_CC_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_KPI_CC_Hour_e"><?php echo $kt_driver_task_view->KPI_CC_Hour_e->caption() ?></span></td>
		<td data-name="KPI_CC_Hour_e" <?php echo $kt_driver_task_view->KPI_CC_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_KPI_CC_Hour_e">
<span<?php echo $kt_driver_task_view->KPI_CC_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->KPI_CC_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->KPI_NEW_Hour_e->Visible) { // KPI_NEW_Hour_e ?>
	<tr id="r_KPI_NEW_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_KPI_NEW_Hour_e"><?php echo $kt_driver_task_view->KPI_NEW_Hour_e->caption() ?></span></td>
		<td data-name="KPI_NEW_Hour_e" <?php echo $kt_driver_task_view->KPI_NEW_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_KPI_NEW_Hour_e">
<span<?php echo $kt_driver_task_view->KPI_NEW_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->KPI_NEW_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->KPI_PROCESING_Hour_e->Visible) { // KPI_PROCESING_Hour_e ?>
	<tr id="r_KPI_PROCESING_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_KPI_PROCESING_Hour_e"><?php echo $kt_driver_task_view->KPI_PROCESING_Hour_e->caption() ?></span></td>
		<td data-name="KPI_PROCESING_Hour_e" <?php echo $kt_driver_task_view->KPI_PROCESING_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_KPI_PROCESING_Hour_e">
<span<?php echo $kt_driver_task_view->KPI_PROCESING_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->KPI_PROCESING_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->KPI_ALL_Hour_e->Visible) { // KPI_ALL_Hour_e ?>
	<tr id="r_KPI_ALL_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_KPI_ALL_Hour_e"><?php echo $kt_driver_task_view->KPI_ALL_Hour_e->caption() ?></span></td>
		<td data-name="KPI_ALL_Hour_e" <?php echo $kt_driver_task_view->KPI_ALL_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_KPI_ALL_Hour_e">
<span<?php echo $kt_driver_task_view->KPI_ALL_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->KPI_ALL_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Kpi_Register_Hour_e->Visible) { // Kpi_Register_Hour_e ?>
	<tr id="r_Kpi_Register_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Kpi_Register_Hour_e"><?php echo $kt_driver_task_view->Kpi_Register_Hour_e->caption() ?></span></td>
		<td data-name="Kpi_Register_Hour_e" <?php echo $kt_driver_task_view->Kpi_Register_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Kpi_Register_Hour_e">
<span<?php echo $kt_driver_task_view->Kpi_Register_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Kpi_Register_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Kpi_Bitel_Hour_e->Visible) { // Kpi_Bitel_Hour_e ?>
	<tr id="r_Kpi_Bitel_Hour_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Kpi_Bitel_Hour_e"><?php echo $kt_driver_task_view->Kpi_Bitel_Hour_e->caption() ?></span></td>
		<td data-name="Kpi_Bitel_Hour_e" <?php echo $kt_driver_task_view->Kpi_Bitel_Hour_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Kpi_Bitel_Hour_e">
<span<?php echo $kt_driver_task_view->Kpi_Bitel_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Kpi_Bitel_Hour_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->AmountGB_e->Visible) { // AmountGB_e ?>
	<tr id="r_AmountGB_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_AmountGB_e"><?php echo $kt_driver_task_view->AmountGB_e->caption() ?></span></td>
		<td data-name="AmountGB_e" <?php echo $kt_driver_task_view->AmountGB_e->cellAttributes() ?>>
<span id="el_kt_driver_task_AmountGB_e">
<span<?php echo $kt_driver_task_view->AmountGB_e->viewAttributes() ?>><?php echo $kt_driver_task_view->AmountGB_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Price_1_e->Visible) { // Price_1_e ?>
	<tr id="r_Price_1_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Price_1_e"><?php echo $kt_driver_task_view->Price_1_e->caption() ?></span></td>
		<td data-name="Price_1_e" <?php echo $kt_driver_task_view->Price_1_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Price_1_e">
<span<?php echo $kt_driver_task_view->Price_1_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Price_1_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Status_1_e->Visible) { // Status_1_e ?>
	<tr id="r_Status_1_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Status_1_e"><?php echo $kt_driver_task_view->Status_1_e->caption() ?></span></td>
		<td data-name="Status_1_e" <?php echo $kt_driver_task_view->Status_1_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Status_1_e">
<span<?php echo $kt_driver_task_view->Status_1_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Status_1_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Registered_Date_e->Visible) { // Registered_Date_e ?>
	<tr id="r_Registered_Date_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Registered_Date_e"><?php echo $kt_driver_task_view->Registered_Date_e->caption() ?></span></td>
		<td data-name="Registered_Date_e" <?php echo $kt_driver_task_view->Registered_Date_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Registered_Date_e">
<span<?php echo $kt_driver_task_view->Registered_Date_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Registered_Date_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Sumary_e->Visible) { // Sumary_e ?>
	<tr id="r_Sumary_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Sumary_e"><?php echo $kt_driver_task_view->Sumary_e->caption() ?></span></td>
		<td data-name="Sumary_e" <?php echo $kt_driver_task_view->Sumary_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Sumary_e">
<span<?php echo $kt_driver_task_view->Sumary_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Sumary_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Plans_e->Visible) { // Plans_e ?>
	<tr id="r_Plans_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Plans_e"><?php echo $kt_driver_task_view->Plans_e->caption() ?></span></td>
		<td data-name="Plans_e" <?php echo $kt_driver_task_view->Plans_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Plans_e">
<span<?php echo $kt_driver_task_view->Plans_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Plans_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Isdns_e->Visible) { // Isdns_e ?>
	<tr id="r_Isdns_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Isdns_e"><?php echo $kt_driver_task_view->Isdns_e->caption() ?></span></td>
		<td data-name="Isdns_e" <?php echo $kt_driver_task_view->Isdns_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Isdns_e">
<span<?php echo $kt_driver_task_view->Isdns_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Isdns_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->PlanTypes_e->Visible) { // PlanTypes_e ?>
	<tr id="r_PlanTypes_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_PlanTypes_e"><?php echo $kt_driver_task_view->PlanTypes_e->caption() ?></span></td>
		<td data-name="PlanTypes_e" <?php echo $kt_driver_task_view->PlanTypes_e->cellAttributes() ?>>
<span id="el_kt_driver_task_PlanTypes_e">
<span<?php echo $kt_driver_task_view->PlanTypes_e->viewAttributes() ?>><?php echo $kt_driver_task_view->PlanTypes_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Serials_e->Visible) { // Serials_e ?>
	<tr id="r_Serials_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Serials_e"><?php echo $kt_driver_task_view->Serials_e->caption() ?></span></td>
		<td data-name="Serials_e" <?php echo $kt_driver_task_view->Serials_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Serials_e">
<span<?php echo $kt_driver_task_view->Serials_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Serials_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Status_2_e->Visible) { // Status_2_e ?>
	<tr id="r_Status_2_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Status_2_e"><?php echo $kt_driver_task_view->Status_2_e->caption() ?></span></td>
		<td data-name="Status_2_e" <?php echo $kt_driver_task_view->Status_2_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Status_2_e">
<span<?php echo $kt_driver_task_view->Status_2_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Status_2_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Registered_Date_2_e->Visible) { // Registered_Date_2_e ?>
	<tr id="r_Registered_Date_2_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Registered_Date_2_e"><?php echo $kt_driver_task_view->Registered_Date_2_e->caption() ?></span></td>
		<td data-name="Registered_Date_2_e" <?php echo $kt_driver_task_view->Registered_Date_2_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Registered_Date_2_e">
<span<?php echo $kt_driver_task_view->Registered_Date_2_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Registered_Date_2_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Summary_2_e->Visible) { // Summary_2_e ?>
	<tr id="r_Summary_2_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Summary_2_e"><?php echo $kt_driver_task_view->Summary_2_e->caption() ?></span></td>
		<td data-name="Summary_2_e" <?php echo $kt_driver_task_view->Summary_2_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Summary_2_e">
<span<?php echo $kt_driver_task_view->Summary_2_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Summary_2_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->serial_2_e->Visible) { // serial_2_e ?>
	<tr id="r_serial_2_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_serial_2_e"><?php echo $kt_driver_task_view->serial_2_e->caption() ?></span></td>
		<td data-name="serial_2_e" <?php echo $kt_driver_task_view->serial_2_e->cellAttributes() ?>>
<span id="el_kt_driver_task_serial_2_e">
<span<?php echo $kt_driver_task_view->serial_2_e->viewAttributes() ?>><?php echo $kt_driver_task_view->serial_2_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->HandsetCode_e->Visible) { // HandsetCode_e ?>
	<tr id="r_HandsetCode_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_HandsetCode_e"><?php echo $kt_driver_task_view->HandsetCode_e->caption() ?></span></td>
		<td data-name="HandsetCode_e" <?php echo $kt_driver_task_view->HandsetCode_e->cellAttributes() ?>>
<span id="el_kt_driver_task_HandsetCode_e">
<span<?php echo $kt_driver_task_view->HandsetCode_e->viewAttributes() ?>><?php echo $kt_driver_task_view->HandsetCode_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->HandsetName_e->Visible) { // HandsetName_e ?>
	<tr id="r_HandsetName_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_HandsetName_e"><?php echo $kt_driver_task_view->HandsetName_e->caption() ?></span></td>
		<td data-name="HandsetName_e" <?php echo $kt_driver_task_view->HandsetName_e->cellAttributes() ?>>
<span id="el_kt_driver_task_HandsetName_e">
<span<?php echo $kt_driver_task_view->HandsetName_e->viewAttributes() ?>><?php echo $kt_driver_task_view->HandsetName_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Status_3_e->Visible) { // Status_3_e ?>
	<tr id="r_Status_3_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Status_3_e"><?php echo $kt_driver_task_view->Status_3_e->caption() ?></span></td>
		<td data-name="Status_3_e" <?php echo $kt_driver_task_view->Status_3_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Status_3_e">
<span<?php echo $kt_driver_task_view->Status_3_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Status_3_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Summary_3_e->Visible) { // Summary_3_e ?>
	<tr id="r_Summary_3_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Summary_3_e"><?php echo $kt_driver_task_view->Summary_3_e->caption() ?></span></td>
		<td data-name="Summary_3_e" <?php echo $kt_driver_task_view->Summary_3_e->cellAttributes() ?>>
<span id="el_kt_driver_task_Summary_3_e">
<span<?php echo $kt_driver_task_view->Summary_3_e->viewAttributes() ?>><?php echo $kt_driver_task_view->Summary_3_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->fecha_activa_e->Visible) { // fecha_activa_e ?>
	<tr id="r_fecha_activa_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_fecha_activa_e"><?php echo $kt_driver_task_view->fecha_activa_e->caption() ?></span></td>
		<td data-name="fecha_activa_e" <?php echo $kt_driver_task_view->fecha_activa_e->cellAttributes() ?>>
<span id="el_kt_driver_task_fecha_activa_e">
<span<?php echo $kt_driver_task_view->fecha_activa_e->viewAttributes() ?>><?php echo $kt_driver_task_view->fecha_activa_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->mes_activa_e->Visible) { // mes_activa_e ?>
	<tr id="r_mes_activa_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_mes_activa_e"><?php echo $kt_driver_task_view->mes_activa_e->caption() ?></span></td>
		<td data-name="mes_activa_e" <?php echo $kt_driver_task_view->mes_activa_e->cellAttributes() ?>>
<span id="el_kt_driver_task_mes_activa_e">
<span<?php echo $kt_driver_task_view->mes_activa_e->viewAttributes() ?>><?php echo $kt_driver_task_view->mes_activa_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->SOURCE_OUT_e->Visible) { // SOURCE_OUT_e ?>
	<tr id="r_SOURCE_OUT_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_SOURCE_OUT_e"><?php echo $kt_driver_task_view->SOURCE_OUT_e->caption() ?></span></td>
		<td data-name="SOURCE_OUT_e" <?php echo $kt_driver_task_view->SOURCE_OUT_e->cellAttributes() ?>>
<span id="el_kt_driver_task_SOURCE_OUT_e">
<span<?php echo $kt_driver_task_view->SOURCE_OUT_e->viewAttributes() ?>><?php echo $kt_driver_task_view->SOURCE_OUT_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->fecha_crea_e->Visible) { // fecha_crea_e ?>
	<tr id="r_fecha_crea_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_fecha_crea_e"><?php echo $kt_driver_task_view->fecha_crea_e->caption() ?></span></td>
		<td data-name="fecha_crea_e" <?php echo $kt_driver_task_view->fecha_crea_e->cellAttributes() ?>>
<span id="el_kt_driver_task_fecha_crea_e">
<span<?php echo $kt_driver_task_view->fecha_crea_e->viewAttributes() ?>><?php echo $kt_driver_task_view->fecha_crea_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->mes_crea_e->Visible) { // mes_crea_e ?>
	<tr id="r_mes_crea_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_mes_crea_e"><?php echo $kt_driver_task_view->mes_crea_e->caption() ?></span></td>
		<td data-name="mes_crea_e" <?php echo $kt_driver_task_view->mes_crea_e->cellAttributes() ?>>
<span id="el_kt_driver_task_mes_crea_e">
<span<?php echo $kt_driver_task_view->mes_crea_e->viewAttributes() ?>><?php echo $kt_driver_task_view->mes_crea_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->moto_e->Visible) { // moto_e ?>
	<tr id="r_moto_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_moto_e"><?php echo $kt_driver_task_view->moto_e->caption() ?></span></td>
		<td data-name="moto_e" <?php echo $kt_driver_task_view->moto_e->cellAttributes() ?>>
<span id="el_kt_driver_task_moto_e">
<span<?php echo $kt_driver_task_view->moto_e->viewAttributes() ?>><?php echo $kt_driver_task_view->moto_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->customer_id->Visible) { // customer_id ?>
	<tr id="r_customer_id">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_customer_id"><?php echo $kt_driver_task_view->customer_id->caption() ?></span></td>
		<td data-name="customer_id" <?php echo $kt_driver_task_view->customer_id->cellAttributes() ?>>
<span id="el_kt_driver_task_customer_id">
<span<?php echo $kt_driver_task_view->customer_id->viewAttributes() ?>><?php echo $kt_driver_task_view->customer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_status"><?php echo $kt_driver_task_view->status->caption() ?></span></td>
		<td data-name="status" <?php echo $kt_driver_task_view->status->cellAttributes() ?>>
<span id="el_kt_driver_task_status">
<span<?php echo $kt_driver_task_view->status->viewAttributes() ?>><?php echo $kt_driver_task_view->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->address_e->Visible) { // address_e ?>
	<tr id="r_address_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_address_e"><?php echo $kt_driver_task_view->address_e->caption() ?></span></td>
		<td data-name="address_e" <?php echo $kt_driver_task_view->address_e->cellAttributes() ?>>
<span id="el_kt_driver_task_address_e">
<span<?php echo $kt_driver_task_view->address_e->viewAttributes() ?>><?php echo $kt_driver_task_view->address_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->branch_e->Visible) { // branch_e ?>
	<tr id="r_branch_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_branch_e"><?php echo $kt_driver_task_view->branch_e->caption() ?></span></td>
		<td data-name="branch_e" <?php echo $kt_driver_task_view->branch_e->cellAttributes() ?>>
<span id="el_kt_driver_task_branch_e">
<span<?php echo $kt_driver_task_view->branch_e->viewAttributes() ?>><?php echo $kt_driver_task_view->branch_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->CreatedTime_e->Visible) { // CreatedTime_e ?>
	<tr id="r_CreatedTime_e">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_CreatedTime_e"><?php echo $kt_driver_task_view->CreatedTime_e->caption() ?></span></td>
		<td data-name="CreatedTime_e" <?php echo $kt_driver_task_view->CreatedTime_e->cellAttributes() ?>>
<span id="el_kt_driver_task_CreatedTime_e">
<span<?php echo $kt_driver_task_view->CreatedTime_e->viewAttributes() ?>><?php echo $kt_driver_task_view->CreatedTime_e->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kt_driver_task_view->Status_n->Visible) { // Status_n ?>
	<tr id="r_Status_n">
		<td class="<?php echo $kt_driver_task_view->TableLeftColumnClass ?>"><span id="elh_kt_driver_task_Status_n"><?php echo $kt_driver_task_view->Status_n->caption() ?></span></td>
		<td data-name="Status_n" <?php echo $kt_driver_task_view->Status_n->cellAttributes() ?>>
<span id="el_kt_driver_task_Status_n">
<span<?php echo $kt_driver_task_view->Status_n->viewAttributes() ?>><?php echo $kt_driver_task_view->Status_n->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$kt_driver_task_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kt_driver_task_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kt_driver_task_view->terminate();
?>