<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_tablaweb_view = new kp_tablaweb_view();

// Run the page
$kp_tablaweb_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_tablaweb_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_tablaweb_view->isExport()) { ?>
<script>
var fkp_tablawebview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fkp_tablawebview = currentForm = new ew.Form("fkp_tablawebview", "view");
	loadjs.done("fkp_tablawebview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_tablaweb_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $kp_tablaweb_view->ExportOptions->render("body") ?>
<?php $kp_tablaweb_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $kp_tablaweb_view->showPageHeader(); ?>
<?php
$kp_tablaweb_view->showMessage();
?>
<form name="fkp_tablawebview" id="fkp_tablawebview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_tablaweb">
<input type="hidden" name="modal" value="<?php echo (int)$kp_tablaweb_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($kp_tablaweb_view->idwebta->Visible) { // idwebta ?>
	<tr id="r_idwebta">
		<td class="<?php echo $kp_tablaweb_view->TableLeftColumnClass ?>"><span id="elh_kp_tablaweb_idwebta"><?php echo $kp_tablaweb_view->idwebta->caption() ?></span></td>
		<td data-name="idwebta" <?php echo $kp_tablaweb_view->idwebta->cellAttributes() ?>>
<span id="el_kp_tablaweb_idwebta">
<span<?php echo $kp_tablaweb_view->idwebta->viewAttributes() ?>><?php echo $kp_tablaweb_view->idwebta->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_tablaweb_view->nomwebta->Visible) { // nomwebta ?>
	<tr id="r_nomwebta">
		<td class="<?php echo $kp_tablaweb_view->TableLeftColumnClass ?>"><span id="elh_kp_tablaweb_nomwebta"><?php echo $kp_tablaweb_view->nomwebta->caption() ?></span></td>
		<td data-name="nomwebta" <?php echo $kp_tablaweb_view->nomwebta->cellAttributes() ?>>
<span id="el_kp_tablaweb_nomwebta">
<span<?php echo $kp_tablaweb_view->nomwebta->viewAttributes() ?>><?php echo $kp_tablaweb_view->nomwebta->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_tablaweb_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $kp_tablaweb_view->TableLeftColumnClass ?>"><span id="elh_kp_tablaweb_estado"><?php echo $kp_tablaweb_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $kp_tablaweb_view->estado->cellAttributes() ?>>
<span id="el_kp_tablaweb_estado">
<span<?php echo $kp_tablaweb_view->estado->viewAttributes() ?>><?php echo $kp_tablaweb_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_tablaweb_view->ordenar->Visible) { // ordenar ?>
	<tr id="r_ordenar">
		<td class="<?php echo $kp_tablaweb_view->TableLeftColumnClass ?>"><span id="elh_kp_tablaweb_ordenar"><?php echo $kp_tablaweb_view->ordenar->caption() ?></span></td>
		<td data-name="ordenar" <?php echo $kp_tablaweb_view->ordenar->cellAttributes() ?>>
<span id="el_kp_tablaweb_ordenar">
<span<?php echo $kp_tablaweb_view->ordenar->viewAttributes() ?>><?php echo $kp_tablaweb_view->ordenar->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_tablaweb_view->icon->Visible) { // icon ?>
	<tr id="r_icon">
		<td class="<?php echo $kp_tablaweb_view->TableLeftColumnClass ?>"><span id="elh_kp_tablaweb_icon"><?php echo $kp_tablaweb_view->icon->caption() ?></span></td>
		<td data-name="icon" <?php echo $kp_tablaweb_view->icon->cellAttributes() ?>>
<span id="el_kp_tablaweb_icon">
<span<?php echo $kp_tablaweb_view->icon->viewAttributes() ?>><?php echo $kp_tablaweb_view->icon->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$kp_tablaweb_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_tablaweb_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_tablaweb_view->terminate();
?>