<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_proyecto_list = new kp_proyecto_list();

// Run the page
$kp_proyecto_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_proyecto_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_proyecto_list->isExport()) { ?>
<script>
var fkp_proyectolist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_proyectolist = currentForm = new ew.Form("fkp_proyectolist", "list");
	fkp_proyectolist.formKeyCountName = '<?php echo $kp_proyecto_list->FormKeyCountName ?>';
	loadjs.done("fkp_proyectolist");
});
var fkp_proyectolistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_proyectolistsrch = currentSearchForm = new ew.Form("fkp_proyectolistsrch");

	// Dynamic selection lists
	// Filters

	fkp_proyectolistsrch.filterList = <?php echo $kp_proyecto_list->getFilterList() ?>;
	loadjs.done("fkp_proyectolistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_proyecto_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_proyecto_list->TotalRecords > 0 && $kp_proyecto_list->ExportOptions->visible()) { ?>
<?php $kp_proyecto_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_proyecto_list->ImportOptions->visible()) { ?>
<?php $kp_proyecto_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_proyecto_list->SearchOptions->visible()) { ?>
<?php $kp_proyecto_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_proyecto_list->FilterOptions->visible()) { ?>
<?php $kp_proyecto_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_proyecto_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_proyecto_list->isExport() && !$kp_proyecto->CurrentAction) { ?>
<form name="fkp_proyectolistsrch" id="fkp_proyectolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_proyectolistsrch-search-panel" class="<?php echo $kp_proyecto_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_proyecto">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_proyecto_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_proyecto_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_proyecto_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_proyecto_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_proyecto_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_proyecto_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_proyecto_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_proyecto_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_proyecto_list->showPageHeader(); ?>
<?php
$kp_proyecto_list->showMessage();
?>
<?php if ($kp_proyecto_list->TotalRecords > 0 || $kp_proyecto->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_proyecto_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_proyecto">
<form name="fkp_proyectolist" id="fkp_proyectolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_proyecto">
<div id="gmp_kp_proyecto" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_proyecto_list->TotalRecords > 0 || $kp_proyecto_list->isGridEdit()) { ?>
<table id="tbl_kp_proyectolist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_proyecto->RowType = ROWTYPE_HEADER;

// Render list options
$kp_proyecto_list->renderListOptions();

// Render list options (header, left)
$kp_proyecto_list->ListOptions->render("header", "left");
?>
<?php if ($kp_proyecto_list->idproyecto->Visible) { // idproyecto ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->idproyecto) == "") { ?>
		<th data-name="idproyecto" class="<?php echo $kp_proyecto_list->idproyecto->headerCellClass() ?>"><div id="elh_kp_proyecto_idproyecto" class="kp_proyecto_idproyecto"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->idproyecto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idproyecto" class="<?php echo $kp_proyecto_list->idproyecto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->idproyecto) ?>', 1);"><div id="elh_kp_proyecto_idproyecto" class="kp_proyecto_idproyecto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->idproyecto->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->idproyecto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->idproyecto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->titulo->Visible) { // titulo ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->titulo) == "") { ?>
		<th data-name="titulo" class="<?php echo $kp_proyecto_list->titulo->headerCellClass() ?>"><div id="elh_kp_proyecto_titulo" class="kp_proyecto_titulo"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->titulo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titulo" class="<?php echo $kp_proyecto_list->titulo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->titulo) ?>', 1);"><div id="elh_kp_proyecto_titulo" class="kp_proyecto_titulo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->titulo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->titulo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->titulo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->nombre->Visible) { // nombre ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->nombre) == "") { ?>
		<th data-name="nombre" class="<?php echo $kp_proyecto_list->nombre->headerCellClass() ?>"><div id="elh_kp_proyecto_nombre" class="kp_proyecto_nombre"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->nombre->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre" class="<?php echo $kp_proyecto_list->nombre->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->nombre) ?>', 1);"><div id="elh_kp_proyecto_nombre" class="kp_proyecto_nombre">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->nombre->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->nombre->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->nombre->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->ubicacion->Visible) { // ubicacion ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->ubicacion) == "") { ?>
		<th data-name="ubicacion" class="<?php echo $kp_proyecto_list->ubicacion->headerCellClass() ?>"><div id="elh_kp_proyecto_ubicacion" class="kp_proyecto_ubicacion"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->ubicacion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ubicacion" class="<?php echo $kp_proyecto_list->ubicacion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->ubicacion) ?>', 1);"><div id="elh_kp_proyecto_ubicacion" class="kp_proyecto_ubicacion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->ubicacion->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->ubicacion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->ubicacion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->cuotas->Visible) { // cuotas ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->cuotas) == "") { ?>
		<th data-name="cuotas" class="<?php echo $kp_proyecto_list->cuotas->headerCellClass() ?>"><div id="elh_kp_proyecto_cuotas" class="kp_proyecto_cuotas"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->cuotas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cuotas" class="<?php echo $kp_proyecto_list->cuotas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->cuotas) ?>', 1);"><div id="elh_kp_proyecto_cuotas" class="kp_proyecto_cuotas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->cuotas->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->cuotas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->cuotas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->foto->Visible) { // foto ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->foto) == "") { ?>
		<th data-name="foto" class="<?php echo $kp_proyecto_list->foto->headerCellClass() ?>"><div id="elh_kp_proyecto_foto" class="kp_proyecto_foto"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->foto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto" class="<?php echo $kp_proyecto_list->foto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->foto) ?>', 1);"><div id="elh_kp_proyecto_foto" class="kp_proyecto_foto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->foto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->foto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->foto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->video->Visible) { // video ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->video) == "") { ?>
		<th data-name="video" class="<?php echo $kp_proyecto_list->video->headerCellClass() ?>"><div id="elh_kp_proyecto_video" class="kp_proyecto_video"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->video->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="video" class="<?php echo $kp_proyecto_list->video->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->video) ?>', 1);"><div id="elh_kp_proyecto_video" class="kp_proyecto_video">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->video->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->video->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->video->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->estado->Visible) { // estado ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $kp_proyecto_list->estado->headerCellClass() ?>"><div id="elh_kp_proyecto_estado" class="kp_proyecto_estado"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $kp_proyecto_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->estado) ?>', 1);"><div id="elh_kp_proyecto_estado" class="kp_proyecto_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->status->Visible) { // status ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->status) == "") { ?>
		<th data-name="status" class="<?php echo $kp_proyecto_list->status->headerCellClass() ?>"><div id="elh_kp_proyecto_status" class="kp_proyecto_status"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $kp_proyecto_list->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->status) ?>', 1);"><div id="elh_kp_proyecto_status" class="kp_proyecto_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->idcategoria->Visible) { // idcategoria ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->idcategoria) == "") { ?>
		<th data-name="idcategoria" class="<?php echo $kp_proyecto_list->idcategoria->headerCellClass() ?>"><div id="elh_kp_proyecto_idcategoria" class="kp_proyecto_idcategoria"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->idcategoria->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idcategoria" class="<?php echo $kp_proyecto_list->idcategoria->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->idcategoria) ?>', 1);"><div id="elh_kp_proyecto_idcategoria" class="kp_proyecto_idcategoria">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->idcategoria->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->idcategoria->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->idcategoria->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->descuento->Visible) { // descuento ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->descuento) == "") { ?>
		<th data-name="descuento" class="<?php echo $kp_proyecto_list->descuento->headerCellClass() ?>"><div id="elh_kp_proyecto_descuento" class="kp_proyecto_descuento"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->descuento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descuento" class="<?php echo $kp_proyecto_list->descuento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->descuento) ?>', 1);"><div id="elh_kp_proyecto_descuento" class="kp_proyecto_descuento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->descuento->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->descuento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->descuento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->precio->Visible) { // precio ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->precio) == "") { ?>
		<th data-name="precio" class="<?php echo $kp_proyecto_list->precio->headerCellClass() ?>"><div id="elh_kp_proyecto_precio" class="kp_proyecto_precio"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->precio->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio" class="<?php echo $kp_proyecto_list->precio->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->precio) ?>', 1);"><div id="elh_kp_proyecto_precio" class="kp_proyecto_precio">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->precio->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->precio->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->precio->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->tipo_entrega->Visible) { // tipo_entrega ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->tipo_entrega) == "") { ?>
		<th data-name="tipo_entrega" class="<?php echo $kp_proyecto_list->tipo_entrega->headerCellClass() ?>"><div id="elh_kp_proyecto_tipo_entrega" class="kp_proyecto_tipo_entrega"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->tipo_entrega->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_entrega" class="<?php echo $kp_proyecto_list->tipo_entrega->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->tipo_entrega) ?>', 1);"><div id="elh_kp_proyecto_tipo_entrega" class="kp_proyecto_tipo_entrega">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->tipo_entrega->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->tipo_entrega->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->tipo_entrega->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->metros_cuadrados->Visible) { // metros_cuadrados ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->metros_cuadrados) == "") { ?>
		<th data-name="metros_cuadrados" class="<?php echo $kp_proyecto_list->metros_cuadrados->headerCellClass() ?>"><div id="elh_kp_proyecto_metros_cuadrados" class="kp_proyecto_metros_cuadrados"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->metros_cuadrados->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="metros_cuadrados" class="<?php echo $kp_proyecto_list->metros_cuadrados->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->metros_cuadrados) ?>', 1);"><div id="elh_kp_proyecto_metros_cuadrados" class="kp_proyecto_metros_cuadrados">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->metros_cuadrados->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->metros_cuadrados->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->metros_cuadrados->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->url->Visible) { // url ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->url) == "") { ?>
		<th data-name="url" class="<?php echo $kp_proyecto_list->url->headerCellClass() ?>"><div id="elh_kp_proyecto_url" class="kp_proyecto_url"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $kp_proyecto_list->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->url) ?>', 1);"><div id="elh_kp_proyecto_url" class="kp_proyecto_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->url->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->url->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_proyecto_list->idempresa->Visible) { // idempresa ?>
	<?php if ($kp_proyecto_list->SortUrl($kp_proyecto_list->idempresa) == "") { ?>
		<th data-name="idempresa" class="<?php echo $kp_proyecto_list->idempresa->headerCellClass() ?>"><div id="elh_kp_proyecto_idempresa" class="kp_proyecto_idempresa"><div class="ew-table-header-caption"><?php echo $kp_proyecto_list->idempresa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idempresa" class="<?php echo $kp_proyecto_list->idempresa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_proyecto_list->SortUrl($kp_proyecto_list->idempresa) ?>', 1);"><div id="elh_kp_proyecto_idempresa" class="kp_proyecto_idempresa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_proyecto_list->idempresa->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_proyecto_list->idempresa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_proyecto_list->idempresa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_proyecto_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_proyecto_list->ExportAll && $kp_proyecto_list->isExport()) {
	$kp_proyecto_list->StopRecord = $kp_proyecto_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_proyecto_list->TotalRecords > $kp_proyecto_list->StartRecord + $kp_proyecto_list->DisplayRecords - 1)
		$kp_proyecto_list->StopRecord = $kp_proyecto_list->StartRecord + $kp_proyecto_list->DisplayRecords - 1;
	else
		$kp_proyecto_list->StopRecord = $kp_proyecto_list->TotalRecords;
}
$kp_proyecto_list->RecordCount = $kp_proyecto_list->StartRecord - 1;
if ($kp_proyecto_list->Recordset && !$kp_proyecto_list->Recordset->EOF) {
	$kp_proyecto_list->Recordset->moveFirst();
	$selectLimit = $kp_proyecto_list->UseSelectLimit;
	if (!$selectLimit && $kp_proyecto_list->StartRecord > 1)
		$kp_proyecto_list->Recordset->move($kp_proyecto_list->StartRecord - 1);
} elseif (!$kp_proyecto->AllowAddDeleteRow && $kp_proyecto_list->StopRecord == 0) {
	$kp_proyecto_list->StopRecord = $kp_proyecto->GridAddRowCount;
}

// Initialize aggregate
$kp_proyecto->RowType = ROWTYPE_AGGREGATEINIT;
$kp_proyecto->resetAttributes();
$kp_proyecto_list->renderRow();
while ($kp_proyecto_list->RecordCount < $kp_proyecto_list->StopRecord) {
	$kp_proyecto_list->RecordCount++;
	if ($kp_proyecto_list->RecordCount >= $kp_proyecto_list->StartRecord) {
		$kp_proyecto_list->RowCount++;

		// Set up key count
		$kp_proyecto_list->KeyCount = $kp_proyecto_list->RowIndex;

		// Init row class and style
		$kp_proyecto->resetAttributes();
		$kp_proyecto->CssClass = "";
		if ($kp_proyecto_list->isGridAdd()) {
		} else {
			$kp_proyecto_list->loadRowValues($kp_proyecto_list->Recordset); // Load row values
		}
		$kp_proyecto->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_proyecto->RowAttrs->merge(["data-rowindex" => $kp_proyecto_list->RowCount, "id" => "r" . $kp_proyecto_list->RowCount . "_kp_proyecto", "data-rowtype" => $kp_proyecto->RowType]);

		// Render row
		$kp_proyecto_list->renderRow();

		// Render list options
		$kp_proyecto_list->renderListOptions();
?>
	<tr <?php echo $kp_proyecto->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_proyecto_list->ListOptions->render("body", "left", $kp_proyecto_list->RowCount);
?>
	<?php if ($kp_proyecto_list->idproyecto->Visible) { // idproyecto ?>
		<td data-name="idproyecto" <?php echo $kp_proyecto_list->idproyecto->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_idproyecto" class="kp_proyecto_idproyecto">
<span<?php echo $kp_proyecto_list->idproyecto->viewAttributes() ?>><?php echo $kp_proyecto_list->idproyecto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->titulo->Visible) { // titulo ?>
		<td data-name="titulo" <?php echo $kp_proyecto_list->titulo->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_titulo" class="kp_proyecto_titulo">
<span<?php echo $kp_proyecto_list->titulo->viewAttributes() ?>><?php echo $kp_proyecto_list->titulo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->nombre->Visible) { // nombre ?>
		<td data-name="nombre" <?php echo $kp_proyecto_list->nombre->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_nombre" class="kp_proyecto_nombre">
<span<?php echo $kp_proyecto_list->nombre->viewAttributes() ?>><?php echo $kp_proyecto_list->nombre->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->ubicacion->Visible) { // ubicacion ?>
		<td data-name="ubicacion" <?php echo $kp_proyecto_list->ubicacion->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_ubicacion" class="kp_proyecto_ubicacion">
<span<?php echo $kp_proyecto_list->ubicacion->viewAttributes() ?>><?php echo $kp_proyecto_list->ubicacion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->cuotas->Visible) { // cuotas ?>
		<td data-name="cuotas" <?php echo $kp_proyecto_list->cuotas->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_cuotas" class="kp_proyecto_cuotas">
<span<?php echo $kp_proyecto_list->cuotas->viewAttributes() ?>><?php echo $kp_proyecto_list->cuotas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->foto->Visible) { // foto ?>
		<td data-name="foto" <?php echo $kp_proyecto_list->foto->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_foto" class="kp_proyecto_foto">
<span<?php echo $kp_proyecto_list->foto->viewAttributes() ?>><?php echo $kp_proyecto_list->foto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->video->Visible) { // video ?>
		<td data-name="video" <?php echo $kp_proyecto_list->video->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_video" class="kp_proyecto_video">
<span<?php echo $kp_proyecto_list->video->viewAttributes() ?>><?php echo $kp_proyecto_list->video->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $kp_proyecto_list->estado->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_estado" class="kp_proyecto_estado">
<span<?php echo $kp_proyecto_list->estado->viewAttributes() ?>><?php echo $kp_proyecto_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->status->Visible) { // status ?>
		<td data-name="status" <?php echo $kp_proyecto_list->status->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_status" class="kp_proyecto_status">
<span<?php echo $kp_proyecto_list->status->viewAttributes() ?>><?php echo $kp_proyecto_list->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->idcategoria->Visible) { // idcategoria ?>
		<td data-name="idcategoria" <?php echo $kp_proyecto_list->idcategoria->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_idcategoria" class="kp_proyecto_idcategoria">
<span<?php echo $kp_proyecto_list->idcategoria->viewAttributes() ?>><?php echo $kp_proyecto_list->idcategoria->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->descuento->Visible) { // descuento ?>
		<td data-name="descuento" <?php echo $kp_proyecto_list->descuento->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_descuento" class="kp_proyecto_descuento">
<span<?php echo $kp_proyecto_list->descuento->viewAttributes() ?>><?php echo $kp_proyecto_list->descuento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->precio->Visible) { // precio ?>
		<td data-name="precio" <?php echo $kp_proyecto_list->precio->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_precio" class="kp_proyecto_precio">
<span<?php echo $kp_proyecto_list->precio->viewAttributes() ?>><?php echo $kp_proyecto_list->precio->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->tipo_entrega->Visible) { // tipo_entrega ?>
		<td data-name="tipo_entrega" <?php echo $kp_proyecto_list->tipo_entrega->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_tipo_entrega" class="kp_proyecto_tipo_entrega">
<span<?php echo $kp_proyecto_list->tipo_entrega->viewAttributes() ?>><?php echo $kp_proyecto_list->tipo_entrega->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->metros_cuadrados->Visible) { // metros_cuadrados ?>
		<td data-name="metros_cuadrados" <?php echo $kp_proyecto_list->metros_cuadrados->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_metros_cuadrados" class="kp_proyecto_metros_cuadrados">
<span<?php echo $kp_proyecto_list->metros_cuadrados->viewAttributes() ?>><?php echo $kp_proyecto_list->metros_cuadrados->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->url->Visible) { // url ?>
		<td data-name="url" <?php echo $kp_proyecto_list->url->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_url" class="kp_proyecto_url">
<span<?php echo $kp_proyecto_list->url->viewAttributes() ?>><?php echo $kp_proyecto_list->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_proyecto_list->idempresa->Visible) { // idempresa ?>
		<td data-name="idempresa" <?php echo $kp_proyecto_list->idempresa->cellAttributes() ?>>
<span id="el<?php echo $kp_proyecto_list->RowCount ?>_kp_proyecto_idempresa" class="kp_proyecto_idempresa">
<span<?php echo $kp_proyecto_list->idempresa->viewAttributes() ?>><?php echo $kp_proyecto_list->idempresa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_proyecto_list->ListOptions->render("body", "right", $kp_proyecto_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_proyecto_list->isGridAdd())
		$kp_proyecto_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_proyecto->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_proyecto_list->Recordset)
	$kp_proyecto_list->Recordset->Close();
?>
<?php if (!$kp_proyecto_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_proyecto_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_proyecto_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_proyecto_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_proyecto_list->TotalRecords == 0 && !$kp_proyecto->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_proyecto_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_proyecto_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_proyecto_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_proyecto_list->terminate();
?>