<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_logs_list = new kp_logs_list();

// Run the page
$kp_logs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_logs_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_logs_list->isExport()) { ?>
<script>
var fkp_logslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_logslist = currentForm = new ew.Form("fkp_logslist", "list");
	fkp_logslist.formKeyCountName = '<?php echo $kp_logs_list->FormKeyCountName ?>';
	loadjs.done("fkp_logslist");
});
var fkp_logslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_logslistsrch = currentSearchForm = new ew.Form("fkp_logslistsrch");

	// Dynamic selection lists
	// Filters

	fkp_logslistsrch.filterList = <?php echo $kp_logs_list->getFilterList() ?>;
	loadjs.done("fkp_logslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_logs_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_logs_list->TotalRecords > 0 && $kp_logs_list->ExportOptions->visible()) { ?>
<?php $kp_logs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_logs_list->ImportOptions->visible()) { ?>
<?php $kp_logs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_logs_list->SearchOptions->visible()) { ?>
<?php $kp_logs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_logs_list->FilterOptions->visible()) { ?>
<?php $kp_logs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_logs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_logs_list->isExport() && !$kp_logs->CurrentAction) { ?>
<form name="fkp_logslistsrch" id="fkp_logslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_logslistsrch-search-panel" class="<?php echo $kp_logs_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_logs">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_logs_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_logs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_logs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_logs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_logs_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_logs_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_logs_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_logs_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_logs_list->showPageHeader(); ?>
<?php
$kp_logs_list->showMessage();
?>
<?php if ($kp_logs_list->TotalRecords > 0 || $kp_logs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_logs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_logs">
<form name="fkp_logslist" id="fkp_logslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_logs">
<div id="gmp_kp_logs" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_logs_list->TotalRecords > 0 || $kp_logs_list->isGridEdit()) { ?>
<table id="tbl_kp_logslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_logs->RowType = ROWTYPE_HEADER;

// Render list options
$kp_logs_list->renderListOptions();

// Render list options (header, left)
$kp_logs_list->ListOptions->render("header", "left");
?>
<?php if ($kp_logs_list->id->Visible) { // id ?>
	<?php if ($kp_logs_list->SortUrl($kp_logs_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $kp_logs_list->id->headerCellClass() ?>"><div id="elh_kp_logs_id" class="kp_logs_id"><div class="ew-table-header-caption"><?php echo $kp_logs_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $kp_logs_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_logs_list->SortUrl($kp_logs_list->id) ?>', 1);"><div id="elh_kp_logs_id" class="kp_logs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_logs_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_logs_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_logs_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_logs_list->tipo->Visible) { // tipo ?>
	<?php if ($kp_logs_list->SortUrl($kp_logs_list->tipo) == "") { ?>
		<th data-name="tipo" class="<?php echo $kp_logs_list->tipo->headerCellClass() ?>"><div id="elh_kp_logs_tipo" class="kp_logs_tipo"><div class="ew-table-header-caption"><?php echo $kp_logs_list->tipo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo" class="<?php echo $kp_logs_list->tipo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_logs_list->SortUrl($kp_logs_list->tipo) ?>', 1);"><div id="elh_kp_logs_tipo" class="kp_logs_tipo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_logs_list->tipo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_logs_list->tipo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_logs_list->tipo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_logs_list->codlogin->Visible) { // codlogin ?>
	<?php if ($kp_logs_list->SortUrl($kp_logs_list->codlogin) == "") { ?>
		<th data-name="codlogin" class="<?php echo $kp_logs_list->codlogin->headerCellClass() ?>"><div id="elh_kp_logs_codlogin" class="kp_logs_codlogin"><div class="ew-table-header-caption"><?php echo $kp_logs_list->codlogin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codlogin" class="<?php echo $kp_logs_list->codlogin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_logs_list->SortUrl($kp_logs_list->codlogin) ?>', 1);"><div id="elh_kp_logs_codlogin" class="kp_logs_codlogin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_logs_list->codlogin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_logs_list->codlogin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_logs_list->codlogin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_logs_list->ip->Visible) { // ip ?>
	<?php if ($kp_logs_list->SortUrl($kp_logs_list->ip) == "") { ?>
		<th data-name="ip" class="<?php echo $kp_logs_list->ip->headerCellClass() ?>"><div id="elh_kp_logs_ip" class="kp_logs_ip"><div class="ew-table-header-caption"><?php echo $kp_logs_list->ip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ip" class="<?php echo $kp_logs_list->ip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_logs_list->SortUrl($kp_logs_list->ip) ?>', 1);"><div id="elh_kp_logs_ip" class="kp_logs_ip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_logs_list->ip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_logs_list->ip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_logs_list->ip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_logs_list->alerta->Visible) { // alerta ?>
	<?php if ($kp_logs_list->SortUrl($kp_logs_list->alerta) == "") { ?>
		<th data-name="alerta" class="<?php echo $kp_logs_list->alerta->headerCellClass() ?>"><div id="elh_kp_logs_alerta" class="kp_logs_alerta"><div class="ew-table-header-caption"><?php echo $kp_logs_list->alerta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="alerta" class="<?php echo $kp_logs_list->alerta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_logs_list->SortUrl($kp_logs_list->alerta) ?>', 1);"><div id="elh_kp_logs_alerta" class="kp_logs_alerta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_logs_list->alerta->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_logs_list->alerta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_logs_list->alerta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_logs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_logs_list->ExportAll && $kp_logs_list->isExport()) {
	$kp_logs_list->StopRecord = $kp_logs_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_logs_list->TotalRecords > $kp_logs_list->StartRecord + $kp_logs_list->DisplayRecords - 1)
		$kp_logs_list->StopRecord = $kp_logs_list->StartRecord + $kp_logs_list->DisplayRecords - 1;
	else
		$kp_logs_list->StopRecord = $kp_logs_list->TotalRecords;
}
$kp_logs_list->RecordCount = $kp_logs_list->StartRecord - 1;
if ($kp_logs_list->Recordset && !$kp_logs_list->Recordset->EOF) {
	$kp_logs_list->Recordset->moveFirst();
	$selectLimit = $kp_logs_list->UseSelectLimit;
	if (!$selectLimit && $kp_logs_list->StartRecord > 1)
		$kp_logs_list->Recordset->move($kp_logs_list->StartRecord - 1);
} elseif (!$kp_logs->AllowAddDeleteRow && $kp_logs_list->StopRecord == 0) {
	$kp_logs_list->StopRecord = $kp_logs->GridAddRowCount;
}

// Initialize aggregate
$kp_logs->RowType = ROWTYPE_AGGREGATEINIT;
$kp_logs->resetAttributes();
$kp_logs_list->renderRow();
while ($kp_logs_list->RecordCount < $kp_logs_list->StopRecord) {
	$kp_logs_list->RecordCount++;
	if ($kp_logs_list->RecordCount >= $kp_logs_list->StartRecord) {
		$kp_logs_list->RowCount++;

		// Set up key count
		$kp_logs_list->KeyCount = $kp_logs_list->RowIndex;

		// Init row class and style
		$kp_logs->resetAttributes();
		$kp_logs->CssClass = "";
		if ($kp_logs_list->isGridAdd()) {
		} else {
			$kp_logs_list->loadRowValues($kp_logs_list->Recordset); // Load row values
		}
		$kp_logs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_logs->RowAttrs->merge(["data-rowindex" => $kp_logs_list->RowCount, "id" => "r" . $kp_logs_list->RowCount . "_kp_logs", "data-rowtype" => $kp_logs->RowType]);

		// Render row
		$kp_logs_list->renderRow();

		// Render list options
		$kp_logs_list->renderListOptions();
?>
	<tr <?php echo $kp_logs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_logs_list->ListOptions->render("body", "left", $kp_logs_list->RowCount);
?>
	<?php if ($kp_logs_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $kp_logs_list->id->cellAttributes() ?>>
<span id="el<?php echo $kp_logs_list->RowCount ?>_kp_logs_id" class="kp_logs_id">
<span<?php echo $kp_logs_list->id->viewAttributes() ?>><?php echo $kp_logs_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_logs_list->tipo->Visible) { // tipo ?>
		<td data-name="tipo" <?php echo $kp_logs_list->tipo->cellAttributes() ?>>
<span id="el<?php echo $kp_logs_list->RowCount ?>_kp_logs_tipo" class="kp_logs_tipo">
<span<?php echo $kp_logs_list->tipo->viewAttributes() ?>><?php echo $kp_logs_list->tipo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_logs_list->codlogin->Visible) { // codlogin ?>
		<td data-name="codlogin" <?php echo $kp_logs_list->codlogin->cellAttributes() ?>>
<span id="el<?php echo $kp_logs_list->RowCount ?>_kp_logs_codlogin" class="kp_logs_codlogin">
<span<?php echo $kp_logs_list->codlogin->viewAttributes() ?>><?php echo $kp_logs_list->codlogin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_logs_list->ip->Visible) { // ip ?>
		<td data-name="ip" <?php echo $kp_logs_list->ip->cellAttributes() ?>>
<span id="el<?php echo $kp_logs_list->RowCount ?>_kp_logs_ip" class="kp_logs_ip">
<span<?php echo $kp_logs_list->ip->viewAttributes() ?>><?php echo $kp_logs_list->ip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_logs_list->alerta->Visible) { // alerta ?>
		<td data-name="alerta" <?php echo $kp_logs_list->alerta->cellAttributes() ?>>
<span id="el<?php echo $kp_logs_list->RowCount ?>_kp_logs_alerta" class="kp_logs_alerta">
<span<?php echo $kp_logs_list->alerta->viewAttributes() ?>><div class="custom-control custom-checkbox d-inline-block"><input type="checkbox" id="x_alerta" class="custom-control-input" value="<?php echo $kp_logs_list->alerta->getViewValue() ?>" disabled<?php if (ConvertToBool($kp_logs_list->alerta->CurrentValue)) { ?> checked<?php } ?>><label class="custom-control-label" for="x_alerta"></label></div></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_logs_list->ListOptions->render("body", "right", $kp_logs_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_logs_list->isGridAdd())
		$kp_logs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_logs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_logs_list->Recordset)
	$kp_logs_list->Recordset->Close();
?>
<?php if (!$kp_logs_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_logs_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_logs_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_logs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_logs_list->TotalRecords == 0 && !$kp_logs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_logs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_logs_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_logs_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_logs_list->terminate();
?>