<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cuota_view = new cuota_view();

// Run the page
$cuota_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cuota_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$cuota_view->isExport()) { ?>
<script>
var fcuotaview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fcuotaview = currentForm = new ew.Form("fcuotaview", "view");
	loadjs.done("fcuotaview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$cuota_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $cuota_view->ExportOptions->render("body") ?>
<?php $cuota_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $cuota_view->showPageHeader(); ?>
<?php
$cuota_view->showMessage();
?>
<form name="fcuotaview" id="fcuotaview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cuota">
<input type="hidden" name="modal" value="<?php echo (int)$cuota_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($cuota_view->id_cuota->Visible) { // id_cuota ?>
	<tr id="r_id_cuota">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_id_cuota"><?php echo $cuota_view->id_cuota->caption() ?></span></td>
		<td data-name="id_cuota" <?php echo $cuota_view->id_cuota->cellAttributes() ?>>
<span id="el_cuota_id_cuota">
<span<?php echo $cuota_view->id_cuota->viewAttributes() ?>><?php echo $cuota_view->id_cuota->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->id_producto->Visible) { // id_producto ?>
	<tr id="r_id_producto">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_id_producto"><?php echo $cuota_view->id_producto->caption() ?></span></td>
		<td data-name="id_producto" <?php echo $cuota_view->id_producto->cellAttributes() ?>>
<span id="el_cuota_id_producto">
<span<?php echo $cuota_view->id_producto->viewAttributes() ?>><?php echo $cuota_view->id_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->interes->Visible) { // interes ?>
	<tr id="r_interes">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_interes"><?php echo $cuota_view->interes->caption() ?></span></td>
		<td data-name="interes" <?php echo $cuota_view->interes->cellAttributes() ?>>
<span id="el_cuota_interes">
<span<?php echo $cuota_view->interes->viewAttributes() ?>><?php echo $cuota_view->interes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->plazo_meses->Visible) { // plazo_meses ?>
	<tr id="r_plazo_meses">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_plazo_meses"><?php echo $cuota_view->plazo_meses->caption() ?></span></td>
		<td data-name="plazo_meses" <?php echo $cuota_view->plazo_meses->cellAttributes() ?>>
<span id="el_cuota_plazo_meses">
<span<?php echo $cuota_view->plazo_meses->viewAttributes() ?>><?php echo $cuota_view->plazo_meses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->monto->Visible) { // monto ?>
	<tr id="r_monto">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_monto"><?php echo $cuota_view->monto->caption() ?></span></td>
		<td data-name="monto" <?php echo $cuota_view->monto->cellAttributes() ?>>
<span id="el_cuota_monto">
<span<?php echo $cuota_view->monto->viewAttributes() ?>><?php echo $cuota_view->monto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->pagar_mensual->Visible) { // pagar_mensual ?>
	<tr id="r_pagar_mensual">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_pagar_mensual"><?php echo $cuota_view->pagar_mensual->caption() ?></span></td>
		<td data-name="pagar_mensual" <?php echo $cuota_view->pagar_mensual->cellAttributes() ?>>
<span id="el_cuota_pagar_mensual">
<span<?php echo $cuota_view->pagar_mensual->viewAttributes() ?>><?php echo $cuota_view->pagar_mensual->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cuota_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $cuota_view->TableLeftColumnClass ?>"><span id="elh_cuota_estado"><?php echo $cuota_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $cuota_view->estado->cellAttributes() ?>>
<span id="el_cuota_estado">
<span<?php echo $cuota_view->estado->viewAttributes() ?>><?php echo $cuota_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$cuota_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$cuota_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$cuota_view->terminate();
?>