<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courses_view = new courses_view();

// Run the page
$courses_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courses_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$courses_view->isExport()) { ?>
<script>
var fcoursesview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fcoursesview = currentForm = new ew.Form("fcoursesview", "view");
	loadjs.done("fcoursesview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$courses_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $courses_view->ExportOptions->render("body") ?>
<?php $courses_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $courses_view->showPageHeader(); ?>
<?php
$courses_view->showMessage();
?>
<form name="fcoursesview" id="fcoursesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courses">
<input type="hidden" name="modal" value="<?php echo (int)$courses_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($courses_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_id"><?php echo $courses_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $courses_view->id->cellAttributes() ?>>
<span id="el_courses_id">
<span<?php echo $courses_view->id->viewAttributes() ?>><?php echo $courses_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->time->Visible) { // time ?>
	<tr id="r_time">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_time"><?php echo $courses_view->time->caption() ?></span></td>
		<td data-name="time" <?php echo $courses_view->time->cellAttributes() ?>>
<span id="el_courses_time">
<span<?php echo $courses_view->time->viewAttributes() ?>><?php echo $courses_view->time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->courses_name->Visible) { // courses_name ?>
	<tr id="r_courses_name">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_courses_name"><?php echo $courses_view->courses_name->caption() ?></span></td>
		<td data-name="courses_name" <?php echo $courses_view->courses_name->cellAttributes() ?>>
<span id="el_courses_courses_name">
<span<?php echo $courses_view->courses_name->viewAttributes() ?>><?php echo $courses_view->courses_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_description"><?php echo $courses_view->description->caption() ?></span></td>
		<td data-name="description" <?php echo $courses_view->description->cellAttributes() ?>>
<span id="el_courses_description">
<span<?php echo $courses_view->description->viewAttributes() ?>><?php echo $courses_view->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->courses_name_in->Visible) { // courses_name_in ?>
	<tr id="r_courses_name_in">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_courses_name_in"><?php echo $courses_view->courses_name_in->caption() ?></span></td>
		<td data-name="courses_name_in" <?php echo $courses_view->courses_name_in->cellAttributes() ?>>
<span id="el_courses_courses_name_in">
<span<?php echo $courses_view->courses_name_in->viewAttributes() ?>><?php echo $courses_view->courses_name_in->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->description_in->Visible) { // description_in ?>
	<tr id="r_description_in">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_description_in"><?php echo $courses_view->description_in->caption() ?></span></td>
		<td data-name="description_in" <?php echo $courses_view->description_in->cellAttributes() ?>>
<span id="el_courses_description_in">
<span<?php echo $courses_view->description_in->viewAttributes() ?>><?php echo $courses_view->description_in->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courses_view->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $courses_view->TableLeftColumnClass ?>"><span id="elh_courses_image"><?php echo $courses_view->image->caption() ?></span></td>
		<td data-name="image" <?php echo $courses_view->image->cellAttributes() ?>>
<span id="el_courses_image">
<span<?php echo $courses_view->image->viewAttributes() ?>><?php echo $courses_view->image->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$courses_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$courses_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$courses_view->terminate();
?>