<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class procesos_nuevo_add extends procesos_nuevo
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'procesos_nuevo';

	// Page object name
	public $PageObjName = "procesos_nuevo_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (procesos_nuevo)
		if (!isset($GLOBALS["procesos_nuevo"]) || get_class($GLOBALS["procesos_nuevo"]) == PROJECT_NAMESPACE . "procesos_nuevo") {
			$GLOBALS["procesos_nuevo"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["procesos_nuevo"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'procesos_nuevo');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $procesos_nuevo;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($procesos_nuevo);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "procesos_nuevoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['codigo'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->codigo->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("procesos_nuevolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->codigo->Visible = FALSE;
		$this->codigo_proceso->setVisibility();
		$this->no->setVisibility();
		$this->usuarios->setVisibility();
		$this->SEC_EJEC->setVisibility();
		$this->TIPO_MODALIDAD->setVisibility();
		$this->SECUENCIA->setVisibility();
		$this->AMBIENTE->setVisibility();
		$this->RUC_ENTIDAD->setVisibility();
		$this->LOCAL->setVisibility();
		$this->DEPARTAMENTO->setVisibility();
		$this->PROVINCIA->setVisibility();
		$this->DISTRITO->setVisibility();
		$this->AREA->setVisibility();
		$this->OFICINA->setVisibility();
		$this->PISO_OFICINA->setVisibility();
		$this->NRO_DOC_IDENT_PERSONAL->setVisibility();
		$this->APELLIDO_PATERNO->setVisibility();
		$this->APELLIDO_MATERNO->setVisibility();
		$this->NOMBRES->setVisibility();
		$this->OPERATIVO->setVisibility();
		$this->TIPO_DOC_IDENTIDAD->setVisibility();
		$this->MODALIDAD_CONTRATO->setVisibility();
		$this->CODIGO_PATRIMONIAL->setVisibility();
		$this->DENOMINACION_BIEN->setVisibility();
		$this->TIPO_CAUSAL_ALTA->setVisibility();
		$this->NRO_DOC_ADQUISICION->setVisibility();
		$this->FECHA_ADQUISICION->setVisibility();
		$this->VALOR_ADQUISICION->setVisibility();
		$this->FECHA_DEPRECIACION->setVisibility();
		$this->VALOR_DEPREC_EJERCICIO->setVisibility();
		$this->VALOR_DEPREC_ACUMULADO->setVisibility();
		$this->VALOR_NETO->setVisibility();
		$this->TIP_USO_CUENTA->setVisibility();
		$this->TIPO_CUENTA->setVisibility();
		$this->NRO_CUENTA_CONTABLE->setVisibility();
		$this->CTA_CON_SEGURO->setVisibility();
		$this->ESTADO_BIEN->setVisibility();
		$this->CONDICION->setVisibility();
		$this->MARCA->setVisibility();
		$this->MODELO->setVisibility();
		$this->TIPO->setVisibility();
		$this->COLOR->setVisibility();
		$this->SERIE->setVisibility();
		$this->DIMENSION->setVisibility();
		$this->PLACA->setVisibility();
		$this->NRO_MOTOR->setVisibility();
		$this->NRO_CHASIS->setVisibility();
		$this->MATRICULA->setVisibility();
		$this->ANIO_FABRICACION->setVisibility();
		$this->LONGITUD->setVisibility();
		$this->ALTURA->setVisibility();
		$this->ANCHO->setVisibility();
		$this->RAZA->setVisibility();
		$this->ESPECIE->setVisibility();
		$this->EDAD->setVisibility();
		$this->PAIS->setVisibility();
		$this->OTRAS_CARACT->setVisibility();
		$this->DESCRIPCION_UBICACION_BIEN->setVisibility();
		$this->CAUSAL_BAJA->setVisibility();
		$this->NRO_RESOLUCION_BAJA->setVisibility();
		$this->FECHA_BAJA->setVisibility();
		$this->ACTO_DISPOSICION_BIEN->setVisibility();
		$this->NRO_RESOLUCION_DISP->setVisibility();
		$this->FECHA_DISPOSICION->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setVisibility();
		$this->MOTIVO_ELIMINACION_BIEN->setVisibility();
		$this->ACTO_ADMINISTRACION_BIEN->setVisibility();
		$this->NUM_RESOLUCION_ADMINISTRACION->setVisibility();
		$this->FECHA_ADMINISTRACION->setVisibility();
		$this->FECHA_VENC_ACTO_ADMIN->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setVisibility();
		$this->DOC_ALTA_SBN->setVisibility();
		$this->DOC_BAJA_SBN->setVisibility();
		$this->DEPENDENCIAS->setVisibility();
		$this->NUMERO_FICHA->setVisibility();
		$this->CODIGO_INTERNO->setVisibility();
		$this->ESTADO->setVisibility();
		$this->USO->setVisibility();
		$this->STICKER->setVisibility();
		$this->SEDE->setVisibility();
		$this->SBN->setVisibility();
		$this->ETIQUETA->setVisibility();
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setVisibility();
		$this->PLACA_RODAJE->setVisibility();
		$this->CODIGO_ACTUAL->setVisibility();
		$this->CODIGO_ANTERIOR->setVisibility();
		$this->PROPIEDAD->setVisibility();
		$this->SITUACION->setVisibility();
		$this->OBSERVACIONES->setVisibility();
		$this->FECHA_REGISTRO->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("codigo") !== NULL) {
				$this->codigo->setQueryStringValue(Get("codigo"));
				$this->setKey("codigo", $this->codigo->CurrentValue); // Set up key
			} else {
				$this->setKey("codigo", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("procesos_nuevolist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "procesos_nuevolist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "procesos_nuevoview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->codigo->CurrentValue = NULL;
		$this->codigo->OldValue = $this->codigo->CurrentValue;
		$this->codigo_proceso->CurrentValue = NULL;
		$this->codigo_proceso->OldValue = $this->codigo_proceso->CurrentValue;
		$this->no->CurrentValue = NULL;
		$this->no->OldValue = $this->no->CurrentValue;
		$this->usuarios->CurrentValue = NULL;
		$this->usuarios->OldValue = $this->usuarios->CurrentValue;
		$this->SEC_EJEC->CurrentValue = NULL;
		$this->SEC_EJEC->OldValue = $this->SEC_EJEC->CurrentValue;
		$this->TIPO_MODALIDAD->CurrentValue = NULL;
		$this->TIPO_MODALIDAD->OldValue = $this->TIPO_MODALIDAD->CurrentValue;
		$this->SECUENCIA->CurrentValue = NULL;
		$this->SECUENCIA->OldValue = $this->SECUENCIA->CurrentValue;
		$this->AMBIENTE->CurrentValue = NULL;
		$this->AMBIENTE->OldValue = $this->AMBIENTE->CurrentValue;
		$this->RUC_ENTIDAD->CurrentValue = NULL;
		$this->RUC_ENTIDAD->OldValue = $this->RUC_ENTIDAD->CurrentValue;
		$this->LOCAL->CurrentValue = NULL;
		$this->LOCAL->OldValue = $this->LOCAL->CurrentValue;
		$this->DEPARTAMENTO->CurrentValue = NULL;
		$this->DEPARTAMENTO->OldValue = $this->DEPARTAMENTO->CurrentValue;
		$this->PROVINCIA->CurrentValue = NULL;
		$this->PROVINCIA->OldValue = $this->PROVINCIA->CurrentValue;
		$this->DISTRITO->CurrentValue = NULL;
		$this->DISTRITO->OldValue = $this->DISTRITO->CurrentValue;
		$this->AREA->CurrentValue = NULL;
		$this->AREA->OldValue = $this->AREA->CurrentValue;
		$this->OFICINA->CurrentValue = NULL;
		$this->OFICINA->OldValue = $this->OFICINA->CurrentValue;
		$this->PISO_OFICINA->CurrentValue = NULL;
		$this->PISO_OFICINA->OldValue = $this->PISO_OFICINA->CurrentValue;
		$this->NRO_DOC_IDENT_PERSONAL->CurrentValue = NULL;
		$this->NRO_DOC_IDENT_PERSONAL->OldValue = $this->NRO_DOC_IDENT_PERSONAL->CurrentValue;
		$this->APELLIDO_PATERNO->CurrentValue = NULL;
		$this->APELLIDO_PATERNO->OldValue = $this->APELLIDO_PATERNO->CurrentValue;
		$this->APELLIDO_MATERNO->CurrentValue = NULL;
		$this->APELLIDO_MATERNO->OldValue = $this->APELLIDO_MATERNO->CurrentValue;
		$this->NOMBRES->CurrentValue = NULL;
		$this->NOMBRES->OldValue = $this->NOMBRES->CurrentValue;
		$this->OPERATIVO->CurrentValue = NULL;
		$this->OPERATIVO->OldValue = $this->OPERATIVO->CurrentValue;
		$this->TIPO_DOC_IDENTIDAD->CurrentValue = NULL;
		$this->TIPO_DOC_IDENTIDAD->OldValue = $this->TIPO_DOC_IDENTIDAD->CurrentValue;
		$this->MODALIDAD_CONTRATO->CurrentValue = NULL;
		$this->MODALIDAD_CONTRATO->OldValue = $this->MODALIDAD_CONTRATO->CurrentValue;
		$this->CODIGO_PATRIMONIAL->CurrentValue = NULL;
		$this->CODIGO_PATRIMONIAL->OldValue = $this->CODIGO_PATRIMONIAL->CurrentValue;
		$this->DENOMINACION_BIEN->CurrentValue = NULL;
		$this->DENOMINACION_BIEN->OldValue = $this->DENOMINACION_BIEN->CurrentValue;
		$this->TIPO_CAUSAL_ALTA->CurrentValue = NULL;
		$this->TIPO_CAUSAL_ALTA->OldValue = $this->TIPO_CAUSAL_ALTA->CurrentValue;
		$this->NRO_DOC_ADQUISICION->CurrentValue = NULL;
		$this->NRO_DOC_ADQUISICION->OldValue = $this->NRO_DOC_ADQUISICION->CurrentValue;
		$this->FECHA_ADQUISICION->CurrentValue = NULL;
		$this->FECHA_ADQUISICION->OldValue = $this->FECHA_ADQUISICION->CurrentValue;
		$this->VALOR_ADQUISICION->CurrentValue = NULL;
		$this->VALOR_ADQUISICION->OldValue = $this->VALOR_ADQUISICION->CurrentValue;
		$this->FECHA_DEPRECIACION->CurrentValue = NULL;
		$this->FECHA_DEPRECIACION->OldValue = $this->FECHA_DEPRECIACION->CurrentValue;
		$this->VALOR_DEPREC_EJERCICIO->CurrentValue = NULL;
		$this->VALOR_DEPREC_EJERCICIO->OldValue = $this->VALOR_DEPREC_EJERCICIO->CurrentValue;
		$this->VALOR_DEPREC_ACUMULADO->CurrentValue = NULL;
		$this->VALOR_DEPREC_ACUMULADO->OldValue = $this->VALOR_DEPREC_ACUMULADO->CurrentValue;
		$this->VALOR_NETO->CurrentValue = NULL;
		$this->VALOR_NETO->OldValue = $this->VALOR_NETO->CurrentValue;
		$this->TIP_USO_CUENTA->CurrentValue = NULL;
		$this->TIP_USO_CUENTA->OldValue = $this->TIP_USO_CUENTA->CurrentValue;
		$this->TIPO_CUENTA->CurrentValue = NULL;
		$this->TIPO_CUENTA->OldValue = $this->TIPO_CUENTA->CurrentValue;
		$this->NRO_CUENTA_CONTABLE->CurrentValue = NULL;
		$this->NRO_CUENTA_CONTABLE->OldValue = $this->NRO_CUENTA_CONTABLE->CurrentValue;
		$this->CTA_CON_SEGURO->CurrentValue = NULL;
		$this->CTA_CON_SEGURO->OldValue = $this->CTA_CON_SEGURO->CurrentValue;
		$this->ESTADO_BIEN->CurrentValue = NULL;
		$this->ESTADO_BIEN->OldValue = $this->ESTADO_BIEN->CurrentValue;
		$this->CONDICION->CurrentValue = NULL;
		$this->CONDICION->OldValue = $this->CONDICION->CurrentValue;
		$this->MARCA->CurrentValue = NULL;
		$this->MARCA->OldValue = $this->MARCA->CurrentValue;
		$this->MODELO->CurrentValue = NULL;
		$this->MODELO->OldValue = $this->MODELO->CurrentValue;
		$this->TIPO->CurrentValue = NULL;
		$this->TIPO->OldValue = $this->TIPO->CurrentValue;
		$this->COLOR->CurrentValue = NULL;
		$this->COLOR->OldValue = $this->COLOR->CurrentValue;
		$this->SERIE->CurrentValue = NULL;
		$this->SERIE->OldValue = $this->SERIE->CurrentValue;
		$this->DIMENSION->CurrentValue = NULL;
		$this->DIMENSION->OldValue = $this->DIMENSION->CurrentValue;
		$this->PLACA->CurrentValue = NULL;
		$this->PLACA->OldValue = $this->PLACA->CurrentValue;
		$this->NRO_MOTOR->CurrentValue = NULL;
		$this->NRO_MOTOR->OldValue = $this->NRO_MOTOR->CurrentValue;
		$this->NRO_CHASIS->CurrentValue = NULL;
		$this->NRO_CHASIS->OldValue = $this->NRO_CHASIS->CurrentValue;
		$this->MATRICULA->CurrentValue = NULL;
		$this->MATRICULA->OldValue = $this->MATRICULA->CurrentValue;
		$this->ANIO_FABRICACION->CurrentValue = NULL;
		$this->ANIO_FABRICACION->OldValue = $this->ANIO_FABRICACION->CurrentValue;
		$this->LONGITUD->CurrentValue = NULL;
		$this->LONGITUD->OldValue = $this->LONGITUD->CurrentValue;
		$this->ALTURA->CurrentValue = NULL;
		$this->ALTURA->OldValue = $this->ALTURA->CurrentValue;
		$this->ANCHO->CurrentValue = NULL;
		$this->ANCHO->OldValue = $this->ANCHO->CurrentValue;
		$this->RAZA->CurrentValue = NULL;
		$this->RAZA->OldValue = $this->RAZA->CurrentValue;
		$this->ESPECIE->CurrentValue = NULL;
		$this->ESPECIE->OldValue = $this->ESPECIE->CurrentValue;
		$this->EDAD->CurrentValue = NULL;
		$this->EDAD->OldValue = $this->EDAD->CurrentValue;
		$this->PAIS->CurrentValue = NULL;
		$this->PAIS->OldValue = $this->PAIS->CurrentValue;
		$this->OTRAS_CARACT->CurrentValue = NULL;
		$this->OTRAS_CARACT->OldValue = $this->OTRAS_CARACT->CurrentValue;
		$this->DESCRIPCION_UBICACION_BIEN->CurrentValue = NULL;
		$this->DESCRIPCION_UBICACION_BIEN->OldValue = $this->DESCRIPCION_UBICACION_BIEN->CurrentValue;
		$this->CAUSAL_BAJA->CurrentValue = NULL;
		$this->CAUSAL_BAJA->OldValue = $this->CAUSAL_BAJA->CurrentValue;
		$this->NRO_RESOLUCION_BAJA->CurrentValue = NULL;
		$this->NRO_RESOLUCION_BAJA->OldValue = $this->NRO_RESOLUCION_BAJA->CurrentValue;
		$this->FECHA_BAJA->CurrentValue = NULL;
		$this->FECHA_BAJA->OldValue = $this->FECHA_BAJA->CurrentValue;
		$this->ACTO_DISPOSICION_BIEN->CurrentValue = NULL;
		$this->ACTO_DISPOSICION_BIEN->OldValue = $this->ACTO_DISPOSICION_BIEN->CurrentValue;
		$this->NRO_RESOLUCION_DISP->CurrentValue = NULL;
		$this->NRO_RESOLUCION_DISP->OldValue = $this->NRO_RESOLUCION_DISP->CurrentValue;
		$this->FECHA_DISPOSICION->CurrentValue = NULL;
		$this->FECHA_DISPOSICION->OldValue = $this->FECHA_DISPOSICION->CurrentValue;
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue = NULL;
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->OldValue = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue;
		$this->MOTIVO_ELIMINACION_BIEN->CurrentValue = NULL;
		$this->MOTIVO_ELIMINACION_BIEN->OldValue = $this->MOTIVO_ELIMINACION_BIEN->CurrentValue;
		$this->ACTO_ADMINISTRACION_BIEN->CurrentValue = NULL;
		$this->ACTO_ADMINISTRACION_BIEN->OldValue = $this->ACTO_ADMINISTRACION_BIEN->CurrentValue;
		$this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue = NULL;
		$this->NUM_RESOLUCION_ADMINISTRACION->OldValue = $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue;
		$this->FECHA_ADMINISTRACION->CurrentValue = NULL;
		$this->FECHA_ADMINISTRACION->OldValue = $this->FECHA_ADMINISTRACION->CurrentValue;
		$this->FECHA_VENC_ACTO_ADMIN->CurrentValue = NULL;
		$this->FECHA_VENC_ACTO_ADMIN->OldValue = $this->FECHA_VENC_ACTO_ADMIN->CurrentValue;
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue = NULL;
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->OldValue = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue;
		$this->DOC_ALTA_SBN->CurrentValue = NULL;
		$this->DOC_ALTA_SBN->OldValue = $this->DOC_ALTA_SBN->CurrentValue;
		$this->DOC_BAJA_SBN->CurrentValue = NULL;
		$this->DOC_BAJA_SBN->OldValue = $this->DOC_BAJA_SBN->CurrentValue;
		$this->DEPENDENCIAS->CurrentValue = NULL;
		$this->DEPENDENCIAS->OldValue = $this->DEPENDENCIAS->CurrentValue;
		$this->NUMERO_FICHA->CurrentValue = NULL;
		$this->NUMERO_FICHA->OldValue = $this->NUMERO_FICHA->CurrentValue;
		$this->CODIGO_INTERNO->CurrentValue = NULL;
		$this->CODIGO_INTERNO->OldValue = $this->CODIGO_INTERNO->CurrentValue;
		$this->ESTADO->CurrentValue = "0";
		$this->USO->CurrentValue = NULL;
		$this->USO->OldValue = $this->USO->CurrentValue;
		$this->STICKER->CurrentValue = NULL;
		$this->STICKER->OldValue = $this->STICKER->CurrentValue;
		$this->SEDE->CurrentValue = NULL;
		$this->SEDE->OldValue = $this->SEDE->CurrentValue;
		$this->SBN->CurrentValue = NULL;
		$this->SBN->OldValue = $this->SBN->CurrentValue;
		$this->ETIQUETA->CurrentValue = NULL;
		$this->ETIQUETA->OldValue = $this->ETIQUETA->CurrentValue;
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue = NULL;
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->OldValue = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue;
		$this->PLACA_RODAJE->CurrentValue = NULL;
		$this->PLACA_RODAJE->OldValue = $this->PLACA_RODAJE->CurrentValue;
		$this->CODIGO_ACTUAL->CurrentValue = NULL;
		$this->CODIGO_ACTUAL->OldValue = $this->CODIGO_ACTUAL->CurrentValue;
		$this->CODIGO_ANTERIOR->CurrentValue = NULL;
		$this->CODIGO_ANTERIOR->OldValue = $this->CODIGO_ANTERIOR->CurrentValue;
		$this->PROPIEDAD->CurrentValue = NULL;
		$this->PROPIEDAD->OldValue = $this->PROPIEDAD->CurrentValue;
		$this->SITUACION->CurrentValue = NULL;
		$this->SITUACION->OldValue = $this->SITUACION->CurrentValue;
		$this->OBSERVACIONES->CurrentValue = NULL;
		$this->OBSERVACIONES->OldValue = $this->OBSERVACIONES->CurrentValue;
		$this->FECHA_REGISTRO->CurrentValue = NULL;
		$this->FECHA_REGISTRO->OldValue = $this->FECHA_REGISTRO->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'codigo_proceso' first before field var 'x_codigo_proceso'
		$val = $CurrentForm->hasValue("codigo_proceso") ? $CurrentForm->getValue("codigo_proceso") : $CurrentForm->getValue("x_codigo_proceso");
		if (!$this->codigo_proceso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codigo_proceso->Visible = FALSE; // Disable update for API request
			else
				$this->codigo_proceso->setFormValue($val);
		}

		// Check field name 'no' first before field var 'x_no'
		$val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
		if (!$this->no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no->Visible = FALSE; // Disable update for API request
			else
				$this->no->setFormValue($val);
		}

		// Check field name 'usuarios' first before field var 'x_usuarios'
		$val = $CurrentForm->hasValue("usuarios") ? $CurrentForm->getValue("usuarios") : $CurrentForm->getValue("x_usuarios");
		if (!$this->usuarios->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->usuarios->Visible = FALSE; // Disable update for API request
			else
				$this->usuarios->setFormValue($val);
		}

		// Check field name 'SEC_EJEC' first before field var 'x_SEC_EJEC'
		$val = $CurrentForm->hasValue("SEC_EJEC") ? $CurrentForm->getValue("SEC_EJEC") : $CurrentForm->getValue("x_SEC_EJEC");
		if (!$this->SEC_EJEC->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SEC_EJEC->Visible = FALSE; // Disable update for API request
			else
				$this->SEC_EJEC->setFormValue($val);
		}

		// Check field name 'TIPO_MODALIDAD' first before field var 'x_TIPO_MODALIDAD'
		$val = $CurrentForm->hasValue("TIPO_MODALIDAD") ? $CurrentForm->getValue("TIPO_MODALIDAD") : $CurrentForm->getValue("x_TIPO_MODALIDAD");
		if (!$this->TIPO_MODALIDAD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIPO_MODALIDAD->Visible = FALSE; // Disable update for API request
			else
				$this->TIPO_MODALIDAD->setFormValue($val);
		}

		// Check field name 'SECUENCIA' first before field var 'x_SECUENCIA'
		$val = $CurrentForm->hasValue("SECUENCIA") ? $CurrentForm->getValue("SECUENCIA") : $CurrentForm->getValue("x_SECUENCIA");
		if (!$this->SECUENCIA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SECUENCIA->Visible = FALSE; // Disable update for API request
			else
				$this->SECUENCIA->setFormValue($val);
		}

		// Check field name 'AMBIENTE' first before field var 'x_AMBIENTE'
		$val = $CurrentForm->hasValue("AMBIENTE") ? $CurrentForm->getValue("AMBIENTE") : $CurrentForm->getValue("x_AMBIENTE");
		if (!$this->AMBIENTE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->AMBIENTE->Visible = FALSE; // Disable update for API request
			else
				$this->AMBIENTE->setFormValue($val);
		}

		// Check field name 'RUC_ENTIDAD' first before field var 'x_RUC_ENTIDAD'
		$val = $CurrentForm->hasValue("RUC_ENTIDAD") ? $CurrentForm->getValue("RUC_ENTIDAD") : $CurrentForm->getValue("x_RUC_ENTIDAD");
		if (!$this->RUC_ENTIDAD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->RUC_ENTIDAD->Visible = FALSE; // Disable update for API request
			else
				$this->RUC_ENTIDAD->setFormValue($val);
		}

		// Check field name 'LOCAL' first before field var 'x_LOCAL'
		$val = $CurrentForm->hasValue("LOCAL") ? $CurrentForm->getValue("LOCAL") : $CurrentForm->getValue("x_LOCAL");
		if (!$this->LOCAL->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LOCAL->Visible = FALSE; // Disable update for API request
			else
				$this->LOCAL->setFormValue($val);
		}

		// Check field name 'DEPARTAMENTO' first before field var 'x_DEPARTAMENTO'
		$val = $CurrentForm->hasValue("DEPARTAMENTO") ? $CurrentForm->getValue("DEPARTAMENTO") : $CurrentForm->getValue("x_DEPARTAMENTO");
		if (!$this->DEPARTAMENTO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DEPARTAMENTO->Visible = FALSE; // Disable update for API request
			else
				$this->DEPARTAMENTO->setFormValue($val);
		}

		// Check field name 'PROVINCIA' first before field var 'x_PROVINCIA'
		$val = $CurrentForm->hasValue("PROVINCIA") ? $CurrentForm->getValue("PROVINCIA") : $CurrentForm->getValue("x_PROVINCIA");
		if (!$this->PROVINCIA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PROVINCIA->Visible = FALSE; // Disable update for API request
			else
				$this->PROVINCIA->setFormValue($val);
		}

		// Check field name 'DISTRITO' first before field var 'x_DISTRITO'
		$val = $CurrentForm->hasValue("DISTRITO") ? $CurrentForm->getValue("DISTRITO") : $CurrentForm->getValue("x_DISTRITO");
		if (!$this->DISTRITO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DISTRITO->Visible = FALSE; // Disable update for API request
			else
				$this->DISTRITO->setFormValue($val);
		}

		// Check field name 'AREA' first before field var 'x_AREA'
		$val = $CurrentForm->hasValue("AREA") ? $CurrentForm->getValue("AREA") : $CurrentForm->getValue("x_AREA");
		if (!$this->AREA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->AREA->Visible = FALSE; // Disable update for API request
			else
				$this->AREA->setFormValue($val);
		}

		// Check field name 'OFICINA' first before field var 'x_OFICINA'
		$val = $CurrentForm->hasValue("OFICINA") ? $CurrentForm->getValue("OFICINA") : $CurrentForm->getValue("x_OFICINA");
		if (!$this->OFICINA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->OFICINA->Visible = FALSE; // Disable update for API request
			else
				$this->OFICINA->setFormValue($val);
		}

		// Check field name 'PISO_OFICINA' first before field var 'x_PISO_OFICINA'
		$val = $CurrentForm->hasValue("PISO_OFICINA") ? $CurrentForm->getValue("PISO_OFICINA") : $CurrentForm->getValue("x_PISO_OFICINA");
		if (!$this->PISO_OFICINA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PISO_OFICINA->Visible = FALSE; // Disable update for API request
			else
				$this->PISO_OFICINA->setFormValue($val);
		}

		// Check field name 'NRO_DOC_IDENT_PERSONAL' first before field var 'x_NRO_DOC_IDENT_PERSONAL'
		$val = $CurrentForm->hasValue("NRO_DOC_IDENT_PERSONAL") ? $CurrentForm->getValue("NRO_DOC_IDENT_PERSONAL") : $CurrentForm->getValue("x_NRO_DOC_IDENT_PERSONAL");
		if (!$this->NRO_DOC_IDENT_PERSONAL->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_DOC_IDENT_PERSONAL->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_DOC_IDENT_PERSONAL->setFormValue($val);
		}

		// Check field name 'APELLIDO_PATERNO' first before field var 'x_APELLIDO_PATERNO'
		$val = $CurrentForm->hasValue("APELLIDO_PATERNO") ? $CurrentForm->getValue("APELLIDO_PATERNO") : $CurrentForm->getValue("x_APELLIDO_PATERNO");
		if (!$this->APELLIDO_PATERNO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->APELLIDO_PATERNO->Visible = FALSE; // Disable update for API request
			else
				$this->APELLIDO_PATERNO->setFormValue($val);
		}

		// Check field name 'APELLIDO_MATERNO' first before field var 'x_APELLIDO_MATERNO'
		$val = $CurrentForm->hasValue("APELLIDO_MATERNO") ? $CurrentForm->getValue("APELLIDO_MATERNO") : $CurrentForm->getValue("x_APELLIDO_MATERNO");
		if (!$this->APELLIDO_MATERNO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->APELLIDO_MATERNO->Visible = FALSE; // Disable update for API request
			else
				$this->APELLIDO_MATERNO->setFormValue($val);
		}

		// Check field name 'NOMBRES' first before field var 'x_NOMBRES'
		$val = $CurrentForm->hasValue("NOMBRES") ? $CurrentForm->getValue("NOMBRES") : $CurrentForm->getValue("x_NOMBRES");
		if (!$this->NOMBRES->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NOMBRES->Visible = FALSE; // Disable update for API request
			else
				$this->NOMBRES->setFormValue($val);
		}

		// Check field name 'OPERATIVO' first before field var 'x_OPERATIVO'
		$val = $CurrentForm->hasValue("OPERATIVO") ? $CurrentForm->getValue("OPERATIVO") : $CurrentForm->getValue("x_OPERATIVO");
		if (!$this->OPERATIVO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->OPERATIVO->Visible = FALSE; // Disable update for API request
			else
				$this->OPERATIVO->setFormValue($val);
		}

		// Check field name 'TIPO_DOC_IDENTIDAD' first before field var 'x_TIPO_DOC_IDENTIDAD'
		$val = $CurrentForm->hasValue("TIPO_DOC_IDENTIDAD") ? $CurrentForm->getValue("TIPO_DOC_IDENTIDAD") : $CurrentForm->getValue("x_TIPO_DOC_IDENTIDAD");
		if (!$this->TIPO_DOC_IDENTIDAD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIPO_DOC_IDENTIDAD->Visible = FALSE; // Disable update for API request
			else
				$this->TIPO_DOC_IDENTIDAD->setFormValue($val);
		}

		// Check field name 'MODALIDAD_CONTRATO' first before field var 'x_MODALIDAD_CONTRATO'
		$val = $CurrentForm->hasValue("MODALIDAD_CONTRATO") ? $CurrentForm->getValue("MODALIDAD_CONTRATO") : $CurrentForm->getValue("x_MODALIDAD_CONTRATO");
		if (!$this->MODALIDAD_CONTRATO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MODALIDAD_CONTRATO->Visible = FALSE; // Disable update for API request
			else
				$this->MODALIDAD_CONTRATO->setFormValue($val);
		}

		// Check field name 'CODIGO_PATRIMONIAL' first before field var 'x_CODIGO_PATRIMONIAL'
		$val = $CurrentForm->hasValue("CODIGO_PATRIMONIAL") ? $CurrentForm->getValue("CODIGO_PATRIMONIAL") : $CurrentForm->getValue("x_CODIGO_PATRIMONIAL");
		if (!$this->CODIGO_PATRIMONIAL->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CODIGO_PATRIMONIAL->Visible = FALSE; // Disable update for API request
			else
				$this->CODIGO_PATRIMONIAL->setFormValue($val);
		}

		// Check field name 'DENOMINACION_BIEN' first before field var 'x_DENOMINACION_BIEN'
		$val = $CurrentForm->hasValue("DENOMINACION_BIEN") ? $CurrentForm->getValue("DENOMINACION_BIEN") : $CurrentForm->getValue("x_DENOMINACION_BIEN");
		if (!$this->DENOMINACION_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DENOMINACION_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->DENOMINACION_BIEN->setFormValue($val);
		}

		// Check field name 'TIPO_CAUSAL_ALTA' first before field var 'x_TIPO_CAUSAL_ALTA'
		$val = $CurrentForm->hasValue("TIPO_CAUSAL_ALTA") ? $CurrentForm->getValue("TIPO_CAUSAL_ALTA") : $CurrentForm->getValue("x_TIPO_CAUSAL_ALTA");
		if (!$this->TIPO_CAUSAL_ALTA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIPO_CAUSAL_ALTA->Visible = FALSE; // Disable update for API request
			else
				$this->TIPO_CAUSAL_ALTA->setFormValue($val);
		}

		// Check field name 'NRO_DOC_ADQUISICION' first before field var 'x_NRO_DOC_ADQUISICION'
		$val = $CurrentForm->hasValue("NRO_DOC_ADQUISICION") ? $CurrentForm->getValue("NRO_DOC_ADQUISICION") : $CurrentForm->getValue("x_NRO_DOC_ADQUISICION");
		if (!$this->NRO_DOC_ADQUISICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_DOC_ADQUISICION->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_DOC_ADQUISICION->setFormValue($val);
		}

		// Check field name 'FECHA_ADQUISICION' first before field var 'x_FECHA_ADQUISICION'
		$val = $CurrentForm->hasValue("FECHA_ADQUISICION") ? $CurrentForm->getValue("FECHA_ADQUISICION") : $CurrentForm->getValue("x_FECHA_ADQUISICION");
		if (!$this->FECHA_ADQUISICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_ADQUISICION->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_ADQUISICION->setFormValue($val);
		}

		// Check field name 'VALOR_ADQUISICION' first before field var 'x_VALOR_ADQUISICION'
		$val = $CurrentForm->hasValue("VALOR_ADQUISICION") ? $CurrentForm->getValue("VALOR_ADQUISICION") : $CurrentForm->getValue("x_VALOR_ADQUISICION");
		if (!$this->VALOR_ADQUISICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->VALOR_ADQUISICION->Visible = FALSE; // Disable update for API request
			else
				$this->VALOR_ADQUISICION->setFormValue($val);
		}

		// Check field name 'FECHA_DEPRECIACION' first before field var 'x_FECHA_DEPRECIACION'
		$val = $CurrentForm->hasValue("FECHA_DEPRECIACION") ? $CurrentForm->getValue("FECHA_DEPRECIACION") : $CurrentForm->getValue("x_FECHA_DEPRECIACION");
		if (!$this->FECHA_DEPRECIACION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_DEPRECIACION->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_DEPRECIACION->setFormValue($val);
		}

		// Check field name 'VALOR_DEPREC_EJERCICIO' first before field var 'x_VALOR_DEPREC_EJERCICIO'
		$val = $CurrentForm->hasValue("VALOR_DEPREC_EJERCICIO") ? $CurrentForm->getValue("VALOR_DEPREC_EJERCICIO") : $CurrentForm->getValue("x_VALOR_DEPREC_EJERCICIO");
		if (!$this->VALOR_DEPREC_EJERCICIO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->VALOR_DEPREC_EJERCICIO->Visible = FALSE; // Disable update for API request
			else
				$this->VALOR_DEPREC_EJERCICIO->setFormValue($val);
		}

		// Check field name 'VALOR_DEPREC_ACUMULADO' first before field var 'x_VALOR_DEPREC_ACUMULADO'
		$val = $CurrentForm->hasValue("VALOR_DEPREC_ACUMULADO") ? $CurrentForm->getValue("VALOR_DEPREC_ACUMULADO") : $CurrentForm->getValue("x_VALOR_DEPREC_ACUMULADO");
		if (!$this->VALOR_DEPREC_ACUMULADO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->VALOR_DEPREC_ACUMULADO->Visible = FALSE; // Disable update for API request
			else
				$this->VALOR_DEPREC_ACUMULADO->setFormValue($val);
		}

		// Check field name 'VALOR_NETO' first before field var 'x_VALOR_NETO'
		$val = $CurrentForm->hasValue("VALOR_NETO") ? $CurrentForm->getValue("VALOR_NETO") : $CurrentForm->getValue("x_VALOR_NETO");
		if (!$this->VALOR_NETO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->VALOR_NETO->Visible = FALSE; // Disable update for API request
			else
				$this->VALOR_NETO->setFormValue($val);
		}

		// Check field name 'TIP_USO_CUENTA' first before field var 'x_TIP_USO_CUENTA'
		$val = $CurrentForm->hasValue("TIP_USO_CUENTA") ? $CurrentForm->getValue("TIP_USO_CUENTA") : $CurrentForm->getValue("x_TIP_USO_CUENTA");
		if (!$this->TIP_USO_CUENTA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIP_USO_CUENTA->Visible = FALSE; // Disable update for API request
			else
				$this->TIP_USO_CUENTA->setFormValue($val);
		}

		// Check field name 'TIPO_CUENTA' first before field var 'x_TIPO_CUENTA'
		$val = $CurrentForm->hasValue("TIPO_CUENTA") ? $CurrentForm->getValue("TIPO_CUENTA") : $CurrentForm->getValue("x_TIPO_CUENTA");
		if (!$this->TIPO_CUENTA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIPO_CUENTA->Visible = FALSE; // Disable update for API request
			else
				$this->TIPO_CUENTA->setFormValue($val);
		}

		// Check field name 'NRO_CUENTA_CONTABLE' first before field var 'x_NRO_CUENTA_CONTABLE'
		$val = $CurrentForm->hasValue("NRO_CUENTA_CONTABLE") ? $CurrentForm->getValue("NRO_CUENTA_CONTABLE") : $CurrentForm->getValue("x_NRO_CUENTA_CONTABLE");
		if (!$this->NRO_CUENTA_CONTABLE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_CUENTA_CONTABLE->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_CUENTA_CONTABLE->setFormValue($val);
		}

		// Check field name 'CTA_CON_SEGURO' first before field var 'x_CTA_CON_SEGURO'
		$val = $CurrentForm->hasValue("CTA_CON_SEGURO") ? $CurrentForm->getValue("CTA_CON_SEGURO") : $CurrentForm->getValue("x_CTA_CON_SEGURO");
		if (!$this->CTA_CON_SEGURO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CTA_CON_SEGURO->Visible = FALSE; // Disable update for API request
			else
				$this->CTA_CON_SEGURO->setFormValue($val);
		}

		// Check field name 'ESTADO_BIEN' first before field var 'x_ESTADO_BIEN'
		$val = $CurrentForm->hasValue("ESTADO_BIEN") ? $CurrentForm->getValue("ESTADO_BIEN") : $CurrentForm->getValue("x_ESTADO_BIEN");
		if (!$this->ESTADO_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ESTADO_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->ESTADO_BIEN->setFormValue($val);
		}

		// Check field name 'CONDICION' first before field var 'x_CONDICION'
		$val = $CurrentForm->hasValue("CONDICION") ? $CurrentForm->getValue("CONDICION") : $CurrentForm->getValue("x_CONDICION");
		if (!$this->CONDICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CONDICION->Visible = FALSE; // Disable update for API request
			else
				$this->CONDICION->setFormValue($val);
		}

		// Check field name 'MARCA' first before field var 'x_MARCA'
		$val = $CurrentForm->hasValue("MARCA") ? $CurrentForm->getValue("MARCA") : $CurrentForm->getValue("x_MARCA");
		if (!$this->MARCA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MARCA->Visible = FALSE; // Disable update for API request
			else
				$this->MARCA->setFormValue($val);
		}

		// Check field name 'MODELO' first before field var 'x_MODELO'
		$val = $CurrentForm->hasValue("MODELO") ? $CurrentForm->getValue("MODELO") : $CurrentForm->getValue("x_MODELO");
		if (!$this->MODELO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MODELO->Visible = FALSE; // Disable update for API request
			else
				$this->MODELO->setFormValue($val);
		}

		// Check field name 'TIPO' first before field var 'x_TIPO'
		$val = $CurrentForm->hasValue("TIPO") ? $CurrentForm->getValue("TIPO") : $CurrentForm->getValue("x_TIPO");
		if (!$this->TIPO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->TIPO->Visible = FALSE; // Disable update for API request
			else
				$this->TIPO->setFormValue($val);
		}

		// Check field name 'COLOR' first before field var 'x_COLOR'
		$val = $CurrentForm->hasValue("COLOR") ? $CurrentForm->getValue("COLOR") : $CurrentForm->getValue("x_COLOR");
		if (!$this->COLOR->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->COLOR->Visible = FALSE; // Disable update for API request
			else
				$this->COLOR->setFormValue($val);
		}

		// Check field name 'SERIE' first before field var 'x_SERIE'
		$val = $CurrentForm->hasValue("SERIE") ? $CurrentForm->getValue("SERIE") : $CurrentForm->getValue("x_SERIE");
		if (!$this->SERIE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SERIE->Visible = FALSE; // Disable update for API request
			else
				$this->SERIE->setFormValue($val);
		}

		// Check field name 'DIMENSION' first before field var 'x_DIMENSION'
		$val = $CurrentForm->hasValue("DIMENSION") ? $CurrentForm->getValue("DIMENSION") : $CurrentForm->getValue("x_DIMENSION");
		if (!$this->DIMENSION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DIMENSION->Visible = FALSE; // Disable update for API request
			else
				$this->DIMENSION->setFormValue($val);
		}

		// Check field name 'PLACA' first before field var 'x_PLACA'
		$val = $CurrentForm->hasValue("PLACA") ? $CurrentForm->getValue("PLACA") : $CurrentForm->getValue("x_PLACA");
		if (!$this->PLACA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PLACA->Visible = FALSE; // Disable update for API request
			else
				$this->PLACA->setFormValue($val);
		}

		// Check field name 'NRO_MOTOR' first before field var 'x_NRO_MOTOR'
		$val = $CurrentForm->hasValue("NRO_MOTOR") ? $CurrentForm->getValue("NRO_MOTOR") : $CurrentForm->getValue("x_NRO_MOTOR");
		if (!$this->NRO_MOTOR->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_MOTOR->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_MOTOR->setFormValue($val);
		}

		// Check field name 'NRO_CHASIS' first before field var 'x_NRO_CHASIS'
		$val = $CurrentForm->hasValue("NRO_CHASIS") ? $CurrentForm->getValue("NRO_CHASIS") : $CurrentForm->getValue("x_NRO_CHASIS");
		if (!$this->NRO_CHASIS->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_CHASIS->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_CHASIS->setFormValue($val);
		}

		// Check field name 'MATRICULA' first before field var 'x_MATRICULA'
		$val = $CurrentForm->hasValue("MATRICULA") ? $CurrentForm->getValue("MATRICULA") : $CurrentForm->getValue("x_MATRICULA");
		if (!$this->MATRICULA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MATRICULA->Visible = FALSE; // Disable update for API request
			else
				$this->MATRICULA->setFormValue($val);
		}

		// Check field name 'ANIO_FABRICACION' first before field var 'x_ANIO_FABRICACION'
		$val = $CurrentForm->hasValue("ANIO_FABRICACION") ? $CurrentForm->getValue("ANIO_FABRICACION") : $CurrentForm->getValue("x_ANIO_FABRICACION");
		if (!$this->ANIO_FABRICACION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ANIO_FABRICACION->Visible = FALSE; // Disable update for API request
			else
				$this->ANIO_FABRICACION->setFormValue($val);
		}

		// Check field name 'LONGITUD' first before field var 'x_LONGITUD'
		$val = $CurrentForm->hasValue("LONGITUD") ? $CurrentForm->getValue("LONGITUD") : $CurrentForm->getValue("x_LONGITUD");
		if (!$this->LONGITUD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LONGITUD->Visible = FALSE; // Disable update for API request
			else
				$this->LONGITUD->setFormValue($val);
		}

		// Check field name 'ALTURA' first before field var 'x_ALTURA'
		$val = $CurrentForm->hasValue("ALTURA") ? $CurrentForm->getValue("ALTURA") : $CurrentForm->getValue("x_ALTURA");
		if (!$this->ALTURA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ALTURA->Visible = FALSE; // Disable update for API request
			else
				$this->ALTURA->setFormValue($val);
		}

		// Check field name 'ANCHO' first before field var 'x_ANCHO'
		$val = $CurrentForm->hasValue("ANCHO") ? $CurrentForm->getValue("ANCHO") : $CurrentForm->getValue("x_ANCHO");
		if (!$this->ANCHO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ANCHO->Visible = FALSE; // Disable update for API request
			else
				$this->ANCHO->setFormValue($val);
		}

		// Check field name 'RAZA' first before field var 'x_RAZA'
		$val = $CurrentForm->hasValue("RAZA") ? $CurrentForm->getValue("RAZA") : $CurrentForm->getValue("x_RAZA");
		if (!$this->RAZA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->RAZA->Visible = FALSE; // Disable update for API request
			else
				$this->RAZA->setFormValue($val);
		}

		// Check field name 'ESPECIE' first before field var 'x_ESPECIE'
		$val = $CurrentForm->hasValue("ESPECIE") ? $CurrentForm->getValue("ESPECIE") : $CurrentForm->getValue("x_ESPECIE");
		if (!$this->ESPECIE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ESPECIE->Visible = FALSE; // Disable update for API request
			else
				$this->ESPECIE->setFormValue($val);
		}

		// Check field name 'EDAD' first before field var 'x_EDAD'
		$val = $CurrentForm->hasValue("EDAD") ? $CurrentForm->getValue("EDAD") : $CurrentForm->getValue("x_EDAD");
		if (!$this->EDAD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->EDAD->Visible = FALSE; // Disable update for API request
			else
				$this->EDAD->setFormValue($val);
		}

		// Check field name 'PAIS' first before field var 'x_PAIS'
		$val = $CurrentForm->hasValue("PAIS") ? $CurrentForm->getValue("PAIS") : $CurrentForm->getValue("x_PAIS");
		if (!$this->PAIS->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PAIS->Visible = FALSE; // Disable update for API request
			else
				$this->PAIS->setFormValue($val);
		}

		// Check field name 'OTRAS_CARACT' first before field var 'x_OTRAS_CARACT'
		$val = $CurrentForm->hasValue("OTRAS_CARACT") ? $CurrentForm->getValue("OTRAS_CARACT") : $CurrentForm->getValue("x_OTRAS_CARACT");
		if (!$this->OTRAS_CARACT->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->OTRAS_CARACT->Visible = FALSE; // Disable update for API request
			else
				$this->OTRAS_CARACT->setFormValue($val);
		}

		// Check field name 'DESCRIPCION_UBICACION_BIEN' first before field var 'x_DESCRIPCION_UBICACION_BIEN'
		$val = $CurrentForm->hasValue("DESCRIPCION_UBICACION_BIEN") ? $CurrentForm->getValue("DESCRIPCION_UBICACION_BIEN") : $CurrentForm->getValue("x_DESCRIPCION_UBICACION_BIEN");
		if (!$this->DESCRIPCION_UBICACION_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DESCRIPCION_UBICACION_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->DESCRIPCION_UBICACION_BIEN->setFormValue($val);
		}

		// Check field name 'CAUSAL_BAJA' first before field var 'x_CAUSAL_BAJA'
		$val = $CurrentForm->hasValue("CAUSAL_BAJA") ? $CurrentForm->getValue("CAUSAL_BAJA") : $CurrentForm->getValue("x_CAUSAL_BAJA");
		if (!$this->CAUSAL_BAJA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CAUSAL_BAJA->Visible = FALSE; // Disable update for API request
			else
				$this->CAUSAL_BAJA->setFormValue($val);
		}

		// Check field name 'NRO_RESOLUCION_BAJA' first before field var 'x_NRO_RESOLUCION_BAJA'
		$val = $CurrentForm->hasValue("NRO_RESOLUCION_BAJA") ? $CurrentForm->getValue("NRO_RESOLUCION_BAJA") : $CurrentForm->getValue("x_NRO_RESOLUCION_BAJA");
		if (!$this->NRO_RESOLUCION_BAJA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_RESOLUCION_BAJA->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_RESOLUCION_BAJA->setFormValue($val);
		}

		// Check field name 'FECHA_BAJA' first before field var 'x_FECHA_BAJA'
		$val = $CurrentForm->hasValue("FECHA_BAJA") ? $CurrentForm->getValue("FECHA_BAJA") : $CurrentForm->getValue("x_FECHA_BAJA");
		if (!$this->FECHA_BAJA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_BAJA->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_BAJA->setFormValue($val);
		}

		// Check field name 'ACTO_DISPOSICION_BIEN' first before field var 'x_ACTO_DISPOSICION_BIEN'
		$val = $CurrentForm->hasValue("ACTO_DISPOSICION_BIEN") ? $CurrentForm->getValue("ACTO_DISPOSICION_BIEN") : $CurrentForm->getValue("x_ACTO_DISPOSICION_BIEN");
		if (!$this->ACTO_DISPOSICION_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ACTO_DISPOSICION_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->ACTO_DISPOSICION_BIEN->setFormValue($val);
		}

		// Check field name 'NRO_RESOLUCION_DISP' first before field var 'x_NRO_RESOLUCION_DISP'
		$val = $CurrentForm->hasValue("NRO_RESOLUCION_DISP") ? $CurrentForm->getValue("NRO_RESOLUCION_DISP") : $CurrentForm->getValue("x_NRO_RESOLUCION_DISP");
		if (!$this->NRO_RESOLUCION_DISP->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NRO_RESOLUCION_DISP->Visible = FALSE; // Disable update for API request
			else
				$this->NRO_RESOLUCION_DISP->setFormValue($val);
		}

		// Check field name 'FECHA_DISPOSICION' first before field var 'x_FECHA_DISPOSICION'
		$val = $CurrentForm->hasValue("FECHA_DISPOSICION") ? $CurrentForm->getValue("FECHA_DISPOSICION") : $CurrentForm->getValue("x_FECHA_DISPOSICION");
		if (!$this->FECHA_DISPOSICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_DISPOSICION->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_DISPOSICION->setFormValue($val);
		}

		// Check field name 'ENTIDAD_BENEFICIADA_ACTO_DISPOSICION' first before field var 'x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION'
		$val = $CurrentForm->hasValue("ENTIDAD_BENEFICIADA_ACTO_DISPOSICION") ? $CurrentForm->getValue("ENTIDAD_BENEFICIADA_ACTO_DISPOSICION") : $CurrentForm->getValue("x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION");
		if (!$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Visible = FALSE; // Disable update for API request
			else
				$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setFormValue($val);
		}

		// Check field name 'MOTIVO_ELIMINACION_BIEN' first before field var 'x_MOTIVO_ELIMINACION_BIEN'
		$val = $CurrentForm->hasValue("MOTIVO_ELIMINACION_BIEN") ? $CurrentForm->getValue("MOTIVO_ELIMINACION_BIEN") : $CurrentForm->getValue("x_MOTIVO_ELIMINACION_BIEN");
		if (!$this->MOTIVO_ELIMINACION_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MOTIVO_ELIMINACION_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->MOTIVO_ELIMINACION_BIEN->setFormValue($val);
		}

		// Check field name 'ACTO_ADMINISTRACION_BIEN' first before field var 'x_ACTO_ADMINISTRACION_BIEN'
		$val = $CurrentForm->hasValue("ACTO_ADMINISTRACION_BIEN") ? $CurrentForm->getValue("ACTO_ADMINISTRACION_BIEN") : $CurrentForm->getValue("x_ACTO_ADMINISTRACION_BIEN");
		if (!$this->ACTO_ADMINISTRACION_BIEN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ACTO_ADMINISTRACION_BIEN->Visible = FALSE; // Disable update for API request
			else
				$this->ACTO_ADMINISTRACION_BIEN->setFormValue($val);
		}

		// Check field name 'NUM_RESOLUCION_ADMINISTRACION' first before field var 'x_NUM_RESOLUCION_ADMINISTRACION'
		$val = $CurrentForm->hasValue("NUM_RESOLUCION_ADMINISTRACION") ? $CurrentForm->getValue("NUM_RESOLUCION_ADMINISTRACION") : $CurrentForm->getValue("x_NUM_RESOLUCION_ADMINISTRACION");
		if (!$this->NUM_RESOLUCION_ADMINISTRACION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NUM_RESOLUCION_ADMINISTRACION->Visible = FALSE; // Disable update for API request
			else
				$this->NUM_RESOLUCION_ADMINISTRACION->setFormValue($val);
		}

		// Check field name 'FECHA_ADMINISTRACION' first before field var 'x_FECHA_ADMINISTRACION'
		$val = $CurrentForm->hasValue("FECHA_ADMINISTRACION") ? $CurrentForm->getValue("FECHA_ADMINISTRACION") : $CurrentForm->getValue("x_FECHA_ADMINISTRACION");
		if (!$this->FECHA_ADMINISTRACION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_ADMINISTRACION->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_ADMINISTRACION->setFormValue($val);
		}

		// Check field name 'FECHA_VENC_ACTO_ADMIN' first before field var 'x_FECHA_VENC_ACTO_ADMIN'
		$val = $CurrentForm->hasValue("FECHA_VENC_ACTO_ADMIN") ? $CurrentForm->getValue("FECHA_VENC_ACTO_ADMIN") : $CurrentForm->getValue("x_FECHA_VENC_ACTO_ADMIN");
		if (!$this->FECHA_VENC_ACTO_ADMIN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_VENC_ACTO_ADMIN->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_VENC_ACTO_ADMIN->setFormValue($val);
		}

		// Check field name 'ENTIDAD_BENEFICIADA_ACTO_ADMIN' first before field var 'x_ENTIDAD_BENEFICIADA_ACTO_ADMIN'
		$val = $CurrentForm->hasValue("ENTIDAD_BENEFICIADA_ACTO_ADMIN") ? $CurrentForm->getValue("ENTIDAD_BENEFICIADA_ACTO_ADMIN") : $CurrentForm->getValue("x_ENTIDAD_BENEFICIADA_ACTO_ADMIN");
		if (!$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Visible = FALSE; // Disable update for API request
			else
				$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setFormValue($val);
		}

		// Check field name 'DOC_ALTA_SBN' first before field var 'x_DOC_ALTA_SBN'
		$val = $CurrentForm->hasValue("DOC_ALTA_SBN") ? $CurrentForm->getValue("DOC_ALTA_SBN") : $CurrentForm->getValue("x_DOC_ALTA_SBN");
		if (!$this->DOC_ALTA_SBN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DOC_ALTA_SBN->Visible = FALSE; // Disable update for API request
			else
				$this->DOC_ALTA_SBN->setFormValue($val);
		}

		// Check field name 'DOC_BAJA_SBN' first before field var 'x_DOC_BAJA_SBN'
		$val = $CurrentForm->hasValue("DOC_BAJA_SBN") ? $CurrentForm->getValue("DOC_BAJA_SBN") : $CurrentForm->getValue("x_DOC_BAJA_SBN");
		if (!$this->DOC_BAJA_SBN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DOC_BAJA_SBN->Visible = FALSE; // Disable update for API request
			else
				$this->DOC_BAJA_SBN->setFormValue($val);
		}

		// Check field name 'DEPENDENCIAS' first before field var 'x_DEPENDENCIAS'
		$val = $CurrentForm->hasValue("DEPENDENCIAS") ? $CurrentForm->getValue("DEPENDENCIAS") : $CurrentForm->getValue("x_DEPENDENCIAS");
		if (!$this->DEPENDENCIAS->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DEPENDENCIAS->Visible = FALSE; // Disable update for API request
			else
				$this->DEPENDENCIAS->setFormValue($val);
		}

		// Check field name 'NUMERO_FICHA' first before field var 'x_NUMERO_FICHA'
		$val = $CurrentForm->hasValue("NUMERO_FICHA") ? $CurrentForm->getValue("NUMERO_FICHA") : $CurrentForm->getValue("x_NUMERO_FICHA");
		if (!$this->NUMERO_FICHA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NUMERO_FICHA->Visible = FALSE; // Disable update for API request
			else
				$this->NUMERO_FICHA->setFormValue($val);
		}

		// Check field name 'CODIGO_INTERNO' first before field var 'x_CODIGO_INTERNO'
		$val = $CurrentForm->hasValue("CODIGO_INTERNO") ? $CurrentForm->getValue("CODIGO_INTERNO") : $CurrentForm->getValue("x_CODIGO_INTERNO");
		if (!$this->CODIGO_INTERNO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CODIGO_INTERNO->Visible = FALSE; // Disable update for API request
			else
				$this->CODIGO_INTERNO->setFormValue($val);
		}

		// Check field name 'ESTADO' first before field var 'x_ESTADO'
		$val = $CurrentForm->hasValue("ESTADO") ? $CurrentForm->getValue("ESTADO") : $CurrentForm->getValue("x_ESTADO");
		if (!$this->ESTADO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ESTADO->Visible = FALSE; // Disable update for API request
			else
				$this->ESTADO->setFormValue($val);
		}

		// Check field name 'USO' first before field var 'x_USO'
		$val = $CurrentForm->hasValue("USO") ? $CurrentForm->getValue("USO") : $CurrentForm->getValue("x_USO");
		if (!$this->USO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->USO->Visible = FALSE; // Disable update for API request
			else
				$this->USO->setFormValue($val);
		}

		// Check field name 'STICKER' first before field var 'x_STICKER'
		$val = $CurrentForm->hasValue("STICKER") ? $CurrentForm->getValue("STICKER") : $CurrentForm->getValue("x_STICKER");
		if (!$this->STICKER->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->STICKER->Visible = FALSE; // Disable update for API request
			else
				$this->STICKER->setFormValue($val);
		}

		// Check field name 'SEDE' first before field var 'x_SEDE'
		$val = $CurrentForm->hasValue("SEDE") ? $CurrentForm->getValue("SEDE") : $CurrentForm->getValue("x_SEDE");
		if (!$this->SEDE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SEDE->Visible = FALSE; // Disable update for API request
			else
				$this->SEDE->setFormValue($val);
		}

		// Check field name 'SBN' first before field var 'x_SBN'
		$val = $CurrentForm->hasValue("SBN") ? $CurrentForm->getValue("SBN") : $CurrentForm->getValue("x_SBN");
		if (!$this->SBN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SBN->Visible = FALSE; // Disable update for API request
			else
				$this->SBN->setFormValue($val);
		}

		// Check field name 'ETIQUETA' first before field var 'x_ETIQUETA'
		$val = $CurrentForm->hasValue("ETIQUETA") ? $CurrentForm->getValue("ETIQUETA") : $CurrentForm->getValue("x_ETIQUETA");
		if (!$this->ETIQUETA->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ETIQUETA->Visible = FALSE; // Disable update for API request
			else
				$this->ETIQUETA->setFormValue($val);
		}

		// Check field name 'NOMBRE_BENEFICIARIO_ACTO_ADMIN' first before field var 'x_NOMBRE_BENEFICIARIO_ACTO_ADMIN'
		$val = $CurrentForm->hasValue("NOMBRE_BENEFICIARIO_ACTO_ADMIN") ? $CurrentForm->getValue("NOMBRE_BENEFICIARIO_ACTO_ADMIN") : $CurrentForm->getValue("x_NOMBRE_BENEFICIARIO_ACTO_ADMIN");
		if (!$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Visible = FALSE; // Disable update for API request
			else
				$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setFormValue($val);
		}

		// Check field name 'PLACA_RODAJE' first before field var 'x_PLACA_RODAJE'
		$val = $CurrentForm->hasValue("PLACA_RODAJE") ? $CurrentForm->getValue("PLACA_RODAJE") : $CurrentForm->getValue("x_PLACA_RODAJE");
		if (!$this->PLACA_RODAJE->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PLACA_RODAJE->Visible = FALSE; // Disable update for API request
			else
				$this->PLACA_RODAJE->setFormValue($val);
		}

		// Check field name 'CODIGO_ACTUAL' first before field var 'x_CODIGO_ACTUAL'
		$val = $CurrentForm->hasValue("CODIGO_ACTUAL") ? $CurrentForm->getValue("CODIGO_ACTUAL") : $CurrentForm->getValue("x_CODIGO_ACTUAL");
		if (!$this->CODIGO_ACTUAL->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CODIGO_ACTUAL->Visible = FALSE; // Disable update for API request
			else
				$this->CODIGO_ACTUAL->setFormValue($val);
		}

		// Check field name 'CODIGO_ANTERIOR' first before field var 'x_CODIGO_ANTERIOR'
		$val = $CurrentForm->hasValue("CODIGO_ANTERIOR") ? $CurrentForm->getValue("CODIGO_ANTERIOR") : $CurrentForm->getValue("x_CODIGO_ANTERIOR");
		if (!$this->CODIGO_ANTERIOR->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CODIGO_ANTERIOR->Visible = FALSE; // Disable update for API request
			else
				$this->CODIGO_ANTERIOR->setFormValue($val);
		}

		// Check field name 'PROPIEDAD' first before field var 'x_PROPIEDAD'
		$val = $CurrentForm->hasValue("PROPIEDAD") ? $CurrentForm->getValue("PROPIEDAD") : $CurrentForm->getValue("x_PROPIEDAD");
		if (!$this->PROPIEDAD->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PROPIEDAD->Visible = FALSE; // Disable update for API request
			else
				$this->PROPIEDAD->setFormValue($val);
		}

		// Check field name 'SITUACION' first before field var 'x_SITUACION'
		$val = $CurrentForm->hasValue("SITUACION") ? $CurrentForm->getValue("SITUACION") : $CurrentForm->getValue("x_SITUACION");
		if (!$this->SITUACION->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SITUACION->Visible = FALSE; // Disable update for API request
			else
				$this->SITUACION->setFormValue($val);
		}

		// Check field name 'OBSERVACIONES' first before field var 'x_OBSERVACIONES'
		$val = $CurrentForm->hasValue("OBSERVACIONES") ? $CurrentForm->getValue("OBSERVACIONES") : $CurrentForm->getValue("x_OBSERVACIONES");
		if (!$this->OBSERVACIONES->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->OBSERVACIONES->Visible = FALSE; // Disable update for API request
			else
				$this->OBSERVACIONES->setFormValue($val);
		}

		// Check field name 'FECHA_REGISTRO' first before field var 'x_FECHA_REGISTRO'
		$val = $CurrentForm->hasValue("FECHA_REGISTRO") ? $CurrentForm->getValue("FECHA_REGISTRO") : $CurrentForm->getValue("x_FECHA_REGISTRO");
		if (!$this->FECHA_REGISTRO->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FECHA_REGISTRO->Visible = FALSE; // Disable update for API request
			else
				$this->FECHA_REGISTRO->setFormValue($val);
			$this->FECHA_REGISTRO->CurrentValue = UnFormatDateTime($this->FECHA_REGISTRO->CurrentValue, 0);
		}

		// Check field name 'codigo' first before field var 'x_codigo'
		$val = $CurrentForm->hasValue("codigo") ? $CurrentForm->getValue("codigo") : $CurrentForm->getValue("x_codigo");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->codigo_proceso->CurrentValue = $this->codigo_proceso->FormValue;
		$this->no->CurrentValue = $this->no->FormValue;
		$this->usuarios->CurrentValue = $this->usuarios->FormValue;
		$this->SEC_EJEC->CurrentValue = $this->SEC_EJEC->FormValue;
		$this->TIPO_MODALIDAD->CurrentValue = $this->TIPO_MODALIDAD->FormValue;
		$this->SECUENCIA->CurrentValue = $this->SECUENCIA->FormValue;
		$this->AMBIENTE->CurrentValue = $this->AMBIENTE->FormValue;
		$this->RUC_ENTIDAD->CurrentValue = $this->RUC_ENTIDAD->FormValue;
		$this->LOCAL->CurrentValue = $this->LOCAL->FormValue;
		$this->DEPARTAMENTO->CurrentValue = $this->DEPARTAMENTO->FormValue;
		$this->PROVINCIA->CurrentValue = $this->PROVINCIA->FormValue;
		$this->DISTRITO->CurrentValue = $this->DISTRITO->FormValue;
		$this->AREA->CurrentValue = $this->AREA->FormValue;
		$this->OFICINA->CurrentValue = $this->OFICINA->FormValue;
		$this->PISO_OFICINA->CurrentValue = $this->PISO_OFICINA->FormValue;
		$this->NRO_DOC_IDENT_PERSONAL->CurrentValue = $this->NRO_DOC_IDENT_PERSONAL->FormValue;
		$this->APELLIDO_PATERNO->CurrentValue = $this->APELLIDO_PATERNO->FormValue;
		$this->APELLIDO_MATERNO->CurrentValue = $this->APELLIDO_MATERNO->FormValue;
		$this->NOMBRES->CurrentValue = $this->NOMBRES->FormValue;
		$this->OPERATIVO->CurrentValue = $this->OPERATIVO->FormValue;
		$this->TIPO_DOC_IDENTIDAD->CurrentValue = $this->TIPO_DOC_IDENTIDAD->FormValue;
		$this->MODALIDAD_CONTRATO->CurrentValue = $this->MODALIDAD_CONTRATO->FormValue;
		$this->CODIGO_PATRIMONIAL->CurrentValue = $this->CODIGO_PATRIMONIAL->FormValue;
		$this->DENOMINACION_BIEN->CurrentValue = $this->DENOMINACION_BIEN->FormValue;
		$this->TIPO_CAUSAL_ALTA->CurrentValue = $this->TIPO_CAUSAL_ALTA->FormValue;
		$this->NRO_DOC_ADQUISICION->CurrentValue = $this->NRO_DOC_ADQUISICION->FormValue;
		$this->FECHA_ADQUISICION->CurrentValue = $this->FECHA_ADQUISICION->FormValue;
		$this->VALOR_ADQUISICION->CurrentValue = $this->VALOR_ADQUISICION->FormValue;
		$this->FECHA_DEPRECIACION->CurrentValue = $this->FECHA_DEPRECIACION->FormValue;
		$this->VALOR_DEPREC_EJERCICIO->CurrentValue = $this->VALOR_DEPREC_EJERCICIO->FormValue;
		$this->VALOR_DEPREC_ACUMULADO->CurrentValue = $this->VALOR_DEPREC_ACUMULADO->FormValue;
		$this->VALOR_NETO->CurrentValue = $this->VALOR_NETO->FormValue;
		$this->TIP_USO_CUENTA->CurrentValue = $this->TIP_USO_CUENTA->FormValue;
		$this->TIPO_CUENTA->CurrentValue = $this->TIPO_CUENTA->FormValue;
		$this->NRO_CUENTA_CONTABLE->CurrentValue = $this->NRO_CUENTA_CONTABLE->FormValue;
		$this->CTA_CON_SEGURO->CurrentValue = $this->CTA_CON_SEGURO->FormValue;
		$this->ESTADO_BIEN->CurrentValue = $this->ESTADO_BIEN->FormValue;
		$this->CONDICION->CurrentValue = $this->CONDICION->FormValue;
		$this->MARCA->CurrentValue = $this->MARCA->FormValue;
		$this->MODELO->CurrentValue = $this->MODELO->FormValue;
		$this->TIPO->CurrentValue = $this->TIPO->FormValue;
		$this->COLOR->CurrentValue = $this->COLOR->FormValue;
		$this->SERIE->CurrentValue = $this->SERIE->FormValue;
		$this->DIMENSION->CurrentValue = $this->DIMENSION->FormValue;
		$this->PLACA->CurrentValue = $this->PLACA->FormValue;
		$this->NRO_MOTOR->CurrentValue = $this->NRO_MOTOR->FormValue;
		$this->NRO_CHASIS->CurrentValue = $this->NRO_CHASIS->FormValue;
		$this->MATRICULA->CurrentValue = $this->MATRICULA->FormValue;
		$this->ANIO_FABRICACION->CurrentValue = $this->ANIO_FABRICACION->FormValue;
		$this->LONGITUD->CurrentValue = $this->LONGITUD->FormValue;
		$this->ALTURA->CurrentValue = $this->ALTURA->FormValue;
		$this->ANCHO->CurrentValue = $this->ANCHO->FormValue;
		$this->RAZA->CurrentValue = $this->RAZA->FormValue;
		$this->ESPECIE->CurrentValue = $this->ESPECIE->FormValue;
		$this->EDAD->CurrentValue = $this->EDAD->FormValue;
		$this->PAIS->CurrentValue = $this->PAIS->FormValue;
		$this->OTRAS_CARACT->CurrentValue = $this->OTRAS_CARACT->FormValue;
		$this->DESCRIPCION_UBICACION_BIEN->CurrentValue = $this->DESCRIPCION_UBICACION_BIEN->FormValue;
		$this->CAUSAL_BAJA->CurrentValue = $this->CAUSAL_BAJA->FormValue;
		$this->NRO_RESOLUCION_BAJA->CurrentValue = $this->NRO_RESOLUCION_BAJA->FormValue;
		$this->FECHA_BAJA->CurrentValue = $this->FECHA_BAJA->FormValue;
		$this->ACTO_DISPOSICION_BIEN->CurrentValue = $this->ACTO_DISPOSICION_BIEN->FormValue;
		$this->NRO_RESOLUCION_DISP->CurrentValue = $this->NRO_RESOLUCION_DISP->FormValue;
		$this->FECHA_DISPOSICION->CurrentValue = $this->FECHA_DISPOSICION->FormValue;
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->FormValue;
		$this->MOTIVO_ELIMINACION_BIEN->CurrentValue = $this->MOTIVO_ELIMINACION_BIEN->FormValue;
		$this->ACTO_ADMINISTRACION_BIEN->CurrentValue = $this->ACTO_ADMINISTRACION_BIEN->FormValue;
		$this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue = $this->NUM_RESOLUCION_ADMINISTRACION->FormValue;
		$this->FECHA_ADMINISTRACION->CurrentValue = $this->FECHA_ADMINISTRACION->FormValue;
		$this->FECHA_VENC_ACTO_ADMIN->CurrentValue = $this->FECHA_VENC_ACTO_ADMIN->FormValue;
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->FormValue;
		$this->DOC_ALTA_SBN->CurrentValue = $this->DOC_ALTA_SBN->FormValue;
		$this->DOC_BAJA_SBN->CurrentValue = $this->DOC_BAJA_SBN->FormValue;
		$this->DEPENDENCIAS->CurrentValue = $this->DEPENDENCIAS->FormValue;
		$this->NUMERO_FICHA->CurrentValue = $this->NUMERO_FICHA->FormValue;
		$this->CODIGO_INTERNO->CurrentValue = $this->CODIGO_INTERNO->FormValue;
		$this->ESTADO->CurrentValue = $this->ESTADO->FormValue;
		$this->USO->CurrentValue = $this->USO->FormValue;
		$this->STICKER->CurrentValue = $this->STICKER->FormValue;
		$this->SEDE->CurrentValue = $this->SEDE->FormValue;
		$this->SBN->CurrentValue = $this->SBN->FormValue;
		$this->ETIQUETA->CurrentValue = $this->ETIQUETA->FormValue;
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->FormValue;
		$this->PLACA_RODAJE->CurrentValue = $this->PLACA_RODAJE->FormValue;
		$this->CODIGO_ACTUAL->CurrentValue = $this->CODIGO_ACTUAL->FormValue;
		$this->CODIGO_ANTERIOR->CurrentValue = $this->CODIGO_ANTERIOR->FormValue;
		$this->PROPIEDAD->CurrentValue = $this->PROPIEDAD->FormValue;
		$this->SITUACION->CurrentValue = $this->SITUACION->FormValue;
		$this->OBSERVACIONES->CurrentValue = $this->OBSERVACIONES->FormValue;
		$this->FECHA_REGISTRO->CurrentValue = $this->FECHA_REGISTRO->FormValue;
		$this->FECHA_REGISTRO->CurrentValue = UnFormatDateTime($this->FECHA_REGISTRO->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->codigo->setDbValue($row['codigo']);
		$this->codigo_proceso->setDbValue($row['codigo_proceso']);
		$this->no->setDbValue($row['no']);
		$this->usuarios->setDbValue($row['usuarios']);
		$this->SEC_EJEC->setDbValue($row['SEC_EJEC']);
		$this->TIPO_MODALIDAD->setDbValue($row['TIPO_MODALIDAD']);
		$this->SECUENCIA->setDbValue($row['SECUENCIA']);
		$this->AMBIENTE->setDbValue($row['AMBIENTE']);
		$this->RUC_ENTIDAD->setDbValue($row['RUC_ENTIDAD']);
		$this->LOCAL->setDbValue($row['LOCAL']);
		$this->DEPARTAMENTO->setDbValue($row['DEPARTAMENTO']);
		$this->PROVINCIA->setDbValue($row['PROVINCIA']);
		$this->DISTRITO->setDbValue($row['DISTRITO']);
		$this->AREA->setDbValue($row['AREA']);
		$this->OFICINA->setDbValue($row['OFICINA']);
		$this->PISO_OFICINA->setDbValue($row['PISO_OFICINA']);
		$this->NRO_DOC_IDENT_PERSONAL->setDbValue($row['NRO_DOC_IDENT_PERSONAL']);
		$this->APELLIDO_PATERNO->setDbValue($row['APELLIDO_PATERNO']);
		$this->APELLIDO_MATERNO->setDbValue($row['APELLIDO_MATERNO']);
		$this->NOMBRES->setDbValue($row['NOMBRES']);
		$this->OPERATIVO->setDbValue($row['OPERATIVO']);
		$this->TIPO_DOC_IDENTIDAD->setDbValue($row['TIPO_DOC_IDENTIDAD']);
		$this->MODALIDAD_CONTRATO->setDbValue($row['MODALIDAD_CONTRATO']);
		$this->CODIGO_PATRIMONIAL->setDbValue($row['CODIGO_PATRIMONIAL']);
		$this->DENOMINACION_BIEN->setDbValue($row['DENOMINACION_BIEN']);
		$this->TIPO_CAUSAL_ALTA->setDbValue($row['TIPO_CAUSAL_ALTA']);
		$this->NRO_DOC_ADQUISICION->setDbValue($row['NRO_DOC_ADQUISICION']);
		$this->FECHA_ADQUISICION->setDbValue($row['FECHA_ADQUISICION']);
		$this->VALOR_ADQUISICION->setDbValue($row['VALOR_ADQUISICION']);
		$this->FECHA_DEPRECIACION->setDbValue($row['FECHA_DEPRECIACION']);
		$this->VALOR_DEPREC_EJERCICIO->setDbValue($row['VALOR_DEPREC_EJERCICIO']);
		$this->VALOR_DEPREC_ACUMULADO->setDbValue($row['VALOR_DEPREC_ACUMULADO']);
		$this->VALOR_NETO->setDbValue($row['VALOR_NETO']);
		$this->TIP_USO_CUENTA->setDbValue($row['TIP_USO_CUENTA']);
		$this->TIPO_CUENTA->setDbValue($row['TIPO_CUENTA']);
		$this->NRO_CUENTA_CONTABLE->setDbValue($row['NRO_CUENTA_CONTABLE']);
		$this->CTA_CON_SEGURO->setDbValue($row['CTA_CON_SEGURO']);
		$this->ESTADO_BIEN->setDbValue($row['ESTADO_BIEN']);
		$this->CONDICION->setDbValue($row['CONDICION']);
		$this->MARCA->setDbValue($row['MARCA']);
		$this->MODELO->setDbValue($row['MODELO']);
		$this->TIPO->setDbValue($row['TIPO']);
		$this->COLOR->setDbValue($row['COLOR']);
		$this->SERIE->setDbValue($row['SERIE']);
		$this->DIMENSION->setDbValue($row['DIMENSION']);
		$this->PLACA->setDbValue($row['PLACA']);
		$this->NRO_MOTOR->setDbValue($row['NRO_MOTOR']);
		$this->NRO_CHASIS->setDbValue($row['NRO_CHASIS']);
		$this->MATRICULA->setDbValue($row['MATRICULA']);
		$this->ANIO_FABRICACION->setDbValue($row['ANIO_FABRICACION']);
		$this->LONGITUD->setDbValue($row['LONGITUD']);
		$this->ALTURA->setDbValue($row['ALTURA']);
		$this->ANCHO->setDbValue($row['ANCHO']);
		$this->RAZA->setDbValue($row['RAZA']);
		$this->ESPECIE->setDbValue($row['ESPECIE']);
		$this->EDAD->setDbValue($row['EDAD']);
		$this->PAIS->setDbValue($row['PAIS']);
		$this->OTRAS_CARACT->setDbValue($row['OTRAS_CARACT']);
		$this->DESCRIPCION_UBICACION_BIEN->setDbValue($row['DESCRIPCION_UBICACION_BIEN']);
		$this->CAUSAL_BAJA->setDbValue($row['CAUSAL_BAJA']);
		$this->NRO_RESOLUCION_BAJA->setDbValue($row['NRO_RESOLUCION_BAJA']);
		$this->FECHA_BAJA->setDbValue($row['FECHA_BAJA']);
		$this->ACTO_DISPOSICION_BIEN->setDbValue($row['ACTO_DISPOSICION_BIEN']);
		$this->NRO_RESOLUCION_DISP->setDbValue($row['NRO_RESOLUCION_DISP']);
		$this->FECHA_DISPOSICION->setDbValue($row['FECHA_DISPOSICION']);
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION']);
		$this->MOTIVO_ELIMINACION_BIEN->setDbValue($row['MOTIVO_ELIMINACION_BIEN']);
		$this->ACTO_ADMINISTRACION_BIEN->setDbValue($row['ACTO_ADMINISTRACION_BIEN']);
		$this->NUM_RESOLUCION_ADMINISTRACION->setDbValue($row['NUM_RESOLUCION_ADMINISTRACION']);
		$this->FECHA_ADMINISTRACION->setDbValue($row['FECHA_ADMINISTRACION']);
		$this->FECHA_VENC_ACTO_ADMIN->setDbValue($row['FECHA_VENC_ACTO_ADMIN']);
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_ADMIN']);
		$this->DOC_ALTA_SBN->setDbValue($row['DOC_ALTA_SBN']);
		$this->DOC_BAJA_SBN->setDbValue($row['DOC_BAJA_SBN']);
		$this->DEPENDENCIAS->setDbValue($row['DEPENDENCIAS']);
		$this->NUMERO_FICHA->setDbValue($row['NUMERO_FICHA']);
		$this->CODIGO_INTERNO->setDbValue($row['CODIGO_INTERNO']);
		$this->ESTADO->setDbValue($row['ESTADO']);
		$this->USO->setDbValue($row['USO']);
		$this->STICKER->setDbValue($row['STICKER']);
		$this->SEDE->setDbValue($row['SEDE']);
		$this->SBN->setDbValue($row['SBN']);
		$this->ETIQUETA->setDbValue($row['ETIQUETA']);
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setDbValue($row['NOMBRE_BENEFICIARIO_ACTO_ADMIN']);
		$this->PLACA_RODAJE->setDbValue($row['PLACA_RODAJE']);
		$this->CODIGO_ACTUAL->setDbValue($row['CODIGO_ACTUAL']);
		$this->CODIGO_ANTERIOR->setDbValue($row['CODIGO_ANTERIOR']);
		$this->PROPIEDAD->setDbValue($row['PROPIEDAD']);
		$this->SITUACION->setDbValue($row['SITUACION']);
		$this->OBSERVACIONES->setDbValue($row['OBSERVACIONES']);
		$this->FECHA_REGISTRO->setDbValue($row['FECHA_REGISTRO']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['codigo'] = $this->codigo->CurrentValue;
		$row['codigo_proceso'] = $this->codigo_proceso->CurrentValue;
		$row['no'] = $this->no->CurrentValue;
		$row['usuarios'] = $this->usuarios->CurrentValue;
		$row['SEC_EJEC'] = $this->SEC_EJEC->CurrentValue;
		$row['TIPO_MODALIDAD'] = $this->TIPO_MODALIDAD->CurrentValue;
		$row['SECUENCIA'] = $this->SECUENCIA->CurrentValue;
		$row['AMBIENTE'] = $this->AMBIENTE->CurrentValue;
		$row['RUC_ENTIDAD'] = $this->RUC_ENTIDAD->CurrentValue;
		$row['LOCAL'] = $this->LOCAL->CurrentValue;
		$row['DEPARTAMENTO'] = $this->DEPARTAMENTO->CurrentValue;
		$row['PROVINCIA'] = $this->PROVINCIA->CurrentValue;
		$row['DISTRITO'] = $this->DISTRITO->CurrentValue;
		$row['AREA'] = $this->AREA->CurrentValue;
		$row['OFICINA'] = $this->OFICINA->CurrentValue;
		$row['PISO_OFICINA'] = $this->PISO_OFICINA->CurrentValue;
		$row['NRO_DOC_IDENT_PERSONAL'] = $this->NRO_DOC_IDENT_PERSONAL->CurrentValue;
		$row['APELLIDO_PATERNO'] = $this->APELLIDO_PATERNO->CurrentValue;
		$row['APELLIDO_MATERNO'] = $this->APELLIDO_MATERNO->CurrentValue;
		$row['NOMBRES'] = $this->NOMBRES->CurrentValue;
		$row['OPERATIVO'] = $this->OPERATIVO->CurrentValue;
		$row['TIPO_DOC_IDENTIDAD'] = $this->TIPO_DOC_IDENTIDAD->CurrentValue;
		$row['MODALIDAD_CONTRATO'] = $this->MODALIDAD_CONTRATO->CurrentValue;
		$row['CODIGO_PATRIMONIAL'] = $this->CODIGO_PATRIMONIAL->CurrentValue;
		$row['DENOMINACION_BIEN'] = $this->DENOMINACION_BIEN->CurrentValue;
		$row['TIPO_CAUSAL_ALTA'] = $this->TIPO_CAUSAL_ALTA->CurrentValue;
		$row['NRO_DOC_ADQUISICION'] = $this->NRO_DOC_ADQUISICION->CurrentValue;
		$row['FECHA_ADQUISICION'] = $this->FECHA_ADQUISICION->CurrentValue;
		$row['VALOR_ADQUISICION'] = $this->VALOR_ADQUISICION->CurrentValue;
		$row['FECHA_DEPRECIACION'] = $this->FECHA_DEPRECIACION->CurrentValue;
		$row['VALOR_DEPREC_EJERCICIO'] = $this->VALOR_DEPREC_EJERCICIO->CurrentValue;
		$row['VALOR_DEPREC_ACUMULADO'] = $this->VALOR_DEPREC_ACUMULADO->CurrentValue;
		$row['VALOR_NETO'] = $this->VALOR_NETO->CurrentValue;
		$row['TIP_USO_CUENTA'] = $this->TIP_USO_CUENTA->CurrentValue;
		$row['TIPO_CUENTA'] = $this->TIPO_CUENTA->CurrentValue;
		$row['NRO_CUENTA_CONTABLE'] = $this->NRO_CUENTA_CONTABLE->CurrentValue;
		$row['CTA_CON_SEGURO'] = $this->CTA_CON_SEGURO->CurrentValue;
		$row['ESTADO_BIEN'] = $this->ESTADO_BIEN->CurrentValue;
		$row['CONDICION'] = $this->CONDICION->CurrentValue;
		$row['MARCA'] = $this->MARCA->CurrentValue;
		$row['MODELO'] = $this->MODELO->CurrentValue;
		$row['TIPO'] = $this->TIPO->CurrentValue;
		$row['COLOR'] = $this->COLOR->CurrentValue;
		$row['SERIE'] = $this->SERIE->CurrentValue;
		$row['DIMENSION'] = $this->DIMENSION->CurrentValue;
		$row['PLACA'] = $this->PLACA->CurrentValue;
		$row['NRO_MOTOR'] = $this->NRO_MOTOR->CurrentValue;
		$row['NRO_CHASIS'] = $this->NRO_CHASIS->CurrentValue;
		$row['MATRICULA'] = $this->MATRICULA->CurrentValue;
		$row['ANIO_FABRICACION'] = $this->ANIO_FABRICACION->CurrentValue;
		$row['LONGITUD'] = $this->LONGITUD->CurrentValue;
		$row['ALTURA'] = $this->ALTURA->CurrentValue;
		$row['ANCHO'] = $this->ANCHO->CurrentValue;
		$row['RAZA'] = $this->RAZA->CurrentValue;
		$row['ESPECIE'] = $this->ESPECIE->CurrentValue;
		$row['EDAD'] = $this->EDAD->CurrentValue;
		$row['PAIS'] = $this->PAIS->CurrentValue;
		$row['OTRAS_CARACT'] = $this->OTRAS_CARACT->CurrentValue;
		$row['DESCRIPCION_UBICACION_BIEN'] = $this->DESCRIPCION_UBICACION_BIEN->CurrentValue;
		$row['CAUSAL_BAJA'] = $this->CAUSAL_BAJA->CurrentValue;
		$row['NRO_RESOLUCION_BAJA'] = $this->NRO_RESOLUCION_BAJA->CurrentValue;
		$row['FECHA_BAJA'] = $this->FECHA_BAJA->CurrentValue;
		$row['ACTO_DISPOSICION_BIEN'] = $this->ACTO_DISPOSICION_BIEN->CurrentValue;
		$row['NRO_RESOLUCION_DISP'] = $this->NRO_RESOLUCION_DISP->CurrentValue;
		$row['FECHA_DISPOSICION'] = $this->FECHA_DISPOSICION->CurrentValue;
		$row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION'] = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue;
		$row['MOTIVO_ELIMINACION_BIEN'] = $this->MOTIVO_ELIMINACION_BIEN->CurrentValue;
		$row['ACTO_ADMINISTRACION_BIEN'] = $this->ACTO_ADMINISTRACION_BIEN->CurrentValue;
		$row['NUM_RESOLUCION_ADMINISTRACION'] = $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue;
		$row['FECHA_ADMINISTRACION'] = $this->FECHA_ADMINISTRACION->CurrentValue;
		$row['FECHA_VENC_ACTO_ADMIN'] = $this->FECHA_VENC_ACTO_ADMIN->CurrentValue;
		$row['ENTIDAD_BENEFICIADA_ACTO_ADMIN'] = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue;
		$row['DOC_ALTA_SBN'] = $this->DOC_ALTA_SBN->CurrentValue;
		$row['DOC_BAJA_SBN'] = $this->DOC_BAJA_SBN->CurrentValue;
		$row['DEPENDENCIAS'] = $this->DEPENDENCIAS->CurrentValue;
		$row['NUMERO_FICHA'] = $this->NUMERO_FICHA->CurrentValue;
		$row['CODIGO_INTERNO'] = $this->CODIGO_INTERNO->CurrentValue;
		$row['ESTADO'] = $this->ESTADO->CurrentValue;
		$row['USO'] = $this->USO->CurrentValue;
		$row['STICKER'] = $this->STICKER->CurrentValue;
		$row['SEDE'] = $this->SEDE->CurrentValue;
		$row['SBN'] = $this->SBN->CurrentValue;
		$row['ETIQUETA'] = $this->ETIQUETA->CurrentValue;
		$row['NOMBRE_BENEFICIARIO_ACTO_ADMIN'] = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue;
		$row['PLACA_RODAJE'] = $this->PLACA_RODAJE->CurrentValue;
		$row['CODIGO_ACTUAL'] = $this->CODIGO_ACTUAL->CurrentValue;
		$row['CODIGO_ANTERIOR'] = $this->CODIGO_ANTERIOR->CurrentValue;
		$row['PROPIEDAD'] = $this->PROPIEDAD->CurrentValue;
		$row['SITUACION'] = $this->SITUACION->CurrentValue;
		$row['OBSERVACIONES'] = $this->OBSERVACIONES->CurrentValue;
		$row['FECHA_REGISTRO'] = $this->FECHA_REGISTRO->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("codigo")) != "")
			$this->codigo->OldValue = $this->getKey("codigo"); // codigo
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// codigo
		// codigo_proceso
		// no
		// usuarios
		// SEC_EJEC
		// TIPO_MODALIDAD
		// SECUENCIA
		// AMBIENTE
		// RUC_ENTIDAD
		// LOCAL
		// DEPARTAMENTO
		// PROVINCIA
		// DISTRITO
		// AREA
		// OFICINA
		// PISO_OFICINA
		// NRO_DOC_IDENT_PERSONAL
		// APELLIDO_PATERNO
		// APELLIDO_MATERNO
		// NOMBRES
		// OPERATIVO
		// TIPO_DOC_IDENTIDAD
		// MODALIDAD_CONTRATO
		// CODIGO_PATRIMONIAL
		// DENOMINACION_BIEN
		// TIPO_CAUSAL_ALTA
		// NRO_DOC_ADQUISICION
		// FECHA_ADQUISICION
		// VALOR_ADQUISICION
		// FECHA_DEPRECIACION
		// VALOR_DEPREC_EJERCICIO
		// VALOR_DEPREC_ACUMULADO
		// VALOR_NETO
		// TIP_USO_CUENTA
		// TIPO_CUENTA
		// NRO_CUENTA_CONTABLE
		// CTA_CON_SEGURO
		// ESTADO_BIEN
		// CONDICION
		// MARCA
		// MODELO
		// TIPO
		// COLOR
		// SERIE
		// DIMENSION
		// PLACA
		// NRO_MOTOR
		// NRO_CHASIS
		// MATRICULA
		// ANIO_FABRICACION
		// LONGITUD
		// ALTURA
		// ANCHO
		// RAZA
		// ESPECIE
		// EDAD
		// PAIS
		// OTRAS_CARACT
		// DESCRIPCION_UBICACION_BIEN
		// CAUSAL_BAJA
		// NRO_RESOLUCION_BAJA
		// FECHA_BAJA
		// ACTO_DISPOSICION_BIEN
		// NRO_RESOLUCION_DISP
		// FECHA_DISPOSICION
		// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		// MOTIVO_ELIMINACION_BIEN
		// ACTO_ADMINISTRACION_BIEN
		// NUM_RESOLUCION_ADMINISTRACION
		// FECHA_ADMINISTRACION
		// FECHA_VENC_ACTO_ADMIN
		// ENTIDAD_BENEFICIADA_ACTO_ADMIN
		// DOC_ALTA_SBN
		// DOC_BAJA_SBN
		// DEPENDENCIAS
		// NUMERO_FICHA
		// CODIGO_INTERNO
		// ESTADO
		// USO
		// STICKER
		// SEDE
		// SBN
		// ETIQUETA
		// NOMBRE_BENEFICIARIO_ACTO_ADMIN
		// PLACA_RODAJE
		// CODIGO_ACTUAL
		// CODIGO_ANTERIOR
		// PROPIEDAD
		// SITUACION
		// OBSERVACIONES
		// FECHA_REGISTRO

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// codigo
			$this->codigo->ViewValue = $this->codigo->CurrentValue;
			$this->codigo->ViewCustomAttributes = "";

			// codigo_proceso
			$this->codigo_proceso->ViewValue = $this->codigo_proceso->CurrentValue;
			$this->codigo_proceso->ViewValue = FormatNumber($this->codigo_proceso->ViewValue, 0, -2, -2, -2);
			$this->codigo_proceso->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewValue = FormatNumber($this->no->ViewValue, 0, -2, -2, -2);
			$this->no->ViewCustomAttributes = "";

			// usuarios
			$this->usuarios->ViewValue = $this->usuarios->CurrentValue;
			$this->usuarios->ViewValue = FormatNumber($this->usuarios->ViewValue, 0, -2, -2, -2);
			$this->usuarios->ViewCustomAttributes = "";

			// SEC_EJEC
			$this->SEC_EJEC->ViewValue = $this->SEC_EJEC->CurrentValue;
			$this->SEC_EJEC->ViewCustomAttributes = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->ViewValue = $this->TIPO_MODALIDAD->CurrentValue;
			$this->TIPO_MODALIDAD->ViewCustomAttributes = "";

			// SECUENCIA
			$this->SECUENCIA->ViewValue = $this->SECUENCIA->CurrentValue;
			$this->SECUENCIA->ViewCustomAttributes = "";

			// AMBIENTE
			$this->AMBIENTE->ViewValue = $this->AMBIENTE->CurrentValue;
			$this->AMBIENTE->ViewCustomAttributes = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->ViewValue = $this->RUC_ENTIDAD->CurrentValue;
			$this->RUC_ENTIDAD->ViewCustomAttributes = "";

			// LOCAL
			$this->LOCAL->ViewValue = $this->LOCAL->CurrentValue;
			$this->LOCAL->ViewCustomAttributes = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->ViewValue = $this->DEPARTAMENTO->CurrentValue;
			$this->DEPARTAMENTO->ViewCustomAttributes = "";

			// PROVINCIA
			$this->PROVINCIA->ViewValue = $this->PROVINCIA->CurrentValue;
			$this->PROVINCIA->ViewCustomAttributes = "";

			// DISTRITO
			$this->DISTRITO->ViewValue = $this->DISTRITO->CurrentValue;
			$this->DISTRITO->ViewCustomAttributes = "";

			// AREA
			$this->AREA->ViewValue = $this->AREA->CurrentValue;
			$this->AREA->ViewCustomAttributes = "";

			// OFICINA
			$this->OFICINA->ViewValue = $this->OFICINA->CurrentValue;
			$this->OFICINA->ViewCustomAttributes = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->ViewValue = $this->PISO_OFICINA->CurrentValue;
			$this->PISO_OFICINA->ViewCustomAttributes = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->ViewValue = $this->NRO_DOC_IDENT_PERSONAL->CurrentValue;
			$this->NRO_DOC_IDENT_PERSONAL->ViewCustomAttributes = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->ViewValue = $this->APELLIDO_PATERNO->CurrentValue;
			$this->APELLIDO_PATERNO->ViewCustomAttributes = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->ViewValue = $this->APELLIDO_MATERNO->CurrentValue;
			$this->APELLIDO_MATERNO->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// OPERATIVO
			$this->OPERATIVO->ViewValue = $this->OPERATIVO->CurrentValue;
			$this->OPERATIVO->ViewCustomAttributes = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->ViewValue = $this->TIPO_DOC_IDENTIDAD->CurrentValue;
			$this->TIPO_DOC_IDENTIDAD->ViewCustomAttributes = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->ViewValue = $this->MODALIDAD_CONTRATO->CurrentValue;
			$this->MODALIDAD_CONTRATO->ViewCustomAttributes = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->ViewValue = $this->CODIGO_PATRIMONIAL->CurrentValue;
			$this->CODIGO_PATRIMONIAL->ViewCustomAttributes = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->ViewValue = $this->DENOMINACION_BIEN->CurrentValue;
			$this->DENOMINACION_BIEN->ViewCustomAttributes = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->ViewValue = $this->TIPO_CAUSAL_ALTA->CurrentValue;
			$this->TIPO_CAUSAL_ALTA->ViewCustomAttributes = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->ViewValue = $this->NRO_DOC_ADQUISICION->CurrentValue;
			$this->NRO_DOC_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->ViewValue = $this->FECHA_ADQUISICION->CurrentValue;
			$this->FECHA_ADQUISICION->ViewCustomAttributes = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->ViewValue = $this->VALOR_ADQUISICION->CurrentValue;
			$this->VALOR_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->ViewValue = $this->FECHA_DEPRECIACION->CurrentValue;
			$this->FECHA_DEPRECIACION->ViewCustomAttributes = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->ViewValue = $this->VALOR_DEPREC_EJERCICIO->CurrentValue;
			$this->VALOR_DEPREC_EJERCICIO->ViewCustomAttributes = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->ViewValue = $this->VALOR_DEPREC_ACUMULADO->CurrentValue;
			$this->VALOR_DEPREC_ACUMULADO->ViewCustomAttributes = "";

			// VALOR_NETO
			$this->VALOR_NETO->ViewValue = $this->VALOR_NETO->CurrentValue;
			$this->VALOR_NETO->ViewCustomAttributes = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->ViewValue = $this->TIP_USO_CUENTA->CurrentValue;
			$this->TIP_USO_CUENTA->ViewCustomAttributes = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->ViewValue = $this->TIPO_CUENTA->CurrentValue;
			$this->TIPO_CUENTA->ViewCustomAttributes = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->ViewValue = $this->NRO_CUENTA_CONTABLE->CurrentValue;
			$this->NRO_CUENTA_CONTABLE->ViewCustomAttributes = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->ViewValue = $this->CTA_CON_SEGURO->CurrentValue;
			$this->CTA_CON_SEGURO->ViewCustomAttributes = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->ViewValue = $this->ESTADO_BIEN->CurrentValue;
			$this->ESTADO_BIEN->ViewCustomAttributes = "";

			// CONDICION
			$this->CONDICION->ViewValue = $this->CONDICION->CurrentValue;
			$this->CONDICION->ViewCustomAttributes = "";

			// MARCA
			$this->MARCA->ViewValue = $this->MARCA->CurrentValue;
			$this->MARCA->ViewCustomAttributes = "";

			// MODELO
			$this->MODELO->ViewValue = $this->MODELO->CurrentValue;
			$this->MODELO->ViewCustomAttributes = "";

			// TIPO
			$this->TIPO->ViewValue = $this->TIPO->CurrentValue;
			$this->TIPO->ViewCustomAttributes = "";

			// COLOR
			$this->COLOR->ViewValue = $this->COLOR->CurrentValue;
			$this->COLOR->ViewCustomAttributes = "";

			// SERIE
			$this->SERIE->ViewValue = $this->SERIE->CurrentValue;
			$this->SERIE->ViewCustomAttributes = "";

			// DIMENSION
			$this->DIMENSION->ViewValue = $this->DIMENSION->CurrentValue;
			$this->DIMENSION->ViewCustomAttributes = "";

			// PLACA
			$this->PLACA->ViewValue = $this->PLACA->CurrentValue;
			$this->PLACA->ViewCustomAttributes = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->ViewValue = $this->NRO_MOTOR->CurrentValue;
			$this->NRO_MOTOR->ViewCustomAttributes = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->ViewValue = $this->NRO_CHASIS->CurrentValue;
			$this->NRO_CHASIS->ViewCustomAttributes = "";

			// MATRICULA
			$this->MATRICULA->ViewValue = $this->MATRICULA->CurrentValue;
			$this->MATRICULA->ViewCustomAttributes = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->ViewValue = $this->ANIO_FABRICACION->CurrentValue;
			$this->ANIO_FABRICACION->ViewCustomAttributes = "";

			// LONGITUD
			$this->LONGITUD->ViewValue = $this->LONGITUD->CurrentValue;
			$this->LONGITUD->ViewCustomAttributes = "";

			// ALTURA
			$this->ALTURA->ViewValue = $this->ALTURA->CurrentValue;
			$this->ALTURA->ViewCustomAttributes = "";

			// ANCHO
			$this->ANCHO->ViewValue = $this->ANCHO->CurrentValue;
			$this->ANCHO->ViewCustomAttributes = "";

			// RAZA
			$this->RAZA->ViewValue = $this->RAZA->CurrentValue;
			$this->RAZA->ViewCustomAttributes = "";

			// ESPECIE
			$this->ESPECIE->ViewValue = $this->ESPECIE->CurrentValue;
			$this->ESPECIE->ViewCustomAttributes = "";

			// EDAD
			$this->EDAD->ViewValue = $this->EDAD->CurrentValue;
			$this->EDAD->ViewCustomAttributes = "";

			// PAIS
			$this->PAIS->ViewValue = $this->PAIS->CurrentValue;
			$this->PAIS->ViewCustomAttributes = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->ViewValue = $this->OTRAS_CARACT->CurrentValue;
			$this->OTRAS_CARACT->ViewCustomAttributes = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->ViewValue = $this->DESCRIPCION_UBICACION_BIEN->CurrentValue;
			$this->DESCRIPCION_UBICACION_BIEN->ViewCustomAttributes = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->ViewValue = $this->CAUSAL_BAJA->CurrentValue;
			$this->CAUSAL_BAJA->ViewCustomAttributes = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->ViewValue = $this->NRO_RESOLUCION_BAJA->CurrentValue;
			$this->NRO_RESOLUCION_BAJA->ViewCustomAttributes = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->ViewValue = $this->FECHA_BAJA->CurrentValue;
			$this->FECHA_BAJA->ViewCustomAttributes = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->ViewValue = $this->ACTO_DISPOSICION_BIEN->CurrentValue;
			$this->ACTO_DISPOSICION_BIEN->ViewCustomAttributes = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->ViewValue = $this->NRO_RESOLUCION_DISP->CurrentValue;
			$this->NRO_RESOLUCION_DISP->ViewCustomAttributes = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->ViewValue = $this->FECHA_DISPOSICION->CurrentValue;
			$this->FECHA_DISPOSICION->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewCustomAttributes = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->ViewValue = $this->MOTIVO_ELIMINACION_BIEN->CurrentValue;
			$this->MOTIVO_ELIMINACION_BIEN->ViewCustomAttributes = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->ViewValue = $this->ACTO_ADMINISTRACION_BIEN->CurrentValue;
			$this->ACTO_ADMINISTRACION_BIEN->ViewCustomAttributes = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewValue = $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue;
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->ViewValue = $this->FECHA_ADMINISTRACION->CurrentValue;
			$this->FECHA_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->ViewValue = $this->FECHA_VENC_ACTO_ADMIN->CurrentValue;
			$this->FECHA_VENC_ACTO_ADMIN->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewCustomAttributes = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->ViewValue = $this->DOC_ALTA_SBN->CurrentValue;
			$this->DOC_ALTA_SBN->ViewCustomAttributes = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->ViewValue = $this->DOC_BAJA_SBN->CurrentValue;
			$this->DOC_BAJA_SBN->ViewCustomAttributes = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->ViewValue = $this->DEPENDENCIAS->CurrentValue;
			$this->DEPENDENCIAS->ViewCustomAttributes = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->ViewValue = $this->NUMERO_FICHA->CurrentValue;
			$this->NUMERO_FICHA->ViewCustomAttributes = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->ViewValue = $this->CODIGO_INTERNO->CurrentValue;
			$this->CODIGO_INTERNO->ViewCustomAttributes = "";

			// ESTADO
			$this->ESTADO->ViewValue = $this->ESTADO->CurrentValue;
			$this->ESTADO->ViewCustomAttributes = "";

			// USO
			$this->USO->ViewValue = $this->USO->CurrentValue;
			$this->USO->ViewCustomAttributes = "";

			// STICKER
			$this->STICKER->ViewValue = $this->STICKER->CurrentValue;
			$this->STICKER->ViewCustomAttributes = "";

			// SEDE
			$this->SEDE->ViewValue = $this->SEDE->CurrentValue;
			$this->SEDE->ViewCustomAttributes = "";

			// SBN
			$this->SBN->ViewValue = $this->SBN->CurrentValue;
			$this->SBN->ViewCustomAttributes = "";

			// ETIQUETA
			$this->ETIQUETA->ViewValue = $this->ETIQUETA->CurrentValue;
			$this->ETIQUETA->ViewCustomAttributes = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewValue = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue;
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewCustomAttributes = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->ViewValue = $this->PLACA_RODAJE->CurrentValue;
			$this->PLACA_RODAJE->ViewCustomAttributes = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->ViewValue = $this->CODIGO_ACTUAL->CurrentValue;
			$this->CODIGO_ACTUAL->ViewCustomAttributes = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->ViewValue = $this->CODIGO_ANTERIOR->CurrentValue;
			$this->CODIGO_ANTERIOR->ViewCustomAttributes = "";

			// PROPIEDAD
			$this->PROPIEDAD->ViewValue = $this->PROPIEDAD->CurrentValue;
			$this->PROPIEDAD->ViewCustomAttributes = "";

			// SITUACION
			$this->SITUACION->ViewValue = $this->SITUACION->CurrentValue;
			$this->SITUACION->ViewCustomAttributes = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->ViewValue = $this->OBSERVACIONES->CurrentValue;
			$this->OBSERVACIONES->ViewCustomAttributes = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->ViewValue = $this->FECHA_REGISTRO->CurrentValue;
			$this->FECHA_REGISTRO->ViewValue = FormatDateTime($this->FECHA_REGISTRO->ViewValue, 0);
			$this->FECHA_REGISTRO->ViewCustomAttributes = "";

			// codigo_proceso
			$this->codigo_proceso->LinkCustomAttributes = "";
			$this->codigo_proceso->HrefValue = "";
			$this->codigo_proceso->TooltipValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// usuarios
			$this->usuarios->LinkCustomAttributes = "";
			$this->usuarios->HrefValue = "";
			$this->usuarios->TooltipValue = "";

			// SEC_EJEC
			$this->SEC_EJEC->LinkCustomAttributes = "";
			$this->SEC_EJEC->HrefValue = "";
			$this->SEC_EJEC->TooltipValue = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->LinkCustomAttributes = "";
			$this->TIPO_MODALIDAD->HrefValue = "";
			$this->TIPO_MODALIDAD->TooltipValue = "";

			// SECUENCIA
			$this->SECUENCIA->LinkCustomAttributes = "";
			$this->SECUENCIA->HrefValue = "";
			$this->SECUENCIA->TooltipValue = "";

			// AMBIENTE
			$this->AMBIENTE->LinkCustomAttributes = "";
			$this->AMBIENTE->HrefValue = "";
			$this->AMBIENTE->TooltipValue = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->LinkCustomAttributes = "";
			$this->RUC_ENTIDAD->HrefValue = "";
			$this->RUC_ENTIDAD->TooltipValue = "";

			// LOCAL
			$this->LOCAL->LinkCustomAttributes = "";
			$this->LOCAL->HrefValue = "";
			$this->LOCAL->TooltipValue = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->LinkCustomAttributes = "";
			$this->DEPARTAMENTO->HrefValue = "";
			$this->DEPARTAMENTO->TooltipValue = "";

			// PROVINCIA
			$this->PROVINCIA->LinkCustomAttributes = "";
			$this->PROVINCIA->HrefValue = "";
			$this->PROVINCIA->TooltipValue = "";

			// DISTRITO
			$this->DISTRITO->LinkCustomAttributes = "";
			$this->DISTRITO->HrefValue = "";
			$this->DISTRITO->TooltipValue = "";

			// AREA
			$this->AREA->LinkCustomAttributes = "";
			$this->AREA->HrefValue = "";
			$this->AREA->TooltipValue = "";

			// OFICINA
			$this->OFICINA->LinkCustomAttributes = "";
			$this->OFICINA->HrefValue = "";
			$this->OFICINA->TooltipValue = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->LinkCustomAttributes = "";
			$this->PISO_OFICINA->HrefValue = "";
			$this->PISO_OFICINA->TooltipValue = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->LinkCustomAttributes = "";
			$this->NRO_DOC_IDENT_PERSONAL->HrefValue = "";
			$this->NRO_DOC_IDENT_PERSONAL->TooltipValue = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_PATERNO->HrefValue = "";
			$this->APELLIDO_PATERNO->TooltipValue = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_MATERNO->HrefValue = "";
			$this->APELLIDO_MATERNO->TooltipValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";
			$this->NOMBRES->TooltipValue = "";

			// OPERATIVO
			$this->OPERATIVO->LinkCustomAttributes = "";
			$this->OPERATIVO->HrefValue = "";
			$this->OPERATIVO->TooltipValue = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->LinkCustomAttributes = "";
			$this->TIPO_DOC_IDENTIDAD->HrefValue = "";
			$this->TIPO_DOC_IDENTIDAD->TooltipValue = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->LinkCustomAttributes = "";
			$this->MODALIDAD_CONTRATO->HrefValue = "";
			$this->MODALIDAD_CONTRATO->TooltipValue = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->LinkCustomAttributes = "";
			$this->CODIGO_PATRIMONIAL->HrefValue = "";
			$this->CODIGO_PATRIMONIAL->TooltipValue = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->LinkCustomAttributes = "";
			$this->DENOMINACION_BIEN->HrefValue = "";
			$this->DENOMINACION_BIEN->TooltipValue = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->LinkCustomAttributes = "";
			$this->TIPO_CAUSAL_ALTA->HrefValue = "";
			$this->TIPO_CAUSAL_ALTA->TooltipValue = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->LinkCustomAttributes = "";
			$this->NRO_DOC_ADQUISICION->HrefValue = "";
			$this->NRO_DOC_ADQUISICION->TooltipValue = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->LinkCustomAttributes = "";
			$this->FECHA_ADQUISICION->HrefValue = "";
			$this->FECHA_ADQUISICION->TooltipValue = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->LinkCustomAttributes = "";
			$this->VALOR_ADQUISICION->HrefValue = "";
			$this->VALOR_ADQUISICION->TooltipValue = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->LinkCustomAttributes = "";
			$this->FECHA_DEPRECIACION->HrefValue = "";
			$this->FECHA_DEPRECIACION->TooltipValue = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_EJERCICIO->HrefValue = "";
			$this->VALOR_DEPREC_EJERCICIO->TooltipValue = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_ACUMULADO->HrefValue = "";
			$this->VALOR_DEPREC_ACUMULADO->TooltipValue = "";

			// VALOR_NETO
			$this->VALOR_NETO->LinkCustomAttributes = "";
			$this->VALOR_NETO->HrefValue = "";
			$this->VALOR_NETO->TooltipValue = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->LinkCustomAttributes = "";
			$this->TIP_USO_CUENTA->HrefValue = "";
			$this->TIP_USO_CUENTA->TooltipValue = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->LinkCustomAttributes = "";
			$this->TIPO_CUENTA->HrefValue = "";
			$this->TIPO_CUENTA->TooltipValue = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->LinkCustomAttributes = "";
			$this->NRO_CUENTA_CONTABLE->HrefValue = "";
			$this->NRO_CUENTA_CONTABLE->TooltipValue = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->LinkCustomAttributes = "";
			$this->CTA_CON_SEGURO->HrefValue = "";
			$this->CTA_CON_SEGURO->TooltipValue = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->LinkCustomAttributes = "";
			$this->ESTADO_BIEN->HrefValue = "";
			$this->ESTADO_BIEN->TooltipValue = "";

			// CONDICION
			$this->CONDICION->LinkCustomAttributes = "";
			$this->CONDICION->HrefValue = "";
			$this->CONDICION->TooltipValue = "";

			// MARCA
			$this->MARCA->LinkCustomAttributes = "";
			$this->MARCA->HrefValue = "";
			$this->MARCA->TooltipValue = "";

			// MODELO
			$this->MODELO->LinkCustomAttributes = "";
			$this->MODELO->HrefValue = "";
			$this->MODELO->TooltipValue = "";

			// TIPO
			$this->TIPO->LinkCustomAttributes = "";
			$this->TIPO->HrefValue = "";
			$this->TIPO->TooltipValue = "";

			// COLOR
			$this->COLOR->LinkCustomAttributes = "";
			$this->COLOR->HrefValue = "";
			$this->COLOR->TooltipValue = "";

			// SERIE
			$this->SERIE->LinkCustomAttributes = "";
			$this->SERIE->HrefValue = "";
			$this->SERIE->TooltipValue = "";

			// DIMENSION
			$this->DIMENSION->LinkCustomAttributes = "";
			$this->DIMENSION->HrefValue = "";
			$this->DIMENSION->TooltipValue = "";

			// PLACA
			$this->PLACA->LinkCustomAttributes = "";
			$this->PLACA->HrefValue = "";
			$this->PLACA->TooltipValue = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->LinkCustomAttributes = "";
			$this->NRO_MOTOR->HrefValue = "";
			$this->NRO_MOTOR->TooltipValue = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->LinkCustomAttributes = "";
			$this->NRO_CHASIS->HrefValue = "";
			$this->NRO_CHASIS->TooltipValue = "";

			// MATRICULA
			$this->MATRICULA->LinkCustomAttributes = "";
			$this->MATRICULA->HrefValue = "";
			$this->MATRICULA->TooltipValue = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->LinkCustomAttributes = "";
			$this->ANIO_FABRICACION->HrefValue = "";
			$this->ANIO_FABRICACION->TooltipValue = "";

			// LONGITUD
			$this->LONGITUD->LinkCustomAttributes = "";
			$this->LONGITUD->HrefValue = "";
			$this->LONGITUD->TooltipValue = "";

			// ALTURA
			$this->ALTURA->LinkCustomAttributes = "";
			$this->ALTURA->HrefValue = "";
			$this->ALTURA->TooltipValue = "";

			// ANCHO
			$this->ANCHO->LinkCustomAttributes = "";
			$this->ANCHO->HrefValue = "";
			$this->ANCHO->TooltipValue = "";

			// RAZA
			$this->RAZA->LinkCustomAttributes = "";
			$this->RAZA->HrefValue = "";
			$this->RAZA->TooltipValue = "";

			// ESPECIE
			$this->ESPECIE->LinkCustomAttributes = "";
			$this->ESPECIE->HrefValue = "";
			$this->ESPECIE->TooltipValue = "";

			// EDAD
			$this->EDAD->LinkCustomAttributes = "";
			$this->EDAD->HrefValue = "";
			$this->EDAD->TooltipValue = "";

			// PAIS
			$this->PAIS->LinkCustomAttributes = "";
			$this->PAIS->HrefValue = "";
			$this->PAIS->TooltipValue = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->LinkCustomAttributes = "";
			$this->OTRAS_CARACT->HrefValue = "";
			$this->OTRAS_CARACT->TooltipValue = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->LinkCustomAttributes = "";
			$this->DESCRIPCION_UBICACION_BIEN->HrefValue = "";
			$this->DESCRIPCION_UBICACION_BIEN->TooltipValue = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->LinkCustomAttributes = "";
			$this->CAUSAL_BAJA->HrefValue = "";
			$this->CAUSAL_BAJA->TooltipValue = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_BAJA->HrefValue = "";
			$this->NRO_RESOLUCION_BAJA->TooltipValue = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->LinkCustomAttributes = "";
			$this->FECHA_BAJA->HrefValue = "";
			$this->FECHA_BAJA->TooltipValue = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_DISPOSICION_BIEN->HrefValue = "";
			$this->ACTO_DISPOSICION_BIEN->TooltipValue = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_DISP->HrefValue = "";
			$this->NRO_RESOLUCION_DISP->TooltipValue = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->LinkCustomAttributes = "";
			$this->FECHA_DISPOSICION->HrefValue = "";
			$this->FECHA_DISPOSICION->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->TooltipValue = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->LinkCustomAttributes = "";
			$this->MOTIVO_ELIMINACION_BIEN->HrefValue = "";
			$this->MOTIVO_ELIMINACION_BIEN->TooltipValue = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_ADMINISTRACION_BIEN->HrefValue = "";
			$this->ACTO_ADMINISTRACION_BIEN->TooltipValue = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->LinkCustomAttributes = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->HrefValue = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->TooltipValue = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->LinkCustomAttributes = "";
			$this->FECHA_ADMINISTRACION->HrefValue = "";
			$this->FECHA_ADMINISTRACION->TooltipValue = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->FECHA_VENC_ACTO_ADMIN->HrefValue = "";
			$this->FECHA_VENC_ACTO_ADMIN->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->TooltipValue = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->LinkCustomAttributes = "";
			$this->DOC_ALTA_SBN->HrefValue = "";
			$this->DOC_ALTA_SBN->TooltipValue = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->LinkCustomAttributes = "";
			$this->DOC_BAJA_SBN->HrefValue = "";
			$this->DOC_BAJA_SBN->TooltipValue = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->LinkCustomAttributes = "";
			$this->DEPENDENCIAS->HrefValue = "";
			$this->DEPENDENCIAS->TooltipValue = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->LinkCustomAttributes = "";
			$this->NUMERO_FICHA->HrefValue = "";
			$this->NUMERO_FICHA->TooltipValue = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->LinkCustomAttributes = "";
			$this->CODIGO_INTERNO->HrefValue = "";
			$this->CODIGO_INTERNO->TooltipValue = "";

			// ESTADO
			$this->ESTADO->LinkCustomAttributes = "";
			$this->ESTADO->HrefValue = "";
			$this->ESTADO->TooltipValue = "";

			// USO
			$this->USO->LinkCustomAttributes = "";
			$this->USO->HrefValue = "";
			$this->USO->TooltipValue = "";

			// STICKER
			$this->STICKER->LinkCustomAttributes = "";
			$this->STICKER->HrefValue = "";
			$this->STICKER->TooltipValue = "";

			// SEDE
			$this->SEDE->LinkCustomAttributes = "";
			$this->SEDE->HrefValue = "";
			$this->SEDE->TooltipValue = "";

			// SBN
			$this->SBN->LinkCustomAttributes = "";
			$this->SBN->HrefValue = "";
			$this->SBN->TooltipValue = "";

			// ETIQUETA
			$this->ETIQUETA->LinkCustomAttributes = "";
			$this->ETIQUETA->HrefValue = "";
			$this->ETIQUETA->TooltipValue = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->HrefValue = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->TooltipValue = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->LinkCustomAttributes = "";
			$this->PLACA_RODAJE->HrefValue = "";
			$this->PLACA_RODAJE->TooltipValue = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->LinkCustomAttributes = "";
			$this->CODIGO_ACTUAL->HrefValue = "";
			$this->CODIGO_ACTUAL->TooltipValue = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->LinkCustomAttributes = "";
			$this->CODIGO_ANTERIOR->HrefValue = "";
			$this->CODIGO_ANTERIOR->TooltipValue = "";

			// PROPIEDAD
			$this->PROPIEDAD->LinkCustomAttributes = "";
			$this->PROPIEDAD->HrefValue = "";
			$this->PROPIEDAD->TooltipValue = "";

			// SITUACION
			$this->SITUACION->LinkCustomAttributes = "";
			$this->SITUACION->HrefValue = "";
			$this->SITUACION->TooltipValue = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->LinkCustomAttributes = "";
			$this->OBSERVACIONES->HrefValue = "";
			$this->OBSERVACIONES->TooltipValue = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->LinkCustomAttributes = "";
			$this->FECHA_REGISTRO->HrefValue = "";
			$this->FECHA_REGISTRO->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// codigo_proceso
			$this->codigo_proceso->EditAttrs["class"] = "form-control";
			$this->codigo_proceso->EditCustomAttributes = "";
			$this->codigo_proceso->EditValue = HtmlEncode($this->codigo_proceso->CurrentValue);
			$this->codigo_proceso->PlaceHolder = RemoveHtml($this->codigo_proceso->caption());

			// no
			$this->no->EditAttrs["class"] = "form-control";
			$this->no->EditCustomAttributes = "";
			$this->no->EditValue = HtmlEncode($this->no->CurrentValue);
			$this->no->PlaceHolder = RemoveHtml($this->no->caption());

			// usuarios
			$this->usuarios->EditAttrs["class"] = "form-control";
			$this->usuarios->EditCustomAttributes = "";
			$this->usuarios->EditValue = HtmlEncode($this->usuarios->CurrentValue);
			$this->usuarios->PlaceHolder = RemoveHtml($this->usuarios->caption());

			// SEC_EJEC
			$this->SEC_EJEC->EditAttrs["class"] = "form-control";
			$this->SEC_EJEC->EditCustomAttributes = "";
			if (!$this->SEC_EJEC->Raw)
				$this->SEC_EJEC->CurrentValue = HtmlDecode($this->SEC_EJEC->CurrentValue);
			$this->SEC_EJEC->EditValue = HtmlEncode($this->SEC_EJEC->CurrentValue);
			$this->SEC_EJEC->PlaceHolder = RemoveHtml($this->SEC_EJEC->caption());

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->EditAttrs["class"] = "form-control";
			$this->TIPO_MODALIDAD->EditCustomAttributes = "";
			if (!$this->TIPO_MODALIDAD->Raw)
				$this->TIPO_MODALIDAD->CurrentValue = HtmlDecode($this->TIPO_MODALIDAD->CurrentValue);
			$this->TIPO_MODALIDAD->EditValue = HtmlEncode($this->TIPO_MODALIDAD->CurrentValue);
			$this->TIPO_MODALIDAD->PlaceHolder = RemoveHtml($this->TIPO_MODALIDAD->caption());

			// SECUENCIA
			$this->SECUENCIA->EditAttrs["class"] = "form-control";
			$this->SECUENCIA->EditCustomAttributes = "";
			if (!$this->SECUENCIA->Raw)
				$this->SECUENCIA->CurrentValue = HtmlDecode($this->SECUENCIA->CurrentValue);
			$this->SECUENCIA->EditValue = HtmlEncode($this->SECUENCIA->CurrentValue);
			$this->SECUENCIA->PlaceHolder = RemoveHtml($this->SECUENCIA->caption());

			// AMBIENTE
			$this->AMBIENTE->EditAttrs["class"] = "form-control";
			$this->AMBIENTE->EditCustomAttributes = "";
			if (!$this->AMBIENTE->Raw)
				$this->AMBIENTE->CurrentValue = HtmlDecode($this->AMBIENTE->CurrentValue);
			$this->AMBIENTE->EditValue = HtmlEncode($this->AMBIENTE->CurrentValue);
			$this->AMBIENTE->PlaceHolder = RemoveHtml($this->AMBIENTE->caption());

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->EditAttrs["class"] = "form-control";
			$this->RUC_ENTIDAD->EditCustomAttributes = "";
			if (!$this->RUC_ENTIDAD->Raw)
				$this->RUC_ENTIDAD->CurrentValue = HtmlDecode($this->RUC_ENTIDAD->CurrentValue);
			$this->RUC_ENTIDAD->EditValue = HtmlEncode($this->RUC_ENTIDAD->CurrentValue);
			$this->RUC_ENTIDAD->PlaceHolder = RemoveHtml($this->RUC_ENTIDAD->caption());

			// LOCAL
			$this->LOCAL->EditAttrs["class"] = "form-control";
			$this->LOCAL->EditCustomAttributes = "";
			if (!$this->LOCAL->Raw)
				$this->LOCAL->CurrentValue = HtmlDecode($this->LOCAL->CurrentValue);
			$this->LOCAL->EditValue = HtmlEncode($this->LOCAL->CurrentValue);
			$this->LOCAL->PlaceHolder = RemoveHtml($this->LOCAL->caption());

			// DEPARTAMENTO
			$this->DEPARTAMENTO->EditAttrs["class"] = "form-control";
			$this->DEPARTAMENTO->EditCustomAttributes = "";
			if (!$this->DEPARTAMENTO->Raw)
				$this->DEPARTAMENTO->CurrentValue = HtmlDecode($this->DEPARTAMENTO->CurrentValue);
			$this->DEPARTAMENTO->EditValue = HtmlEncode($this->DEPARTAMENTO->CurrentValue);
			$this->DEPARTAMENTO->PlaceHolder = RemoveHtml($this->DEPARTAMENTO->caption());

			// PROVINCIA
			$this->PROVINCIA->EditAttrs["class"] = "form-control";
			$this->PROVINCIA->EditCustomAttributes = "";
			if (!$this->PROVINCIA->Raw)
				$this->PROVINCIA->CurrentValue = HtmlDecode($this->PROVINCIA->CurrentValue);
			$this->PROVINCIA->EditValue = HtmlEncode($this->PROVINCIA->CurrentValue);
			$this->PROVINCIA->PlaceHolder = RemoveHtml($this->PROVINCIA->caption());

			// DISTRITO
			$this->DISTRITO->EditAttrs["class"] = "form-control";
			$this->DISTRITO->EditCustomAttributes = "";
			if (!$this->DISTRITO->Raw)
				$this->DISTRITO->CurrentValue = HtmlDecode($this->DISTRITO->CurrentValue);
			$this->DISTRITO->EditValue = HtmlEncode($this->DISTRITO->CurrentValue);
			$this->DISTRITO->PlaceHolder = RemoveHtml($this->DISTRITO->caption());

			// AREA
			$this->AREA->EditAttrs["class"] = "form-control";
			$this->AREA->EditCustomAttributes = "";
			if (!$this->AREA->Raw)
				$this->AREA->CurrentValue = HtmlDecode($this->AREA->CurrentValue);
			$this->AREA->EditValue = HtmlEncode($this->AREA->CurrentValue);
			$this->AREA->PlaceHolder = RemoveHtml($this->AREA->caption());

			// OFICINA
			$this->OFICINA->EditAttrs["class"] = "form-control";
			$this->OFICINA->EditCustomAttributes = "";
			if (!$this->OFICINA->Raw)
				$this->OFICINA->CurrentValue = HtmlDecode($this->OFICINA->CurrentValue);
			$this->OFICINA->EditValue = HtmlEncode($this->OFICINA->CurrentValue);
			$this->OFICINA->PlaceHolder = RemoveHtml($this->OFICINA->caption());

			// PISO_OFICINA
			$this->PISO_OFICINA->EditAttrs["class"] = "form-control";
			$this->PISO_OFICINA->EditCustomAttributes = "";
			if (!$this->PISO_OFICINA->Raw)
				$this->PISO_OFICINA->CurrentValue = HtmlDecode($this->PISO_OFICINA->CurrentValue);
			$this->PISO_OFICINA->EditValue = HtmlEncode($this->PISO_OFICINA->CurrentValue);
			$this->PISO_OFICINA->PlaceHolder = RemoveHtml($this->PISO_OFICINA->caption());

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->EditAttrs["class"] = "form-control";
			$this->NRO_DOC_IDENT_PERSONAL->EditCustomAttributes = "";
			if (!$this->NRO_DOC_IDENT_PERSONAL->Raw)
				$this->NRO_DOC_IDENT_PERSONAL->CurrentValue = HtmlDecode($this->NRO_DOC_IDENT_PERSONAL->CurrentValue);
			$this->NRO_DOC_IDENT_PERSONAL->EditValue = HtmlEncode($this->NRO_DOC_IDENT_PERSONAL->CurrentValue);
			$this->NRO_DOC_IDENT_PERSONAL->PlaceHolder = RemoveHtml($this->NRO_DOC_IDENT_PERSONAL->caption());

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->EditAttrs["class"] = "form-control";
			$this->APELLIDO_PATERNO->EditCustomAttributes = "";
			if (!$this->APELLIDO_PATERNO->Raw)
				$this->APELLIDO_PATERNO->CurrentValue = HtmlDecode($this->APELLIDO_PATERNO->CurrentValue);
			$this->APELLIDO_PATERNO->EditValue = HtmlEncode($this->APELLIDO_PATERNO->CurrentValue);
			$this->APELLIDO_PATERNO->PlaceHolder = RemoveHtml($this->APELLIDO_PATERNO->caption());

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->EditAttrs["class"] = "form-control";
			$this->APELLIDO_MATERNO->EditCustomAttributes = "";
			if (!$this->APELLIDO_MATERNO->Raw)
				$this->APELLIDO_MATERNO->CurrentValue = HtmlDecode($this->APELLIDO_MATERNO->CurrentValue);
			$this->APELLIDO_MATERNO->EditValue = HtmlEncode($this->APELLIDO_MATERNO->CurrentValue);
			$this->APELLIDO_MATERNO->PlaceHolder = RemoveHtml($this->APELLIDO_MATERNO->caption());

			// NOMBRES
			$this->NOMBRES->EditAttrs["class"] = "form-control";
			$this->NOMBRES->EditCustomAttributes = "";
			if (!$this->NOMBRES->Raw)
				$this->NOMBRES->CurrentValue = HtmlDecode($this->NOMBRES->CurrentValue);
			$this->NOMBRES->EditValue = HtmlEncode($this->NOMBRES->CurrentValue);
			$this->NOMBRES->PlaceHolder = RemoveHtml($this->NOMBRES->caption());

			// OPERATIVO
			$this->OPERATIVO->EditAttrs["class"] = "form-control";
			$this->OPERATIVO->EditCustomAttributes = "";
			if (!$this->OPERATIVO->Raw)
				$this->OPERATIVO->CurrentValue = HtmlDecode($this->OPERATIVO->CurrentValue);
			$this->OPERATIVO->EditValue = HtmlEncode($this->OPERATIVO->CurrentValue);
			$this->OPERATIVO->PlaceHolder = RemoveHtml($this->OPERATIVO->caption());

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->EditAttrs["class"] = "form-control";
			$this->TIPO_DOC_IDENTIDAD->EditCustomAttributes = "";
			if (!$this->TIPO_DOC_IDENTIDAD->Raw)
				$this->TIPO_DOC_IDENTIDAD->CurrentValue = HtmlDecode($this->TIPO_DOC_IDENTIDAD->CurrentValue);
			$this->TIPO_DOC_IDENTIDAD->EditValue = HtmlEncode($this->TIPO_DOC_IDENTIDAD->CurrentValue);
			$this->TIPO_DOC_IDENTIDAD->PlaceHolder = RemoveHtml($this->TIPO_DOC_IDENTIDAD->caption());

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->EditAttrs["class"] = "form-control";
			$this->MODALIDAD_CONTRATO->EditCustomAttributes = "";
			if (!$this->MODALIDAD_CONTRATO->Raw)
				$this->MODALIDAD_CONTRATO->CurrentValue = HtmlDecode($this->MODALIDAD_CONTRATO->CurrentValue);
			$this->MODALIDAD_CONTRATO->EditValue = HtmlEncode($this->MODALIDAD_CONTRATO->CurrentValue);
			$this->MODALIDAD_CONTRATO->PlaceHolder = RemoveHtml($this->MODALIDAD_CONTRATO->caption());

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->EditAttrs["class"] = "form-control";
			$this->CODIGO_PATRIMONIAL->EditCustomAttributes = "";
			if (!$this->CODIGO_PATRIMONIAL->Raw)
				$this->CODIGO_PATRIMONIAL->CurrentValue = HtmlDecode($this->CODIGO_PATRIMONIAL->CurrentValue);
			$this->CODIGO_PATRIMONIAL->EditValue = HtmlEncode($this->CODIGO_PATRIMONIAL->CurrentValue);
			$this->CODIGO_PATRIMONIAL->PlaceHolder = RemoveHtml($this->CODIGO_PATRIMONIAL->caption());

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->EditAttrs["class"] = "form-control";
			$this->DENOMINACION_BIEN->EditCustomAttributes = "";
			if (!$this->DENOMINACION_BIEN->Raw)
				$this->DENOMINACION_BIEN->CurrentValue = HtmlDecode($this->DENOMINACION_BIEN->CurrentValue);
			$this->DENOMINACION_BIEN->EditValue = HtmlEncode($this->DENOMINACION_BIEN->CurrentValue);
			$this->DENOMINACION_BIEN->PlaceHolder = RemoveHtml($this->DENOMINACION_BIEN->caption());

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->EditAttrs["class"] = "form-control";
			$this->TIPO_CAUSAL_ALTA->EditCustomAttributes = "";
			if (!$this->TIPO_CAUSAL_ALTA->Raw)
				$this->TIPO_CAUSAL_ALTA->CurrentValue = HtmlDecode($this->TIPO_CAUSAL_ALTA->CurrentValue);
			$this->TIPO_CAUSAL_ALTA->EditValue = HtmlEncode($this->TIPO_CAUSAL_ALTA->CurrentValue);
			$this->TIPO_CAUSAL_ALTA->PlaceHolder = RemoveHtml($this->TIPO_CAUSAL_ALTA->caption());

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->EditAttrs["class"] = "form-control";
			$this->NRO_DOC_ADQUISICION->EditCustomAttributes = "";
			if (!$this->NRO_DOC_ADQUISICION->Raw)
				$this->NRO_DOC_ADQUISICION->CurrentValue = HtmlDecode($this->NRO_DOC_ADQUISICION->CurrentValue);
			$this->NRO_DOC_ADQUISICION->EditValue = HtmlEncode($this->NRO_DOC_ADQUISICION->CurrentValue);
			$this->NRO_DOC_ADQUISICION->PlaceHolder = RemoveHtml($this->NRO_DOC_ADQUISICION->caption());

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->EditAttrs["class"] = "form-control";
			$this->FECHA_ADQUISICION->EditCustomAttributes = "";
			if (!$this->FECHA_ADQUISICION->Raw)
				$this->FECHA_ADQUISICION->CurrentValue = HtmlDecode($this->FECHA_ADQUISICION->CurrentValue);
			$this->FECHA_ADQUISICION->EditValue = HtmlEncode($this->FECHA_ADQUISICION->CurrentValue);
			$this->FECHA_ADQUISICION->PlaceHolder = RemoveHtml($this->FECHA_ADQUISICION->caption());

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->EditAttrs["class"] = "form-control";
			$this->VALOR_ADQUISICION->EditCustomAttributes = "";
			if (!$this->VALOR_ADQUISICION->Raw)
				$this->VALOR_ADQUISICION->CurrentValue = HtmlDecode($this->VALOR_ADQUISICION->CurrentValue);
			$this->VALOR_ADQUISICION->EditValue = HtmlEncode($this->VALOR_ADQUISICION->CurrentValue);
			$this->VALOR_ADQUISICION->PlaceHolder = RemoveHtml($this->VALOR_ADQUISICION->caption());

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->EditAttrs["class"] = "form-control";
			$this->FECHA_DEPRECIACION->EditCustomAttributes = "";
			if (!$this->FECHA_DEPRECIACION->Raw)
				$this->FECHA_DEPRECIACION->CurrentValue = HtmlDecode($this->FECHA_DEPRECIACION->CurrentValue);
			$this->FECHA_DEPRECIACION->EditValue = HtmlEncode($this->FECHA_DEPRECIACION->CurrentValue);
			$this->FECHA_DEPRECIACION->PlaceHolder = RemoveHtml($this->FECHA_DEPRECIACION->caption());

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->EditAttrs["class"] = "form-control";
			$this->VALOR_DEPREC_EJERCICIO->EditCustomAttributes = "";
			if (!$this->VALOR_DEPREC_EJERCICIO->Raw)
				$this->VALOR_DEPREC_EJERCICIO->CurrentValue = HtmlDecode($this->VALOR_DEPREC_EJERCICIO->CurrentValue);
			$this->VALOR_DEPREC_EJERCICIO->EditValue = HtmlEncode($this->VALOR_DEPREC_EJERCICIO->CurrentValue);
			$this->VALOR_DEPREC_EJERCICIO->PlaceHolder = RemoveHtml($this->VALOR_DEPREC_EJERCICIO->caption());

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->EditAttrs["class"] = "form-control";
			$this->VALOR_DEPREC_ACUMULADO->EditCustomAttributes = "";
			if (!$this->VALOR_DEPREC_ACUMULADO->Raw)
				$this->VALOR_DEPREC_ACUMULADO->CurrentValue = HtmlDecode($this->VALOR_DEPREC_ACUMULADO->CurrentValue);
			$this->VALOR_DEPREC_ACUMULADO->EditValue = HtmlEncode($this->VALOR_DEPREC_ACUMULADO->CurrentValue);
			$this->VALOR_DEPREC_ACUMULADO->PlaceHolder = RemoveHtml($this->VALOR_DEPREC_ACUMULADO->caption());

			// VALOR_NETO
			$this->VALOR_NETO->EditAttrs["class"] = "form-control";
			$this->VALOR_NETO->EditCustomAttributes = "";
			if (!$this->VALOR_NETO->Raw)
				$this->VALOR_NETO->CurrentValue = HtmlDecode($this->VALOR_NETO->CurrentValue);
			$this->VALOR_NETO->EditValue = HtmlEncode($this->VALOR_NETO->CurrentValue);
			$this->VALOR_NETO->PlaceHolder = RemoveHtml($this->VALOR_NETO->caption());

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->EditAttrs["class"] = "form-control";
			$this->TIP_USO_CUENTA->EditCustomAttributes = "";
			if (!$this->TIP_USO_CUENTA->Raw)
				$this->TIP_USO_CUENTA->CurrentValue = HtmlDecode($this->TIP_USO_CUENTA->CurrentValue);
			$this->TIP_USO_CUENTA->EditValue = HtmlEncode($this->TIP_USO_CUENTA->CurrentValue);
			$this->TIP_USO_CUENTA->PlaceHolder = RemoveHtml($this->TIP_USO_CUENTA->caption());

			// TIPO_CUENTA
			$this->TIPO_CUENTA->EditAttrs["class"] = "form-control";
			$this->TIPO_CUENTA->EditCustomAttributes = "";
			if (!$this->TIPO_CUENTA->Raw)
				$this->TIPO_CUENTA->CurrentValue = HtmlDecode($this->TIPO_CUENTA->CurrentValue);
			$this->TIPO_CUENTA->EditValue = HtmlEncode($this->TIPO_CUENTA->CurrentValue);
			$this->TIPO_CUENTA->PlaceHolder = RemoveHtml($this->TIPO_CUENTA->caption());

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->EditAttrs["class"] = "form-control";
			$this->NRO_CUENTA_CONTABLE->EditCustomAttributes = "";
			if (!$this->NRO_CUENTA_CONTABLE->Raw)
				$this->NRO_CUENTA_CONTABLE->CurrentValue = HtmlDecode($this->NRO_CUENTA_CONTABLE->CurrentValue);
			$this->NRO_CUENTA_CONTABLE->EditValue = HtmlEncode($this->NRO_CUENTA_CONTABLE->CurrentValue);
			$this->NRO_CUENTA_CONTABLE->PlaceHolder = RemoveHtml($this->NRO_CUENTA_CONTABLE->caption());

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->EditAttrs["class"] = "form-control";
			$this->CTA_CON_SEGURO->EditCustomAttributes = "";
			if (!$this->CTA_CON_SEGURO->Raw)
				$this->CTA_CON_SEGURO->CurrentValue = HtmlDecode($this->CTA_CON_SEGURO->CurrentValue);
			$this->CTA_CON_SEGURO->EditValue = HtmlEncode($this->CTA_CON_SEGURO->CurrentValue);
			$this->CTA_CON_SEGURO->PlaceHolder = RemoveHtml($this->CTA_CON_SEGURO->caption());

			// ESTADO_BIEN
			$this->ESTADO_BIEN->EditAttrs["class"] = "form-control";
			$this->ESTADO_BIEN->EditCustomAttributes = "";
			if (!$this->ESTADO_BIEN->Raw)
				$this->ESTADO_BIEN->CurrentValue = HtmlDecode($this->ESTADO_BIEN->CurrentValue);
			$this->ESTADO_BIEN->EditValue = HtmlEncode($this->ESTADO_BIEN->CurrentValue);
			$this->ESTADO_BIEN->PlaceHolder = RemoveHtml($this->ESTADO_BIEN->caption());

			// CONDICION
			$this->CONDICION->EditAttrs["class"] = "form-control";
			$this->CONDICION->EditCustomAttributes = "";
			if (!$this->CONDICION->Raw)
				$this->CONDICION->CurrentValue = HtmlDecode($this->CONDICION->CurrentValue);
			$this->CONDICION->EditValue = HtmlEncode($this->CONDICION->CurrentValue);
			$this->CONDICION->PlaceHolder = RemoveHtml($this->CONDICION->caption());

			// MARCA
			$this->MARCA->EditAttrs["class"] = "form-control";
			$this->MARCA->EditCustomAttributes = "";
			if (!$this->MARCA->Raw)
				$this->MARCA->CurrentValue = HtmlDecode($this->MARCA->CurrentValue);
			$this->MARCA->EditValue = HtmlEncode($this->MARCA->CurrentValue);
			$this->MARCA->PlaceHolder = RemoveHtml($this->MARCA->caption());

			// MODELO
			$this->MODELO->EditAttrs["class"] = "form-control";
			$this->MODELO->EditCustomAttributes = "";
			if (!$this->MODELO->Raw)
				$this->MODELO->CurrentValue = HtmlDecode($this->MODELO->CurrentValue);
			$this->MODELO->EditValue = HtmlEncode($this->MODELO->CurrentValue);
			$this->MODELO->PlaceHolder = RemoveHtml($this->MODELO->caption());

			// TIPO
			$this->TIPO->EditAttrs["class"] = "form-control";
			$this->TIPO->EditCustomAttributes = "";
			if (!$this->TIPO->Raw)
				$this->TIPO->CurrentValue = HtmlDecode($this->TIPO->CurrentValue);
			$this->TIPO->EditValue = HtmlEncode($this->TIPO->CurrentValue);
			$this->TIPO->PlaceHolder = RemoveHtml($this->TIPO->caption());

			// COLOR
			$this->COLOR->EditAttrs["class"] = "form-control";
			$this->COLOR->EditCustomAttributes = "";
			if (!$this->COLOR->Raw)
				$this->COLOR->CurrentValue = HtmlDecode($this->COLOR->CurrentValue);
			$this->COLOR->EditValue = HtmlEncode($this->COLOR->CurrentValue);
			$this->COLOR->PlaceHolder = RemoveHtml($this->COLOR->caption());

			// SERIE
			$this->SERIE->EditAttrs["class"] = "form-control";
			$this->SERIE->EditCustomAttributes = "";
			if (!$this->SERIE->Raw)
				$this->SERIE->CurrentValue = HtmlDecode($this->SERIE->CurrentValue);
			$this->SERIE->EditValue = HtmlEncode($this->SERIE->CurrentValue);
			$this->SERIE->PlaceHolder = RemoveHtml($this->SERIE->caption());

			// DIMENSION
			$this->DIMENSION->EditAttrs["class"] = "form-control";
			$this->DIMENSION->EditCustomAttributes = "";
			if (!$this->DIMENSION->Raw)
				$this->DIMENSION->CurrentValue = HtmlDecode($this->DIMENSION->CurrentValue);
			$this->DIMENSION->EditValue = HtmlEncode($this->DIMENSION->CurrentValue);
			$this->DIMENSION->PlaceHolder = RemoveHtml($this->DIMENSION->caption());

			// PLACA
			$this->PLACA->EditAttrs["class"] = "form-control";
			$this->PLACA->EditCustomAttributes = "";
			if (!$this->PLACA->Raw)
				$this->PLACA->CurrentValue = HtmlDecode($this->PLACA->CurrentValue);
			$this->PLACA->EditValue = HtmlEncode($this->PLACA->CurrentValue);
			$this->PLACA->PlaceHolder = RemoveHtml($this->PLACA->caption());

			// NRO_MOTOR
			$this->NRO_MOTOR->EditAttrs["class"] = "form-control";
			$this->NRO_MOTOR->EditCustomAttributes = "";
			if (!$this->NRO_MOTOR->Raw)
				$this->NRO_MOTOR->CurrentValue = HtmlDecode($this->NRO_MOTOR->CurrentValue);
			$this->NRO_MOTOR->EditValue = HtmlEncode($this->NRO_MOTOR->CurrentValue);
			$this->NRO_MOTOR->PlaceHolder = RemoveHtml($this->NRO_MOTOR->caption());

			// NRO_CHASIS
			$this->NRO_CHASIS->EditAttrs["class"] = "form-control";
			$this->NRO_CHASIS->EditCustomAttributes = "";
			if (!$this->NRO_CHASIS->Raw)
				$this->NRO_CHASIS->CurrentValue = HtmlDecode($this->NRO_CHASIS->CurrentValue);
			$this->NRO_CHASIS->EditValue = HtmlEncode($this->NRO_CHASIS->CurrentValue);
			$this->NRO_CHASIS->PlaceHolder = RemoveHtml($this->NRO_CHASIS->caption());

			// MATRICULA
			$this->MATRICULA->EditAttrs["class"] = "form-control";
			$this->MATRICULA->EditCustomAttributes = "";
			if (!$this->MATRICULA->Raw)
				$this->MATRICULA->CurrentValue = HtmlDecode($this->MATRICULA->CurrentValue);
			$this->MATRICULA->EditValue = HtmlEncode($this->MATRICULA->CurrentValue);
			$this->MATRICULA->PlaceHolder = RemoveHtml($this->MATRICULA->caption());

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->EditAttrs["class"] = "form-control";
			$this->ANIO_FABRICACION->EditCustomAttributes = "";
			if (!$this->ANIO_FABRICACION->Raw)
				$this->ANIO_FABRICACION->CurrentValue = HtmlDecode($this->ANIO_FABRICACION->CurrentValue);
			$this->ANIO_FABRICACION->EditValue = HtmlEncode($this->ANIO_FABRICACION->CurrentValue);
			$this->ANIO_FABRICACION->PlaceHolder = RemoveHtml($this->ANIO_FABRICACION->caption());

			// LONGITUD
			$this->LONGITUD->EditAttrs["class"] = "form-control";
			$this->LONGITUD->EditCustomAttributes = "";
			if (!$this->LONGITUD->Raw)
				$this->LONGITUD->CurrentValue = HtmlDecode($this->LONGITUD->CurrentValue);
			$this->LONGITUD->EditValue = HtmlEncode($this->LONGITUD->CurrentValue);
			$this->LONGITUD->PlaceHolder = RemoveHtml($this->LONGITUD->caption());

			// ALTURA
			$this->ALTURA->EditAttrs["class"] = "form-control";
			$this->ALTURA->EditCustomAttributes = "";
			if (!$this->ALTURA->Raw)
				$this->ALTURA->CurrentValue = HtmlDecode($this->ALTURA->CurrentValue);
			$this->ALTURA->EditValue = HtmlEncode($this->ALTURA->CurrentValue);
			$this->ALTURA->PlaceHolder = RemoveHtml($this->ALTURA->caption());

			// ANCHO
			$this->ANCHO->EditAttrs["class"] = "form-control";
			$this->ANCHO->EditCustomAttributes = "";
			if (!$this->ANCHO->Raw)
				$this->ANCHO->CurrentValue = HtmlDecode($this->ANCHO->CurrentValue);
			$this->ANCHO->EditValue = HtmlEncode($this->ANCHO->CurrentValue);
			$this->ANCHO->PlaceHolder = RemoveHtml($this->ANCHO->caption());

			// RAZA
			$this->RAZA->EditAttrs["class"] = "form-control";
			$this->RAZA->EditCustomAttributes = "";
			if (!$this->RAZA->Raw)
				$this->RAZA->CurrentValue = HtmlDecode($this->RAZA->CurrentValue);
			$this->RAZA->EditValue = HtmlEncode($this->RAZA->CurrentValue);
			$this->RAZA->PlaceHolder = RemoveHtml($this->RAZA->caption());

			// ESPECIE
			$this->ESPECIE->EditAttrs["class"] = "form-control";
			$this->ESPECIE->EditCustomAttributes = "";
			if (!$this->ESPECIE->Raw)
				$this->ESPECIE->CurrentValue = HtmlDecode($this->ESPECIE->CurrentValue);
			$this->ESPECIE->EditValue = HtmlEncode($this->ESPECIE->CurrentValue);
			$this->ESPECIE->PlaceHolder = RemoveHtml($this->ESPECIE->caption());

			// EDAD
			$this->EDAD->EditAttrs["class"] = "form-control";
			$this->EDAD->EditCustomAttributes = "";
			if (!$this->EDAD->Raw)
				$this->EDAD->CurrentValue = HtmlDecode($this->EDAD->CurrentValue);
			$this->EDAD->EditValue = HtmlEncode($this->EDAD->CurrentValue);
			$this->EDAD->PlaceHolder = RemoveHtml($this->EDAD->caption());

			// PAIS
			$this->PAIS->EditAttrs["class"] = "form-control";
			$this->PAIS->EditCustomAttributes = "";
			if (!$this->PAIS->Raw)
				$this->PAIS->CurrentValue = HtmlDecode($this->PAIS->CurrentValue);
			$this->PAIS->EditValue = HtmlEncode($this->PAIS->CurrentValue);
			$this->PAIS->PlaceHolder = RemoveHtml($this->PAIS->caption());

			// OTRAS_CARACT
			$this->OTRAS_CARACT->EditAttrs["class"] = "form-control";
			$this->OTRAS_CARACT->EditCustomAttributes = "";
			if (!$this->OTRAS_CARACT->Raw)
				$this->OTRAS_CARACT->CurrentValue = HtmlDecode($this->OTRAS_CARACT->CurrentValue);
			$this->OTRAS_CARACT->EditValue = HtmlEncode($this->OTRAS_CARACT->CurrentValue);
			$this->OTRAS_CARACT->PlaceHolder = RemoveHtml($this->OTRAS_CARACT->caption());

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->EditAttrs["class"] = "form-control";
			$this->DESCRIPCION_UBICACION_BIEN->EditCustomAttributes = "";
			if (!$this->DESCRIPCION_UBICACION_BIEN->Raw)
				$this->DESCRIPCION_UBICACION_BIEN->CurrentValue = HtmlDecode($this->DESCRIPCION_UBICACION_BIEN->CurrentValue);
			$this->DESCRIPCION_UBICACION_BIEN->EditValue = HtmlEncode($this->DESCRIPCION_UBICACION_BIEN->CurrentValue);
			$this->DESCRIPCION_UBICACION_BIEN->PlaceHolder = RemoveHtml($this->DESCRIPCION_UBICACION_BIEN->caption());

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->EditAttrs["class"] = "form-control";
			$this->CAUSAL_BAJA->EditCustomAttributes = "";
			if (!$this->CAUSAL_BAJA->Raw)
				$this->CAUSAL_BAJA->CurrentValue = HtmlDecode($this->CAUSAL_BAJA->CurrentValue);
			$this->CAUSAL_BAJA->EditValue = HtmlEncode($this->CAUSAL_BAJA->CurrentValue);
			$this->CAUSAL_BAJA->PlaceHolder = RemoveHtml($this->CAUSAL_BAJA->caption());

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->EditAttrs["class"] = "form-control";
			$this->NRO_RESOLUCION_BAJA->EditCustomAttributes = "";
			if (!$this->NRO_RESOLUCION_BAJA->Raw)
				$this->NRO_RESOLUCION_BAJA->CurrentValue = HtmlDecode($this->NRO_RESOLUCION_BAJA->CurrentValue);
			$this->NRO_RESOLUCION_BAJA->EditValue = HtmlEncode($this->NRO_RESOLUCION_BAJA->CurrentValue);
			$this->NRO_RESOLUCION_BAJA->PlaceHolder = RemoveHtml($this->NRO_RESOLUCION_BAJA->caption());

			// FECHA_BAJA
			$this->FECHA_BAJA->EditAttrs["class"] = "form-control";
			$this->FECHA_BAJA->EditCustomAttributes = "";
			if (!$this->FECHA_BAJA->Raw)
				$this->FECHA_BAJA->CurrentValue = HtmlDecode($this->FECHA_BAJA->CurrentValue);
			$this->FECHA_BAJA->EditValue = HtmlEncode($this->FECHA_BAJA->CurrentValue);
			$this->FECHA_BAJA->PlaceHolder = RemoveHtml($this->FECHA_BAJA->caption());

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->EditAttrs["class"] = "form-control";
			$this->ACTO_DISPOSICION_BIEN->EditCustomAttributes = "";
			if (!$this->ACTO_DISPOSICION_BIEN->Raw)
				$this->ACTO_DISPOSICION_BIEN->CurrentValue = HtmlDecode($this->ACTO_DISPOSICION_BIEN->CurrentValue);
			$this->ACTO_DISPOSICION_BIEN->EditValue = HtmlEncode($this->ACTO_DISPOSICION_BIEN->CurrentValue);
			$this->ACTO_DISPOSICION_BIEN->PlaceHolder = RemoveHtml($this->ACTO_DISPOSICION_BIEN->caption());

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->EditAttrs["class"] = "form-control";
			$this->NRO_RESOLUCION_DISP->EditCustomAttributes = "";
			if (!$this->NRO_RESOLUCION_DISP->Raw)
				$this->NRO_RESOLUCION_DISP->CurrentValue = HtmlDecode($this->NRO_RESOLUCION_DISP->CurrentValue);
			$this->NRO_RESOLUCION_DISP->EditValue = HtmlEncode($this->NRO_RESOLUCION_DISP->CurrentValue);
			$this->NRO_RESOLUCION_DISP->PlaceHolder = RemoveHtml($this->NRO_RESOLUCION_DISP->caption());

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->EditAttrs["class"] = "form-control";
			$this->FECHA_DISPOSICION->EditCustomAttributes = "";
			if (!$this->FECHA_DISPOSICION->Raw)
				$this->FECHA_DISPOSICION->CurrentValue = HtmlDecode($this->FECHA_DISPOSICION->CurrentValue);
			$this->FECHA_DISPOSICION->EditValue = HtmlEncode($this->FECHA_DISPOSICION->CurrentValue);
			$this->FECHA_DISPOSICION->PlaceHolder = RemoveHtml($this->FECHA_DISPOSICION->caption());

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->EditAttrs["class"] = "form-control";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->EditCustomAttributes = "";
			if (!$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Raw)
				$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue = HtmlDecode($this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue);
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->EditValue = HtmlEncode($this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue);
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->PlaceHolder = RemoveHtml($this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption());

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->EditAttrs["class"] = "form-control";
			$this->MOTIVO_ELIMINACION_BIEN->EditCustomAttributes = "";
			if (!$this->MOTIVO_ELIMINACION_BIEN->Raw)
				$this->MOTIVO_ELIMINACION_BIEN->CurrentValue = HtmlDecode($this->MOTIVO_ELIMINACION_BIEN->CurrentValue);
			$this->MOTIVO_ELIMINACION_BIEN->EditValue = HtmlEncode($this->MOTIVO_ELIMINACION_BIEN->CurrentValue);
			$this->MOTIVO_ELIMINACION_BIEN->PlaceHolder = RemoveHtml($this->MOTIVO_ELIMINACION_BIEN->caption());

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->EditAttrs["class"] = "form-control";
			$this->ACTO_ADMINISTRACION_BIEN->EditCustomAttributes = "";
			if (!$this->ACTO_ADMINISTRACION_BIEN->Raw)
				$this->ACTO_ADMINISTRACION_BIEN->CurrentValue = HtmlDecode($this->ACTO_ADMINISTRACION_BIEN->CurrentValue);
			$this->ACTO_ADMINISTRACION_BIEN->EditValue = HtmlEncode($this->ACTO_ADMINISTRACION_BIEN->CurrentValue);
			$this->ACTO_ADMINISTRACION_BIEN->PlaceHolder = RemoveHtml($this->ACTO_ADMINISTRACION_BIEN->caption());

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->EditAttrs["class"] = "form-control";
			$this->NUM_RESOLUCION_ADMINISTRACION->EditCustomAttributes = "";
			if (!$this->NUM_RESOLUCION_ADMINISTRACION->Raw)
				$this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue = HtmlDecode($this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue);
			$this->NUM_RESOLUCION_ADMINISTRACION->EditValue = HtmlEncode($this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue);
			$this->NUM_RESOLUCION_ADMINISTRACION->PlaceHolder = RemoveHtml($this->NUM_RESOLUCION_ADMINISTRACION->caption());

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->EditAttrs["class"] = "form-control";
			$this->FECHA_ADMINISTRACION->EditCustomAttributes = "";
			if (!$this->FECHA_ADMINISTRACION->Raw)
				$this->FECHA_ADMINISTRACION->CurrentValue = HtmlDecode($this->FECHA_ADMINISTRACION->CurrentValue);
			$this->FECHA_ADMINISTRACION->EditValue = HtmlEncode($this->FECHA_ADMINISTRACION->CurrentValue);
			$this->FECHA_ADMINISTRACION->PlaceHolder = RemoveHtml($this->FECHA_ADMINISTRACION->caption());

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->EditAttrs["class"] = "form-control";
			$this->FECHA_VENC_ACTO_ADMIN->EditCustomAttributes = "";
			if (!$this->FECHA_VENC_ACTO_ADMIN->Raw)
				$this->FECHA_VENC_ACTO_ADMIN->CurrentValue = HtmlDecode($this->FECHA_VENC_ACTO_ADMIN->CurrentValue);
			$this->FECHA_VENC_ACTO_ADMIN->EditValue = HtmlEncode($this->FECHA_VENC_ACTO_ADMIN->CurrentValue);
			$this->FECHA_VENC_ACTO_ADMIN->PlaceHolder = RemoveHtml($this->FECHA_VENC_ACTO_ADMIN->caption());

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->EditAttrs["class"] = "form-control";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->EditCustomAttributes = "";
			if (!$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Raw)
				$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue = HtmlDecode($this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue);
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->EditValue = HtmlEncode($this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue);
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->PlaceHolder = RemoveHtml($this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption());

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->EditAttrs["class"] = "form-control";
			$this->DOC_ALTA_SBN->EditCustomAttributes = "";
			if (!$this->DOC_ALTA_SBN->Raw)
				$this->DOC_ALTA_SBN->CurrentValue = HtmlDecode($this->DOC_ALTA_SBN->CurrentValue);
			$this->DOC_ALTA_SBN->EditValue = HtmlEncode($this->DOC_ALTA_SBN->CurrentValue);
			$this->DOC_ALTA_SBN->PlaceHolder = RemoveHtml($this->DOC_ALTA_SBN->caption());

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->EditAttrs["class"] = "form-control";
			$this->DOC_BAJA_SBN->EditCustomAttributes = "";
			if (!$this->DOC_BAJA_SBN->Raw)
				$this->DOC_BAJA_SBN->CurrentValue = HtmlDecode($this->DOC_BAJA_SBN->CurrentValue);
			$this->DOC_BAJA_SBN->EditValue = HtmlEncode($this->DOC_BAJA_SBN->CurrentValue);
			$this->DOC_BAJA_SBN->PlaceHolder = RemoveHtml($this->DOC_BAJA_SBN->caption());

			// DEPENDENCIAS
			$this->DEPENDENCIAS->EditAttrs["class"] = "form-control";
			$this->DEPENDENCIAS->EditCustomAttributes = "";
			if (!$this->DEPENDENCIAS->Raw)
				$this->DEPENDENCIAS->CurrentValue = HtmlDecode($this->DEPENDENCIAS->CurrentValue);
			$this->DEPENDENCIAS->EditValue = HtmlEncode($this->DEPENDENCIAS->CurrentValue);
			$this->DEPENDENCIAS->PlaceHolder = RemoveHtml($this->DEPENDENCIAS->caption());

			// NUMERO_FICHA
			$this->NUMERO_FICHA->EditAttrs["class"] = "form-control";
			$this->NUMERO_FICHA->EditCustomAttributes = "";
			if (!$this->NUMERO_FICHA->Raw)
				$this->NUMERO_FICHA->CurrentValue = HtmlDecode($this->NUMERO_FICHA->CurrentValue);
			$this->NUMERO_FICHA->EditValue = HtmlEncode($this->NUMERO_FICHA->CurrentValue);
			$this->NUMERO_FICHA->PlaceHolder = RemoveHtml($this->NUMERO_FICHA->caption());

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->EditAttrs["class"] = "form-control";
			$this->CODIGO_INTERNO->EditCustomAttributes = "";
			if (!$this->CODIGO_INTERNO->Raw)
				$this->CODIGO_INTERNO->CurrentValue = HtmlDecode($this->CODIGO_INTERNO->CurrentValue);
			$this->CODIGO_INTERNO->EditValue = HtmlEncode($this->CODIGO_INTERNO->CurrentValue);
			$this->CODIGO_INTERNO->PlaceHolder = RemoveHtml($this->CODIGO_INTERNO->caption());

			// ESTADO
			$this->ESTADO->EditAttrs["class"] = "form-control";
			$this->ESTADO->EditCustomAttributes = "";
			if (!$this->ESTADO->Raw)
				$this->ESTADO->CurrentValue = HtmlDecode($this->ESTADO->CurrentValue);
			$this->ESTADO->EditValue = HtmlEncode($this->ESTADO->CurrentValue);
			$this->ESTADO->PlaceHolder = RemoveHtml($this->ESTADO->caption());

			// USO
			$this->USO->EditAttrs["class"] = "form-control";
			$this->USO->EditCustomAttributes = "";
			if (!$this->USO->Raw)
				$this->USO->CurrentValue = HtmlDecode($this->USO->CurrentValue);
			$this->USO->EditValue = HtmlEncode($this->USO->CurrentValue);
			$this->USO->PlaceHolder = RemoveHtml($this->USO->caption());

			// STICKER
			$this->STICKER->EditAttrs["class"] = "form-control";
			$this->STICKER->EditCustomAttributes = "";
			if (!$this->STICKER->Raw)
				$this->STICKER->CurrentValue = HtmlDecode($this->STICKER->CurrentValue);
			$this->STICKER->EditValue = HtmlEncode($this->STICKER->CurrentValue);
			$this->STICKER->PlaceHolder = RemoveHtml($this->STICKER->caption());

			// SEDE
			$this->SEDE->EditAttrs["class"] = "form-control";
			$this->SEDE->EditCustomAttributes = "";
			if (!$this->SEDE->Raw)
				$this->SEDE->CurrentValue = HtmlDecode($this->SEDE->CurrentValue);
			$this->SEDE->EditValue = HtmlEncode($this->SEDE->CurrentValue);
			$this->SEDE->PlaceHolder = RemoveHtml($this->SEDE->caption());

			// SBN
			$this->SBN->EditAttrs["class"] = "form-control";
			$this->SBN->EditCustomAttributes = "";
			if (!$this->SBN->Raw)
				$this->SBN->CurrentValue = HtmlDecode($this->SBN->CurrentValue);
			$this->SBN->EditValue = HtmlEncode($this->SBN->CurrentValue);
			$this->SBN->PlaceHolder = RemoveHtml($this->SBN->caption());

			// ETIQUETA
			$this->ETIQUETA->EditAttrs["class"] = "form-control";
			$this->ETIQUETA->EditCustomAttributes = "";
			if (!$this->ETIQUETA->Raw)
				$this->ETIQUETA->CurrentValue = HtmlDecode($this->ETIQUETA->CurrentValue);
			$this->ETIQUETA->EditValue = HtmlEncode($this->ETIQUETA->CurrentValue);
			$this->ETIQUETA->PlaceHolder = RemoveHtml($this->ETIQUETA->caption());

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->EditAttrs["class"] = "form-control";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->EditCustomAttributes = "";
			if (!$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Raw)
				$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue = HtmlDecode($this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue);
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->EditValue = HtmlEncode($this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue);
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->PlaceHolder = RemoveHtml($this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption());

			// PLACA_RODAJE
			$this->PLACA_RODAJE->EditAttrs["class"] = "form-control";
			$this->PLACA_RODAJE->EditCustomAttributes = "";
			if (!$this->PLACA_RODAJE->Raw)
				$this->PLACA_RODAJE->CurrentValue = HtmlDecode($this->PLACA_RODAJE->CurrentValue);
			$this->PLACA_RODAJE->EditValue = HtmlEncode($this->PLACA_RODAJE->CurrentValue);
			$this->PLACA_RODAJE->PlaceHolder = RemoveHtml($this->PLACA_RODAJE->caption());

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->EditAttrs["class"] = "form-control";
			$this->CODIGO_ACTUAL->EditCustomAttributes = "";
			if (!$this->CODIGO_ACTUAL->Raw)
				$this->CODIGO_ACTUAL->CurrentValue = HtmlDecode($this->CODIGO_ACTUAL->CurrentValue);
			$this->CODIGO_ACTUAL->EditValue = HtmlEncode($this->CODIGO_ACTUAL->CurrentValue);
			$this->CODIGO_ACTUAL->PlaceHolder = RemoveHtml($this->CODIGO_ACTUAL->caption());

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->EditAttrs["class"] = "form-control";
			$this->CODIGO_ANTERIOR->EditCustomAttributes = "";
			if (!$this->CODIGO_ANTERIOR->Raw)
				$this->CODIGO_ANTERIOR->CurrentValue = HtmlDecode($this->CODIGO_ANTERIOR->CurrentValue);
			$this->CODIGO_ANTERIOR->EditValue = HtmlEncode($this->CODIGO_ANTERIOR->CurrentValue);
			$this->CODIGO_ANTERIOR->PlaceHolder = RemoveHtml($this->CODIGO_ANTERIOR->caption());

			// PROPIEDAD
			$this->PROPIEDAD->EditAttrs["class"] = "form-control";
			$this->PROPIEDAD->EditCustomAttributes = "";
			if (!$this->PROPIEDAD->Raw)
				$this->PROPIEDAD->CurrentValue = HtmlDecode($this->PROPIEDAD->CurrentValue);
			$this->PROPIEDAD->EditValue = HtmlEncode($this->PROPIEDAD->CurrentValue);
			$this->PROPIEDAD->PlaceHolder = RemoveHtml($this->PROPIEDAD->caption());

			// SITUACION
			$this->SITUACION->EditAttrs["class"] = "form-control";
			$this->SITUACION->EditCustomAttributes = "";
			if (!$this->SITUACION->Raw)
				$this->SITUACION->CurrentValue = HtmlDecode($this->SITUACION->CurrentValue);
			$this->SITUACION->EditValue = HtmlEncode($this->SITUACION->CurrentValue);
			$this->SITUACION->PlaceHolder = RemoveHtml($this->SITUACION->caption());

			// OBSERVACIONES
			$this->OBSERVACIONES->EditAttrs["class"] = "form-control";
			$this->OBSERVACIONES->EditCustomAttributes = "";
			if (!$this->OBSERVACIONES->Raw)
				$this->OBSERVACIONES->CurrentValue = HtmlDecode($this->OBSERVACIONES->CurrentValue);
			$this->OBSERVACIONES->EditValue = HtmlEncode($this->OBSERVACIONES->CurrentValue);
			$this->OBSERVACIONES->PlaceHolder = RemoveHtml($this->OBSERVACIONES->caption());

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->EditAttrs["class"] = "form-control";
			$this->FECHA_REGISTRO->EditCustomAttributes = "";
			$this->FECHA_REGISTRO->EditValue = HtmlEncode(FormatDateTime($this->FECHA_REGISTRO->CurrentValue, 8));
			$this->FECHA_REGISTRO->PlaceHolder = RemoveHtml($this->FECHA_REGISTRO->caption());

			// Add refer script
			// codigo_proceso

			$this->codigo_proceso->LinkCustomAttributes = "";
			$this->codigo_proceso->HrefValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";

			// usuarios
			$this->usuarios->LinkCustomAttributes = "";
			$this->usuarios->HrefValue = "";

			// SEC_EJEC
			$this->SEC_EJEC->LinkCustomAttributes = "";
			$this->SEC_EJEC->HrefValue = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->LinkCustomAttributes = "";
			$this->TIPO_MODALIDAD->HrefValue = "";

			// SECUENCIA
			$this->SECUENCIA->LinkCustomAttributes = "";
			$this->SECUENCIA->HrefValue = "";

			// AMBIENTE
			$this->AMBIENTE->LinkCustomAttributes = "";
			$this->AMBIENTE->HrefValue = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->LinkCustomAttributes = "";
			$this->RUC_ENTIDAD->HrefValue = "";

			// LOCAL
			$this->LOCAL->LinkCustomAttributes = "";
			$this->LOCAL->HrefValue = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->LinkCustomAttributes = "";
			$this->DEPARTAMENTO->HrefValue = "";

			// PROVINCIA
			$this->PROVINCIA->LinkCustomAttributes = "";
			$this->PROVINCIA->HrefValue = "";

			// DISTRITO
			$this->DISTRITO->LinkCustomAttributes = "";
			$this->DISTRITO->HrefValue = "";

			// AREA
			$this->AREA->LinkCustomAttributes = "";
			$this->AREA->HrefValue = "";

			// OFICINA
			$this->OFICINA->LinkCustomAttributes = "";
			$this->OFICINA->HrefValue = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->LinkCustomAttributes = "";
			$this->PISO_OFICINA->HrefValue = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->LinkCustomAttributes = "";
			$this->NRO_DOC_IDENT_PERSONAL->HrefValue = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_PATERNO->HrefValue = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_MATERNO->HrefValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";

			// OPERATIVO
			$this->OPERATIVO->LinkCustomAttributes = "";
			$this->OPERATIVO->HrefValue = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->LinkCustomAttributes = "";
			$this->TIPO_DOC_IDENTIDAD->HrefValue = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->LinkCustomAttributes = "";
			$this->MODALIDAD_CONTRATO->HrefValue = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->LinkCustomAttributes = "";
			$this->CODIGO_PATRIMONIAL->HrefValue = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->LinkCustomAttributes = "";
			$this->DENOMINACION_BIEN->HrefValue = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->LinkCustomAttributes = "";
			$this->TIPO_CAUSAL_ALTA->HrefValue = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->LinkCustomAttributes = "";
			$this->NRO_DOC_ADQUISICION->HrefValue = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->LinkCustomAttributes = "";
			$this->FECHA_ADQUISICION->HrefValue = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->LinkCustomAttributes = "";
			$this->VALOR_ADQUISICION->HrefValue = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->LinkCustomAttributes = "";
			$this->FECHA_DEPRECIACION->HrefValue = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_EJERCICIO->HrefValue = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_ACUMULADO->HrefValue = "";

			// VALOR_NETO
			$this->VALOR_NETO->LinkCustomAttributes = "";
			$this->VALOR_NETO->HrefValue = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->LinkCustomAttributes = "";
			$this->TIP_USO_CUENTA->HrefValue = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->LinkCustomAttributes = "";
			$this->TIPO_CUENTA->HrefValue = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->LinkCustomAttributes = "";
			$this->NRO_CUENTA_CONTABLE->HrefValue = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->LinkCustomAttributes = "";
			$this->CTA_CON_SEGURO->HrefValue = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->LinkCustomAttributes = "";
			$this->ESTADO_BIEN->HrefValue = "";

			// CONDICION
			$this->CONDICION->LinkCustomAttributes = "";
			$this->CONDICION->HrefValue = "";

			// MARCA
			$this->MARCA->LinkCustomAttributes = "";
			$this->MARCA->HrefValue = "";

			// MODELO
			$this->MODELO->LinkCustomAttributes = "";
			$this->MODELO->HrefValue = "";

			// TIPO
			$this->TIPO->LinkCustomAttributes = "";
			$this->TIPO->HrefValue = "";

			// COLOR
			$this->COLOR->LinkCustomAttributes = "";
			$this->COLOR->HrefValue = "";

			// SERIE
			$this->SERIE->LinkCustomAttributes = "";
			$this->SERIE->HrefValue = "";

			// DIMENSION
			$this->DIMENSION->LinkCustomAttributes = "";
			$this->DIMENSION->HrefValue = "";

			// PLACA
			$this->PLACA->LinkCustomAttributes = "";
			$this->PLACA->HrefValue = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->LinkCustomAttributes = "";
			$this->NRO_MOTOR->HrefValue = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->LinkCustomAttributes = "";
			$this->NRO_CHASIS->HrefValue = "";

			// MATRICULA
			$this->MATRICULA->LinkCustomAttributes = "";
			$this->MATRICULA->HrefValue = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->LinkCustomAttributes = "";
			$this->ANIO_FABRICACION->HrefValue = "";

			// LONGITUD
			$this->LONGITUD->LinkCustomAttributes = "";
			$this->LONGITUD->HrefValue = "";

			// ALTURA
			$this->ALTURA->LinkCustomAttributes = "";
			$this->ALTURA->HrefValue = "";

			// ANCHO
			$this->ANCHO->LinkCustomAttributes = "";
			$this->ANCHO->HrefValue = "";

			// RAZA
			$this->RAZA->LinkCustomAttributes = "";
			$this->RAZA->HrefValue = "";

			// ESPECIE
			$this->ESPECIE->LinkCustomAttributes = "";
			$this->ESPECIE->HrefValue = "";

			// EDAD
			$this->EDAD->LinkCustomAttributes = "";
			$this->EDAD->HrefValue = "";

			// PAIS
			$this->PAIS->LinkCustomAttributes = "";
			$this->PAIS->HrefValue = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->LinkCustomAttributes = "";
			$this->OTRAS_CARACT->HrefValue = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->LinkCustomAttributes = "";
			$this->DESCRIPCION_UBICACION_BIEN->HrefValue = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->LinkCustomAttributes = "";
			$this->CAUSAL_BAJA->HrefValue = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_BAJA->HrefValue = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->LinkCustomAttributes = "";
			$this->FECHA_BAJA->HrefValue = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_DISPOSICION_BIEN->HrefValue = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_DISP->HrefValue = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->LinkCustomAttributes = "";
			$this->FECHA_DISPOSICION->HrefValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->HrefValue = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->LinkCustomAttributes = "";
			$this->MOTIVO_ELIMINACION_BIEN->HrefValue = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_ADMINISTRACION_BIEN->HrefValue = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->LinkCustomAttributes = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->HrefValue = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->LinkCustomAttributes = "";
			$this->FECHA_ADMINISTRACION->HrefValue = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->FECHA_VENC_ACTO_ADMIN->HrefValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->HrefValue = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->LinkCustomAttributes = "";
			$this->DOC_ALTA_SBN->HrefValue = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->LinkCustomAttributes = "";
			$this->DOC_BAJA_SBN->HrefValue = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->LinkCustomAttributes = "";
			$this->DEPENDENCIAS->HrefValue = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->LinkCustomAttributes = "";
			$this->NUMERO_FICHA->HrefValue = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->LinkCustomAttributes = "";
			$this->CODIGO_INTERNO->HrefValue = "";

			// ESTADO
			$this->ESTADO->LinkCustomAttributes = "";
			$this->ESTADO->HrefValue = "";

			// USO
			$this->USO->LinkCustomAttributes = "";
			$this->USO->HrefValue = "";

			// STICKER
			$this->STICKER->LinkCustomAttributes = "";
			$this->STICKER->HrefValue = "";

			// SEDE
			$this->SEDE->LinkCustomAttributes = "";
			$this->SEDE->HrefValue = "";

			// SBN
			$this->SBN->LinkCustomAttributes = "";
			$this->SBN->HrefValue = "";

			// ETIQUETA
			$this->ETIQUETA->LinkCustomAttributes = "";
			$this->ETIQUETA->HrefValue = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->HrefValue = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->LinkCustomAttributes = "";
			$this->PLACA_RODAJE->HrefValue = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->LinkCustomAttributes = "";
			$this->CODIGO_ACTUAL->HrefValue = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->LinkCustomAttributes = "";
			$this->CODIGO_ANTERIOR->HrefValue = "";

			// PROPIEDAD
			$this->PROPIEDAD->LinkCustomAttributes = "";
			$this->PROPIEDAD->HrefValue = "";

			// SITUACION
			$this->SITUACION->LinkCustomAttributes = "";
			$this->SITUACION->HrefValue = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->LinkCustomAttributes = "";
			$this->OBSERVACIONES->HrefValue = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->LinkCustomAttributes = "";
			$this->FECHA_REGISTRO->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->codigo_proceso->Required) {
			if (!$this->codigo_proceso->IsDetailKey && $this->codigo_proceso->FormValue != NULL && $this->codigo_proceso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codigo_proceso->caption(), $this->codigo_proceso->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->codigo_proceso->FormValue)) {
			AddMessage($FormError, $this->codigo_proceso->errorMessage());
		}
		if ($this->no->Required) {
			if (!$this->no->IsDetailKey && $this->no->FormValue != NULL && $this->no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->no->FormValue)) {
			AddMessage($FormError, $this->no->errorMessage());
		}
		if ($this->usuarios->Required) {
			if (!$this->usuarios->IsDetailKey && $this->usuarios->FormValue != NULL && $this->usuarios->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->usuarios->caption(), $this->usuarios->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->usuarios->FormValue)) {
			AddMessage($FormError, $this->usuarios->errorMessage());
		}
		if ($this->SEC_EJEC->Required) {
			if (!$this->SEC_EJEC->IsDetailKey && $this->SEC_EJEC->FormValue != NULL && $this->SEC_EJEC->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SEC_EJEC->caption(), $this->SEC_EJEC->RequiredErrorMessage));
			}
		}
		if ($this->TIPO_MODALIDAD->Required) {
			if (!$this->TIPO_MODALIDAD->IsDetailKey && $this->TIPO_MODALIDAD->FormValue != NULL && $this->TIPO_MODALIDAD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIPO_MODALIDAD->caption(), $this->TIPO_MODALIDAD->RequiredErrorMessage));
			}
		}
		if ($this->SECUENCIA->Required) {
			if (!$this->SECUENCIA->IsDetailKey && $this->SECUENCIA->FormValue != NULL && $this->SECUENCIA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SECUENCIA->caption(), $this->SECUENCIA->RequiredErrorMessage));
			}
		}
		if ($this->AMBIENTE->Required) {
			if (!$this->AMBIENTE->IsDetailKey && $this->AMBIENTE->FormValue != NULL && $this->AMBIENTE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->AMBIENTE->caption(), $this->AMBIENTE->RequiredErrorMessage));
			}
		}
		if ($this->RUC_ENTIDAD->Required) {
			if (!$this->RUC_ENTIDAD->IsDetailKey && $this->RUC_ENTIDAD->FormValue != NULL && $this->RUC_ENTIDAD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RUC_ENTIDAD->caption(), $this->RUC_ENTIDAD->RequiredErrorMessage));
			}
		}
		if ($this->LOCAL->Required) {
			if (!$this->LOCAL->IsDetailKey && $this->LOCAL->FormValue != NULL && $this->LOCAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LOCAL->caption(), $this->LOCAL->RequiredErrorMessage));
			}
		}
		if ($this->DEPARTAMENTO->Required) {
			if (!$this->DEPARTAMENTO->IsDetailKey && $this->DEPARTAMENTO->FormValue != NULL && $this->DEPARTAMENTO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DEPARTAMENTO->caption(), $this->DEPARTAMENTO->RequiredErrorMessage));
			}
		}
		if ($this->PROVINCIA->Required) {
			if (!$this->PROVINCIA->IsDetailKey && $this->PROVINCIA->FormValue != NULL && $this->PROVINCIA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PROVINCIA->caption(), $this->PROVINCIA->RequiredErrorMessage));
			}
		}
		if ($this->DISTRITO->Required) {
			if (!$this->DISTRITO->IsDetailKey && $this->DISTRITO->FormValue != NULL && $this->DISTRITO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DISTRITO->caption(), $this->DISTRITO->RequiredErrorMessage));
			}
		}
		if ($this->AREA->Required) {
			if (!$this->AREA->IsDetailKey && $this->AREA->FormValue != NULL && $this->AREA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->AREA->caption(), $this->AREA->RequiredErrorMessage));
			}
		}
		if ($this->OFICINA->Required) {
			if (!$this->OFICINA->IsDetailKey && $this->OFICINA->FormValue != NULL && $this->OFICINA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->OFICINA->caption(), $this->OFICINA->RequiredErrorMessage));
			}
		}
		if ($this->PISO_OFICINA->Required) {
			if (!$this->PISO_OFICINA->IsDetailKey && $this->PISO_OFICINA->FormValue != NULL && $this->PISO_OFICINA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PISO_OFICINA->caption(), $this->PISO_OFICINA->RequiredErrorMessage));
			}
		}
		if ($this->NRO_DOC_IDENT_PERSONAL->Required) {
			if (!$this->NRO_DOC_IDENT_PERSONAL->IsDetailKey && $this->NRO_DOC_IDENT_PERSONAL->FormValue != NULL && $this->NRO_DOC_IDENT_PERSONAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_DOC_IDENT_PERSONAL->caption(), $this->NRO_DOC_IDENT_PERSONAL->RequiredErrorMessage));
			}
		}
		if ($this->APELLIDO_PATERNO->Required) {
			if (!$this->APELLIDO_PATERNO->IsDetailKey && $this->APELLIDO_PATERNO->FormValue != NULL && $this->APELLIDO_PATERNO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->APELLIDO_PATERNO->caption(), $this->APELLIDO_PATERNO->RequiredErrorMessage));
			}
		}
		if ($this->APELLIDO_MATERNO->Required) {
			if (!$this->APELLIDO_MATERNO->IsDetailKey && $this->APELLIDO_MATERNO->FormValue != NULL && $this->APELLIDO_MATERNO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->APELLIDO_MATERNO->caption(), $this->APELLIDO_MATERNO->RequiredErrorMessage));
			}
		}
		if ($this->NOMBRES->Required) {
			if (!$this->NOMBRES->IsDetailKey && $this->NOMBRES->FormValue != NULL && $this->NOMBRES->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NOMBRES->caption(), $this->NOMBRES->RequiredErrorMessage));
			}
		}
		if ($this->OPERATIVO->Required) {
			if (!$this->OPERATIVO->IsDetailKey && $this->OPERATIVO->FormValue != NULL && $this->OPERATIVO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->OPERATIVO->caption(), $this->OPERATIVO->RequiredErrorMessage));
			}
		}
		if ($this->TIPO_DOC_IDENTIDAD->Required) {
			if (!$this->TIPO_DOC_IDENTIDAD->IsDetailKey && $this->TIPO_DOC_IDENTIDAD->FormValue != NULL && $this->TIPO_DOC_IDENTIDAD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIPO_DOC_IDENTIDAD->caption(), $this->TIPO_DOC_IDENTIDAD->RequiredErrorMessage));
			}
		}
		if ($this->MODALIDAD_CONTRATO->Required) {
			if (!$this->MODALIDAD_CONTRATO->IsDetailKey && $this->MODALIDAD_CONTRATO->FormValue != NULL && $this->MODALIDAD_CONTRATO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MODALIDAD_CONTRATO->caption(), $this->MODALIDAD_CONTRATO->RequiredErrorMessage));
			}
		}
		if ($this->CODIGO_PATRIMONIAL->Required) {
			if (!$this->CODIGO_PATRIMONIAL->IsDetailKey && $this->CODIGO_PATRIMONIAL->FormValue != NULL && $this->CODIGO_PATRIMONIAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CODIGO_PATRIMONIAL->caption(), $this->CODIGO_PATRIMONIAL->RequiredErrorMessage));
			}
		}
		if ($this->DENOMINACION_BIEN->Required) {
			if (!$this->DENOMINACION_BIEN->IsDetailKey && $this->DENOMINACION_BIEN->FormValue != NULL && $this->DENOMINACION_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DENOMINACION_BIEN->caption(), $this->DENOMINACION_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->TIPO_CAUSAL_ALTA->Required) {
			if (!$this->TIPO_CAUSAL_ALTA->IsDetailKey && $this->TIPO_CAUSAL_ALTA->FormValue != NULL && $this->TIPO_CAUSAL_ALTA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIPO_CAUSAL_ALTA->caption(), $this->TIPO_CAUSAL_ALTA->RequiredErrorMessage));
			}
		}
		if ($this->NRO_DOC_ADQUISICION->Required) {
			if (!$this->NRO_DOC_ADQUISICION->IsDetailKey && $this->NRO_DOC_ADQUISICION->FormValue != NULL && $this->NRO_DOC_ADQUISICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_DOC_ADQUISICION->caption(), $this->NRO_DOC_ADQUISICION->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_ADQUISICION->Required) {
			if (!$this->FECHA_ADQUISICION->IsDetailKey && $this->FECHA_ADQUISICION->FormValue != NULL && $this->FECHA_ADQUISICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_ADQUISICION->caption(), $this->FECHA_ADQUISICION->RequiredErrorMessage));
			}
		}
		if ($this->VALOR_ADQUISICION->Required) {
			if (!$this->VALOR_ADQUISICION->IsDetailKey && $this->VALOR_ADQUISICION->FormValue != NULL && $this->VALOR_ADQUISICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->VALOR_ADQUISICION->caption(), $this->VALOR_ADQUISICION->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_DEPRECIACION->Required) {
			if (!$this->FECHA_DEPRECIACION->IsDetailKey && $this->FECHA_DEPRECIACION->FormValue != NULL && $this->FECHA_DEPRECIACION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_DEPRECIACION->caption(), $this->FECHA_DEPRECIACION->RequiredErrorMessage));
			}
		}
		if ($this->VALOR_DEPREC_EJERCICIO->Required) {
			if (!$this->VALOR_DEPREC_EJERCICIO->IsDetailKey && $this->VALOR_DEPREC_EJERCICIO->FormValue != NULL && $this->VALOR_DEPREC_EJERCICIO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->VALOR_DEPREC_EJERCICIO->caption(), $this->VALOR_DEPREC_EJERCICIO->RequiredErrorMessage));
			}
		}
		if ($this->VALOR_DEPREC_ACUMULADO->Required) {
			if (!$this->VALOR_DEPREC_ACUMULADO->IsDetailKey && $this->VALOR_DEPREC_ACUMULADO->FormValue != NULL && $this->VALOR_DEPREC_ACUMULADO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->VALOR_DEPREC_ACUMULADO->caption(), $this->VALOR_DEPREC_ACUMULADO->RequiredErrorMessage));
			}
		}
		if ($this->VALOR_NETO->Required) {
			if (!$this->VALOR_NETO->IsDetailKey && $this->VALOR_NETO->FormValue != NULL && $this->VALOR_NETO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->VALOR_NETO->caption(), $this->VALOR_NETO->RequiredErrorMessage));
			}
		}
		if ($this->TIP_USO_CUENTA->Required) {
			if (!$this->TIP_USO_CUENTA->IsDetailKey && $this->TIP_USO_CUENTA->FormValue != NULL && $this->TIP_USO_CUENTA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIP_USO_CUENTA->caption(), $this->TIP_USO_CUENTA->RequiredErrorMessage));
			}
		}
		if ($this->TIPO_CUENTA->Required) {
			if (!$this->TIPO_CUENTA->IsDetailKey && $this->TIPO_CUENTA->FormValue != NULL && $this->TIPO_CUENTA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIPO_CUENTA->caption(), $this->TIPO_CUENTA->RequiredErrorMessage));
			}
		}
		if ($this->NRO_CUENTA_CONTABLE->Required) {
			if (!$this->NRO_CUENTA_CONTABLE->IsDetailKey && $this->NRO_CUENTA_CONTABLE->FormValue != NULL && $this->NRO_CUENTA_CONTABLE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_CUENTA_CONTABLE->caption(), $this->NRO_CUENTA_CONTABLE->RequiredErrorMessage));
			}
		}
		if ($this->CTA_CON_SEGURO->Required) {
			if (!$this->CTA_CON_SEGURO->IsDetailKey && $this->CTA_CON_SEGURO->FormValue != NULL && $this->CTA_CON_SEGURO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CTA_CON_SEGURO->caption(), $this->CTA_CON_SEGURO->RequiredErrorMessage));
			}
		}
		if ($this->ESTADO_BIEN->Required) {
			if (!$this->ESTADO_BIEN->IsDetailKey && $this->ESTADO_BIEN->FormValue != NULL && $this->ESTADO_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ESTADO_BIEN->caption(), $this->ESTADO_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->CONDICION->Required) {
			if (!$this->CONDICION->IsDetailKey && $this->CONDICION->FormValue != NULL && $this->CONDICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CONDICION->caption(), $this->CONDICION->RequiredErrorMessage));
			}
		}
		if ($this->MARCA->Required) {
			if (!$this->MARCA->IsDetailKey && $this->MARCA->FormValue != NULL && $this->MARCA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MARCA->caption(), $this->MARCA->RequiredErrorMessage));
			}
		}
		if ($this->MODELO->Required) {
			if (!$this->MODELO->IsDetailKey && $this->MODELO->FormValue != NULL && $this->MODELO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MODELO->caption(), $this->MODELO->RequiredErrorMessage));
			}
		}
		if ($this->TIPO->Required) {
			if (!$this->TIPO->IsDetailKey && $this->TIPO->FormValue != NULL && $this->TIPO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TIPO->caption(), $this->TIPO->RequiredErrorMessage));
			}
		}
		if ($this->COLOR->Required) {
			if (!$this->COLOR->IsDetailKey && $this->COLOR->FormValue != NULL && $this->COLOR->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->COLOR->caption(), $this->COLOR->RequiredErrorMessage));
			}
		}
		if ($this->SERIE->Required) {
			if (!$this->SERIE->IsDetailKey && $this->SERIE->FormValue != NULL && $this->SERIE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SERIE->caption(), $this->SERIE->RequiredErrorMessage));
			}
		}
		if ($this->DIMENSION->Required) {
			if (!$this->DIMENSION->IsDetailKey && $this->DIMENSION->FormValue != NULL && $this->DIMENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DIMENSION->caption(), $this->DIMENSION->RequiredErrorMessage));
			}
		}
		if ($this->PLACA->Required) {
			if (!$this->PLACA->IsDetailKey && $this->PLACA->FormValue != NULL && $this->PLACA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PLACA->caption(), $this->PLACA->RequiredErrorMessage));
			}
		}
		if ($this->NRO_MOTOR->Required) {
			if (!$this->NRO_MOTOR->IsDetailKey && $this->NRO_MOTOR->FormValue != NULL && $this->NRO_MOTOR->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_MOTOR->caption(), $this->NRO_MOTOR->RequiredErrorMessage));
			}
		}
		if ($this->NRO_CHASIS->Required) {
			if (!$this->NRO_CHASIS->IsDetailKey && $this->NRO_CHASIS->FormValue != NULL && $this->NRO_CHASIS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_CHASIS->caption(), $this->NRO_CHASIS->RequiredErrorMessage));
			}
		}
		if ($this->MATRICULA->Required) {
			if (!$this->MATRICULA->IsDetailKey && $this->MATRICULA->FormValue != NULL && $this->MATRICULA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MATRICULA->caption(), $this->MATRICULA->RequiredErrorMessage));
			}
		}
		if ($this->ANIO_FABRICACION->Required) {
			if (!$this->ANIO_FABRICACION->IsDetailKey && $this->ANIO_FABRICACION->FormValue != NULL && $this->ANIO_FABRICACION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ANIO_FABRICACION->caption(), $this->ANIO_FABRICACION->RequiredErrorMessage));
			}
		}
		if ($this->LONGITUD->Required) {
			if (!$this->LONGITUD->IsDetailKey && $this->LONGITUD->FormValue != NULL && $this->LONGITUD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LONGITUD->caption(), $this->LONGITUD->RequiredErrorMessage));
			}
		}
		if ($this->ALTURA->Required) {
			if (!$this->ALTURA->IsDetailKey && $this->ALTURA->FormValue != NULL && $this->ALTURA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ALTURA->caption(), $this->ALTURA->RequiredErrorMessage));
			}
		}
		if ($this->ANCHO->Required) {
			if (!$this->ANCHO->IsDetailKey && $this->ANCHO->FormValue != NULL && $this->ANCHO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ANCHO->caption(), $this->ANCHO->RequiredErrorMessage));
			}
		}
		if ($this->RAZA->Required) {
			if (!$this->RAZA->IsDetailKey && $this->RAZA->FormValue != NULL && $this->RAZA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RAZA->caption(), $this->RAZA->RequiredErrorMessage));
			}
		}
		if ($this->ESPECIE->Required) {
			if (!$this->ESPECIE->IsDetailKey && $this->ESPECIE->FormValue != NULL && $this->ESPECIE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ESPECIE->caption(), $this->ESPECIE->RequiredErrorMessage));
			}
		}
		if ($this->EDAD->Required) {
			if (!$this->EDAD->IsDetailKey && $this->EDAD->FormValue != NULL && $this->EDAD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EDAD->caption(), $this->EDAD->RequiredErrorMessage));
			}
		}
		if ($this->PAIS->Required) {
			if (!$this->PAIS->IsDetailKey && $this->PAIS->FormValue != NULL && $this->PAIS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PAIS->caption(), $this->PAIS->RequiredErrorMessage));
			}
		}
		if ($this->OTRAS_CARACT->Required) {
			if (!$this->OTRAS_CARACT->IsDetailKey && $this->OTRAS_CARACT->FormValue != NULL && $this->OTRAS_CARACT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->OTRAS_CARACT->caption(), $this->OTRAS_CARACT->RequiredErrorMessage));
			}
		}
		if ($this->DESCRIPCION_UBICACION_BIEN->Required) {
			if (!$this->DESCRIPCION_UBICACION_BIEN->IsDetailKey && $this->DESCRIPCION_UBICACION_BIEN->FormValue != NULL && $this->DESCRIPCION_UBICACION_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DESCRIPCION_UBICACION_BIEN->caption(), $this->DESCRIPCION_UBICACION_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->CAUSAL_BAJA->Required) {
			if (!$this->CAUSAL_BAJA->IsDetailKey && $this->CAUSAL_BAJA->FormValue != NULL && $this->CAUSAL_BAJA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CAUSAL_BAJA->caption(), $this->CAUSAL_BAJA->RequiredErrorMessage));
			}
		}
		if ($this->NRO_RESOLUCION_BAJA->Required) {
			if (!$this->NRO_RESOLUCION_BAJA->IsDetailKey && $this->NRO_RESOLUCION_BAJA->FormValue != NULL && $this->NRO_RESOLUCION_BAJA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_RESOLUCION_BAJA->caption(), $this->NRO_RESOLUCION_BAJA->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_BAJA->Required) {
			if (!$this->FECHA_BAJA->IsDetailKey && $this->FECHA_BAJA->FormValue != NULL && $this->FECHA_BAJA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_BAJA->caption(), $this->FECHA_BAJA->RequiredErrorMessage));
			}
		}
		if ($this->ACTO_DISPOSICION_BIEN->Required) {
			if (!$this->ACTO_DISPOSICION_BIEN->IsDetailKey && $this->ACTO_DISPOSICION_BIEN->FormValue != NULL && $this->ACTO_DISPOSICION_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACTO_DISPOSICION_BIEN->caption(), $this->ACTO_DISPOSICION_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->NRO_RESOLUCION_DISP->Required) {
			if (!$this->NRO_RESOLUCION_DISP->IsDetailKey && $this->NRO_RESOLUCION_DISP->FormValue != NULL && $this->NRO_RESOLUCION_DISP->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NRO_RESOLUCION_DISP->caption(), $this->NRO_RESOLUCION_DISP->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_DISPOSICION->Required) {
			if (!$this->FECHA_DISPOSICION->IsDetailKey && $this->FECHA_DISPOSICION->FormValue != NULL && $this->FECHA_DISPOSICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_DISPOSICION->caption(), $this->FECHA_DISPOSICION->RequiredErrorMessage));
			}
		}
		if ($this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Required) {
			if (!$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->IsDetailKey && $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->FormValue != NULL && $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption(), $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->RequiredErrorMessage));
			}
		}
		if ($this->MOTIVO_ELIMINACION_BIEN->Required) {
			if (!$this->MOTIVO_ELIMINACION_BIEN->IsDetailKey && $this->MOTIVO_ELIMINACION_BIEN->FormValue != NULL && $this->MOTIVO_ELIMINACION_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MOTIVO_ELIMINACION_BIEN->caption(), $this->MOTIVO_ELIMINACION_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->ACTO_ADMINISTRACION_BIEN->Required) {
			if (!$this->ACTO_ADMINISTRACION_BIEN->IsDetailKey && $this->ACTO_ADMINISTRACION_BIEN->FormValue != NULL && $this->ACTO_ADMINISTRACION_BIEN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACTO_ADMINISTRACION_BIEN->caption(), $this->ACTO_ADMINISTRACION_BIEN->RequiredErrorMessage));
			}
		}
		if ($this->NUM_RESOLUCION_ADMINISTRACION->Required) {
			if (!$this->NUM_RESOLUCION_ADMINISTRACION->IsDetailKey && $this->NUM_RESOLUCION_ADMINISTRACION->FormValue != NULL && $this->NUM_RESOLUCION_ADMINISTRACION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NUM_RESOLUCION_ADMINISTRACION->caption(), $this->NUM_RESOLUCION_ADMINISTRACION->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_ADMINISTRACION->Required) {
			if (!$this->FECHA_ADMINISTRACION->IsDetailKey && $this->FECHA_ADMINISTRACION->FormValue != NULL && $this->FECHA_ADMINISTRACION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_ADMINISTRACION->caption(), $this->FECHA_ADMINISTRACION->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_VENC_ACTO_ADMIN->Required) {
			if (!$this->FECHA_VENC_ACTO_ADMIN->IsDetailKey && $this->FECHA_VENC_ACTO_ADMIN->FormValue != NULL && $this->FECHA_VENC_ACTO_ADMIN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_VENC_ACTO_ADMIN->caption(), $this->FECHA_VENC_ACTO_ADMIN->RequiredErrorMessage));
			}
		}
		if ($this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Required) {
			if (!$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->IsDetailKey && $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->FormValue != NULL && $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption(), $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->RequiredErrorMessage));
			}
		}
		if ($this->DOC_ALTA_SBN->Required) {
			if (!$this->DOC_ALTA_SBN->IsDetailKey && $this->DOC_ALTA_SBN->FormValue != NULL && $this->DOC_ALTA_SBN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DOC_ALTA_SBN->caption(), $this->DOC_ALTA_SBN->RequiredErrorMessage));
			}
		}
		if ($this->DOC_BAJA_SBN->Required) {
			if (!$this->DOC_BAJA_SBN->IsDetailKey && $this->DOC_BAJA_SBN->FormValue != NULL && $this->DOC_BAJA_SBN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DOC_BAJA_SBN->caption(), $this->DOC_BAJA_SBN->RequiredErrorMessage));
			}
		}
		if ($this->DEPENDENCIAS->Required) {
			if (!$this->DEPENDENCIAS->IsDetailKey && $this->DEPENDENCIAS->FormValue != NULL && $this->DEPENDENCIAS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DEPENDENCIAS->caption(), $this->DEPENDENCIAS->RequiredErrorMessage));
			}
		}
		if ($this->NUMERO_FICHA->Required) {
			if (!$this->NUMERO_FICHA->IsDetailKey && $this->NUMERO_FICHA->FormValue != NULL && $this->NUMERO_FICHA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NUMERO_FICHA->caption(), $this->NUMERO_FICHA->RequiredErrorMessage));
			}
		}
		if ($this->CODIGO_INTERNO->Required) {
			if (!$this->CODIGO_INTERNO->IsDetailKey && $this->CODIGO_INTERNO->FormValue != NULL && $this->CODIGO_INTERNO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CODIGO_INTERNO->caption(), $this->CODIGO_INTERNO->RequiredErrorMessage));
			}
		}
		if ($this->ESTADO->Required) {
			if (!$this->ESTADO->IsDetailKey && $this->ESTADO->FormValue != NULL && $this->ESTADO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ESTADO->caption(), $this->ESTADO->RequiredErrorMessage));
			}
		}
		if ($this->USO->Required) {
			if (!$this->USO->IsDetailKey && $this->USO->FormValue != NULL && $this->USO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->USO->caption(), $this->USO->RequiredErrorMessage));
			}
		}
		if ($this->STICKER->Required) {
			if (!$this->STICKER->IsDetailKey && $this->STICKER->FormValue != NULL && $this->STICKER->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->STICKER->caption(), $this->STICKER->RequiredErrorMessage));
			}
		}
		if ($this->SEDE->Required) {
			if (!$this->SEDE->IsDetailKey && $this->SEDE->FormValue != NULL && $this->SEDE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SEDE->caption(), $this->SEDE->RequiredErrorMessage));
			}
		}
		if ($this->SBN->Required) {
			if (!$this->SBN->IsDetailKey && $this->SBN->FormValue != NULL && $this->SBN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SBN->caption(), $this->SBN->RequiredErrorMessage));
			}
		}
		if ($this->ETIQUETA->Required) {
			if (!$this->ETIQUETA->IsDetailKey && $this->ETIQUETA->FormValue != NULL && $this->ETIQUETA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ETIQUETA->caption(), $this->ETIQUETA->RequiredErrorMessage));
			}
		}
		if ($this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Required) {
			if (!$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->IsDetailKey && $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->FormValue != NULL && $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption(), $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->RequiredErrorMessage));
			}
		}
		if ($this->PLACA_RODAJE->Required) {
			if (!$this->PLACA_RODAJE->IsDetailKey && $this->PLACA_RODAJE->FormValue != NULL && $this->PLACA_RODAJE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PLACA_RODAJE->caption(), $this->PLACA_RODAJE->RequiredErrorMessage));
			}
		}
		if ($this->CODIGO_ACTUAL->Required) {
			if (!$this->CODIGO_ACTUAL->IsDetailKey && $this->CODIGO_ACTUAL->FormValue != NULL && $this->CODIGO_ACTUAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CODIGO_ACTUAL->caption(), $this->CODIGO_ACTUAL->RequiredErrorMessage));
			}
		}
		if ($this->CODIGO_ANTERIOR->Required) {
			if (!$this->CODIGO_ANTERIOR->IsDetailKey && $this->CODIGO_ANTERIOR->FormValue != NULL && $this->CODIGO_ANTERIOR->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CODIGO_ANTERIOR->caption(), $this->CODIGO_ANTERIOR->RequiredErrorMessage));
			}
		}
		if ($this->PROPIEDAD->Required) {
			if (!$this->PROPIEDAD->IsDetailKey && $this->PROPIEDAD->FormValue != NULL && $this->PROPIEDAD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PROPIEDAD->caption(), $this->PROPIEDAD->RequiredErrorMessage));
			}
		}
		if ($this->SITUACION->Required) {
			if (!$this->SITUACION->IsDetailKey && $this->SITUACION->FormValue != NULL && $this->SITUACION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SITUACION->caption(), $this->SITUACION->RequiredErrorMessage));
			}
		}
		if ($this->OBSERVACIONES->Required) {
			if (!$this->OBSERVACIONES->IsDetailKey && $this->OBSERVACIONES->FormValue != NULL && $this->OBSERVACIONES->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->OBSERVACIONES->caption(), $this->OBSERVACIONES->RequiredErrorMessage));
			}
		}
		if ($this->FECHA_REGISTRO->Required) {
			if (!$this->FECHA_REGISTRO->IsDetailKey && $this->FECHA_REGISTRO->FormValue != NULL && $this->FECHA_REGISTRO->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FECHA_REGISTRO->caption(), $this->FECHA_REGISTRO->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->FECHA_REGISTRO->FormValue)) {
			AddMessage($FormError, $this->FECHA_REGISTRO->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// codigo_proceso
		$this->codigo_proceso->setDbValueDef($rsnew, $this->codigo_proceso->CurrentValue, NULL, FALSE);

		// no
		$this->no->setDbValueDef($rsnew, $this->no->CurrentValue, NULL, FALSE);

		// usuarios
		$this->usuarios->setDbValueDef($rsnew, $this->usuarios->CurrentValue, NULL, FALSE);

		// SEC_EJEC
		$this->SEC_EJEC->setDbValueDef($rsnew, $this->SEC_EJEC->CurrentValue, NULL, FALSE);

		// TIPO_MODALIDAD
		$this->TIPO_MODALIDAD->setDbValueDef($rsnew, $this->TIPO_MODALIDAD->CurrentValue, NULL, FALSE);

		// SECUENCIA
		$this->SECUENCIA->setDbValueDef($rsnew, $this->SECUENCIA->CurrentValue, NULL, FALSE);

		// AMBIENTE
		$this->AMBIENTE->setDbValueDef($rsnew, $this->AMBIENTE->CurrentValue, NULL, FALSE);

		// RUC_ENTIDAD
		$this->RUC_ENTIDAD->setDbValueDef($rsnew, $this->RUC_ENTIDAD->CurrentValue, NULL, FALSE);

		// LOCAL
		$this->LOCAL->setDbValueDef($rsnew, $this->LOCAL->CurrentValue, NULL, FALSE);

		// DEPARTAMENTO
		$this->DEPARTAMENTO->setDbValueDef($rsnew, $this->DEPARTAMENTO->CurrentValue, NULL, FALSE);

		// PROVINCIA
		$this->PROVINCIA->setDbValueDef($rsnew, $this->PROVINCIA->CurrentValue, NULL, FALSE);

		// DISTRITO
		$this->DISTRITO->setDbValueDef($rsnew, $this->DISTRITO->CurrentValue, NULL, FALSE);

		// AREA
		$this->AREA->setDbValueDef($rsnew, $this->AREA->CurrentValue, NULL, FALSE);

		// OFICINA
		$this->OFICINA->setDbValueDef($rsnew, $this->OFICINA->CurrentValue, NULL, FALSE);

		// PISO_OFICINA
		$this->PISO_OFICINA->setDbValueDef($rsnew, $this->PISO_OFICINA->CurrentValue, NULL, FALSE);

		// NRO_DOC_IDENT_PERSONAL
		$this->NRO_DOC_IDENT_PERSONAL->setDbValueDef($rsnew, $this->NRO_DOC_IDENT_PERSONAL->CurrentValue, NULL, FALSE);

		// APELLIDO_PATERNO
		$this->APELLIDO_PATERNO->setDbValueDef($rsnew, $this->APELLIDO_PATERNO->CurrentValue, NULL, FALSE);

		// APELLIDO_MATERNO
		$this->APELLIDO_MATERNO->setDbValueDef($rsnew, $this->APELLIDO_MATERNO->CurrentValue, NULL, FALSE);

		// NOMBRES
		$this->NOMBRES->setDbValueDef($rsnew, $this->NOMBRES->CurrentValue, NULL, FALSE);

		// OPERATIVO
		$this->OPERATIVO->setDbValueDef($rsnew, $this->OPERATIVO->CurrentValue, NULL, FALSE);

		// TIPO_DOC_IDENTIDAD
		$this->TIPO_DOC_IDENTIDAD->setDbValueDef($rsnew, $this->TIPO_DOC_IDENTIDAD->CurrentValue, NULL, FALSE);

		// MODALIDAD_CONTRATO
		$this->MODALIDAD_CONTRATO->setDbValueDef($rsnew, $this->MODALIDAD_CONTRATO->CurrentValue, NULL, FALSE);

		// CODIGO_PATRIMONIAL
		$this->CODIGO_PATRIMONIAL->setDbValueDef($rsnew, $this->CODIGO_PATRIMONIAL->CurrentValue, NULL, FALSE);

		// DENOMINACION_BIEN
		$this->DENOMINACION_BIEN->setDbValueDef($rsnew, $this->DENOMINACION_BIEN->CurrentValue, NULL, FALSE);

		// TIPO_CAUSAL_ALTA
		$this->TIPO_CAUSAL_ALTA->setDbValueDef($rsnew, $this->TIPO_CAUSAL_ALTA->CurrentValue, NULL, FALSE);

		// NRO_DOC_ADQUISICION
		$this->NRO_DOC_ADQUISICION->setDbValueDef($rsnew, $this->NRO_DOC_ADQUISICION->CurrentValue, NULL, FALSE);

		// FECHA_ADQUISICION
		$this->FECHA_ADQUISICION->setDbValueDef($rsnew, $this->FECHA_ADQUISICION->CurrentValue, NULL, FALSE);

		// VALOR_ADQUISICION
		$this->VALOR_ADQUISICION->setDbValueDef($rsnew, $this->VALOR_ADQUISICION->CurrentValue, NULL, FALSE);

		// FECHA_DEPRECIACION
		$this->FECHA_DEPRECIACION->setDbValueDef($rsnew, $this->FECHA_DEPRECIACION->CurrentValue, NULL, FALSE);

		// VALOR_DEPREC_EJERCICIO
		$this->VALOR_DEPREC_EJERCICIO->setDbValueDef($rsnew, $this->VALOR_DEPREC_EJERCICIO->CurrentValue, NULL, FALSE);

		// VALOR_DEPREC_ACUMULADO
		$this->VALOR_DEPREC_ACUMULADO->setDbValueDef($rsnew, $this->VALOR_DEPREC_ACUMULADO->CurrentValue, NULL, FALSE);

		// VALOR_NETO
		$this->VALOR_NETO->setDbValueDef($rsnew, $this->VALOR_NETO->CurrentValue, NULL, FALSE);

		// TIP_USO_CUENTA
		$this->TIP_USO_CUENTA->setDbValueDef($rsnew, $this->TIP_USO_CUENTA->CurrentValue, NULL, FALSE);

		// TIPO_CUENTA
		$this->TIPO_CUENTA->setDbValueDef($rsnew, $this->TIPO_CUENTA->CurrentValue, NULL, FALSE);

		// NRO_CUENTA_CONTABLE
		$this->NRO_CUENTA_CONTABLE->setDbValueDef($rsnew, $this->NRO_CUENTA_CONTABLE->CurrentValue, NULL, FALSE);

		// CTA_CON_SEGURO
		$this->CTA_CON_SEGURO->setDbValueDef($rsnew, $this->CTA_CON_SEGURO->CurrentValue, NULL, FALSE);

		// ESTADO_BIEN
		$this->ESTADO_BIEN->setDbValueDef($rsnew, $this->ESTADO_BIEN->CurrentValue, NULL, FALSE);

		// CONDICION
		$this->CONDICION->setDbValueDef($rsnew, $this->CONDICION->CurrentValue, NULL, FALSE);

		// MARCA
		$this->MARCA->setDbValueDef($rsnew, $this->MARCA->CurrentValue, NULL, FALSE);

		// MODELO
		$this->MODELO->setDbValueDef($rsnew, $this->MODELO->CurrentValue, NULL, FALSE);

		// TIPO
		$this->TIPO->setDbValueDef($rsnew, $this->TIPO->CurrentValue, NULL, FALSE);

		// COLOR
		$this->COLOR->setDbValueDef($rsnew, $this->COLOR->CurrentValue, NULL, FALSE);

		// SERIE
		$this->SERIE->setDbValueDef($rsnew, $this->SERIE->CurrentValue, NULL, FALSE);

		// DIMENSION
		$this->DIMENSION->setDbValueDef($rsnew, $this->DIMENSION->CurrentValue, NULL, FALSE);

		// PLACA
		$this->PLACA->setDbValueDef($rsnew, $this->PLACA->CurrentValue, NULL, FALSE);

		// NRO_MOTOR
		$this->NRO_MOTOR->setDbValueDef($rsnew, $this->NRO_MOTOR->CurrentValue, NULL, FALSE);

		// NRO_CHASIS
		$this->NRO_CHASIS->setDbValueDef($rsnew, $this->NRO_CHASIS->CurrentValue, NULL, FALSE);

		// MATRICULA
		$this->MATRICULA->setDbValueDef($rsnew, $this->MATRICULA->CurrentValue, NULL, FALSE);

		// ANIO_FABRICACION
		$this->ANIO_FABRICACION->setDbValueDef($rsnew, $this->ANIO_FABRICACION->CurrentValue, NULL, FALSE);

		// LONGITUD
		$this->LONGITUD->setDbValueDef($rsnew, $this->LONGITUD->CurrentValue, NULL, FALSE);

		// ALTURA
		$this->ALTURA->setDbValueDef($rsnew, $this->ALTURA->CurrentValue, NULL, FALSE);

		// ANCHO
		$this->ANCHO->setDbValueDef($rsnew, $this->ANCHO->CurrentValue, NULL, FALSE);

		// RAZA
		$this->RAZA->setDbValueDef($rsnew, $this->RAZA->CurrentValue, NULL, FALSE);

		// ESPECIE
		$this->ESPECIE->setDbValueDef($rsnew, $this->ESPECIE->CurrentValue, NULL, FALSE);

		// EDAD
		$this->EDAD->setDbValueDef($rsnew, $this->EDAD->CurrentValue, NULL, FALSE);

		// PAIS
		$this->PAIS->setDbValueDef($rsnew, $this->PAIS->CurrentValue, NULL, FALSE);

		// OTRAS_CARACT
		$this->OTRAS_CARACT->setDbValueDef($rsnew, $this->OTRAS_CARACT->CurrentValue, NULL, FALSE);

		// DESCRIPCION_UBICACION_BIEN
		$this->DESCRIPCION_UBICACION_BIEN->setDbValueDef($rsnew, $this->DESCRIPCION_UBICACION_BIEN->CurrentValue, NULL, FALSE);

		// CAUSAL_BAJA
		$this->CAUSAL_BAJA->setDbValueDef($rsnew, $this->CAUSAL_BAJA->CurrentValue, NULL, FALSE);

		// NRO_RESOLUCION_BAJA
		$this->NRO_RESOLUCION_BAJA->setDbValueDef($rsnew, $this->NRO_RESOLUCION_BAJA->CurrentValue, NULL, FALSE);

		// FECHA_BAJA
		$this->FECHA_BAJA->setDbValueDef($rsnew, $this->FECHA_BAJA->CurrentValue, NULL, FALSE);

		// ACTO_DISPOSICION_BIEN
		$this->ACTO_DISPOSICION_BIEN->setDbValueDef($rsnew, $this->ACTO_DISPOSICION_BIEN->CurrentValue, NULL, FALSE);

		// NRO_RESOLUCION_DISP
		$this->NRO_RESOLUCION_DISP->setDbValueDef($rsnew, $this->NRO_RESOLUCION_DISP->CurrentValue, NULL, FALSE);

		// FECHA_DISPOSICION
		$this->FECHA_DISPOSICION->setDbValueDef($rsnew, $this->FECHA_DISPOSICION->CurrentValue, NULL, FALSE);

		// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setDbValueDef($rsnew, $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue, NULL, FALSE);

		// MOTIVO_ELIMINACION_BIEN
		$this->MOTIVO_ELIMINACION_BIEN->setDbValueDef($rsnew, $this->MOTIVO_ELIMINACION_BIEN->CurrentValue, NULL, FALSE);

		// ACTO_ADMINISTRACION_BIEN
		$this->ACTO_ADMINISTRACION_BIEN->setDbValueDef($rsnew, $this->ACTO_ADMINISTRACION_BIEN->CurrentValue, NULL, FALSE);

		// NUM_RESOLUCION_ADMINISTRACION
		$this->NUM_RESOLUCION_ADMINISTRACION->setDbValueDef($rsnew, $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue, NULL, FALSE);

		// FECHA_ADMINISTRACION
		$this->FECHA_ADMINISTRACION->setDbValueDef($rsnew, $this->FECHA_ADMINISTRACION->CurrentValue, NULL, FALSE);

		// FECHA_VENC_ACTO_ADMIN
		$this->FECHA_VENC_ACTO_ADMIN->setDbValueDef($rsnew, $this->FECHA_VENC_ACTO_ADMIN->CurrentValue, NULL, FALSE);

		// ENTIDAD_BENEFICIADA_ACTO_ADMIN
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setDbValueDef($rsnew, $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue, NULL, FALSE);

		// DOC_ALTA_SBN
		$this->DOC_ALTA_SBN->setDbValueDef($rsnew, $this->DOC_ALTA_SBN->CurrentValue, NULL, FALSE);

		// DOC_BAJA_SBN
		$this->DOC_BAJA_SBN->setDbValueDef($rsnew, $this->DOC_BAJA_SBN->CurrentValue, NULL, FALSE);

		// DEPENDENCIAS
		$this->DEPENDENCIAS->setDbValueDef($rsnew, $this->DEPENDENCIAS->CurrentValue, NULL, FALSE);

		// NUMERO_FICHA
		$this->NUMERO_FICHA->setDbValueDef($rsnew, $this->NUMERO_FICHA->CurrentValue, NULL, FALSE);

		// CODIGO_INTERNO
		$this->CODIGO_INTERNO->setDbValueDef($rsnew, $this->CODIGO_INTERNO->CurrentValue, NULL, FALSE);

		// ESTADO
		$this->ESTADO->setDbValueDef($rsnew, $this->ESTADO->CurrentValue, NULL, strval($this->ESTADO->CurrentValue) == "");

		// USO
		$this->USO->setDbValueDef($rsnew, $this->USO->CurrentValue, NULL, FALSE);

		// STICKER
		$this->STICKER->setDbValueDef($rsnew, $this->STICKER->CurrentValue, NULL, FALSE);

		// SEDE
		$this->SEDE->setDbValueDef($rsnew, $this->SEDE->CurrentValue, NULL, FALSE);

		// SBN
		$this->SBN->setDbValueDef($rsnew, $this->SBN->CurrentValue, NULL, FALSE);

		// ETIQUETA
		$this->ETIQUETA->setDbValueDef($rsnew, $this->ETIQUETA->CurrentValue, NULL, FALSE);

		// NOMBRE_BENEFICIARIO_ACTO_ADMIN
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setDbValueDef($rsnew, $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue, NULL, FALSE);

		// PLACA_RODAJE
		$this->PLACA_RODAJE->setDbValueDef($rsnew, $this->PLACA_RODAJE->CurrentValue, NULL, FALSE);

		// CODIGO_ACTUAL
		$this->CODIGO_ACTUAL->setDbValueDef($rsnew, $this->CODIGO_ACTUAL->CurrentValue, NULL, FALSE);

		// CODIGO_ANTERIOR
		$this->CODIGO_ANTERIOR->setDbValueDef($rsnew, $this->CODIGO_ANTERIOR->CurrentValue, NULL, FALSE);

		// PROPIEDAD
		$this->PROPIEDAD->setDbValueDef($rsnew, $this->PROPIEDAD->CurrentValue, NULL, FALSE);

		// SITUACION
		$this->SITUACION->setDbValueDef($rsnew, $this->SITUACION->CurrentValue, NULL, FALSE);

		// OBSERVACIONES
		$this->OBSERVACIONES->setDbValueDef($rsnew, $this->OBSERVACIONES->CurrentValue, NULL, FALSE);

		// FECHA_REGISTRO
		$this->FECHA_REGISTRO->setDbValueDef($rsnew, UnFormatDateTime($this->FECHA_REGISTRO->CurrentValue, 0), NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("procesos_nuevolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>