<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for kp_usuarios
 */
class kp_usuarios extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $codlogin;
	public $codpassword;
	public $nomusuario;
	public $apeusuario;
	public $tipo;
	public $fecha_reg;
	public $dniusuario;
	public $telefonousuario;
	public $celularusuario;
	public $direccionusuario;
	public $emailcorpusuario;
	public $emailusuario;
	public $iddisciplina;
	public $idperfil;
	public $mostrarcalendario;
	public $obsusuario;
	public $verificaringreso;
	public $estadousuario;
	public $idcategoria;
	public $tipo_usuario;
	public $idempresa;
	public $idusuario;
	public $estado;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'kp_usuarios';
		$this->TableName = 'kp_usuarios';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`kp_usuarios`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// codlogin
		$this->codlogin = new DbField('kp_usuarios', 'kp_usuarios', 'x_codlogin', 'codlogin', '`codlogin`', '`codlogin`', 200, 100, -1, FALSE, '`codlogin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codlogin->Nullable = FALSE; // NOT NULL field
		$this->codlogin->Required = TRUE; // Required field
		$this->codlogin->Sortable = TRUE; // Allow sort
		$this->fields['codlogin'] = &$this->codlogin;

		// codpassword
		$this->codpassword = new DbField('kp_usuarios', 'kp_usuarios', 'x_codpassword', 'codpassword', '`codpassword`', '`codpassword`', 200, 100, -1, FALSE, '`codpassword`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codpassword->Sortable = TRUE; // Allow sort
		$this->fields['codpassword'] = &$this->codpassword;

		// nomusuario
		$this->nomusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_nomusuario', 'nomusuario', '`nomusuario`', '`nomusuario`', 200, 100, -1, FALSE, '`nomusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomusuario->Sortable = TRUE; // Allow sort
		$this->fields['nomusuario'] = &$this->nomusuario;

		// apeusuario
		$this->apeusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_apeusuario', 'apeusuario', '`apeusuario`', '`apeusuario`', 200, 200, -1, FALSE, '`apeusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->apeusuario->Nullable = FALSE; // NOT NULL field
		$this->apeusuario->Required = TRUE; // Required field
		$this->apeusuario->Sortable = TRUE; // Allow sort
		$this->fields['apeusuario'] = &$this->apeusuario;

		// tipo
		$this->tipo = new DbField('kp_usuarios', 'kp_usuarios', 'x_tipo', 'tipo', '`tipo`', '`tipo`', 200, 200, -1, FALSE, '`tipo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo->Sortable = TRUE; // Allow sort
		$this->fields['tipo'] = &$this->tipo;

		// fecha_reg
		$this->fecha_reg = new DbField('kp_usuarios', 'kp_usuarios', 'x_fecha_reg', 'fecha_reg', '`fecha_reg`', CastDateFieldForLike("`fecha_reg`", 0, "DB"), 135, 19, 0, FALSE, '`fecha_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha_reg->Sortable = TRUE; // Allow sort
		$this->fecha_reg->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha_reg'] = &$this->fecha_reg;

		// dniusuario
		$this->dniusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_dniusuario', 'dniusuario', '`dniusuario`', '`dniusuario`', 200, 30, -1, FALSE, '`dniusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dniusuario->Sortable = TRUE; // Allow sort
		$this->fields['dniusuario'] = &$this->dniusuario;

		// telefonousuario
		$this->telefonousuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_telefonousuario', 'telefonousuario', '`telefonousuario`', '`telefonousuario`', 200, 30, -1, FALSE, '`telefonousuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->telefonousuario->Sortable = TRUE; // Allow sort
		$this->fields['telefonousuario'] = &$this->telefonousuario;

		// celularusuario
		$this->celularusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_celularusuario', 'celularusuario', '`celularusuario`', '`celularusuario`', 200, 30, -1, FALSE, '`celularusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->celularusuario->Sortable = TRUE; // Allow sort
		$this->fields['celularusuario'] = &$this->celularusuario;

		// direccionusuario
		$this->direccionusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_direccionusuario', 'direccionusuario', '`direccionusuario`', '`direccionusuario`', 200, 220, -1, FALSE, '`direccionusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->direccionusuario->Sortable = TRUE; // Allow sort
		$this->fields['direccionusuario'] = &$this->direccionusuario;

		// emailcorpusuario
		$this->emailcorpusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_emailcorpusuario', 'emailcorpusuario', '`emailcorpusuario`', '`emailcorpusuario`', 200, 100, -1, FALSE, '`emailcorpusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emailcorpusuario->Sortable = TRUE; // Allow sort
		$this->fields['emailcorpusuario'] = &$this->emailcorpusuario;

		// emailusuario
		$this->emailusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_emailusuario', 'emailusuario', '`emailusuario`', '`emailusuario`', 200, 200, -1, FALSE, '`emailusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emailusuario->Sortable = TRUE; // Allow sort
		$this->fields['emailusuario'] = &$this->emailusuario;

		// iddisciplina
		$this->iddisciplina = new DbField('kp_usuarios', 'kp_usuarios', 'x_iddisciplina', 'iddisciplina', '`iddisciplina`', '`iddisciplina`', 3, 11, -1, FALSE, '`iddisciplina`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->iddisciplina->Sortable = TRUE; // Allow sort
		$this->iddisciplina->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddisciplina'] = &$this->iddisciplina;

		// idperfil
		$this->idperfil = new DbField('kp_usuarios', 'kp_usuarios', 'x_idperfil', 'idperfil', '`idperfil`', '`idperfil`', 3, 11, -1, FALSE, '`idperfil`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idperfil->Sortable = TRUE; // Allow sort
		$this->idperfil->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idperfil'] = &$this->idperfil;

		// mostrarcalendario
		$this->mostrarcalendario = new DbField('kp_usuarios', 'kp_usuarios', 'x_mostrarcalendario', 'mostrarcalendario', '`mostrarcalendario`', '`mostrarcalendario`', 3, 11, -1, FALSE, '`mostrarcalendario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mostrarcalendario->Sortable = TRUE; // Allow sort
		$this->mostrarcalendario->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mostrarcalendario'] = &$this->mostrarcalendario;

		// obsusuario
		$this->obsusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_obsusuario', 'obsusuario', '`obsusuario`', '`obsusuario`', 201, 65535, -1, FALSE, '`obsusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->obsusuario->Sortable = TRUE; // Allow sort
		$this->fields['obsusuario'] = &$this->obsusuario;

		// verificaringreso
		$this->verificaringreso = new DbField('kp_usuarios', 'kp_usuarios', 'x_verificaringreso', 'verificaringreso', '`verificaringreso`', '`verificaringreso`', 3, 11, -1, FALSE, '`verificaringreso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->verificaringreso->Sortable = TRUE; // Allow sort
		$this->verificaringreso->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['verificaringreso'] = &$this->verificaringreso;

		// estadousuario
		$this->estadousuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_estadousuario', 'estadousuario', '`estadousuario`', '`estadousuario`', 3, 11, -1, FALSE, '`estadousuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estadousuario->Sortable = TRUE; // Allow sort
		$this->estadousuario->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estadousuario'] = &$this->estadousuario;

		// idcategoria
		$this->idcategoria = new DbField('kp_usuarios', 'kp_usuarios', 'x_idcategoria', 'idcategoria', '`idcategoria`', '`idcategoria`', 3, 11, -1, FALSE, '`idcategoria`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idcategoria->Sortable = TRUE; // Allow sort
		$this->idcategoria->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idcategoria'] = &$this->idcategoria;

		// tipo_usuario
		$this->tipo_usuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_tipo_usuario', 'tipo_usuario', '`tipo_usuario`', '`tipo_usuario`', 3, 11, -1, FALSE, '`tipo_usuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_usuario->Sortable = TRUE; // Allow sort
		$this->tipo_usuario->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_usuario'] = &$this->tipo_usuario;

		// idempresa
		$this->idempresa = new DbField('kp_usuarios', 'kp_usuarios', 'x_idempresa', 'idempresa', '`idempresa`', '`idempresa`', 3, 11, -1, FALSE, '`idempresa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idempresa->Sortable = TRUE; // Allow sort
		$this->idempresa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idempresa'] = &$this->idempresa;

		// idusuario
		$this->idusuario = new DbField('kp_usuarios', 'kp_usuarios', 'x_idusuario', 'idusuario', '`idusuario`', '`idusuario`', 3, 11, -1, FALSE, '`idusuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idusuario->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idusuario->IsPrimaryKey = TRUE; // Primary key field
		$this->idusuario->Sortable = TRUE; // Allow sort
		$this->idusuario->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idusuario'] = &$this->idusuario;

		// estado
		$this->estado = new DbField('kp_usuarios', 'kp_usuarios', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`kp_usuarios`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idusuario->setDbValue($conn->insert_ID());
			$rs['idusuario'] = $this->idusuario->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idusuario', $rs))
				AddFilter($where, QuotedName('idusuario', $this->Dbid) . '=' . QuotedValue($rs['idusuario'], $this->idusuario->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->codlogin->DbValue = $row['codlogin'];
		$this->codpassword->DbValue = $row['codpassword'];
		$this->nomusuario->DbValue = $row['nomusuario'];
		$this->apeusuario->DbValue = $row['apeusuario'];
		$this->tipo->DbValue = $row['tipo'];
		$this->fecha_reg->DbValue = $row['fecha_reg'];
		$this->dniusuario->DbValue = $row['dniusuario'];
		$this->telefonousuario->DbValue = $row['telefonousuario'];
		$this->celularusuario->DbValue = $row['celularusuario'];
		$this->direccionusuario->DbValue = $row['direccionusuario'];
		$this->emailcorpusuario->DbValue = $row['emailcorpusuario'];
		$this->emailusuario->DbValue = $row['emailusuario'];
		$this->iddisciplina->DbValue = $row['iddisciplina'];
		$this->idperfil->DbValue = $row['idperfil'];
		$this->mostrarcalendario->DbValue = $row['mostrarcalendario'];
		$this->obsusuario->DbValue = $row['obsusuario'];
		$this->verificaringreso->DbValue = $row['verificaringreso'];
		$this->estadousuario->DbValue = $row['estadousuario'];
		$this->idcategoria->DbValue = $row['idcategoria'];
		$this->tipo_usuario->DbValue = $row['tipo_usuario'];
		$this->idempresa->DbValue = $row['idempresa'];
		$this->idusuario->DbValue = $row['idusuario'];
		$this->estado->DbValue = $row['estado'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idusuario` = @idusuario@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idusuario', $row) ? $row['idusuario'] : NULL;
		else
			$val = $this->idusuario->OldValue !== NULL ? $this->idusuario->OldValue : $this->idusuario->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idusuario@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "kp_usuarioslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "kp_usuariosview.php")
			return $Language->phrase("View");
		elseif ($pageName == "kp_usuariosedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "kp_usuariosadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "kp_usuarioslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("kp_usuariosview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("kp_usuariosview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "kp_usuariosadd.php?" . $this->getUrlParm($parm);
		else
			$url = "kp_usuariosadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("kp_usuariosedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("kp_usuariosadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("kp_usuariosdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idusuario:" . JsonEncode($this->idusuario->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idusuario->CurrentValue != NULL) {
			$url .= "idusuario=" . urlencode($this->idusuario->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idusuario") !== NULL)
				$arKeys[] = Param("idusuario");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idusuario->CurrentValue = $key;
			else
				$this->idusuario->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->codlogin->setDbValue($rs->fields('codlogin'));
		$this->codpassword->setDbValue($rs->fields('codpassword'));
		$this->nomusuario->setDbValue($rs->fields('nomusuario'));
		$this->apeusuario->setDbValue($rs->fields('apeusuario'));
		$this->tipo->setDbValue($rs->fields('tipo'));
		$this->fecha_reg->setDbValue($rs->fields('fecha_reg'));
		$this->dniusuario->setDbValue($rs->fields('dniusuario'));
		$this->telefonousuario->setDbValue($rs->fields('telefonousuario'));
		$this->celularusuario->setDbValue($rs->fields('celularusuario'));
		$this->direccionusuario->setDbValue($rs->fields('direccionusuario'));
		$this->emailcorpusuario->setDbValue($rs->fields('emailcorpusuario'));
		$this->emailusuario->setDbValue($rs->fields('emailusuario'));
		$this->iddisciplina->setDbValue($rs->fields('iddisciplina'));
		$this->idperfil->setDbValue($rs->fields('idperfil'));
		$this->mostrarcalendario->setDbValue($rs->fields('mostrarcalendario'));
		$this->obsusuario->setDbValue($rs->fields('obsusuario'));
		$this->verificaringreso->setDbValue($rs->fields('verificaringreso'));
		$this->estadousuario->setDbValue($rs->fields('estadousuario'));
		$this->idcategoria->setDbValue($rs->fields('idcategoria'));
		$this->tipo_usuario->setDbValue($rs->fields('tipo_usuario'));
		$this->idempresa->setDbValue($rs->fields('idempresa'));
		$this->idusuario->setDbValue($rs->fields('idusuario'));
		$this->estado->setDbValue($rs->fields('estado'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// codlogin
		// codpassword
		// nomusuario
		// apeusuario
		// tipo
		// fecha_reg
		// dniusuario
		// telefonousuario
		// celularusuario
		// direccionusuario
		// emailcorpusuario
		// emailusuario
		// iddisciplina
		// idperfil
		// mostrarcalendario
		// obsusuario
		// verificaringreso
		// estadousuario
		// idcategoria
		// tipo_usuario
		// idempresa
		// idusuario
		// estado
		// codlogin

		$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
		$this->codlogin->ViewCustomAttributes = "";

		// codpassword
		$this->codpassword->ViewValue = $this->codpassword->CurrentValue;
		$this->codpassword->ViewCustomAttributes = "";

		// nomusuario
		$this->nomusuario->ViewValue = $this->nomusuario->CurrentValue;
		$this->nomusuario->ViewCustomAttributes = "";

		// apeusuario
		$this->apeusuario->ViewValue = $this->apeusuario->CurrentValue;
		$this->apeusuario->ViewCustomAttributes = "";

		// tipo
		$this->tipo->ViewValue = $this->tipo->CurrentValue;
		$this->tipo->ViewCustomAttributes = "";

		// fecha_reg
		$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
		$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
		$this->fecha_reg->ViewCustomAttributes = "";

		// dniusuario
		$this->dniusuario->ViewValue = $this->dniusuario->CurrentValue;
		$this->dniusuario->ViewCustomAttributes = "";

		// telefonousuario
		$this->telefonousuario->ViewValue = $this->telefonousuario->CurrentValue;
		$this->telefonousuario->ViewCustomAttributes = "";

		// celularusuario
		$this->celularusuario->ViewValue = $this->celularusuario->CurrentValue;
		$this->celularusuario->ViewCustomAttributes = "";

		// direccionusuario
		$this->direccionusuario->ViewValue = $this->direccionusuario->CurrentValue;
		$this->direccionusuario->ViewCustomAttributes = "";

		// emailcorpusuario
		$this->emailcorpusuario->ViewValue = $this->emailcorpusuario->CurrentValue;
		$this->emailcorpusuario->ViewCustomAttributes = "";

		// emailusuario
		$this->emailusuario->ViewValue = $this->emailusuario->CurrentValue;
		$this->emailusuario->ViewCustomAttributes = "";

		// iddisciplina
		$this->iddisciplina->ViewValue = $this->iddisciplina->CurrentValue;
		$this->iddisciplina->ViewValue = FormatNumber($this->iddisciplina->ViewValue, 0, -2, -2, -2);
		$this->iddisciplina->ViewCustomAttributes = "";

		// idperfil
		$this->idperfil->ViewValue = $this->idperfil->CurrentValue;
		$this->idperfil->ViewValue = FormatNumber($this->idperfil->ViewValue, 0, -2, -2, -2);
		$this->idperfil->ViewCustomAttributes = "";

		// mostrarcalendario
		$this->mostrarcalendario->ViewValue = $this->mostrarcalendario->CurrentValue;
		$this->mostrarcalendario->ViewValue = FormatNumber($this->mostrarcalendario->ViewValue, 0, -2, -2, -2);
		$this->mostrarcalendario->ViewCustomAttributes = "";

		// obsusuario
		$this->obsusuario->ViewValue = $this->obsusuario->CurrentValue;
		$this->obsusuario->ViewCustomAttributes = "";

		// verificaringreso
		$this->verificaringreso->ViewValue = $this->verificaringreso->CurrentValue;
		$this->verificaringreso->ViewValue = FormatNumber($this->verificaringreso->ViewValue, 0, -2, -2, -2);
		$this->verificaringreso->ViewCustomAttributes = "";

		// estadousuario
		$this->estadousuario->ViewValue = $this->estadousuario->CurrentValue;
		$this->estadousuario->ViewValue = FormatNumber($this->estadousuario->ViewValue, 0, -2, -2, -2);
		$this->estadousuario->ViewCustomAttributes = "";

		// idcategoria
		$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
		$this->idcategoria->ViewCustomAttributes = "";

		// tipo_usuario
		$this->tipo_usuario->ViewValue = $this->tipo_usuario->CurrentValue;
		$this->tipo_usuario->ViewValue = FormatNumber($this->tipo_usuario->ViewValue, 0, -2, -2, -2);
		$this->tipo_usuario->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
		$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
		$this->idempresa->ViewCustomAttributes = "";

		// idusuario
		$this->idusuario->ViewValue = $this->idusuario->CurrentValue;
		$this->idusuario->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// codlogin
		$this->codlogin->LinkCustomAttributes = "";
		$this->codlogin->HrefValue = "";
		$this->codlogin->TooltipValue = "";

		// codpassword
		$this->codpassword->LinkCustomAttributes = "";
		$this->codpassword->HrefValue = "";
		$this->codpassword->TooltipValue = "";

		// nomusuario
		$this->nomusuario->LinkCustomAttributes = "";
		$this->nomusuario->HrefValue = "";
		$this->nomusuario->TooltipValue = "";

		// apeusuario
		$this->apeusuario->LinkCustomAttributes = "";
		$this->apeusuario->HrefValue = "";
		$this->apeusuario->TooltipValue = "";

		// tipo
		$this->tipo->LinkCustomAttributes = "";
		$this->tipo->HrefValue = "";
		$this->tipo->TooltipValue = "";

		// fecha_reg
		$this->fecha_reg->LinkCustomAttributes = "";
		$this->fecha_reg->HrefValue = "";
		$this->fecha_reg->TooltipValue = "";

		// dniusuario
		$this->dniusuario->LinkCustomAttributes = "";
		$this->dniusuario->HrefValue = "";
		$this->dniusuario->TooltipValue = "";

		// telefonousuario
		$this->telefonousuario->LinkCustomAttributes = "";
		$this->telefonousuario->HrefValue = "";
		$this->telefonousuario->TooltipValue = "";

		// celularusuario
		$this->celularusuario->LinkCustomAttributes = "";
		$this->celularusuario->HrefValue = "";
		$this->celularusuario->TooltipValue = "";

		// direccionusuario
		$this->direccionusuario->LinkCustomAttributes = "";
		$this->direccionusuario->HrefValue = "";
		$this->direccionusuario->TooltipValue = "";

		// emailcorpusuario
		$this->emailcorpusuario->LinkCustomAttributes = "";
		$this->emailcorpusuario->HrefValue = "";
		$this->emailcorpusuario->TooltipValue = "";

		// emailusuario
		$this->emailusuario->LinkCustomAttributes = "";
		$this->emailusuario->HrefValue = "";
		$this->emailusuario->TooltipValue = "";

		// iddisciplina
		$this->iddisciplina->LinkCustomAttributes = "";
		$this->iddisciplina->HrefValue = "";
		$this->iddisciplina->TooltipValue = "";

		// idperfil
		$this->idperfil->LinkCustomAttributes = "";
		$this->idperfil->HrefValue = "";
		$this->idperfil->TooltipValue = "";

		// mostrarcalendario
		$this->mostrarcalendario->LinkCustomAttributes = "";
		$this->mostrarcalendario->HrefValue = "";
		$this->mostrarcalendario->TooltipValue = "";

		// obsusuario
		$this->obsusuario->LinkCustomAttributes = "";
		$this->obsusuario->HrefValue = "";
		$this->obsusuario->TooltipValue = "";

		// verificaringreso
		$this->verificaringreso->LinkCustomAttributes = "";
		$this->verificaringreso->HrefValue = "";
		$this->verificaringreso->TooltipValue = "";

		// estadousuario
		$this->estadousuario->LinkCustomAttributes = "";
		$this->estadousuario->HrefValue = "";
		$this->estadousuario->TooltipValue = "";

		// idcategoria
		$this->idcategoria->LinkCustomAttributes = "";
		$this->idcategoria->HrefValue = "";
		$this->idcategoria->TooltipValue = "";

		// tipo_usuario
		$this->tipo_usuario->LinkCustomAttributes = "";
		$this->tipo_usuario->HrefValue = "";
		$this->tipo_usuario->TooltipValue = "";

		// idempresa
		$this->idempresa->LinkCustomAttributes = "";
		$this->idempresa->HrefValue = "";
		$this->idempresa->TooltipValue = "";

		// idusuario
		$this->idusuario->LinkCustomAttributes = "";
		$this->idusuario->HrefValue = "";
		$this->idusuario->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// codlogin
		$this->codlogin->EditAttrs["class"] = "form-control";
		$this->codlogin->EditCustomAttributes = "";
		if (!$this->codlogin->Raw)
			$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
		$this->codlogin->EditValue = $this->codlogin->CurrentValue;
		$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

		// codpassword
		$this->codpassword->EditAttrs["class"] = "form-control";
		$this->codpassword->EditCustomAttributes = "";
		if (!$this->codpassword->Raw)
			$this->codpassword->CurrentValue = HtmlDecode($this->codpassword->CurrentValue);
		$this->codpassword->EditValue = $this->codpassword->CurrentValue;
		$this->codpassword->PlaceHolder = RemoveHtml($this->codpassword->caption());

		// nomusuario
		$this->nomusuario->EditAttrs["class"] = "form-control";
		$this->nomusuario->EditCustomAttributes = "";
		if (!$this->nomusuario->Raw)
			$this->nomusuario->CurrentValue = HtmlDecode($this->nomusuario->CurrentValue);
		$this->nomusuario->EditValue = $this->nomusuario->CurrentValue;
		$this->nomusuario->PlaceHolder = RemoveHtml($this->nomusuario->caption());

		// apeusuario
		$this->apeusuario->EditAttrs["class"] = "form-control";
		$this->apeusuario->EditCustomAttributes = "";
		if (!$this->apeusuario->Raw)
			$this->apeusuario->CurrentValue = HtmlDecode($this->apeusuario->CurrentValue);
		$this->apeusuario->EditValue = $this->apeusuario->CurrentValue;
		$this->apeusuario->PlaceHolder = RemoveHtml($this->apeusuario->caption());

		// tipo
		$this->tipo->EditAttrs["class"] = "form-control";
		$this->tipo->EditCustomAttributes = "";
		if (!$this->tipo->Raw)
			$this->tipo->CurrentValue = HtmlDecode($this->tipo->CurrentValue);
		$this->tipo->EditValue = $this->tipo->CurrentValue;
		$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

		// fecha_reg
		$this->fecha_reg->EditAttrs["class"] = "form-control";
		$this->fecha_reg->EditCustomAttributes = "";
		$this->fecha_reg->EditValue = FormatDateTime($this->fecha_reg->CurrentValue, 8);
		$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

		// dniusuario
		$this->dniusuario->EditAttrs["class"] = "form-control";
		$this->dniusuario->EditCustomAttributes = "";
		if (!$this->dniusuario->Raw)
			$this->dniusuario->CurrentValue = HtmlDecode($this->dniusuario->CurrentValue);
		$this->dniusuario->EditValue = $this->dniusuario->CurrentValue;
		$this->dniusuario->PlaceHolder = RemoveHtml($this->dniusuario->caption());

		// telefonousuario
		$this->telefonousuario->EditAttrs["class"] = "form-control";
		$this->telefonousuario->EditCustomAttributes = "";
		if (!$this->telefonousuario->Raw)
			$this->telefonousuario->CurrentValue = HtmlDecode($this->telefonousuario->CurrentValue);
		$this->telefonousuario->EditValue = $this->telefonousuario->CurrentValue;
		$this->telefonousuario->PlaceHolder = RemoveHtml($this->telefonousuario->caption());

		// celularusuario
		$this->celularusuario->EditAttrs["class"] = "form-control";
		$this->celularusuario->EditCustomAttributes = "";
		if (!$this->celularusuario->Raw)
			$this->celularusuario->CurrentValue = HtmlDecode($this->celularusuario->CurrentValue);
		$this->celularusuario->EditValue = $this->celularusuario->CurrentValue;
		$this->celularusuario->PlaceHolder = RemoveHtml($this->celularusuario->caption());

		// direccionusuario
		$this->direccionusuario->EditAttrs["class"] = "form-control";
		$this->direccionusuario->EditCustomAttributes = "";
		if (!$this->direccionusuario->Raw)
			$this->direccionusuario->CurrentValue = HtmlDecode($this->direccionusuario->CurrentValue);
		$this->direccionusuario->EditValue = $this->direccionusuario->CurrentValue;
		$this->direccionusuario->PlaceHolder = RemoveHtml($this->direccionusuario->caption());

		// emailcorpusuario
		$this->emailcorpusuario->EditAttrs["class"] = "form-control";
		$this->emailcorpusuario->EditCustomAttributes = "";
		if (!$this->emailcorpusuario->Raw)
			$this->emailcorpusuario->CurrentValue = HtmlDecode($this->emailcorpusuario->CurrentValue);
		$this->emailcorpusuario->EditValue = $this->emailcorpusuario->CurrentValue;
		$this->emailcorpusuario->PlaceHolder = RemoveHtml($this->emailcorpusuario->caption());

		// emailusuario
		$this->emailusuario->EditAttrs["class"] = "form-control";
		$this->emailusuario->EditCustomAttributes = "";
		if (!$this->emailusuario->Raw)
			$this->emailusuario->CurrentValue = HtmlDecode($this->emailusuario->CurrentValue);
		$this->emailusuario->EditValue = $this->emailusuario->CurrentValue;
		$this->emailusuario->PlaceHolder = RemoveHtml($this->emailusuario->caption());

		// iddisciplina
		$this->iddisciplina->EditAttrs["class"] = "form-control";
		$this->iddisciplina->EditCustomAttributes = "";
		$this->iddisciplina->EditValue = $this->iddisciplina->CurrentValue;
		$this->iddisciplina->PlaceHolder = RemoveHtml($this->iddisciplina->caption());

		// idperfil
		$this->idperfil->EditAttrs["class"] = "form-control";
		$this->idperfil->EditCustomAttributes = "";
		$this->idperfil->EditValue = $this->idperfil->CurrentValue;
		$this->idperfil->PlaceHolder = RemoveHtml($this->idperfil->caption());

		// mostrarcalendario
		$this->mostrarcalendario->EditAttrs["class"] = "form-control";
		$this->mostrarcalendario->EditCustomAttributes = "";
		$this->mostrarcalendario->EditValue = $this->mostrarcalendario->CurrentValue;
		$this->mostrarcalendario->PlaceHolder = RemoveHtml($this->mostrarcalendario->caption());

		// obsusuario
		$this->obsusuario->EditAttrs["class"] = "form-control";
		$this->obsusuario->EditCustomAttributes = "";
		$this->obsusuario->EditValue = $this->obsusuario->CurrentValue;
		$this->obsusuario->PlaceHolder = RemoveHtml($this->obsusuario->caption());

		// verificaringreso
		$this->verificaringreso->EditAttrs["class"] = "form-control";
		$this->verificaringreso->EditCustomAttributes = "";
		$this->verificaringreso->EditValue = $this->verificaringreso->CurrentValue;
		$this->verificaringreso->PlaceHolder = RemoveHtml($this->verificaringreso->caption());

		// estadousuario
		$this->estadousuario->EditAttrs["class"] = "form-control";
		$this->estadousuario->EditCustomAttributes = "";
		$this->estadousuario->EditValue = $this->estadousuario->CurrentValue;
		$this->estadousuario->PlaceHolder = RemoveHtml($this->estadousuario->caption());

		// idcategoria
		$this->idcategoria->EditAttrs["class"] = "form-control";
		$this->idcategoria->EditCustomAttributes = "";
		$this->idcategoria->EditValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

		// tipo_usuario
		$this->tipo_usuario->EditAttrs["class"] = "form-control";
		$this->tipo_usuario->EditCustomAttributes = "";
		$this->tipo_usuario->EditValue = $this->tipo_usuario->CurrentValue;
		$this->tipo_usuario->PlaceHolder = RemoveHtml($this->tipo_usuario->caption());

		// idempresa
		$this->idempresa->EditAttrs["class"] = "form-control";
		$this->idempresa->EditCustomAttributes = "";
		$this->idempresa->EditValue = $this->idempresa->CurrentValue;
		$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

		// idusuario
		$this->idusuario->EditAttrs["class"] = "form-control";
		$this->idusuario->EditCustomAttributes = "";
		$this->idusuario->EditValue = $this->idusuario->CurrentValue;
		$this->idusuario->ViewCustomAttributes = "";

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->codpassword);
					$doc->exportCaption($this->nomusuario);
					$doc->exportCaption($this->apeusuario);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->fecha_reg);
					$doc->exportCaption($this->dniusuario);
					$doc->exportCaption($this->telefonousuario);
					$doc->exportCaption($this->celularusuario);
					$doc->exportCaption($this->direccionusuario);
					$doc->exportCaption($this->emailcorpusuario);
					$doc->exportCaption($this->emailusuario);
					$doc->exportCaption($this->iddisciplina);
					$doc->exportCaption($this->idperfil);
					$doc->exportCaption($this->mostrarcalendario);
					$doc->exportCaption($this->obsusuario);
					$doc->exportCaption($this->verificaringreso);
					$doc->exportCaption($this->estadousuario);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->tipo_usuario);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->idusuario);
					$doc->exportCaption($this->estado);
				} else {
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->codpassword);
					$doc->exportCaption($this->nomusuario);
					$doc->exportCaption($this->apeusuario);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->fecha_reg);
					$doc->exportCaption($this->dniusuario);
					$doc->exportCaption($this->telefonousuario);
					$doc->exportCaption($this->celularusuario);
					$doc->exportCaption($this->direccionusuario);
					$doc->exportCaption($this->emailcorpusuario);
					$doc->exportCaption($this->emailusuario);
					$doc->exportCaption($this->iddisciplina);
					$doc->exportCaption($this->idperfil);
					$doc->exportCaption($this->mostrarcalendario);
					$doc->exportCaption($this->verificaringreso);
					$doc->exportCaption($this->estadousuario);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->tipo_usuario);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->idusuario);
					$doc->exportCaption($this->estado);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->codlogin);
						$doc->exportField($this->codpassword);
						$doc->exportField($this->nomusuario);
						$doc->exportField($this->apeusuario);
						$doc->exportField($this->tipo);
						$doc->exportField($this->fecha_reg);
						$doc->exportField($this->dniusuario);
						$doc->exportField($this->telefonousuario);
						$doc->exportField($this->celularusuario);
						$doc->exportField($this->direccionusuario);
						$doc->exportField($this->emailcorpusuario);
						$doc->exportField($this->emailusuario);
						$doc->exportField($this->iddisciplina);
						$doc->exportField($this->idperfil);
						$doc->exportField($this->mostrarcalendario);
						$doc->exportField($this->obsusuario);
						$doc->exportField($this->verificaringreso);
						$doc->exportField($this->estadousuario);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->tipo_usuario);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->idusuario);
						$doc->exportField($this->estado);
					} else {
						$doc->exportField($this->codlogin);
						$doc->exportField($this->codpassword);
						$doc->exportField($this->nomusuario);
						$doc->exportField($this->apeusuario);
						$doc->exportField($this->tipo);
						$doc->exportField($this->fecha_reg);
						$doc->exportField($this->dniusuario);
						$doc->exportField($this->telefonousuario);
						$doc->exportField($this->celularusuario);
						$doc->exportField($this->direccionusuario);
						$doc->exportField($this->emailcorpusuario);
						$doc->exportField($this->emailusuario);
						$doc->exportField($this->iddisciplina);
						$doc->exportField($this->idperfil);
						$doc->exportField($this->mostrarcalendario);
						$doc->exportField($this->verificaringreso);
						$doc->exportField($this->estadousuario);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->tipo_usuario);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->idusuario);
						$doc->exportField($this->estado);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>