<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for kp_proyecto
 */
class kp_proyecto extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idproyecto;
	public $titulo;
	public $nombre;
	public $descproyecto;
	public $ubicacion;
	public $cuotas;
	public $foto;
	public $video;
	public $estado;
	public $status;
	public $idcategoria;
	public $descuento;
	public $precio;
	public $tipo_entrega;
	public $metros_cuadrados;
	public $url;
	public $idempresa;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'kp_proyecto';
		$this->TableName = 'kp_proyecto';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`kp_proyecto`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idproyecto
		$this->idproyecto = new DbField('kp_proyecto', 'kp_proyecto', 'x_idproyecto', 'idproyecto', '`idproyecto`', '`idproyecto`', 3, 11, -1, FALSE, '`idproyecto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idproyecto->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idproyecto->IsPrimaryKey = TRUE; // Primary key field
		$this->idproyecto->Sortable = TRUE; // Allow sort
		$this->idproyecto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idproyecto'] = &$this->idproyecto;

		// titulo
		$this->titulo = new DbField('kp_proyecto', 'kp_proyecto', 'x_titulo', 'titulo', '`titulo`', '`titulo`', 200, 250, -1, FALSE, '`titulo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->titulo->Sortable = TRUE; // Allow sort
		$this->fields['titulo'] = &$this->titulo;

		// nombre
		$this->nombre = new DbField('kp_proyecto', 'kp_proyecto', 'x_nombre', 'nombre', '`nombre`', '`nombre`', 200, 50, -1, FALSE, '`nombre`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombre->Sortable = TRUE; // Allow sort
		$this->fields['nombre'] = &$this->nombre;

		// descproyecto
		$this->descproyecto = new DbField('kp_proyecto', 'kp_proyecto', 'x_descproyecto', 'descproyecto', '`descproyecto`', '`descproyecto`', 201, 65535, -1, FALSE, '`descproyecto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->descproyecto->Sortable = TRUE; // Allow sort
		$this->fields['descproyecto'] = &$this->descproyecto;

		// ubicacion
		$this->ubicacion = new DbField('kp_proyecto', 'kp_proyecto', 'x_ubicacion', 'ubicacion', '`ubicacion`', '`ubicacion`', 200, 250, -1, FALSE, '`ubicacion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ubicacion->Sortable = TRUE; // Allow sort
		$this->fields['ubicacion'] = &$this->ubicacion;

		// cuotas
		$this->cuotas = new DbField('kp_proyecto', 'kp_proyecto', 'x_cuotas', 'cuotas', '`cuotas`', '`cuotas`', 3, 11, -1, FALSE, '`cuotas`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cuotas->Sortable = TRUE; // Allow sort
		$this->cuotas->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cuotas'] = &$this->cuotas;

		// foto
		$this->foto = new DbField('kp_proyecto', 'kp_proyecto', 'x_foto', 'foto', '`foto`', '`foto`', 200, 250, -1, FALSE, '`foto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto->Sortable = TRUE; // Allow sort
		$this->fields['foto'] = &$this->foto;

		// video
		$this->video = new DbField('kp_proyecto', 'kp_proyecto', 'x_video', 'video', '`video`', '`video`', 200, 250, -1, FALSE, '`video`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->video->Sortable = TRUE; // Allow sort
		$this->fields['video'] = &$this->video;

		// estado
		$this->estado = new DbField('kp_proyecto', 'kp_proyecto', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// status
		$this->status = new DbField('kp_proyecto', 'kp_proyecto', 'x_status', 'status', '`status`', '`status`', 3, 11, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// idcategoria
		$this->idcategoria = new DbField('kp_proyecto', 'kp_proyecto', 'x_idcategoria', 'idcategoria', '`idcategoria`', '`idcategoria`', 3, 11, -1, FALSE, '`idcategoria`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idcategoria->Sortable = TRUE; // Allow sort
		$this->idcategoria->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idcategoria'] = &$this->idcategoria;

		// descuento
		$this->descuento = new DbField('kp_proyecto', 'kp_proyecto', 'x_descuento', 'descuento', '`descuento`', '`descuento`', 4, 12, -1, FALSE, '`descuento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->descuento->Sortable = TRUE; // Allow sort
		$this->descuento->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['descuento'] = &$this->descuento;

		// precio
		$this->precio = new DbField('kp_proyecto', 'kp_proyecto', 'x_precio', 'precio', '`precio`', '`precio`', 4, 12, -1, FALSE, '`precio`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio->Sortable = TRUE; // Allow sort
		$this->precio->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio'] = &$this->precio;

		// tipo_entrega
		$this->tipo_entrega = new DbField('kp_proyecto', 'kp_proyecto', 'x_tipo_entrega', 'tipo_entrega', '`tipo_entrega`', '`tipo_entrega`', 3, 11, -1, FALSE, '`tipo_entrega`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_entrega->Sortable = TRUE; // Allow sort
		$this->tipo_entrega->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_entrega'] = &$this->tipo_entrega;

		// metros_cuadrados
		$this->metros_cuadrados = new DbField('kp_proyecto', 'kp_proyecto', 'x_metros_cuadrados', 'metros_cuadrados', '`metros_cuadrados`', '`metros_cuadrados`', 4, 12, -1, FALSE, '`metros_cuadrados`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->metros_cuadrados->Sortable = TRUE; // Allow sort
		$this->metros_cuadrados->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['metros_cuadrados'] = &$this->metros_cuadrados;

		// url
		$this->url = new DbField('kp_proyecto', 'kp_proyecto', 'x_url', 'url', '`url`', '`url`', 200, 250, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Sortable = TRUE; // Allow sort
		$this->fields['url'] = &$this->url;

		// idempresa
		$this->idempresa = new DbField('kp_proyecto', 'kp_proyecto', 'x_idempresa', 'idempresa', '`idempresa`', '`idempresa`', 3, 11, -1, FALSE, '`idempresa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idempresa->Sortable = TRUE; // Allow sort
		$this->idempresa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idempresa'] = &$this->idempresa;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`kp_proyecto`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idproyecto->setDbValue($conn->insert_ID());
			$rs['idproyecto'] = $this->idproyecto->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idproyecto', $rs))
				AddFilter($where, QuotedName('idproyecto', $this->Dbid) . '=' . QuotedValue($rs['idproyecto'], $this->idproyecto->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idproyecto->DbValue = $row['idproyecto'];
		$this->titulo->DbValue = $row['titulo'];
		$this->nombre->DbValue = $row['nombre'];
		$this->descproyecto->DbValue = $row['descproyecto'];
		$this->ubicacion->DbValue = $row['ubicacion'];
		$this->cuotas->DbValue = $row['cuotas'];
		$this->foto->DbValue = $row['foto'];
		$this->video->DbValue = $row['video'];
		$this->estado->DbValue = $row['estado'];
		$this->status->DbValue = $row['status'];
		$this->idcategoria->DbValue = $row['idcategoria'];
		$this->descuento->DbValue = $row['descuento'];
		$this->precio->DbValue = $row['precio'];
		$this->tipo_entrega->DbValue = $row['tipo_entrega'];
		$this->metros_cuadrados->DbValue = $row['metros_cuadrados'];
		$this->url->DbValue = $row['url'];
		$this->idempresa->DbValue = $row['idempresa'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idproyecto` = @idproyecto@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idproyecto', $row) ? $row['idproyecto'] : NULL;
		else
			$val = $this->idproyecto->OldValue !== NULL ? $this->idproyecto->OldValue : $this->idproyecto->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idproyecto@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "kp_proyectolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "kp_proyectoview.php")
			return $Language->phrase("View");
		elseif ($pageName == "kp_proyectoedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "kp_proyectoadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "kp_proyectolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("kp_proyectoview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("kp_proyectoview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "kp_proyectoadd.php?" . $this->getUrlParm($parm);
		else
			$url = "kp_proyectoadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("kp_proyectoedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("kp_proyectoadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("kp_proyectodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idproyecto:" . JsonEncode($this->idproyecto->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idproyecto->CurrentValue != NULL) {
			$url .= "idproyecto=" . urlencode($this->idproyecto->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idproyecto") !== NULL)
				$arKeys[] = Param("idproyecto");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idproyecto->CurrentValue = $key;
			else
				$this->idproyecto->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idproyecto->setDbValue($rs->fields('idproyecto'));
		$this->titulo->setDbValue($rs->fields('titulo'));
		$this->nombre->setDbValue($rs->fields('nombre'));
		$this->descproyecto->setDbValue($rs->fields('descproyecto'));
		$this->ubicacion->setDbValue($rs->fields('ubicacion'));
		$this->cuotas->setDbValue($rs->fields('cuotas'));
		$this->foto->setDbValue($rs->fields('foto'));
		$this->video->setDbValue($rs->fields('video'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->status->setDbValue($rs->fields('status'));
		$this->idcategoria->setDbValue($rs->fields('idcategoria'));
		$this->descuento->setDbValue($rs->fields('descuento'));
		$this->precio->setDbValue($rs->fields('precio'));
		$this->tipo_entrega->setDbValue($rs->fields('tipo_entrega'));
		$this->metros_cuadrados->setDbValue($rs->fields('metros_cuadrados'));
		$this->url->setDbValue($rs->fields('url'));
		$this->idempresa->setDbValue($rs->fields('idempresa'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idproyecto
		// titulo
		// nombre
		// descproyecto
		// ubicacion
		// cuotas
		// foto
		// video
		// estado
		// status
		// idcategoria
		// descuento
		// precio
		// tipo_entrega
		// metros_cuadrados
		// url
		// idempresa
		// idproyecto

		$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
		$this->idproyecto->ViewCustomAttributes = "";

		// titulo
		$this->titulo->ViewValue = $this->titulo->CurrentValue;
		$this->titulo->ViewCustomAttributes = "";

		// nombre
		$this->nombre->ViewValue = $this->nombre->CurrentValue;
		$this->nombre->ViewCustomAttributes = "";

		// descproyecto
		$this->descproyecto->ViewValue = $this->descproyecto->CurrentValue;
		$this->descproyecto->ViewCustomAttributes = "";

		// ubicacion
		$this->ubicacion->ViewValue = $this->ubicacion->CurrentValue;
		$this->ubicacion->ViewCustomAttributes = "";

		// cuotas
		$this->cuotas->ViewValue = $this->cuotas->CurrentValue;
		$this->cuotas->ViewValue = FormatNumber($this->cuotas->ViewValue, 0, -2, -2, -2);
		$this->cuotas->ViewCustomAttributes = "";

		// foto
		$this->foto->ViewValue = $this->foto->CurrentValue;
		$this->foto->ViewCustomAttributes = "";

		// video
		$this->video->ViewValue = $this->video->CurrentValue;
		$this->video->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// idcategoria
		$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
		$this->idcategoria->ViewCustomAttributes = "";

		// descuento
		$this->descuento->ViewValue = $this->descuento->CurrentValue;
		$this->descuento->ViewValue = FormatNumber($this->descuento->ViewValue, 2, -2, -2, -2);
		$this->descuento->ViewCustomAttributes = "";

		// precio
		$this->precio->ViewValue = $this->precio->CurrentValue;
		$this->precio->ViewValue = FormatNumber($this->precio->ViewValue, 2, -2, -2, -2);
		$this->precio->ViewCustomAttributes = "";

		// tipo_entrega
		$this->tipo_entrega->ViewValue = $this->tipo_entrega->CurrentValue;
		$this->tipo_entrega->ViewValue = FormatNumber($this->tipo_entrega->ViewValue, 0, -2, -2, -2);
		$this->tipo_entrega->ViewCustomAttributes = "";

		// metros_cuadrados
		$this->metros_cuadrados->ViewValue = $this->metros_cuadrados->CurrentValue;
		$this->metros_cuadrados->ViewValue = FormatNumber($this->metros_cuadrados->ViewValue, 2, -2, -2, -2);
		$this->metros_cuadrados->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
		$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
		$this->idempresa->ViewCustomAttributes = "";

		// idproyecto
		$this->idproyecto->LinkCustomAttributes = "";
		$this->idproyecto->HrefValue = "";
		$this->idproyecto->TooltipValue = "";

		// titulo
		$this->titulo->LinkCustomAttributes = "";
		$this->titulo->HrefValue = "";
		$this->titulo->TooltipValue = "";

		// nombre
		$this->nombre->LinkCustomAttributes = "";
		$this->nombre->HrefValue = "";
		$this->nombre->TooltipValue = "";

		// descproyecto
		$this->descproyecto->LinkCustomAttributes = "";
		$this->descproyecto->HrefValue = "";
		$this->descproyecto->TooltipValue = "";

		// ubicacion
		$this->ubicacion->LinkCustomAttributes = "";
		$this->ubicacion->HrefValue = "";
		$this->ubicacion->TooltipValue = "";

		// cuotas
		$this->cuotas->LinkCustomAttributes = "";
		$this->cuotas->HrefValue = "";
		$this->cuotas->TooltipValue = "";

		// foto
		$this->foto->LinkCustomAttributes = "";
		$this->foto->HrefValue = "";
		$this->foto->TooltipValue = "";

		// video
		$this->video->LinkCustomAttributes = "";
		$this->video->HrefValue = "";
		$this->video->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// idcategoria
		$this->idcategoria->LinkCustomAttributes = "";
		$this->idcategoria->HrefValue = "";
		$this->idcategoria->TooltipValue = "";

		// descuento
		$this->descuento->LinkCustomAttributes = "";
		$this->descuento->HrefValue = "";
		$this->descuento->TooltipValue = "";

		// precio
		$this->precio->LinkCustomAttributes = "";
		$this->precio->HrefValue = "";
		$this->precio->TooltipValue = "";

		// tipo_entrega
		$this->tipo_entrega->LinkCustomAttributes = "";
		$this->tipo_entrega->HrefValue = "";
		$this->tipo_entrega->TooltipValue = "";

		// metros_cuadrados
		$this->metros_cuadrados->LinkCustomAttributes = "";
		$this->metros_cuadrados->HrefValue = "";
		$this->metros_cuadrados->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// idempresa
		$this->idempresa->LinkCustomAttributes = "";
		$this->idempresa->HrefValue = "";
		$this->idempresa->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idproyecto
		$this->idproyecto->EditAttrs["class"] = "form-control";
		$this->idproyecto->EditCustomAttributes = "";
		$this->idproyecto->EditValue = $this->idproyecto->CurrentValue;
		$this->idproyecto->ViewCustomAttributes = "";

		// titulo
		$this->titulo->EditAttrs["class"] = "form-control";
		$this->titulo->EditCustomAttributes = "";
		if (!$this->titulo->Raw)
			$this->titulo->CurrentValue = HtmlDecode($this->titulo->CurrentValue);
		$this->titulo->EditValue = $this->titulo->CurrentValue;
		$this->titulo->PlaceHolder = RemoveHtml($this->titulo->caption());

		// nombre
		$this->nombre->EditAttrs["class"] = "form-control";
		$this->nombre->EditCustomAttributes = "";
		if (!$this->nombre->Raw)
			$this->nombre->CurrentValue = HtmlDecode($this->nombre->CurrentValue);
		$this->nombre->EditValue = $this->nombre->CurrentValue;
		$this->nombre->PlaceHolder = RemoveHtml($this->nombre->caption());

		// descproyecto
		$this->descproyecto->EditAttrs["class"] = "form-control";
		$this->descproyecto->EditCustomAttributes = "";
		$this->descproyecto->EditValue = $this->descproyecto->CurrentValue;
		$this->descproyecto->PlaceHolder = RemoveHtml($this->descproyecto->caption());

		// ubicacion
		$this->ubicacion->EditAttrs["class"] = "form-control";
		$this->ubicacion->EditCustomAttributes = "";
		if (!$this->ubicacion->Raw)
			$this->ubicacion->CurrentValue = HtmlDecode($this->ubicacion->CurrentValue);
		$this->ubicacion->EditValue = $this->ubicacion->CurrentValue;
		$this->ubicacion->PlaceHolder = RemoveHtml($this->ubicacion->caption());

		// cuotas
		$this->cuotas->EditAttrs["class"] = "form-control";
		$this->cuotas->EditCustomAttributes = "";
		$this->cuotas->EditValue = $this->cuotas->CurrentValue;
		$this->cuotas->PlaceHolder = RemoveHtml($this->cuotas->caption());

		// foto
		$this->foto->EditAttrs["class"] = "form-control";
		$this->foto->EditCustomAttributes = "";
		if (!$this->foto->Raw)
			$this->foto->CurrentValue = HtmlDecode($this->foto->CurrentValue);
		$this->foto->EditValue = $this->foto->CurrentValue;
		$this->foto->PlaceHolder = RemoveHtml($this->foto->caption());

		// video
		$this->video->EditAttrs["class"] = "form-control";
		$this->video->EditCustomAttributes = "";
		if (!$this->video->Raw)
			$this->video->CurrentValue = HtmlDecode($this->video->CurrentValue);
		$this->video->EditValue = $this->video->CurrentValue;
		$this->video->PlaceHolder = RemoveHtml($this->video->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// idcategoria
		$this->idcategoria->EditAttrs["class"] = "form-control";
		$this->idcategoria->EditCustomAttributes = "";
		$this->idcategoria->EditValue = $this->idcategoria->CurrentValue;
		$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

		// descuento
		$this->descuento->EditAttrs["class"] = "form-control";
		$this->descuento->EditCustomAttributes = "";
		$this->descuento->EditValue = $this->descuento->CurrentValue;
		$this->descuento->PlaceHolder = RemoveHtml($this->descuento->caption());
		if (strval($this->descuento->EditValue) != "" && is_numeric($this->descuento->EditValue))
			$this->descuento->EditValue = FormatNumber($this->descuento->EditValue, -2, -2, -2, -2);
		

		// precio
		$this->precio->EditAttrs["class"] = "form-control";
		$this->precio->EditCustomAttributes = "";
		$this->precio->EditValue = $this->precio->CurrentValue;
		$this->precio->PlaceHolder = RemoveHtml($this->precio->caption());
		if (strval($this->precio->EditValue) != "" && is_numeric($this->precio->EditValue))
			$this->precio->EditValue = FormatNumber($this->precio->EditValue, -2, -2, -2, -2);
		

		// tipo_entrega
		$this->tipo_entrega->EditAttrs["class"] = "form-control";
		$this->tipo_entrega->EditCustomAttributes = "";
		$this->tipo_entrega->EditValue = $this->tipo_entrega->CurrentValue;
		$this->tipo_entrega->PlaceHolder = RemoveHtml($this->tipo_entrega->caption());

		// metros_cuadrados
		$this->metros_cuadrados->EditAttrs["class"] = "form-control";
		$this->metros_cuadrados->EditCustomAttributes = "";
		$this->metros_cuadrados->EditValue = $this->metros_cuadrados->CurrentValue;
		$this->metros_cuadrados->PlaceHolder = RemoveHtml($this->metros_cuadrados->caption());
		if (strval($this->metros_cuadrados->EditValue) != "" && is_numeric($this->metros_cuadrados->EditValue))
			$this->metros_cuadrados->EditValue = FormatNumber($this->metros_cuadrados->EditValue, -2, -2, -2, -2);
		

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (!$this->url->Raw)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// idempresa
		$this->idempresa->EditAttrs["class"] = "form-control";
		$this->idempresa->EditCustomAttributes = "";
		$this->idempresa->EditValue = $this->idempresa->CurrentValue;
		$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idproyecto);
					$doc->exportCaption($this->titulo);
					$doc->exportCaption($this->nombre);
					$doc->exportCaption($this->descproyecto);
					$doc->exportCaption($this->ubicacion);
					$doc->exportCaption($this->cuotas);
					$doc->exportCaption($this->foto);
					$doc->exportCaption($this->video);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->descuento);
					$doc->exportCaption($this->precio);
					$doc->exportCaption($this->tipo_entrega);
					$doc->exportCaption($this->metros_cuadrados);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->idempresa);
				} else {
					$doc->exportCaption($this->idproyecto);
					$doc->exportCaption($this->titulo);
					$doc->exportCaption($this->nombre);
					$doc->exportCaption($this->ubicacion);
					$doc->exportCaption($this->cuotas);
					$doc->exportCaption($this->foto);
					$doc->exportCaption($this->video);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->idcategoria);
					$doc->exportCaption($this->descuento);
					$doc->exportCaption($this->precio);
					$doc->exportCaption($this->tipo_entrega);
					$doc->exportCaption($this->metros_cuadrados);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->idempresa);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idproyecto);
						$doc->exportField($this->titulo);
						$doc->exportField($this->nombre);
						$doc->exportField($this->descproyecto);
						$doc->exportField($this->ubicacion);
						$doc->exportField($this->cuotas);
						$doc->exportField($this->foto);
						$doc->exportField($this->video);
						$doc->exportField($this->estado);
						$doc->exportField($this->status);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->descuento);
						$doc->exportField($this->precio);
						$doc->exportField($this->tipo_entrega);
						$doc->exportField($this->metros_cuadrados);
						$doc->exportField($this->url);
						$doc->exportField($this->idempresa);
					} else {
						$doc->exportField($this->idproyecto);
						$doc->exportField($this->titulo);
						$doc->exportField($this->nombre);
						$doc->exportField($this->ubicacion);
						$doc->exportField($this->cuotas);
						$doc->exportField($this->foto);
						$doc->exportField($this->video);
						$doc->exportField($this->estado);
						$doc->exportField($this->status);
						$doc->exportField($this->idcategoria);
						$doc->exportField($this->descuento);
						$doc->exportField($this->precio);
						$doc->exportField($this->tipo_entrega);
						$doc->exportField($this->metros_cuadrados);
						$doc->exportField($this->url);
						$doc->exportField($this->idempresa);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>