<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for interesados
 */
class interesados extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idinteresado;
	public $id_usuarioencargado;
	public $fecha;
	public $_email;
	public $cursos;
	public $categorias;
	public $nombres;
	public $apellidos;
	public $direccion;
	public $ciudad;
	public $provincia;
	public $pais;
	public $telefono;
	public $tipo_certificado;
	public $tipo_pago;
	public $nombretarjeta;
	public $numerotarjeta;
	public $mes;
	public $anio;
	public $tipo_tarjeta;
	public $nombrepaypal;
	public $montopaypal;
	public $emailpaypal;
	public $don;
	public $tipo_condicion;
	public $acciones;
	public $solicitud;
	public $examen;
	public $estado;
	public $tipo;
	public $codigo_certificado;
	public $estado_entrega;
	public $idioma;
	public $tipo_documento;
	public $n_documento;
	public $condicion1;
	public $condicion2;
	public $consulta;
	public $status;
	public $codlogin;
	public $idproyecto;
	public $id_producto;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'interesados';
		$this->TableName = 'interesados';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`interesados`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idinteresado
		$this->idinteresado = new DbField('interesados', 'interesados', 'x_idinteresado', 'idinteresado', '`idinteresado`', '`idinteresado`', 19, 10, -1, FALSE, '`idinteresado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idinteresado->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idinteresado->IsPrimaryKey = TRUE; // Primary key field
		$this->idinteresado->Sortable = TRUE; // Allow sort
		$this->idinteresado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idinteresado'] = &$this->idinteresado;

		// id_usuarioencargado
		$this->id_usuarioencargado = new DbField('interesados', 'interesados', 'x_id_usuarioencargado', 'id_usuarioencargado', '`id_usuarioencargado`', '`id_usuarioencargado`', 3, 11, -1, FALSE, '`id_usuarioencargado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_usuarioencargado->Sortable = TRUE; // Allow sort
		$this->id_usuarioencargado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_usuarioencargado'] = &$this->id_usuarioencargado;

		// fecha
		$this->fecha = new DbField('interesados', 'interesados', 'x_fecha', 'fecha', '`fecha`', CastDateFieldForLike("`fecha`", 0, "DB"), 135, 19, 0, FALSE, '`fecha`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha->Nullable = FALSE; // NOT NULL field
		$this->fecha->Required = TRUE; // Required field
		$this->fecha->Sortable = TRUE; // Allow sort
		$this->fecha->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha'] = &$this->fecha;

		// email
		$this->_email = new DbField('interesados', 'interesados', 'x__email', 'email', '`email`', '`email`', 200, 100, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->fields['email'] = &$this->_email;

		// cursos
		$this->cursos = new DbField('interesados', 'interesados', 'x_cursos', 'cursos', '`cursos`', '`cursos`', 3, 11, -1, FALSE, '`cursos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cursos->Sortable = TRUE; // Allow sort
		$this->cursos->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cursos'] = &$this->cursos;

		// categorias
		$this->categorias = new DbField('interesados', 'interesados', 'x_categorias', 'categorias', '`categorias`', '`categorias`', 3, 11, -1, FALSE, '`categorias`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->categorias->Sortable = TRUE; // Allow sort
		$this->categorias->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['categorias'] = &$this->categorias;

		// nombres
		$this->nombres = new DbField('interesados', 'interesados', 'x_nombres', 'nombres', '`nombres`', '`nombres`', 200, 50, -1, FALSE, '`nombres`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombres->Sortable = TRUE; // Allow sort
		$this->fields['nombres'] = &$this->nombres;

		// apellidos
		$this->apellidos = new DbField('interesados', 'interesados', 'x_apellidos', 'apellidos', '`apellidos`', '`apellidos`', 200, 200, -1, FALSE, '`apellidos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->apellidos->Sortable = TRUE; // Allow sort
		$this->fields['apellidos'] = &$this->apellidos;

		// direccion
		$this->direccion = new DbField('interesados', 'interesados', 'x_direccion', 'direccion', '`direccion`', '`direccion`', 200, 200, -1, FALSE, '`direccion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->direccion->Sortable = TRUE; // Allow sort
		$this->fields['direccion'] = &$this->direccion;

		// ciudad
		$this->ciudad = new DbField('interesados', 'interesados', 'x_ciudad', 'ciudad', '`ciudad`', '`ciudad`', 200, 200, -1, FALSE, '`ciudad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ciudad->Sortable = TRUE; // Allow sort
		$this->fields['ciudad'] = &$this->ciudad;

		// provincia
		$this->provincia = new DbField('interesados', 'interesados', 'x_provincia', 'provincia', '`provincia`', '`provincia`', 200, 100, -1, FALSE, '`provincia`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->provincia->Sortable = TRUE; // Allow sort
		$this->fields['provincia'] = &$this->provincia;

		// pais
		$this->pais = new DbField('interesados', 'interesados', 'x_pais', 'pais', '`pais`', '`pais`', 200, 20, -1, FALSE, '`pais`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pais->Sortable = TRUE; // Allow sort
		$this->fields['pais'] = &$this->pais;

		// telefono
		$this->telefono = new DbField('interesados', 'interesados', 'x_telefono', 'telefono', '`telefono`', '`telefono`', 200, 64, -1, FALSE, '`telefono`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->telefono->Sortable = TRUE; // Allow sort
		$this->fields['telefono'] = &$this->telefono;

		// tipo_certificado
		$this->tipo_certificado = new DbField('interesados', 'interesados', 'x_tipo_certificado', 'tipo_certificado', '`tipo_certificado`', '`tipo_certificado`', 3, 11, -1, FALSE, '`tipo_certificado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_certificado->Sortable = TRUE; // Allow sort
		$this->tipo_certificado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_certificado'] = &$this->tipo_certificado;

		// tipo_pago
		$this->tipo_pago = new DbField('interesados', 'interesados', 'x_tipo_pago', 'tipo_pago', '`tipo_pago`', '`tipo_pago`', 3, 11, -1, FALSE, '`tipo_pago`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_pago->Sortable = TRUE; // Allow sort
		$this->tipo_pago->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_pago'] = &$this->tipo_pago;

		// nombretarjeta
		$this->nombretarjeta = new DbField('interesados', 'interesados', 'x_nombretarjeta', 'nombretarjeta', '`nombretarjeta`', '`nombretarjeta`', 200, 200, -1, FALSE, '`nombretarjeta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombretarjeta->Sortable = TRUE; // Allow sort
		$this->fields['nombretarjeta'] = &$this->nombretarjeta;

		// numerotarjeta
		$this->numerotarjeta = new DbField('interesados', 'interesados', 'x_numerotarjeta', 'numerotarjeta', '`numerotarjeta`', '`numerotarjeta`', 200, 200, -1, FALSE, '`numerotarjeta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numerotarjeta->Sortable = TRUE; // Allow sort
		$this->fields['numerotarjeta'] = &$this->numerotarjeta;

		// mes
		$this->mes = new DbField('interesados', 'interesados', 'x_mes', 'mes', '`mes`', '`mes`', 200, 200, -1, FALSE, '`mes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mes->Sortable = TRUE; // Allow sort
		$this->fields['mes'] = &$this->mes;

		// anio
		$this->anio = new DbField('interesados', 'interesados', 'x_anio', 'anio', '`anio`', '`anio`', 200, 200, -1, FALSE, '`anio`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->anio->Sortable = TRUE; // Allow sort
		$this->fields['anio'] = &$this->anio;

		// tipo_tarjeta
		$this->tipo_tarjeta = new DbField('interesados', 'interesados', 'x_tipo_tarjeta', 'tipo_tarjeta', '`tipo_tarjeta`', '`tipo_tarjeta`', 200, 110, -1, FALSE, '`tipo_tarjeta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_tarjeta->Sortable = TRUE; // Allow sort
		$this->fields['tipo_tarjeta'] = &$this->tipo_tarjeta;

		// nombrepaypal
		$this->nombrepaypal = new DbField('interesados', 'interesados', 'x_nombrepaypal', 'nombrepaypal', '`nombrepaypal`', '`nombrepaypal`', 200, 20, -1, FALSE, '`nombrepaypal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombrepaypal->Sortable = TRUE; // Allow sort
		$this->fields['nombrepaypal'] = &$this->nombrepaypal;

		// montopaypal
		$this->montopaypal = new DbField('interesados', 'interesados', 'x_montopaypal', 'montopaypal', '`montopaypal`', '`montopaypal`', 200, 64, -1, FALSE, '`montopaypal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->montopaypal->Sortable = TRUE; // Allow sort
		$this->fields['montopaypal'] = &$this->montopaypal;

		// emailpaypal
		$this->emailpaypal = new DbField('interesados', 'interesados', 'x_emailpaypal', 'emailpaypal', '`emailpaypal`', '`emailpaypal`', 200, 200, -1, FALSE, '`emailpaypal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emailpaypal->Sortable = TRUE; // Allow sort
		$this->fields['emailpaypal'] = &$this->emailpaypal;

		// don
		$this->don = new DbField('interesados', 'interesados', 'x_don', 'don', '`don`', '`don`', 200, 20, -1, FALSE, '`don`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->don->Sortable = TRUE; // Allow sort
		$this->fields['don'] = &$this->don;

		// tipo_condicion
		$this->tipo_condicion = new DbField('interesados', 'interesados', 'x_tipo_condicion', 'tipo_condicion', '`tipo_condicion`', '`tipo_condicion`', 3, 11, -1, FALSE, '`tipo_condicion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_condicion->Sortable = TRUE; // Allow sort
		$this->tipo_condicion->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_condicion'] = &$this->tipo_condicion;

		// acciones
		$this->acciones = new DbField('interesados', 'interesados', 'x_acciones', 'acciones', '`acciones`', '`acciones`', 3, 11, -1, FALSE, '`acciones`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->acciones->Sortable = TRUE; // Allow sort
		$this->acciones->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['acciones'] = &$this->acciones;

		// solicitud
		$this->solicitud = new DbField('interesados', 'interesados', 'x_solicitud', 'solicitud', '`solicitud`', '`solicitud`', 3, 11, -1, FALSE, '`solicitud`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->solicitud->Sortable = TRUE; // Allow sort
		$this->solicitud->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['solicitud'] = &$this->solicitud;

		// examen
		$this->examen = new DbField('interesados', 'interesados', 'x_examen', 'examen', '`examen`', '`examen`', 131, 11, -1, FALSE, '`examen`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->examen->Sortable = TRUE; // Allow sort
		$this->examen->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['examen'] = &$this->examen;

		// estado
		$this->estado = new DbField('interesados', 'interesados', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// tipo
		$this->tipo = new DbField('interesados', 'interesados', 'x_tipo', 'tipo', '`tipo`', '`tipo`', 3, 11, -1, FALSE, '`tipo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo->Sortable = TRUE; // Allow sort
		$this->tipo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo'] = &$this->tipo;

		// codigo_certificado
		$this->codigo_certificado = new DbField('interesados', 'interesados', 'x_codigo_certificado', 'codigo_certificado', '`codigo_certificado`', '`codigo_certificado`', 200, 200, -1, FALSE, '`codigo_certificado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codigo_certificado->Sortable = TRUE; // Allow sort
		$this->fields['codigo_certificado'] = &$this->codigo_certificado;

		// estado_entrega
		$this->estado_entrega = new DbField('interesados', 'interesados', 'x_estado_entrega', 'estado_entrega', '`estado_entrega`', '`estado_entrega`', 3, 11, -1, FALSE, '`estado_entrega`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado_entrega->Sortable = TRUE; // Allow sort
		$this->estado_entrega->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado_entrega'] = &$this->estado_entrega;

		// idioma
		$this->idioma = new DbField('interesados', 'interesados', 'x_idioma', 'idioma', '`idioma`', '`idioma`', 3, 11, -1, FALSE, '`idioma`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idioma->Sortable = TRUE; // Allow sort
		$this->idioma->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idioma'] = &$this->idioma;

		// tipo_documento
		$this->tipo_documento = new DbField('interesados', 'interesados', 'x_tipo_documento', 'tipo_documento', '`tipo_documento`', '`tipo_documento`', 3, 11, -1, FALSE, '`tipo_documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_documento->Sortable = TRUE; // Allow sort
		$this->tipo_documento->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_documento'] = &$this->tipo_documento;

		// n_documento
		$this->n_documento = new DbField('interesados', 'interesados', 'x_n_documento', 'n_documento', '`n_documento`', '`n_documento`', 3, 11, -1, FALSE, '`n_documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->n_documento->Sortable = TRUE; // Allow sort
		$this->n_documento->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['n_documento'] = &$this->n_documento;

		// condicion1
		$this->condicion1 = new DbField('interesados', 'interesados', 'x_condicion1', 'condicion1', '`condicion1`', '`condicion1`', 3, 11, -1, FALSE, '`condicion1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->condicion1->Sortable = TRUE; // Allow sort
		$this->condicion1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['condicion1'] = &$this->condicion1;

		// condicion2
		$this->condicion2 = new DbField('interesados', 'interesados', 'x_condicion2', 'condicion2', '`condicion2`', '`condicion2`', 3, 11, -1, FALSE, '`condicion2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->condicion2->Sortable = TRUE; // Allow sort
		$this->condicion2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['condicion2'] = &$this->condicion2;

		// consulta
		$this->consulta = new DbField('interesados', 'interesados', 'x_consulta', 'consulta', '`consulta`', '`consulta`', 200, 250, -1, FALSE, '`consulta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->consulta->Sortable = TRUE; // Allow sort
		$this->fields['consulta'] = &$this->consulta;

		// status
		$this->status = new DbField('interesados', 'interesados', 'x_status', 'status', '`status`', '`status`', 3, 11, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// codlogin
		$this->codlogin = new DbField('interesados', 'interesados', 'x_codlogin', 'codlogin', '`codlogin`', '`codlogin`', 200, 100, -1, FALSE, '`codlogin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codlogin->Sortable = TRUE; // Allow sort
		$this->fields['codlogin'] = &$this->codlogin;

		// idproyecto
		$this->idproyecto = new DbField('interesados', 'interesados', 'x_idproyecto', 'idproyecto', '`idproyecto`', '`idproyecto`', 3, 11, -1, FALSE, '`idproyecto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idproyecto->Nullable = FALSE; // NOT NULL field
		$this->idproyecto->Required = TRUE; // Required field
		$this->idproyecto->Sortable = TRUE; // Allow sort
		$this->idproyecto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idproyecto'] = &$this->idproyecto;

		// id_producto
		$this->id_producto = new DbField('interesados', 'interesados', 'x_id_producto', 'id_producto', '`id_producto`', '`id_producto`', 3, 11, -1, FALSE, '`id_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_producto->Nullable = FALSE; // NOT NULL field
		$this->id_producto->Required = TRUE; // Required field
		$this->id_producto->Sortable = TRUE; // Allow sort
		$this->id_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_producto'] = &$this->id_producto;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`interesados`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idinteresado->setDbValue($conn->insert_ID());
			$rs['idinteresado'] = $this->idinteresado->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idinteresado', $rs))
				AddFilter($where, QuotedName('idinteresado', $this->Dbid) . '=' . QuotedValue($rs['idinteresado'], $this->idinteresado->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idinteresado->DbValue = $row['idinteresado'];
		$this->id_usuarioencargado->DbValue = $row['id_usuarioencargado'];
		$this->fecha->DbValue = $row['fecha'];
		$this->_email->DbValue = $row['email'];
		$this->cursos->DbValue = $row['cursos'];
		$this->categorias->DbValue = $row['categorias'];
		$this->nombres->DbValue = $row['nombres'];
		$this->apellidos->DbValue = $row['apellidos'];
		$this->direccion->DbValue = $row['direccion'];
		$this->ciudad->DbValue = $row['ciudad'];
		$this->provincia->DbValue = $row['provincia'];
		$this->pais->DbValue = $row['pais'];
		$this->telefono->DbValue = $row['telefono'];
		$this->tipo_certificado->DbValue = $row['tipo_certificado'];
		$this->tipo_pago->DbValue = $row['tipo_pago'];
		$this->nombretarjeta->DbValue = $row['nombretarjeta'];
		$this->numerotarjeta->DbValue = $row['numerotarjeta'];
		$this->mes->DbValue = $row['mes'];
		$this->anio->DbValue = $row['anio'];
		$this->tipo_tarjeta->DbValue = $row['tipo_tarjeta'];
		$this->nombrepaypal->DbValue = $row['nombrepaypal'];
		$this->montopaypal->DbValue = $row['montopaypal'];
		$this->emailpaypal->DbValue = $row['emailpaypal'];
		$this->don->DbValue = $row['don'];
		$this->tipo_condicion->DbValue = $row['tipo_condicion'];
		$this->acciones->DbValue = $row['acciones'];
		$this->solicitud->DbValue = $row['solicitud'];
		$this->examen->DbValue = $row['examen'];
		$this->estado->DbValue = $row['estado'];
		$this->tipo->DbValue = $row['tipo'];
		$this->codigo_certificado->DbValue = $row['codigo_certificado'];
		$this->estado_entrega->DbValue = $row['estado_entrega'];
		$this->idioma->DbValue = $row['idioma'];
		$this->tipo_documento->DbValue = $row['tipo_documento'];
		$this->n_documento->DbValue = $row['n_documento'];
		$this->condicion1->DbValue = $row['condicion1'];
		$this->condicion2->DbValue = $row['condicion2'];
		$this->consulta->DbValue = $row['consulta'];
		$this->status->DbValue = $row['status'];
		$this->codlogin->DbValue = $row['codlogin'];
		$this->idproyecto->DbValue = $row['idproyecto'];
		$this->id_producto->DbValue = $row['id_producto'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idinteresado` = @idinteresado@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idinteresado', $row) ? $row['idinteresado'] : NULL;
		else
			$val = $this->idinteresado->OldValue !== NULL ? $this->idinteresado->OldValue : $this->idinteresado->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idinteresado@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "interesadoslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "interesadosview.php")
			return $Language->phrase("View");
		elseif ($pageName == "interesadosedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "interesadosadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "interesadoslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("interesadosview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("interesadosview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "interesadosadd.php?" . $this->getUrlParm($parm);
		else
			$url = "interesadosadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("interesadosedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("interesadosadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("interesadosdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idinteresado:" . JsonEncode($this->idinteresado->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idinteresado->CurrentValue != NULL) {
			$url .= "idinteresado=" . urlencode($this->idinteresado->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idinteresado") !== NULL)
				$arKeys[] = Param("idinteresado");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idinteresado->CurrentValue = $key;
			else
				$this->idinteresado->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idinteresado->setDbValue($rs->fields('idinteresado'));
		$this->id_usuarioencargado->setDbValue($rs->fields('id_usuarioencargado'));
		$this->fecha->setDbValue($rs->fields('fecha'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->cursos->setDbValue($rs->fields('cursos'));
		$this->categorias->setDbValue($rs->fields('categorias'));
		$this->nombres->setDbValue($rs->fields('nombres'));
		$this->apellidos->setDbValue($rs->fields('apellidos'));
		$this->direccion->setDbValue($rs->fields('direccion'));
		$this->ciudad->setDbValue($rs->fields('ciudad'));
		$this->provincia->setDbValue($rs->fields('provincia'));
		$this->pais->setDbValue($rs->fields('pais'));
		$this->telefono->setDbValue($rs->fields('telefono'));
		$this->tipo_certificado->setDbValue($rs->fields('tipo_certificado'));
		$this->tipo_pago->setDbValue($rs->fields('tipo_pago'));
		$this->nombretarjeta->setDbValue($rs->fields('nombretarjeta'));
		$this->numerotarjeta->setDbValue($rs->fields('numerotarjeta'));
		$this->mes->setDbValue($rs->fields('mes'));
		$this->anio->setDbValue($rs->fields('anio'));
		$this->tipo_tarjeta->setDbValue($rs->fields('tipo_tarjeta'));
		$this->nombrepaypal->setDbValue($rs->fields('nombrepaypal'));
		$this->montopaypal->setDbValue($rs->fields('montopaypal'));
		$this->emailpaypal->setDbValue($rs->fields('emailpaypal'));
		$this->don->setDbValue($rs->fields('don'));
		$this->tipo_condicion->setDbValue($rs->fields('tipo_condicion'));
		$this->acciones->setDbValue($rs->fields('acciones'));
		$this->solicitud->setDbValue($rs->fields('solicitud'));
		$this->examen->setDbValue($rs->fields('examen'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->tipo->setDbValue($rs->fields('tipo'));
		$this->codigo_certificado->setDbValue($rs->fields('codigo_certificado'));
		$this->estado_entrega->setDbValue($rs->fields('estado_entrega'));
		$this->idioma->setDbValue($rs->fields('idioma'));
		$this->tipo_documento->setDbValue($rs->fields('tipo_documento'));
		$this->n_documento->setDbValue($rs->fields('n_documento'));
		$this->condicion1->setDbValue($rs->fields('condicion1'));
		$this->condicion2->setDbValue($rs->fields('condicion2'));
		$this->consulta->setDbValue($rs->fields('consulta'));
		$this->status->setDbValue($rs->fields('status'));
		$this->codlogin->setDbValue($rs->fields('codlogin'));
		$this->idproyecto->setDbValue($rs->fields('idproyecto'));
		$this->id_producto->setDbValue($rs->fields('id_producto'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idinteresado
		// id_usuarioencargado
		// fecha
		// email
		// cursos
		// categorias
		// nombres
		// apellidos
		// direccion
		// ciudad
		// provincia
		// pais
		// telefono
		// tipo_certificado
		// tipo_pago
		// nombretarjeta
		// numerotarjeta
		// mes
		// anio
		// tipo_tarjeta
		// nombrepaypal
		// montopaypal
		// emailpaypal
		// don
		// tipo_condicion
		// acciones
		// solicitud
		// examen
		// estado
		// tipo
		// codigo_certificado
		// estado_entrega
		// idioma
		// tipo_documento
		// n_documento
		// condicion1
		// condicion2
		// consulta
		// status
		// codlogin
		// idproyecto
		// id_producto
		// idinteresado

		$this->idinteresado->ViewValue = $this->idinteresado->CurrentValue;
		$this->idinteresado->ViewCustomAttributes = "";

		// id_usuarioencargado
		$this->id_usuarioencargado->ViewValue = $this->id_usuarioencargado->CurrentValue;
		$this->id_usuarioencargado->ViewValue = FormatNumber($this->id_usuarioencargado->ViewValue, 0, -2, -2, -2);
		$this->id_usuarioencargado->ViewCustomAttributes = "";

		// fecha
		$this->fecha->ViewValue = $this->fecha->CurrentValue;
		$this->fecha->ViewValue = FormatDateTime($this->fecha->ViewValue, 0);
		$this->fecha->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// cursos
		$this->cursos->ViewValue = $this->cursos->CurrentValue;
		$this->cursos->ViewValue = FormatNumber($this->cursos->ViewValue, 0, -2, -2, -2);
		$this->cursos->ViewCustomAttributes = "";

		// categorias
		$this->categorias->ViewValue = $this->categorias->CurrentValue;
		$this->categorias->ViewValue = FormatNumber($this->categorias->ViewValue, 0, -2, -2, -2);
		$this->categorias->ViewCustomAttributes = "";

		// nombres
		$this->nombres->ViewValue = $this->nombres->CurrentValue;
		$this->nombres->ViewCustomAttributes = "";

		// apellidos
		$this->apellidos->ViewValue = $this->apellidos->CurrentValue;
		$this->apellidos->ViewCustomAttributes = "";

		// direccion
		$this->direccion->ViewValue = $this->direccion->CurrentValue;
		$this->direccion->ViewCustomAttributes = "";

		// ciudad
		$this->ciudad->ViewValue = $this->ciudad->CurrentValue;
		$this->ciudad->ViewCustomAttributes = "";

		// provincia
		$this->provincia->ViewValue = $this->provincia->CurrentValue;
		$this->provincia->ViewCustomAttributes = "";

		// pais
		$this->pais->ViewValue = $this->pais->CurrentValue;
		$this->pais->ViewCustomAttributes = "";

		// telefono
		$this->telefono->ViewValue = $this->telefono->CurrentValue;
		$this->telefono->ViewCustomAttributes = "";

		// tipo_certificado
		$this->tipo_certificado->ViewValue = $this->tipo_certificado->CurrentValue;
		$this->tipo_certificado->ViewValue = FormatNumber($this->tipo_certificado->ViewValue, 0, -2, -2, -2);
		$this->tipo_certificado->ViewCustomAttributes = "";

		// tipo_pago
		$this->tipo_pago->ViewValue = $this->tipo_pago->CurrentValue;
		$this->tipo_pago->ViewValue = FormatNumber($this->tipo_pago->ViewValue, 0, -2, -2, -2);
		$this->tipo_pago->ViewCustomAttributes = "";

		// nombretarjeta
		$this->nombretarjeta->ViewValue = $this->nombretarjeta->CurrentValue;
		$this->nombretarjeta->ViewCustomAttributes = "";

		// numerotarjeta
		$this->numerotarjeta->ViewValue = $this->numerotarjeta->CurrentValue;
		$this->numerotarjeta->ViewCustomAttributes = "";

		// mes
		$this->mes->ViewValue = $this->mes->CurrentValue;
		$this->mes->ViewCustomAttributes = "";

		// anio
		$this->anio->ViewValue = $this->anio->CurrentValue;
		$this->anio->ViewCustomAttributes = "";

		// tipo_tarjeta
		$this->tipo_tarjeta->ViewValue = $this->tipo_tarjeta->CurrentValue;
		$this->tipo_tarjeta->ViewCustomAttributes = "";

		// nombrepaypal
		$this->nombrepaypal->ViewValue = $this->nombrepaypal->CurrentValue;
		$this->nombrepaypal->ViewCustomAttributes = "";

		// montopaypal
		$this->montopaypal->ViewValue = $this->montopaypal->CurrentValue;
		$this->montopaypal->ViewCustomAttributes = "";

		// emailpaypal
		$this->emailpaypal->ViewValue = $this->emailpaypal->CurrentValue;
		$this->emailpaypal->ViewCustomAttributes = "";

		// don
		$this->don->ViewValue = $this->don->CurrentValue;
		$this->don->ViewCustomAttributes = "";

		// tipo_condicion
		$this->tipo_condicion->ViewValue = $this->tipo_condicion->CurrentValue;
		$this->tipo_condicion->ViewValue = FormatNumber($this->tipo_condicion->ViewValue, 0, -2, -2, -2);
		$this->tipo_condicion->ViewCustomAttributes = "";

		// acciones
		$this->acciones->ViewValue = $this->acciones->CurrentValue;
		$this->acciones->ViewValue = FormatNumber($this->acciones->ViewValue, 0, -2, -2, -2);
		$this->acciones->ViewCustomAttributes = "";

		// solicitud
		$this->solicitud->ViewValue = $this->solicitud->CurrentValue;
		$this->solicitud->ViewValue = FormatNumber($this->solicitud->ViewValue, 0, -2, -2, -2);
		$this->solicitud->ViewCustomAttributes = "";

		// examen
		$this->examen->ViewValue = $this->examen->CurrentValue;
		$this->examen->ViewValue = FormatNumber($this->examen->ViewValue, 2, -2, -2, -2);
		$this->examen->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// tipo
		$this->tipo->ViewValue = $this->tipo->CurrentValue;
		$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
		$this->tipo->ViewCustomAttributes = "";

		// codigo_certificado
		$this->codigo_certificado->ViewValue = $this->codigo_certificado->CurrentValue;
		$this->codigo_certificado->ViewCustomAttributes = "";

		// estado_entrega
		$this->estado_entrega->ViewValue = $this->estado_entrega->CurrentValue;
		$this->estado_entrega->ViewValue = FormatNumber($this->estado_entrega->ViewValue, 0, -2, -2, -2);
		$this->estado_entrega->ViewCustomAttributes = "";

		// idioma
		$this->idioma->ViewValue = $this->idioma->CurrentValue;
		$this->idioma->ViewValue = FormatNumber($this->idioma->ViewValue, 0, -2, -2, -2);
		$this->idioma->ViewCustomAttributes = "";

		// tipo_documento
		$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
		$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
		$this->tipo_documento->ViewCustomAttributes = "";

		// n_documento
		$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
		$this->n_documento->ViewValue = FormatNumber($this->n_documento->ViewValue, 0, -2, -2, -2);
		$this->n_documento->ViewCustomAttributes = "";

		// condicion1
		$this->condicion1->ViewValue = $this->condicion1->CurrentValue;
		$this->condicion1->ViewValue = FormatNumber($this->condicion1->ViewValue, 0, -2, -2, -2);
		$this->condicion1->ViewCustomAttributes = "";

		// condicion2
		$this->condicion2->ViewValue = $this->condicion2->CurrentValue;
		$this->condicion2->ViewValue = FormatNumber($this->condicion2->ViewValue, 0, -2, -2, -2);
		$this->condicion2->ViewCustomAttributes = "";

		// consulta
		$this->consulta->ViewValue = $this->consulta->CurrentValue;
		$this->consulta->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// codlogin
		$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
		$this->codlogin->ViewCustomAttributes = "";

		// idproyecto
		$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
		$this->idproyecto->ViewValue = FormatNumber($this->idproyecto->ViewValue, 0, -2, -2, -2);
		$this->idproyecto->ViewCustomAttributes = "";

		// id_producto
		$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
		$this->id_producto->ViewCustomAttributes = "";

		// idinteresado
		$this->idinteresado->LinkCustomAttributes = "";
		$this->idinteresado->HrefValue = "";
		$this->idinteresado->TooltipValue = "";

		// id_usuarioencargado
		$this->id_usuarioencargado->LinkCustomAttributes = "";
		$this->id_usuarioencargado->HrefValue = "";
		$this->id_usuarioencargado->TooltipValue = "";

		// fecha
		$this->fecha->LinkCustomAttributes = "";
		$this->fecha->HrefValue = "";
		$this->fecha->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// cursos
		$this->cursos->LinkCustomAttributes = "";
		$this->cursos->HrefValue = "";
		$this->cursos->TooltipValue = "";

		// categorias
		$this->categorias->LinkCustomAttributes = "";
		$this->categorias->HrefValue = "";
		$this->categorias->TooltipValue = "";

		// nombres
		$this->nombres->LinkCustomAttributes = "";
		$this->nombres->HrefValue = "";
		$this->nombres->TooltipValue = "";

		// apellidos
		$this->apellidos->LinkCustomAttributes = "";
		$this->apellidos->HrefValue = "";
		$this->apellidos->TooltipValue = "";

		// direccion
		$this->direccion->LinkCustomAttributes = "";
		$this->direccion->HrefValue = "";
		$this->direccion->TooltipValue = "";

		// ciudad
		$this->ciudad->LinkCustomAttributes = "";
		$this->ciudad->HrefValue = "";
		$this->ciudad->TooltipValue = "";

		// provincia
		$this->provincia->LinkCustomAttributes = "";
		$this->provincia->HrefValue = "";
		$this->provincia->TooltipValue = "";

		// pais
		$this->pais->LinkCustomAttributes = "";
		$this->pais->HrefValue = "";
		$this->pais->TooltipValue = "";

		// telefono
		$this->telefono->LinkCustomAttributes = "";
		$this->telefono->HrefValue = "";
		$this->telefono->TooltipValue = "";

		// tipo_certificado
		$this->tipo_certificado->LinkCustomAttributes = "";
		$this->tipo_certificado->HrefValue = "";
		$this->tipo_certificado->TooltipValue = "";

		// tipo_pago
		$this->tipo_pago->LinkCustomAttributes = "";
		$this->tipo_pago->HrefValue = "";
		$this->tipo_pago->TooltipValue = "";

		// nombretarjeta
		$this->nombretarjeta->LinkCustomAttributes = "";
		$this->nombretarjeta->HrefValue = "";
		$this->nombretarjeta->TooltipValue = "";

		// numerotarjeta
		$this->numerotarjeta->LinkCustomAttributes = "";
		$this->numerotarjeta->HrefValue = "";
		$this->numerotarjeta->TooltipValue = "";

		// mes
		$this->mes->LinkCustomAttributes = "";
		$this->mes->HrefValue = "";
		$this->mes->TooltipValue = "";

		// anio
		$this->anio->LinkCustomAttributes = "";
		$this->anio->HrefValue = "";
		$this->anio->TooltipValue = "";

		// tipo_tarjeta
		$this->tipo_tarjeta->LinkCustomAttributes = "";
		$this->tipo_tarjeta->HrefValue = "";
		$this->tipo_tarjeta->TooltipValue = "";

		// nombrepaypal
		$this->nombrepaypal->LinkCustomAttributes = "";
		$this->nombrepaypal->HrefValue = "";
		$this->nombrepaypal->TooltipValue = "";

		// montopaypal
		$this->montopaypal->LinkCustomAttributes = "";
		$this->montopaypal->HrefValue = "";
		$this->montopaypal->TooltipValue = "";

		// emailpaypal
		$this->emailpaypal->LinkCustomAttributes = "";
		$this->emailpaypal->HrefValue = "";
		$this->emailpaypal->TooltipValue = "";

		// don
		$this->don->LinkCustomAttributes = "";
		$this->don->HrefValue = "";
		$this->don->TooltipValue = "";

		// tipo_condicion
		$this->tipo_condicion->LinkCustomAttributes = "";
		$this->tipo_condicion->HrefValue = "";
		$this->tipo_condicion->TooltipValue = "";

		// acciones
		$this->acciones->LinkCustomAttributes = "";
		$this->acciones->HrefValue = "";
		$this->acciones->TooltipValue = "";

		// solicitud
		$this->solicitud->LinkCustomAttributes = "";
		$this->solicitud->HrefValue = "";
		$this->solicitud->TooltipValue = "";

		// examen
		$this->examen->LinkCustomAttributes = "";
		$this->examen->HrefValue = "";
		$this->examen->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// tipo
		$this->tipo->LinkCustomAttributes = "";
		$this->tipo->HrefValue = "";
		$this->tipo->TooltipValue = "";

		// codigo_certificado
		$this->codigo_certificado->LinkCustomAttributes = "";
		$this->codigo_certificado->HrefValue = "";
		$this->codigo_certificado->TooltipValue = "";

		// estado_entrega
		$this->estado_entrega->LinkCustomAttributes = "";
		$this->estado_entrega->HrefValue = "";
		$this->estado_entrega->TooltipValue = "";

		// idioma
		$this->idioma->LinkCustomAttributes = "";
		$this->idioma->HrefValue = "";
		$this->idioma->TooltipValue = "";

		// tipo_documento
		$this->tipo_documento->LinkCustomAttributes = "";
		$this->tipo_documento->HrefValue = "";
		$this->tipo_documento->TooltipValue = "";

		// n_documento
		$this->n_documento->LinkCustomAttributes = "";
		$this->n_documento->HrefValue = "";
		$this->n_documento->TooltipValue = "";

		// condicion1
		$this->condicion1->LinkCustomAttributes = "";
		$this->condicion1->HrefValue = "";
		$this->condicion1->TooltipValue = "";

		// condicion2
		$this->condicion2->LinkCustomAttributes = "";
		$this->condicion2->HrefValue = "";
		$this->condicion2->TooltipValue = "";

		// consulta
		$this->consulta->LinkCustomAttributes = "";
		$this->consulta->HrefValue = "";
		$this->consulta->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// codlogin
		$this->codlogin->LinkCustomAttributes = "";
		$this->codlogin->HrefValue = "";
		$this->codlogin->TooltipValue = "";

		// idproyecto
		$this->idproyecto->LinkCustomAttributes = "";
		$this->idproyecto->HrefValue = "";
		$this->idproyecto->TooltipValue = "";

		// id_producto
		$this->id_producto->LinkCustomAttributes = "";
		$this->id_producto->HrefValue = "";
		$this->id_producto->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idinteresado
		$this->idinteresado->EditAttrs["class"] = "form-control";
		$this->idinteresado->EditCustomAttributes = "";
		$this->idinteresado->EditValue = $this->idinteresado->CurrentValue;
		$this->idinteresado->ViewCustomAttributes = "";

		// id_usuarioencargado
		$this->id_usuarioencargado->EditAttrs["class"] = "form-control";
		$this->id_usuarioencargado->EditCustomAttributes = "";
		$this->id_usuarioencargado->EditValue = $this->id_usuarioencargado->CurrentValue;
		$this->id_usuarioencargado->PlaceHolder = RemoveHtml($this->id_usuarioencargado->caption());

		// fecha
		$this->fecha->EditAttrs["class"] = "form-control";
		$this->fecha->EditCustomAttributes = "";
		$this->fecha->EditValue = FormatDateTime($this->fecha->CurrentValue, 8);
		$this->fecha->PlaceHolder = RemoveHtml($this->fecha->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (!$this->_email->Raw)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// cursos
		$this->cursos->EditAttrs["class"] = "form-control";
		$this->cursos->EditCustomAttributes = "";
		$this->cursos->EditValue = $this->cursos->CurrentValue;
		$this->cursos->PlaceHolder = RemoveHtml($this->cursos->caption());

		// categorias
		$this->categorias->EditAttrs["class"] = "form-control";
		$this->categorias->EditCustomAttributes = "";
		$this->categorias->EditValue = $this->categorias->CurrentValue;
		$this->categorias->PlaceHolder = RemoveHtml($this->categorias->caption());

		// nombres
		$this->nombres->EditAttrs["class"] = "form-control";
		$this->nombres->EditCustomAttributes = "";
		if (!$this->nombres->Raw)
			$this->nombres->CurrentValue = HtmlDecode($this->nombres->CurrentValue);
		$this->nombres->EditValue = $this->nombres->CurrentValue;
		$this->nombres->PlaceHolder = RemoveHtml($this->nombres->caption());

		// apellidos
		$this->apellidos->EditAttrs["class"] = "form-control";
		$this->apellidos->EditCustomAttributes = "";
		if (!$this->apellidos->Raw)
			$this->apellidos->CurrentValue = HtmlDecode($this->apellidos->CurrentValue);
		$this->apellidos->EditValue = $this->apellidos->CurrentValue;
		$this->apellidos->PlaceHolder = RemoveHtml($this->apellidos->caption());

		// direccion
		$this->direccion->EditAttrs["class"] = "form-control";
		$this->direccion->EditCustomAttributes = "";
		if (!$this->direccion->Raw)
			$this->direccion->CurrentValue = HtmlDecode($this->direccion->CurrentValue);
		$this->direccion->EditValue = $this->direccion->CurrentValue;
		$this->direccion->PlaceHolder = RemoveHtml($this->direccion->caption());

		// ciudad
		$this->ciudad->EditAttrs["class"] = "form-control";
		$this->ciudad->EditCustomAttributes = "";
		if (!$this->ciudad->Raw)
			$this->ciudad->CurrentValue = HtmlDecode($this->ciudad->CurrentValue);
		$this->ciudad->EditValue = $this->ciudad->CurrentValue;
		$this->ciudad->PlaceHolder = RemoveHtml($this->ciudad->caption());

		// provincia
		$this->provincia->EditAttrs["class"] = "form-control";
		$this->provincia->EditCustomAttributes = "";
		if (!$this->provincia->Raw)
			$this->provincia->CurrentValue = HtmlDecode($this->provincia->CurrentValue);
		$this->provincia->EditValue = $this->provincia->CurrentValue;
		$this->provincia->PlaceHolder = RemoveHtml($this->provincia->caption());

		// pais
		$this->pais->EditAttrs["class"] = "form-control";
		$this->pais->EditCustomAttributes = "";
		if (!$this->pais->Raw)
			$this->pais->CurrentValue = HtmlDecode($this->pais->CurrentValue);
		$this->pais->EditValue = $this->pais->CurrentValue;
		$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

		// telefono
		$this->telefono->EditAttrs["class"] = "form-control";
		$this->telefono->EditCustomAttributes = "";
		if (!$this->telefono->Raw)
			$this->telefono->CurrentValue = HtmlDecode($this->telefono->CurrentValue);
		$this->telefono->EditValue = $this->telefono->CurrentValue;
		$this->telefono->PlaceHolder = RemoveHtml($this->telefono->caption());

		// tipo_certificado
		$this->tipo_certificado->EditAttrs["class"] = "form-control";
		$this->tipo_certificado->EditCustomAttributes = "";
		$this->tipo_certificado->EditValue = $this->tipo_certificado->CurrentValue;
		$this->tipo_certificado->PlaceHolder = RemoveHtml($this->tipo_certificado->caption());

		// tipo_pago
		$this->tipo_pago->EditAttrs["class"] = "form-control";
		$this->tipo_pago->EditCustomAttributes = "";
		$this->tipo_pago->EditValue = $this->tipo_pago->CurrentValue;
		$this->tipo_pago->PlaceHolder = RemoveHtml($this->tipo_pago->caption());

		// nombretarjeta
		$this->nombretarjeta->EditAttrs["class"] = "form-control";
		$this->nombretarjeta->EditCustomAttributes = "";
		if (!$this->nombretarjeta->Raw)
			$this->nombretarjeta->CurrentValue = HtmlDecode($this->nombretarjeta->CurrentValue);
		$this->nombretarjeta->EditValue = $this->nombretarjeta->CurrentValue;
		$this->nombretarjeta->PlaceHolder = RemoveHtml($this->nombretarjeta->caption());

		// numerotarjeta
		$this->numerotarjeta->EditAttrs["class"] = "form-control";
		$this->numerotarjeta->EditCustomAttributes = "";
		if (!$this->numerotarjeta->Raw)
			$this->numerotarjeta->CurrentValue = HtmlDecode($this->numerotarjeta->CurrentValue);
		$this->numerotarjeta->EditValue = $this->numerotarjeta->CurrentValue;
		$this->numerotarjeta->PlaceHolder = RemoveHtml($this->numerotarjeta->caption());

		// mes
		$this->mes->EditAttrs["class"] = "form-control";
		$this->mes->EditCustomAttributes = "";
		if (!$this->mes->Raw)
			$this->mes->CurrentValue = HtmlDecode($this->mes->CurrentValue);
		$this->mes->EditValue = $this->mes->CurrentValue;
		$this->mes->PlaceHolder = RemoveHtml($this->mes->caption());

		// anio
		$this->anio->EditAttrs["class"] = "form-control";
		$this->anio->EditCustomAttributes = "";
		if (!$this->anio->Raw)
			$this->anio->CurrentValue = HtmlDecode($this->anio->CurrentValue);
		$this->anio->EditValue = $this->anio->CurrentValue;
		$this->anio->PlaceHolder = RemoveHtml($this->anio->caption());

		// tipo_tarjeta
		$this->tipo_tarjeta->EditAttrs["class"] = "form-control";
		$this->tipo_tarjeta->EditCustomAttributes = "";
		if (!$this->tipo_tarjeta->Raw)
			$this->tipo_tarjeta->CurrentValue = HtmlDecode($this->tipo_tarjeta->CurrentValue);
		$this->tipo_tarjeta->EditValue = $this->tipo_tarjeta->CurrentValue;
		$this->tipo_tarjeta->PlaceHolder = RemoveHtml($this->tipo_tarjeta->caption());

		// nombrepaypal
		$this->nombrepaypal->EditAttrs["class"] = "form-control";
		$this->nombrepaypal->EditCustomAttributes = "";
		if (!$this->nombrepaypal->Raw)
			$this->nombrepaypal->CurrentValue = HtmlDecode($this->nombrepaypal->CurrentValue);
		$this->nombrepaypal->EditValue = $this->nombrepaypal->CurrentValue;
		$this->nombrepaypal->PlaceHolder = RemoveHtml($this->nombrepaypal->caption());

		// montopaypal
		$this->montopaypal->EditAttrs["class"] = "form-control";
		$this->montopaypal->EditCustomAttributes = "";
		if (!$this->montopaypal->Raw)
			$this->montopaypal->CurrentValue = HtmlDecode($this->montopaypal->CurrentValue);
		$this->montopaypal->EditValue = $this->montopaypal->CurrentValue;
		$this->montopaypal->PlaceHolder = RemoveHtml($this->montopaypal->caption());

		// emailpaypal
		$this->emailpaypal->EditAttrs["class"] = "form-control";
		$this->emailpaypal->EditCustomAttributes = "";
		if (!$this->emailpaypal->Raw)
			$this->emailpaypal->CurrentValue = HtmlDecode($this->emailpaypal->CurrentValue);
		$this->emailpaypal->EditValue = $this->emailpaypal->CurrentValue;
		$this->emailpaypal->PlaceHolder = RemoveHtml($this->emailpaypal->caption());

		// don
		$this->don->EditAttrs["class"] = "form-control";
		$this->don->EditCustomAttributes = "";
		if (!$this->don->Raw)
			$this->don->CurrentValue = HtmlDecode($this->don->CurrentValue);
		$this->don->EditValue = $this->don->CurrentValue;
		$this->don->PlaceHolder = RemoveHtml($this->don->caption());

		// tipo_condicion
		$this->tipo_condicion->EditAttrs["class"] = "form-control";
		$this->tipo_condicion->EditCustomAttributes = "";
		$this->tipo_condicion->EditValue = $this->tipo_condicion->CurrentValue;
		$this->tipo_condicion->PlaceHolder = RemoveHtml($this->tipo_condicion->caption());

		// acciones
		$this->acciones->EditAttrs["class"] = "form-control";
		$this->acciones->EditCustomAttributes = "";
		$this->acciones->EditValue = $this->acciones->CurrentValue;
		$this->acciones->PlaceHolder = RemoveHtml($this->acciones->caption());

		// solicitud
		$this->solicitud->EditAttrs["class"] = "form-control";
		$this->solicitud->EditCustomAttributes = "";
		$this->solicitud->EditValue = $this->solicitud->CurrentValue;
		$this->solicitud->PlaceHolder = RemoveHtml($this->solicitud->caption());

		// examen
		$this->examen->EditAttrs["class"] = "form-control";
		$this->examen->EditCustomAttributes = "";
		$this->examen->EditValue = $this->examen->CurrentValue;
		$this->examen->PlaceHolder = RemoveHtml($this->examen->caption());
		if (strval($this->examen->EditValue) != "" && is_numeric($this->examen->EditValue))
			$this->examen->EditValue = FormatNumber($this->examen->EditValue, -2, -2, -2, -2);
		

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// tipo
		$this->tipo->EditAttrs["class"] = "form-control";
		$this->tipo->EditCustomAttributes = "";
		$this->tipo->EditValue = $this->tipo->CurrentValue;
		$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

		// codigo_certificado
		$this->codigo_certificado->EditAttrs["class"] = "form-control";
		$this->codigo_certificado->EditCustomAttributes = "";
		if (!$this->codigo_certificado->Raw)
			$this->codigo_certificado->CurrentValue = HtmlDecode($this->codigo_certificado->CurrentValue);
		$this->codigo_certificado->EditValue = $this->codigo_certificado->CurrentValue;
		$this->codigo_certificado->PlaceHolder = RemoveHtml($this->codigo_certificado->caption());

		// estado_entrega
		$this->estado_entrega->EditAttrs["class"] = "form-control";
		$this->estado_entrega->EditCustomAttributes = "";
		$this->estado_entrega->EditValue = $this->estado_entrega->CurrentValue;
		$this->estado_entrega->PlaceHolder = RemoveHtml($this->estado_entrega->caption());

		// idioma
		$this->idioma->EditAttrs["class"] = "form-control";
		$this->idioma->EditCustomAttributes = "";
		$this->idioma->EditValue = $this->idioma->CurrentValue;
		$this->idioma->PlaceHolder = RemoveHtml($this->idioma->caption());

		// tipo_documento
		$this->tipo_documento->EditAttrs["class"] = "form-control";
		$this->tipo_documento->EditCustomAttributes = "";
		$this->tipo_documento->EditValue = $this->tipo_documento->CurrentValue;
		$this->tipo_documento->PlaceHolder = RemoveHtml($this->tipo_documento->caption());

		// n_documento
		$this->n_documento->EditAttrs["class"] = "form-control";
		$this->n_documento->EditCustomAttributes = "";
		$this->n_documento->EditValue = $this->n_documento->CurrentValue;
		$this->n_documento->PlaceHolder = RemoveHtml($this->n_documento->caption());

		// condicion1
		$this->condicion1->EditAttrs["class"] = "form-control";
		$this->condicion1->EditCustomAttributes = "";
		$this->condicion1->EditValue = $this->condicion1->CurrentValue;
		$this->condicion1->PlaceHolder = RemoveHtml($this->condicion1->caption());

		// condicion2
		$this->condicion2->EditAttrs["class"] = "form-control";
		$this->condicion2->EditCustomAttributes = "";
		$this->condicion2->EditValue = $this->condicion2->CurrentValue;
		$this->condicion2->PlaceHolder = RemoveHtml($this->condicion2->caption());

		// consulta
		$this->consulta->EditAttrs["class"] = "form-control";
		$this->consulta->EditCustomAttributes = "";
		if (!$this->consulta->Raw)
			$this->consulta->CurrentValue = HtmlDecode($this->consulta->CurrentValue);
		$this->consulta->EditValue = $this->consulta->CurrentValue;
		$this->consulta->PlaceHolder = RemoveHtml($this->consulta->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// codlogin
		$this->codlogin->EditAttrs["class"] = "form-control";
		$this->codlogin->EditCustomAttributes = "";
		if (!$this->codlogin->Raw)
			$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
		$this->codlogin->EditValue = $this->codlogin->CurrentValue;
		$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

		// idproyecto
		$this->idproyecto->EditAttrs["class"] = "form-control";
		$this->idproyecto->EditCustomAttributes = "";
		$this->idproyecto->EditValue = $this->idproyecto->CurrentValue;
		$this->idproyecto->PlaceHolder = RemoveHtml($this->idproyecto->caption());

		// id_producto
		$this->id_producto->EditAttrs["class"] = "form-control";
		$this->id_producto->EditCustomAttributes = "";
		$this->id_producto->EditValue = $this->id_producto->CurrentValue;
		$this->id_producto->PlaceHolder = RemoveHtml($this->id_producto->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idinteresado);
					$doc->exportCaption($this->id_usuarioencargado);
					$doc->exportCaption($this->fecha);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->cursos);
					$doc->exportCaption($this->categorias);
					$doc->exportCaption($this->nombres);
					$doc->exportCaption($this->apellidos);
					$doc->exportCaption($this->direccion);
					$doc->exportCaption($this->ciudad);
					$doc->exportCaption($this->provincia);
					$doc->exportCaption($this->pais);
					$doc->exportCaption($this->telefono);
					$doc->exportCaption($this->tipo_certificado);
					$doc->exportCaption($this->tipo_pago);
					$doc->exportCaption($this->nombretarjeta);
					$doc->exportCaption($this->numerotarjeta);
					$doc->exportCaption($this->mes);
					$doc->exportCaption($this->anio);
					$doc->exportCaption($this->tipo_tarjeta);
					$doc->exportCaption($this->nombrepaypal);
					$doc->exportCaption($this->montopaypal);
					$doc->exportCaption($this->emailpaypal);
					$doc->exportCaption($this->don);
					$doc->exportCaption($this->tipo_condicion);
					$doc->exportCaption($this->acciones);
					$doc->exportCaption($this->solicitud);
					$doc->exportCaption($this->examen);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->codigo_certificado);
					$doc->exportCaption($this->estado_entrega);
					$doc->exportCaption($this->idioma);
					$doc->exportCaption($this->tipo_documento);
					$doc->exportCaption($this->n_documento);
					$doc->exportCaption($this->condicion1);
					$doc->exportCaption($this->condicion2);
					$doc->exportCaption($this->consulta);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->idproyecto);
					$doc->exportCaption($this->id_producto);
				} else {
					$doc->exportCaption($this->idinteresado);
					$doc->exportCaption($this->id_usuarioencargado);
					$doc->exportCaption($this->fecha);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->cursos);
					$doc->exportCaption($this->categorias);
					$doc->exportCaption($this->nombres);
					$doc->exportCaption($this->apellidos);
					$doc->exportCaption($this->direccion);
					$doc->exportCaption($this->ciudad);
					$doc->exportCaption($this->provincia);
					$doc->exportCaption($this->pais);
					$doc->exportCaption($this->telefono);
					$doc->exportCaption($this->tipo_certificado);
					$doc->exportCaption($this->tipo_pago);
					$doc->exportCaption($this->nombretarjeta);
					$doc->exportCaption($this->numerotarjeta);
					$doc->exportCaption($this->mes);
					$doc->exportCaption($this->anio);
					$doc->exportCaption($this->tipo_tarjeta);
					$doc->exportCaption($this->nombrepaypal);
					$doc->exportCaption($this->montopaypal);
					$doc->exportCaption($this->emailpaypal);
					$doc->exportCaption($this->don);
					$doc->exportCaption($this->tipo_condicion);
					$doc->exportCaption($this->acciones);
					$doc->exportCaption($this->solicitud);
					$doc->exportCaption($this->examen);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->codigo_certificado);
					$doc->exportCaption($this->estado_entrega);
					$doc->exportCaption($this->idioma);
					$doc->exportCaption($this->tipo_documento);
					$doc->exportCaption($this->n_documento);
					$doc->exportCaption($this->condicion1);
					$doc->exportCaption($this->condicion2);
					$doc->exportCaption($this->consulta);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->idproyecto);
					$doc->exportCaption($this->id_producto);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idinteresado);
						$doc->exportField($this->id_usuarioencargado);
						$doc->exportField($this->fecha);
						$doc->exportField($this->_email);
						$doc->exportField($this->cursos);
						$doc->exportField($this->categorias);
						$doc->exportField($this->nombres);
						$doc->exportField($this->apellidos);
						$doc->exportField($this->direccion);
						$doc->exportField($this->ciudad);
						$doc->exportField($this->provincia);
						$doc->exportField($this->pais);
						$doc->exportField($this->telefono);
						$doc->exportField($this->tipo_certificado);
						$doc->exportField($this->tipo_pago);
						$doc->exportField($this->nombretarjeta);
						$doc->exportField($this->numerotarjeta);
						$doc->exportField($this->mes);
						$doc->exportField($this->anio);
						$doc->exportField($this->tipo_tarjeta);
						$doc->exportField($this->nombrepaypal);
						$doc->exportField($this->montopaypal);
						$doc->exportField($this->emailpaypal);
						$doc->exportField($this->don);
						$doc->exportField($this->tipo_condicion);
						$doc->exportField($this->acciones);
						$doc->exportField($this->solicitud);
						$doc->exportField($this->examen);
						$doc->exportField($this->estado);
						$doc->exportField($this->tipo);
						$doc->exportField($this->codigo_certificado);
						$doc->exportField($this->estado_entrega);
						$doc->exportField($this->idioma);
						$doc->exportField($this->tipo_documento);
						$doc->exportField($this->n_documento);
						$doc->exportField($this->condicion1);
						$doc->exportField($this->condicion2);
						$doc->exportField($this->consulta);
						$doc->exportField($this->status);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->idproyecto);
						$doc->exportField($this->id_producto);
					} else {
						$doc->exportField($this->idinteresado);
						$doc->exportField($this->id_usuarioencargado);
						$doc->exportField($this->fecha);
						$doc->exportField($this->_email);
						$doc->exportField($this->cursos);
						$doc->exportField($this->categorias);
						$doc->exportField($this->nombres);
						$doc->exportField($this->apellidos);
						$doc->exportField($this->direccion);
						$doc->exportField($this->ciudad);
						$doc->exportField($this->provincia);
						$doc->exportField($this->pais);
						$doc->exportField($this->telefono);
						$doc->exportField($this->tipo_certificado);
						$doc->exportField($this->tipo_pago);
						$doc->exportField($this->nombretarjeta);
						$doc->exportField($this->numerotarjeta);
						$doc->exportField($this->mes);
						$doc->exportField($this->anio);
						$doc->exportField($this->tipo_tarjeta);
						$doc->exportField($this->nombrepaypal);
						$doc->exportField($this->montopaypal);
						$doc->exportField($this->emailpaypal);
						$doc->exportField($this->don);
						$doc->exportField($this->tipo_condicion);
						$doc->exportField($this->acciones);
						$doc->exportField($this->solicitud);
						$doc->exportField($this->examen);
						$doc->exportField($this->estado);
						$doc->exportField($this->tipo);
						$doc->exportField($this->codigo_certificado);
						$doc->exportField($this->estado_entrega);
						$doc->exportField($this->idioma);
						$doc->exportField($this->tipo_documento);
						$doc->exportField($this->n_documento);
						$doc->exportField($this->condicion1);
						$doc->exportField($this->condicion2);
						$doc->exportField($this->consulta);
						$doc->exportField($this->status);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->idproyecto);
						$doc->exportField($this->id_producto);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>