<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$categories_list = new categories_list();

// Run the page
$categories_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$categories_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$categories_list->isExport()) { ?>
<script>
var fcategorieslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fcategorieslist = currentForm = new ew.Form("fcategorieslist", "list");
	fcategorieslist.formKeyCountName = '<?php echo $categories_list->FormKeyCountName ?>';
	loadjs.done("fcategorieslist");
});
var fcategorieslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fcategorieslistsrch = currentSearchForm = new ew.Form("fcategorieslistsrch");

	// Dynamic selection lists
	// Filters

	fcategorieslistsrch.filterList = <?php echo $categories_list->getFilterList() ?>;
	loadjs.done("fcategorieslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$categories_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($categories_list->TotalRecords > 0 && $categories_list->ExportOptions->visible()) { ?>
<?php $categories_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($categories_list->ImportOptions->visible()) { ?>
<?php $categories_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($categories_list->SearchOptions->visible()) { ?>
<?php $categories_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($categories_list->FilterOptions->visible()) { ?>
<?php $categories_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$categories_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$categories_list->isExport() && !$categories->CurrentAction) { ?>
<form name="fcategorieslistsrch" id="fcategorieslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fcategorieslistsrch-search-panel" class="<?php echo $categories_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="categories">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $categories_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($categories_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($categories_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $categories_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($categories_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($categories_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($categories_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($categories_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $categories_list->showPageHeader(); ?>
<?php
$categories_list->showMessage();
?>
<?php if ($categories_list->TotalRecords > 0 || $categories->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($categories_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> categories">
<form name="fcategorieslist" id="fcategorieslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="categories">
<div id="gmp_categories" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($categories_list->TotalRecords > 0 || $categories_list->isGridEdit()) { ?>
<table id="tbl_categorieslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$categories->RowType = ROWTYPE_HEADER;

// Render list options
$categories_list->renderListOptions();

// Render list options (header, left)
$categories_list->ListOptions->render("header", "left");
?>
<?php if ($categories_list->id->Visible) { // id ?>
	<?php if ($categories_list->SortUrl($categories_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $categories_list->id->headerCellClass() ?>"><div id="elh_categories_id" class="categories_id"><div class="ew-table-header-caption"><?php echo $categories_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $categories_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->id) ?>', 1);"><div id="elh_categories_id" class="categories_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($categories_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($categories_list->courses_id->Visible) { // courses_id ?>
	<?php if ($categories_list->SortUrl($categories_list->courses_id) == "") { ?>
		<th data-name="courses_id" class="<?php echo $categories_list->courses_id->headerCellClass() ?>"><div id="elh_categories_courses_id" class="categories_courses_id"><div class="ew-table-header-caption"><?php echo $categories_list->courses_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="courses_id" class="<?php echo $categories_list->courses_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->courses_id) ?>', 1);"><div id="elh_categories_courses_id" class="categories_courses_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->courses_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($categories_list->courses_id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->courses_id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($categories_list->category_name->Visible) { // category_name ?>
	<?php if ($categories_list->SortUrl($categories_list->category_name) == "") { ?>
		<th data-name="category_name" class="<?php echo $categories_list->category_name->headerCellClass() ?>"><div id="elh_categories_category_name" class="categories_category_name"><div class="ew-table-header-caption"><?php echo $categories_list->category_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category_name" class="<?php echo $categories_list->category_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->category_name) ?>', 1);"><div id="elh_categories_category_name" class="categories_category_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->category_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($categories_list->category_name->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->category_name->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($categories_list->description->Visible) { // description ?>
	<?php if ($categories_list->SortUrl($categories_list->description) == "") { ?>
		<th data-name="description" class="<?php echo $categories_list->description->headerCellClass() ?>"><div id="elh_categories_description" class="categories_description"><div class="ew-table-header-caption"><?php echo $categories_list->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $categories_list->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->description) ?>', 1);"><div id="elh_categories_description" class="categories_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($categories_list->description->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->description->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($categories_list->time->Visible) { // time ?>
	<?php if ($categories_list->SortUrl($categories_list->time) == "") { ?>
		<th data-name="time" class="<?php echo $categories_list->time->headerCellClass() ?>"><div id="elh_categories_time" class="categories_time"><div class="ew-table-header-caption"><?php echo $categories_list->time->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="time" class="<?php echo $categories_list->time->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->time) ?>', 1);"><div id="elh_categories_time" class="categories_time">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->time->caption() ?></span><span class="ew-table-header-sort"><?php if ($categories_list->time->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->time->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($categories_list->estado->Visible) { // estado ?>
	<?php if ($categories_list->SortUrl($categories_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $categories_list->estado->headerCellClass() ?>"><div id="elh_categories_estado" class="categories_estado"><div class="ew-table-header-caption"><?php echo $categories_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $categories_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $categories_list->SortUrl($categories_list->estado) ?>', 1);"><div id="elh_categories_estado" class="categories_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $categories_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($categories_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($categories_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$categories_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($categories_list->ExportAll && $categories_list->isExport()) {
	$categories_list->StopRecord = $categories_list->TotalRecords;
} else {

	// Set the last record to display
	if ($categories_list->TotalRecords > $categories_list->StartRecord + $categories_list->DisplayRecords - 1)
		$categories_list->StopRecord = $categories_list->StartRecord + $categories_list->DisplayRecords - 1;
	else
		$categories_list->StopRecord = $categories_list->TotalRecords;
}
$categories_list->RecordCount = $categories_list->StartRecord - 1;
if ($categories_list->Recordset && !$categories_list->Recordset->EOF) {
	$categories_list->Recordset->moveFirst();
	$selectLimit = $categories_list->UseSelectLimit;
	if (!$selectLimit && $categories_list->StartRecord > 1)
		$categories_list->Recordset->move($categories_list->StartRecord - 1);
} elseif (!$categories->AllowAddDeleteRow && $categories_list->StopRecord == 0) {
	$categories_list->StopRecord = $categories->GridAddRowCount;
}

// Initialize aggregate
$categories->RowType = ROWTYPE_AGGREGATEINIT;
$categories->resetAttributes();
$categories_list->renderRow();
while ($categories_list->RecordCount < $categories_list->StopRecord) {
	$categories_list->RecordCount++;
	if ($categories_list->RecordCount >= $categories_list->StartRecord) {
		$categories_list->RowCount++;

		// Set up key count
		$categories_list->KeyCount = $categories_list->RowIndex;

		// Init row class and style
		$categories->resetAttributes();
		$categories->CssClass = "";
		if ($categories_list->isGridAdd()) {
		} else {
			$categories_list->loadRowValues($categories_list->Recordset); // Load row values
		}
		$categories->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$categories->RowAttrs->merge(["data-rowindex" => $categories_list->RowCount, "id" => "r" . $categories_list->RowCount . "_categories", "data-rowtype" => $categories->RowType]);

		// Render row
		$categories_list->renderRow();

		// Render list options
		$categories_list->renderListOptions();
?>
	<tr <?php echo $categories->rowAttributes() ?>>
<?php

// Render list options (body, left)
$categories_list->ListOptions->render("body", "left", $categories_list->RowCount);
?>
	<?php if ($categories_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $categories_list->id->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_id" class="categories_id">
<span<?php echo $categories_list->id->viewAttributes() ?>><?php echo $categories_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($categories_list->courses_id->Visible) { // courses_id ?>
		<td data-name="courses_id" <?php echo $categories_list->courses_id->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_courses_id" class="categories_courses_id">
<span<?php echo $categories_list->courses_id->viewAttributes() ?>><?php echo $categories_list->courses_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($categories_list->category_name->Visible) { // category_name ?>
		<td data-name="category_name" <?php echo $categories_list->category_name->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_category_name" class="categories_category_name">
<span<?php echo $categories_list->category_name->viewAttributes() ?>><?php echo $categories_list->category_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($categories_list->description->Visible) { // description ?>
		<td data-name="description" <?php echo $categories_list->description->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_description" class="categories_description">
<span<?php echo $categories_list->description->viewAttributes() ?>><?php echo $categories_list->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($categories_list->time->Visible) { // time ?>
		<td data-name="time" <?php echo $categories_list->time->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_time" class="categories_time">
<span<?php echo $categories_list->time->viewAttributes() ?>><?php echo $categories_list->time->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($categories_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $categories_list->estado->cellAttributes() ?>>
<span id="el<?php echo $categories_list->RowCount ?>_categories_estado" class="categories_estado">
<span<?php echo $categories_list->estado->viewAttributes() ?>><?php echo $categories_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$categories_list->ListOptions->render("body", "right", $categories_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$categories_list->isGridAdd())
		$categories_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$categories->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($categories_list->Recordset)
	$categories_list->Recordset->Close();
?>
<?php if (!$categories_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$categories_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $categories_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $categories_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($categories_list->TotalRecords == 0 && !$categories->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $categories_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$categories_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$categories_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$categories_list->terminate();
?>